/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.buildparam;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.acct.buildparam.AssistWrap;
import kd.fi.gl.acct.buildparam.BuildParamMapContext;
import kd.fi.gl.acct.param.AcctParam;
import kd.fi.gl.acct.param.DetailAcctParam;
import kd.fi.gl.acct.param.ReClassNumberIDParam;

public class BuildAcctParams {
    private static final Log log = LogFactory.getLog(BuildAcctParams.class);

    public static void action(BuildParamMapContext ctx) {
        Map<Long, Map<String, Set<Object>>> assistToAcctMap = ctx.getAssistToAcctMap();
        ReClassNumberIDParam numberIDParam = ctx.getNumberIDParam();
        Set<AssistWrap> singleAssistMapCol = ctx.getSingleAssistMapCol();
        for (Map.Entry<Long, Map<String, Set<Object>>> acttEntry : assistToAcctMap.entrySet()) {
            HashSet<AssistWrap> assistSet = new HashSet<AssistWrap>(8);
            long acctId = acttEntry.getKey();
            Set<Long> leafAcctIds = ctx.getAcctToRCAcctIdsMap().get(acctId);
            if (leafAcctIds == null || leafAcctIds.isEmpty()) continue;
            Set<String> numberSet = BuildAcctParams.acctIdsToNumbers(leafAcctIds, numberIDParam);
            Map<String, Set<Object>> assistMap = acttEntry.getValue();
            if (null == assistMap || assistMap.size() == 0 || null == singleAssistMapCol || singleAssistMapCol.size() == 0) {
                assistSet.add(AssistWrap.getEmptyInstance());
            } else {
                assistSet.addAll(singleAssistMapCol);
            }
            if (DebugTrace.enable()) {
                log.info("acctdebug DetailAcctParam_constructor instance times: " + DetailAcctParam.INIT_COUNT.get());
                log.info("acctdebug DetailAcctParam_constructor assistSet size: " + assistSet.size());
            }
            AcctParam acctParam = new AcctParam(numberSet, assistSet);
            ctx.getAcctParams().add(acctParam);
        }
    }

    private static Set<String> acctIdsToNumbers(Set<Long> acctIds, ReClassNumberIDParam numberIDParam) {
        Map<Long, String> acctToNumberMap = numberIDParam.getAcctToNumberMap();
        HashSet<String> numberSet = new HashSet<String>(acctToNumberMap.size());
        for (Long acctId : acctIds) {
            numberSet.add(acctToNumberMap.get(acctId));
        }
        return numberSet;
    }
}

