/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.buildparam;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.fi.gl.acct.buildparam.BuildParamMapContext;
import kd.fi.gl.acct.param.ReClassNumberIDParam;

public class CombinationLeafAcctToStyle {
    public static void action(BuildParamMapContext ctx) {
        Map<Long, Map<String, Set<Object>>> assistToAcctMap = ctx.getAssistToAcctMap();
        ReClassNumberIDParam numberIDParam = ctx.getNumberIDParam();
        Map<Long, String> acctToDcMap = numberIDParam.getAcctMasterToDcMap();
        for (Map.Entry<Long, Map<String, Set<Object>>> acttEntry : assistToAcctMap.entrySet()) {
            long acctId = acttEntry.getKey();
            Set<Long> leafAcctIds = ctx.getAcctToRCAcctIdsMap().get(acctId);
            if (leafAcctIds == null || leafAcctIds.isEmpty()) continue;
            ctx.getDcSet().add(acctToDcMap.get(acctId));
            Set<String> numberSet = CombinationLeafAcctToStyle.acctIdsToNumbers(leafAcctIds, numberIDParam);
            int assistStyle = ctx.getAcctToAssistStyleMap().get(acctId);
            for (String number : numberSet) {
                ctx.getLeafAcctToStyleMap().put(number, assistStyle);
            }
            Map<String, Set<Object>> assistMap = acttEntry.getValue();
            HashSet<String> flexs = new HashSet<String>();
            for (Map.Entry<String, Set<Object>> assistEtnry : assistMap.entrySet()) {
                String flex = assistEtnry.getKey();
                Set<Object> vals = assistEtnry.getValue();
                if (vals == null || vals.size() <= 0) continue;
                flexs.add(flex);
            }
            ctx.getValFlexsSet().add(flexs);
        }
    }

    private static Set<String> acctIdsToNumbers(Set<Long> acctIds, ReClassNumberIDParam numberIDParam) {
        Map<Long, String> acctToNumberMap = numberIDParam.getAcctToNumberMap();
        HashSet<String> numberSet = new HashSet<String>(acctToNumberMap.size());
        for (Long acctId : acctIds) {
            numberSet.add(acctToNumberMap.get(acctId));
        }
        return numberSet;
    }
}

