/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.context;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ThreadLocals;
import kd.fi.gl.acct.buildparam.AssistWrap;

public class AcctKeyObject {
    private static final Log log = LogFactory.getLog(AcctKeyObject.class);
    private static final String _CACHE_KEY = "fi.gl.acct.acctkeyobject.cache";
    public static ThreadLocal<Integer> INIT_COUNT = ThreadLocals.create((Object)0);
    public static ThreadLocal<Integer> HIT_TIMES = ThreadLocals.create((Object)0);
    private Long currencyId;
    private AssistWrap assistGroup;
    private int hashcode = 0;
    private static final int MAX_KEY = 50000;

    public AcctKeyObject(Long currencyId, AssistWrap assistGroup) {
        this.currencyId = currencyId;
        this.assistGroup = assistGroup;
        this.hashcode = AcctKeyObject.calcHashCode(currencyId, assistGroup);
    }

    private static int calcHashCode(Long currencyId, AssistWrap assistGroup) {
        return Objects.hash(currencyId, assistGroup.hashCode());
    }

    public int hashCode() {
        return this.hashcode;
    }

    public static AcctKeyObject retrievalFromCacheOrBuild(Long currencyId, AssistWrap assistGroup) {
        int hashCode;
        Map _keyCache = (Map)ThreadCache.get((Object)_CACHE_KEY, () -> new HashMap(50000), (boolean)true);
        LinkedList<AcctKeyObject> candiates = (LinkedList<AcctKeyObject>)_keyCache.get(hashCode = AcctKeyObject.calcHashCode(currencyId, assistGroup));
        if (null == candiates) {
            candiates = new LinkedList<AcctKeyObject>();
            _keyCache.put(hashCode, candiates);
        }
        if (candiates.size() > 0) {
            for (int i = 0; i < candiates.size(); ++i) {
                AcctKeyObject value = (AcctKeyObject)candiates.get(i);
                if (!AcctKeyObject.equals(value, currencyId, assistGroup)) continue;
                HIT_TIMES.set(HIT_TIMES.get() + 1);
                return value;
            }
        }
        AcctKeyObject key = new AcctKeyObject(currencyId, assistGroup);
        candiates.add(key);
        if (_keyCache.size() > 50000) {
            _keyCache.clear();
            log.error("debug_error: clear cache");
        }
        INIT_COUNT.set(INIT_COUNT.get() + 1);
        return key;
    }

    public static void clear() {
        Map _keyCache = (Map)ThreadCache.get((Object)_CACHE_KEY, () -> new HashMap(50000), (boolean)true);
        if (null != _keyCache) {
            _keyCache.entrySet().forEach(x -> ((List)x.getValue()).clear());
            _keyCache.clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcctKeyObject that = (AcctKeyObject)o;
        return AcctKeyObject.equals(this, that.currencyId, that.assistGroup);
    }

    public static boolean equals(AcctKeyObject keyObject, Long currencyId, AssistWrap assistGroup) {
        return Objects.equals(keyObject.currencyId, currencyId) && keyObject.assistGroup.hashCode() == assistGroup.hashCode() && Objects.equals(keyObject.assistGroup, assistGroup);
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public AssistWrap getAssistGroup() {
        return this.assistGroup;
    }

    public String toString() {
        return "AcctKeyObject{currencyId=" + this.currencyId + ", assistGroup=" + this.assistGroup.toString() + '}';
    }
}

