/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.context;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ThreadLocals;

public class AssistKeyObject {
    private static final Log log = LogFactory.getLog(AssistKeyObject.class);
    private static final String _CACHE_KEY = "fi.gl.acct.assistkeyobject.cache";
    public static ThreadLocal<Integer> INIT_COUNT = ThreadLocals.create((Object)0);
    public static ThreadLocal<Integer> HIT_TIMES = ThreadLocals.create((Object)0);
    private String acctNumber;
    private Map<String, Object> comAssist;
    private int hashcode = 0;
    private static final int MAX_KEY = 50000;

    public AssistKeyObject(String acctNumber, Map<String, Object> comAssist) {
        this.acctNumber = acctNumber;
        this.comAssist = comAssist;
        this.hashcode = AssistKeyObject.calcHashCode(acctNumber, comAssist);
    }

    private static int calcHashCode(String acctNumber, Map<String, Object> comAssist) {
        return Objects.hash(acctNumber, comAssist.hashCode());
    }

    public int hashCode() {
        return this.hashcode;
    }

    public static AssistKeyObject retrievalFromCacheOrBuild(String acctNumber, Map<String, Object> comAssist) {
        int hashCode;
        Map _keyCache = (Map)ThreadCache.get((Object)_CACHE_KEY, () -> new HashMap(50000), (boolean)true);
        LinkedList<AssistKeyObject> candiates = (LinkedList<AssistKeyObject>)_keyCache.get(hashCode = AssistKeyObject.calcHashCode(acctNumber, comAssist));
        if (null == candiates) {
            candiates = new LinkedList<AssistKeyObject>();
            _keyCache.put(hashCode, candiates);
        }
        if (candiates.size() > 0) {
            for (int i = 0; i < candiates.size(); ++i) {
                AssistKeyObject value = (AssistKeyObject)candiates.get(i);
                if (!AssistKeyObject.equals(value, acctNumber, comAssist)) continue;
                HIT_TIMES.set(HIT_TIMES.get() + 1);
                return value;
            }
        }
        AssistKeyObject key = new AssistKeyObject(acctNumber, comAssist);
        candiates.add(key);
        if (_keyCache.size() > 50000) {
            _keyCache.clear();
            log.error("debug_error: clear cache");
        }
        INIT_COUNT.set(INIT_COUNT.get() + 1);
        return key;
    }

    public static void clear() {
        Map _keyCache = (Map)ThreadCache.get((Object)_CACHE_KEY, () -> new HashMap(50000), (boolean)true);
        if (null != _keyCache) {
            _keyCache.entrySet().forEach(x -> ((List)x.getValue()).clear());
            _keyCache.clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistKeyObject that = (AssistKeyObject)o;
        return AssistKeyObject.equals(this, that.acctNumber, that.comAssist);
    }

    public static boolean equals(AssistKeyObject keyObject, String acctNumber, Map<String, Object> comAssist) {
        return Objects.equals(keyObject.acctNumber, acctNumber) && keyObject.comAssist.hashCode() == comAssist.hashCode() && Objects.equals(keyObject.comAssist, comAssist);
    }

    public String getAcctNumber() {
        return this.acctNumber;
    }

    public Map<String, Object> getComAssist() {
        return this.comAssist;
    }

    public String toString() {
        return "AcctKeyObject{acctNumber=" + this.acctNumber + ", comAssist=" + this.comAssist + '}';
    }
}

