/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.param;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.acct.param.AcctReClassAmountKey;
import kd.fi.gl.acct.param.BCMBalanceIndexParam;

public class FormulaParam {
    private String key;
    private String fetchType;
    private Object[] balFieldIndex;
    private BigDecimal amtResult;
    private String formulaDc;
    private boolean isBalDc;
    private String errorMsg;
    private boolean isReclass;
    private boolean isLeafAcctSum;
    private boolean isJBal;
    private Table<String, String, BigDecimal> leafAcctToAmtTable = HashBasedTable.create();
    private Map<String, Integer> leafAcctToStyleMap;
    private boolean contraAccount = false;
    Map<AcctReClassAmountKey, BigDecimal> assgrpToAmountMap = new HashMap<AcctReClassAmountKey, BigDecimal>(64);
    private Set<String> allFlexs;
    private Map<String, Set<Long>> comAssistToIdMap;
    private boolean hasComAssist;

    public FormulaParam(String key, String fetchType, int acctReClass, String formulaDc, Set<String> allFlexs, Map<String, Integer> leafAcctToStyleMap, boolean isBaseCurrency, String contraAccount, Map<String, Set<Long>> comAssistToIdMap) {
        this.key = key;
        this.fetchType = fetchType;
        this.formulaDc = formulaDc;
        this.allFlexs = allFlexs;
        this.comAssistToIdMap = comAssistToIdMap;
        this.hasComAssist = Objects.nonNull(comAssistToIdMap) && !comAssistToIdMap.isEmpty();
        this.isReclass = BCMBalanceIndexParam.getFetchTypeReclass().contains(fetchType);
        if (this.isReclass) {
            this.leafAcctToStyleMap = leafAcctToStyleMap;
            this.isLeafAcctSum = acctReClass == 4 || acctReClass == 5;
            this.isJBal = !BCMBalanceIndexParam.getFetchTypeD().contains(fetchType);
        }
        this.setBalFieldIndex(isBaseCurrency);
        this.isBalDc();
        this.isContraAccount(contraAccount);
    }

    private void isBalDc() {
        this.isBalDc = BCMBalanceIndexParam.getFetchType_y().contains(this.fetchType);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(String fetchType) {
        this.fetchType = fetchType;
    }

    public Map<String, Set<Long>> getComAssistToIdMap() {
        return this.comAssistToIdMap;
    }

    private void isContraAccount(String contraAccount) {
        if ("Y".equalsIgnoreCase(contraAccount)) {
            this.contraAccount = true;
        }
    }

    public void setAllFlexs(Set<String> allFlexs) {
        this.allFlexs = allFlexs;
    }

    private void setBalFieldIndex(boolean isBaseCurrency) {
        String _L = "";
        if (isBaseCurrency) {
            _L = "_L";
        }
        this.balFieldIndex = BCMBalanceIndexParam.getFetchTypeIndex().get(this.fetchType + _L);
        if (this.balFieldIndex == null && "L".equalsIgnoreCase(this.fetchType.substring(0, 1))) {
            String lfetchType = this.fetchType.substring(1);
            this.balFieldIndex = BCMBalanceIndexParam.getFetchTypeIndex().get(lfetchType + "_L");
        }
        if (this.balFieldIndex == null) {
            this.errorMsg = ResManager.loadKDString((String)"%s\u53d6\u6570\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"FormulaParam_0", (String)"fi-gl-mservice", (Object[])new Object[]{this.fetchType});
        }
    }

    public void addValue(Row rowData) {
        if (this.errorMsg != null) {
            return;
        }
        this.amtResult = this.amtResult == null ? new BigDecimal("0") : this.amtResult;
        BigDecimal amtRow = BCMBalanceIndexParam.rowCountByFetchType(rowData, this.balFieldIndex);
        if (!this.isReclass) {
            this.amtResult = this.amtResult.add(amtRow);
        } else {
            this.reClassAmt(rowData, amtRow);
        }
    }

    private void reClassAmt(Row rowData, BigDecimal amtRow) {
        String leafAcctId = rowData.getString("account");
        int assistStyle = this.leafAcctToStyleMap.get(leafAcctId);
        if (this.contraAccount) {
            if (assistStyle == 1) {
                this.dealLeafAcctToAmt(leafAcctId, rowData, amtRow);
            } else {
                this.dealAssgrpToAmt(false, assistStyle, rowData, amtRow);
            }
        } else if (assistStyle == 1) {
            this.dealLeafAcctToAmt(leafAcctId, rowData, amtRow);
        } else if (assistStyle == 2) {
            if (this.isLeafAcctSum) {
                this.dealLeafAcctToAmt(leafAcctId, rowData, amtRow);
            } else {
                this.dealAssgrpToAmt(true, assistStyle, rowData, amtRow);
            }
        } else if (assistStyle == 3) {
            this.dealAssgrpToAmt(true, assistStyle, rowData, amtRow);
        }
    }

    public Object getAmtResult() {
        if (this.errorMsg != null) {
            return this.errorMsg;
        }
        if (this.amtResult == null) {
            if (this.leafAcctToAmtTable.isEmpty() && this.assgrpToAmountMap.isEmpty()) {
                return null;
            }
            this.amtResult = new BigDecimal("0");
        }
        this.reClassSum();
        if (this.isBalDc) {
            this.amtResult = this.amtResult.multiply(new BigDecimal(this.formulaDc));
        }
        return this.amtResult;
    }

    private void reClassSum() {
        Collection amountColl = this.leafAcctToAmtTable.values();
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(amountColl);
        amountList.addAll(this.assgrpToAmountMap.values());
        for (BigDecimal amount : amountList) {
            if (this.isJBal && amount.compareTo(BigDecimal.ZERO) > 0) {
                this.amtResult = this.amtResult.add(amount);
                continue;
            }
            if (this.isJBal || amount.compareTo(BigDecimal.ZERO) >= 0) continue;
            this.amtResult = this.amtResult.add(amount);
        }
        if (this.isReclass && !this.isJBal) {
            this.amtResult = this.amtResult.negate();
        }
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    private void dealLeafAcctToAmt(String accountKey, Row rowData, BigDecimal amount) {
        String comAssistKey = "";
        if (this.hasComAssist) {
            comAssistKey = this.buildComAssistKey(rowData);
        }
        BigDecimal amtAcct = this.leafAcctToAmtTable.get((Object)accountKey, (Object)comAssistKey) != null ? (BigDecimal)this.leafAcctToAmtTable.get((Object)accountKey, (Object)comAssistKey) : new BigDecimal("0");
        amtAcct = amtAcct.add(amount);
        this.leafAcctToAmtTable.put((Object)accountKey, (Object)comAssistKey, (Object)amtAcct);
    }

    private String buildComAssistKey(Row dataRow) {
        ArrayList<String> valueList = new ArrayList<String>(8);
        for (String comAssistFiled : this.comAssistToIdMap.keySet()) {
            valueList.add(String.valueOf(dataRow.getLong(comAssistFiled)));
        }
        if (CollectionUtils.isNotEmpty(valueList)) {
            return String.join((CharSequence)"-", valueList);
        }
        return "";
    }

    private void dealAssgrpToAmt(boolean isNeedAccount, int assistStyle, Row rowData, BigDecimal amount) {
        String accountKey = "";
        if (isNeedAccount) {
            accountKey = rowData.getString("account");
        }
        HashMap<String, Object> assgrpMap = new HashMap<String, Object>(8);
        if (assistStyle == 2) {
            for (String f : this.allFlexs) {
                Object fval = rowData.get(f);
                assgrpMap.put(f, fval);
            }
        } else if (assistStyle == 3) {
            long hgId = rowData.getLong("hg");
            assgrpMap.put(hgId + "", null);
        }
        String comAssistKey = "";
        if (this.hasComAssist) {
            comAssistKey = this.buildComAssistKey(rowData);
        }
        AcctReClassAmountKey acctReClassAmountKey = new AcctReClassAmountKey(accountKey, assgrpMap, comAssistKey);
        BigDecimal bigDecimal = this.assgrpToAmountMap.computeIfAbsent(acctReClassAmountKey, x -> new BigDecimal("0"));
        bigDecimal = bigDecimal.add(amount);
        this.assgrpToAmountMap.put(acctReClassAmountKey, bigDecimal);
    }
}

