/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.param;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.acct.buildparam.AssistIdCollectionType;
import kd.fi.gl.acct.handle.MakeBaseDateDetailHelper;
import kd.fi.gl.acct.param.AcctPropertyParam;
import kd.fi.gl.acct.param.ReClassParam;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.util.ReClassUtils;
import kd.fi.gl.util.assistgroup.AssistGroupFactory;

public class ReClassNumberIDParam {
    private static final String ASSISTBD = "gl_assist_bd";
    private static final String ASSISTTXT = "gl_assist_txt";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private static final String FLEXFIELD = "flexfield";
    private static final String VALUETYPE = "valuetype";
    private static final String ASSISTANT_TYPE = "2";
    private Set<String> orgNumberSet = new HashSet<String>(8);
    private Set<String> bookTypeNumberSet = new HashSet<String>(8);
    private Set<String> currencyNumberSet = new HashSet<String>(8);
    private Set<String> periodNumberSet = new HashSet<String>(32);
    private Map<String, Map<String, Object>> errorInfoMap = new HashMap<String, Map<String, Object>>(128);
    private Set<String> acctNumberSet = new HashSet<String>(128);
    private Set<String> acctRangeNumberSet = new HashSet<String>(128);
    private Map<String, Set<String>> assistToValNumbersMap = new HashMap<String, Set<String>>(8);
    private Map<String, Set<String>> assistToValRangeNumbersMap = new HashMap<String, Set<String>>(8);
    private Map<String, Long> orgNumberToIdsMap;
    private Map<String, Long> bookTypeNumberToIdsMap;
    private Map<String, Long> currencyNumberToIdsMap;
    private Map<String, Long> periodIdsMap = new HashMap<String, Long>(32);
    private Map<String, Long> acctNumberToIdsMap = new HashMap<String, Long>(128);
    private Map<Long, String> acctMasterToDcMap = new HashMap<Long, String>(128);
    private Map<String, Set<Long>> acctRangeKeyToIdsMap = new HashMap<String, Set<Long>>(128);
    private Map<String, Set<Long>> flexsToAcctIdsMap = new HashMap<String, Set<Long>>(8);
    private Map<Long, Long> acctIdToMasterIdMap = new HashMap<Long, Long>(128);
    private Map<Long, Set<Long>> acctToDirectLeafMap = new HashMap<Long, Set<Long>>(128);
    private Map<Long, Set<Long>> acctToAllLeafMap = new HashMap<Long, Set<Long>>(128);
    private Map<Long, Set<String>> acctToFlexsMap = new HashMap<Long, Set<String>>(128);
    private Map<Long, String> acctToNumberMap = new HashMap<Long, String>(128);
    private Map<String, String> assistToFlexMap = new HashMap<String, String>(8);
    private Map<String, String> flexToAssistEntityMap = new HashMap<String, String>(8);
    private Map<String, Object> assistValNumberToObjMap = new HashMap<String, Object>(8);
    private Map<String, Set<Object>> assistValRangeNumberToObjsMap = new HashMap<String, Set<Object>>(8);
    private Map<String, AssistIdCollectionType> assistValCollectionMap = new HashMap<String, AssistIdCollectionType>(8);
    private Map<String, DataSet> flexToIDHgSet = new HashMap<String, DataSet>(8);
    private Set<String> assistNumberAllVal = new HashSet<String>(8);
    private Set<String> flexAllVal = new HashSet<String>(8);
    private Map<String, Long> standardMap = new HashMap<String, Long>(8);
    private final Map<String, DataSet> groupMap = new HashMap<String, DataSet>(8);
    private Set<String> periodYearAndMonthSet = new HashSet<String>(8);
    private Map<String, Long> seasonPeriodIdMap = new HashMap<String, Long>(8);
    private Map<String, Set<String>> assistNumToDocumentFiledMap = new HashMap<String, Set<String>>(16);
    private Map<String, Set<String>> assistFieldToPropertyValMap = new HashMap<String, Set<String>>(16);
    private Map<String, Set<Long>> assistFieldValToIdMap = new HashMap<String, Set<Long>>(16);
    private Map<String, Set<String>> fieldToEntryFieldMap = new HashMap<String, Set<String>>(8);
    private Map<String, List<String>> periodFromYearMap = new HashMap<String, List<String>>(8);
    private Map<String, Set<String>> comAssistToValueNumMap = new HashMap<String, Set<String>>(8);
    private Map<String, Set<String>> comAssistToValRangeNumMap = new HashMap<String, Set<String>>(8);
    private Set<String> comAssistToAllValueSet = new HashSet<String>(8);
    private Table<String, String, Set<Long>> comAssistToValueIdTable = HashBasedTable.create();
    private Table<String, String, Set<Long>> comAssistToValRangeIdTable = HashBasedTable.create();
    private Map<String, String> assistNumToValTypeMap;
    private String orgNumber;
    private String bookTypeNumber;
    private long orgId = 0L;
    private long bookTypeId = 0L;
    private long acctTableId = 0L;
    boolean isAssistJoinBal = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.acct.assistjoinbal", (boolean)true);
    private static final Log log = LogFactory.getLog(ReClassNumberIDParam.class);
    private static final String ACCTLOG = "ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: ";

    public ReClassNumberIDParam(ReClassParam param, Map<String, List<String>> formulasMap, String bookStr) {
        this.parseAcctFormula(param, formulasMap, bookStr);
    }

    private void parseAcctFormula(ReClassParam param, Map<String, List<String>> formulasMap, String bookStr) {
        PerformanceWatch watch = new PerformanceWatch(ReClassNumberIDParam.class, "parseAcctFormula", false);
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: bookStr " + bookStr + " parseAcctFormula paramMap iterator");
        String[] orgBookTypes = bookStr.split(",");
        this.orgNumber = orgBookTypes[0];
        this.bookTypeNumber = orgBookTypes[1];
        this.orgNumberSet.add(this.orgNumber);
        this.bookTypeNumberSet.add(this.bookTypeNumber);
        this.assistNumToValTypeMap = this.queryAssistNumToValType();
        List<String> scopePeriods = param.getScopePeriods();
        for (Map.Entry<String, List<String>> entry : formulasMap.entrySet()) {
            String key = entry.getKey();
            List<String> paramFields = entry.getValue();
            String fetchType = paramFields.get(3);
            String acctToAssistStr = paramFields.get(2);
            this.getBatchAcctAndAssist(acctToAssistStr, key);
            String periodNumber = AcctUtil.getPeriodParam(paramFields.get(5));
            if ((StringUtils.isBlank((CharSequence)periodNumber) || periodNumber.equals("0")) && CollectionUtils.isNotEmpty(scopePeriods) && StringUtils.isNotBlank((CharSequence)fetchType)) {
                int formulaYear = StringUtils.isBlank((CharSequence)paramFields.get(4)) || paramFields.get(4).equals("0") ? 0 : Integer.parseInt(paramFields.get(4));
                int fy = formulaYear > 1000 ? formulaYear : param.getFy() + formulaYear;
                for (int i = 0; i < scopePeriods.size(); ++i) {
                    String strPeriod = String.valueOf(scopePeriods.get(i));
                    this.periodYearAndMonthSet.add(fy + "," + strPeriod);
                }
            } else {
                if (CollectionUtils.isNotEmpty(scopePeriods) && periodNumber.startsWith("-")) {
                    this.setErrorInfoMap(key, -1, ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u53d6\u6570\u65f6\u4e0d\u652f\u6301\u8bbe\u7f6e\u504f\u79fb\u91cf\uff0c\u8bf7\u66f4\u6539\u516c\u5f0f\u914d\u7f6e\u6216\u671f\u95f4\u6210\u5458\u6620\u5c04\u3002", (String)"ReClassNumberIDParam_3", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                String fy = paramFields.get(4);
                this.periodNumberSet.add(fy + "," + periodNumber);
            }
            String currencyNumber = paramFields.get(6);
            this.currencyNumberSet.add(currencyNumber);
            String comAssistStr = param.getComAssistStr();
            if (paramFields.size() > 9 && StringUtils.isNotBlank((CharSequence)paramFields.get(9))) {
                comAssistStr = paramFields.get(9);
            }
            if (!AcctUtil.checkComAssistFormat(comAssistStr, Boolean.TRUE)) continue;
            this.getBatchComAssist(comAssistStr);
        }
        this.printComAssistNumLog();
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: bookStr " + bookStr + " numberToIDParam ");
        this.numberToIDParam();
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: bookStr " + bookStr + " AccountBookInfo and periodIdsMap");
        if (this.orgNumberToIdsMap.get(this.orgNumber) == null) {
            return;
        }
        this.orgId = this.orgNumberToIdsMap.get(this.orgNumber);
        if (this.bookTypeNumberToIdsMap.get(this.bookTypeNumber) == null) {
            return;
        }
        this.bookTypeId = this.bookTypeNumberToIdsMap.get(this.bookTypeNumber);
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgNumberToIdsMap.get(this.orgNumber), (long)this.bookTypeNumberToIdsMap.get(this.bookTypeNumber));
        if (bookInfo == null) {
            return;
        }
        int comFy = param.getFy();
        this.initPeriodFromYear(comFy);
        int comPeriod = param.getPeriod();
        String comAdjustPeriod = param.getAdjustPeriod();
        this.queryPeriodIdByBook(comFy, comPeriod, comAdjustPeriod);
        boolean isQueryAdjustPeriod = param.getCommParamMap().get("isAdjustPeriod") == null ? true : (Boolean)param.getCommParamMap().get("isAdjustPeriod") == false;
        this.querySeasonPeriodId(isQueryAdjustPeriod);
        long periodId = 0L;
        if (this.periodIdsMap.get(comFy + "," + comPeriod) != null) {
            periodId = this.periodIdsMap.get(comFy + "," + comPeriod);
        } else {
            if (this.periodIdsMap.isEmpty() && this.seasonPeriodIdMap.isEmpty()) {
                log.info("ACCT\u91cd\u5206\u7c7bparseAcctFormula:orgNumber:" + this.orgNumber + "," + this.orgId + ";bookTypeNumber:" + this.bookTypeNumber + "," + this.bookTypeId + ";accountTableId:" + this.acctTableId + ";periodNumber:" + this.periodNumberSet);
                return;
            }
            if (!this.periodIdsMap.isEmpty()) {
                periodId = this.periodIdsMap.values().iterator().next();
            } else {
                for (Long tempPeriodId : this.seasonPeriodIdMap.values()) {
                    if (periodId != 0L && tempPeriodId <= periodId) continue;
                    periodId = tempPeriodId;
                }
            }
        }
        if (!this.periodIdsMap.isEmpty()) {
            this.acctTableId = AccSysUtil.getCurPeriodAccountTableId((long)this.orgId, (long)this.bookTypeId, (long)periodId);
        }
        if (this.acctTableId == 0L) {
            this.acctTableId = bookInfo.getAccountTableId();
        }
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: bookStr " + bookStr + " queryAcctId");
        QFilter facctBaseData = AccountUtils.getAccountDataFilter((long)this.orgId, (long)this.acctTableId);
        if (this.periodIdsMap.size() > 1 && comPeriod < 13) {
            this.periodIdsMap.remove(comFy + "," + comPeriod);
            periodId = this.periodIdsMap.values().iterator().next();
        }
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
        facctBaseData = facctBaseData.and(new QFilter("startdate", "<=", (Object)period.getDate("enddate"))).and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
        facctBaseData = facctBaseData.and(new QFilter("accounttable", "=", (Object)this.acctTableId));
        log.info("ACCT\u91cd\u5206\u7c7bparseAcctFormula:orgNumber:" + this.orgNumber + "," + this.orgId + ";bookTypeNumber:" + this.bookTypeNumber + "," + this.bookTypeId + ";accountTableId:" + this.acctTableId + ";periodId:" + periodId);
        this.queryAcctId(facctBaseData.copy());
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: bookStr " + bookStr + " queryDLAndALAcct all leaf account");
        this.queryDLAndALAcct(facctBaseData.copy());
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: bookStr " + bookStr + " queryAssistId all leaf assist");
        this.queryAssistId();
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: boo kStr " + bookStr + " queryComAssistId()");
        this.queryComAssistId();
        watch.stop();
        log.info(watch.show());
    }

    private void queryAllAcctFlexs(Set<Long> acctIds) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, number, masterid, checkitementry.asstactitem.flexfield flexfield, checkitementry.asstactitem.valuetype valuetype", new QFilter[]{new QFilter("id", "in", acctIds)});
        for (Row row : acctSet) {
            long acctId = row.getLong("id");
            long masterId = row.getLong("masterid");
            this.acctToNumberMap.put(acctId, row.getString("number"));
            String flexField = row.getString(FLEXFIELD);
            this.acctIdToMasterIdMap.put(acctId, masterId);
            if (flexField == null) {
                this.acctToFlexsMap.put(acctId, null);
                continue;
            }
            HashSet<String> flexMap = this.acctToFlexsMap.get(acctId) == null ? new HashSet<String>(8) : this.acctToFlexsMap.get(acctId);
            flexMap.add(flexField);
            this.acctToFlexsMap.put(acctId, flexMap);
            String valueType = row.getString(VALUETYPE);
            if ("3".equals(valueType)) {
                this.flexToAssistEntityMap.put(flexField, ASSISTTXT);
                continue;
            }
            this.flexToAssistEntityMap.put(flexField, ASSISTBD);
        }
    }

    private void queryDLAndALAcct(QFilter facctBaseData) {
        HashSet<Long> acctIds = new HashSet<Long>(128);
        acctIds.addAll(this.acctNumberToIdsMap.values());
        for (Collection collection : this.acctRangeKeyToIdsMap.values()) {
            acctIds.addAll(collection);
        }
        PerformanceWatch watch = new PerformanceWatch(ReClassNumberIDParam.class, "queryDLAndALAcct", false);
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryDLAndALAcct queryAcctLeafAndDirectSub, acctIds size: " + acctIds.size());
        this.queryAcctLeafAndDirectSub(facctBaseData);
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryDLAndALAcct queryAllAcctFlexs");
        HashSet<Long> hashSet = new HashSet<Long>(128);
        Iterator iterator = acctIds.iterator();
        while (iterator.hasNext()) {
            long acctId = (Long)iterator.next();
            Set leafAcctIds = this.acctToDirectLeafMap.computeIfAbsent(acctId, x -> new HashSet(128));
            if (leafAcctIds.isEmpty()) {
                leafAcctIds.add(acctId);
            }
            hashSet.add(acctId);
            hashSet.addAll(leafAcctIds);
            Set allLeafAcctIds = this.acctToAllLeafMap.computeIfAbsent(acctId, x -> new HashSet(128));
            if (allLeafAcctIds.isEmpty()) {
                allLeafAcctIds.add(acctId);
            }
            hashSet.add(acctId);
            hashSet.addAll(allLeafAcctIds);
        }
        if (DebugTrace.enable()) {
            log.info("ACCT\u91cd\u5206\u7c7b\u79d1\u76ee\u8fc7\u6ee4\u540eacctToAllLeafMap\uff1a" + this.acctToAllLeafMap);
            log.info("ACCT\u91cd\u5206\u7c7b\u79d1\u76ee\u8fc7\u6ee4\u540eacctToDirectLeafMap\uff1a" + this.acctToDirectLeafMap);
        }
        this.queryAllAcctFlexs(hashSet);
        watch.stop();
        log.info(watch.show());
    }

    private void queryAcctLeafAndDirectSub(QFilter baseFilter) {
        DataSet leafAcctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, number, longnumber, isleaf", new QFilter[]{baseFilter});
        for (Row row : leafAcctSet) {
            String parentNumber;
            int splitCount;
            boolean isLeaf = row.getBoolean("isleaf");
            String longNumber = row.getString("longnumber");
            String[] split = longNumber.split("_");
            if (isLeaf) {
                for (String number : split) {
                    if (this.acctNumberToIdsMap.get(number) == null) continue;
                    long acctId = this.acctNumberToIdsMap.get(number);
                    Set leafSet = this.acctToAllLeafMap.computeIfAbsent(acctId, x -> new HashSet(128));
                    leafSet.add(row.getLong("id"));
                }
            }
            if ((splitCount = split.length) <= 1 || this.acctNumberToIdsMap.get(parentNumber = split[split.length - 2]) == null) continue;
            long acctId = this.acctNumberToIdsMap.get(parentNumber);
            long leafAcctId = row.getLong("id");
            Set directLeafAcctIds = this.acctToDirectLeafMap.computeIfAbsent(acctId, x -> new HashSet(8));
            directLeafAcctIds.add(leafAcctId);
            this.acctToDirectLeafMap.put(acctId, directLeafAcctIds);
        }
    }

    private void queryAssistId() {
        String entityId;
        String assistNumber;
        HashMap<String, Set<Object>> flexToValIdsMap = new HashMap<String, Set<Object>>(this.assistNumberAllVal.size());
        HashSet<String> asstactTypeNumbers = new HashSet<String>();
        asstactTypeNumbers.addAll(this.assistNumberAllVal);
        if (!this.assistToValNumbersMap.isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValNumbersMap.keySet());
        }
        if (!this.assistToValRangeNumbersMap.isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValRangeNumbersMap.keySet());
        }
        if (!this.assistNumToDocumentFiledMap.isEmpty()) {
            asstactTypeNumbers.addAll(this.assistNumToDocumentFiledMap.keySet());
        }
        HashMap<String, Long> numberToDetailGroupMap = new HashMap<String, Long>(8);
        HashMap<String, String> assistNnumberToEntityMap = new HashMap<String, String>(8);
        PerformanceWatch watch = new PerformanceWatch(ReClassNumberIDParam.class, "queryAssistId", false);
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryAssistId getFlexToAssistTypeMap asstactTypeNumbers size " + asstactTypeNumbers.size());
        this.getFlexToAssistTypeMap(assistNnumberToEntityMap, numberToDetailGroupMap, asstactTypeNumbers);
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryAssistId assistNumToDocumentFiledMap size " + this.assistNumToDocumentFiledMap.size());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        if (!this.assistNumToDocumentFiledMap.isEmpty()) {
            AcctPropertyParam acctPropertyParam = new AcctPropertyParam(this.assistNumToDocumentFiledMap, assistNnumberToEntityMap, this.assistFieldToPropertyValMap, this.orgId, numberToDetailGroupMap);
            this.assistFieldValToIdMap = acctPropertyParam.getAssistFieldValToIdMap();
            this.assistValNumberToObjMap = acctPropertyParam.getAssistNumToIdsMap();
            this.fieldToEntryFieldMap = acctPropertyParam.getFiledMap();
            Map<String, Set<String>> assistFieldToNumbersMap = acctPropertyParam.getAssistFieldToNumbersMap();
            for (String assistNumber2 : asstactTypeNumbers) {
                Set<String> valNumbers = assistFieldToNumbersMap.get(assistNumber2);
                String flex = this.assistToFlexMap.get(assistNumber2);
                if (StringUtils.isBlank((CharSequence)flex)) continue;
                if (null == valNumbers || valNumbers.isEmpty()) {
                    flexToValIdsMap.computeIfAbsent(flex, k -> new HashSet()).add(0L);
                    continue;
                }
                for (String valNumber : valNumbers) {
                    flexToValIdsMap.computeIfAbsent(flex, k -> new HashSet()).add(this.assistValNumberToObjMap.get(assistNumber2 + "*" + valNumber));
                }
            }
        }
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryAssistId assistToValNumbersMap size " + this.assistToValNumbersMap.size());
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        for (Map.Entry<String, Set<String>> entry : this.assistToValNumbersMap.entrySet()) {
            assistNumber = entry.getKey();
            entityId = (String)assistNnumberToEntityMap.get(assistNumber);
            Set<String> valNumbers = entry.getValue();
            filters.clear();
            QFilter fbasedata = null;
            if (this.orgId != 0L && entityId != null && (fbasedata = this.dealBasedataFilter(entityId, this.orgId)) != null) {
                filters.add(fbasedata);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long assistGroupId = (Long)numberToDetailGroupMap.get(assistNumber);
                QFilter qFilter = this.dealAssistantFilter(assistGroupId, this.orgId);
                if (qFilter != null) {
                    filters.add(qFilter);
                }
                filters.add(new QFilter("group", "=", (Object)assistGroupId));
            }
            HashMap<String, Object> numberToObjsMap = new HashMap<String, Object>(64);
            if (entityId == null) {
                for (String string : valNumbers) {
                    numberToObjsMap.put(string, string);
                }
            } else {
                Map<String, Set<Long>> numberToIdsMap1 = detailHelper.getDetailAssists(entityId, valNumbers, filters);
                numberToObjsMap.putAll(numberToIdsMap1);
            }
            for (Map.Entry entry2 : numberToObjsMap.entrySet()) {
                this.assistValNumberToObjMap.put(assistNumber + "*" + (String)entry2.getKey(), entry2.getValue());
            }
            String flex = this.assistToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            flexToValIdsMap.put(flex, new HashSet(numberToObjsMap.values()));
        }
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryAssistId assistToValNumbersMap size " + this.assistToValNumbersMap.size());
        for (Map.Entry<String, Set<String>> entry : this.assistToValRangeNumbersMap.entrySet()) {
            assistNumber = entry.getKey();
            entityId = (String)assistNnumberToEntityMap.get(assistNumber);
            if (Objects.isNull(entityId)) continue;
            boolean containMasterid = ReClassUtils.hasMasteridProp(entityId);
            String masteridField = containMasterid ? "masterid" : "id";
            Set<String> rangeValNumber = entry.getValue();
            filters.clear();
            QFilter fbasedata = null;
            if (this.orgId != 0L && entityId != null) {
                fbasedata = this.dealBasedataFilter(entityId, this.orgId);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long l = (Long)numberToDetailGroupMap.get(assistNumber);
                QFilter assistantFilter = this.dealAssistantFilter(l, this.orgId);
                if (assistantFilter != null) {
                    filters.add(assistantFilter);
                }
                filters.add(new QFilter("group", "=", (Object)l));
            }
            HashSet<Object> hashSet = new HashSet<Object>(128);
            Iterator<String> iterator = rangeValNumber.iterator();
            while (iterator.hasNext()) {
                String assistRangeNumber;
                String key = assistRangeNumber = iterator.next();
                HashSet<Object> assistValIds = new HashSet<Object>(128);
                ArrayList<QFilter> rangFilters = new ArrayList<QFilter>(8);
                rangFilters.addAll(filters);
                boolean isNoCategory = ReClassUtils.isCollectionNumber(assistRangeNumber);
                if (!isNoCategory) {
                    assistRangeNumber = assistRangeNumber.substring(1, assistRangeNumber.length() - 1);
                }
                String[] assisttContinueNumbers = assistRangeNumber.split(",");
                if (entityId == null) {
                    assistValIds.addAll(Arrays.asList(assisttContinueNumbers));
                    hashSet.addAll(assistValIds);
                    this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                    continue;
                }
                DataSet assistSet = null;
                if (!isNoCategory) {
                    if (fbasedata != null) {
                        rangFilters.add(fbasedata.copy());
                    }
                    if ((assistSet = this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), rangFilters, masteridField, entityId)) == null) continue;
                    for (Iterator row : assistSet) {
                        assistValIds.add(row.getLong(masteridField));
                    }
                    if (assistValIds.size() == 0) continue;
                    if (!isNoCategory && detailHelper.hasParent(entityId)) {
                        Set<Object> assistValIds1 = detailHelper.getDetailAssisttContinueNumbers(entityId, assistValIds, filters);
                        assistValIds.addAll(assistValIds1);
                    }
                    this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                } else {
                    Iterator row;
                    assistSet = AssistGroupFactory.getGroupFactoryHandle(entityId).initData(this.standardMap, this.groupMap).queryAssistValByGroup(assistRangeNumber, entityId);
                    if (assistSet == null) continue;
                    HashSet<Long> masterIdByGroup = new HashSet<Long>(8);
                    row = assistSet.iterator();
                    while (row.hasNext()) {
                        Row row2 = (Row)row.next();
                        masterIdByGroup.add(row2.getLong("masterid"));
                    }
                    assistSet = this.queryDataSet(this.getClass().getName(), entityId, "masterid", new QFilter[]{fbasedata, new QFilter("id", "in", masterIdByGroup)});
                    HashSet<Long> masterIds = new HashSet<Long>(128);
                    for (Row row3 : assistSet) {
                        long mid = row3.getLong("masterid");
                        assistValIds.add(mid);
                        masterIds.add(mid);
                    }
                    if (assistValIds.size() == 0) continue;
                    String flex = this.assistToFlexMap.get(assistNumber);
                    this.assistValCollectionMap.put(assistNumber + "*" + key, new AssistIdCollectionType(flex, assistRangeNumber, masterIds));
                    this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                }
                hashSet.addAll(assistValIds);
            }
            String flex = this.assistToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex) || hashSet.isEmpty()) continue;
            Set<Object> valIds = flexToValIdsMap.get(flex) == null ? new HashSet(128) : (Set)flexToValIdsMap.get(flex);
            valIds.addAll(hashSet);
            flexToValIdsMap.put(flex, valIds);
        }
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryAssistId assistToValRangeNumbersMap size " + this.assistToValRangeNumbersMap.size());
        for (String assistNumber3 : this.assistNumberAllVal) {
            String flex = this.assistToFlexMap.get(assistNumber3);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            this.flexAllVal.add(flex);
        }
        for (String flex : this.flexAllVal) {
            flexToValIdsMap.put(flex, new HashSet(128));
        }
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryAssistId addFlexAllVal flexToValIdsMap size " + flexToValIdsMap.size());
        if (this.isAssistJoinBal) {
            this.addFlexAllVal_new(flexToValIdsMap);
        } else {
            this.addFlexAllVal_old(flexToValIdsMap);
        }
        watch.stop();
        log.info(watch.show());
    }

    public void addFlexAllVal_new(Map<String, Set<Object>> flexToValIdsMap) {
        for (Map.Entry<String, Set<Object>> assistEntry : flexToValIdsMap.entrySet()) {
            boolean isQueryVal;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            String flex = assistEntry.getKey();
            Set<Object> valIds = assistEntry.getValue();
            QFilter typeFilter = new QFilter("asstype", "=", (Object)flex);
            filters.add(typeFilter);
            if (valIds == null) {
                valIds = new HashSet<Object>(128);
            }
            HashSet<Object> newValIds = new HashSet<Object>(valIds.size());
            for (Object valId : valIds) {
                if (valId instanceof Collection) {
                    newValIds.addAll((Collection)valId);
                    continue;
                }
                newValIds.add(valId);
            }
            String entityId = this.flexToAssistEntityMap.get(flex);
            boolean isFilterVal = newValIds.size() < 1000;
            boolean bl = isQueryVal = isFilterVal && newValIds.size() != 0 && !this.flexAllVal.contains(flex);
            if (isQueryVal) {
                QFilter ValFilter = new QFilter("assval", "in", newValIds);
                filters.add(ValFilter);
            } else if (newValIds.size() == 0) {
                this.flexAllVal.add(flex);
            }
            String selFields = "hg, assval " + flex;
            DataSet balAssistSet = ReClassUtils.queryAssistByBal(entityId, selFields, this.orgId, filters, "gl_balance");
            DataSet balLogAssistSet = ReClassUtils.queryAssistByBal(entityId, selFields, this.orgId, filters, "gl_balance_log");
            int balLogCount = balLogAssistSet.copy().count("hg", false);
            DataSet hgSet = balLogCount > 0 ? balAssistSet.union(balLogAssistSet) : balAssistSet;
            hgSet = hgSet.groupBy(new String[]{"hg", flex}).finish();
            if (!isFilterVal && newValIds.size() != 0 && !this.flexAllVal.contains(flex)) {
                HashMap<String, HashSet<Object>> filterMap = new HashMap<String, HashSet<Object>>(8);
                filterMap.put("valIds", newValIds);
                hgSet = hgSet.filter(flex + " in valIds", filterMap);
            }
            this.flexToIDHgSet.put(flex, hgSet);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void queryComAssistId() {
        QFilter baseDataFilter;
        ArrayList<QFilter> comAssistValFilters;
        String entityId;
        String valueSourceType;
        CommonAssist commonAssist;
        String comAssistKey;
        ComAssistTable comAssistTable = ComAssistTable.get((Long)this.acctTableId);
        List commonAssists = comAssistTable.getCommonAssists();
        List allCommonAssistKeys = comAssistTable.getAllCommonAssistKeys();
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        for (Map.Entry<String, Set<String>> comAssistToValueNumEntry : this.comAssistToValueNumMap.entrySet()) {
            comAssistKey = comAssistToValueNumEntry.getKey();
            if (!allCommonAssistKeys.contains(comAssistKey)) continue;
            commonAssist = (CommonAssist)commonAssists.get(allCommonAssistKeys.indexOf(comAssistKey));
            valueSourceType = commonAssist.getValueSourceType();
            entityId = commonAssist.getValueSource();
            comAssistValFilters = new ArrayList<QFilter>(8);
            if (this.orgId != 0L && entityId != null && (baseDataFilter = this.dealBasedataFilter(entityId, this.orgId)) != null) {
                comAssistValFilters.add(baseDataFilter);
            }
            if (ASSISTANT_TYPE.equals(valueSourceType)) {
                QFilter assistantFilter = this.dealAssistantFilter(commonAssist.assistType, this.orgId);
                if (assistantFilter != null) {
                    comAssistValFilters.add(assistantFilter);
                }
                comAssistValFilters.add(new QFilter("group", "=", (Object)commonAssist.assistType));
            }
            Map<String, Set<Long>> detailComAssistValueMap = detailHelper.getDetailAssists(entityId, comAssistToValueNumEntry.getValue(), comAssistValFilters);
            for (Map.Entry entry : detailComAssistValueMap.entrySet()) {
                this.comAssistToValueIdTable.put((Object)comAssistKey, entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<String, Set<String>> comAssistToValRangeNumEntry : this.comAssistToValRangeNumMap.entrySet()) {
            comAssistKey = comAssistToValRangeNumEntry.getKey();
            if (!allCommonAssistKeys.contains(comAssistKey)) continue;
            commonAssist = (CommonAssist)commonAssists.get(allCommonAssistKeys.indexOf(comAssistKey));
            valueSourceType = commonAssist.getValueSourceType();
            entityId = commonAssist.getValueSource();
            comAssistValFilters = new ArrayList(8);
            baseDataFilter = null;
            if (this.orgId != 0L && entityId != null && (baseDataFilter = this.dealBasedataFilter(entityId, this.orgId)) != null) {
                comAssistValFilters.add(baseDataFilter);
            }
            if (ASSISTANT_TYPE.equals(valueSourceType)) {
                QFilter assistantFilter = this.dealAssistantFilter(commonAssist.assistType, this.orgId);
                if (assistantFilter != null) {
                    comAssistValFilters.add(assistantFilter);
                }
                comAssistValFilters.add(new QFilter("group", "=", (Object)commonAssist.assistType));
            }
            for (String string : comAssistToValRangeNumEntry.getValue()) {
                void var14_18;
                HashSet<Object> comAssistValIds = new HashSet<Object>(8);
                boolean isNoCategory = ReClassUtils.isCollectionNumber(string);
                if (!isNoCategory) {
                    String string2 = string.substring(1, string.length() - 1);
                }
                String[] comAssistContinueNumbers = var14_18.split(",");
                DataSet assistDataSet = !isNoCategory ? this.queryContinueNumber(Arrays.asList(comAssistContinueNumbers), comAssistValFilters, "masterid", entityId) : AssistGroupFactory.getGroupFactoryHandle(entityId).initData(this.standardMap, this.groupMap).queryAssistValByGroup((String)var14_18, entityId);
                if (assistDataSet == null) continue;
                HashSet<Long> masterIdByGroup = new HashSet<Long>(8);
                for (Row row : assistDataSet) {
                    masterIdByGroup.add(row.getLong("masterid"));
                }
                assistDataSet = this.queryDataSet(this.getClass().getName(), entityId, "masterid", new QFilter[]{baseDataFilter, new QFilter("id", "in", masterIdByGroup)});
                for (Row row : assistDataSet) {
                    comAssistValIds.add(row.getLong("masterid"));
                }
                if (CollectionUtils.isEmpty(comAssistValIds)) continue;
                if (!isNoCategory && detailHelper.hasParent(entityId)) {
                    Set<Object> comAssistValIdSet = detailHelper.getDetailAssisttContinueNumbers(entityId, comAssistValIds, comAssistValFilters);
                    comAssistValIds.addAll(comAssistValIdSet);
                }
                HashSet<Long> rangeComAssistIdSet = new HashSet<Long>(8);
                for (Object e : comAssistValIds) {
                    rangeComAssistIdSet.add((Long)e);
                }
                this.comAssistToValRangeIdTable.put((Object)comAssistKey, (Object)var14_18, rangeComAssistIdSet);
            }
        }
        if (DebugTrace.enable()) {
            log.info("ReClassNumberIDParam_queryComAssistId comAssistToValueIdTable:" + this.comAssistToValueIdTable);
            log.info("ReClassNumberIDParam_queryComAssistId comAssistToValRangeIdTable:" + this.comAssistToValRangeIdTable);
        }
    }

    public void addFlexAllVal_old(Map<String, Set<Object>> flexToValIdsMap) {
        for (Map.Entry<String, Set<Object>> assistEntry : flexToValIdsMap.entrySet()) {
            boolean isFilterVal;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            String flex = assistEntry.getKey();
            Set<Object> valIds = assistEntry.getValue();
            QFilter typeFilter = new QFilter("asstype", "=", (Object)flex);
            filters.add(typeFilter);
            if (valIds == null) {
                valIds = new HashSet<Object>(128);
            }
            HashSet<Object> newValIds = new HashSet<Object>(valIds.size());
            for (Object valId : valIds) {
                if (valId instanceof Collection) {
                    newValIds.addAll((Collection)valId);
                    continue;
                }
                newValIds.add(valId);
            }
            String entityId = this.flexToAssistEntityMap.get(flex);
            boolean bl = isFilterVal = newValIds.size() < 1000;
            if (isFilterVal && newValIds.size() != 0 && !this.flexAllVal.contains(flex)) {
                QFilter ValFilter = new QFilter("assval", "in", newValIds);
                filters.add(ValFilter);
            } else if (newValIds.size() == 0) {
                this.flexAllVal.add(flex);
            }
            DataSet hgSet = ReClassUtils.queryDataSet(entityId, "hg, assval " + flex, filters);
            if (!isFilterVal && newValIds.size() != 0 && !this.flexAllVal.contains(flex)) {
                HashMap<String, HashSet<Object>> filterMap = new HashMap<String, HashSet<Object>>(8);
                filterMap.put("valIds", newValIds);
                hgSet = hgSet.filter(flex + " in valIds", filterMap);
            }
            this.flexToIDHgSet.put(flex, hgSet);
        }
    }

    private QFilter dealBasedataFilter(String entityId, long orgId) {
        QFilter qf = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId);
        return qf;
    }

    private QFilter dealAssistantFilter(long assistantTypeId, long orgId) {
        QFilter assistantFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistantTypeId, (Long)orgId);
        return assistantFilter;
    }

    private void getFlexToAssistTypeMap(Map<String, String> numberToEntityMap, Map<String, Long> numberToDetailGroupMap, Set<String> asstactTypeNumbers) {
        QFilter fnumber = new QFilter("number", "in", asstactTypeNumbers);
        QFilter fflexid = new QFilter("flexid", "=", (Object)2L);
        DataSet asstactSet = this.queryDataSet(this.getClass().getName(), ASSIST_TYPE, "number,valuetype,assistanttype,valuesource,flexfield", new QFilter[]{fnumber, fflexid});
        for (Row row : asstactSet) {
            long assistGroupId = 0L;
            String valType = row.getString(VALUETYPE);
            String entityId = null;
            switch (valType) {
                case "1": {
                    entityId = row.getString("valuesource");
                    break;
                }
                case "2": {
                    entityId = "bos_assistantdata_detail";
                    assistGroupId = row.getLong("assistanttype");
                    break;
                }
                case "3": {
                    entityId = null;
                }
            }
            String number = row.getString("number");
            String flex = row.getString(FLEXFIELD);
            if (entityId != null) {
                this.flexToAssistEntityMap.put(flex, ASSISTBD);
            } else {
                this.flexToAssistEntityMap.put(flex, ASSISTTXT);
            }
            this.assistToFlexMap.put(number, flex);
            if (assistGroupId != 0L) {
                numberToDetailGroupMap.put(number, assistGroupId);
            }
            numberToEntityMap.put(number, entityId);
        }
    }

    private void getBatchAcctAndAssist(String acctAssistListStr, String acctKeyId) {
        acctAssistListStr = acctAssistListStr.replaceAll("\\|", "\\| ");
        String[] accountValues = acctAssistListStr.split("\\|");
        String accountNumberStr = "";
        if (accountValues.length == 1) {
            accountNumberStr = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                this.setErrorInfoMap(acctKeyId, -1, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u683c\u5f0f\u9519\u8bef\u3002", (String)"ReClassNumberIDParam_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
                return;
            }
            accountNumberStr = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)accountNumberStr)) {
            this.setErrorInfoMap(acctKeyId, -1, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"ReClassNumberIDParam_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return;
        }
        boolean isContinueAcct = this.isContinueNumber(accountNumberStr);
        if (!isContinueAcct) {
            String[] accts = accountNumberStr.split(",");
            this.acctNumberSet.addAll(Arrays.asList(accts));
        } else {
            this.acctRangeNumberSet.add(accountNumberStr);
        }
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            if (StringUtils.isBlank((CharSequence)assistNumber)) continue;
            HashSet<String> vals = new HashSet<String>(128);
            String rangeVals = "";
            String valStr = accountValues[i + 1].trim();
            if (valStr.contains("None")) {
                this.assistNumberAllVal.add(assistNumber);
            }
            if (!StringUtils.isBlank((CharSequence)valStr)) {
                if (ReClassUtils.isContinueNumber(valStr)) {
                    if ("3".equals(this.assistNumToValTypeMap.getOrDefault(assistNumber, "-1"))) {
                        this.setErrorInfoMap(acctKeyId, -1, ResManager.loadKDString((String)"\u624b\u5de5\u6838\u7b97\u7ef4\u5ea6\u4e0d\u652f\u6301\u53d6\u8303\u56f4\u503c\u3002", (String)"ReClassNumberIDParam_2", (String)"fi-gl-mservice", (Object[])new Object[0]));
                        return;
                    }
                    rangeVals = valStr;
                    Set<Object> rangeValNumbers = this.assistToValRangeNumbersMap.get(assistNumber) == null ? new HashSet(128) : this.assistToValRangeNumbersMap.get(assistNumber);
                    rangeValNumbers.add(rangeVals);
                    this.assistToValRangeNumbersMap.put(assistNumber, rangeValNumbers);
                    continue;
                }
                if (valStr.contains(":")) {
                    String[] documentFieldAndPropertyVals = valStr.replaceAll(":", ",").split(",");
                    String documentField = documentFieldAndPropertyVals[0];
                    this.assistNumToDocumentFiledMap.computeIfAbsent(assistNumber, k -> new HashSet(16)).add(documentField);
                    Set propertyValuesSet = this.assistFieldToPropertyValMap.computeIfAbsent(this.buildAssistAndFiledKey(new Object[]{assistNumber, documentField}, "*"), k -> new HashSet(16));
                    for (int j = 1; j < documentFieldAndPropertyVals.length; ++j) {
                        propertyValuesSet.add(documentFieldAndPropertyVals[j].trim());
                    }
                    continue;
                }
                String[] valList = valStr.split(",");
                vals.addAll(Arrays.asList(valList));
                Set<String> valNumbers = this.assistToValNumbersMap.get(assistNumber);
                if (valNumbers == null) {
                    valNumbers = new HashSet<String>(128);
                    valNumbers.addAll(vals);
                } else {
                    if (valNumbers.size() == 0) continue;
                    valNumbers.addAll(vals);
                }
                this.assistToValNumbersMap.put(assistNumber, valNumbers);
                continue;
            }
            this.assistNumberAllVal.add(assistNumber);
        }
    }

    private void getBatchComAssist(String comAssistStr) {
        Map<String, Set<String>> comAssistKeyToNumMap = AcctUtil.parseComAssistStr(comAssistStr);
        for (Map.Entry<String, Set<String>> comAssistKeyToNumEntry : comAssistKeyToNumMap.entrySet()) {
            String comAssistKey = comAssistKeyToNumEntry.getKey();
            Set<String> valueNumberSet = comAssistKeyToNumEntry.getValue();
            if (valueNumberSet != null && valueNumberSet.isEmpty()) {
                this.comAssistToAllValueSet.add(comAssistKey);
                continue;
            }
            if (valueNumberSet == null) continue;
            String tempValueNumber = valueNumberSet.iterator().next();
            if (AcctUtil.isRangeValueNumber(tempValueNumber)) {
                Set<Object> rangeValNumbers = this.comAssistToValRangeNumMap.get(comAssistKey) == null ? new HashSet(128) : this.comAssistToValRangeNumMap.get(comAssistKey);
                rangeValNumbers.addAll(valueNumberSet);
                this.comAssistToValRangeNumMap.put(comAssistKey, rangeValNumbers);
                continue;
            }
            Set<Object> dispersedValNumSet = this.comAssistToValueNumMap.get(comAssistKey) == null ? new HashSet(128) : this.comAssistToValueNumMap.get(comAssistKey);
            dispersedValNumSet.addAll(valueNumberSet);
            this.comAssistToValueNumMap.put(comAssistKey, dispersedValNumSet);
        }
    }

    private void printComAssistNumLog() {
        if (DebugTrace.enable()) {
            log.info("ReClassNumberIDParam_printComAssistNumLog comAssistToValueNumMap:" + this.comAssistToValueNumMap);
            log.info("ReClassNumberIDParam_printComAssistNumLog comAssistToValRangeNumMap:" + this.comAssistToValRangeNumMap);
            log.info("ReClassNumberIDParam_printComAssistNumLog comAssistToAllValueSet:" + this.comAssistToAllValueSet);
        }
    }

    private void setErrorInfoMap(String key, int type, String errorMessage) {
        HashMap<String, Object> message = new HashMap<String, Object>(8);
        message.put("type", type);
        message.put("v", errorMessage);
        this.errorInfoMap.put(key, message);
    }

    private String buildAssistAndFiledKey(Object[] fields, String separator) {
        return StringUtils.join((Object[])Arrays.stream(fields).toArray(), (String)separator);
    }

    private boolean isContinueNumber(String numberStr) {
        if (!StringUtils.isBlank((CharSequence)numberStr)) {
            return numberStr.contains("[") && numberStr.contains("]");
        }
        return false;
    }

    private void numberToIDParam() {
        this.orgNumberToIdsMap = ReClassUtils.numbersToIds("bos_org", this.orgNumberSet, null);
        this.bookTypeNumberToIdsMap = ReClassUtils.numbersToIds("bd_accountbookstype", this.bookTypeNumberSet, null);
        this.currencyNumberToIdsMap = ReClassUtils.numbersToIds("bd_currency", this.currencyNumberSet, null);
    }

    private void initPeriodFromYear(int comYear) {
        HashSet<Integer> yearSet = new HashSet<Integer>(8);
        for (String periodNumber : this.periodNumberSet) {
            String[] yearPeriodNumber = periodNumber.split(",");
            if (yearPeriodNumber.length != 2 || StringUtils.isBlank((CharSequence)yearPeriodNumber[0])) continue;
            if (Integer.parseInt(yearPeriodNumber[0]) > 1000) {
                yearSet.add(Integer.parseInt(yearPeriodNumber[0]));
                yearSet.add(Integer.parseInt(yearPeriodNumber[0]) - 1);
                continue;
            }
            yearSet.add(comYear + Integer.parseInt(yearPeriodNumber[0]));
            yearSet.add(comYear + Integer.parseInt(yearPeriodNumber[0]) - 1);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("periodyear", "in", yearSet));
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgId, (long)this.bookTypeId);
        if (bookInfo == null) {
            return;
        }
        qFilters.add(new QFilter("periodtype", "=", (Object)bookInfo.getPeriodTypeId()));
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id, number, periodnumber, periodyear, isadjustperiod", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"number");
        if (periodDataSet != null) {
            for (Row row : periodDataSet) {
                String periodYear = String.valueOf(row.getInteger("periodyear"));
                boolean isAdjustPeriod = row.getBoolean("isadjustperiod");
                String periodNumber = String.valueOf(row.getInteger("periodnumber"));
                if (isAdjustPeriod && Integer.parseInt(periodNumber) <= 12) {
                    periodNumber = periodNumber + "T";
                }
                if (this.periodFromYearMap.containsKey(String.valueOf(periodYear))) {
                    this.periodFromYearMap.get(periodYear).add(periodNumber);
                    continue;
                }
                ArrayList<String> periodNumberList = new ArrayList<String>(8);
                periodNumberList.add(periodNumber);
                this.periodFromYearMap.put(periodYear, periodNumberList);
            }
        }
        if (DebugTrace.enable()) {
            log.info("ReClassNumberIDParam_periodFromYearMap : " + this.periodFromYearMap);
        }
    }

    private void queryPeriodIdByBook(int comFy, int comPeriod, String comAdjustPeriod) {
        HashSet<Integer> yearList = new HashSet<Integer>(this.periodNumberSet.size());
        HashSet<String> periodList = new HashSet<String>(this.periodNumberSet.size());
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgId, (long)this.bookTypeId);
        if (bookInfo == null) {
            return;
        }
        HashMap negativePeriodMap = new HashMap(32);
        for (String str : this.periodNumberSet) {
            String periodAndYearKey;
            String[] yearAndPeriod;
            String[] yearPeriodNumber = str.split(",");
            if (yearPeriodNumber.length != 2) continue;
            String yearStr = yearPeriodNumber[0];
            String periodStr = yearPeriodNumber[1];
            if (!AcctUtil.checkPeriodFormat(periodStr) || (yearAndPeriod = (periodAndYearKey = AcctUtil.dealYearAndPeriod(periodStr, comPeriod, comAdjustPeriod, yearStr, comFy, this.periodFromYearMap)).split("-")).length != 2) continue;
            yearList.add(Integer.valueOf(yearAndPeriod[0]));
            periodList.add(yearAndPeriod[1]);
        }
        long periodTypeId = bookInfo.getPeriodTypeId();
        HashMap<Integer, Integer> yearMaxPeriodMap = new HashMap<Integer, Integer>(32);
        DataSet periodDataSet = this.queryPeriodByNumber("periodyear, periodnumber, id, isadjustperiod", yearList, periodList, periodTypeId);
        for (Row row : periodDataSet) {
            int maxPeriod;
            int year = row.getInteger("periodyear");
            int periodNumber = row.getInteger("periodnumber");
            boolean isAdjustPeriod = row.getBoolean("isadjustperiod");
            if (periodNumber >= 13) {
                this.periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
                this.periodIdsMap.put(year + "," + periodNumber + "T", row.getLong("id"));
            } else if (isAdjustPeriod) {
                this.periodIdsMap.put(year + "," + periodNumber + "T", row.getLong("id"));
            } else {
                this.periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
            }
            int n = maxPeriod = yearMaxPeriodMap.get(year) == null ? 1 : (Integer)yearMaxPeriodMap.get(year);
            if (periodNumber > maxPeriod) {
                maxPeriod = periodNumber;
            }
            yearMaxPeriodMap.put(year, maxPeriod);
        }
        if (!negativePeriodMap.isEmpty()) {
            for (Map.Entry nEntry : negativePeriodMap.entrySet()) {
                int year = (Integer)nEntry.getKey();
                Set periodNumberSet = (Set)nEntry.getValue();
                for (Integer nperiod : periodNumberSet) {
                    if (yearMaxPeriodMap.get(year) == null) continue;
                    int maxPeriod = (Integer)yearMaxPeriodMap.get(year);
                    int period = maxPeriod + nperiod;
                    if (this.periodIdsMap.get(year + "," + period) == null) continue;
                    long periodId = this.periodIdsMap.get(year + "," + period);
                    this.periodIdsMap.put(year + "," + nperiod, periodId);
                }
            }
        }
    }

    private DataSet queryPeriodByNumber(String selFields, Set<Integer> fys, Set<String> periodNumbers, long periodTypeId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter fperiodTypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter ffy = new QFilter("periodyear", "in", fys);
        filters.add(fperiodTypeId);
        filters.add(ffy);
        if (periodNumbers != null && periodNumbers.size() > 0) {
            HashSet<Integer> adjPeriodNumbers = new HashSet<Integer>(8);
            HashSet<Integer> nAdjPeriodNumbers = new HashSet<Integer>(8);
            for (String periodStr : periodNumbers) {
                if (!periodStr.endsWith("T") && Integer.parseInt(periodStr) <= 12) {
                    nAdjPeriodNumbers.add(Integer.parseInt(periodStr));
                    continue;
                }
                if (periodStr.endsWith("T")) {
                    adjPeriodNumbers.add(Integer.parseInt(periodStr.substring(0, periodStr.length() - 1)));
                    continue;
                }
                adjPeriodNumbers.add(Integer.parseInt(periodStr));
            }
            QFilter fperiod = null;
            if (!nAdjPeriodNumbers.isEmpty()) {
                fperiod = new QFilter("periodnumber", "in", nAdjPeriodNumbers).and(new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0')));
            }
            if (!adjPeriodNumbers.isEmpty()) {
                QFilter qFilter = fperiod = fperiod == null ? new QFilter("periodnumber", "in", adjPeriodNumbers) : fperiod.or(new QFilter("periodnumber", "in", adjPeriodNumbers));
            }
            if (fperiod != null) {
                filters.add(fperiod);
            }
        }
        DataSet periodSet = this.queryDataSet(this.getClass().getName(), "bd_period", selFields, filters.toArray(new QFilter[0]));
        return periodSet;
    }

    private void queryAcctId(QFilter facctBaseData) {
        PerformanceWatch watch = new PerformanceWatch(ReClassNumberIDParam.class, "queryAcctId", false);
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryAcctId acctNumberSet size " + this.acctNumberSet.size());
        QFilter filterAcctTable = new QFilter("accounttable", "=", (Object)this.acctTableId);
        QFilter fnumbers = new QFilter("number", "in", this.acctNumberSet);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(filterAcctTable);
        filters.add(facctBaseData.copy());
        filters.add(fnumbers);
        DataSet acctSet = ReClassUtils.queryDataSet("bd_accountview", "id, number, masterid,dc", filters);
        for (Row row : acctSet) {
            long acctId = row.getLong("id");
            String number = row.getString("number");
            this.acctNumberToIdsMap.put(number, acctId);
            this.acctMasterToDcMap.put(acctId, row.getString("dc"));
        }
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -ReClassNumberIDParam-: orgNumber+bookTypeNumber" + this.orgNumber + "," + this.bookTypeNumber + " queryAcctId acctRangeNumberSet size " + this.acctRangeNumberSet.size());
        boolean isOnlyRange = this.acctRangeNumberSet.size() == 1;
        ArrayList<String> allRangeNumbers = new ArrayList<String>(128);
        for (String acctRangeNumber : this.acctRangeNumberSet) {
            ArrayList<QFilter> rangFilters = new ArrayList<QFilter>(8);
            rangFilters.add(filterAcctTable);
            rangFilters.add(facctBaseData.copy());
            if (isOnlyRange) {
                log.info("ACCT\u91cd\u5206\u7c7b\u53d6\u6570isOnlyRange\uff1a" + facctBaseData.toString());
            }
            String key = acctRangeNumber;
            String[] acctContinueNumbers = (acctRangeNumber = acctRangeNumber.substring(1, acctRangeNumber.length() - 1)).split(",");
            DataSet rangeAcctSet = this.queryContinueNumber(Arrays.asList(acctContinueNumbers), rangFilters, "id,masterid,dc,level,number", "bd_accountview");
            if (rangeAcctSet == null) continue;
            HashSet<Long> acctIds = new HashSet<Long>(128);
            String cNumber = acctContinueNumbers[0];
            int cNumberLength = cNumber.length();
            for (Row row : rangeAcctSet) {
                String number = row.getString("number");
                allRangeNumbers.add(number);
                if (cNumberLength != number.length()) continue;
                String dc = row.getString("dc");
                long acctId = row.getLong("id");
                acctIds.add(acctId);
                this.acctMasterToDcMap.put(acctId, dc);
                this.acctNumberToIdsMap.put(number, acctId);
            }
            this.acctRangeKeyToIdsMap.put(key, acctIds);
        }
        watch.stop();
        log.info(watch.show());
        if (DebugTrace.enable()) {
            log.info("ACCT\u91cd\u5206\u7c7b\u53d6\u6570acctMasterToDcMap\uff1a" + this.acctMasterToDcMap.toString());
            log.info("ACCT\u91cd\u5206\u7c7b\u53d6\u6570acctNumberToIdsMap\uff1a" + this.acctNumberToIdsMap.toString());
            log.info("ACCT\u91cd\u5206\u7c7b\u53d6\u6570acctRangeKeyToIdsMap\uff1a" + this.acctRangeKeyToIdsMap.toString());
        }
        if (isOnlyRange) {
            log.info("ACCT\u91cd\u5206\u7c7b\u53d6\u6570isOnlyRange-allRangeNumbers\uff1a" + ((Object)allRangeNumbers).toString());
        }
    }

    private DataSet queryContinueNumber(List<String> acctNumbers, List<QFilter> filters, String sel, String entityName) {
        if (acctNumbers != null && acctNumbers.size() == 2) {
            String acctNumber0 = acctNumbers.get(0);
            String acctNumber1 = acctNumbers.get(1);
            String number = "number";
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            if (mainEntityType instanceof BasedataEntityType) {
                number = ((BasedataEntityType)mainEntityType).getNumberProperty();
            }
            QFilter filterMin = new QFilter(number, ">=", (Object)acctNumber0);
            QFilter filterMax = new QFilter(number, "<=", (Object)acctNumber1);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
            filterList.addAll(filters);
            filterList.add(filterMin);
            filterList.add(filterMax);
            DataSet acctSet = QueryServiceHelper.queryDataSet((String)"ReClassUtils.queryDataSet", (String)entityName, (String)sel, (QFilter[])filterList.toArray(new QFilter[0]), (String)number);
            return acctSet;
        }
        return null;
    }

    private DataSet queryDataSet(String algoKey, String entityId, String sel, QFilter[] filters) {
        DataSet assistSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityId, (String)sel, (QFilter[])filters, null);
        return assistSet;
    }

    private void querySeasonPeriodId(boolean isQueryAdjustPeriod) {
        String month;
        String year;
        HashSet<Integer> periodYearSet = new HashSet<Integer>(this.periodYearAndMonthSet.size());
        for (String periodYearAndMonth : this.periodYearAndMonthSet) {
            String[] yearAndMonth = periodYearAndMonth.split(",");
            if (yearAndMonth.length != 2) continue;
            periodYearSet.add(Integer.parseInt(yearAndMonth[0]));
        }
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgId, (long)this.bookTypeId);
        long periodTypeId = bookInfo.getPeriodTypeId();
        DataSet dataSet = this.queryPeriodByNumber("periodyear, periodnumber, id, isadjustperiod", periodYearSet, null, periodTypeId);
        HashMap<String, String> maxNoAdjustPeriodKeyMap = new HashMap<String, String>(8);
        HashMap<String, String> maxAdjustPeriodKeyMap = new HashMap<String, String>(8);
        HashMap<String, Long> maxAdjustPeriodIdMap = new HashMap<String, Long>(8);
        HashMap<String, Long> allPeriodIdMap = new HashMap<String, Long>(8);
        for (Row row : dataSet) {
            year = row.getString("periodyear");
            month = row.getString("periodnumber");
            Boolean isAdjustPeriod = row.getBoolean("isadjustperiod");
            Long periodId = row.getLong("id");
            if (!allPeriodIdMap.containsKey(year + "," + month) || isQueryAdjustPeriod && isAdjustPeriod != null && isAdjustPeriod.booleanValue()) {
                allPeriodIdMap.put(year + "," + month, periodId);
            }
            if (isAdjustPeriod != null && isAdjustPeriod.booleanValue()) {
                allPeriodIdMap.put(year + "," + month + "T", periodId);
                if (!StringUtils.isBlank((CharSequence)((CharSequence)maxAdjustPeriodKeyMap.get(year))) && Integer.parseInt(month) <= Integer.parseInt((String)maxAdjustPeriodKeyMap.get(year))) continue;
                maxAdjustPeriodKeyMap.put(year, month);
                maxAdjustPeriodIdMap.put(year, periodId);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)((CharSequence)maxNoAdjustPeriodKeyMap.get(year))) && Integer.parseInt(month) <= Integer.parseInt((String)maxNoAdjustPeriodKeyMap.get(year))) continue;
            maxNoAdjustPeriodKeyMap.put(year, month);
        }
        if (isQueryAdjustPeriod) {
            for (Map.Entry entry : maxAdjustPeriodKeyMap.entrySet()) {
                year = (String)entry.getKey();
                month = (String)entry.getValue();
                String noAdjustPeriodNum = (String)maxNoAdjustPeriodKeyMap.get(year);
                if (!StringUtils.isNotBlank((CharSequence)noAdjustPeriodNum) || Integer.parseInt(month) <= Integer.parseInt(noAdjustPeriodNum)) continue;
                allPeriodIdMap.put(year + "," + noAdjustPeriodNum, (Long)maxAdjustPeriodIdMap.get(year));
            }
        }
        for (String string : this.periodYearAndMonthSet) {
            if (allPeriodIdMap.get(string) == null) continue;
            this.seasonPeriodIdMap.put(string, (Long)allPeriodIdMap.get(string));
        }
    }

    private Map<String, String> queryAssistNumToValType() {
        HashMap<String, String> assistNumToValTypeMap = new HashMap<String, String>(8);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ASSIST_TYPE, (String)"number, valuetype", null, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            assistNumToValTypeMap.put(row.getString("number"), row.getString(VALUETYPE));
        }
        return assistNumToValTypeMap;
    }

    public Set<String> getOrgNumberSet() {
        return this.orgNumberSet;
    }

    public void setOrgNumberSet(Set<String> orgNumberSet) {
        this.orgNumberSet = orgNumberSet;
    }

    public Set<String> getBookTypeNumberSet() {
        return this.bookTypeNumberSet;
    }

    public void setBookTypeNumberSet(Set<String> bookTypeNumberSet) {
        this.bookTypeNumberSet = bookTypeNumberSet;
    }

    public Set<String> getCurrencyNumberSet() {
        return this.currencyNumberSet;
    }

    public void setCurrencyNumberSet(Set<String> currencyNumberSet) {
        this.currencyNumberSet = currencyNumberSet;
    }

    public Set<String> getPeriodNumberSet() {
        return this.periodNumberSet;
    }

    public void setPeriodNumberSet(Set<String> periodNumberSet) {
        this.periodNumberSet = periodNumberSet;
    }

    public Set<String> getAcctNumberSet() {
        return this.acctNumberSet;
    }

    public void setAcctNumberSet(Set<String> acctNumberSet) {
        this.acctNumberSet = acctNumberSet;
    }

    public Map<String, Long> getOrgNumberToIdsMap() {
        return this.orgNumberToIdsMap;
    }

    public void setOrgNumberToIdsMap(Map<String, Long> orgNumberToIdsMap) {
        this.orgNumberToIdsMap = orgNumberToIdsMap;
    }

    public Map<String, Long> getBookTypeNumberToIdsMap() {
        return this.bookTypeNumberToIdsMap;
    }

    public void setBookTypeNumberToIdsMap(Map<String, Long> bookTypeNumberToIdsMap) {
        this.bookTypeNumberToIdsMap = bookTypeNumberToIdsMap;
    }

    public Map<String, Long> getCurrencyNumberToIdsMap() {
        return this.currencyNumberToIdsMap;
    }

    public void setCurrencyNumberToIdsMap(Map<String, Long> currencyNumberToIdsMap) {
        this.currencyNumberToIdsMap = currencyNumberToIdsMap;
    }

    public Map<Long, String> getAcctMasterToDcMap() {
        return this.acctMasterToDcMap;
    }

    public Map<String, Long> getAcctNumberToIdsMap() {
        return this.acctNumberToIdsMap;
    }

    public void setAcctNumberToIdsMap(Map<String, Long> acctNumberToIdsMap) {
        this.acctNumberToIdsMap = acctNumberToIdsMap;
    }

    public Map<String, Long> getPeriodIdsMap() {
        return this.periodIdsMap;
    }

    public void setPeriodIdsMap(Map<String, Long> periodIdsMap) {
        this.periodIdsMap = periodIdsMap;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public long getBookTypeId() {
        return this.bookTypeId;
    }

    public long getAcctTableId() {
        return this.acctTableId;
    }

    public Set<String> getAcctRangeNumberSet() {
        return this.acctRangeNumberSet;
    }

    public void setAcctRangeNumberSet(Set<String> acctRangeNumberSet) {
        this.acctRangeNumberSet = acctRangeNumberSet;
    }

    public Map<String, Set<String>> getAssistToValNumbersMap() {
        return this.assistToValNumbersMap;
    }

    public void setAssistToValNumbersMap(Map<String, Set<String>> assistToValNumbersMap) {
        this.assistToValNumbersMap = assistToValNumbersMap;
    }

    public Map<String, AssistIdCollectionType> getAssistValCollectionMap() {
        return this.assistValCollectionMap;
    }

    public Map<String, Set<String>> getAssistToValRangeNumbersMap() {
        return this.assistToValRangeNumbersMap;
    }

    public void setAssistToValRangeNumbersMap(Map<String, Set<String>> assistToValRangeNumbersMap) {
        this.assistToValRangeNumbersMap = assistToValRangeNumbersMap;
    }

    public Map<String, Set<Long>> getAcctRangeKeyToIdsMap() {
        return this.acctRangeKeyToIdsMap;
    }

    public void setAcctRangeKeyToIdsMap(Map<String, Set<Long>> acctRangeKeyToIdsMap) {
        this.acctRangeKeyToIdsMap = acctRangeKeyToIdsMap;
    }

    public Map<Long, Set<Long>> getAcctToDirectLeafMap() {
        return this.acctToDirectLeafMap;
    }

    public void setAcctToDirectLeafMap(Map<Long, Set<Long>> acctToDirectLeafMap) {
        this.acctToDirectLeafMap = acctToDirectLeafMap;
    }

    public Map<Long, Set<Long>> getAcctToAllLeafMap() {
        return this.acctToAllLeafMap;
    }

    public void setAcctToAllLeafMap(Map<Long, Set<Long>> acctToAllLeafMap) {
        this.acctToAllLeafMap = acctToAllLeafMap;
    }

    public Map<Long, Set<String>> getAcctToFlexsMap() {
        return this.acctToFlexsMap;
    }

    public void setAcctToFlexsMap(Map<Long, Set<String>> acctToFlexsMap) {
        this.acctToFlexsMap = acctToFlexsMap;
    }

    public Map<Long, String> getAcctToNumberMap() {
        return this.acctToNumberMap;
    }

    public void setAcctToNumberMap(Map<Long, String> acctToNumberMap) {
        this.acctToNumberMap = acctToNumberMap;
    }

    public Map<String, String> getAssistToFlexMap() {
        return this.assistToFlexMap;
    }

    public void setAssistToFlexMap(Map<String, String> assistToFlexMap) {
        this.assistToFlexMap = assistToFlexMap;
    }

    public Map<String, Object> getassistValNumberToObjMap() {
        return this.assistValNumberToObjMap;
    }

    public void setassistValNumberToObjMap(Map<String, Object> assistValNumberToObjMap) {
        this.assistValNumberToObjMap = assistValNumberToObjMap;
    }

    public Map<String, Set<Object>> getassistValRangeNumberToObjsMap() {
        return this.assistValRangeNumberToObjsMap;
    }

    public void setassistValRangeNumberToObjsMap(Map<String, Set<Object>> assistValRangeNumberToObjsMap) {
        this.assistValRangeNumberToObjsMap = assistValRangeNumberToObjsMap;
    }

    public Map<String, DataSet> getFlexToIDHgSet() {
        return this.flexToIDHgSet;
    }

    public void setFlexToIDHgSet(Map<String, DataSet> flexToIDHgSet) {
        this.flexToIDHgSet = flexToIDHgSet;
    }

    public String getBookTypeNumber() {
        return this.bookTypeNumber;
    }

    public void setBookTypeNumber(String bookTypeNumber) {
        this.bookTypeNumber = bookTypeNumber;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public void setBookTypeId(long bookTypeId) {
        this.bookTypeId = bookTypeId;
    }

    public void setAcctTableId(long acctTableId) {
        this.acctTableId = acctTableId;
    }

    public Set<String> getAssistNumberAllVal() {
        return this.assistNumberAllVal;
    }

    public void setAssistNumberAllVal(Set<String> assistNumberAllVal) {
        this.assistNumberAllVal = assistNumberAllVal;
    }

    public void setErrorInfoMap(Map<String, Map<String, Object>> errorInfoMap) {
        this.errorInfoMap = errorInfoMap;
    }

    public Map<String, Map<String, Object>> getErrorInfoMap() {
        return this.errorInfoMap;
    }

    public Set<String> getFlexAllVal() {
        return this.flexAllVal;
    }

    public void setFlexAllVal(Set<String> flexAllVal) {
        this.flexAllVal = flexAllVal;
    }

    public Map<Long, Long> getAcctIdToMasterIdMap() {
        return this.acctIdToMasterIdMap;
    }

    public void setAcctIdToMasterIdMap(Map<Long, Long> acctIdToMasterIdMap) {
        this.acctIdToMasterIdMap = acctIdToMasterIdMap;
    }

    public Map<String, String> getFlexToAssistEntityMap() {
        return this.flexToAssistEntityMap;
    }

    public void setFlexToAssistEntityMap(Map<String, String> flexToAssistEntityMap) {
        this.flexToAssistEntityMap = flexToAssistEntityMap;
    }

    public Map<String, Set<Long>> getFlexsToAcctIdsMap() {
        return this.flexsToAcctIdsMap;
    }

    public void setFlexsToAcctIdsMap(Map<String, Set<Long>> flexsToAcctIdsMap) {
        this.flexsToAcctIdsMap = flexsToAcctIdsMap;
    }

    public Set<String> getPeriodYearAndMonthSet() {
        return this.periodYearAndMonthSet;
    }

    public void setPeriodYearAndMonthSet(Set<String> periodYearAndMonthSet) {
        this.periodYearAndMonthSet = periodYearAndMonthSet;
    }

    public Map<String, Long> getSeasonPeriodIdMap() {
        return this.seasonPeriodIdMap;
    }

    public void setSeasonPeriodIdMap(Map<String, Long> seasonPeriodIdMap) {
        this.seasonPeriodIdMap = seasonPeriodIdMap;
    }

    public Map<String, Set<Long>> getAssistFieldValToIdMap() {
        return this.assistFieldValToIdMap;
    }

    public Map<String, Set<String>> getFieldToEntryFieldMap() {
        return this.fieldToEntryFieldMap;
    }

    public Map<String, List<String>> getPeriodFromYearMap() {
        return this.periodFromYearMap;
    }

    public void setPeriodFromYearMap(Map<String, List<String>> periodFromYearMap) {
        this.periodFromYearMap = periodFromYearMap;
    }

    public Table<String, String, Set<Long>> getComAssistToValueIdTable() {
        return this.comAssistToValueIdTable;
    }

    public void setComAssistToValueIdTable(Table<String, String, Set<Long>> comAssistToValueIdTable) {
        this.comAssistToValueIdTable = comAssistToValueIdTable;
    }

    public Table<String, String, Set<Long>> getComAssistToValRangeIdTable() {
        return this.comAssistToValRangeIdTable;
    }

    public void setComAssistToValRangeIdTable(Table<String, String, Set<Long>> comAssistToValRangeIdTable) {
        this.comAssistToValRangeIdTable = comAssistToValRangeIdTable;
    }

    public boolean isExistNonCollectionType() {
        return !this.assistValNumberToObjMap.isEmpty() || !this.assistValRangeNumberToObjsMap.isEmpty();
    }
}

