/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.param;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.JSONUtils;
import kd.fi.gl.acct.AcctUtil;

public class ReClassParam {
    private String orgNumber;
    private int fy;
    private int period;
    private String adjustPeriod;
    private int acctReClass;
    private String formulaName;
    private Map<String, Object> commParamMap;
    private Map<String, Object> acctFormulaMap;
    private List<String> scopePeriods;
    private String comAssistStr;

    public ReClassParam(String acctParamStr) {
        try {
            Map acctMap = (Map)JSONUtils.cast((String)acctParamStr, Map.class);
            this.acctFormulaMap = (Map)acctMap.get("param");
            this.commParamMap = (Map)acctMap.get("commParam");
            if (this.commParamMap == null) {
                return;
            }
            this.fy = (Integer)this.commParamMap.get("fy");
            this.orgNumber = (String)this.commParamMap.get("org");
            if (this.commParamMap.get("period") instanceof String) {
                this.adjustPeriod = AcctUtil.getPeriodParam((String)this.commParamMap.get("period"));
                this.period = 0;
            } else {
                this.period = (Integer)this.commParamMap.get("period");
                this.adjustPeriod = "";
            }
            this.acctReClass = (Integer)this.commParamMap.getOrDefault("accountreclass", 6);
            this.scopePeriods = (List)this.commParamMap.get("scopePeriod");
            this.comAssistStr = AcctUtil.getComAssistFromBCM(acctMap);
        }
        catch (Exception ex) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s \u5f02\u5e38\u4fe1\u606f\uff1a%2$s", (String)"ReClassParam_0", (String)"fi-gl-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u6709\u8bef", (String)"ReClassParam_1", (String)"fi-gl-mservice", (Object[])new Object[0]), ex));
        }
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public int getFy() {
        return this.fy;
    }

    public void setFy(int fy) {
        this.fy = fy;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getAdjustPeriod() {
        return this.adjustPeriod;
    }

    public void setAdjustPeriod(String adjustPeriod) {
        this.adjustPeriod = adjustPeriod;
    }

    public int getAcctReClass() {
        return this.acctReClass;
    }

    public void setAcctReClass(int acctReClass) {
        this.acctReClass = acctReClass;
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public Map<String, Object> getCommParamMap() {
        return this.commParamMap;
    }

    public void setCommParamMap(Map<String, Object> commParamMap) {
        this.commParamMap = commParamMap;
    }

    public Map<String, Object> getAcctFormulaMap() {
        return this.acctFormulaMap;
    }

    public void setAcctFormulaMap(Map<String, Object> acctFormulaMap) {
        this.acctFormulaMap = acctFormulaMap;
    }

    public List<String> getScopePeriods() {
        return this.scopePeriods;
    }

    public void setScopePeriods(List<String> scopePeriods) {
        this.scopePeriods = scopePeriods;
    }

    public String getComAssistStr() {
        return this.comAssistStr;
    }

    public void setComAssistStr(String comAssistStr) {
        this.comAssistStr = comAssistStr;
    }
}

