/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acctfloat;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.acct.combination.AssistCombination;
import kd.fi.gl.acct.param.AcctReClassAmountKey;
import kd.fi.gl.acct.param.BCMBalanceIndexParam;
import kd.fi.gl.acctfloat.AcctFloatContext;
import kd.fi.gl.acctfloat.AcctFloatQueryFormula;
import kd.fi.gl.acctfloat.AcctFloatQueryParam;
import kd.fi.gl.acctfloat.AcctQueryExecutor;
import kd.fi.gl.exception.BOSException;

public class AcctFloatQueryServiceImpl
implements AcctQueryExecutor {
    private final Log log = LogFactory.getLog((String)"AcctFloatQueryServiceImpl");

    @Override
    public String getBalance(String param) {
        AcctFloatQueryParam acctFloatQueryParam = new AcctFloatQueryParam(param);
        if (DebugTrace.enable()) {
            this.printLog(acctFloatQueryParam);
        }
        List<AcctFloatQueryFormula> formulas = this.parseFormulas(acctFloatQueryParam);
        this.checkFormulaSizeLimit(formulas);
        this.checkFormulaFormat(formulas);
        ArrayList<AcctFloatQueryFormula> legalFormulas = new ArrayList<AcctFloatQueryFormula>(formulas.size());
        formulas.forEach(formula -> {
            if (StringUtils.isBlank((CharSequence)formula.getErrorMsg())) {
                legalFormulas.add((AcctFloatQueryFormula)formula);
            }
        });
        AcctFloatContext ctx = new AcctFloatContext(acctFloatQueryParam, legalFormulas);
        for (AcctFloatQueryFormula formula2 : legalFormulas) {
            formula2.setErrorMsg(this.checkFormula(ctx, formula2));
            if (StringUtils.isNotBlank((CharSequence)formula2.getErrorMsg())) continue;
            HashMap<Long, Integer> acctToAssistStyleMap = new HashMap<Long, Integer>();
            HashMap<Long, Set<Long>> acctToReClassAcctIdsMap = new HashMap<Long, Set<Long>>();
            this.dealReClassAccount(ctx, formula2, acctToAssistStyleMap, acctToReClassAcctIdsMap);
            DataSet balance = this.getBalanceByAssist(ctx, formula2, acctToReClassAcctIdsMap);
            this.reClassBalance(ctx, formula2, balance, acctToReClassAcctIdsMap, acctToAssistStyleMap);
        }
        return this.getResult(formulas);
    }

    private void checkFormulaSizeLimit(List<AcctFloatQueryFormula> formulas) {
        int formulaSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.acct.float.formula.size", (int)500);
        if (formulas != null && formulas.size() > formulaSize) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u7684\u6d6e\u52a8\u516c\u5f0f\u6570\u91cf\u8d85\u51fa\u9650\u5236%1$d", (String)"AcccurrentParseAction_3", (String)"fi-gl-mservice", (Object[])new Object[0]), formulaSize));
        }
    }

    private void printLog(AcctFloatQueryParam acctFloatQueryParam) {
        this.log.info(String.format("ACCT param\uff1a%s,org number\uff1a%s,period\uff1a%s,assist param\uff1a%s", acctFloatQueryParam.getComAcctReClass(), acctFloatQueryParam.getComOrgNumber(), acctFloatQueryParam.getComPeriod(), acctFloatQueryParam.getRefParamMap()));
        Map<String, Object> formulaMap = acctFloatQueryParam.getAcctFormulaMap();
        int logIndex = 1;
        int logCount = 1;
        StringBuilder logBuilder = new StringBuilder();
        if (formulaMap.size() > 1000) {
            this.log.info("ACCT formula size\uff1a" + formulaMap.size());
            return;
        }
        for (Map.Entry<String, Object> entry : formulaMap.entrySet()) {
            if (logCount > 100) {
                logBuilder.append(entry);
                this.log.info("ACCT formula" + logIndex + "\uff1a" + logBuilder);
                logBuilder = new StringBuilder();
                ++logIndex;
                logCount = 0;
                continue;
            }
            logBuilder.append(entry);
            ++logCount;
        }
        if (logIndex == 1) {
            this.log.info("ACCT formula\uff1a" + logBuilder);
        } else {
            this.log.info("ACCT formula" + logIndex + "\uff1a" + logBuilder);
        }
    }

    private List<AcctFloatQueryFormula> parseFormulas(AcctFloatQueryParam acctParam) {
        Map<String, Object> formulaMap = acctParam.getAcctFormulaMap();
        ArrayList<AcctFloatQueryFormula> formulas = new ArrayList<AcctFloatQueryFormula>(formulaMap.size());
        for (Map.Entry<String, Object> formulaEntry : formulaMap.entrySet()) {
            String formulaKey = formulaEntry.getKey();
            List formulaParam = (List)formulaEntry.getValue();
            formulas.add(new AcctFloatQueryFormula(acctParam, formulaKey, formulaParam));
        }
        return formulas;
    }

    private void checkFormulaFormat(List<AcctFloatQueryFormula> formulas) {
        for (AcctFloatQueryFormula formula : formulas) {
            HashSet<String> accountNumberSet = new HashSet<String>(formula.getAccountNumberToDynMap().keySet());
            accountNumberSet.addAll(formula.getAccountContinueNumberSet());
            String errorMsg = this.checkAccountFormat(accountNumberSet);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                formula.setErrorMsg(errorMsg);
                continue;
            }
            errorMsg = this.checkAssistRangeValFormat(formula.getAssistToRangeValueMap());
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                formula.setErrorMsg(errorMsg);
                continue;
            }
            errorMsg = this.checkFetchTypeFormat(formula.getFetchType());
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                formula.setErrorMsg(errorMsg);
                continue;
            }
            errorMsg = this.checkPeriodFormat(formula.getPeriod());
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                formula.setErrorMsg(errorMsg);
                continue;
            }
            errorMsg = this.checkComAssistFormat(formula.getComAssistStr());
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                formula.setErrorMsg(errorMsg);
                continue;
            }
            errorMsg = this.checkFloatAssistFormat(formula.getFloatAssistNumberList(), formula.getAssistToValueNumberMap());
            if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
            formula.setErrorMsg(errorMsg);
        }
    }

    private String checkFormula(AcctFloatContext ctx, AcctFloatQueryFormula formula) {
        if (StringUtils.isNotBlank((CharSequence)formula.getErrorMsg())) {
            return formula.getErrorMsg();
        }
        String orgNumber = formula.getOrgNumber();
        String errorMsg = this.checkOrg(ctx.getOrgNumberToIdMap(), orgNumber);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = AcctUtil.checkPermByOrgId(orgNumber, ctx.getPermName(), ctx.getOrgNumberToIdMap().get(orgNumber), ctx.getAllPermOrgIdSet());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkBookType(ctx.getBookTypeNumberToIdMap(), formula.getBookTypeNumber());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkAccountBook(ctx.getAccountBookMap(), orgNumber, formula.getBookTypeNumber());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkPeriod(ctx.getPeriodMap(), formula.getFormulaKey());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkAccount(formula.getAccountNumberToDynMap());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkAssist(formula, ctx.getAssistMap());
        return errorMsg;
    }

    private void dealReClassAccount(AcctFloatContext ctx, AcctFloatQueryFormula formula, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap) {
        int reClassType = formula.getReClassType();
        Map<String, DynamicObject> accountNumberMap = formula.getAccountNumberToDynMap();
        HashSet<Long> accountIdSet = new HashSet<Long>(accountNumberMap.size());
        for (Map.Entry<String, DynamicObject> accountDynEntry : accountNumberMap.entrySet()) {
            DynamicObject accountDyn = accountDynEntry.getValue();
            if (accountDyn == null) continue;
            accountIdSet.add(accountDyn.getLong("id"));
        }
        if (!BCMBalanceIndexParam.getFetchTypeReclass().contains(formula.getFetchType())) {
            Map<Long, Set<Long>> allDetailedAccountMap = ctx.getAllDetailedAccountMap();
            for (Long accountId : accountIdSet) {
                acctToAssistStyleMap.put(accountId, 2);
                acctToReClassAcctIdsMap.put(accountId, allDetailedAccountMap.get(accountId));
            }
        } else {
            this.acctReClassDeal(reClassType, accountIdSet, acctToAssistStyleMap, acctToReClassAcctIdsMap, ctx, formula.getAssistToValueNumberMap().keySet());
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatQueryServiceImpl_dealReClassAccount acctToReClassAcctIdsMap\uff1a" + acctToReClassAcctIdsMap);
            this.log.info("AcctFloatQueryServiceImpl_dealReClassAccount acctToAssistStyleMap\uff1a" + acctToAssistStyleMap);
        }
    }

    private DataSet getBalanceByAssist(AcctFloatContext ctx, AcctFloatQueryFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap) {
        long startTime = System.currentTimeMillis();
        DataSet balance = this.queryBalanceByORM(ctx, formula, acctToReClassAcctIdsMap);
        long endTime = System.currentTimeMillis();
        this.log.info("get balance cost time\uff1a" + (endTime - startTime));
        return balance;
    }

    private void reClassBalance(AcctFloatContext ctx, AcctFloatQueryFormula formula, DataSet balance, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, Integer> acctToAssistStyleMap) {
        long startTime = System.currentTimeMillis();
        Table<String, String, Map<Object, Set<String>>> assistValIdToNumTable = ctx.getAssistValIdToNumTable();
        Map assistValIdToNumMap = assistValIdToNumTable.row((Object)formula.getOrgNumber());
        Object[] balanceFieldIndex = this.getBalanceFieldIndex(formula, ctx.getCurrencyNumberToIdMap());
        if (Objects.nonNull(balanceFieldIndex)) {
            this.sumBalanceByAssist(balance, formula, ctx.getAssistMap(), balanceFieldIndex, assistValIdToNumMap, acctToAssistStyleMap, acctToReClassAcctIdsMap, ctx.getAccountIdToNumberMap());
        }
        long endTime = System.currentTimeMillis();
        this.log.info("sum balance cost all time\uff1a" + (endTime - startTime));
    }

    private String getResult(List<AcctFloatQueryFormula> formulas) {
        try {
            HashMap resultMap = new HashMap(8);
            for (AcctFloatQueryFormula formula : formulas) {
                HashMap<String, Object> acctValueMap = new HashMap<String, Object>(8);
                if (StringUtils.isBlank((CharSequence)formula.getErrorMsg())) {
                    acctValueMap.put("v", this.getAmountResult(formula));
                    acctValueMap.put("success", true);
                    acctValueMap.put("failmsg", null);
                } else {
                    acctValueMap.put("v", null);
                    acctValueMap.put("success", false);
                    acctValueMap.put("failmsg", formula.getErrorMsg());
                }
                resultMap.put(formula.getFormulaKey(), acctValueMap);
            }
            return JSONUtils.toString(resultMap);
        }
        catch (IOException e) {
            this.log.error("acctFloat_getResult:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new BOSException((Throwable)e);
        }
    }

    private String checkAccountFormat(Set<String> accountNumberSet) {
        if (accountNumberSet.isEmpty()) {
            return ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AcctFloatQueryServiceImpl_4", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkAssistRangeValFormat(Map<String, List<String>> assistToRangeValueMap) {
        for (List<String> rangeValueList : assistToRangeValueMap.values()) {
            for (String rangeValue : rangeValueList) {
                if (rangeValue.split(",").length == 2 || rangeValue.split("#").length == 2) continue;
                return String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u503c\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AcctFloatQueryServiceImpl_8", (String)"fi-gl-mservice", (Object[])new Object[0]), rangeValue);
            }
        }
        return "";
    }

    private String checkFetchTypeFormat(String fetchType) {
        if (StringUtils.isBlank((CharSequence)fetchType)) {
            return ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AcctFloatQueryServiceImpl_6", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        if (!BCMBalanceIndexParam.getFetchTypeField().containsKey(fetchType) && !BCMBalanceIndexParam.getFetchTypeForField().containsKey(fetchType)) {
            return ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"AcctFloatQueryServiceImpl_14", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkPeriodFormat(String period) {
        if (!AcctUtil.checkPeriodFormat(period)) {
            return ResManager.loadKDString((String)"\u671f\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AcctFloatQueryServiceImpl_11", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkComAssistFormat(String comAssistStr) {
        if (!AcctUtil.checkComAssistFormat(comAssistStr, Boolean.FALSE)) {
            return ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AcctFloatQueryServiceImpl_12", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkFloatAssistFormat(List<String> floatAssistNumberList, Map<String, List<String>> assistToValueNumberMap) {
        for (String floatAssistNum : floatAssistNumberList) {
            if (!CollectionUtils.isEmpty((Collection)assistToValueNumberMap.get(floatAssistNum))) continue;
            return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6d6e\u52a8\u7c7b\u578b\u5bf9\u5e94\u7684\u6d6e\u52a8\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AcctFloatQueryServiceImpl_13", (String)"fi-gl-mservice", (Object[])new Object[0]), floatAssistNum);
        }
        return "";
    }

    private String checkOrg(Map<String, Long> orgNumberToIdMap, String orgNumber) {
        if (!orgNumberToIdMap.containsKey(orgNumber)) {
            return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u672a\u627e\u5230\u76f8\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"AcctFloatQueryServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNumber);
        }
        return "";
    }

    private String checkBookType(Map<String, Long> bookTypeNumberToIdMap, String bookTypeNumber) {
        if (!bookTypeNumberToIdMap.containsKey(bookTypeNumber)) {
            return String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u201c%s\u201d\u672a\u627e\u5230\u76f8\u5e94\u8d26\u7c3f\u7c7b\u578b\u4fe1\u606f\u3002", (String)"AcctFloatQueryServiceImpl_2", (String)"fi-gl-mservice", (Object[])new Object[0]), bookTypeNumber);
        }
        return "";
    }

    private String checkAccountBook(Map<String, DynamicObject> accountBookMap, String orgNumber, String bookTypeNumber) {
        DynamicObject accountBookInfo = accountBookMap.get(orgNumber + "*" + bookTypeNumber);
        if (accountBookInfo == null) {
            return String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ec4\u7ec7\u7f16\u7801\u201c%1$s\u201d\uff0c\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u201c%2$s\u201d\uff0c\u5bf9\u5e94\u7684\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"AcctFloatQueryServiceImpl_3", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNumber, bookTypeNumber);
        }
        return "";
    }

    private String checkPeriod(Map<String, List<DynamicObject>> periodMap, String formulaKey) {
        if (periodMap.isEmpty() || CollectionUtils.isEmpty((Collection)periodMap.get(formulaKey)) || periodMap.get(formulaKey).stream().anyMatch(Objects::isNull)) {
            return ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u671f\u95f4\uff0c\u8bf7\u67e5\u770b\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u662f\u5426\u6b63\u786e", (String)"AcctFloatQueryServiceImpl_7", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkAccount(Map<String, DynamicObject> accountNumberToDynMap) {
        accountNumberToDynMap.entrySet().removeIf(accountNumberToDynEntry -> accountNumberToDynEntry.getValue() == null);
        if (accountNumberToDynMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u516c\u5f0f\u8bbe\u7f6e\u7684\u79d1\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AcctFloatQueryServiceImpl_9", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkAssist(AcctFloatQueryFormula formula, Map<String, DynamicObject> assistMap) {
        HashSet<String> allAssistNumber = new HashSet<String>(formula.getAssistToValueNumberMap().keySet());
        allAssistNumber.addAll(formula.getAssistToRangeValueMap().keySet());
        allAssistNumber.addAll(formula.getAllValueAssistNumberSet());
        for (String assistNumber : allAssistNumber) {
            if (assistMap.get(assistNumber) != null) continue;
            return String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AcctFloatQueryServiceImpl_10", (String)"fi-gl-mservice", (Object[])new Object[0]), assistNumber);
        }
        return "";
    }

    private void acctReClassDeal(int reClassType, Set<Long> accountIdSet, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap, AcctFloatContext ctx, Set<String> assistNumberSet) {
        Map<Long, Set<Long>> directChildAccountMap = ctx.getDirectChildAccountMap();
        Map<Long, Set<Long>> allDetailedAccountMap = ctx.getAllDetailedAccountMap();
        Map<Long, Set<String>> accountToAssistMap = ctx.getAccountIdToFlexFieldMap();
        boolean isSelectAssist = !assistNumberSet.isEmpty();
        switch (reClassType) {
            case 1: {
                for (Long accountId : accountIdSet) {
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    if (isSelectAssist) {
                        HashSet<Long> acctIds = new HashSet<Long>();
                        acctIds.add(accountId);
                        acctToReClassAcctIdsMap.put(accountId, acctIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        Set<Long> directLeafIds = directChildAccountMap.get(accountId);
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    Set<Long> allLeafIds = allDetailedAccountMap.get(accountId);
                    acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                    acctToAssistStyleMap.put(accountId, 3);
                }
                break;
            }
            case 2: {
                for (Long accountId : accountIdSet) {
                    Set<Long> allLeafIds;
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    if (isSelectAssist) {
                        allLeafIds = allDetailedAccountMap.get(accountId);
                        acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        allLeafIds = allDetailedAccountMap.get(accountId);
                        acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                        acctToAssistStyleMap.put(accountId, 3);
                        continue;
                    }
                    allLeafIds = allDetailedAccountMap.get(accountId);
                    acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                    acctToAssistStyleMap.put(accountId, 3);
                }
                break;
            }
            case 3: {
                for (Long accountId : accountIdSet) {
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    Set<Long> directLeafIds = directChildAccountMap.get(accountId);
                    if (isSelectAssist) {
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                    acctToAssistStyleMap.put(accountId, 3);
                }
                break;
            }
            case 4: {
                for (Long accountId : accountIdSet) {
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    Set<Long> allLeafIds = allDetailedAccountMap.get(accountId);
                    acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                    if (isSelectAssist) {
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    acctToAssistStyleMap.put(accountId, 1);
                }
                break;
            }
            case 5: {
                for (Long accountId : accountIdSet) {
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    Set<Long> directLeafIds = directChildAccountMap.get(accountId);
                    if (isSelectAssist) {
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                    acctToAssistStyleMap.put(accountId, 1);
                }
                break;
            }
            case 6: {
                for (Long accountId : accountIdSet) {
                    HashSet<Long> acctIds;
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    if (isSelectAssist) {
                        Set<Long> allLeafIds = allDetailedAccountMap.get(accountId);
                        acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctIds = new HashSet<Long>();
                        acctIds.add(accountId);
                        acctToReClassAcctIdsMap.put(accountId, acctIds);
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    acctIds = new HashSet();
                    acctIds.add(accountId);
                    acctToReClassAcctIdsMap.put(accountId, acctIds);
                    acctToAssistStyleMap.put(accountId, 1);
                }
                break;
            }
        }
    }

    private boolean acctIsContainAssistMap(Map<Long, Set<String>> accountToAssistMap, long accountId) {
        boolean isContainAssist = true;
        Set<String> flexFields = accountToAssistMap.get(accountId);
        if (flexFields == null || flexFields.isEmpty()) {
            isContainAssist = false;
        }
        return isContainAssist;
    }

    private DataSet queryBalanceByORM(AcctFloatContext ctx, AcctFloatQueryFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap) {
        String fetchType;
        List<String> fieldList;
        boolean isBaseCurrency = true;
        String currencyNumber = formula.getCurrency();
        if (StringUtils.isNotBlank((CharSequence)currencyNumber) && ctx.getCurrencyNumberToIdMap().get(currencyNumber) != null) {
            isBaseCurrency = false;
        }
        HashSet<String> sumFields = new HashSet<String>();
        Map<String, List<String>> fetchjtypeFieldMap = BCMBalanceIndexParam.getFetchTypeField();
        if (!isBaseCurrency) {
            fetchjtypeFieldMap = BCMBalanceIndexParam.getFetchTypeForField();
        }
        if ((fieldList = fetchjtypeFieldMap.get(fetchType = formula.getFetchType())) != null) {
            sumFields.addAll(fieldList);
        }
        boolean isReClass = BCMBalanceIndexParam.getFetchTypeReclass().contains(fetchType);
        String selector = this.buildSelectFields(formula, isBaseCurrency, sumFields, isReClass, Boolean.TRUE);
        Object[] orgIds = new Long[]{ctx.getOrgNumberToIdMap().get(formula.getOrgNumber())};
        DynamicObject accountBookInfo = ctx.getAccountBookMap().get(formula.getOrgNumber() + "*" + formula.getBookTypeNumber());
        long bookTypeId = accountBookInfo.getLong("bookstype.id");
        Long accountTableId = ctx.getAccountTableIdMap().get(formula.getFormulaKey());
        List<DynamicObject> periodDyns = ctx.getPeriodMap().get(formula.getFormulaKey());
        long beginPeriodId = periodDyns.get(0).getLong("id");
        long endPeriodId = periodDyns.get(periodDyns.size() - 1).getLong("id");
        HashSet<String> allAssistNumberSet = new HashSet<String>(formula.getAssistToValueNumberMap().keySet());
        allAssistNumberSet.addAll(formula.getAssistToRangeValueMap().keySet());
        if (isReClass) {
            allAssistNumberSet.addAll(formula.getAllValueAssistNumberSet());
        }
        QueryParam param = this.buildGetBalanceParamByORM(ctx, formula, acctToReClassAcctIdsMap, isReClass, allAssistNumberSet);
        Map<String, DynamicObject> assistMap = ctx.getAssistMap();
        StringBuilder assgrpStr = new StringBuilder();
        for (String assistNumber : allAssistNumberSet) {
            DynamicObject assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            assgrpStr.append(",");
            assgrpStr.append(" assgrp_");
            assgrpStr.append(assistDyn.getString("flexfield"));
            assgrpStr.append(".assval ");
            assgrpStr.append(assistDyn.getString("flexfield"));
        }
        selector = selector + assgrpStr;
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatQueryServiceImpl_queryBalanceByORM getBalance param\uff1aselector=" + selector + " ,orgIds=" + Arrays.toString(orgIds) + " ,accountTableId=" + accountTableId + " ,beginPeriodId=" + beginPeriodId + " ,endPeriodId=" + endPeriodId + " ,param=" + param);
        }
        DataSet balance = BalanceQueryExecutor.getInstance().getBalance(selector, (Long[])orgIds, bookTypeId, accountTableId.longValue(), beginPeriodId, endPeriodId, param);
        balance = this.filterBalanceByAcctNumber(balance, acctToReClassAcctIdsMap, ctx.getAccountIdToNumberMap());
        if (CollectionUtils.isNotEmpty(formula.getIncludeNoneAssistSet())) {
            balance = this.filterBalanceByEmptyAssist(balance, formula, ctx);
        }
        return balance;
    }

    private DataSet filterBalanceByEmptyAssist(DataSet balance, AcctFloatQueryFormula formula, AcctFloatContext ctx) {
        String filter = this.getIncludeEmptyAssistFilter(formula, ctx);
        return balance.filter(filter);
    }

    private String getIncludeEmptyAssistFilter(AcctFloatQueryFormula formula, AcctFloatContext ctx) {
        StringBuilder filter = new StringBuilder();
        HashMap<String, Set> filterAssistValueIdMap = new HashMap<String, Set>(8);
        Map<String, List<String>> assistToValueNumberMap = formula.getAssistToValueNumberMap();
        Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable = ctx.getAssistValueNumberToIdTable();
        Map<String, DynamicObject> assistMap = ctx.getAssistMap();
        String orgNumber = formula.getOrgNumber();
        for (String string : formula.getIncludeNoneAssistSet()) {
            DynamicObject assistDyn = assistMap.get(string);
            if (!Objects.nonNull(assistDyn)) continue;
            String assistFlexField = assistDyn.getString("flexfield");
            Set allValueIdSet = filterAssistValueIdMap.computeIfAbsent(assistFlexField, key -> new HashSet(8));
            List<String> assistValueNumList = assistToValueNumberMap.get(string);
            Map assistValNumToIdMap = (Map)assistValueNumberToIdTable.get((Object)orgNumber, (Object)string);
            if (!Objects.nonNull(assistValNumToIdMap)) continue;
            for (String assistValueNum : assistValueNumList) {
                Set assistValIdSet = (Set)assistValNumToIdMap.get(assistValueNum);
                if (CollectionUtils.isNotEmpty((Collection)assistValIdSet)) {
                    allValueIdSet.addAll(assistValIdSet);
                    continue;
                }
                allValueIdSet.add(-1L);
            }
        }
        for (Map.Entry entry : filterAssistValueIdMap.entrySet()) {
            String assistFlexField = (String)entry.getKey();
            Set valueIdSet = (Set)entry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)valueIdSet)) continue;
            String valueStr = valueIdSet.toString().substring(1, valueIdSet.toString().length() - 1);
            if (filter.length() == 0) {
                filter.append(assistFlexField).append(" in (").append(valueStr).append(")");
                continue;
            }
            filter.append(" and ").append(assistFlexField).append(" in (").append(valueStr).append(")");
        }
        return filter.toString();
    }

    private String buildSelectFields(AcctFloatQueryFormula formula, boolean isBaseCurrency, Set<String> sumFields, boolean isReClass, boolean isORMQuery) {
        HashSet<String> balFields = new HashSet<String>();
        balFields.add("org");
        if (!isBaseCurrency) {
            balFields.add("currency");
        }
        balFields.add("account.number account");
        if (isORMQuery) {
            if (isReClass && formula.getAssistToValueNumberMap().isEmpty()) {
                balFields.add("assgrp hg");
            }
        } else if (isReClass || !formula.getAssistToValueNumberMap().isEmpty()) {
            balFields.add("assgrp hg");
        }
        balFields.addAll(sumFields);
        Set<String> comAssistFieldSet = formula.getComAssistToValNumMap().keySet();
        if (CollectionUtils.isNotEmpty(comAssistFieldSet)) {
            balFields.addAll(comAssistFieldSet);
        }
        String selFields = ((Object)balFields).toString();
        selFields = selFields.substring(1, selFields.length() - 1);
        return selFields;
    }

    private QueryParam buildGetBalanceParamByORM(AcctFloatContext ctx, AcctFloatQueryFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap, boolean isReClass, Set<String> allAssistNumberSet) {
        MainEntityType balanceMainEntityType;
        QueryParam queryParam = new QueryParam();
        queryParam.setSpecialAccount(false);
        String fetchType = formula.getFetchType();
        boolean isSubPL = BCMBalanceIndexParam.getSubPlFetchType().contains(fetchType);
        queryParam.setSubstractPL(isSubPL);
        Set<String> accountNumberSet = formula.getAccountNumberToDynMap().keySet();
        if (!accountNumberSet.isEmpty()) {
            Set<String> allAccountNumberSet = this.dealLeafAcctNumbers(formula.getAssistToValueNumberMap().keySet(), ctx.getAssistMap(), formula.getAccountNumberToDynMap(), acctToReClassAcctIdsMap, ctx.getAccountIdToFlexFieldMap(), ctx.getAccountIdToNumberMap(), ctx.getAllDetailedAccountMap());
            queryParam.setOnlyLeafAcctBal(false);
            queryParam.setAccountFilter(new QFilter("number", "in", allAccountNumberSet));
        }
        boolean isBaseCurrency = true;
        String currencyNumber = formula.getCurrency();
        if (StringUtils.isNotBlank((CharSequence)currencyNumber) && ctx.getCurrencyNumberToIdMap().get(currencyNumber) != null) {
            isBaseCurrency = false;
        }
        if (!isBaseCurrency) {
            queryParam.setCurrencyIds(new Long[]{ctx.getCurrencyNumberToIdMap().get(currencyNumber)});
        }
        if ((balanceMainEntityType = this.getBalMainEntityType(allAssistNumberSet, ctx.getAssistMap())) != null) {
            queryParam.setBalEntityType(balanceMainEntityType);
        }
        ArrayList<QFilter> customFilters = queryParam.getCustomFilter() == null ? new ArrayList() : queryParam.getCustomFilter();
        this.setAssistFilter(customFilters, formula, ctx, isReClass);
        queryParam.setCustomFilter(customFilters);
        List<QFilter> comAssistFilterList = this.getComAssistFilters(formula, ctx);
        queryParam.getCustomFilter().addAll(comAssistFilterList);
        return queryParam;
    }

    private DataSet filterBalanceByAcctNumber(DataSet balance, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, String> accountIdToNumberMap) {
        Set<String> accountNumberSet = this.getAccountNumber(acctToReClassAcctIdsMap, accountIdToNumberMap);
        if (!accountNumberSet.isEmpty()) {
            StringBuilder accountNumberFilter = new StringBuilder();
            accountNumberFilter.append("account in (");
            accountNumberSet.forEach(number -> accountNumberFilter.append("\"").append((String)number).append("\"").append(","));
            if (accountNumberFilter.length() > 0) {
                accountNumberFilter.delete(accountNumberFilter.length() - 1, accountNumberFilter.length()).append(")");
            }
            return balance.filter(accountNumberFilter.toString());
        }
        return balance;
    }

    private MainEntityType getBalMainEntityType(Set<String> allAssistNumberSet, Map<String, DynamicObject> assistMap) {
        try {
            MainEntityType balEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"gl_balance").clone();
            this.registerProperty(balEntity, allAssistNumberSet, assistMap);
            return balEntity;
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void registerProperty(MainEntityType balEntity, Set<String> allAssistNumberSet, Map<String, DynamicObject> assistMap) {
        for (String assistNumber : allAssistNumberSet) {
            DynamicObject assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            String valueSource = assistDyn.getString("valuesource");
            String flexField = assistDyn.getString("flexfield");
            DynamicObjectType type = this.getFlexDataType(valueSource);
            BasedataProp prop = new BasedataProp();
            prop.setAlias("fassgrpid");
            prop.setName("assgrp_" + flexField);
            prop.setComplexType((IDataEntityType)type);
            ((LongProp)type.getProperties().get((Object)"id")).setAlias("fid");
            balEntity.addProperty((DynamicProperty)prop);
        }
    }

    private DynamicObjectType getFlexDataType(String valueSource) {
        String tableName = StringUtils.isBlank((CharSequence)valueSource) ? "gl_assist_txt" : "gl_assist_bd";
        try {
            return (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)tableName).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setAssistFilter(List<QFilter> customFilters, AcctFloatQueryFormula formula, AcctFloatContext ctx, boolean isReClass) {
        QFilter fvalue;
        QFilter fflex;
        String flexField;
        DynamicObject assistDyn;
        String assistNumber;
        String orgNumber = formula.getOrgNumber();
        Map<String, List<String>> assistToValueNumberMap = formula.getAssistToValueNumberMap();
        Map<String, List<String>> assistToRangeValueMap = formula.getAssistToRangeValueMap();
        Set<String> allValueAssistNumberSet = formula.getAllValueAssistNumberSet();
        Set<String> includeNoneAssistSet = formula.getIncludeNoneAssistSet();
        Map<String, DynamicObject> assistMap = ctx.getAssistMap();
        Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable = ctx.getAssistValueNumberToIdTable();
        Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable = ctx.getAssistRangeValToIdTable();
        String assgrpPrefix = "assgrp_";
        for (Map.Entry<String, List<String>> assistToValueNumberEntry : assistToValueNumberMap.entrySet()) {
            assistNumber = assistToValueNumberEntry.getKey();
            List<String> assistValueNumberList = assistToValueNumberEntry.getValue();
            assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            flexField = assistDyn.getString("flexfield");
            HashSet<Integer> assistValueIdSet = new HashSet<Integer>(assistValueNumberList.size());
            if (!assistValueNumberList.contains("None")) {
                for (String assistValueNumber : assistValueNumberList) {
                    Set assistValueId = (Set)((Map)assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(assistValueNumber);
                    if (CollectionUtils.isNotEmpty((Collection)assistValueId)) {
                        assistValueIdSet.addAll(assistValueId);
                        continue;
                    }
                    assistValueIdSet.add(0);
                }
            } else {
                includeNoneAssistSet.add(assistNumber);
            }
            if (!assistValueIdSet.isEmpty()) {
                fflex = new QFilter(assgrpPrefix + flexField + ".asstype", "=", (Object)flexField);
                fvalue = new QFilter(assgrpPrefix + flexField + ".assval", "in", assistValueIdSet);
                customFilters.add(fflex);
                customFilters.add(fvalue);
                continue;
            }
            customFilters.add(QFilter.join((String)(assgrpPrefix + flexField), (String)(assgrpPrefix + flexField + ".hg"), (QFilter)new QFilter(assgrpPrefix + flexField + ".asstype", "=", (Object)flexField), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)false));
        }
        for (Map.Entry<String, List<String>> assistToRangeValueEntry : assistToRangeValueMap.entrySet()) {
            assistNumber = assistToRangeValueEntry.getKey();
            List<String> rangeValueList = assistToRangeValueEntry.getValue();
            assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            flexField = assistDyn.getString("flexfield");
            HashSet<Integer> allRangeValueIdSet = new HashSet<Integer>(rangeValueList.size());
            for (String rangeValue : rangeValueList) {
                Set rangeValueIdSet = (Set)((Map)assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue);
                if (CollectionUtils.isNotEmpty((Collection)rangeValueIdSet)) {
                    allRangeValueIdSet.addAll(rangeValueIdSet);
                    continue;
                }
                allRangeValueIdSet.add(0);
            }
            if (!allRangeValueIdSet.isEmpty()) {
                fflex = new QFilter(assgrpPrefix + flexField + ".asstype", "=", (Object)flexField);
                fvalue = new QFilter(assgrpPrefix + flexField + ".assval", "in", allRangeValueIdSet);
                customFilters.add(fflex);
                customFilters.add(fvalue);
                continue;
            }
            customFilters.add(QFilter.join((String)(assgrpPrefix + flexField), (String)(assgrpPrefix + flexField + ".hg"), (QFilter)new QFilter(assgrpPrefix + flexField + ".asstype", "=", (Object)flexField), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)false));
        }
        if (isReClass) {
            for (String assistNumber2 : allValueAssistNumberSet) {
                DynamicObject assistDyn2 = assistMap.get(assistNumber2);
                if (assistDyn2 == null) continue;
                String flexField2 = assistDyn2.getString("flexfield");
                customFilters.add(QFilter.join((String)(assgrpPrefix + flexField2), (String)(assgrpPrefix + flexField2 + ".hg"), (QFilter)new QFilter(assgrpPrefix + flexField2 + ".asstype", "=", (Object)flexField2), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)false));
            }
        }
    }

    private Set<String> dealLeafAcctNumbers(Set<String> assistNumberSet, Map<String, DynamicObject> assistMap, Map<String, DynamicObject> accountNumberMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, Set<String>> accountIdToFlexFieldMap, Map<Long, String> accountIdToNumberMap, Map<Long, Set<Long>> detailAccountIdMap) {
        if (!assistNumberSet.isEmpty()) {
            HashSet<String> flexFieldSet = new HashSet<String>(assistNumberSet.size());
            for (String string : assistNumberSet) {
                DynamicObject dynamicObject = assistMap.get(string);
                String string2 = dynamicObject.getString("flexfield");
                flexFieldSet.add(string2);
            }
            HashSet<Long> allReClassAccountIdSet = new HashSet<Long>(8);
            for (Map.Entry<String, DynamicObject> entry : accountNumberMap.entrySet()) {
                DynamicObject dynamicObject = entry.getValue();
                if (dynamicObject == null) continue;
                Set<Long> reClassAccountIdSet = acctToReClassAcctIdsMap.get(dynamicObject.getLong("id"));
                allReClassAccountIdSet.addAll(reClassAccountIdSet);
            }
            HashSet hashSet = new HashSet(8);
            for (Long l : allReClassAccountIdSet) {
                hashSet.addAll(detailAccountIdMap.get(l));
            }
            HashSet<Long> hashSet2 = new HashSet<Long>(hashSet.size());
            for (Long detailAccountId : hashSet) {
                Set<String> accountToFlexFieldSet = accountIdToFlexFieldMap.get(detailAccountId);
                if (accountToFlexFieldSet == null || !accountToFlexFieldSet.containsAll(flexFieldSet)) continue;
                hashSet2.add(detailAccountId);
            }
            HashSet<String> hashSet3 = new HashSet<String>(hashSet2.size());
            for (Long accountId : hashSet2) {
                hashSet3.add(accountIdToNumberMap.get(accountId));
            }
            return hashSet3;
        }
        return accountNumberMap.keySet();
    }

    private Set<String> getAccountNumber(Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, String> accountIdToNumberMap) {
        HashSet<String> accountNumberSet = new HashSet<String>(8);
        for (Set<Long> accountSet : acctToReClassAcctIdsMap.values()) {
            accountSet.forEach(id -> accountNumberSet.add((String)accountIdToNumberMap.get(id)));
        }
        return accountNumberSet;
    }

    private Object[] getBalanceFieldIndex(AcctFloatQueryFormula formula, Map<String, Long> currencyNumberToIdMap) {
        boolean isBaseCurrency = true;
        String currencyNumber = formula.getCurrency();
        if (StringUtils.isNotBlank((CharSequence)currencyNumber) && currencyNumberToIdMap.get(currencyNumber) != null) {
            isBaseCurrency = false;
        }
        String _L = "";
        if (isBaseCurrency) {
            _L = "_L";
        }
        String fetchType = formula.getFetchType();
        Object[] balanceFieldIndex = BCMBalanceIndexParam.getFetchTypeIndex().get(fetchType + _L);
        if (balanceFieldIndex == null && "L".equalsIgnoreCase(fetchType.substring(0, 1))) {
            String lfetchType = fetchType.substring(1);
            balanceFieldIndex = BCMBalanceIndexParam.getFetchTypeIndex().get(lfetchType + "_L");
        }
        if (balanceFieldIndex == null && StringUtils.isBlank((CharSequence)formula.getErrorMsg())) {
            formula.setErrorMsg(String.format(ResManager.loadKDString((String)"%s\u53d6\u6570\u7c7b\u578b\u4e0d\u652f\u6301", (String)"AcctFloatQueryServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0]), fetchType));
        }
        return balanceFieldIndex;
    }

    private void sumBalanceByAssist(DataSet balance, AcctFloatQueryFormula formula, Map<String, DynamicObject> assistMap, Object[] balanceFieldIndex, Map<String, Map<Object, Set<String>>> assistValIdToNumMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, String> accountIdToNumberMap) {
        long startTime = System.currentTimeMillis();
        List<String> floatAssistNumberList = formula.getFloatAssistNumberList();
        boolean isReClass = BCMBalanceIndexParam.getFetchTypeReclass().contains(formula.getFetchType());
        Map<Map<String, Object>, BigDecimal> resultMap = formula.getResultMap();
        if (!isReClass) {
            this.sumBalanceNoReClass(balance, resultMap, floatAssistNumberList, balanceFieldIndex, assistMap, assistValIdToNumMap);
        } else {
            HashSet<String> allAssistNunSet = new HashSet<String>(formula.getAssistToValueNumberMap().keySet());
            allAssistNunSet.addAll(formula.getAssistToRangeValueMap().keySet());
            allAssistNunSet.addAll(formula.getAllValueAssistNumberSet());
            HashSet<String> allFlexFiledSet = new HashSet<String>(8);
            for (String assistNumber : allAssistNunSet) {
                DynamicObject assistDyn = assistMap.get(assistNumber);
                allFlexFiledSet.add(assistDyn.getString("flexfield"));
            }
            this.sumBalanceReClass(balance, floatAssistNumberList, balanceFieldIndex, assistMap, assistValIdToNumMap, formula, acctToAssistStyleMap, acctToReClassAcctIdsMap, accountIdToNumberMap, allFlexFiledSet);
        }
        long endTime = System.currentTimeMillis();
        this.log.info("sum balance cost time\uff1a" + (endTime - startTime));
    }

    private void sumBalanceNoReClass(DataSet balance, Map<Map<String, Object>, BigDecimal> resultMap, List<String> floatAssistNumberList, Object[] balanceFieldIndex, Map<String, DynamicObject> assistMap, Map<String, Map<Object, Set<String>>> assistValIdToNumMap) {
        long startTime = System.currentTimeMillis();
        long executeTime = 0L;
        for (Row row : balance) {
            Set<Map<String, Object>> assistValueKeys = this.buildAssistValueKeys(floatAssistNumberList, assistMap, row, assistValIdToNumMap);
            BigDecimal amtRow = BCMBalanceIndexParam.rowCountByFetchType(row, balanceFieldIndex);
            for (Map<String, Object> assistValueKey : assistValueKeys) {
                BigDecimal amount = resultMap.computeIfAbsent(assistValueKey, key -> new BigDecimal("0"));
                amount = amount.add(amtRow);
                resultMap.put(assistValueKey, amount);
                ++executeTime;
            }
        }
        long endTime = System.currentTimeMillis();
        this.log.info("sum balance by no reclass execute time\uff1a" + executeTime);
        this.log.info("sum balance by no reclass cost time\uff1a" + (endTime - startTime));
    }

    private void sumBalanceReClass(DataSet balance, List<String> floatAssistNumberList, Object[] balanceFieldIndex, Map<String, DynamicObject> assistMap, Map<String, Map<Object, Set<String>>> assistValIdToNumMap, AcctFloatQueryFormula formula, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, String> accountIdToNumberMap, Set<String> allFlexFiledSet) {
        long startTime = System.currentTimeMillis();
        Map<String, Integer> acctNumToAssistStyleMap = this.getAssistStyleMap(formula, acctToReClassAcctIdsMap, acctToAssistStyleMap, accountIdToNumberMap);
        long executeTime = 0L;
        for (Row row : balance) {
            Set<Map<String, Object>> assistValueKeys = this.buildAssistValueKeys(floatAssistNumberList, assistMap, row, assistValIdToNumMap);
            BigDecimal amtRow = BCMBalanceIndexParam.rowCountByFetchType(row, balanceFieldIndex);
            for (Map<String, Object> assistValueKey : assistValueKeys) {
                Table accountToAmountTable = formula.getCombinationToAmountByAccountTable().computeIfAbsent(assistValueKey, key -> HashBasedTable.create());
                Map assgrpToAmountMap = formula.getCombinationToAmountByAssgrpMap().computeIfAbsent(assistValueKey, key -> new HashMap(8));
                this.reClassAmount(assistValueKey, row, amtRow, acctNumToAssistStyleMap, (Table<String, String, BigDecimal>)accountToAmountTable, assgrpToAmountMap, formula, allFlexFiledSet);
                ++executeTime;
            }
        }
        long endTime = System.currentTimeMillis();
        this.log.info("sum balance by reclass execute time\uff1a" + executeTime);
        this.log.info("sum balance by reclass cost time\uff1a" + (endTime - startTime));
    }

    private Set<Map<String, Object>> buildAssistValueKeys(List<String> floatAssistNumberList, Map<String, DynamicObject> assistMap, Row row, Map<String, Map<Object, Set<String>>> assistValIdToNumMap) {
        HashMap combineAssistMap = new HashMap(8);
        for (String assistNumber : floatAssistNumberList) {
            String flexField = assistMap.get(assistNumber).getString("flexfield");
            Object assistValueId = row.get(flexField);
            Map<Object, Set<String>> valueIdToNumMap = assistValIdToNumMap.get(assistNumber);
            if (CollectionUtils.isNotEmpty(Collections.singleton(valueIdToNumMap))) {
                Set<String> valueNumberSet = valueIdToNumMap.get(assistValueId);
                if (CollectionUtils.isNotEmpty(valueNumberSet)) {
                    combineAssistMap.put(assistNumber, new HashSet<String>(valueNumberSet));
                    continue;
                }
                return Collections.EMPTY_SET;
            }
            return Collections.EMPTY_SET;
        }
        HashSet<Map<String, Object>> assistCombinationSet = new HashSet<Map<String, Object>>(8);
        AssistCombination.parts(combineAssistMap, assistCombinationSet::add);
        return assistCombinationSet;
    }

    private Map<String, Integer> getAssistStyleMap(AcctFloatQueryFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, String> accountIdToNumberMap) {
        HashMap<String, Integer> acctNumToAssistStyleMap = new HashMap<String, Integer>(8);
        for (Map.Entry<String, DynamicObject> accountEntry : formula.getAccountNumberToDynMap().entrySet()) {
            DynamicObject accountDyn = accountEntry.getValue();
            if (accountDyn == null) continue;
            long accountId = accountDyn.getLong("id");
            Set<Long> reClassAccountIdSet = acctToReClassAcctIdsMap.get(accountId);
            Integer assistStyle = acctToAssistStyleMap.get(accountId);
            if (reClassAccountIdSet.isEmpty()) continue;
            reClassAccountIdSet.forEach(id -> acctNumToAssistStyleMap.put((String)accountIdToNumberMap.get(id), assistStyle));
        }
        return acctNumToAssistStyleMap;
    }

    private void reClassAmount(Map<String, Object> assistCombinationMap, Row rowData, BigDecimal amtRow, Map<String, Integer> acctNumToAssistStyleMap, Table<String, String, BigDecimal> accountToAmountTable, Map<AcctReClassAmountKey, BigDecimal> assgrpToAmountMap, AcctFloatQueryFormula formula, Collection<String> allFlexField) {
        Map<Map<String, Object>, BigDecimal> resultMap = formula.getResultMap();
        BigDecimal resultAmount = resultMap.computeIfAbsent(assistCombinationMap, key -> new BigDecimal(0));
        String accountId = rowData.getString("account");
        boolean contraAccount = formula.isContraAccount();
        int reClassType = formula.getReClassType();
        int assistStyle = acctNumToAssistStyleMap.get(accountId);
        if (contraAccount) {
            if (assistStyle == 1) {
                this.dealLeafAcctToAmt(accountToAmountTable, formula, accountId, rowData, amtRow);
            } else {
                this.dealAssgrpToAmt(allFlexField, formula, assgrpToAmountMap, false, assistStyle, rowData, amtRow);
            }
        } else if (assistStyle == 1) {
            this.dealLeafAcctToAmt(accountToAmountTable, formula, accountId, rowData, amtRow);
        } else if (assistStyle == 2) {
            if (reClassType == 4 || reClassType == 5) {
                this.dealLeafAcctToAmt(accountToAmountTable, formula, accountId, rowData, amtRow);
            } else {
                this.dealAssgrpToAmt(allFlexField, formula, assgrpToAmountMap, true, assistStyle, rowData, amtRow);
            }
        } else if (assistStyle == 3) {
            this.dealAssgrpToAmt(allFlexField, formula, assgrpToAmountMap, true, assistStyle, rowData, amtRow);
        }
        resultMap.put(assistCombinationMap, resultAmount);
    }

    private void dealLeafAcctToAmt(Table<String, String, BigDecimal> leafAcctToAmtTable, AcctFloatQueryFormula formula, String accountKey, Row rowData, BigDecimal amount) {
        String comAssistKey = "";
        if (formula.isHaveComAssist()) {
            comAssistKey = this.buildComAssistKey(formula.getComAssistToValNumMap().keySet(), rowData);
        }
        BigDecimal amtAcct = leafAcctToAmtTable.get((Object)accountKey, (Object)comAssistKey) != null ? (BigDecimal)leafAcctToAmtTable.get((Object)accountKey, (Object)comAssistKey) : new BigDecimal("0");
        amtAcct = amtAcct.add(amount);
        leafAcctToAmtTable.put((Object)accountKey, (Object)comAssistKey, (Object)amtAcct);
    }

    private void dealAssgrpToAmt(Collection<String> allFlexField, AcctFloatQueryFormula formula, Map<AcctReClassAmountKey, BigDecimal> assgrpToAmountMap, boolean isNeedAccount, int assistStyle, Row rowData, BigDecimal amount) {
        String accountKey = "";
        if (isNeedAccount) {
            accountKey = rowData.getString("account");
        }
        HashMap<String, Object> flexMap = new HashMap<String, Object>(8);
        if (assistStyle == 2) {
            for (String flexField : allFlexField) {
                Object value = rowData.get(flexField);
                flexMap.put(flexField, value);
            }
        } else if (assistStyle == 3) {
            String hgId = rowData.getString("hg");
            flexMap.put(hgId, null);
        }
        String comAssistKey = "";
        if (formula.isHaveComAssist()) {
            comAssistKey = this.buildComAssistKey(formula.getComAssistToValNumMap().keySet(), rowData);
        }
        AcctReClassAmountKey acctReClassAmountKey = new AcctReClassAmountKey(accountKey, flexMap, comAssistKey);
        BigDecimal bigDecimal = assgrpToAmountMap.computeIfAbsent(acctReClassAmountKey, x -> new BigDecimal("0"));
        bigDecimal = bigDecimal.add(amount);
        assgrpToAmountMap.put(acctReClassAmountKey, bigDecimal);
    }

    private String buildComAssistKey(Collection<String> comAssistKeys, Row dataRow) {
        ArrayList<String> valueList = new ArrayList<String>(8);
        for (String comAssistFiled : comAssistKeys) {
            valueList.add(String.valueOf(dataRow.getLong(comAssistFiled)));
        }
        if (CollectionUtils.isNotEmpty(valueList)) {
            return String.join((CharSequence)"-", valueList);
        }
        return "";
    }

    public Map<String, BigDecimal> getAmountResult(AcctFloatQueryFormula formula) {
        Map<Map<String, Object>, BigDecimal> resultMap = formula.getResultMap();
        Map<Map<String, Object>, Table<String, String, BigDecimal>> combinationToAmountByAccountTable = formula.getCombinationToAmountByAccountTable();
        Map<Map<String, Object>, Map<AcctReClassAmountKey, BigDecimal>> combinationToAmountByAssgrpMap = formula.getCombinationToAmountByAssgrpMap();
        HashMap<String, BigDecimal> assistToResultMap = new HashMap<String, BigDecimal>(resultMap.size());
        String balanceDc = this.getBalanceDc(formula);
        List<String> floatAssistNumberList = formula.getFloatAssistNumberList();
        for (Map.Entry<Map<String, Object>, BigDecimal> resultEntry : resultMap.entrySet()) {
            Map<String, Object> assistCombinationMap = resultEntry.getKey();
            BigDecimal resultAmount = resultEntry.getValue();
            Table<String, String, BigDecimal> leafAcctToAmtTable = combinationToAmountByAccountTable.get(assistCombinationMap);
            Map<AcctReClassAmountKey, BigDecimal> assgrpToAmountMap = combinationToAmountByAssgrpMap.get(assistCombinationMap);
            if (resultAmount == null) {
                if (leafAcctToAmtTable.isEmpty() && assgrpToAmountMap.isEmpty()) {
                    return null;
                }
                resultAmount = new BigDecimal("0");
                resultEntry.setValue(resultAmount);
            }
            resultAmount = this.reClassSum(leafAcctToAmtTable, assgrpToAmountMap, formula, resultAmount, balanceDc);
            StringBuilder assistKey = new StringBuilder();
            for (String assistNumber : floatAssistNumberList) {
                String assistValueNumber = (String)assistCombinationMap.get(assistNumber);
                assistKey.append(assistValueNumber);
                assistKey.append("|");
            }
            assistKey.delete(assistKey.length() - 1, assistKey.length());
            assistToResultMap.put(assistKey.toString(), assistToResultMap.containsKey(assistKey.toString()) ? ((BigDecimal)assistToResultMap.get(assistKey.toString())).add(resultAmount) : resultAmount);
        }
        return assistToResultMap;
    }

    private String getBalanceDc(AcctFloatQueryFormula formula) {
        Collection<DynamicObject> accounts = formula.getAccountNumberToDynMap().values();
        HashSet<String> balanceDcSet = new HashSet<String>(8);
        for (DynamicObject account : accounts) {
            String balanceDc = account.getString("dc");
            balanceDcSet.add(balanceDc);
        }
        if (balanceDcSet.size() == 1) {
            return (String)balanceDcSet.iterator().next();
        }
        return "1";
    }

    private BigDecimal reClassSum(Table<String, String, BigDecimal> leafAcctToAmtTable, Map<AcctReClassAmountKey, BigDecimal> assgrpToAmountMap, AcctFloatQueryFormula formula, BigDecimal resultAmount, String balanceDc) {
        String fetchType = formula.getFetchType();
        boolean isReClass = BCMBalanceIndexParam.getFetchTypeReclass().contains(fetchType);
        boolean isJBal = !BCMBalanceIndexParam.getFetchTypeD().contains(fetchType);
        boolean isBalDc = BCMBalanceIndexParam.getFetchType_y().contains(fetchType);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(8);
        if (leafAcctToAmtTable != null) {
            amountList.addAll(leafAcctToAmtTable.values());
        }
        if (assgrpToAmountMap != null) {
            amountList.addAll(assgrpToAmountMap.values());
        }
        for (BigDecimal amount : amountList) {
            if ((!isJBal || amount.compareTo(BigDecimal.ZERO) <= 0) && (isJBal || amount.compareTo(BigDecimal.ZERO) >= 0)) continue;
            resultAmount = resultAmount.add(amount);
        }
        if (isReClass && !isJBal) {
            resultAmount = resultAmount.negate();
        }
        if (isBalDc) {
            resultAmount = resultAmount.multiply(new BigDecimal(balanceDc));
        }
        return resultAmount;
    }

    private List<QFilter> getComAssistFilters(AcctFloatQueryFormula formula, AcctFloatContext ctx) {
        ArrayList<QFilter> comAssistFilterList = new ArrayList<QFilter>(8);
        String formulaKey = formula.getFormulaKey();
        String orgNumber = formula.getOrgNumber();
        Table<String, String, Map<String, Set<Long>>> comAssistDispersedValIdTable = ctx.getComAssistDispersedValIdTable();
        Table<String, String, Map<String, Set<Long>>> comAssistRangeValIdTable = ctx.getComAssistRangeValIdTable();
        Table<String, String, String> comAssistToValSourceTable = ctx.getComAssistToValSourceTable();
        for (Map.Entry<String, Set<String>> comAssistToValNumEntry : formula.getComAssistToValNumMap().entrySet()) {
            Set<String> comAssistValueNumSet;
            String valueSource;
            HashSet comAssistValIdSet = new HashSet(8);
            String comAssistKey = comAssistToValNumEntry.getKey();
            if (!StringUtils.isNotBlank((CharSequence)comAssistKey) || !StringUtils.isNotBlank((CharSequence)(valueSource = (String)comAssistToValSourceTable.get((Object)formulaKey, (Object)comAssistKey))) || !CollectionUtils.isNotEmpty(comAssistValueNumSet = comAssistToValNumEntry.getValue())) continue;
            for (String comAssistNum : comAssistValueNumSet) {
                Set valueIdSet;
                Map comAssistNumToIdMap;
                if (AcctUtil.isRangeValueNumber(comAssistNum)) {
                    comAssistNumToIdMap = (Map)comAssistRangeValIdTable.get((Object)orgNumber, (Object)valueSource);
                    if (comAssistNumToIdMap == null || !CollectionUtils.isNotEmpty((Collection)(valueIdSet = (Set)comAssistNumToIdMap.get(comAssistNum)))) continue;
                    comAssistValIdSet.addAll(valueIdSet);
                    continue;
                }
                comAssistNumToIdMap = (Map)comAssistDispersedValIdTable.get((Object)orgNumber, (Object)valueSource);
                if (comAssistNumToIdMap == null || !CollectionUtils.isNotEmpty((Collection)(valueIdSet = (Set)comAssistNumToIdMap.get(comAssistNum)))) continue;
                comAssistValIdSet.addAll(valueIdSet);
            }
            comAssistFilterList.add(new QFilter(comAssistKey, "in", comAssistValIdSet));
        }
        return comAssistFilterList;
    }
}

