/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.bcmbussiness;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.gl.util.ReClassUtils;

public class FormulaInfo {
    private List<String> formulaStr;
    private String key;
    private String formulaId;
    private String acctcfStr;
    private String cashItemNum;
    private String calType;
    private Map<String, Set<String>> assistNumValsMap;
    private Map<String, Map<String, Set<String>>> groupValsMap;
    private Map<String, Set<String>> comAssistKeyToNumMap;

    public FormulaInfo(List<String> formulastr, String key, String formulaId, Map<String, Set<String>> comAssistKeyToNumMap) {
        this.formulaStr = formulastr;
        this.acctcfStr = formulastr.get(2);
        this.calType = formulastr.get(3);
        this.key = key;
        this.formulaId = formulaId;
        String[] cfs = this.acctcfStr.split("\\|");
        this.assistNumValsMap = new HashMap<String, Set<String>>();
        this.groupValsMap = new HashMap<String, Map<String, Set<String>>>();
        for (int i = 0; i < cfs.length; ++i) {
            if (i == 0) {
                this.cashItemNum = cfs[i];
                continue;
            }
            if (i % 2 != 0) {
                if (StringUtils.isEmpty((CharSequence)cfs[i])) continue;
                this.assistNumValsMap.put(cfs[i], new HashSet());
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)cfs[i])) continue;
            boolean isNoCategory = ReClassUtils.isCollectionNumber(cfs[i]);
            if (!isNoCategory) {
                Set<String> assistValNumSet = this.assistNumValsMap.get(cfs[i - 1]);
                if (!Objects.nonNull(assistValNumSet)) continue;
                String[] valNums = cfs[i].split(",");
                assistValNumSet.addAll(Arrays.asList(valNums));
                continue;
            }
            String[] strings = cfs[i].split("#");
            String assistNum = cfs[i - 1];
            String groupStandard = strings[0];
            String groupString = strings[1];
            Map groupStandardToGroupMap = this.groupValsMap.computeIfAbsent(assistNum, e -> new HashMap());
            Set groupSet = groupStandardToGroupMap.computeIfAbsent(groupStandard, e -> new HashSet());
            String[] groups = groupString.split(",");
            groupSet.addAll(Arrays.asList(groups));
        }
        this.comAssistKeyToNumMap = comAssistKeyToNumMap;
    }

    public String getKey() {
        return this.key;
    }

    public String getFormulaId() {
        return this.formulaId;
    }

    public String getAcctcfStr() {
        return this.acctcfStr;
    }

    public String getCashItemNum() {
        return this.cashItemNum;
    }

    public String getCalType() {
        return this.calType;
    }

    public Map<String, Set<String>> getAssistNumValsMap() {
        return this.assistNumValsMap;
    }

    public Map<String, Map<String, Set<String>>> getGroupValsMap() {
        return this.groupValsMap;
    }

    public List<String> getFormulaStr() {
        return this.formulaStr;
    }

    public Map<String, Set<String>> getComAssistKeyToNumMap() {
        return this.comAssistKeyToNumMap;
    }
}

