/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.kpi.thread;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.fi.gl.service.FdaFinancialKpiGetValueHelp;

public class FdaKpiWorkTask
implements Callable {
    private List<Long> orgIds;
    private Set<Long> childOrgSet;
    private Long orgViewId;
    private Long bookTypeId;
    private Long accTableId;
    private Long periodTypeId;
    private Long periodId;
    private String reportType;
    int amtprecision;

    public FdaKpiWorkTask(Collection<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, String reportType, int amtprecision) {
        this.orgIds = orgIds != null ? new ArrayList<Long>(orgIds) : null;
        this.childOrgSet = childOrgSet;
        this.orgViewId = orgViewId;
        this.bookTypeId = bookTypeId;
        this.accTableId = accTableId;
        this.periodTypeId = periodTypeId;
        this.periodId = periodId;
        this.reportType = reportType;
        this.amtprecision = amtprecision;
    }

    public Map<String, BigDecimal> call() throws Exception {
        Map<String, BigDecimal> resultMap = this.doTask();
        return resultMap;
    }

    public Map<String, BigDecimal> doTask() {
        Map<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        switch (this.reportType) {
            case "gl_balancesheet": {
                map = FdaFinancialKpiGetValueHelp.getBalanceValue(this.orgIds, this.childOrgSet, this.orgViewId, this.bookTypeId, this.accTableId, this.periodTypeId, this.periodId, this.amtprecision, map);
                break;
            }
            case "gl_showincome": {
                map = FdaFinancialKpiGetValueHelp.getIncomeValue(this.orgIds, this.childOrgSet, this.orgViewId, this.bookTypeId, this.accTableId, this.periodTypeId, this.periodId, this.amtprecision, map, true);
                break;
            }
            case "gl_cashflowstat": {
                map = FdaFinancialKpiGetValueHelp.getCashFlowStatValue(this.orgIds, this.childOrgSet, this.orgViewId, this.bookTypeId, this.accTableId, this.periodTypeId, this.periodId, this.amtprecision, map);
                break;
            }
        }
        return map;
    }
}

