/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.operation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;

public class BatchUpdateEntriesUtil {
    private static final int BATCH_UPDATE_SIZE = 5000;
    private static final int BATCH_UPDATE_SIZE_MIN = 1;
    private static final String updateSql_mainCFAndSuppCF = "update t_gl_voucherentry set fmaincfamount = ? , fsuppcfamount = ? where fid = ? and fentryid = ?";
    private static final String updateSql_mainCF = "update t_gl_voucherentry set fmaincfamount = ? where fid = ? and fentryid = ?";
    private static final String updateSql_suppCF = "update t_gl_voucherentry set fsuppcfamount = ? where fid = ? and fentryid = ?";
    private static final String updateSql_OriDebit = "update t_gl_voucherentry set flocaldebit = ? where fid = ? and fentryid = ?";
    private static final String updateSql_OriDebitWithRate = "update t_gl_voucherentry set flocaldebit = ? , flocalexchangerate = ? where fid = ? and fentryid = ?";
    private static final String updateSql_OriCredit = "update t_gl_voucherentry set flocalcredit = ? where fid = ? and fentryid = ?";
    private static final String updateSql_OriCreditWithRate = "update t_gl_voucherentry set flocalcredit = ? , flocalexchangerate = ? where fid = ? and fentryid = ?";
    private static final String updateSql_LocalDebit = "update t_gl_voucherentry set flocaldebit = ?  where fid = ? and fentryid = ?";
    private static final String updateSql_LocalCredit = "update t_gl_voucherentry set flocalcredit = ?  where fid = ? and fentryid = ?";
    private List<Object[]> mainCFAndSuppCFParamsList = new ArrayList<Object[]>(8);
    private List<Object[]> mainCFParamsList = new ArrayList<Object[]>(8);
    private List<Object[]> suppCFParamsList = new ArrayList<Object[]>(8);
    private List<Object[]> maxOriDebitParamsList = new ArrayList<Object[]>(8);
    private List<Object[]> maxOriDebitWithRateParamsList = new ArrayList<Object[]>(8);
    private List<Object[]> maxOriCreditParamsList = new ArrayList<Object[]>(8);
    private List<Object[]> maxOriCreditWithRateParamsList = new ArrayList<Object[]>(8);
    private List<Object[]> maxLocalDebitParamsList = new ArrayList<Object[]>(8);
    private List<Object[]> maxLocalCreditParamsList = new ArrayList<Object[]>(8);

    public void addToBatchUpdateEntries(long vid, Long entryId, BigDecimal newMainCfAmount, BigDecimal newSuppcfAmount) {
        if (null != newMainCfAmount && null != newSuppcfAmount) {
            this.mainCFAndSuppCFParamsList.add(new Object[]{newMainCfAmount, newSuppcfAmount, vid, entryId});
        } else if (null != newMainCfAmount && null == newSuppcfAmount) {
            this.mainCFParamsList.add(new Object[]{newMainCfAmount, vid, entryId});
        } else if (null == newMainCfAmount && null != newSuppcfAmount) {
            this.suppCFParamsList.add(new Object[]{newSuppcfAmount, vid, entryId});
        }
        if (null != newMainCfAmount || null != newSuppcfAmount) {
            this.checkToExecuteBatch(5000);
        }
    }

    private void checkToExecuteBatch(int batchUpdateSize) {
        Throwable throwable;
        TXHandle h2;
        Throwable throwable2;
        ShardingHintContext ctx;
        HintCondition hintId;
        Set<Long> ids;
        if (this.mainCFAndSuppCFParamsList.size() >= batchUpdateSize) {
            ids = this.getVchIds(this.mainCFAndSuppCFParamsList, updateSql_mainCFAndSuppCF);
            hintId = new HintCondition("fid", "in", ids);
            ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintId}).prepareShardingIndex();
            throwable2 = null;
            try {
                h2 = TX.requiresNew((String)"updateSql_mainCFAndSuppCF");
                throwable = null;
                try {
                    try {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateSql_mainCFAndSuppCF, this.mainCFAndSuppCFParamsList);
                    }
                    catch (Throwable e) {
                        h2.markRollback();
                        throw e;
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                    throw e;
                }
                finally {
                    if (h2 != null) {
                        if (throwable != null) {
                            try {
                                h2.close();
                            }
                            catch (Throwable e) {
                                throwable.addSuppressed(e);
                            }
                        } else {
                            h2.close();
                        }
                    }
                }
                this.mainCFAndSuppCFParamsList.clear();
            }
            catch (Throwable h2) {
                throwable2 = h2;
                throw h2;
            }
            finally {
                if (ctx != null) {
                    if (throwable2 != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable h2) {
                            throwable2.addSuppressed(h2);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        if (this.mainCFParamsList.size() >= batchUpdateSize) {
            ids = this.getVchIds(this.mainCFParamsList, updateSql_mainCF);
            hintId = new HintCondition("fid", "in", ids);
            ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintId}).prepareShardingIndex();
            throwable2 = null;
            try {
                h2 = TX.requiresNew((String)"updateSql_mainCF");
                throwable = null;
                try {
                    try {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateSql_mainCF, this.mainCFParamsList);
                    }
                    catch (Throwable e) {
                        h2.markRollback();
                        throw e;
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                    throw e;
                }
                finally {
                    if (h2 != null) {
                        if (throwable != null) {
                            try {
                                h2.close();
                            }
                            catch (Throwable e) {
                                throwable.addSuppressed(e);
                            }
                        } else {
                            h2.close();
                        }
                    }
                }
                this.mainCFParamsList.clear();
            }
            catch (Throwable h3) {
                throwable2 = h3;
                throw h3;
            }
            finally {
                if (ctx != null) {
                    if (throwable2 != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable h3) {
                            throwable2.addSuppressed(h3);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        if (this.suppCFParamsList.size() >= batchUpdateSize) {
            ids = this.getVchIds(this.suppCFParamsList, updateSql_suppCF);
            hintId = new HintCondition("fid", "in", ids);
            ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintId}).prepareShardingIndex();
            throwable2 = null;
            try {
                h2 = TX.requiresNew((String)"updateSql_suppCF");
                throwable = null;
                try {
                    try {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateSql_suppCF, this.suppCFParamsList);
                    }
                    catch (Throwable e) {
                        h2.markRollback();
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (h2 != null) {
                        if (throwable != null) {
                            try {
                                h2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            h2.close();
                        }
                    }
                }
                this.suppCFParamsList.clear();
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (ctx != null) {
                    if (throwable2 != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
    }

    public void lastBatchUpdate() {
        this.checkToExecuteBatch(1);
    }

    public void addToBatchUpdateMaxOriDebitEntries(Long vid, long entryid, BigDecimal newDebitLoc, BigDecimal localrate) {
        this.maxOriDebitWithRateParamsList.add(new Object[]{newDebitLoc, localrate, vid, entryid});
        Set<Long> vchIds = this.getVchIds(this.maxOriDebitWithRateParamsList, updateSql_OriDebitWithRate);
        this.checkToExecuteBatchShortUpdate(5000, this.maxOriDebitWithRateParamsList, updateSql_OriDebitWithRate, vchIds);
    }

    public void addToBatchUpdateMaxOriDebitEntries(Long vid, long entryid, BigDecimal newDebitLoc) {
        this.maxOriDebitParamsList.add(new Object[]{newDebitLoc, vid, entryid});
        Set<Long> vchIds = this.getVchIds(this.maxOriDebitParamsList, updateSql_OriDebit);
        this.checkToExecuteBatchShortUpdate(5000, this.maxOriDebitParamsList, updateSql_OriDebit, vchIds);
    }

    public void addToBatchUpdateMaxOriCreditEntries(Long vid, long entryid, BigDecimal newCreditLoc, BigDecimal localrate) {
        this.maxOriCreditWithRateParamsList.add(new Object[]{newCreditLoc, localrate, vid, entryid});
        Set<Long> vchIds = this.getVchIds(this.maxOriCreditWithRateParamsList, updateSql_OriCreditWithRate);
        this.checkToExecuteBatchShortUpdate(5000, this.maxOriCreditWithRateParamsList, updateSql_OriCreditWithRate, vchIds);
    }

    public void addToBatchUpdateMaxOriCreditEntries(Long vid, long entryid, BigDecimal newCreditLoc) {
        this.maxOriCreditParamsList.add(new Object[]{newCreditLoc, vid, entryid});
        Set<Long> vchIds = this.getVchIds(this.maxOriCreditParamsList, updateSql_OriCredit);
        this.checkToExecuteBatchShortUpdate(5000, this.maxOriCreditParamsList, updateSql_OriCredit, vchIds);
    }

    public void addToBatchUpdateMaxLocalDebitEntries(Long vid, long entryid, BigDecimal newDebitLoc) {
        this.maxLocalDebitParamsList.add(new Object[]{newDebitLoc, vid, entryid});
        Set<Long> vchIds = this.getVchIds(this.maxLocalDebitParamsList, updateSql_LocalDebit);
        this.checkToExecuteBatchShortUpdate(5000, this.maxLocalDebitParamsList, updateSql_LocalDebit, vchIds);
    }

    public void addToBatchUpdateMaxLocalCreditEntries(Long vid, long entryid, BigDecimal newCreditLoc) {
        this.maxLocalCreditParamsList.add(new Object[]{newCreditLoc, vid, entryid});
        Set<Long> vchIds = this.getVchIds(this.maxLocalCreditParamsList, updateSql_LocalCredit);
        this.checkToExecuteBatchShortUpdate(5000, this.maxLocalCreditParamsList, updateSql_LocalCredit, vchIds);
    }

    private void checkToExecuteBatchShortUpdate(int batchUpdateSize, List<Object[]> paramsList, String updateSql, Set<Long> ids) {
        if (paramsList.size() >= batchUpdateSize) {
            HintCondition hintId = new HintCondition("fid", "in", ids);
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintId}).prepareShardingIndex();){
                try (TXHandle h = TX.requiresNew((String)"checkToExecuteBatchShortUpdate");){
                    try {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateSql, paramsList);
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
                paramsList.clear();
            }
        }
    }

    private Set<Long> getVchIds(List<Object[]> paramsList, String sql) {
        HashSet<Long> vchIds = new HashSet<Long>(paramsList.size());
        int index = 0;
        switch (sql) {
            case "update t_gl_voucherentry set fmaincfamount = ? where fid = ? and fentryid = ?": 
            case "update t_gl_voucherentry set fsuppcfamount = ? where fid = ? and fentryid = ?": 
            case "update t_gl_voucherentry set flocaldebit = ? where fid = ? and fentryid = ?": 
            case "update t_gl_voucherentry set flocalcredit = ? where fid = ? and fentryid = ?": 
            case "update t_gl_voucherentry set flocaldebit = ?  where fid = ? and fentryid = ?": 
            case "update t_gl_voucherentry set flocalcredit = ?  where fid = ? and fentryid = ?": {
                index = 1;
                break;
            }
            case "update t_gl_voucherentry set fmaincfamount = ? , fsuppcfamount = ? where fid = ? and fentryid = ?": 
            case "update t_gl_voucherentry set flocaldebit = ? , flocalexchangerate = ? where fid = ? and fentryid = ?": 
            case "update t_gl_voucherentry set flocalcredit = ? , flocalexchangerate = ? where fid = ? and fentryid = ?": {
                index = 2;
                break;
            }
        }
        for (Object[] obj : paramsList) {
            vchIds.add(Long.parseLong(obj[index] + ""));
        }
        return vchIds;
    }

    public void lastBatchUpdateLocalShort() {
        Set<Long> vchIds = this.getVchIds(this.maxOriDebitWithRateParamsList, updateSql_OriDebitWithRate);
        this.checkToExecuteBatchShortUpdate(1, this.maxOriDebitWithRateParamsList, updateSql_OriDebitWithRate, vchIds);
        vchIds = this.getVchIds(this.maxOriDebitParamsList, updateSql_OriDebit);
        this.checkToExecuteBatchShortUpdate(1, this.maxOriDebitParamsList, updateSql_OriDebit, vchIds);
        vchIds = this.getVchIds(this.maxOriCreditWithRateParamsList, updateSql_OriCreditWithRate);
        this.checkToExecuteBatchShortUpdate(1, this.maxOriCreditWithRateParamsList, updateSql_OriCreditWithRate, vchIds);
        vchIds = this.getVchIds(this.maxOriCreditParamsList, updateSql_OriCredit);
        this.checkToExecuteBatchShortUpdate(1, this.maxOriCreditParamsList, updateSql_OriCredit, vchIds);
        vchIds = this.getVchIds(this.maxLocalDebitParamsList, updateSql_LocalDebit);
        this.checkToExecuteBatchShortUpdate(1, this.maxLocalDebitParamsList, updateSql_LocalDebit, vchIds);
        vchIds = this.getVchIds(this.maxLocalCreditParamsList, updateSql_LocalCredit);
        this.checkToExecuteBatchShortUpdate(1, this.maxLocalCreditParamsList, updateSql_LocalCredit, vchIds);
    }
}

