/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.operation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.bean.EntryFieldInfo;
import kd.fi.gl.bean.GlVoucherField;
import kd.fi.gl.business.service.synbook.VoucherRefTrackerService;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.VoucherStandardField;
import kd.fi.gl.finalprocess.VoucherEntryDBHelper;
import kd.fi.gl.finalprocess.merge.EntryMergeOption;
import kd.fi.gl.finalprocess.merge.VoucherEntryDSMergeHelper;
import kd.fi.gl.model.schema.synvoucher.SynVoucherSchema;
import kd.fi.gl.model.schema.synvoucher.VoucherConvertRuleSchema;
import kd.fi.gl.operation.BatchUpdateEntriesUtil;
import kd.fi.gl.operation.SingleBookSynResult;
import kd.fi.gl.operation.SynVoucherValidator;
import kd.fi.gl.operation.VoucherConvertInfo;
import kd.fi.gl.operation.VoucherConvertUtil;
import kd.fi.gl.operation.VoucherEntryConvertUtil;
import kd.fi.gl.operation.VoucherSummary;
import kd.fi.gl.service.dtxservice.AttachmentCopyParam;
import kd.fi.gl.synvoucher.AccountMapCache;
import kd.fi.gl.synvoucher.VoucherRefTrackerCollector;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MetaEntityUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.voucher.util.VoucherUtils;

public class SynBookVoucherService
extends EntityOperateService {
    private final Map<Long, DynamicObject> accDynCache = new HashMap<Long, DynamicObject>(32);
    private final Map<Long, DynamicObject> bookDynCache = new HashMap<Long, DynamicObject>(2);
    private final Map<Long, String> globalErrorCache = new HashMap<Long, String>(16);
    private final Map<Long, String> idAndNo = new HashMap<Long, String>(16);
    private VoucherRefTrackerCollector voucherRefTrackerCollector;
    private static final VoucherConvertRuleSchema RULE_SCHEMA = VoucherConvertRuleSchema.INSTANCE;
    private static final Log logger = LogFactory.getLog((String)SynBookVoucherService.class.getTypeName());
    private long selectDestBookTypeId;
    private DynamicObject voucherBosType;
    private Date now;
    private MainEntityType voucherMainEntityType;
    private AccountMapCache accountMapCache = new AccountMapCache();
    private Map<Long, DynamicObject> vouchers = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Set<Long>> bookIdVchIdMap = new HashMap<Long, Set<Long>>(2);
    private final Multimap<Long, Long> syncedVoucherIdsHistory = HashMultimap.create();
    private final Multimap<Long, Object> syncedVoucherIdsCurrent = HashMultimap.create();
    private GlVoucherField glVoucherField;

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.addAll(VoucherStandardField.ALL_HEAD_PROPS);
        this.glVoucherField = MetaEntityUtil.getGlVoucherField();
        if (this.glVoucherField != null) {
            List allHeadFields = this.glVoucherField.getAllHeadFields();
            Iterator iterator = allHeadFields.iterator();
            while (iterator.hasNext()) {
                String field = (String)iterator.next();
                if (!VoucherStandardField.ALL_HEAD_PROPS.contains(field) && !VoucherStandardField.NOREL_HEAD_PROPS.contains(field)) continue;
                iterator.remove();
            }
            fieldKeys.addAll(allHeadFields);
            this.glVoucherField.setAllHeadFields(allHeadFields);
        }
    }

    protected void addDefaultValidator(List<AbstractValidator> arg0) {
        arg0.add(new SynVoucherValidator());
        super.addDefaultValidator(arg0);
    }

    private Deque<DynamicObject> sortRules(long currentOrgID, DynamicObject[] rules) {
        List allParentOrgIds = PresetCashItemUtil.getAllSuperiorOrgIds((Long)currentOrgID, (boolean)false);
        LinkedList<DynamicObject> current = new LinkedList<DynamicObject>();
        LinkedList<DynamicObject> parents = new LinkedList<DynamicObject>();
        LinkedList<DynamicObject> other = new LinkedList<DynamicObject>();
        for (DynamicObject rule : rules) {
            long createOrgID = rule.getLong("createorg.id");
            if (currentOrgID == createOrgID) {
                current.add(rule);
                continue;
            }
            if (allParentOrgIds.contains(createOrgID)) {
                parents.add(rule);
                continue;
            }
            other.add(rule);
        }
        for (int i = allParentOrgIds.size(); i > 0; --i) {
            for (DynamicObject parent : parents) {
                if (!Objects.equals(parent.getLong("createorg.id"), allParentOrgIds.get(i - 1))) continue;
                current.add(parent);
            }
        }
        current.addAll(other);
        return current;
    }

    protected void executeOperate(DynamicObject[] arg0) {
        long start = System.currentTimeMillis();
        this.globalErrorCache.clear();
        this.selectDestBookTypeId = Long.parseLong(this.getOption().getVariableValue("Option_DestBookTypeId", "0"));
        this.groupByBook(arg0);
        this.cacheSrcBook(this.bookIdVchIdMap.keySet());
        this.now = new Date();
        this.voucherBosType = BusinessDataServiceHelper.loadSingle((Object)"gl_voucher", (String)"bos_entityobject");
        this.voucherMainEntityType = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        for (Map.Entry<Long, Set<Long>> bookIdVchIdSetEntry : this.bookIdVchIdMap.entrySet()) {
            this.dealBySingleSrcBook(bookIdVchIdSetEntry);
        }
        long end = System.currentTimeMillis();
        logger.info("SynBookVoucherService total cost: {} ms", (Object)(end - start));
    }

    private void dealBySingleSrcBook(Map.Entry<Long, Set<Long>> bookIdVchIdSetEntry) {
        Long srcBookId = bookIdVchIdSetEntry.getKey();
        DynamicObject srcBook = this.bookDynCache.get(srcBookId);
        long orgId = srcBook.getLong("org.id");
        long booksTypeId = srcBook.getLong("bookstype.id");
        DynamicObject[] ruleDyns = this.getRules(orgId, booksTypeId);
        Deque<DynamicObject> rules = this.sortRules(orgId, ruleDyns);
        HashSet<Object> inValidpkSet = new HashSet<Object>(bookIdVchIdSetEntry.getValue().size());
        inValidpkSet.addAll((Collection)bookIdVchIdSetEntry.getValue());
        HashMap<Long, Set<Object>> succeedCache = new HashMap<Long, Set<Object>>(2);
        for (DynamicObject rule : rules) {
            this.dealBySingleRule(bookIdVchIdSetEntry, rule, inValidpkSet, succeedCache);
        }
        for (Object vchedid : inValidpkSet) {
            if (this.globalErrorCache.containsKey(vchedid)) continue;
            this.globalErrorCache.put((Long)vchedid, ResManager.loadKDString((String)"\u9002\u7528\u7684\u51ed\u8bc1\u6298\u7b97\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"SynBookVoucherService_10", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
    }

    private void dealBySingleRule(Map.Entry<Long, Set<Long>> bookIdVchIdSetEntry, DynamicObject rule, Set<Object> inValidpkSet, Map<Long, Set<Object>> succeedCache) {
        Long srcBookId = bookIdVchIdSetEntry.getKey();
        Set<Long> vchids = bookIdVchIdSetEntry.getValue();
        DynamicObject srcBook = this.bookDynCache.get(srcBookId);
        long orgId = srcBook.getLong("org.id");
        List<Object> validVoucherpkList = this.filterByRule(vchids, rule);
        if (validVoucherpkList.isEmpty()) {
            return;
        }
        inValidpkSet.removeAll(validVoucherpkList);
        boolean isMergeEntry = this.checkIsMerge(rule.getString("ismergeentry"));
        EntryMergeOption entryMergeOption = this.initEntryMergeOption(isMergeEntry, rule.getString("entrymerge"));
        HashMap<Long, BigDecimal> orgSynRation = new HashMap<Long, BigDecimal>(16);
        boolean iscrossorgsyn = rule.getBoolean("iscrossorgsyn");
        if (iscrossorgsyn) {
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                long ruleSourceOrgId = entry.getLong("sourceorg_id");
                if (ruleSourceOrgId != orgId) continue;
                long ruleTargetOrgId = entry.getLong("targetorg_id");
                long selectDestOrgId = Long.parseLong(this.getOption().getVariableValue("Option_DestOrgId", "0"));
                if (selectDestOrgId != 0L && ruleTargetOrgId != selectDestOrgId) continue;
                BigDecimal synration = entry.getBigDecimal("synration");
                if (synration.compareTo(BigDecimal.ZERO) == 0) {
                    synration = new BigDecimal(100);
                }
                orgSynRation.put(ruleTargetOrgId, synration);
            }
        } else {
            orgSynRation.put(orgId, new BigDecimal(100));
        }
        Set<Long> targetOrgIds = orgSynRation.keySet();
        Map<Object, DynamicObject> targetBookDynMap = this.loadTargetBooks(rule, targetOrgIds);
        if (CollectionUtils.isEmpty(targetBookDynMap)) {
            for (Long vchedid : vchids) {
                if (this.globalErrorCache.containsKey(vchedid)) continue;
                this.globalErrorCache.put(vchedid, ResManager.loadKDString((String)"\u8bf7\u5728\u57fa\u7840\u8d44\u6599\u7ef4\u62a4\u76ee\u6807\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"SynBookVoucherService_20", (String)"fi-gl-mservice", (Object[])new Object[0]));
            }
            return;
        }
        for (DynamicObject destBook : targetBookDynMap.values()) {
            validVoucherpkList.removeAll(this.syncedVoucherIdsCurrent.get((Object)destBook.getLong("id")));
            this.syncedVoucherIdsCurrent.putAll((Object)destBook.getLong("id"), validVoucherpkList);
            SingleBookSynResult singleBookSynResult = this.dealBySingleDestBook(srcBook, destBook, rule, isMergeEntry, entryMergeOption, validVoucherpkList, succeedCache, orgSynRation);
            for (Object sourceVoucherId : validVoucherpkList) {
                String msgBuf = singleBookSynResult.getErrorInfo((Long)sourceVoucherId);
                if (msgBuf == null || this.syncedVoucherIdsHistory.containsEntry((Object)destBook.getLong("id"), sourceVoucherId)) continue;
                this.voucherRefTrackerCollector.addTracker((Long)sourceVoucherId, destBook.getLong("id"), msgBuf);
                this.globalErrorCache.put((Long)sourceVoucherId, msgBuf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleBookSynResult dealBySingleDestBook(DynamicObject srcBook, DynamicObject destBook, DynamicObject rule, boolean isMergeEntry, EntryMergeOption entryMergeOption, List<Object> validVoucherpkList, Map<Long, Set<Object>> succeedCache, Map<Long, BigDecimal> orgSynRation) {
        SingleBookSynResult singleBookSynResult = new SingleBookSynResult(destBook.getLong("id"));
        LinkedList<Map<String, Object>> allLockedInfoList = new LinkedList<Map<String, Object>>();
        try {
            Map<Object, DynamicObject> destVoucherMap;
            long srcBookId = srcBook.getLong("id");
            long destBookId = destBook.getLong("id");
            if (srcBookId == destBookId || validVoucherpkList.isEmpty()) {
                SingleBookSynResult singleBookSynResult2 = singleBookSynResult;
                return singleBookSynResult2;
            }
            List<Object> voucherIdList = this.filterByVoucherType(validVoucherpkList, this.getIncludeTypes(rule), singleBookSynResult);
            voucherIdList = this.filterByVoucherStatus(voucherIdList, rule.getString("targetstatus"), singleBookSynResult);
            Set<Object> srcVchIDsToSyn = this.getNoRelationSrcVchs(destBook, voucherIdList, succeedCache);
            if (Boolean.parseBoolean(this.getOption().getVariableValue("ignoreValidation", "false"))) {
                this.customMutex(validVoucherpkList, destBookId, allLockedInfoList, destBook.getString("bookstype.name"));
            }
            int newVoucherListSize = srcVchIDsToSyn.size();
            SequenceReader sReader = new SequenceReader(new DBRoute("gl"));
            Iterator newVoucherIDItr = Arrays.stream(sReader.getSequences((Object[])new Long[newVoucherListSize], "T_GL_VOUCHER", newVoucherListSize)).iterator();
            HashMap<Object, DynamicObject> relMap = new HashMap<Object, DynamicObject>(newVoucherListSize);
            Set srcAcctIds = VoucherUtils.getAccountIdSetByVoucherIds((Collection)BDUtil.extractToSet(srcVchIDsToSyn, Long.class::cast));
            VoucherConvertInfo voucherConvertInfo = VoucherConvertInfo.create().init(srcBook, destBook);
            ArrayList<String> selectFieldList = new ArrayList<String>(Arrays.asList("id,entries.seq,entries.edescription,entries.account,entries.currency,entries.measureunit,entries.creditori,entries.creditlocal,entries.debitori,entries.debitlocal,entries.localrate,entries.expiredate,entries.biznumrecord,entries.businessnum,entries.quantity,entries.assgrp,entries.assgrp.value,entries.entrydc,entries.price,entries.maincfitem,entries.maincfassgrp,entries.maincfamount,entries.suppcfitem,entries.suppcfamount,entries.eorg,entries.eperiod".split(",")));
            this.appendSelectField(selectFieldList);
            String selectFields = String.join((CharSequence)",", selectFieldList);
            DataSet vouchersEntries = VoucherEntryDBHelper.getSrcVoucherEntries(srcVchIDsToSyn, (String)selectFields);
            long currentSrcVid = 0L;
            VoucherConvertUtil voucherConvertUtil = new VoucherConvertUtil(this.accDynCache, this.accountMapCache, this.glVoucherField, voucherConvertInfo);
            voucherConvertUtil.processAssgrpMapping(voucherConvertInfo, voucherConvertUtil.getCustomAccountAssgrpMappingInfo(), this.accDynCache);
            HashMap<Long, Long> srcVidDestVidMap = new HashMap<Long, Long>(srcVchIDsToSyn.size());
            boolean currVchExceptionFlag = false;
            boolean isDestBudget = destBook.getBoolean("isbudget");
            boolean isSrcBookBudget = srcBook.getBoolean("isbudget");
            HashMap<Long, Boolean> accountIsBudget = new HashMap<Long, Boolean>(16);
            if (isSrcBookBudget && !isDestBudget) {
                DataSet copy = vouchersEntries.copy();
                while (copy.hasNext()) {
                    Row entryRow = copy.next();
                    accountIsBudget.put(entryRow.getLong("entries.account"), false);
                }
                if (accountIsBudget.size() > 0) {
                    ArrayList accountIds = new ArrayList(accountIsBudget.keySet());
                    SqlBuilder accountTypeSql = new SqlBuilder();
                    accountTypeSql.append(" select a.fid,b.faccounttype from t_bd_account a ", new Object[0]);
                    accountTypeSql.append(" inner join T_bd_accounttype b on a.faccounttypeid=b.fid ", new Object[0]);
                    accountTypeSql.appendIn(" where a.fid ", accountIds);
                    try (DataSet ds = DB.queryDataSet((String)"test", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)accountTypeSql);){
                        for (Row row : ds) {
                            accountIsBudget.put(row.getLong("fid"), AccountType.isBudgetProp((String)row.getString("faccounttype")));
                        }
                    }
                    boolean isAllAccountBudget = accountIsBudget.entrySet().stream().allMatch(x -> (Boolean)x.getValue());
                    if (isAllAccountBudget) {
                        Row entryRow = vouchersEntries.next();
                        long srcVid = entryRow.getLong("id");
                        singleBookSynResult.addErrorInfo(srcVid, ResManager.loadKDString((String)"\u6e90\u8d26\u7c3f\u542f\u7528\u9884\u7b97\u4f1a\u8ba1\uff0c\u76ee\u6807\u8d26\u7c3f\u672a\u542f\u7528\u9884\u7b97\u4f1a\u8ba1,\u539f\u51ed\u8bc1\u4ec5\u6709\u9884\u7b97\u79d1\u76ee\uff0c\u4e0d\u80fd\u8fdb\u884c\u534f\u540c\u64cd\u4f5c\u3002", (String)"SynBookVoucherService_21", (String)"fi-gl-mservice", (Object[])new Object[0]));
                        srcVidDestVidMap.remove(srcVid);
                        SingleBookSynResult singleBookSynResult3 = singleBookSynResult;
                        return singleBookSynResult3;
                    }
                }
            }
            while (vouchersEntries.hasNext()) {
                boolean budgetType;
                Row entryRow = vouchersEntries.next();
                if (isSrcBookBudget && !isDestBudget && (budgetType = ((Boolean)accountIsBudget.get(entryRow.getLong("entries.account"))).booleanValue())) continue;
                long srcVid = entryRow.getLong("id");
                if (!this.checkSameVoucher(currentSrcVid, srcVid)) {
                    currentSrcVid = srcVid;
                    currVchExceptionFlag = false;
                    Long destVid = (Long)newVoucherIDItr.next();
                    srcVidDestVidMap.put(srcVid, destVid);
                    try {
                        this.initVoucherHead(srcVid, destVid, voucherConvertInfo, voucherConvertUtil, srcAcctIds);
                    }
                    catch (Exception e) {
                        logger.error("initVoucherHead error, srcVid: {}, voucherConvertInfo: {} : ", new Object[]{srcVid, voucherConvertInfo, e});
                        currVchExceptionFlag = true;
                        singleBookSynResult.addErrorInfo(srcVid, e.getMessage());
                        voucherConvertUtil.clearVoucherCache();
                        srcVidDestVidMap.remove(srcVid);
                    }
                }
                if (currVchExceptionFlag) continue;
                try {
                    long targetOrgId = destBook.getLong("org.id");
                    BigDecimal synration = orgSynRation.get(targetOrgId);
                    if (synration == null || synration.compareTo(BigDecimal.ZERO) == 0) {
                        synration = new BigDecimal(100);
                    }
                    synration = synration.multiply(BigDecimal.valueOf(0.01));
                    this.dealSingleEntry(entryRow, voucherConvertInfo, voucherConvertUtil, destBook, synration);
                }
                catch (Exception e) {
                    logger.error("dealSingleEntry error, srcVid: {}, voucherConvertInfo: {} : ", new Object[]{srcVid, voucherConvertInfo, e});
                    singleBookSynResult.addErrorInfo(srcVid, e.getMessage());
                    currVchExceptionFlag = true;
                    voucherConvertUtil.clearVoucherCache();
                    srcVidDestVidMap.remove(srcVid);
                }
            }
            voucherConvertUtil.saveLastEntries();
            if (!voucherConvertInfo.isSameLocCurrency()) {
                voucherConvertUtil.handleLocalShortBatch();
                if (!voucherConvertUtil.getDestVoucherSummaryMap().isEmpty() && CashFlowItemHelper.permitDesignCashflowByPeriod((long)destBook.getLong(GLField.id_((String)"cashinitperiod")), (long)voucherConvertUtil.getDestVoucher().getLong(GLField.id_((String)"period")))) {
                    this.calcCFAndSuppCfByRate(voucherConvertUtil.getDestVoucherSummaryMap(), voucherConvertInfo.getDestBook().getLocCurrency());
                }
                voucherConvertUtil.handleCfShortBatch();
            }
            if ((destVoucherMap = voucherConvertUtil.getDestVoucherMap()).size() == 0) {
                SingleBookSynResult srcVid = singleBookSynResult;
                return srcVid;
            }
            if (isMergeEntry) {
                try {
                    long mergeStart = System.currentTimeMillis();
                    Map mergedDestVidMap = VoucherEntryDSMergeHelper.create().init(entryMergeOption, this.glVoucherField).merge(destVoucherMap.keySet());
                    long mergeEnd = System.currentTimeMillis();
                    logger.info("SynBookVoucherService VoucherEntryDSMergeHelper.merge cost: {} ms", (Object)(mergeEnd - mergeStart));
                    LinkedHashMap<Object, DynamicObject> mergedDestVoucherMap = new LinkedHashMap<Object, DynamicObject>(mergedDestVidMap.size());
                    for (Map.Entry srcVidDestVid : srcVidDestVidMap.entrySet()) {
                        Long destVid = (Long)srcVidDestVid.getValue();
                        Long mergedDestVid = (Long)mergedDestVidMap.get(destVid);
                        srcVidDestVidMap.put((Long)srcVidDestVid.getKey(), mergedDestVid);
                        DynamicObject destVoucher = destVoucherMap.get(destVid);
                        destVoucher.set("id", (Object)mergedDestVid);
                        mergedDestVoucherMap.put(mergedDestVid, destVoucher);
                    }
                    destVoucherMap = mergedDestVoucherMap;
                }
                catch (Exception e) {
                    logger.error("VoucherEntryDSMergeHelper.merge error: ", (Throwable)e);
                    this.deleteFailedVoucherEntriesInException(destVoucherMap.keySet());
                    destVoucherMap.clear();
                    for (Long srcVid : srcVidDestVidMap.keySet()) {
                        singleBookSynResult.addErrorInfo(srcVid, "VoucherEntryDSMergeHelper.merge error: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    }
                    srcVidDestVidMap.clear();
                }
            }
            if (destVoucherMap.size() == 0) {
                SingleBookSynResult e = singleBookSynResult;
                return e;
            }
            for (Map.Entry e : srcVidDestVidMap.entrySet()) {
                DynamicObject rel2 = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher_relation");
                rel2.set("srcvoucherid", e.getKey());
                rel2.set("destvoucherid", e.getValue());
                rel2.set("createdate", (Object)this.now);
                rel2.set("srcbook_id", (Object)srcBookId);
                rel2.set("destbook_id", (Object)destBookId);
                rel2.set("ruleid", (Object)rule.getLong("id"));
                relMap.put(e.getValue(), rel2);
            }
            DynamicObjectType vchDType = voucherConvertUtil.getVoucherDT();
            BusinessDataWriter.save((IDataEntityType)vchDType, (Object[])destVoucherMap.values().toArray(new Object[0]));
            Object[] ids = destVoucherMap.keySet().toArray(new Long[0]);
            String vchStatus = rule.getString("targetstatus");
            long saveOrSubmitStart = System.currentTimeMillis();
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isdap", "true");
            operateOption.setVariableValue("sysvoucher", "true");
            operateOption.setVariableValue("isFirstOperation", "true");
            operateOption.setVariableValue("skipCheckSpecialDataPermission", "true");
            HashMap<String, OperationResult> operationResultMap = new HashMap<String, OperationResult>(4);
            if ("A".equalsIgnoreCase(vchStatus)) {
                operationResultMap.put("save", OperationServiceHelper.executeOperate((String)"save", (String)"gl_voucher", (Object[])ids, (OperateOption)operateOption));
            } else {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"gl_voucher", (Object[])ids, (OperateOption)operateOption);
                operationResultMap.put("submit", operationResult);
                List successPkIds = operationResult.getSuccessPkIds();
                if (!CollectionUtils.isEmpty((Collection)successPkIds) && !"B".equals(vchStatus)) {
                    operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"gl_voucher", (Object[])successPkIds.toArray(), (OperateOption)operateOption);
                    operationResultMap.put("audit", operationResult);
                    successPkIds = operationResult.getSuccessPkIds();
                    List<Object> needCheckVchIdList = this.getCheckVoucherIds(successPkIds, relMap);
                    if (!CollectionUtils.isEmpty(needCheckVchIdList)) {
                        operationResult = OperationServiceHelper.executeOperate((String)"vouchercheck", (String)"gl_voucher", (Object[])needCheckVchIdList.toArray(), (OperateOption)operateOption);
                        operationResultMap.put("vouchercheck", operationResult);
                    }
                    successPkIds.remove(needCheckVchIdList.remove(operationResult.getSuccessPkIds()));
                    if (!CollectionUtils.isEmpty((Collection)successPkIds) && "D".equals(vchStatus) && !CollectionUtils.isEmpty((Collection)successPkIds)) {
                        operationResult = OperationServiceHelper.executeOperate((String)"post", (String)"gl_voucher", (Object[])successPkIds.toArray(), (OperateOption)operateOption);
                        operationResultMap.put("post", operationResult);
                    }
                }
            }
            long saveOrSubmitEnd = System.currentTimeMillis();
            logger.info("SynBookVoucherService saveOrSubmit cost: {} ms", (Object)(saveOrSubmitEnd - saveOrSubmitStart));
            HashSet succids = new HashSet(8);
            operationResultMap.values().forEach(result -> succids.addAll(result.getSuccessPkIds()));
            for (Map.Entry entry : operationResultMap.entrySet()) {
                String opKey = (String)entry.getKey();
                OperationResult operationResult = (OperationResult)entry.getValue();
                String tipMsg = this.getTipMsgByOp(opKey);
                if (operationResult.isSuccess()) continue;
                List errs = operationResult.getAllErrorOrValidateInfo();
                HashSet<Object> failedVids = new HashSet<Object>(8);
                for (IOperateInfo err : errs) {
                    DynamicObject rel3 = (DynamicObject)relMap.get(err.getPkValue());
                    failedVids.add(err.getPkValue());
                    singleBookSynResult.addErrorInfo(rel3.getLong("srcvoucherid"), (String)tipMsg + err.getMessage());
                }
                if (!operationResult.isSuccess() && errs.isEmpty()) {
                    Arrays.stream(ids).filter(pk -> !succids.contains(pk)).forEach(pkFailed -> {
                        failedVids.add(pkFailed);
                        long srcVoucherID = ((DynamicObject)relMap.get(pkFailed)).getLong("srcvoucherid");
                        singleBookSynResult.addErrorInfo(srcVoucherID, tipMsg + operationResult.getMessage());
                    });
                }
                if (!"save".equals(opKey) && !"submit".equals(opKey)) continue;
                this.deleteFailedVouchers(vchDType, failedVids);
            }
            Long bookTypeid = destBook.getLong("bookstype.id");
            Set set = succeedCache.computeIfAbsent(bookTypeid, k -> new HashSet(32));
            DynamicObject[] rels = new DynamicObject[succids.size()];
            int m = 0;
            for (Object succid : succids) {
                rels[m++] = (DynamicObject)relMap.get(succid);
                set.add(((DynamicObject)relMap.get(succid)).getLong("srcvoucherid"));
            }
            SaveServiceHelper.save((DynamicObject[])rels);
            this.registerAttachmentsCopyDtx(rels);
            List voucherIdTargetBookIdTupleList = Arrays.stream(rels).map(rel -> Tuple.create((Object)rel.getLong("srcvoucherid"), (Object)rel.getLong("destbook_id"))).collect(Collectors.toList());
            VoucherRefTrackerService.deleteBySrcVoucherAndTargetBook(voucherIdTargetBookIdTupleList);
            OperationResult auditResult = (OperationResult)operationResultMap.get("audit");
            if (Objects.nonNull(auditResult) && !CollectionUtils.isEmpty((Collection)auditResult.getSuccessPkIds())) {
                this.updateOperatorAndTime(auditResult.getSuccessPkIds(), relMap);
            }
        }
        finally {
            DataMutex.create().batchRelease(allLockedInfoList);
        }
        return singleBookSynResult;
    }

    private List<Object> filterByVoucherStatus(List<Object> voucherIdList, String targetStatus, SingleBookSynResult singleBookSynResult) {
        ArrayList<Object> validVchIdList = new ArrayList<Object>(8);
        if ("D".equals(targetStatus)) {
            for (Object voucherId : voucherIdList) {
                DynamicObject voucherDyn = this.vouchers.get(voucherId);
                boolean post = voucherDyn.getBoolean("ispost");
                if (!post) {
                    singleBookSynResult.addErrorInfo((Long)voucherId, ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u5df2\u8fc7\u8d26\u72b6\u6001\u7684\u51ed\u8bc1\u3002", (String)"SynBookVoucherService_22", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                validVchIdList.add(voucherId);
            }
            return validVchIdList;
        }
        return voucherIdList;
    }

    private void registerAttachmentsCopyDtx(DynamicObject[] relations) {
        Map<Long, Long> effectiveRelationMap = Arrays.stream(relations).filter(r -> this.vouchers.get(r.getLong("srcvoucherid")).getInt("attachment") > 0).collect(Collectors.toMap(r -> r.getLong("srcvoucherid"), r -> r.getLong("destvoucherid"), (o, n) -> n));
        if (effectiveRelationMap.isEmpty()) {
            return;
        }
        logger.info("Initiating kdtx for copying attachments.");
        ECGlobalSession.begin((String)"copy_vch_attachments", (DBRoute)DBRoute.of((String)"fi"), (boolean)true);
        ECGlobalSession.setBusinessType((String)"gl_voucher");
        ECGlobalSession.setAsync((boolean)true);
        AttachmentCopyParam param = new AttachmentCopyParam();
        param.setRelationMap(effectiveRelationMap);
        ECGlobalSession.register((String)"fi", (String)"gl", (String)"AttachmentsCopyService", (Param)param);
    }

    private void appendSelectField(List<String> selectFieldList) {
        if (this.glVoucherField != null) {
            List allEntryFieldInfos = this.glVoucherField.getAllEntryFieldInfos();
            Iterator iterator = allEntryFieldInfos.iterator();
            while (iterator.hasNext()) {
                EntryFieldInfo entryFieldInfo = (EntryFieldInfo)iterator.next();
                String fullName = entryFieldInfo.getFullName();
                if (selectFieldList.contains(fullName) || VoucherStandardField.NOREL_ENTRY_PROPS.contains(fullName)) {
                    iterator.remove();
                    continue;
                }
                selectFieldList.add(fullName);
            }
            this.glVoucherField.setAllEntryFieldInfos(allEntryFieldInfos);
        }
    }

    private void dealSingleEntry(Row srcEntryRow, VoucherConvertInfo voucherConvertInfo, VoucherConvertUtil voucherConvertUtil, DynamicObject destBook, BigDecimal synration) throws Exception {
        VoucherSummary voucherSummary = voucherConvertUtil.getDestVoucherSummary();
        DynamicObject newEntry = voucherConvertUtil.createNewEntry();
        VoucherEntryConvertUtil.setAccount(newEntry, srcEntryRow, voucherConvertUtil, voucherConvertInfo, this.accDynCache);
        VoucherEntryConvertUtil.setLocal(newEntry, srcEntryRow, voucherConvertInfo, voucherSummary.srcVid, voucherSummary.bookDate, synration);
        VoucherEntryConvertUtil.setOri(newEntry, srcEntryRow, voucherConvertInfo, synration);
        if (CashFlowItemHelper.permitDesignCashflowByPeriod((long)destBook.getLong(GLField.id_((String)"cashinitperiod")), (long)voucherConvertUtil.getDestVoucher().getLong(GLField.id_((String)"period")))) {
            VoucherEntryConvertUtil.setMainAndSuppCf(newEntry, srcEntryRow, voucherConvertInfo, voucherSummary.srcVid, voucherSummary.bookDate, synration);
        }
        VoucherEntryConvertUtil.setAssGrp(newEntry, srcEntryRow, voucherConvertUtil);
        VoucherEntryConvertUtil.setPriceQtyUnit(newEntry, srcEntryRow, synration);
        VoucherEntryConvertUtil.setExpireDate(newEntry, voucherSummary.bizDate);
        VoucherEntryConvertUtil.setOtherEntryFields(newEntry, srcEntryRow, voucherSummary.orgId, voucherSummary.periodId, this.glVoucherField);
        voucherSummary.recordAccountType(newEntry.getDynamicObject("account"));
        long destLocCurrencyId = voucherConvertInfo.getDestBook().getLocCurrency().getLong("id");
        voucherSummary.recordMaxEntryAndTotal(srcEntryRow, newEntry, destLocCurrencyId, this.accDynCache);
    }

    private void initVoucherHead(long srcVid, Long destVid, VoucherConvertInfo voucherConvertInfo, VoucherConvertUtil voucherConvertUtil, Set<Long> srcAcctIds) throws Exception {
        DynamicObject srcVoucher = this.vouchers.get(srcVid);
        DynamicObject destVoucher = voucherConvertUtil.createDestVoucher(destVid, srcVoucher);
        this.setDestVoucherValue(destVoucher, srcVid, voucherConvertInfo);
        voucherConvertUtil.getDestVoucherSummaryMap().put(destVid, new VoucherSummary(destVoucher, srcVid));
        voucherConvertUtil.initDestAccIdDynMap(srcAcctIds, voucherConvertInfo);
    }

    private boolean checkSameVoucher(long currentVoucherId, long vid) {
        return Objects.equals(currentVoucherId, vid);
    }

    private void setDestVoucherValue(DynamicObject destVoucher, long srcVid, VoucherConvertInfo voucherConvertInfo) throws Exception {
        destVoucher.set("errorstatus", (Object)"0");
        destVoucher.set("errormsg", (Object)"");
        destVoucher.set("isreverse", (Object)Boolean.FALSE);
        destVoucher.set("billno", null);
        destVoucher.set("sourcesys_id", (Object)"83bfebc8000017ac");
        destVoucher.set("sourcebilltype", (Object)this.voucherBosType);
        destVoucher.set("sourcebill", (Object)srcVid);
        destVoucher.set("sourcetype", (Object)"a");
        destVoucher.set("auditor", null);
        destVoucher.set("poster", null);
        destVoucher.set("cashier", null);
        destVoucher.set("ischeck", (Object)"a");
        destVoucher.set("createtime", (Object)new Date());
        destVoucher.set("auditdate", null);
        destVoucher.set("posttime", null);
        destVoucher.set("ispost", (Object)Boolean.FALSE);
        destVoucher.set("billstatus", (Object)"A");
        DynamicObject newLocCurrency = voucherConvertInfo.getDestBook().getLocCurrency();
        long newLocCurrencyID = newLocCurrency.getLong("id");
        destVoucher.set("localcur", (Object)newLocCurrency);
        destVoucher.set("localcur_id", (Object)newLocCurrencyID);
        DynamicObject destBook = voucherConvertInfo.getDestBook().getBook();
        long destBookId = voucherConvertInfo.getDestBook().getBookId();
        destVoucher.set("book", (Object)destBook);
        destVoucher.set("book_id", (Object)destBookId);
        long destOrgId = voucherConvertInfo.getDestBook().getBookOrgId();
        DynamicObject destOrg = BusinessDataServiceHelper.loadSingle((Object)destOrgId, (String)"bos_org");
        destVoucher.set("org", (Object)destOrg);
        destVoucher.set("org_id", (Object)destOrgId);
        destVoucher.set("booktype", (Object)destBook.getDynamicObject("bookstype"));
        destVoucher.set("booktype_id", (Object)destBook.getLong("bookstype.id"));
        if (!voucherConvertInfo.isSamePeriodType()) {
            DynamicObject period = Optional.ofNullable(GLUtil.getPeriodByDate((Date)destVoucher.getDate("bookeddate"), (long)destBook.getLong("periodtype.id"), (Boolean)Boolean.FALSE)).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u6620\u5c04\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u8d26\u7c3f\u7684\u671f\u95f4\u7c7b\u578b\u4e0b\u662f\u5426\u5df2\u5efa\u7acb\u76f8\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"SynBookVoucherService_19", (String)GLApp.instance.mServiceModule(), (Object[])new Object[0])));
            destVoucher.set("period", (Object)period);
            destVoucher.set("period_id", (Object)period.getLong("id"));
        }
        long srcBookOrgId = voucherConvertInfo.getSrcBook().getBookOrgId();
        String vchTypeName = destVoucher.getString("vouchertype.name");
        DynamicObject vouchertype = this.getVchTypeNameDynMap(srcBookOrgId).get(vchTypeName);
        if (vouchertype == null) {
            vouchertype = BusinessDataServiceHelper.loadSingleFromCache((Object)destBook.getLong("defaultvouchertype_id"), (String)"gl_vouchertype", (String)String.join((CharSequence)",", "number", "name", "isdefault", "islimitmultdc"));
        }
        if (vouchertype == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u76ee\u6807\u8d26\u7c3f\u4e0d\u5b58\u5728\u540c\u540d\u51ed\u8bc1\u7c7b\u578b\u201c%s\u201d\uff0c\u4e5f\u672a\u8bbe\u7f6e\u8d26\u7c3f\u9ed8\u8ba4\u51ed\u8bc1\u7c7b\u578b\u3002", (String)"SynBookVoucherService_3", (String)GLApp.instance.mServiceModule(), (Object[])new Object[0]), vchTypeName);
            throw new Exception(errorMsg);
        }
        destVoucher.set("vouchertype", (Object)vouchertype);
        destVoucher.set("vouchertype_id", vouchertype.getPkValue());
    }

    private void calcCFAndSuppCfByRate(Map<Object, VoucherSummary> destVoucherSummaryMap, DynamicObject destLocCurrency) {
        DataSet destEntriesDS = VoucherEntryDBHelper.getDestVoucherEntries(destVoucherSummaryMap.keySet());
        BigDecimal maxSuppCfAmount = BigDecimal.ZERO;
        BigDecimal maxMainCfAmount = BigDecimal.ZERO;
        BatchUpdateEntriesUtil batchUpdateEntriesUtil = new BatchUpdateEntriesUtil();
        long currentVid = 0L;
        VoucherSummary voucherSummary = null;
        while (destEntriesDS.hasNext()) {
            BigDecimal rate;
            BigDecimal newCashLocalAmount;
            Row entryRow = destEntriesDS.next();
            long vid = entryRow.getLong("fid");
            if (!this.checkSameVoucher(currentVid, vid)) {
                currentVid = vid;
                voucherSummary = destVoucherSummaryMap.get(vid);
                maxSuppCfAmount = BigDecimal.ZERO;
                maxMainCfAmount = BigDecimal.ZERO;
            }
            long entryid = entryRow.getLong("fentryid");
            long account = entryRow.getLong("faccountid");
            DynamicObject acct = this.accDynCache.get(account);
            long maincfitemId = entryRow.getLong("fmaincfitemid");
            BigDecimal mainCfAmount = entryRow.getBigDecimal("fmaincfamount");
            BigDecimal suppCfAmount = entryRow.getBigDecimal("fsuppcfamount");
            String direction = "";
            boolean isdealactivity = false;
            if (maincfitemId != 0L) {
                DynamicObject maincfitem = BusinessDataServiceHelper.loadSingleFromCache((Object)maincfitemId, (String)"gl_cashflowitem", (String)"isdealactivity,direction");
                isdealactivity = maincfitem.getBoolean("isdealactivity");
                direction = maincfitem.getString("direction");
            }
            if (null == voucherSummary) {
                throw new RuntimeException("voucherSummary is null");
            }
            BigDecimal cashLocalAmount = voucherSummary.cashLocalAmount;
            BigDecimal newMainCfAmount = null;
            if (!GLUtil.isCashAcct((DynamicObject)acct) && cashLocalAmount.compareTo(BigDecimal.ZERO) != 0 && null != (newMainCfAmount = (newCashLocalAmount = voucherSummary.newCashLocalAmount).multiply(rate = mainCfAmount == null || mainCfAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : mainCfAmount.divide(cashLocalAmount, 15, RoundingMode.HALF_UP)).setScale(destLocCurrency.getInt("amtprecision"), RoundingMode.HALF_UP))) {
                voucherSummary.newMainCfAmountTotal = "o".equals(direction) ? voucherSummary.newMainCfAmountTotal.subtract(newMainCfAmount) : voucherSummary.newMainCfAmountTotal.add(newMainCfAmount);
                if (maxMainCfAmount.compareTo(newMainCfAmount.abs()) < 0) {
                    maxMainCfAmount = newMainCfAmount.abs();
                    voucherSummary.maxLocalMaincfEntry.setMainCfInfo(vid, entryid, acct, newMainCfAmount, direction, isdealactivity);
                }
            }
            BigDecimal newSuppcfAmount = null;
            if (entryRow.getLong("fsuppcfitemid") != 0L && !GLUtil.isCashAcct((DynamicObject)acct)) {
                if (voucherSummary.isHasCash) {
                    if (GLUtil.isPLAcct((DynamicObject)acct) && !isdealactivity) {
                        newSuppcfAmount = entryRow.getBigDecimal("flocaldebit").subtract(entryRow.getBigDecimal("flocalcredit"));
                    } else if (!GLUtil.isPLAcct((DynamicObject)acct) && isdealactivity) {
                        if ("o".equals(direction)) {
                            if (mainCfAmount != null) {
                                newSuppcfAmount = mainCfAmount.negate();
                            }
                        } else {
                            newSuppcfAmount = mainCfAmount;
                        }
                    }
                } else if (!voucherSummary.isHasCash && !voucherSummary.isHasPL && voucherSummary.isNoCashAndPL) {
                    if (suppCfAmount.compareTo(BigDecimal.ZERO) != 0) {
                        newSuppcfAmount = entryRow.getBigDecimal("flocaldebit").subtract(entryRow.getBigDecimal("flocalcredit"));
                    }
                } else if (!voucherSummary.isHasCash && voucherSummary.isHasPL && voucherSummary.isNoCashAndPL) {
                    BigDecimal cashSuppcfAmount = voucherSummary.cashSuppcfAmount;
                    BigDecimal rate2 = suppCfAmount == null || suppCfAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : suppCfAmount.divide(cashSuppcfAmount, 15, 4);
                    BigDecimal newcashSuppcfAmount = voucherSummary.newcashSuppcfAmount;
                    newSuppcfAmount = newcashSuppcfAmount.multiply(rate2).setScale(destLocCurrency.getInt("amtprecision"), 4);
                    voucherSummary.newSuppcfAmountTotal = voucherSummary.newSuppcfAmountTotal.add(newSuppcfAmount);
                    if (maxSuppCfAmount.compareTo(newSuppcfAmount.abs()) < 0) {
                        maxSuppCfAmount = newSuppcfAmount.abs();
                        voucherSummary.maxLocalSuppcfEntry.setSuppCfInfo(vid, entryid, newSuppcfAmount);
                    }
                }
                if (null != newSuppcfAmount && Objects.equals(entryid, voucherSummary.maxLocalMaincfEntry.entryId)) {
                    voucherSummary.maxLocalMaincfEntry.suppcfamount = newSuppcfAmount;
                }
            }
            batchUpdateEntriesUtil.addToBatchUpdateEntries(vid, entryid, newMainCfAmount, newSuppcfAmount);
        }
        batchUpdateEntriesUtil.lastBatchUpdate();
        for (VoucherSummary vchSummary : destVoucherSummaryMap.values()) {
            BigDecimal newMainCfAmountTotal = vchSummary.newMainCfAmountTotal;
            BigDecimal newCashLocalAmount = vchSummary.newCashLocalAmount;
            if (newMainCfAmountTotal != null && newMainCfAmountTotal.compareTo(BigDecimal.ZERO) != 0 && newMainCfAmountTotal.abs().compareTo(newCashLocalAmount.abs()) != 0 && null != vchSummary.maxLocalMaincfEntry.entryId) {
                BigDecimal subtract = newCashLocalAmount.subtract(newMainCfAmountTotal);
                BigDecimal maincfamount = vchSummary.maxLocalMaincfEntry.maincfamount;
                BigDecimal newmaincfamount = "o".equals(vchSummary.maxLocalMaincfEntry.maincfitemDirection) ? maincfamount.subtract(subtract) : maincfamount.add(subtract);
                BigDecimal newSuppcfAmount = null;
                if (vchSummary.maxLocalMaincfEntry.suppcfamount != null) {
                    DynamicObject acct = vchSummary.maxLocalMaincfEntry.account;
                    boolean isdealactivity = vchSummary.maxLocalMaincfEntry.maincfitemIsdealactivity;
                    String direction = vchSummary.maxLocalMaincfEntry.maincfitemDirection;
                    if (!GLUtil.isCashAcct((DynamicObject)acct) && vchSummary.isHasCash && !GLUtil.isPLAcct((DynamicObject)acct) && isdealactivity) {
                        newSuppcfAmount = "o".equals(direction) ? newmaincfamount.negate() : newmaincfamount;
                        vchSummary.newSuppcfAmountTotal = vchSummary.newSuppcfAmountTotal.subtract(vchSummary.maxLocalMaincfEntry.suppcfamount).add(newSuppcfAmount);
                    }
                }
                batchUpdateEntriesUtil.addToBatchUpdateEntries(vchSummary.maxLocalMaincfEntry.id, vchSummary.maxLocalMaincfEntry.entryId, newmaincfamount, newSuppcfAmount);
            }
            BigDecimal newSuppcfAmountTotal = vchSummary.newSuppcfAmountTotal;
            BigDecimal cashSuppcfAmount = vchSummary.newcashSuppcfAmount;
            if (!vchSummary.isHasCash && vchSummary.isHasPL && vchSummary.isNoCashAndPL && newSuppcfAmountTotal.compareTo(BigDecimal.ZERO) != 0 && newSuppcfAmountTotal.abs().compareTo(cashSuppcfAmount.abs()) != 0 && null != vchSummary.maxLocalSuppcfEntry.entryId) {
                BigDecimal newSuppcfAmount = vchSummary.maxLocalSuppcfEntry.suppcfamount.add(cashSuppcfAmount.subtract(newSuppcfAmountTotal));
                batchUpdateEntriesUtil.addToBatchUpdateEntries(vchSummary.maxLocalSuppcfEntry.id, vchSummary.maxLocalSuppcfEntry.entryId, null, newSuppcfAmount);
            }
            batchUpdateEntriesUtil.lastBatchUpdate();
        }
    }

    private Set<Object> getNoRelationSrcVchs(DynamicObject destBook, List<Object> srcVchIDs, Map<Long, Set<Object>> succeedCache) {
        DataSet srcidSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher_relation", (String)"srcvoucherid", (QFilter[])new QFilter[]{new QFilter("destbook", "=", destBook.getPkValue()), new QFilter("srcvoucherid", "in", srcVchIDs)}, null);
        HashSet<Object> hasVched = new HashSet<Object>(4);
        for (Row row : srcidSet) {
            hasVched.add(row.get("srcvoucherid"));
        }
        HashSet<Object> bookVL = new HashSet<Object>(srcVchIDs);
        bookVL.removeAll(hasVched);
        Set<Object> suids = succeedCache.get(destBook.getLong("bookstype.id"));
        for (Object e : hasVched) {
            if (suids != null && suids.contains(e)) continue;
            this.syncedVoucherIdsHistory.put((Object)destBook.getLong("id"), (Object)((Long)e));
            this.globalErrorCache.put((Long)e, String.format(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8fc7\u8d26\u7c3f\u201c%s\u201d\u7684\u6298\u7b97\u51ed\u8bc1\u3002", (String)"SynBookVoucherService_16", (String)"fi-gl-mservice", (Object[])new Object[0]), destBook.getString("bookstype.name")));
        }
        return bookVL;
    }

    public OperationResult excute(Object[] ids) throws Exception {
        this.voucherRefTrackerCollector = new VoucherRefTrackerCollector(ids.length);
        OperationResult sr = super.excute(ids);
        if (!this.globalErrorCache.isEmpty()) {
            for (Map.Entry<Long, String> me : this.globalErrorCache.entrySet()) {
                OperateErrorInfo eo = new OperateErrorInfo();
                eo.setPkValue((Object)me.getKey());
                eo.setMessage(this.idAndNo.get(me.getKey()) + "\uff1a" + me.getValue());
                eo.setTitle(this.getOpName());
                eo.setErrorLevel(ErrorLevel.Error.toString());
                sr.addErrorInfo(eo);
                sr.getSuccessPkIds().remove(me.getKey());
            }
        }
        return sr;
    }

    private void groupByBook(DynamicObject[] voucherArr) {
        for (DynamicObject dy : voucherArr) {
            this.vouchers.put(dy.getLong("id"), dy);
            this.idAndNo.put(dy.getLong("id"), dy.getString("billno"));
            long bookID = dy.getLong("book.id");
            this.bookIdVchIdMap.putIfAbsent(bookID, new HashSet());
            Set<Long> vchids = this.bookIdVchIdMap.get(bookID);
            vchids.add(dy.getLong("id"));
        }
    }

    private void cacheSrcBook(Set<Long> srcBookIds) {
        Map bookIdDynMap = BusinessDataServiceHelper.loadFromCache((Object[])srcBookIds.toArray(), (String)"gl_accountbook");
        this.bookDynCache.putAll(bookIdDynMap.entrySet().stream().collect(Collectors.toMap(x -> Long.valueOf(x.getKey().toString()), Map.Entry::getValue)));
    }

    private DynamicObject[] getRules(long orgId, long booksTypeId) {
        boolean realTime = this.getOption().containsVariable(SynVoucherSchema.INSTANCE.Option_RealTime.toTypeName());
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_voucher_rulecondition", (Long)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFBuilder ruleFilterBuilder = new QFBuilder();
        ruleFilterBuilder.add(baseFilter);
        ruleFilterBuilder.add(enableFilter);
        if (realTime) {
            ruleFilterBuilder.add(SynBookVoucherService.RULE_SCHEMA.exeWay.toFilter((Object)"ontime"));
        }
        ruleFilterBuilder.add("sourceaccbooktype.id", "=", (Object)booksTypeId);
        ruleFilterBuilder.add("iscrossorgsyn", "=", (Object)Boolean.TRUE);
        ruleFilterBuilder.add("entryentity.sourceorg", "=", (Object)orgId);
        long selectDestOrgId = Long.parseLong(this.getOption().getVariableValue("Option_DestOrgId", "0"));
        if (selectDestOrgId != 0L) {
            ruleFilterBuilder.add("entryentity.targetorg", "=", (Object)selectDestOrgId);
        }
        if (this.selectDestBookTypeId > 0L) {
            ruleFilterBuilder.add("targetaccbooktype.fbasedataid", "=", (Object)this.selectDestBookTypeId);
        }
        DynamicObject[] ruleDyns = BusinessDataServiceHelper.load((String)"gl_voucher_rulecondition", (String)"voucherfilterjson,targetaccbooktype.id,targetstatus,entrymerge,org.id,createorg.id,ismergeentry,iscrossorgsyn,entryentity.sourceorg,entryentity.targetorg,entryentity.synration,includetype", (QFilter[])ruleFilterBuilder.toArray());
        if (selectDestOrgId == 0L || orgId == selectDestOrgId) {
            ruleFilterBuilder = new QFBuilder();
            ruleFilterBuilder.add(baseFilter);
            ruleFilterBuilder.add(enableFilter);
            if (realTime) {
                ruleFilterBuilder.add(SynBookVoucherService.RULE_SCHEMA.exeWay.toFilter((Object)"ontime"));
            }
            ruleFilterBuilder.add("sourceaccbooktype.id", "=", (Object)booksTypeId);
            ruleFilterBuilder.add("iscrossorgsyn", "=", (Object)Boolean.FALSE);
            if (this.selectDestBookTypeId != 0L) {
                ruleFilterBuilder.add("targetaccbooktype.fbasedataid", "=", (Object)this.selectDestBookTypeId);
            }
            DynamicObject[] ruleDynsOld = BusinessDataServiceHelper.load((String)"gl_voucher_rulecondition", (String)"voucherfilterjson,targetaccbooktype.id,targetstatus,entrymerge,org.id,createorg.id,ismergeentry,iscrossorgsyn,entryentity.sourceorg,entryentity.targetorg,entryentity.synration,includetype", (QFilter[])ruleFilterBuilder.toArray());
            ruleDyns = (DynamicObject[])Stream.concat(Arrays.stream(ruleDyns), Arrays.stream(ruleDynsOld)).toArray(DynamicObject[]::new);
        }
        return ruleDyns;
    }

    private List<Object> filterByRule(Set<Long> vchids, DynamicObject rule) {
        FilterCondition filterCondition;
        List<Object> validVoucherpkList = new ArrayList<Object>(vchids);
        String filterJson = rule.getString("voucherfilterjson");
        if (filterJson != null && !filterJson.trim().equals("") && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class)) != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(this.voucherMainEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter qFilter = filterBuilder.getQFilter();
            QFilter idFilter = new QFilter("id", "in", vchids);
            validVoucherpkList = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{qFilter, idFilter}, null, (int)-1);
        }
        return validVoucherpkList;
    }

    private List<Object> filterByVoucherType(List<Object> validVoucherPkList, Set<String> includeTypes, SingleBookSynResult singleBookSynResult) {
        ArrayList<Object> vchIdList = new ArrayList<Object>(8);
        for (Object vchId : validVoucherPkList) {
            DynamicObject voucherDyn = this.vouchers.get(vchId);
            String voucherType = voucherDyn.getString("sourcetype");
            if ("1".equals(voucherType) || "2".equals(voucherType)) {
                if (includeTypes.contains(voucherType)) {
                    vchIdList.add(vchId);
                    continue;
                }
                if ("1".equals(voucherType)) {
                    singleBookSynResult.addErrorInfo((Long)vchId, ResManager.loadKDString((String)"\u7ed3\u8f6c\u635f\u76ca\u51ed\u8bc1\u4e0d\u652f\u6301\u51ed\u8bc1\u6298\u7b97\u3002", (String)"SynBookVoucherService_25", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                singleBookSynResult.addErrorInfo((Long)vchId, ResManager.loadKDString((String)"\u671f\u672b\u8c03\u6c47\u51ed\u8bc1\u4e0d\u652f\u6301\u51ed\u8bc1\u6298\u7b97\u3002", (String)"SynBookVoucherService_26", (String)"fi-gl-mservice", (Object[])new Object[0]));
                continue;
            }
            vchIdList.add(vchId);
        }
        return vchIdList;
    }

    private Set<String> getIncludeTypes(DynamicObject rule) {
        String[] includeTypes;
        HashSet<String> includeTypeSet = new HashSet<String>(8);
        for (String includeType : includeTypes = rule.getString("includetype").split(",")) {
            if (!"1".equalsIgnoreCase(includeType) && !"2".equalsIgnoreCase(includeType)) continue;
            includeTypeSet.add(includeType);
        }
        return includeTypeSet;
    }

    private boolean checkIsMerge(String ismergeentry) {
        return ismergeentry == null || ismergeentry.equals("A");
    }

    private EntryMergeOption initEntryMergeOption(boolean isMergeEntry, String mergeJson) {
        EntryMergeOption entryMergeOption = new EntryMergeOption();
        if (isMergeEntry && StringUtils.isNotBlank((CharSequence)mergeJson)) {
            Map entryMap = (Map)SerializationUtils.fromJsonString((String)mergeJson, Map.class);
            entryMergeOption.setDcMerge(((Boolean)entryMap.get("dcdiff")).booleanValue());
            entryMergeOption.setDescriptionMerge(((Boolean)entryMap.get("despdiff")).booleanValue());
            entryMergeOption.setPriceMerge(((Boolean)entryMap.get("pricediff")).booleanValue());
        }
        return entryMergeOption;
    }

    private Map<Object, DynamicObject> loadTargetBooks(DynamicObject rule, Set<Long> targetOrgIds) {
        Set<Long> targetBookTypeIdSet = this.selectDestBookTypeId > 0L ? new HashSet<Long>(Collections.singleton(this.selectDestBookTypeId)) : rule.getDynamicObjectCollection("targetaccbooktype").stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
        QFBuilder bookFilterBuilder = new QFBuilder();
        bookFilterBuilder.add("org", "in", targetOrgIds);
        bookFilterBuilder.add("bookstype", "in", targetBookTypeIdSet);
        Map targetBookDynMap = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (QFilter[])bookFilterBuilder.toArray());
        this.bookDynCache.putAll(targetBookDynMap.entrySet().stream().collect(Collectors.toMap(x -> Long.valueOf(x.getKey().toString()), Map.Entry::getValue)));
        return targetBookDynMap;
    }

    private void customMutex(List<Object> validVoucherpkList, long destBookID, List<Map<String, Object>> allLockedInfoList, String bookstypeName) {
        List lockInfoList = validVoucherpkList.stream().map(srcVch -> {
            HashMap<String, String> lockInfo = new HashMap<String, String>();
            lockInfo.put("dataObjId", srcVch.toString());
            lockInfo.put("operationKey", this.getOperationContext().getOperationKey());
            lockInfo.put("entityKey", SynVoucherSchema.INSTANCE.entity);
            lockInfo.put("groupId", destBookID + "");
            return lockInfo;
        }).collect(Collectors.toList());
        Map batchRequired = DataMutex.create().batchrequire(lockInfoList);
        batchRequired.forEach((pk, isSuccess) -> {
            if (isSuccess.booleanValue()) {
                HashMap<String, String> lockInfo = new HashMap<String, String>();
                lockInfo.put("dataObjId", (String)pk);
                lockInfo.put("operationKey", this.getOperationContext().getOperationKey());
                lockInfo.put("entityKey", SynVoucherSchema.INSTANCE.entity);
                lockInfo.put("groupId", destBookID + "");
                allLockedInfoList.add(lockInfo);
            } else {
                if (DebugTrace.enable()) {
                    logger.info("vch id %s is on syn.", pk);
                }
                this.globalErrorCache.put(Long.parseLong(pk), ResManager.loadKDString((String)"\u6b63\u5728\u534f\u540c\u5230\u8d26\u7c3f\u3010\u3011\uff0c\u65e0\u9700\u91cd\u590d\u534f\u540c\u3002", (String)"SynBookVoucherService_15", (String)"fi-gl-mservice", (Object[])new Object[]{bookstypeName}));
            }
        });
    }

    private Map<String, DynamicObject> getVchTypeNameDynMap(long orgId) {
        return (Map)ThreadCache.get((Object)("SynBookVoucherService_getAllVoucherTypes_" + orgId), () -> {
            QFilter vchTypeFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgId);
            Map vchTypeDynMap = BusinessDataServiceHelper.loadFromCache((String)"gl_vouchertype", (QFilter[])vchTypeFilter.toArray());
            return vchTypeDynMap.values().stream().collect(Collectors.toMap(x -> x.getString("name"), x -> x, (oldVal, newVal) -> newVal));
        });
    }

    private void deleteFailedVoucherEntriesInException(Set<Object> destVids) {
        String sqlTag = "deleteFailedVoucherEntriesInException";
        VoucherEntryDBHelper.deleteEntryById(destVids, (String)sqlTag);
    }

    private void deleteFailedVouchers(DynamicObjectType vchDType, Set<Object> failedVids) {
        if (CollectionUtils.isEmpty(failedVids)) {
            return;
        }
        logger.info("deleteFailedVouchers failedVids: {}", failedVids);
        try (TXHandle h = TX.required((String)"deleteFailedVouchers");){
            try {
                BusinessDataWriter.delete((IDataEntityType)vchDType, (Object[])failedVids.toArray(new Object[0]));
            }
            catch (Throwable e) {
                h.markRollback();
                logger.error("deleteFailedVouchers error, failedVids: {}", failedVids, (Object)e);
                throw e;
            }
        }
    }

    protected void release() {
        super.release();
        if (this.voucherRefTrackerCollector != null) {
            this.voucherRefTrackerCollector.close();
        }
    }

    private String getTipMsgByOp(String op) {
        switch (op) {
            case "save": {
                return ResManager.loadKDString((String)"\u6298\u7b97\u51ed\u8bc1\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"SynBookVoucherService_8", (String)"fi-gl-mservice", (Object[])new Object[0]);
            }
            case "submit": {
                return ResManager.loadKDString((String)"\u6298\u7b97\u51ed\u8bc1\u63d0\u4ea4\u5931\u8d25\uff1a", (String)"SynBookVoucherService_9", (String)"fi-gl-mservice", (Object[])new Object[0]);
            }
            case "audit": {
                return ResManager.loadKDString((String)"\u6298\u7b97\u51ed\u8bc1\u5ba1\u6838\u5931\u8d25\uff1a", (String)"SynBookVoucherService_23", (String)"fi-gl-mservice", (Object[])new Object[0]);
            }
            case "post": {
                return ResManager.loadKDString((String)"\u6298\u7b97\u51ed\u8bc1\u8fc7\u8d26\u5931\u8d25\uff1a", (String)"SynBookVoucherService_24", (String)"fi-gl-mservice", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private List<Object> getCheckVoucherIds(List<Object> successPkIds, Map<Object, DynamicObject> relMap) {
        HashMap<Long, Set> srcToDestVchIdMap = new HashMap<Long, Set>(8);
        for (Map.Entry<Object, DynamicObject> relEntry : relMap.entrySet()) {
            if (!successPkIds.contains(relEntry.getKey())) continue;
            long srcVchId = relEntry.getValue().getLong("srcvoucherid");
            Set destVchIdSet = srcToDestVchIdMap.computeIfAbsent(srcVchId, k -> new HashSet(8));
            destVchIdSet.add((Long)relEntry.getKey());
        }
        List checkSrcVchIdList = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{new QFilter("id", "in", srcToDestVchIdMap.keySet()), new QFilter("ischeck", "=", (Object)"c")}, null, (int)-1);
        ArrayList<Object> needCheckIdList = new ArrayList<Object>(8);
        for (Object checkSrcVchId : checkSrcVchIdList) {
            if (CollectionUtils.isEmpty((Collection)((Collection)srcToDestVchIdMap.get(checkSrcVchId)))) continue;
            needCheckIdList.addAll((Collection)srcToDestVchIdMap.get(checkSrcVchId));
        }
        return needCheckIdList;
    }

    private void updateOperatorAndTime(List<Object> succVchIdSet, Map<Object, DynamicObject> relMap) {
        HashMap<Long, Long> destToSrcVchIdMap = new HashMap<Long, Long>(8);
        for (Map.Entry<Object, DynamicObject> relEntry : relMap.entrySet()) {
            destToSrcVchIdMap.put((Long)relEntry.getKey(), relEntry.getValue().getLong("srcvoucherid"));
        }
        HashSet allVchIdSet = new HashSet(destToSrcVchIdMap.values());
        succVchIdSet.forEach(id -> allVchIdSet.add((Long)id));
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        statusFilter.or(new QFilter("ispost", "=", (Object)true));
        DynamicObject[] voucherDyns = BusinessDataServiceHelper.load((String)"gl_voucher", (String)String.join((CharSequence)",", "id", "auditor", "auditdate", "poster", "posttime", "cashier", "billstatus", "ischeck", "ispost"), (QFilter[])new QFilter[]{new QFilter("id", "in", allVchIdSet), statusFilter});
        HashMap<Long, DynamicObject> idToVoucherMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject voucherDyn : voucherDyns) {
            idToVoucherMap.put(voucherDyn.getLong("id"), voucherDyn);
        }
        HashSet<DynamicObject> updateDynSet = new HashSet<DynamicObject>(8);
        for (Map.Entry destToSrcVchIdEntry : destToSrcVchIdMap.entrySet()) {
            Long destVchId = (Long)destToSrcVchIdEntry.getKey();
            Long srcVchId = (Long)destToSrcVchIdEntry.getValue();
            DynamicObject destVchDyn = (DynamicObject)idToVoucherMap.get(destVchId);
            DynamicObject srcVchDyn = (DynamicObject)idToVoucherMap.get(srcVchId);
            this.setOperatorAndTime(destVchDyn, srcVchDyn);
            updateDynSet.add(destVchDyn);
        }
        SaveServiceHelper.save((DynamicObject[])updateDynSet.toArray(new DynamicObject[0]));
    }

    private void setOperatorAndTime(DynamicObject destVchDyn, DynamicObject srcVchDyn) {
        String billStatus;
        String check;
        boolean post = destVchDyn.getBoolean("ispost");
        if (post) {
            destVchDyn.set("poster", srcVchDyn.get("poster"));
            destVchDyn.set("posttime", srcVchDyn.get("posttime"));
        }
        if ("c".equals(check = destVchDyn.getString("ischeck"))) {
            destVchDyn.set("cashier", srcVchDyn.get("cashier"));
        }
        if ("C".equals(billStatus = destVchDyn.getString("billstatus"))) {
            destVchDyn.set("auditor", srcVchDyn.get("auditor"));
            destVchDyn.set("auditdate", srcVchDyn.get("auditdate"));
        }
    }
}

