/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.operation;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.util.AccountUtils;

public class VoucherConvertInfo {
    private GLBook srcBook;
    private GLBook destBook;
    private boolean samePeriodType;
    private boolean sameAccountTable;
    private boolean sameLocCurrency;
    private boolean sameExrateTable;
    private boolean crossOrg;

    public static VoucherConvertInfo create() {
        return new VoucherConvertInfo();
    }

    public VoucherConvertInfo init(DynamicObject srcBook, DynamicObject destBook) {
        this.setSrcBookAndDestBook(srcBook, destBook);
        return this;
    }

    public GLBook getSrcBook() {
        return this.srcBook;
    }

    public GLBook getDestBook() {
        return this.destBook;
    }

    public boolean isSamePeriodType() {
        return this.samePeriodType;
    }

    public boolean isSameAccountTable() {
        return this.sameAccountTable;
    }

    public boolean isSameLocCurrency() {
        return this.sameLocCurrency;
    }

    public void setSrcBookAndDestBook(DynamicObject srcBook, DynamicObject destBook) {
        this.srcBook = new GLBook(srcBook);
        this.destBook = new GLBook(destBook);
        this.samePeriodType = Objects.equals(this.srcBook.periodType, this.destBook.periodType);
        this.sameAccountTable = Objects.equals(this.srcBook.accTabId, this.destBook.accTabId);
        this.sameExrateTable = Objects.equals(this.srcBook.exRateTable, this.destBook.exRateTable);
        this.sameLocCurrency = Objects.equals(this.srcBook.locCurrency, this.destBook.locCurrency);
        this.crossOrg = !Objects.equals(this.srcBook.bookOrgId, this.destBook.bookOrgId);
    }

    public boolean needCalcLocal() {
        boolean needCalc = true;
        if (this.sameLocCurrency && this.sameExrateTable) {
            needCalc = false;
        }
        return needCalc;
    }

    public boolean isCrossOrg() {
        return this.crossOrg;
    }

    public static class GLBook {
        private DynamicObject book;
        private Long bookId;
        private Long bookOrgId;
        private String booksTypeName;
        private Long periodType;
        private Long accTabId;
        private Long exRateTable;
        private DynamicObject locCurrency;
        private QFilter accBaseDataFilter;

        public GLBook(DynamicObject book) {
            this.book = book;
            this.bookId = book.getLong("id");
            this.bookOrgId = book.getLong("org.id");
            this.booksTypeName = book.getString("bookstype.name");
            this.periodType = book.getLong("periodtype.id");
            this.accTabId = book.getLong("accounttable.id");
            this.exRateTable = book.getLong("exratetable.id");
            this.locCurrency = book.getDynamicObject("basecurrency");
            this.accBaseDataFilter = AccountUtils.getAccountDataFilter((long)this.bookOrgId, (long)this.accTabId);
        }

        public DynamicObject getBook() {
            return this.book;
        }

        public Long getBookId() {
            return this.bookId;
        }

        public Long getBookOrgId() {
            return this.bookOrgId;
        }

        public String getBooksTypeName() {
            return this.booksTypeName;
        }

        public Long getAccTabId() {
            return this.accTabId;
        }

        public Long getExRateTable() {
            return this.exRateTable;
        }

        public DynamicObject getLocCurrency() {
            return this.locCurrency;
        }

        public QFilter getAccBaseDataFilter() {
            return this.accBaseDataFilter;
        }
    }
}

