/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.operation;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.bean.EntryFieldInfo;
import kd.fi.gl.bean.GlVoucherField;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.business.vo.voucher.wrap.DynamicEntryWrap;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.operation.TarAccountAssgrpInfo;
import kd.fi.gl.operation.VoucherConvertInfo;
import kd.fi.gl.operation.VoucherConvertUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.replace.AssgrpBatchReplacer;
import kd.fi.gl.voucher.util.VoucherUtils;

public class VoucherEntryConvertUtil {
    public static final Log logger = LogFactory.getLog(VoucherEntryConvertUtil.class);
    private static final String ASSGRP_ID = "assgrp_id";

    public static void setAccount(DynamicObject newEntry, Row srcEntryRow, VoucherConvertUtil voucherConvertUtil, VoucherConvertInfo voucherConvertInfo, Map<Long, DynamicObject> accDynCache) throws Exception {
        Map<Long, DynamicObject> destAccIdDynMap = voucherConvertUtil.getDestAccIdDynMap();
        long srcAccId = srcEntryRow.getLong("entries.account");
        long srcAssgrpId = srcEntryRow.getLong("entries.assgrp");
        DynamicObject descAccDO = destAccIdDynMap.get(srcAccId);
        if (descAccDO == null) {
            Table<String, Long, TarAccountAssgrpInfo> finalMapping = voucherConvertUtil.getCustomAccountAssgrpMappingInfo().getFinalMapping();
            DynamicObject srcAccDO = accDynCache.get(srcAccId);
            if (srcAccDO == null) {
                srcAccDO = BusinessDataServiceHelper.loadSingleFromCache((Object)srcAccId, (String)"bd_accountview", (String)"fmasterid, number");
            }
            String accountNumber = srcAccDO.getString("number");
            if (!finalMapping.isEmpty()) {
                TarAccountAssgrpInfo tarAccountAssgrpInfo = (TarAccountAssgrpInfo)finalMapping.get((Object)accountNumber, (Object)srcAssgrpId);
                if (tarAccountAssgrpInfo != null) {
                    descAccDO = tarAccountAssgrpInfo.getTarAccDyn();
                }
                if (DebugTrace.enable()) {
                    logger.info("Customize the post-development dimension: srcAccNum = " + accountNumber + "; srcAssgrpId = " + srcAssgrpId + "tarInfo = " + tarAccountAssgrpInfo);
                }
            }
            if (descAccDO == null) {
                String booksTypeName = voucherConvertInfo.getDestBook().getBooksTypeName();
                throw new Exception(String.format(ResManager.loadKDString((String)"\u6839\u636e[%1$s]\u79d1\u76ee\u83b7\u53d6\u76ee\u6807\u8d26\u7c3f[%2$s]\u5bf9\u5e94\u79d1\u76ee\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u4ee5\u53ca\u79d1\u76ee\u5728\u5f53\u524d\u7ec4\u7ec7\u662f\u5426\u53ef\u7528\u3002", (String)"SynBookVoucherService_5", (String)GLApp.instance.mServiceModule(), (Object[])new Object[0]), accountNumber, booksTypeName));
            }
        }
        Long descAccId = descAccDO.getLong("id");
        newEntry.set("account_id", (Object)descAccId);
        newEntry.set("account", (Object)descAccDO);
    }

    public static void setLocal(DynamicObject newEntry, Row srcEntryRow, VoucherConvertInfo voucherConvertInfo, Long srcVid, Date bookeddate, BigDecimal synration) throws Exception {
        newEntry.set("localrate", (Object)srcEntryRow.getBigDecimal("entries.localrate"));
        if (voucherConvertInfo.needCalcLocal()) {
            Long destExRateTable = voucherConvertInfo.getDestBook().getExRateTable();
            Long destLocCurrencyId = voucherConvertInfo.getDestBook().getLocCurrency().getLong("id");
            String destLocCurrencyName = voucherConvertInfo.getDestBook().getLocCurrency().getString("name");
            int amtprecision = voucherConvertInfo.getDestBook().getLocCurrency().getInt("amtprecision");
            Long oriCurrencyId = srcEntryRow.getLong("entries.currency");
            Optional<ExchangeRate> localRateOpt = VoucherEntryConvertUtil.getExchangeRate(destExRateTable, oriCurrencyId, destLocCurrencyId, bookeddate);
            String dc = srcEntryRow.getString("entries.entrydc");
            Long srcLocCurrencyId = voucherConvertInfo.getSrcBook().getLocCurrency().getLong("id");
            Long deskLocCurrencyId = voucherConvertInfo.getDestBook().getLocCurrency().getLong("id");
            if ("1".equalsIgnoreCase(dc)) {
                BigDecimal debitOri = srcEntryRow.getBigDecimal("entries.debitori");
                if (BigDecimal.ZERO.compareTo(debitOri) == 0) {
                    if (Long.compare(srcLocCurrencyId, deskLocCurrencyId) != 0) {
                        Optional<ExchangeRate> newLocalRateOpt = VoucherEntryConvertUtil.getExchangeRate(destExRateTable, srcLocCurrencyId, destLocCurrencyId, bookeddate);
                        if (!newLocalRateOpt.isPresent()) {
                            DynamicObject currencyDO = BusinessDataServiceHelper.loadSingleFromCache((Object)srcLocCurrencyId, (String)"bd_currency", (String)"name");
                            String srcLocCurrencyName = currencyDO.getString("name");
                            String msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u627e\u5230\u539f\u5e01[%1$s]\u5230\u76ee\u6807\u5e01[%2$s]\u7684\u6c47\u7387\u3002", (String)"SynBookVoucherService_17", (String)GLApp.instance.mServiceModule(), (Object[])new Object[0]), srcLocCurrencyName, destLocCurrencyName);
                            throw new Exception(msg);
                        }
                        ExchangeRate destLocalRate = newLocalRateOpt.get();
                        BigDecimal debitLocal = srcEntryRow.getBigDecimal("entries.debitlocal");
                        debitLocal = debitLocal.multiply(synration);
                        IRateCalculator rateCalculator = destLocalRate.getRateType().getRateCalculator();
                        BigDecimal newDebitLoc = rateCalculator.calLocAmount(newLocalRateOpt.get().getValue(), debitLocal, amtprecision);
                        newEntry.set("debitlocal", (Object)newDebitLoc);
                    } else {
                        BigDecimal debitLoc = srcEntryRow.getBigDecimal("entries.debitlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP);
                        newEntry.set("debitlocal", (Object)debitLoc);
                    }
                } else {
                    if (!localRateOpt.isPresent()) {
                        DynamicObject currencyDO = BusinessDataServiceHelper.loadSingleFromCache((Object)oriCurrencyId, (String)"bd_currency", (String)"name");
                        String oriCurrencyName = currencyDO.getString("name");
                        String msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u627e\u5230\u539f\u5e01[%1$s]\u5230\u76ee\u6807\u5e01[%2$s]\u7684\u6c47\u7387\u3002", (String)"SynBookVoucherService_17", (String)GLApp.instance.mServiceModule(), (Object[])new Object[0]), oriCurrencyName, destLocCurrencyName);
                        throw new Exception(msg);
                    }
                    ExchangeRate destLocalRate = localRateOpt.get();
                    if (destLocalRate.getValue().compareTo(srcEntryRow.getBigDecimal("entries.localrate")) != 0) {
                        newEntry.set("localrate", (Object)destLocalRate.getValue());
                        IRateCalculator rateCalculator = destLocalRate.getRateType().getRateCalculator();
                        debitOri = debitOri.multiply(synration);
                        BigDecimal debitLoc = rateCalculator.calLocAmount(destLocalRate.getValue(), debitOri, amtprecision);
                        newEntry.set("debitlocal", (Object)debitLoc);
                    } else {
                        newEntry.set("debitlocal", (Object)srcEntryRow.getBigDecimal("entries.debitlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
                        newEntry.set("creditlocal", (Object)srcEntryRow.getBigDecimal("entries.creditlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
                    }
                }
            } else {
                BigDecimal creditOri = srcEntryRow.getBigDecimal("entries.creditori");
                if (BigDecimal.ZERO.compareTo(creditOri) == 0) {
                    if (Long.compare(srcLocCurrencyId, deskLocCurrencyId) != 0) {
                        Optional<ExchangeRate> newLocalRateOpt = VoucherEntryConvertUtil.getExchangeRate(destExRateTable, srcLocCurrencyId, destLocCurrencyId, bookeddate);
                        if (!newLocalRateOpt.isPresent()) {
                            DynamicObject currencyDO = BusinessDataServiceHelper.loadSingleFromCache((Object)srcLocCurrencyId, (String)"bd_currency", (String)"name");
                            String srcLocCurrencyName = currencyDO.getString("name");
                            String msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u627e\u5230\u539f\u5e01[%1$s]\u5230\u76ee\u6807\u5e01[%2$s]\u7684\u6c47\u7387\u3002", (String)"SynBookVoucherService_17", (String)GLApp.instance.mServiceModule(), (Object[])new Object[0]), srcLocCurrencyName, destLocCurrencyName);
                            throw new Exception(msg);
                        }
                        ExchangeRate destLocalRate = newLocalRateOpt.get();
                        BigDecimal creditLocal = srcEntryRow.getBigDecimal("entries.creditlocal");
                        creditLocal = creditLocal.multiply(synration);
                        IRateCalculator rateCalculator = destLocalRate.getRateType().getRateCalculator();
                        BigDecimal newDebitLoc = rateCalculator.calLocAmount(newLocalRateOpt.get().getValue(), creditLocal, amtprecision);
                        newEntry.set("creditlocal", (Object)newDebitLoc);
                    } else {
                        BigDecimal creditLoc = srcEntryRow.getBigDecimal("entries.creditlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP);
                        newEntry.set("creditlocal", (Object)creditLoc);
                    }
                } else {
                    if (!localRateOpt.isPresent()) {
                        DynamicObject currencyDO = BusinessDataServiceHelper.loadSingleFromCache((Object)oriCurrencyId, (String)"bd_currency", (String)"name");
                        String oriCurrencyName = currencyDO.getString("name");
                        String msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u627e\u5230\u539f\u5e01[%1$s]\u5230\u76ee\u6807\u5e01[%2$s]\u7684\u6c47\u7387\u3002", (String)"SynBookVoucherService_17", (String)GLApp.instance.mServiceModule(), (Object[])new Object[0]), oriCurrencyName, destLocCurrencyName);
                        throw new Exception(msg);
                    }
                    ExchangeRate destLocalRate = localRateOpt.get();
                    if (destLocalRate.getValue().compareTo(srcEntryRow.getBigDecimal("entries.localrate")) != 0) {
                        newEntry.set("localrate", (Object)destLocalRate.getValue());
                        IRateCalculator rateCalculator = destLocalRate.getRateType().getRateCalculator();
                        creditOri = creditOri.multiply(synration);
                        BigDecimal creditLoc = rateCalculator.calLocAmount(destLocalRate.getValue(), creditOri, amtprecision);
                        newEntry.set("creditlocal", (Object)creditLoc);
                    } else {
                        newEntry.set("debitlocal", (Object)srcEntryRow.getBigDecimal("entries.debitlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
                        newEntry.set("creditlocal", (Object)srcEntryRow.getBigDecimal("entries.creditlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
                    }
                }
            }
        } else {
            int amtprecision = voucherConvertInfo.getDestBook().getLocCurrency().getInt("amtprecision");
            newEntry.set("debitlocal", (Object)srcEntryRow.getBigDecimal("entries.debitlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
            newEntry.set("creditlocal", (Object)srcEntryRow.getBigDecimal("entries.creditlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
        }
    }

    public static void setOri(DynamicObject newEntry, Row srcEntryRow, VoucherConvertInfo voucherConvertInfo, BigDecimal synration) {
        DynamicObject destLocCurreny = voucherConvertInfo.getDestBook().getLocCurrency();
        DynamicObject srcLocCurreny = voucherConvertInfo.getSrcBook().getLocCurrency();
        long destLocCurrenyId = destLocCurreny.getLong("id");
        Long oriCurrencyId = srcEntryRow.getLong("entries.currency");
        int amtprecision = destLocCurreny.getInt("amtprecision");
        boolean adjust = false;
        BigDecimal srcDebitOri = srcEntryRow.getBigDecimal("entries.debitori");
        BigDecimal srcCreditOri = srcEntryRow.getBigDecimal("entries.creditori");
        if (oriCurrencyId != destLocCurrenyId) {
            DynamicObject descAccDO = newEntry.getDynamicObject("account");
            String acctcurrency = descAccDO.getString("acctcurrency");
            if ("nocurrency".equalsIgnoreCase(acctcurrency)) {
                adjust = true;
            } else {
                boolean zeroAndDiffLocCurrency;
                boolean bl = zeroAndDiffLocCurrency = srcDebitOri.add(srcCreditOri).compareTo(BigDecimal.ZERO) == 0 && srcLocCurreny.getLong("id") != destLocCurrenyId;
                if ("descurrency".equalsIgnoreCase(acctcurrency)) {
                    DynamicObjectCollection currencyentry = descAccDO.getDynamicObjectCollection("currencyentry");
                    adjust = true;
                    for (DynamicObject currencye : currencyentry) {
                        if (currencye.getLong("currency.id") != oriCurrencyId.longValue() || zeroAndDiffLocCurrency) continue;
                        adjust = false;
                        break;
                    }
                } else if (zeroAndDiffLocCurrency) {
                    adjust = true;
                }
            }
        }
        if (adjust) {
            newEntry.set("localrate", (Object)BigDecimal.ONE);
            newEntry.set("debitori", (Object)newEntry.getBigDecimal("debitlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
            newEntry.set("creditori", (Object)newEntry.getBigDecimal("creditlocal").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
            newEntry.set("currency_id", (Object)destLocCurrenyId);
            newEntry.set("currency", (Object)destLocCurreny);
        } else {
            newEntry.set("debitori", (Object)srcDebitOri.multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
            newEntry.set("creditori", (Object)srcEntryRow.getBigDecimal("entries.creditori").multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP));
            newEntry.set("currency_id", (Object)srcEntryRow.getLong("entries.currency"));
        }
    }

    public static void setAssGrp(DynamicObject newEntry, Row srcEntryRow, VoucherConvertUtil voucherConvertUtil) {
        AssgrpBatchReplacer<DynamicEntryWrap> assgrpBatchReplacer = voucherConvertUtil.getAssgrpBatchReplacer();
        long srcAssgrpId = srcEntryRow.getLong("entries.assgrp");
        long srcAccountId = srcEntryRow.getLong("entries.account");
        long destAccountId = newEntry.getLong("account_id");
        DynamicObject descAccDO = newEntry.getDynamicObject("account");
        Map<Long, DynamicObject> destAccIdDynMap = voucherConvertUtil.getDestAccIdDynMap();
        boolean specialHandling = false;
        if (destAccIdDynMap.get(srcAccountId) == null) {
            DynamicObject srcAccDO = BusinessDataServiceHelper.loadSingleFromCache((Object)srcAccountId, (String)"bd_accountview", (String)"number");
            String srcNumber = srcAccDO.getString("number");
            Table<String, Long, TarAccountAssgrpInfo> finalMapping = voucherConvertUtil.getCustomAccountAssgrpMappingInfo().getFinalMapping();
            TarAccountAssgrpInfo tarAccountAssgrpInfo = (TarAccountAssgrpInfo)finalMapping.get((Object)srcNumber, (Object)srcAssgrpId);
            if (tarAccountAssgrpInfo != null) {
                specialHandling = true;
                srcAssgrpId = tarAccountAssgrpInfo.getAssgrpIdNew();
            }
        }
        newEntry.set(ASSGRP_ID, (Object)srcAssgrpId);
        if (specialHandling) {
            return;
        }
        if (destAccountId == srcAccountId) {
            return;
        }
        if (!descAccDO.getBoolean("isassist")) {
            newEntry.set(ASSGRP_ID, (Object)0L);
            return;
        }
        List assistTypeIdList = descAccDO.getDynamicObjectCollection("checkitementry").stream().map(x -> x.getLong(GLField.id_((String)"asstactitem"))).collect(Collectors.toList());
        ArrayList flexFields = new ArrayList(FlexUtils.batchGetFlexFields(assistTypeIdList).values());
        assgrpBatchReplacer.addReplace((IVoucherEntry)new DynamicEntryWrap(newEntry), flexFields, srcEntryRow.getString("entries.assgrp.value"), srcEntryRow.getLong("entries.assgrp"));
    }

    public static void setPriceQtyUnit(DynamicObject newEntry, Row srcEntryRow, BigDecimal synration) {
        DynamicObject destAccDO = newEntry.getDynamicObject("account");
        if (!destAccDO.getBoolean("isqty")) {
            newEntry.set("price", null);
            newEntry.set("quantity", null);
            newEntry.set("measureunit", null);
        } else {
            newEntry.set("price", (Object)srcEntryRow.getBigDecimal("entries.price"));
            newEntry.set("measureunit", (Object)srcEntryRow.getLong("entries.measureunit"));
            BigDecimal quantity = srcEntryRow.getBigDecimal("entries.quantity");
            DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)srcEntryRow.getLong("entries.measureunit"), (String)"bd_measureunits", (String)"precisionaccount,precision");
            if (unit != null) {
                String precisionAccount = unit.getString("precisionaccount");
                int precision = unit.getInt("precision");
                quantity = quantity.multiply(synration).setScale(precision, VoucherEntryConvertUtil.transPrecisionProcessing(precisionAccount));
            }
            newEntry.set("quantity", (Object)quantity);
        }
    }

    public static void setExpireDate(DynamicObject newEntry, Date bizDate) {
        DynamicObject destAccDO = newEntry.getDynamicObject("account");
        if (destAccDO.getBoolean("accheck")) {
            newEntry.set("expiredate", (Object)bizDate);
        }
    }

    public static void setOtherEntryFields(DynamicObject newEntry, Row srcEntryRow, Long orgId, Long periodId, GlVoucherField glVoucherField) {
        newEntry.set("seq", (Object)srcEntryRow.getString("entries.seq"));
        newEntry.set("entrydc", (Object)srcEntryRow.getString("entries.entrydc"));
        newEntry.set("edescription", (Object)srcEntryRow.getString("entries.edescription"));
        newEntry.set("businessnum", (Object)srcEntryRow.getString("entries.businessnum"));
        newEntry.set("biznumrecord", (Object)srcEntryRow.getString("entries.biznumrecord"));
        newEntry.set("eorg", (Object)orgId);
        newEntry.set("eperiod", (Object)periodId);
        VoucherEntryConvertUtil.setEntryExpandField(newEntry, srcEntryRow, glVoucherField);
    }

    private static void setEntryExpandField(DynamicObject newEntry, Row srcEntryRow, GlVoucherField glVoucherField) {
        if (glVoucherField != null) {
            List allEntryFieldInfos = glVoucherField.getAllEntryFieldInfos();
            for (EntryFieldInfo entryFieldInfo : allEntryFieldInfos) {
                newEntry.set(entryFieldInfo.getName(), srcEntryRow.get(entryFieldInfo.getFullName()));
                if (!entryFieldInfo.isBaseData()) continue;
                newEntry.set(entryFieldInfo.getName() + "_id", (Object)srcEntryRow.getLong(entryFieldInfo.getFullName()));
            }
        }
    }

    private static Optional<ExchangeRate> getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        Map rateMap = (Map)ThreadCache.get((Object)"SynBookVoucherService_getExchangeRate", () -> new HashMap(16));
        String rateKey = String.join((CharSequence)"_", exchangeTableID.toString(), sourceCurrencyID.toString(), targetCurrencyID.toString(), date.toString());
        return rateMap.computeIfAbsent(rateKey, k -> {
            ExchangeRate exchangeRate = RateServiceHelper.getExchangeRate((Long)sourceCurrencyID, (Long)targetCurrencyID, (Long)exchangeTableID, (Date)date);
            if (exchangeRate == null || exchangeRate.getValue() == null) {
                return Optional.empty();
            }
            return Optional.of(exchangeRate);
        });
    }

    public static void setMainAndSuppCf(DynamicObject newEntry, Row srcEntryRow, VoucherConvertInfo voucherConvertInfo, Long srcVid, Date bookeddate, BigDecimal synration) throws Exception {
        BigDecimal mainCfAmount = srcEntryRow.getBigDecimal("entries.maincfamount");
        BigDecimal suppCfAmount = srcEntryRow.getBigDecimal("entries.suppcfamount");
        Long mainCfItemId = srcEntryRow.getLong("entries.maincfitem");
        Long suppCfItemId = srcEntryRow.getLong("entries.suppcfitem");
        if (voucherConvertInfo.isCrossOrg() && mainCfItemId > 0L && null == VoucherUtils.getCFitem((long)voucherConvertInfo.getDestBook().getBookOrgId(), (long)mainCfItemId)) {
            return;
        }
        if (voucherConvertInfo.isCrossOrg() && suppCfItemId > 0L && null == VoucherUtils.getCFitem((long)voucherConvertInfo.getDestBook().getBookOrgId(), (long)suppCfItemId)) {
            suppCfItemId = 0L;
            suppCfAmount = BigDecimal.ZERO;
        }
        newEntry.set("maincfitem", (Object)mainCfItemId);
        newEntry.set("maincfassgrp", (Object)srcEntryRow.getLong("entries.maincfassgrp"));
        newEntry.set("suppcfitem", (Object)suppCfItemId);
        if (voucherConvertInfo.needCalcLocal()) {
            Long destExRateTable = voucherConvertInfo.getDestBook().getExRateTable();
            Long destLocCurrencyId = voucherConvertInfo.getDestBook().getLocCurrency().getLong("id");
            String destLocCurrencyName = voucherConvertInfo.getDestBook().getLocCurrency().getString("name");
            int amtprecision = voucherConvertInfo.getDestBook().getLocCurrency().getInt("amtprecision");
            Long oriCurrencyId = voucherConvertInfo.getSrcBook().getLocCurrency().getLong("id");
            Optional<ExchangeRate> localRateOpt = VoucherEntryConvertUtil.getExchangeRate(destExRateTable, oriCurrencyId, destLocCurrencyId, bookeddate);
            if (!localRateOpt.isPresent()) {
                DynamicObject currencyDO = BusinessDataServiceHelper.loadSingleFromCache((Object)oriCurrencyId, (String)"bd_currency", (String)"name");
                String oriCurrencyName = currencyDO.getString("name");
                String msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u627e\u5230\u539f\u5e01[%1$s]\u5230\u76ee\u6807\u5e01[%2$s]\u7684\u6c47\u7387\u3002", (String)"SynBookVoucherService_17", (String)GLApp.instance.mServiceModule(), (Object[])new Object[0]), oriCurrencyName, destLocCurrencyName);
                throw new Exception(msg);
            }
            ExchangeRate destLocalRate = localRateOpt.get();
            IRateCalculator rateCalculator = destLocalRate.getRateType().getRateCalculator();
            if (BigDecimal.ZERO.compareTo(mainCfAmount) != 0) {
                mainCfAmount = mainCfAmount.multiply(synration);
                mainCfAmount = rateCalculator.calLocAmount(destLocalRate.getValue(), mainCfAmount, amtprecision);
                newEntry.set("maincfamount", (Object)mainCfAmount);
            }
            if (BigDecimal.ZERO.compareTo(suppCfAmount) != 0) {
                suppCfAmount = suppCfAmount.multiply(synration);
                suppCfAmount = rateCalculator.calLocAmount(destLocalRate.getValue(), suppCfAmount, amtprecision);
                newEntry.set("suppCfAmount", (Object)suppCfAmount);
            }
        } else {
            int amtprecision = voucherConvertInfo.getDestBook().getLocCurrency().getInt("amtprecision");
            mainCfAmount = mainCfAmount.multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP);
            suppCfAmount = suppCfAmount.multiply(synration).setScale(amtprecision, RoundingMode.HALF_UP);
            newEntry.set("maincfamount", (Object)mainCfAmount);
            newEntry.set("suppcfamount", (Object)suppCfAmount);
        }
    }

    public static int transPrecisionProcessing(String precisionAccount) {
        switch (precisionAccount) {
            case "2": {
                return 1;
            }
            case "3": {
                return 0;
            }
        }
        return 4;
    }
}

