/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.CheckResult;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accountref.constant.BalTransferType;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accountref.utils.GLAccountRefUtil;
import kd.fi.gl.accsys.AccountBookInfo;

public class AcccurrentTransferServiceImpl
implements IAccountTableRefService {
    private static final String WRITEOFFENTRY = "writeoffentry";
    private static final String BUYERENTRY = "buyerentry";

    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        GLAccountRefUtil.AccountBookCheckResult acctBookCheckRst = BalanceTransferUtils.getEnableableAccountBook((long)orgId, (Date)enableDate, (AccountTableRef)accountIdRef, (boolean)true);
        for (AccountBookInfo bookInfo : acctBookCheckRst.getBooks()) {
            BalanceTransferUtils.transfer((Long)orgId, (Long)bookInfo.getBookTypeId(), (Date)enableDate, (Long)bookInfo.getCurPeriodId(), (AccountTableRef)accountIdRef, (BalTransferType)BalTransferType.ACCCURRENT);
        }
    }

    public CheckResult enableCheck(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        GLAccountRefUtil.AccountBookCheckResult acctBookCheckRst = BalanceTransferUtils.getEnableableAccountBook((long)orgId, (Date)enableDate, (AccountTableRef)accountIdRef, (boolean)true);
        return acctBookCheckRst.getCheckResult();
    }

    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        GLAccountRefUtil.AccountBookCheckResult acctBookCheckRst = BalanceTransferUtils.getEnableableAccountBook((long)orgId, (Date)disableDate, (AccountTableRef)accountIdRef, (boolean)false);
        for (AccountBookInfo bookInfo : acctBookCheckRst.getBooks()) {
            BalanceTransferUtils.unTransfer((Long)orgId, (Long)bookInfo.getBookTypeId(), (Date)disableDate, (Long)bookInfo.getCurPeriodId(), (AccountTableRef)accountIdRef, (BalTransferType)BalTransferType.ACCCURRENT);
        }
    }

    public CheckResult disableCheck(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        boolean existFutureWriteOffRecord;
        GLAccountRefUtil.AccountBookCheckResult acctBookCheckRst = BalanceTransferUtils.getEnableableAccountBook((long)orgId, (Date)disableDate, (AccountTableRef)accountIdRef, (boolean)false);
        CheckResult checkResult = acctBookCheckRst.getCheckResult();
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        Set newAccountIds = accountIdRef.getNewAccountIdSet();
        HashSet<Long> newAccountMasterIds = new HashSet<Long>(newAccountIds.size());
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".disableCheck"), (String)"bd_accountview", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)newAccountIds)}, null);){
            for (Row row : dSet) {
                newAccountMasterIds.add(row.getLong("masterid"));
            }
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter acctFilter = new QFilter("account", "in", newAccountMasterIds);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"0");
        HashSet<Long> recordIds = new HashSet<Long>(newAccountMasterIds.size());
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"id", (QFilter[])new QFilter[]{orgFilter, acctFilter, statusFilter}, null);){
            for (Row row : dSet) {
                recordIds.add(row.getLong("id"));
            }
        }
        CheckResult checkErrResult = new CheckResult();
        if (!recordIds.isEmpty() && (existFutureWriteOffRecord = QueryServiceHelper.exists((String)"gl_reciprocal_log", (QFilter[])new QFilter[]{new QFilter(BUYERENTRY, "in", recordIds).or(new QFilter(WRITEOFFENTRY, "in", recordIds))}))) {
            checkErrResult.setSuccess(false);
            checkErrResult.setMessage(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u6765\u671f\u95f4\u5df2\u6838\u9500\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u542f\u7528\u3002", (String)"AcccurrentTransferServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        return checkErrResult;
    }
}

