/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.acct.param.BCMBalanceIndexParam;
import kd.fi.gl.acct.param.ReClassNumberIDParam;
import kd.fi.gl.acct.param.ReClassParam;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;
import kd.fi.gl.util.ReClassUtils;

public class AcctFormulaLinkServiceImpl {
    private static final Log LOG = LogFactory.getLog(AcctFormulaLinkServiceImpl.class);
    private static final String[] SHOW_TY = new String[]{"QC", "QY", "QJF", "QDF", "QJL", "QDL"};
    private List<String> errorFormula = new ArrayList<String>();
    private Map<String, String> errorMessageMap = new HashMap<String, String>(8);

    public String getLinkParam(String formulaParam) {
        String[] periodList;
        JSONObject resultJson = new JSONObject();
        ArrayList<String> params = new ArrayList<String>(8);
        ReClassParam reClassParam = new ReClassParam(formulaParam);
        String comOrgNumber = reClassParam.getOrgNumber();
        Map<String, Long> mainBookTypeMap = this.getMainBookType();
        String mainBookTypeNumber = "";
        if (mainBookTypeMap.size() > 0) {
            mainBookTypeNumber = mainBookTypeMap.keySet().iterator().next();
        }
        if (StringUtils.isBlank((CharSequence)mainBookTypeNumber)) {
            String mess = ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u7684\u7ec4\u7ec7\u53d6\u4e0d\u5230\u4e3b\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"DataCollectMsServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0]);
            this.errorMessageMap.put("", mess);
            throw new KDBizException(mess);
        }
        int comFy = reClassParam.getFy();
        int comPeriod = reClassParam.getPeriod();
        String comAdjustPeriod = reClassParam.getAdjustPeriod();
        List<String> scopePeriods = reClassParam.getScopePeriods();
        if (!StringUtils.isBlank((CharSequence)comAdjustPeriod) && (periodList = comAdjustPeriod.split(",")).length == 2 && (scopePeriods == null || scopePeriods.isEmpty())) {
            scopePeriods = new ArrayList<String>(2);
            scopePeriods.add(periodList[0]);
            scopePeriods.add(periodList[1]);
            reClassParam.setScopePeriods(scopePeriods);
        }
        String comAssistStr = "";
        Map<String, Object> paramMap = reClassParam.getAcctFormulaMap();
        Map<String, Map<String, List<String>>> bookStrToFormulasMap = this.getBookStrSet(paramMap, mainBookTypeNumber, comOrgNumber, scopePeriods);
        HasPermOrgResult permOrgResult = InterfacePermissionService.getAllPermOrgs(PermissionType.ACCT);
        String permName = InterfacePermissionService.getPermName(PermissionType.ACCT);
        for (Map.Entry<String, Map<String, List<String>>> bookEntry : bookStrToFormulasMap.entrySet()) {
            String bookStr = bookEntry.getKey();
            Map<String, List<String>> formulasMap = bookEntry.getValue();
            ReClassNumberIDParam numberIDParam = new ReClassNumberIDParam(reClassParam, formulasMap, bookStr);
            long orgId = numberIDParam.getOrgId();
            long bookTypeId = numberIDParam.getBookTypeId();
            long acctTableId = numberIDParam.getAcctTableId();
            String bookErrorMessage = this.checkBook(bookStr, orgId, bookTypeId, acctTableId);
            String orgPermMsg = AcctUtil.checkPermByOrgId(bookStr.split(",")[0], permName, orgId, permOrgResult);
            Map<String, Map<String, Object>> errorInfoMap = numberIDParam.getErrorInfoMap();
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                boolean bl;
                Long endPeriodId;
                Long startPeriodId;
                String periodParam;
                String tmpBookTypeNumber;
                ReportShowParameter formShowParameter = new ReportShowParameter();
                FilterInfo filter = new FilterInfo();
                String acctKeyId = entry.getKey();
                List paramFields = (List)entry.getValue();
                String formulaStr = this.buildFormula(paramFields);
                if (errorInfoMap.containsKey(acctKeyId)) {
                    this.addErrorMessage(acctKeyId, formulaStr, (String)errorInfoMap.get(acctKeyId).get("v"));
                    continue;
                }
                String tmpOrgNumber = (String)paramFields.get(0);
                if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                    tmpOrgNumber = comOrgNumber;
                }
                if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                    tmpBookTypeNumber = mainBookTypeNumber;
                }
                if ((StringUtils.isBlank((CharSequence)(periodParam = AcctUtil.getPeriodParam((String)paramFields.get(5)))) || periodParam.equals("0")) && CollectionUtils.isNotEmpty(scopePeriods)) {
                    periodParam = String.valueOf(scopePeriods.get(1));
                }
                if (!bookStr.equals(tmpOrgNumber + "," + tmpBookTypeNumber + "," + (String)paramFields.get(4) + "," + periodParam)) continue;
                if (!AcctUtil.checkPeriodFormat(periodParam)) {
                    this.addErrorMessage(acctKeyId, formulaStr, ResManager.loadKDString((String)"\u516c\u5f0f\u7684\u671f\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"DataCollectMsServiceImpl_16", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)bookErrorMessage)) {
                    this.addErrorMessage(acctKeyId, formulaStr, bookErrorMessage);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)orgPermMsg)) {
                    this.addErrorMessage(acctKeyId, formulaStr, orgPermMsg);
                    continue;
                }
                String acctToAssistList = (String)paramFields.get(2);
                Map<Long, Map<String, Set<Object>>> assistToAcctMap = this.parseAcctAssistList(acctToAssistList, numberIDParam, acctKeyId, formulaStr);
                Set<Long> accountIds = new HashSet<Long>(8);
                if (assistToAcctMap.isEmpty()) {
                    this.addErrorMessage(acctKeyId, formulaStr, ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u65e0\u6cd5\u89e3\u6790\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u79d1\u76ee\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AcctBalParseAction_5", (String)"fi-gl-mservice", (Object[])new Object[]{tmpOrgNumber, acctToAssistList}));
                    continue;
                }
                String fetchType = (String)paramFields.get(3);
                if (StringUtils.isBlank((CharSequence)fetchType)) {
                    this.addErrorMessage(acctKeyId, formulaStr, ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataCollectMsServiceImpl_3", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                fetchType = fetchType.toUpperCase();
                if (this.isGetAttribute(acctKeyId, formulaStr, acctToAssistList)) continue;
                int fy = -1;
                String periodStr = StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(comPeriod);
                String yearAndPeriodKey = AcctUtil.dealYearAndPeriod(AcctUtil.getPeriodParam((String)paramFields.get(5)), comPeriod, comAdjustPeriod, (String)paramFields.get(4), comFy, numberIDParam.getPeriodFromYearMap());
                String[] yearAndPeriod = yearAndPeriodKey.split("-");
                if (yearAndPeriod.length == 2) {
                    fy = Integer.parseInt(yearAndPeriod[0]);
                    periodStr = yearAndPeriod[1];
                }
                if ((StringUtils.isBlank((CharSequence)(periodParam = AcctUtil.getPeriodParam((String)paramFields.get(5)))) || periodParam.equals("0")) && CollectionUtils.isNotEmpty(scopePeriods)) {
                    startPeriodId = numberIDParam.getSeasonPeriodIdMap().get(fy + "," + scopePeriods.get(0));
                    endPeriodId = numberIDParam.getSeasonPeriodIdMap().get(fy + "," + scopePeriods.get(1));
                } else if (periodStr.endsWith("T") || fy != -1) {
                    endPeriodId = startPeriodId = numberIDParam.getPeriodIdsMap().get(fy + "," + periodStr);
                } else {
                    this.addErrorMessage(acctKeyId, formulaStr, ResManager.loadKDString((String)"\u671f\u95f4\u8d1f\u6570\u4e0d\u80fd\u8de8\u5ea6\u4e24\u5e74\u3002", (String)"DataCollectMsServiceImpl_4", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                if (startPeriodId == null) {
                    this.addErrorMessage(acctKeyId, formulaStr, ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"DataCollectMsServiceImpl_5", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                long periodTypeId = this.getPeriodTypeId(orgId, bookTypeId);
                String formId = "gl_rpt_accountbalance";
                ArrayList<FilterItemInfo> ass = new ArrayList<FilterItemInfo>(assistToAcctMap.size());
                HashMap<String, Set> flexToValueIdMap = new HashMap<String, Set>(10);
                for (Map.Entry<Long, Map<String, Set<Object>>> entry2 : assistToAcctMap.entrySet()) {
                    Map<String, Set<Object>> value = entry2.getValue();
                    if (entry2.getValue().isEmpty()) continue;
                    formId = "gl_rpt_assistbalance";
                    for (Map.Entry<String, Set<Object>> assist : value.entrySet()) {
                        Set<Object> assVals = assist.getValue();
                        HashSet<Object> allAssists = new HashSet<Object>(8);
                        for (Object assVal : assVals) {
                            if (assVal instanceof Collection) {
                                allAssists.addAll((Collection)assVal);
                                continue;
                            }
                            allAssists.add(assVal);
                        }
                        flexToValueIdMap.computeIfAbsent(assist.getKey(), k -> new HashSet(10)).addAll(allAssists);
                    }
                }
                for (Map.Entry<Long, Map<String, Set<Object>>> entry3 : flexToValueIdMap.entrySet()) {
                    ass.add(new FilterItemInfo((String)((Object)entry3.getKey()), ((Set)((Object)entry3.getValue())).stream().filter(Objects::nonNull).collect(Collectors.toSet()), "in"));
                }
                boolean issubstractpl = false;
                if (BCMBalanceIndexParam.getSubPlFetchType().contains(fetchType)) {
                    issubstractpl = true;
                }
                boolean bl2 = false;
                if (Arrays.asList(SHOW_TY).contains(fetchType)) {
                    bl = true;
                }
                String currencyNumber = (String)paramFields.get(6);
                long currencyId = 0L;
                if (!StringUtils.isBlank((CharSequence)currencyNumber)) {
                    currencyId = numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber) == null ? 0L : numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber);
                    filter.addFilterItem("currency", (Object)currencyId);
                } else {
                    filter.addFilterItem("currency", (Object)"basecurrency");
                }
                HashMap<Long, Integer> acctToAssistStyleMap = new HashMap<Long, Integer>();
                HashMap<Long, Set<Long>> acctToRCAcctIdsMap = new HashMap<Long, Set<Long>>();
                int acctReClass = reClassParam.getAcctReClass();
                if (!BCMBalanceIndexParam.getFetchTypeReclass().contains(fetchType)) {
                    Map<Long, Set<Long>> leafMap = numberIDParam.getAcctToAllLeafMap();
                    Set<Long> set = assistToAcctMap.keySet();
                    for (Long acctId : set) {
                        acctToAssistStyleMap.put(acctId, 2);
                        acctToRCAcctIdsMap.put(acctId, (Set<Long>)leafMap.get(acctId));
                    }
                    accountIds.addAll(set);
                } else {
                    if (paramFields.size() > 7 && StringUtils.isNotBlank((CharSequence)((CharSequence)paramFields.get(7)))) {
                        acctReClass = Integer.parseInt((String)paramFields.get(7));
                    }
                    this.acctReClassDeal(acctReClass, assistToAcctMap, acctToAssistStyleMap, acctToRCAcctIdsMap, numberIDParam);
                    for (Map.Entry entry4 : acctToRCAcctIdsMap.entrySet()) {
                        Set accIds = (Set)entry4.getValue();
                        accountIds.addAll(accIds);
                    }
                }
                QFilter levelFilter = new QFilter("id", "in", accountIds);
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_accountview", (String)"level", (QFilter[])new QFilter[]{levelFilter}, (String)"level desc");
                int accLevel = ((DynamicObject)dynamicObjectCollection.get(0)).getInt("level");
                if (acctToAssistStyleMap.isEmpty()) {
                    String[] accountValues = acctToAssistList.split("\\|");
                    String acctsStr = accountValues[0];
                    HashMap message = new HashMap(8);
                    String string = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u6ca1\u6709\u5206\u914d%2$s\u79d1\u76ee\u6743\u9650\u3002", (String)"DataCollectMsServiceImpl_6", (String)"fi-gl-mservice", (Object[])new Object[0]), tmpOrgNumber, acctsStr);
                    message.put("type", -1);
                    message.put("v", string);
                    errorInfoMap.put(acctKeyId, message);
                    this.addErrorMessage(acctKeyId, formulaStr, string);
                    continue;
                }
                Map<Object, Object> comAssistIdMap = new HashMap(8);
                String tempComAssistStr = comAssistStr;
                if (paramFields.size() > 9 && StringUtils.isNotBlank((CharSequence)((CharSequence)paramFields.get(9)))) {
                    tempComAssistStr = (String)paramFields.get(9);
                }
                if (StringUtils.isNotBlank((CharSequence)tempComAssistStr)) {
                    if (AcctUtil.checkComAssistFormat(tempComAssistStr, Boolean.FALSE)) {
                        comAssistIdMap = this.getComAssistIdMap(tempComAssistStr, numberIDParam.getComAssistToValueIdTable(), numberIDParam.getComAssistToValRangeIdTable());
                    } else {
                        this.addErrorMessage(acctKeyId, formulaStr, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u53c2\u6570\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"DataCollectMsServiceImpl_18", (String)"fi-gl-mservice", (Object[])new Object[0]));
                        continue;
                    }
                }
                for (Map.Entry entry5 : comAssistIdMap.entrySet()) {
                    filter.addFilterItem((String)entry5.getKey(), entry5.getValue());
                }
                filter.addFilterItem("org", (Object)orgId);
                filter.addFilterItem("orgs", (Object)orgId);
                filter.addFilterItem("booktype", (Object)bookTypeId);
                filter.addFilterItem("periodtype", (Object)periodTypeId);
                filter.addFilterItem("startperiod", (Object)startPeriodId);
                filter.addFilterItem("endperiod", (Object)endPeriodId);
                filter.addFilterItem("accounttable", (Object)numberIDParam.getAcctTableId());
                if ("gl_rpt_assistbalance".equals(formId)) {
                    accountIds = accountIds.stream().filter(accountId -> CollectionUtils.isNotEmpty((Collection)numberIDParam.getAcctToFlexsMap().get(accountId))).collect(Collectors.toSet());
                }
                filter.addFilterItem("account", accountIds, "in");
                filter.addFilterItem("accountlevel", (Object)accLevel);
                if (issubstractpl) {
                    filter.addFilterItem("issubstractpl", (Object)issubstractpl);
                }
                if (bl) {
                    filter.addFilterItem("showqty", (Object)bl);
                }
                if (!ass.isEmpty()) {
                    filter.setFlexFilterItems(ass);
                }
                if (StringUtils.isNotBlank((CharSequence)tempComAssistStr)) {
                    filter.addFilterItem("showcomassist", (Object)true);
                }
                ReportQueryParam queryParam = new ReportQueryParam();
                queryParam.setFilter(filter);
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                formShowParameter.setOpenStyle(openStyle);
                formShowParameter.setQueryParam(queryParam);
                formShowParameter.setFormId(formId);
                formShowParameter.setCustomParam("accounttable", (Object)String.valueOf(numberIDParam.getAcctTableId()));
                formShowParameter.setCustomParam("org", (Object)String.valueOf(orgId));
                params.add(ReportShowParameter.toJsonString((FormShowParameter)formShowParameter));
            }
        }
        LOG.info("this query result pageParam size : " + params.size() + "there formulas don't meet query criteria : " + JSON.toJSON(this.errorFormula));
        resultJson.put("pageParam", params);
        resultJson.put("error", this.errorMessageMap);
        return resultJson.toJSONString();
    }

    private Map<String, Long> getMainBookType() {
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        QFilter ftype = new QFilter("accounttype", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ftype);
        DataSet bookTypeSet = ReClassUtils.queryDataSet("bd_accountbookstype", "id,number", filters);
        for (Row row : bookTypeSet) {
            long bookTypeId = row.getLong("id");
            String bookTypeNumber = row.getString("number");
            numberToIdMap.put(bookTypeNumber, bookTypeId);
        }
        return numberToIdMap;
    }

    private Map<String, Map<String, List<String>>> getBookStrSet(Map<String, Object> paramMap, String comBookTypeNumber, String comOrgNumber, List<String> scopePeriods) {
        HashMap<String, Map<String, List<String>>> bookStrToFormulasMap = new HashMap<String, Map<String, List<String>>>(8);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String periodParam;
            String tmpBookTypeNumber;
            String key = entry.getKey();
            List paramFields = (List)entry.getValue();
            String formulaStr = this.buildFormula(paramFields);
            String tmpOrgNumber = (String)paramFields.get(0);
            if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                if (StringUtils.isBlank((CharSequence)comOrgNumber)) {
                    this.addErrorMessage(key, formulaStr, ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ec4\u7ec7", (String)"DataCollectMsServiceImpl_9", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                tmpOrgNumber = comOrgNumber;
            }
            if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                if (StringUtils.isBlank((CharSequence)comBookTypeNumber)) {
                    this.addErrorMessage(key, formulaStr, ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"DataCollectMsServiceImpl_10", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                tmpBookTypeNumber = comBookTypeNumber;
            }
            if ((StringUtils.isBlank((CharSequence)(periodParam = AcctUtil.getPeriodParam((String)paramFields.get(5)))) || periodParam.equals("0")) && CollectionUtils.isNotEmpty(scopePeriods)) {
                periodParam = String.valueOf(scopePeriods.get(1));
            }
            String bookStr = tmpOrgNumber + "," + tmpBookTypeNumber + "," + (String)paramFields.get(4) + "," + periodParam;
            Map formulasMap = bookStrToFormulasMap.computeIfAbsent(bookStr, x -> new HashMap(64));
            formulasMap.put(key, paramFields);
        }
        return bookStrToFormulasMap;
    }

    private String checkBook(String bookStr, long orgId, long bookTypeId, long acctTableId) {
        String bookErrorMessage = "";
        String[] orgBookTypes = bookStr.split(",");
        String orgNumber = orgBookTypes[0];
        String bookTypeNumber = orgBookTypes[1];
        if (orgId == 0L) {
            bookErrorMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u672a\u627e\u5230\u76f8\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"DataCollectMsServiceImpl_11", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNumber);
        } else if (bookTypeId == 0L) {
            bookErrorMessage = String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u201c%s\u201d\u672a\u627e\u5230\u76f8\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"DataCollectMsServiceImpl_12", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNumber);
        } else if (acctTableId == 0L) {
            bookErrorMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u8d26\u7c3f\u7c7b\u578b\uff1a%2$s\uff0c\u5c1a\u672a\u5efa\u7acb\u8d26\u7c3f\u3002", (String)"DataCollectMsServiceImpl_13", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNumber, bookTypeNumber);
        }
        return bookErrorMessage;
    }

    private String buildFormula(List<String> paramFields) {
        StringBuilder formulaStr = new StringBuilder();
        if (CollectionUtils.isNotEmpty(paramFields)) {
            formulaStr.append("acct(");
            for (int i = 0; i < paramFields.size(); ++i) {
                if (i == 4 || i == 5) {
                    formulaStr.append(paramFields.get(i)).append(",");
                    continue;
                }
                formulaStr.append("\"").append(paramFields.get(i)).append("\"").append(",");
            }
            return formulaStr.deleteCharAt(formulaStr.length() - 1).append(")").toString();
        }
        return formulaStr.toString();
    }

    private Map<Long, Map<String, Set<Object>>> parseAcctAssistList(String accountListStr, ReClassNumberIDParam numberIDParam, String acctKeyId, String formulaStr) {
        Map<String, Long> numberToIdMap = numberIDParam.getAcctNumberToIdsMap();
        Map<String, Set<Long>> rangeNumberToIdsMap = numberIDParam.getAcctRangeKeyToIdsMap();
        if (StringUtils.isEmpty((CharSequence)accountListStr)) {
            this.addErrorMessage(acctKeyId, formulaStr, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DataCollectMsServiceImpl_7", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        String[] accountValues = accountListStr.split("\\|");
        String acctsStr = accountValues[0];
        boolean isContinueAcct = ReClassUtils.isContinueNumber(acctsStr);
        HashMap<Long, Map<String, Set<Object>>> acctIdToAssistMap = new HashMap<Long, Map<String, Set<Object>>>();
        HashMap<String, Set<Object>> asstMap = new HashMap<String, Set<Object>>();
        Set<Object> acctIds = new HashSet();
        String accountNumber = this.parseAssistStr(accountListStr, asstMap, numberIDParam);
        if (isContinueAcct) {
            acctIds = rangeNumberToIdsMap.get(accountNumber);
            Iterator<Object> iterator = acctIds.iterator();
            while (iterator.hasNext()) {
                long acctId = (Long)iterator.next();
                acctIdToAssistMap.put(acctId, asstMap);
            }
        } else if (StringUtils.isEmpty((CharSequence)acctsStr)) {
            StringBuilder flexsStr = new StringBuilder();
            Set flexs = asstMap.keySet();
            for (String flex : flexs) {
                flexsStr = flexsStr.append(flex);
                flexsStr = flexsStr.append("*");
            }
            Map<String, Set<Long>> flexsToAcctIdsMap = numberIDParam.getFlexsToAcctIdsMap();
            acctIds = flexsToAcctIdsMap.get(flexsStr.toString());
            Iterator<Object> iterator = acctIds.iterator();
            while (iterator.hasNext()) {
                long acctId = (Long)iterator.next();
                acctIdToAssistMap.put(acctId, asstMap);
            }
        } else {
            String[] accountList;
            for (String acctNumberStr : accountList = acctsStr.split(",")) {
                Long acctId = numberToIdMap.get(acctNumberStr);
                if (acctId == null) continue;
                acctIds.add(acctId);
                acctIdToAssistMap.put(acctId, asstMap);
            }
        }
        return acctIdToAssistMap;
    }

    private String parseAssistStr(String accountStr, Map<String, Set<Object>> asstMap, ReClassNumberIDParam numberIDParam) {
        accountStr = accountStr.replaceAll("\\|", "\\| ");
        String[] accountValues = accountStr.split("\\|");
        String accountNumber = "";
        if (accountValues.length == 1) {
            accountNumber = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                return accountNumber;
            }
            accountNumber = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)accountNumber)) {
            return accountNumber;
        }
        Map<String, String> assistNumberToFlexMap = numberIDParam.getAssistToFlexMap();
        Map<String, Object> valNumberToIdsMap = numberIDParam.getassistValNumberToObjMap();
        Map<String, Set<Object>> valRangeNumberToIdsMap = numberIDParam.getassistValRangeNumberToObjsMap();
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            String flex = assistNumberToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            HashSet<Object> valIds = new HashSet<Object>();
            if (StringUtils.isNotEmpty((CharSequence)accountValues[i + 1].trim())) {
                String valStr = accountValues[i + 1].trim();
                boolean isContinue = ReClassUtils.isContinueNumber(valStr);
                if (isContinue) {
                    Set<Object> valIdSet = valRangeNumberToIdsMap.get(assistNumber + "*" + valStr);
                    if (Objects.nonNull(valIdSet)) {
                        valIds.addAll(valIdSet);
                    }
                } else {
                    String[] valList;
                    for (String valNumber : valList = valStr.split(",")) {
                        valIds.add(valNumberToIdsMap.get(assistNumber + "*" + valNumber));
                    }
                }
            }
            asstMap.put(flex, valIds);
        }
        return accountNumber;
    }

    private boolean isGetAttribute(String formulaKey, String formulaStr, String acctToAssistList) {
        String[] accountValues;
        if (StringUtils.isNotBlank((CharSequence)acctToAssistList) && (accountValues = acctToAssistList.split("\\|")).length > 2 && accountValues[2].contains(":")) {
            this.addErrorMessage(formulaKey, formulaStr, ResManager.loadKDString((String)"\u5f53\u524d\u516c\u5f0f\u6682\u4e0d\u652f\u6301\u5c5e\u6027\u53d6\u6570\u8054\u67e5\u3002", (String)"DataCollectMsServiceImpl_14", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private long getPeriodTypeId(long orgId, long bookTypeId) {
        long periodTypeId = 0L;
        try (DataSet resDataSet = DB.queryDataSet((String)"DataCollectMsServiceImpl", (DBRoute)DBRoute.of((String)"gl"), (String)String.format("select forgid,fbookstypeid,faccounttableid,fperiodtypeid from t_bd_accountbooks  where forgid = %s and fbookstypeid = %s", orgId, bookTypeId));){
            while (resDataSet.hasNext()) {
                Row row = resDataSet.next();
                periodTypeId = row.getInteger("fperiodtypeid").intValue();
            }
        }
        return periodTypeId;
    }

    private void acctReClassDeal(int acctReClass, Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToRCAcctIdsMap, ReClassNumberIDParam numberIDParam) {
        Map<Long, Set<Long>> directLeafMap = numberIDParam.getAcctToDirectLeafMap();
        Map<Long, Set<Long>> allLeafMap = numberIDParam.getAcctToAllLeafMap();
        Map<Long, Set<String>> acctToFlexMap = numberIDParam.getAcctToFlexsMap();
        HashMap<Long, Map<String, Set<Object>>> acctIdToAssistMapFor = new HashMap<Long, Map<String, Set<Object>>>();
        acctIdToAssistMapFor.putAll(acctIdToAssistMap);
        switch (acctReClass) {
            case 1: {
                for (Map.Entry entry : acctIdToAssistMapFor.entrySet()) {
                    long acctId = (Long)entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    if (isSelectAssist) {
                        HashSet<Long> acctIds = new HashSet<Long>();
                        acctIds.add(acctId);
                        acctToRCAcctIdsMap.put(acctId, acctIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        Set<Long> directLeafIds = directLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    Set<Long> allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 2: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    Set<Long> allLeafIds;
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    if (isSelectAssist) {
                        allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 3);
                        continue;
                    }
                    allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 3: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    Set<Long> directLeafIds = directLeafMap.get(acctId);
                    if (isSelectAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToRCAcctIdsMap.put(acctId, directLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 4: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    Set<Long> allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    if (isSelectAssist) {
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
            case 5: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    Set<Long> directLeafIds = directLeafMap.get(acctId);
                    if (isSelectAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToRCAcctIdsMap.put(acctId, directLeafIds);
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
            case 6: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    HashSet<Long> acctIds;
                    long acctId = entry.getKey();
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    if (isSelectAssist) {
                        Set<Long> allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctIds = new HashSet<Long>();
                        acctIds.add(acctId);
                        acctToRCAcctIdsMap.put(acctId, acctIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctIds = new HashSet();
                    acctIds.add(acctId);
                    acctToRCAcctIdsMap.put(acctId, acctIds);
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
        }
    }

    private boolean acctIsContainAssistMap(Map<Long, Set<String>> acctToFlexMap, long acctId) {
        boolean isContainAssist = true;
        Set<String> flexs = acctToFlexMap.get(acctId);
        if (flexs == null || flexs.size() == 0) {
            isContainAssist = false;
        }
        return isContainAssist;
    }

    private boolean isSelectAssist(Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, long acctId) {
        Map<String, Set<Object>> assistMap = acctIdToAssistMap.get(acctId);
        boolean isSelectAssist = assistMap != null && !assistMap.isEmpty();
        return isSelectAssist;
    }

    private Map<String, Set<Long>> getComAssistIdMap(String tempComAssistStr, Table<String, String, Set<Long>> comAssistToValueIdTable, Table<String, String, Set<Long>> comAssistToValRangeIdTable) {
        HashMap<String, Set<Long>> comAssistIdMap = new HashMap<String, Set<Long>>(8);
        Map<String, Set<String>> comAssistKeyToNumMap = AcctUtil.parseComAssistStr(tempComAssistStr);
        for (Map.Entry<String, Set<String>> comAssistKeyToNumEntry : comAssistKeyToNumMap.entrySet()) {
            Set allValueIdSet;
            String comAssistKey = comAssistKeyToNumEntry.getKey();
            Set<String> valueNumberSet = comAssistKeyToNumEntry.getValue();
            if (Objects.nonNull(valueNumberSet) && valueNumberSet.isEmpty()) {
                comAssistIdMap.put(comAssistKey, new HashSet(8));
                continue;
            }
            if (!Objects.nonNull(valueNumberSet)) continue;
            String tempValueNumber = valueNumberSet.iterator().next();
            if (AcctUtil.isRangeValueNumber(tempValueNumber)) {
                for (String valueNumber : valueNumberSet) {
                    valueNumber = valueNumber.substring(1, valueNumber.length() - 1);
                    allValueIdSet = comAssistIdMap.computeIfAbsent(comAssistKey, e -> new HashSet(8));
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)comAssistToValRangeIdTable.get((Object)comAssistKey, (Object)valueNumber)))) {
                        allValueIdSet.addAll((Collection)comAssistToValRangeIdTable.get((Object)comAssistKey, (Object)valueNumber));
                        continue;
                    }
                    allValueIdSet.add(0L);
                }
                continue;
            }
            for (String valueNumber : valueNumberSet) {
                allValueIdSet = comAssistIdMap.computeIfAbsent(comAssistKey, e -> new HashSet(8));
                if (CollectionUtils.isNotEmpty((Collection)((Collection)comAssistToValueIdTable.get((Object)comAssistKey, (Object)valueNumber)))) {
                    allValueIdSet.addAll((Collection)comAssistToValueIdTable.get((Object)comAssistKey, (Object)valueNumber));
                    continue;
                }
                allValueIdSet.add(0L);
            }
        }
        return comAssistIdMap;
    }

    private void addErrorMessage(String formulaKey, String formulaStr, String message) {
        this.errorFormula.add(formulaKey);
        this.errorMessageMap.put(formulaStr, message);
    }
}

