/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.common.CommonResult;
import kd.fi.gl.enums.ResultCode;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.reciprocal.agingservice.AgingQueryParam;
import kd.fi.gl.reciprocal.agingservice.util.AgingApiUtil;
import kd.fi.gl.service.AgingService;

public class AgingServiceImpl
implements AgingService {
    private Log logger = LogFactory.getLog((String)this.getClass().getName());

    public String getAging(String param) {
        try {
            String result;
            this.logger.info("\u8d26\u9f84\u53d6\u6570\u63a5\u6536\u53c2\u6570\uff1a" + param);
            if (param == null || StringUtils.isBlank((CharSequence)param)) {
                return null;
            }
            AgingQueryParam queryParam = (AgingQueryParam)JSONUtils.cast((String)param, AgingQueryParam.class);
            String errorMessage = AgingApiUtil.validateAgingParam((AgingQueryParam)queryParam);
            if (errorMessage != null) {
                if (DebugTrace.enable()) {
                    this.logger.info("\u8d26\u9f84\u53d6\u6570\u8fd4\u56de\u6570\u636e\uff1a" + errorMessage);
                }
                CommonResult commonResult = new CommonResult(ResultCode.FAILED.getCode(), errorMessage, null);
                return JSONUtils.toString((Object)commonResult);
            }
            Future future = ThreadService.submit(() -> {
                try {
                    CommonResult commonResult = AgingApiUtil.getAgingData((AgingQueryParam)queryParam);
                    return JSONUtils.toString((Object)commonResult);
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }, (TaskType)TaskType.GL_RECIPROCAL_AGINGSERVICE);
            try {
                result = (String)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.error((Throwable)e);
                throw new KDBizException("getAging fail.");
            }
            if (DebugTrace.enable()) {
                this.logger.info("\u8d26\u9f84\u53d6\u6570\u8fd4\u56de\u6570\u636e\uff1a" + result);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

