/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.service.BalanceQueryParam;
import kd.fi.gl.service.BalanceService;
import kd.fi.gl.util.AcctAndAssistHelper;
import kd.fi.gl.util.GLServiceUtils;
import org.apache.commons.collections4.list.UnmodifiableList;

public class BalanceServiceImpl
implements BalanceService {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    public HashSet<String> balanceFields = new HashSet<String>(){
        {
            this.add("org");
            this.add("booktype");
            this.add("period");
            this.add("endperiod");
            this.add("accounttable");
            this.add("account");
            this.add("assgrp");
            this.add("currency");
            this.add("measureunit");
            this.add("beginfor");
            this.add("debitfor");
            this.add("creditfor");
            this.add("endfor");
            this.add("beginlocal");
            this.add("debitlocal");
            this.add("creditlocal");
            this.add("endlocal");
            this.add("yeardebitfor");
            this.add("yeardebitlocal");
            this.add("yearcreditfor");
            this.add("yearcreditlocal");
            this.add("beginqty");
            this.add("debitqty");
            this.add("creditqty");
            this.add("endqty");
            this.add("yeardebitqty");
            this.add("yearcreditqty");
            this.add("count");
        }
    };
    public HashSet<String> dcFields = new HashSet<String>(){
        {
            this.add("beginqty");
            this.add("beginfor");
            this.add("beginlocal");
            this.add("endqty");
            this.add("endfor");
            this.add("endlocal");
        }
    };

    public String getBalance(String param) {
        try {
            this.log.info("\u4f59\u989d\u8868\u53d6\u6570\u63a5\u6536\u53c2\u6570\uff1a" + param);
            if (param == null || StringUtils.isBlank((CharSequence)param)) {
                return null;
            }
            BalanceQueryParam queryParam = (BalanceQueryParam)JSONUtils.cast((String)param, BalanceQueryParam.class);
            List<Map<String, Object>> data = this.getBalanceData(queryParam);
            if (DebugTrace.enable()) {
                this.log.info("\u4f59\u989d\u8868\u53d6\u6570\u8fd4\u56de\u6570\u636e\uff1a" + data);
            }
            return JSONUtils.toString(data);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public List<Map<String, Object>> getBalanceData(BalanceQueryParam param) {
        Long[] longArray;
        HashMap<String, Object> deriveMap = new HashMap<String, Object>();
        deriveMap.put("aliasDc", "dc");
        deriveMap.put("aliasAcct", "acct_id");
        deriveMap.put("flagDc", false);
        deriveMap.put("flagAcct", false);
        if (param.getSelector() == null || param.getSelector().isEmpty()) {
            return null;
        }
        long accounttableId = param.getAccountTableId() == 0L ? this.getAccountTableId(param.getOrgId(), param.getBookTypeId()) : param.getAccountTableId();
        if (accounttableId == 0L) {
            return null;
        }
        param.setAccountTableId(accounttableId);
        Map<Long, List<Map<String, Long>>> accountAssgrp = param.getAccountAssgrp();
        HashSet<Long> faccountIds = this.getAccountFilter(accountAssgrp);
        HashMap<String, String> selFiledMap = new HashMap<String, String>();
        HashMap<String, String> selAssMap = new HashMap<String, String>();
        String sels = this.getSelector(param.getSelector(), param.getGroupBy(), selFiledMap, selAssMap, deriveMap);
        if (param.getCurrencyId() == 0L) {
            longArray = null;
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = param.getCurrencyId();
        }
        Long[] currencyIds = longArray;
        QueryParam queryParam = new QueryParam();
        queryParam.setCurrencyIds(currencyIds);
        queryParam.setSubstractPL(param.isSubstractPL());
        queryParam.setSpecialAccount(param.isSpecialAccount());
        queryParam.setSumAssgrp(true);
        List customFilter = queryParam.getCustomFilter();
        param.getComassit().forEach((k, v) -> customFilter.add(new QFilter(k, "in", v)));
        if (!faccountIds.isEmpty()) {
            queryParam.setAccountFilter(new QFilter("id", "in", faccountIds));
        }
        try (DataSet ds = null;){
            this.log.info("\u4f59\u989d\u8868\u53d6\u6570\u53c2\u6570:" + queryParam.toString() + ";\u67e5\u8be2\u5b57\u6bb5\uff1a" + sels);
            if (!accountAssgrp.isEmpty()) {
                AcctAndAssistHelper acctAssistHelper = new AcctAndAssistHelper();
                ds = acctAssistHelper.getAssFilterAndAssDs(sels, param, queryParam, accountAssgrp, deriveMap);
            } else {
                ds = param.getOrgIds() != null && param.getOrgIds().length > 0 ? BalanceQueryExecutor.getInstance().getBalance(sels, this.toLongArray(param.getOrgIds()), param.getBookTypeId(), param.getAccountTableId(), param.getPeriodId(), param.getPeriodId(), queryParam) : BalanceQueryExecutor.getInstance().getBalance(sels, new Long[]{param.getOrgId()}, param.getBookTypeId(), param.getAccountTableId(), param.getPeriodId(), param.getPeriodId(), queryParam);
            }
            ds = this.dealAssgrpAlias(ds, selAssMap);
            HashSet<String> balGroupFields = new HashSet<String>();
            HashSet<String> assGroupFields = new HashSet<String>();
            this.splitGroupFields(param.getGroupBy(), balGroupFields, assGroupFields);
            Set<String> selAlias = this.getMapValue(selFiledMap);
            Set<String> assAlias = this.getMapValue(selAssMap);
            this.log.info("\u4f59\u989d\u8868\u53d6\u6570sum\u524d\u53c2\u6570\uff1a" + balGroupFields + ";" + assGroupFields + ";" + assAlias + ";" + deriveMap);
            ds = this.sum(ds, balGroupFields, assGroupFields, selFiledMap, assAlias, deriveMap);
            if (!((Boolean)deriveMap.get("flagDc")).booleanValue()) {
                selAlias.remove(deriveMap.get("aliasDc"));
            }
            if (!((Boolean)deriveMap.get("flagAcct")).booleanValue()) {
                selAlias.remove(deriveMap.get("aliasAcct"));
            }
            selAlias.addAll(assAlias);
            List<Map<String, Object>> rs = this.trans2List(selAlias, deriveMap, ds);
            if (DebugTrace.enable()) {
                this.log.info("\u4f59\u989d\u8868\u53d6\u6570\u8fd4\u56de\u7ed3\u679c\uff1a" + rs);
            }
            List<Map<String, Object>> list = rs;
            return list;
        }
    }

    private DataSet dealAssgrpAlias(DataSet dataSet, Map<String, String> assAliasMap) {
        List<String> allFields = GLServiceUtils.getFieldsByDs(dataSet);
        for (Map.Entry<String, String> assAliasMapEntry : assAliasMap.entrySet()) {
            String assField = assAliasMapEntry.getKey();
            if (!allFields.contains(assField)) continue;
            allFields.remove(assField);
            allFields.add(assField + " " + assAliasMapEntry.getValue());
        }
        dataSet = dataSet.select(allFields.toArray(new String[0]));
        return dataSet;
    }

    public Long[] toLongArray(long[] values) {
        Long[] value = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            value[i] = values[i];
        }
        return value;
    }

    private Set<String> getMapValue(Map<String, String> selMap) {
        HashSet<String> aliasList = new HashSet<String>();
        aliasList.addAll(selMap.values());
        return aliasList;
    }

    private long getAccountTableId(long orgId, long bookTypeId) {
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter bookFilter = new QFilter("bookstype.id", "=", (Object)bookTypeId);
        long accounttableId = 0L;
        try (DataSet set = QueryServiceHelper.queryDataSet((String)"BalanceService", (String)"gl_accountbook", (String)"accounttable.id accounttableId", (QFilter[])new QFilter[]{orgFilter, bookFilter}, null);){
            Iterator it = set.iterator();
            if (it.hasNext()) {
                Row row = (Row)it.next();
                accounttableId = row.getLong("accounttableId");
            }
        }
        return accounttableId;
    }

    private List<Map<String, Object>> trans2List(Set<String> selector, Map<String, Object> deriveMap, DataSet ds) {
        ArrayList<Map<String, Object>> rs = new ArrayList<Map<String, Object>>();
        int selSize = selector.size();
        Iterator rowIt = ds.iterator();
        String balanceLimit = BillParamUtil.getStringValue((String)"83bfebc8000017ac", (String)"fi.gl.service.balance.limit", (String)"100000");
        int limit = Integer.parseInt(balanceLimit);
        while (rowIt.hasNext()) {
            Row row = (Row)rowIt.next();
            HashMap<String, Object> rowData = new HashMap<String, Object>(selSize);
            for (String sel : selector) {
                rowData.put(sel, row.get(sel));
            }
            rs.add(rowData);
            if (rs.size() != limit) continue;
            new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8d85\u8fc7\u9650\u5236\u6570\u636e\u91cf\u201c%s\u201d\uff0c\u8bf7\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"BalanceServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0]), limit));
        }
        return rs;
    }

    private DataSet sum(DataSet ds, Set<String> balGroupFields, Set<String> assGroupFields, Map<String, String> selFiledMap, Set<String> assFields, Map<String, Object> deriveMap) {
        Set<String> fieldSet;
        LinkedList<String> allFields = new LinkedList<String>();
        HashSet<String> compareFields = new HashSet<String>(8);
        ArrayList<String> amountFields = new ArrayList<String>(8);
        for (Map.Entry<String, String> entry : selFiledMap.entrySet()) {
            String name = entry.getKey();
            String alias = entry.getValue();
            if (name.endsWith("for") || name.endsWith("local") || name.endsWith("qty")) {
                allFields.add(this.replaceFieldByDc(alias, deriveMap));
                amountFields.add(alias);
                compareFields.add(alias);
                continue;
            }
            allFields.add(alias);
            compareFields.add(alias);
        }
        allFields.addAll(assFields);
        compareFields.addAll(assFields);
        if (!((Boolean)deriveMap.get("flagDc")).booleanValue()) {
            allFields.remove(deriveMap.get("aliasDc"));
            compareFields.remove(deriveMap.get("aliasDc"));
        }
        if (!((Boolean)deriveMap.get("flagAcct")).booleanValue()) {
            allFields.remove(deriveMap.get("aliasAcct"));
            compareFields.remove(deriveMap.get("aliasAcct"));
        }
        if (!(fieldSet = this.dataSetFields(ds)).containsAll(compareFields)) {
            throw new GLException(GLErrorCode.common, new Object[]{String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5\u8ddf\u67e5\u8be2\u5b57\u6bb5\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u5b57\u6bb5\uff1a%1$s\uff1b\u548c\u67e5\u8be2\u5b57\u6bb5%2$s\u3002", (String)"BalanceQueryParamApi_0", (String)"fi-gl-webapi", (Object[])new Object[0]), fieldSet, compareFields)});
        }
        ds = ds.select(allFields.toArray(new String[0]));
        if (assGroupFields != null) {
            balGroupFields.addAll(assGroupFields);
        }
        if (balGroupFields != null && !balGroupFields.isEmpty()) {
            GroupbyDataSet gpRs = ds.groupBy(balGroupFields.toArray(new String[0]));
            for (String str : amountFields) {
                gpRs.sum(str);
            }
            ds = gpRs.finish();
        }
        return ds;
    }

    private Set<String> dataSetFields(DataSet ds) {
        Field[] fields;
        HashSet<String> fieldList = new HashSet<String>(8);
        for (Field field : fields = ds.getRowMeta().getFields()) {
            String alias = field.getAlias();
            fieldList.add(alias);
        }
        return fieldList;
    }

    private String replaceFieldByDc(String amountField, Map<String, Object> deriveMap) {
        if (this.dcFields.contains(amountField)) {
            String exp = "case when " + deriveMap.get("aliasDc") + "='1' then " + amountField + " else -1*" + amountField + " end as " + amountField;
            return exp;
        }
        return amountField;
    }

    public String[] splitStr(String str, String name, String alias) {
        String[] strs = str.trim().split("\\s+");
        alias = strs.length == 2 ? strs[1].trim() : strs[0].trim();
        name = strs[0].trim();
        return new String[]{name, alias};
    }

    private String getSelector(List<String> selector, List<String> groupBy, Map<String, String> selAliasMap, Map<String, String> selAssFields, Map<String, Object> deriveMap) {
        StringBuilder sels = new StringBuilder();
        HashSet<String> fs = new HashSet<String>();
        if (groupBy != null && !groupBy.isEmpty()) {
            fs.addAll(groupBy);
        }
        fs.addAll(selector);
        ArrayList<String> balFields = new ArrayList<String>(this.balanceFields);
        ArrayList<String> dcBalFields = new ArrayList<String>(this.dcFields);
        UnmodifiableList configVOS = LocalCurrencyConfigService.queryEnableCurrencies();
        for (LocalCurrencyConfigVO vo : configVOS) {
            balFields.addAll(Arrays.asList(vo.getOrmBalanceFields(new MCT[]{MCT.BEGIN, MCT.DEBIT, MCT.CREDIT, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT, MCT.END}).split(",")));
            dcBalFields.addAll(Arrays.asList(vo.getOrmBalanceFields(new MCT[]{MCT.BEGIN, MCT.END}).split(",")));
        }
        boolean flagSplit = false;
        for (String f : fs) {
            String fieldName;
            String name = "";
            String alias = "";
            String[] nameAndAlias = this.splitStr(f, name, alias);
            name = nameAndAlias[0];
            alias = nameAndAlias[1];
            String[] nameArray = name.split("\\.");
            String string = fieldName = nameArray.length == 0 ? name : name.split("\\.")[0];
            if (balFields.contains(fieldName) || fieldName.startsWith("comassist")) {
                if ("account.dc".equalsIgnoreCase(name)) {
                    deriveMap.put("aliasDc", alias);
                    deriveMap.put("flagDc", true);
                } else if ("account.id".equalsIgnoreCase(name) || "account".equalsIgnoreCase(name)) {
                    deriveMap.put("aliasAcct", alias);
                    deriveMap.put("flagAcct", true);
                } else if (dcBalFields.contains(name)) {
                    deriveMap.put(name + "_bal", alias);
                }
                if (flagSplit) {
                    sels.append(",").append(f);
                } else {
                    sels.append(f);
                    flagSplit = true;
                }
                selAliasMap.put(name, alias);
                continue;
            }
            selAssFields.put(name, alias);
        }
        if (fs.size() > 0) {
            if (!((Boolean)deriveMap.get("flagDc")).booleanValue()) {
                sels.append(",account.dc ").append(deriveMap.get("aliasDc"));
                selAliasMap.put("account.dc", (String)deriveMap.get("aliasDc"));
            }
            if (!((Boolean)deriveMap.get("flagAcct")).booleanValue()) {
                sels.append(",account.id ").append(deriveMap.get("aliasAcct"));
                selAliasMap.put("aliasAcct.id", (String)deriveMap.get("aliasAcct"));
            }
        }
        return sels.toString();
    }

    private void splitGroupFields(List<String> groupFields, Set<String> bals, Set<String> ass) {
        for (String fields : groupFields) {
            String fieldName;
            String name = "";
            String alias = "";
            String[] nameAndAlias = this.splitStr(fields, name, alias);
            name = nameAndAlias[0];
            alias = nameAndAlias[1];
            String[] nameArray = name.split("\\.");
            String string = fieldName = nameArray.length == 0 ? name : name.split("\\.")[0];
            if (this.balanceFields.contains(fieldName)) {
                bals.add(alias);
                continue;
            }
            ass.add(alias);
        }
    }

    private HashSet<Long> getAccountFilter(Map<Long, List<Map<String, Long>>> accountAssgrp) {
        if (accountAssgrp == null) {
            return new HashSet<Long>();
        }
        HashSet<Long> accountIds = new HashSet<Long>();
        for (Map.Entry<Long, List<Map<String, Long>>> entry : accountAssgrp.entrySet()) {
            Long accId = entry.getKey();
            accountIds.add(accId);
        }
        return accountIds;
    }
}

