/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.ContextUtil;
import kd.fi.gl.service.FinancialBooksService;
import kd.fi.gl.vo.AccountBookRes;

public class FinancialBooksServiceImpl
implements FinancialBooksService {
    private static final Log LOG = LogFactory.getLog(FinancialBooksServiceImpl.class);
    private static final String ENABLED = "C";
    private static final String TRUE_FlAG = "1";
    private static final String FALSE_FlAG = "0";
    private static final String BASE_FIELDS = "org,curperiod.id curperiodid,periodtype.id periodtypeid,startperiod.id startperiodid";
    private static final String[] CAS_FIELDS = new String[]{"org", "curperiodid", "periodtypeid", "bookstypeid", "startperiodid", "isfinishinit"};
    public static final String CAL_FIELD = "org,entry.currentperiod.id curperiodid,entry.calpolicy.periodtype.id periodtypeid,entry.startperiod.id startperiodid,entry.costaccount.booktype.id bookstypeid,entry.isenabled isfinishinit";

    public String queryAccountBooks(Map<String, Object> map) {
        try {
            String property;
            Long bookTypeId;
            LOG.info("queryAccountBooks param:{}", map);
            if (map == null) {
                return null;
            }
            if (ObjectUtils.isEmpty((Object)map.get("appNum"))) {
                LOG.info("appNum is null");
                throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"FinancialBooksServiceImpl_0", (String)"fi-fcm-mservice", (Object[])new Object[0]));
            }
            if (ObjectUtils.isEmpty((Object)map.get("orgIds"))) {
                LOG.info("orgIds is null");
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"FinancialBooksServiceImpl_1", (String)"fi-fcm-mservice", (Object[])new Object[0]));
            }
            String appNum = map.get("appNum").toString();
            List orgIds = (List)map.get("orgIds");
            QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
            Long l = bookTypeId = map.get("bookTypeId") == null ? Long.valueOf(0L) : (Long)map.get("bookTypeId");
            if (bookTypeId != 0L && StringUtils.isNotEmpty((CharSequence)(property = this.getBookTypeField(appNum)))) {
                QFilter bookTypeFilter = new QFilter(property, "=", (Object)bookTypeId);
                orgFilter.and(bookTypeFilter);
            }
            QFilter[] filters = new QFilter[]{orgFilter};
            String entityName = null;
            String selectFields = null;
            QFilter qFilter = null;
            switch (appNum) {
                case "ap": {
                    selectFields = "org,curperiod.id curperiodid,periodtype.id periodtypeid,startperiod.id startperiodid,isfinishinit";
                    entityName = "ap_init";
                    break;
                }
                case "ar": {
                    selectFields = "org,curperiod.id curperiodid,periodtype.id periodtypeid,startperiod.id startperiodid,policytype.id bookstypeid,isfinishinit";
                    entityName = "ar_init";
                    break;
                }
                case "gl": {
                    selectFields = "org,curperiod.id curperiodid,periodtype.id periodtypeid,startperiod.id startperiodid,bookstype.id bookstypeid,isendinit isfinishinit";
                    qFilter = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
                    qFilter.and("enable", "=", (Object)TRUE_FlAG);
                    List<Long> bootTypeIds = this.getBookTypeDataPermission(orgIds);
                    if (bootTypeIds != null) {
                        qFilter.and("bookstype", "in", bootTypeIds);
                    }
                    entityName = "gl_accountbook";
                    break;
                }
                case "fa": {
                    selectFields = "org,curperiod.id curperiodid,periodtype.id periodtypeid,startperiod.id startperiodid,depreuse.id bookstypeid,status isfinishinit";
                    entityName = "fa_assetbook";
                    break;
                }
                case "cal": {
                    selectFields = CAL_FIELD;
                    entityName = "cal_sysctrlentity";
                    break;
                }
            }
            if (qFilter != null) {
                List<QFilter> filterList = Arrays.stream(filters).collect(Collectors.toList());
                filterList.add(qFilter);
                filters = filterList.toArray(new QFilter[0]);
            }
            DataSet dataSet = "cas".equals(appNum) ? this.getDataSetCAS(filters) : QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])filters, null);
            dataSet.getRowMeta().getField("isfinishinit").setDataType((DataType)DataType.StringType);
            if ("ap".equals(appNum)) {
                dataSet = dataSet.addNullField("bookstypeid");
            }
            ArrayList<AccountBookRes> resList = new ArrayList<AccountBookRes>();
            for (Row row : dataSet) {
                AccountBookRes bookRes = new AccountBookRes();
                bookRes.setOrgId(row.getLong("org"));
                bookRes.setBookTypeId(row.getLong("bookstypeid"));
                bookRes.setCurrentPeriodId(row.getLong("curperiodid"));
                bookRes.setStartPeriodId(row.getLong("startperiodid"));
                bookRes.setPeriodTypeId(row.getLong("periodtypeid"));
                bookRes.setIsEndInit(this.convertIsFinishInit(appNum, row.getString("isfinishinit")));
                resList.add(bookRes);
            }
            return JSONUtils.toString(resList);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u7cfb\u7edf\u8d26\u7c3f\u67e5\u8be2\u5fae\u670d\u52a1\u5f02\u5e38[%1$s]: %2$s", (String)"FinancialBooksServiceImpl_2", (String)"fi-fcm-mservice", (Object[])new Object[0]), TraceIdUtil.getCurrentTraceIdString(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            LOG.error(msg, (Throwable)e);
            throw new KDBizException(msg);
        }
    }

    private DataSet getDataSetCAS(QFilter[] filters) {
        String selectFields = "org,period.id curperiodid";
        QFilter qFilter = new QFilter("checkoutstatus", "!=", (Object)"3");
        List<QFilter> filterList = Arrays.stream(filters).collect(Collectors.toList());
        filterList.add(qFilter);
        QFilter[] qFilters = filterList.toArray(new QFilter[0]);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cas_finalcheckout", (String)selectFields, (QFilter[])qFilters, null);
        DataSet dataSetInit = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cas_cashmgtinit", (String)"org,startperiod.id startperiodid,isfinishinit,periodtype.id periodtypeid", (QFilter[])filters, null);
        dataSet = dataSet.addNullField("bookstypeid");
        DataSet joinDataSet = dataSet.join(dataSetInit).on("org", "org").select(CAS_FIELDS).finish();
        return joinDataSet;
    }

    private String convertIsFinishInit(String appId, String isFinishInitStr) {
        if ("fa".equals(appId)) {
            if (ENABLED.equals(isFinishInitStr)) {
                return TRUE_FlAG;
            }
            return FALSE_FlAG;
        }
        if (Boolean.parseBoolean(isFinishInitStr)) {
            return TRUE_FlAG;
        }
        return FALSE_FlAG;
    }

    private String getBookTypeField(String appNum) {
        String property = null;
        switch (appNum) {
            case "ar": {
                property = "policytype";
                break;
            }
            case "gl": {
                property = "bookstype";
                break;
            }
            case "fa": {
                property = "depreuse";
                break;
            }
            case "cal": {
                property = "entry.costaccount.booktype";
                break;
            }
        }
        return property;
    }

    private List<Long> getBookTypeDataPermission(List<Long> orgIdList) {
        QFilter dataPermissionFilter = orgIdList == null || orgIdList.isEmpty() ? PermissionServiceHelper.getDataPermission((long)ContextUtil.getUserId(), null, (String)"bd_accountbookstype") : PermissionServiceHelper.getDataPermission((long)ContextUtil.getUserId(), null, (String)"bd_accountbookstype", orgIdList);
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbookstype", (QFilter[])new QFilter[]{dataPermissionFilter}, (String)"accounttype", (int)-1).stream().map(x -> Long.valueOf(x.toString())).collect(Collectors.toList());
    }
}

