/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.service.GLAccountBookService;
import kd.fi.gl.util.QFBuilder;

public class GLAccountBookServiceImpl
implements GLAccountBookService {
    private static final Log logger = LogFactory.getLog(GLAccountBookServiceImpl.class);

    public boolean isAccountBookClose(String org, String bookType, String year, String period) {
        List openedPeriodValues;
        if (DebugTrace.enable() && logger.isInfoEnabled()) {
            logger.info("GLAccountBookServiceImpl.isAccountBookClose is called, params are: org:{},booktype:{},year:{},period:{}", new Object[]{org, bookType, year, period});
        }
        if (StringUtils.isBlank((CharSequence)org) || StringUtils.isBlank((CharSequence)year) || StringUtils.isBlank((CharSequence)period)) {
            return true;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org.number", "=", (Object)org);
        if (StringUtils.isNotBlank((CharSequence)bookType)) {
            qfBuilder.add("bookstype.number", "=", (Object)bookType);
        } else {
            qfBuilder.add("bookstype.accounttype", "=", (Object)AccountBooksType.MAIN_BOOK.getValue());
        }
        DynamicObject accountBookDO = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"org,bookstype,periodtype,curperiod.periodyear periodyear,curperiod.periodnumber periodnumber", (QFilter[])qfBuilder.toArray());
        if (null == accountBookDO) {
            return true;
        }
        int curPeriodValue = accountBookDO.getInt("periodyear") * 1000 + accountBookDO.getInt("periodnumber");
        int periodValue = Integer.parseInt(year) * 1000 + Integer.parseInt(period);
        if (periodValue >= curPeriodValue) {
            return false;
        }
        qfBuilder.clear();
        qfBuilder.add("org", "=", (Object)accountBookDO.getLong("org"));
        qfBuilder.add("booktype", "=", (Object)accountBookDO.getLong("bookstype"));
        DynamicObjectCollection openedPeriods = QueryServiceHelper.query((String)"gl_openedperiod", (String)"period.periodyear periodyear,period.periodnumber periodnumber", (QFilter[])qfBuilder.toArray());
        return openedPeriods.isEmpty() || !(openedPeriodValues = openedPeriods.stream().map(x -> x.getInt("periodyear") * 1000 + x.getInt("periodnumber")).collect(Collectors.toList())).contains(periodValue);
    }

    public Map<String, Boolean> isAccountBookCloseBatch(List<String> orgs, String bookType, String year, String period) {
        return orgs.stream().distinct().collect(Collectors.toMap(x -> x, x -> this.isAccountBookClose((String)x, bookType, year, period)));
    }
}

