/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.business.service.reciprocal.UnAcccurrentUpdateUtil;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.TransBalToReciUtil;
import kd.fi.gl.service.ReciprocalInitEndInitService;
import kd.fi.gl.util.GLUtil;

public class ReciprocalInitEndInitServiceImpl
implements ReciprocalInitEndInitService {
    private static final String END_INIT_PERIOD = "endinitperiod";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String SUCCESS_MESSAGE = "successMessage";
    private static final String IS_SUCCESS = "isSuccess";
    private static final Log log = LogFactory.getLog(ReciprocalInitEndInitServiceImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAcctCurrentData(String jsonData) {
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>(8);
        Map map = (Map)SerializationUtils.fromJsonString((String)jsonData, Map.class);
        long bookId = Long.parseLong((String)map.get("bookId"));
        long accountTblId = Long.parseLong((String)map.get("accountTable"));
        boolean needEndInit = Boolean.parseBoolean((String)map.get("needEndInit"));
        AccountBookInfo accountBookInfo = new AccountBookInfo(bookId);
        DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id acct,number acctNumber,name acctName, masterid", (QFilter[])ReciprocalUtils.getAccAccountFilter((Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTblId).toArray(new QFilter[0]), null);
        DataSet endInitSet = ReciprocalInitUtils.queryIsEndInitReciprocalInit((boolean)needEndInit, (Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTblId);
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id periodid,name periodname", null, null);
        try (DataSet ds = endInitSet.join(dSet, JoinType.INNER).on("id", "acct").select(new String[]{"id", "acctName", "acctNumber", "masterid", END_INIT_PERIOD}).finish();){
            if (ds == null) return SerializationUtils.toJsonString(resultList);
            if (ds.isEmpty()) {
                String string = SerializationUtils.toJsonString(resultList);
                return string;
            }
            DataSet resultDs = ds.join(periodSet, JoinType.LEFT).on(END_INIT_PERIOD, "periodid").select(new String[]{"id", "acctNumber", "acctName", "periodname", "masterid", END_INIT_PERIOD}).finish();
            Map<String, String> currentAccountBook = ReciprocalInitEndInitServiceImpl.getCurPeriodByBookId(bookId);
            Iterator iterator = resultDs.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                JSONObject item = new JSONObject();
                String acct = row.getString("acctNumber") + "." + row.getString("acctName");
                String endInitPeriod = row.getString("periodname");
                item.put("account", (Object)row.getLong("id"));
                item.put("accountName", (Object)acct);
                item.put("masterId", (Object)row.getLong("masterid"));
                if (endInitPeriod != null) {
                    item.put("period", (Object)row.getLong(END_INIT_PERIOD));
                    item.put("periodName", (Object)endInitPeriod);
                } else {
                    item.put("period", (Object)Long.parseLong(currentAccountBook.get("curperiodId")));
                    item.put("periodName", (Object)currentAccountBook.get("curperiod"));
                }
                item.put("orgName", (Object)currentAccountBook.get("orgName"));
                item.put("orgNumber", (Object)currentAccountBook.get("orgNumber"));
                item.put("orgId", (Object)String.valueOf(accountBookInfo.getOrgId()));
                resultList.add(item);
            }
            return SerializationUtils.toJsonString(resultList);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
        return SerializationUtils.toJsonString(resultList);
    }

    private static Map<String, String> getCurPeriodByBookId(long bookId) {
        HashMap<String, String> result = new HashMap<String, String>();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)bookId, (String)"gl_accountbook", (String)"curperiod.id,curperiod.name,org");
        if (obj == null) {
            return result;
        }
        result.put("curperiodId", obj.getString("curperiod.id"));
        result.put("curperiod", obj.getString("curperiod.name"));
        result.put("orgName", obj.getString("org.name"));
        result.put("orgNumber", obj.getString("org.number"));
        return result;
    }

    public String initCurrentBalance(String jsonData) {
        JSONArray response = new JSONArray();
        List dataList = (List)SerializationUtils.fromJsonString((String)jsonData, List.class);
        for (Map map : dataList) {
            long bookId = Long.parseLong((String)map.get("bookId"));
            long accountTableId = Long.parseLong((String)map.get("accountTable"));
            map.put("needEndInit", "true");
            String acctCurrentData = this.getAcctCurrentData(SerializationUtils.toJsonString((Object)map));
            List resultList = (List)SerializationUtils.fromJsonString((String)acctCurrentData, List.class);
            if (CollectionUtils.isEmpty((Collection)resultList)) continue;
            AccountBookInfo accountBookInfo = new AccountBookInfo(bookId);
            JSONObject result = this.handleEndInit(accountBookInfo, resultList, accountTableId);
            response.add((Object)result);
        }
        return SerializationUtils.toJsonString((Object)response);
    }

    public String unInitCurrentBalance(String jsonData) {
        JSONArray response = new JSONArray();
        List dataList = (List)SerializationUtils.fromJsonString((String)jsonData, List.class);
        for (Map map : dataList) {
            long bookId = Long.parseLong((String)map.get("bookId"));
            map.put("needEndInit", "false");
            String acctCurrentData = this.getAcctCurrentData(SerializationUtils.toJsonString((Object)map));
            List resultList = (List)SerializationUtils.fromJsonString((String)acctCurrentData, List.class);
            if (CollectionUtils.isEmpty((Collection)resultList)) continue;
            AccountBookInfo accountBookInfo = new AccountBookInfo(bookId);
            JSONObject result = this.handleAntiEndInit(accountBookInfo, resultList);
            response.add((Object)result);
        }
        return SerializationUtils.toJsonString((Object)response);
    }

    private JSONObject handleEndInit(AccountBookInfo accountBookInfo, List<Map<String, Object>> selectedRows, long acctTable) {
        int successCount = selectedRows.size();
        JSONObject response = new JSONObject();
        if (accountBookInfo == null) {
            return response;
        }
        long tick = System.currentTimeMillis();
        ArrayList rowEntityList = new ArrayList(successCount);
        ArrayList accountIds = new ArrayList(successCount);
        selectedRows.forEach(rowEntity -> accountIds.add(Long.parseLong(String.valueOf(rowEntity.get("account")))));
        DynamicObject[] accounts = BusinessDataServiceHelper.load((Object[])accountIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        HashMap accountIdDynMap = new HashMap(successCount);
        Arrays.stream(accounts).forEach(account -> accountIdDynMap.put(account.getLong("id"), account));
        log.info("endreciprocalinit query accounts cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        ArrayList futures = new ArrayList(selectedRows.size());
        String traceId = RequestContext.get().getTraceId();
        selectedRows.forEach(rowEntity -> {
            Future future = ThreadService.submit(() -> {
                TraceIdUtil.setCurrentTraceId((String)traceId);
                String validateMsg = "";
                DynamicObject account = (DynamicObject)accountIdDynMap.get(Long.parseLong(String.valueOf(rowEntity.get("account"))));
                long periodId = Long.parseLong(String.valueOf(rowEntity.get("period")));
                if (accountBookInfo.isIsendinit()) {
                    String number = account.getString("number");
                    String fullName = account.getString("fullname");
                    String accountShow = number + fullName;
                    if (periodId == 0L) {
                        validateMsg = String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u6ca1\u6709\u8bbe\u7f6e\u521d\u59cb\u5316\u671f\u95f4\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002\r\n", (String)"ReciprocalInitEndInitPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), accountShow);
                        return new Tuple(rowEntity, (Object)validateMsg);
                    }
                    if (periodId != accountBookInfo.getCurPeriodId()) {
                        validateMsg = String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u521d\u59cb\u5316\u671f\u95f4\u4e0d\u662f\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002\r\n", (String)"ReciprocalInitEndInitPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), accountShow);
                        return new Tuple(rowEntity, (Object)validateMsg);
                    }
                    TransBalToReciUtil transBalToReciUtil = new TransBalToReciUtil();
                    validateMsg = transBalToReciUtil.compareBalanceWithReciprocal(account, Long.valueOf(periodId), accountBookInfo);
                    if (validateMsg.length() > 0) {
                        return new Tuple(rowEntity, (Object)validateMsg);
                    }
                }
                Long orgId = accountBookInfo.getOrgId();
                Long bookType = accountBookInfo.getBookTypeId();
                Long localCurrency = accountBookInfo.getBaseCurrencyId();
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookType);
                Long accountId = account.getLong("id");
                QFilter accountFilter = new QFilter("account.masterid", "=", account.get("masterid"));
                DynamicObject reciprocalInitState = BusinessDataServiceHelper.loadSingle((String)"gl_reci_init_state", (String)"id,endinitperiod, isendinit, modifier, modifydate", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accountFilter});
                Date modifyDate = TimeServiceHelper.now();
                if (reciprocalInitState == null) {
                    ReciprocalUtils.delAcccBeforePeroid((Long)orgId, (Long)bookType, (Long)account.getLong("masterid"), (Long)periodId);
                }
                DynamicObject period = PeriodUtil.getPeriod((Long)periodId, (String)"id,begindate");
                long tick1 = System.currentTimeMillis();
                this.handleRecordAddNewByInit(accountBookInfo, orgFilter, bookTypeFilter, account, acctTable, response, period);
                log.info("endreciprocalinit handleRecordAddNewByInit cost:{}ms", (Object)(System.currentTimeMillis() - tick1));
                tick1 = System.currentTimeMillis();
                this.handleRecordUpdateByInit(orgFilter, bookTypeFilter, account, reciprocalInitState, period);
                log.info("endreciprocalinit handleRecordUpdateByInit cost:{}ms", (Object)(System.currentTimeMillis() - tick1));
                tick1 = System.currentTimeMillis();
                ReciprocalUtils.batchSaveReciprocalRecordsEndInit((Long)orgId, (Long)bookType, (Long)periodId, (Long)localCurrency, (Long)acctTable, (Long)account.getLong("masterid"), (DynamicObject)reciprocalInitState);
                log.info("endreciprocalinit batchSaveReciprocalRecordsEndInit cost:{}ms", (Object)(System.currentTimeMillis() - tick1));
                tick1 = System.currentTimeMillis();
                UnAcccurrentUpdateUtil.asyncReCalUnAcccurrent((long)orgId, (long)bookType, (long)acctTable, (Long)account.getLong("masterid"));
                log.info("endreciprocalinit ReciprocalUtils.reCalUnAcccurrent cost:{}ms", (Object)(System.currentTimeMillis() - tick1));
                if (reciprocalInitState == null) {
                    reciprocalInitState = BusinessDataServiceHelper.newDynamicObject((String)"gl_reci_init_state");
                    reciprocalInitState.set("org", (Object)orgId);
                    reciprocalInitState.set("booktype", (Object)bookType);
                    reciprocalInitState.set("accounttable", (Object)acctTable);
                    reciprocalInitState.set("account", (Object)accountId);
                }
                reciprocalInitState.set(END_INIT_PERIOD, (Object)periodId);
                reciprocalInitState.set("isendinit", (Object)Boolean.TRUE);
                String userId = RequestContext.get().getUserId();
                reciprocalInitState.set("modifier_id", (Object)Long.valueOf(userId));
                reciprocalInitState.set("modifydate", (Object)modifyDate);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reciprocalInitState});
                return new Tuple(rowEntity, (Object)validateMsg);
            }, (TaskType)TaskType.GL_RECIPROCAL_INIT_END_INIT_SERVICE);
            futures.add(future);
        });
        StringBuilder tipMsg = new StringBuilder();
        futures.forEach(x -> {
            try {
                Tuple result = (Tuple)x.get();
                if (StringUtils.isEmpty((CharSequence)((CharSequence)result.item2))) {
                    rowEntityList.add(result.item1);
                } else {
                    tipMsg.append((String)result.item2);
                }
            }
            catch (Exception e) {
                log.error("doEndInit failed.", (Throwable)e);
                response.put(IS_SUCCESS, (Object)Boolean.FALSE);
                response.put(ERROR_MESSAGE, (Object)e.getMessage());
            }
        });
        if (tipMsg.length() > 0) {
            response.put(IS_SUCCESS, (Object)Boolean.FALSE);
            response.put(ERROR_MESSAGE, (Object)tipMsg.toString());
        } else {
            response.put(IS_SUCCESS, (Object)Boolean.TRUE);
            response.put(SUCCESS_MESSAGE, (Object)ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"ReciprocalInitEndInitServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        log.info("endreciprocalinit doEndInit totalcost:{}ms", (Object)(System.currentTimeMillis() - tick));
        return response;
    }

    private void handleRecordAddNewByInit(AccountBookInfo accountBookInfo, QFilter orgFilter, QFilter bookTypeFilter, DynamicObject account, Long acctTblId, JSONObject response, DynamicObject period) {
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                List reciprocalRecordList = ReciprocalInitUtils.buildReciprocalRecordFromInit((DynamicObject)account, (AccountBookInfo)accountBookInfo, (QFilter)orgFilter, (QFilter)bookTypeFilter, (Long)acctTblId, (DynamicObject)period);
                if (reciprocalRecordList.size() == 0) break;
                try {
                    SaveServiceHelper.save((DynamicObject[])reciprocalRecordList.toArray(new DynamicObject[0]));
                    reciprocalRecordList.clear();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    response.put(IS_SUCCESS, (Object)Boolean.FALSE);
                    response.put(ERROR_MESSAGE, (Object)ResManager.loadKDString((String)"\u5f80\u6765\u521d\u59cb\u5316\u589e\u91cf\u65b0\u589e\u5f80\u6765\u8d26\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u6392\u67e5\u3002", (String)"ReciprocalInitEndInitPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    log.error("\u5f80\u6765\u521d\u59cb\u5316\u589e\u91cf\u65b0\u589e\u5f80\u6765\u8d26\u51fa\u9519\uff1a", (Throwable)e);
                    return;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
    }

    private void handleRecordUpdateByInit(QFilter orgFilter, QFilter bookTypeFilter, DynamicObject account, DynamicObject reciprocalInitState, DynamicObject period) {
        QFilter acctFilter = new QFilter("account.masterid", "=", (Object)account.getLong("masterid"));
        QFilter recordIsNullFilter = new QFilter("reciprocalrecord", "!=", (Object)0L);
        QFilter recordStatusFilter = new QFilter("reciprocalrecord.status", "=", (Object)"0");
        QFilter[] filters = null;
        if (reciprocalInitState == null) {
            return;
        }
        QFilter modifyDateFilter = new QFilter("modifydate", ">=", (Object)reciprocalInitState.getDate("modifydate"));
        filters = new QFilter[]{acctFilter, orgFilter, bookTypeFilter, recordIsNullFilter, recordStatusFilter, modifyDateFilter};
        ArrayList<Long> initPkIds = new ArrayList<Long>(10);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "handleRecordUpdateByInit"), (String)"gl_initacccurrent", (String)"id", (QFilter[])filters, null);){
            if (ds != null) {
                for (Row row : ds) {
                    initPkIds.add(row.getLong("id"));
                }
            }
        }
        int size = initPkIds.size();
        HashSet<Long> updatingIds = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            updatingIds.add((Long)initPkIds.get(i));
            if (updatingIds.size() < 1000) continue;
            this.updateReciprocalRecordOnce(updatingIds, period);
        }
        this.updateReciprocalRecordOnce(updatingIds, period);
    }

    private void updateReciprocalRecordOnce(Set<Long> updatingIds, DynamicObject period) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                QFilter idFilter = new QFilter("id", "in", updatingIds);
                DynamicObject[] reciprocalRecordArray = ReciprocalInitUtils.updateReciprocalRecordFromInit((QFilter)idFilter, (DynamicObject)period);
                if (reciprocalRecordArray == null) {
                    return;
                }
                SaveServiceHelper.save((DynamicObject[])reciprocalRecordArray);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("\u5f80\u6765\u521d\u59cb\u5316\u589e\u91cf\u66f4\u65b0\u5f80\u6765\u8d26\u51fa\u9519\uff1a", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f80\u6765\u521d\u59cb\u5316\u589e\u91cf\u66f4\u65b0\u5f80\u6765\u8d26\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u6392\u67e5\u3002", (String)"ReciprocalInitEndInitPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            finally {
                updatingIds.clear();
            }
        }
    }

    private JSONObject handleAntiEndInit(AccountBookInfo accountBookInfo, List<Map<String, Object>> resultList) {
        int i;
        JSONObject response = new JSONObject();
        Set<Long> accountIdSet = this.validateAntiEndInit(accountBookInfo, resultList, response);
        try (TXHandle tx = TX.required();){
            try {
                Object userId;
                Long orgId = accountBookInfo.getOrgId();
                Long bookType = accountBookInfo.getBookTypeId();
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookType);
                QFilter accountFilter = new QFilter("account.masterid", "in", accountIdSet);
                DynamicObject[] reciprocalInitStates = BusinessDataServiceHelper.load((String)"gl_reci_init_state", (String)"id, account, isendinit, modifier,modifydate", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accountFilter});
                QFilter accountSingleFilter = null;
                QFilter stateFilter = new QFilter("status", "not in", (Object)"0");
                HashSet<Long> allMasterIdSet = new HashSet<Long>(8);
                for (i = 0; i < reciprocalInitStates.length; ++i) {
                    DynamicObject reciprocalInitState = reciprocalInitStates[i];
                    reciprocalInitState.set("isendinit", (Object)Boolean.FALSE);
                    userId = RequestContext.get().getUserId();
                    reciprocalInitState.set("modifier", (Object)Long.valueOf((String)userId));
                    reciprocalInitState.set("modifydate", (Object)TimeServiceHelper.now());
                    DynamicObject acct = reciprocalInitState.getDynamicObject("account");
                    allMasterIdSet.add(acct.getLong("masterid"));
                }
                accountSingleFilter = new QFilter("account", "in", allMasterIdSet);
                DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "queryaccurent"), (String)"gl_acccurrent", (String)"account", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accountSingleFilter, stateFilter}, null);
                userId = null;
                try {
                    for (Row row : ds) {
                        allMasterIdSet.remove(row.getLong("account"));
                    }
                }
                catch (Throwable acct) {
                    userId = acct;
                    throw acct;
                }
                finally {
                    if (ds != null) {
                        if (userId != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable acct) {
                                ((Throwable)userId).addSuppressed(acct);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                List idList = GLUtil.getIdsByMasterIds((String)"bd_accountview", allMasterIdSet, null, (int)-1);
                if (!idList.isEmpty()) {
                    int size = idList.size() + 1;
                    ArrayList<String> idStr = new ArrayList<String>(size);
                    ArrayList<Long> param = new ArrayList<Long>(size);
                    param.add(orgId);
                    param.add(bookType);
                    for (Object id : idList) {
                        idStr.add("?");
                        param.add((Long)id);
                    }
                    QFilter deleteAccountFilter = new QFilter("account.masterid", "in", allMasterIdSet);
                    QFilter[] filterArray = new QFilter[]{orgFilter, bookTypeFilter, deleteAccountFilter};
                    DeleteServiceHelper.delete((String)"gl_acccurrent", (QFilter[])filterArray);
                    DeleteServiceHelper.delete((String)"gl_reci_init_state", (QFilter[])filterArray);
                    String sql = "update t_gl_initacccurrent set freciprocalrecordid = 0 where forgid = ? and fbooktypeid = ? and faccountid in (" + String.join((CharSequence)",", idStr) + ")";
                    DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql, (Object[])param.toArray());
                }
                SaveServiceHelper.save((DynamicObject[])reciprocalInitStates);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("reciAntiEndInit", e.getMessage()), new Object[]{""});
            }
        }
        if (resultList.size() == i) {
            response.put(IS_SUCCESS, (Object)Boolean.TRUE);
            response.put(SUCCESS_MESSAGE, (Object)ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"ReciprocalInitEndInitServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        return response;
    }

    private Set<Long> validateAntiEndInit(AccountBookInfo accountBookInfo, List<Map<String, Object>> resultList, JSONObject response) {
        HashSet<Long> accountIdSet = new HashSet<Long>(resultList.size());
        StringBuilder tipMsg = new StringBuilder();
        for (Map<String, Object> rowEntity : resultList) {
            long periodId = Long.parseLong(String.valueOf(rowEntity.get("period")));
            String accountShow = String.valueOf(rowEntity.get("accountName"));
            if (periodId == 0L) {
                tipMsg.append(String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u6ca1\u6709\u8bbe\u7f6e\u521d\u59cb\u5316\u671f\u95f4\uff0c\u4e0d\u80fd\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u3002\r\n", (String)"ReciprocalInitEndInitPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), accountShow));
                continue;
            }
            if (periodId != accountBookInfo.getCurPeriodId()) {
                tipMsg.append(String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u521d\u59cb\u5316\u671f\u95f4\u4e0d\u662f\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u3002\r\n", (String)"ReciprocalInitEndInitPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), accountShow));
                continue;
            }
            accountIdSet.add(Long.parseLong(String.valueOf(rowEntity.get("masterId"))));
        }
        if (tipMsg.length() > 0) {
            response.put(IS_SUCCESS, (Object)Boolean.FALSE);
            response.put(ERROR_MESSAGE, (Object)tipMsg.toString());
        }
        return accountIdSet;
    }
}

