/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.DateUtil;

public class VoucherNumberService
implements ISkillRunnable {
    private static DBRoute ROUNTE_FI = DBRoute.of((String)"fi");
    private static final Log logger = LogFactory.getLog(VoucherNumberService.class);

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        if (skillRunContext == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u201cSkillRunContext\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherNumberService_0", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        String skillNum = skillRunContext.getSkillNum();
        Date startTime = skillRunContext.getStartTime();
        if (startTime == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherNumberService_1", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        Date endTime = skillRunContext.getEndTime();
        if (endTime == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherNumberService_2", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        Date date = new Date();
        Date curMonFirstDay = DateUtil.getFirstMonthDay((Date)date, (int)0);
        Date curMonLastDay = DateUtil.getLastMonthDay((Date)date, (int)0);
        Date cur3MonFirstDay = DateUtil.getFirstMonthDay((Date)date, (int)-2);
        List<Object> currentPeriodIds = this.getPeriodIds(curMonFirstDay, curMonLastDay);
        List<Object> currentThreePeriodIds = this.getPeriodIds(cur3MonFirstDay, curMonLastDay);
        boolean ismechanism = false;
        int curPeriodVoucherSize = this.getVoucherSizeByFilter(currentPeriodIds, ismechanism);
        ismechanism = true;
        int curPeriodMesVoucherSize = this.getVoucherSizeByFilter(currentPeriodIds, ismechanism);
        ismechanism = false;
        int cur3PeriodVoucherSize = this.getVoucherSizeByFilter(currentThreePeriodIds, ismechanism);
        ismechanism = true;
        int cur3PeriodMesVoucherSize = this.getVoucherSizeByFilter(currentThreePeriodIds, ismechanism);
        List<Map<String, String>> queryResult = this.genQueryResult(curPeriodVoucherSize, curPeriodMesVoucherSize, cur3PeriodVoucherSize, cur3PeriodMesVoucherSize);
        int total = this.getTotalCount(startTime, endTime);
        skillResult.setData(queryResult);
        skillResult.setDate(date);
        skillResult.setSkillNum(skillNum);
        skillResult.setFailCount(Integer.valueOf(0));
        skillResult.setTotalCount(Integer.valueOf(total));
        logger.info("VoucherNumberApI pullData skillResult: {}", (Object)skillResult);
        return skillResult;
    }

    private int getTotalCount(Date startTime, Date endTime) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) from  t_gl_voucher where", new Object[0]);
        sqlBuilder.append(" fcreatetime >= ?", new Object[]{startTime});
        sqlBuilder.append(" and fcreatetime <= ?", new Object[]{endTime});
        sqlBuilder.append(" and fsourcetype = ?", new Object[]{Character.valueOf('4')});
        return this.executeSql(sqlBuilder);
    }

    private List<Object> getPeriodIds(Date startDate, Date endDate) {
        ArrayList<Object> periodIds = new ArrayList<Object>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "#getPeriodIds"), (String)"bd_period", (String)"id,periodtype.id periodtypeid", (QFilter[])new QFilter("begindate", ">=", (Object)startDate).and(new QFilter("enddate", "<=", (Object)endDate)).toArray(), (String)"number asc");){
            for (Row row : dataset) {
                periodIds.add(row.getLong("id"));
            }
        }
        return periodIds;
    }

    private List<Map<String, String>> genQueryResult(int curPeriodVoucherSize, int curPeriodMesVoucherSize, int cur3PeriodVoucherSize, int cur3PeriodMesVoucherSize) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(6);
        HashMap<String, String> curPeriodVoucherMap = new HashMap<String, String>(4);
        curPeriodVoucherMap.put("name", ResManager.loadKDString((String)"\u672c\u671f\u51ed\u8bc1\u6570\u91cf", (String)"VoucherNumberApI_3", (String)"fi-gl-mservice", (Object[])new Object[0]));
        curPeriodVoucherMap.put("value", String.valueOf(curPeriodVoucherSize));
        curPeriodVoucherMap.put("valueType", "0");
        curPeriodVoucherMap.put("number", "curPeriodVoucher");
        HashMap<String, String> curPeriodMesVoucherMap = new HashMap<String, String>(4);
        curPeriodMesVoucherMap.put("name", ResManager.loadKDString((String)"\u672c\u671f\u673a\u5236\u51ed\u8bc1\u6570\u91cf", (String)"VoucherNumberApI_4", (String)"fi-gl-mservice", (Object[])new Object[0]));
        curPeriodMesVoucherMap.put("value", String.valueOf(curPeriodMesVoucherSize));
        curPeriodMesVoucherMap.put("valueType", "0");
        curPeriodMesVoucherMap.put("number", "curPeriodMesVoucher");
        HashMap<String, String> curPeriodAutoRateMap = new HashMap<String, String>(4);
        curPeriodAutoRateMap.put("name", ResManager.loadKDString((String)"\u672c\u671f\u81ea\u52a8\u5316\u7387", (String)"VoucherNumberApI_5", (String)"fi-gl-mservice", (Object[])new Object[0]));
        String value = "0.00%";
        if (curPeriodVoucherSize != 0) {
            value = BigDecimal.valueOf((float)(curPeriodMesVoucherSize * 100) / (float)curPeriodVoucherSize).setScale(2, 4).toString() + "%";
        }
        curPeriodAutoRateMap.put("value", value);
        curPeriodAutoRateMap.put("valueType", "1");
        curPeriodAutoRateMap.put("number", "curPeriodAutoRate");
        HashMap<String, String> cur3PeriodVoucherMap = new HashMap<String, String>(4);
        cur3PeriodVoucherMap.put("name", ResManager.loadKDString((String)"\u8fd1\u4e09\u671f\u51ed\u8bc1\u6570\u91cf", (String)"VoucherNumberApI_6", (String)"fi-gl-mservice", (Object[])new Object[0]));
        cur3PeriodVoucherMap.put("value", String.valueOf(cur3PeriodVoucherSize));
        cur3PeriodVoucherMap.put("valueType", "0");
        cur3PeriodVoucherMap.put("number", "cur3PeriodVoucher");
        HashMap<String, String> cur3PeriodMesVoucherMap = new HashMap<String, String>(4);
        cur3PeriodMesVoucherMap.put("name", ResManager.loadKDString((String)"\u8fd1\u4e09\u671f\u673a\u5236\u51ed\u8bc1\u6570\u91cf", (String)"VoucherNumberApI_7", (String)"fi-gl-mservice", (Object[])new Object[0]));
        cur3PeriodMesVoucherMap.put("value", String.valueOf(cur3PeriodMesVoucherSize));
        cur3PeriodMesVoucherMap.put("valueType", "0");
        cur3PeriodMesVoucherMap.put("number", "cur3PeriodMesVoucher");
        HashMap<String, String> cur3PeriodAutoRateMap = new HashMap<String, String>(4);
        cur3PeriodAutoRateMap.put("name", ResManager.loadKDString((String)"\u8fd1\u4e09\u671f\u81ea\u52a8\u5316\u7387", (String)"VoucherNumberApI_8", (String)"fi-gl-mservice", (Object[])new Object[0]));
        value = "0.00%";
        if (cur3PeriodVoucherSize != 0) {
            value = BigDecimal.valueOf((float)(cur3PeriodMesVoucherSize * 100) / (float)cur3PeriodVoucherSize).setScale(2, 4).toString() + "%";
        }
        cur3PeriodAutoRateMap.put("value", value);
        cur3PeriodAutoRateMap.put("valueType", "1");
        cur3PeriodAutoRateMap.put("number", "cur3PeriodAutoRate");
        result.add(cur3PeriodVoucherMap);
        result.add(cur3PeriodMesVoucherMap);
        result.add(cur3PeriodAutoRateMap);
        result.add(curPeriodVoucherMap);
        result.add(curPeriodMesVoucherMap);
        result.add(curPeriodAutoRateMap);
        return result;
    }

    private int getVoucherSizeByFilter(List<Object> currentPeriodIds, boolean ismechanism) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) from  t_gl_voucher where ", new Object[0]);
        sqlBuilder.appendIn("fperiodid", currentPeriodIds);
        if (ismechanism) {
            sqlBuilder.append("and fsourcetype = ?", new Object[]{Character.valueOf('4')});
        }
        return this.executeSql(sqlBuilder);
    }

    private int executeSql(SqlBuilder sqlBuilder) {
        return (Integer)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                rs.next();
                return rs.getInt(1);
            }
        });
    }
}

