/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service.unzipbalance;

import com.kingdee.bos.qing.api.customtable.interfaces.IQingEntityDataPostProcessor;
import com.kingdee.bos.qing.api.customtable.model.FieldData;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.service.unzipbalance.UnzipType;

public class UnzipBalanceService
implements IQingEntityDataPostProcessor {
    private static final Set<String> MUST_INPUT_FIELDS_SET = new HashSet<String>(Arrays.asList("org", "booktype", "period", "endperiod"));
    private static final Set<String> BEGIN_FIELD_NAME = new HashSet<String>(Arrays.asList("beginqty", "beginfor", "beginlocal"));
    private static final Set<String> CURRENT_PERIOD_FIELD_NAME = new HashSet<String>(Arrays.asList("debitqty", "creditqty", "debitfor", "creditfor", "debitlocal", "creditlocal"));
    private static final Set<String> YEAR_FIELD_NAME = new HashSet<String>(Arrays.asList("yeardebitqty", "yeardebitfor", "yeardebitlocal", "yearcreditqty", "yearcreditfor", "yearcreditlocal"));
    private static final Map<String, String> BEGIN_TO_END_FIELD_MAP;
    private static final BigDecimal ZERO;

    public List<Map<String, FieldData>> process(Map<String, FieldData> map) {
        if (!this.containsAllMustInputField(map.keySet())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e2d\u7f3a\u5c11\u5fc5\u987b\u8981\u4f20\u7684\u5b57\u6bb5\uff0c\u65e0\u6cd5\u89e3\u6790\u3002", (String)"UnzipBalanceService_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        long orgId = ((BigDecimal)this.getValue(map, this.getFieldIdName("org"))).longValue();
        long bookTypeId = ((BigDecimal)this.getValue(map, this.getFieldIdName("booktype"))).longValue();
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        Set<String> periodSelectFieldSet = map.keySet().stream().filter(key -> key.startsWith("period") || key.startsWith("endperiod")).map(key -> key.split("\\.")[1]).collect(Collectors.toSet());
        Tuple<Map<Long, Integer>, List<DynamicObject>> periodTuple = this.getAllPeriodByType(bookInfo.getPeriodTypeId(), String.join((CharSequence)",", periodSelectFieldSet.toArray(new String[0])));
        int toPeriod = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.mservice.unzipbalance.period", (int)0);
        int curPeriodIndex = (Integer)((Map)periodTuple.item1).get(bookInfo.getCurPeriodId());
        long curPeriodId = ((List)periodTuple.item2).size() > curPeriodIndex + toPeriod ? ((DynamicObject)((List)periodTuple.item2).get(curPeriodIndex + toPeriod)).getLong("id") : ((DynamicObject)((List)periodTuple.item2).get(((List)periodTuple.item2).size() - 1)).getLong("id");
        UnzipType unzipType = this.getUnzipType(map, periodTuple, curPeriodId);
        return this.unzipBalance(map, unzipType, curPeriodId, periodTuple);
    }

    private boolean containsAllMustInputField(Set<String> fieldKeySet) {
        HashSet<String> mustInputFieldSet = new HashSet<String>(8);
        for (String field : MUST_INPUT_FIELDS_SET) {
            mustInputFieldSet.add(this.getFieldIdName(field));
        }
        for (String beginField : BEGIN_FIELD_NAME) {
            if (!fieldKeySet.contains(beginField)) continue;
            mustInputFieldSet.add(this.getEndFieldByBegin(beginField));
        }
        return fieldKeySet.containsAll(mustInputFieldSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple<Map<Long, Integer>, List<DynamicObject>> getAllPeriodByType(long periodTypeId, String selectFields) {
        CacheKey cacheKey = CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.UNZIP_BALANCE_PERIOD, (Object[])new Object[]{periodTypeId});
        Tuple periodTuple = (Tuple)LocalCacheHelper.get((CacheKey)cacheKey, Tuple.class);
        if (!Objects.isNull(periodTuple)) return periodTuple;
        Class<UnzipBalanceService> clazz = UnzipBalanceService.class;
        synchronized (UnzipBalanceService.class) {
            periodTuple = (Tuple)LocalCacheHelper.get((CacheKey)cacheKey, Tuple.class);
            if (!Objects.isNull(periodTuple)) return periodTuple;
            DynamicObjectCollection periodDys = QueryServiceHelper.query((String)"bd_period", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId)}, (String)"id", (int)-1);
            ArrayList<DynamicObject> periodIdList = new ArrayList<DynamicObject>(periodDys.size());
            HashMap<Long, Integer> periodIdToIndexMap = new HashMap<Long, Integer>(periodDys.size());
            for (int i = 0; i < periodDys.size(); ++i) {
                DynamicObject periodDy = (DynamicObject)periodDys.get(i);
                periodIdList.add(periodDy);
                long periodId = periodDy.getLong("id");
                periodIdToIndexMap.put(periodId, i);
            }
            periodTuple = new Tuple(periodIdToIndexMap, periodIdList);
            LocalCacheHelper.put((CacheKey)cacheKey, (Object)periodTuple);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return periodTuple;
        }
    }

    private UnzipType getUnzipType(Map<String, FieldData> map, Tuple<Map<Long, Integer>, List<DynamicObject>> periodTuple, long curPeriodId) {
        Map periodIdToIndexMap = (Map)periodTuple.item1;
        List periodDyList = (List)periodTuple.item2;
        long periodId = ((BigDecimal)this.getValue(map, this.getFieldIdName("period"))).longValue();
        long endPeriodId = ((BigDecimal)this.getValue(map, this.getFieldIdName("endperiod"))).longValue();
        if (endPeriodId == 0L) {
            endPeriodId = (Integer)periodIdToIndexMap.get(curPeriodId) + 1 >= periodDyList.size() ? curPeriodId : ((DynamicObject)periodDyList.get((Integer)periodIdToIndexMap.get(curPeriodId) + 1)).getLong("id");
        }
        if (periodId == endPeriodId || (Integer)periodIdToIndexMap.get(periodId) + 1 == (Integer)periodIdToIndexMap.get(endPeriodId)) {
            return UnzipType.SINGLE_PERIOD;
        }
        if (PeriodUtil.getYear((long)periodId) == PeriodUtil.getYear((long)endPeriodId)) {
            return UnzipType.MUL_PERIOD;
        }
        return UnzipType.CROSS_YEAR;
    }

    private List<Map<String, FieldData>> unzipBalance(Map<String, FieldData> map, UnzipType unzipType, long curPeriodId, Tuple<Map<Long, Integer>, List<DynamicObject>> periodTuple) {
        ArrayList<Map<String, FieldData>> result = new ArrayList<Map<String, FieldData>>(8);
        switch (unzipType) {
            case SINGLE_PERIOD: {
                result.add(map);
                break;
            }
            case MUL_PERIOD: 
            case CROSS_YEAR: {
                result.addAll(this.dealFieldDataMap(map, curPeriodId, periodTuple));
                break;
            }
        }
        return result;
    }

    private List<Map<String, FieldData>> dealFieldDataMap(Map<String, FieldData> map, long curPeriodId, Tuple<Map<Long, Integer>, List<DynamicObject>> periodTuple) {
        int endIndex;
        ArrayList<Map<String, FieldData>> result = new ArrayList<Map<String, FieldData>>(8);
        long periodId = ((BigDecimal)this.getValue(map, this.getFieldIdName("period"))).longValue();
        long endPeriodId = ((BigDecimal)this.getValue(map, this.getFieldIdName("endperiod"))).longValue();
        Map periodIdToIndexMap = (Map)periodTuple.item1;
        List periodDyList = (List)periodTuple.item2;
        if (endPeriodId == 0L && (Integer)periodIdToIndexMap.get(curPeriodId) + 1 < periodDyList.size()) {
            endPeriodId = ((DynamicObject)periodDyList.get((Integer)periodIdToIndexMap.get(curPeriodId) + 1)).getLong("id");
        }
        int startIndex = (Integer)periodIdToIndexMap.get(periodId);
        int n = endIndex = endPeriodId == 0L ? periodDyList.size() : ((Integer)periodIdToIndexMap.get(endPeriodId)).intValue();
        if (startIndex + 1 < periodDyList.size()) {
            DynamicObject nextPeriodDy = (DynamicObject)periodDyList.get(startIndex + 1);
            HashMap<String, FieldData> fieldDataMap = new HashMap<String, FieldData>(8);
            for (Map.Entry<String, FieldData> fieldDataEntry : map.entrySet()) {
                String field = fieldDataEntry.getKey();
                FieldData fieldData = fieldDataEntry.getValue();
                if (field.startsWith("endperiod")) {
                    String periodField = field.split("\\.")[1];
                    fieldDataMap.put(field, new FieldData(field, fieldData.getQingFieldName(), nextPeriodDy.get(periodField)));
                    continue;
                }
                fieldDataMap.put(field, fieldData);
            }
            result.add(fieldDataMap);
        } else {
            result.add(map);
        }
        long curYear = PeriodUtil.getYear((long)periodId);
        for (int i = startIndex + 1; i < endIndex; ++i) {
            DynamicObject periodDy = (DynamicObject)periodDyList.get(i);
            DynamicObject nextPeriodDy = null;
            if (i + 1 < periodDyList.size()) {
                nextPeriodDy = (DynamicObject)periodDyList.get(i + 1);
            }
            if (curYear == PeriodUtil.getYear((long)periodDy.getLong("id"))) {
                result.add(this.buildFieldDataMap(periodDy, nextPeriodDy, map, false));
                continue;
            }
            result.add(this.buildFieldDataMap(periodDy, nextPeriodDy, map, true));
        }
        return result;
    }

    private Map<String, FieldData> buildFieldDataMap(DynamicObject periodDy, DynamicObject nextPeriodDy, Map<String, FieldData> map, boolean crossYear) {
        HashMap<String, FieldData> fieldDataMap = new HashMap<String, FieldData>(8);
        for (Map.Entry<String, FieldData> fieldDataEntry : map.entrySet()) {
            String periodField;
            String field = fieldDataEntry.getKey();
            FieldData oriFieldData = fieldDataEntry.getValue();
            String qingFieldName = oriFieldData.getQingFieldName();
            if (field.startsWith("period")) {
                periodField = field.split("\\.")[1];
                fieldDataMap.put(field, new FieldData(field, qingFieldName, periodDy.get(periodField)));
                continue;
            }
            if (field.startsWith("endperiod") && Objects.nonNull(nextPeriodDy)) {
                periodField = field.split("\\.")[1];
                fieldDataMap.put(field, new FieldData(field, qingFieldName, nextPeriodDy.get(periodField)));
                continue;
            }
            if (BEGIN_FIELD_NAME.contains(field)) {
                fieldDataMap.put(field, new FieldData(field, qingFieldName, map.get(this.getEndFieldByBegin(field)).getRawValue()));
                continue;
            }
            if (CURRENT_PERIOD_FIELD_NAME.contains(field) || YEAR_FIELD_NAME.contains(field) && crossYear) {
                fieldDataMap.put(field, new FieldData(field, qingFieldName, (Object)ZERO));
                continue;
            }
            fieldDataMap.put(field, oriFieldData);
        }
        return fieldDataMap;
    }

    private String getEndFieldByBegin(String beginField) {
        return BEGIN_TO_END_FIELD_MAP.get(beginField);
    }

    private Object getValue(Map<String, FieldData> map, String field) {
        FieldData fieldData = map.get(field);
        if (Objects.nonNull(fieldData)) {
            return fieldData.getRawValue();
        }
        throw new KDBizException("field : " + field + " not exist");
    }

    private String getFieldIdName(String fieldName) {
        return fieldName + ".id";
    }

    static {
        ZERO = new BigDecimal(BigInteger.ZERO, 10);
        HashMap<String, String> beginToEndFieldMap = new HashMap<String, String>(8);
        beginToEndFieldMap.put("beginqty", "endqty");
        beginToEndFieldMap.put("beginfor", "endfor");
        beginToEndFieldMap.put("beginlocal", "endlocal");
        BEGIN_TO_END_FIELD_MAP = Collections.unmodifiableMap(beginToEndFieldMap);
    }
}

