/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service.updatevoucher;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.service.updatevoucher.AccountReplace;
import kd.fi.gl.service.updatevoucher.UpdateVoucherParam;
import kd.fi.gl.service.updatevoucher.UpdateVoucherService;
import kd.fi.gl.util.GLUtil;

public class UpdateVoucherServiceImpl
implements UpdateVoucherService {
    private static final String SQL_VOUCHERENTRY_UPDATE = "update t_gl_voucherentry set faccountid=? ,fassgrpid=? where fentryid=? and faccountid=? and fassgrpid=?";
    private static final String SQL_VOUCHERENTRY_UPDATE_RECI = "update t_gl_voucherentry set  faccountid=? ,fassgrpid=? ,fexpiredate=? where fentryid=? and faccountid=? and fassgrpid=?";
    private static final String SQL_BALANCE_DELETE = "delete from t_gl_balance where forgid=? and fbooktypeid=?  and fperiodid>= ? and faccountid in (?";
    private static final String SQL_BALANCE_UPDATE = "update t_gl_balance set fendperiodid=99999999999 where forgid=? and fbooktypeid=?  and fperiodid<? and fendperiodid>=? and fendperiodid <> 99999999999 and faccountid in (?";
    private static final Log logger = LogFactory.getLog(UpdateVoucherServiceImpl.class);

    @Override
    public boolean updateVoucher(String accParamStr) {
        UpdateVoucherParam accParam;
        logger.info("-----------updat ebegin--------------");
        try {
            accParam = (UpdateVoucherParam)JSONUtils.cast((String)accParamStr, UpdateVoucherParam.class);
        }
        catch (Exception e) {
            throw new KDBizException(e.getCause(), new ErrorCode("", String.format(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\uff1a%s\u3002", (String)"UpdateVoucherServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0]), accParamStr)), new Object[0]);
        }
        long useOrgId = accParam.getOrg();
        QFilter masterf = new QFilter("masterid", "in", accParam.getAccountMasteridSet());
        QFilter idf = new QFilter("id", "not in", accParam.getAccountIdSet());
        HashMap<Long, HashSet<Long>> idNew2idOlds = new HashMap<Long, HashSet<Long>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{masterf, idf}, null);){
            for (Row dyn : ds) {
                Long idNew = accParam.getMaster2Id().get(dyn.getLong("masterid"));
                HashSet<Long> set = (HashSet<Long>)idNew2idOlds.get(idNew);
                if (set == null) {
                    set = new HashSet<Long>(16);
                }
                set.add(dyn.getLong("id"));
                idNew2idOlds.put(idNew, set);
            }
        }
        QFilter orgF = new QFilter("org", "=", (Object)useOrgId);
        long tableid = accParam.getAccountTable();
        QFilter tableF = new QFilter("accounttable", "=", (Object)tableid);
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype,startperiod,periodtype,startperiod.begindate", (QFilter[])new QFilter[]{orgF, tableF});
        HashMap<String, Long> accAss2assgrp = new HashMap<String, Long>(16);
        for (DynamicObject book : books) {
            Date bookStartDate = book.getDate("startperiod.begindate");
            QFilter booktypeF = new QFilter("booktype", "=", (Object)book.getLong("bookstype"));
            for (AccountReplace account : accParam.getAccounts()) {
                long accountStartPeriod = book.getLong("startperiod");
                book.getDate("startperiod.begindate");
                Map<String, Object> defaultAssgrp = account.getAssgrps();
                Date date = account.getBegindate();
                if (date.after(bookStartDate)) {
                    DynamicObject period = GLUtil.getPeriodByDate((Date)date, (long)book.getLong("periodtype"), (Boolean)false);
                    accountStartPeriod = period.getLong("id");
                }
                QFilter peridoF = new QFilter("period", ">=", (Object)accountStartPeriod);
                Set oldAccounts = (Set)idNew2idOlds.get(account.getId());
                if (oldAccounts == null || oldAccounts.size() == 0) continue;
                QFilter accountF = new QFilter("entries.account", "in", (Object)oldAccounts);
                ArrayList<Object[]> params = new ArrayList<Object[]>(1000);
                try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)"bizdate,entries.expiredate expiredate, entries.account account,entries.assgrp assgrp,entries.id entryid,entries.assgrp.value assgrpStr", (QFilter[])new QFilter[]{orgF, booktypeF, peridoF, accountF}, null);){
                    int i = 0;
                    for (Row row : queryDataSet) {
                        Object[] param;
                        ++i;
                        int j = 0;
                        if (account.isReci()) {
                            param = new Object[6];
                            ++j;
                            param[2] = row.getDate("expiredate") != null ? row.getDate("expiredate") : row.getDate("bizdate");
                        } else {
                            param = new Object[5];
                        }
                        long accountId = row.getLong("account");
                        long assgrpId = row.getLong("assgrp");
                        param[0] = account.getId();
                        param[2 + j] = row.getLong("entryid");
                        param[3 + j] = accountId;
                        param[4 + j] = assgrpId;
                        String key = this.getKey(accountId, assgrpId);
                        Long assgrpNew = (Long)accAss2assgrp.get(key);
                        HashMap<String, Object> newAssgrpMap = new HashMap<String, Object>(defaultAssgrp.size());
                        if (assgrpNew == null) {
                            if (assgrpId == 0L) {
                                for (Map.Entry<String, Object> assistEntry : defaultAssgrp.entrySet()) {
                                    Object value = assistEntry.getValue();
                                    if (value != null) {
                                        newAssgrpMap.put(assistEntry.getKey(), value);
                                    }
                                    assgrpNew = AccountRefUtils.rebuildAssgrpId(newAssgrpMap);
                                    accAss2assgrp.put(key, assgrpNew);
                                }
                            } else {
                                Map<String, Object> assgrpMap = this.getAssgrpMap(row.getString("assgrpStr"));
                                for (Map.Entry<String, Object> assistEntry : defaultAssgrp.entrySet()) {
                                    String asskey = assistEntry.getKey();
                                    Object object = assgrpMap.get(asskey);
                                    if (object == null && assistEntry.getValue() != null) {
                                        newAssgrpMap.put(asskey, assistEntry.getValue());
                                        continue;
                                    }
                                    if (object == null) continue;
                                    newAssgrpMap.put(asskey, object);
                                }
                                assgrpNew = AccountRefUtils.rebuildAssgrpId(newAssgrpMap);
                                accAss2assgrp.put(key, assgrpNew);
                            }
                        }
                        param[1] = assgrpNew;
                        params.add(param);
                        if (params.size() < 1000) continue;
                        if (account.isReci()) {
                            this.updateVoucherEbtry(SQL_VOUCHERENTRY_UPDATE_RECI, params);
                            continue;
                        }
                        this.updateVoucherEbtry(SQL_VOUCHERENTRY_UPDATE, params);
                    }
                    if (params.size() != 0) {
                        if (account.isReci()) {
                            this.updateVoucherEbtry(SQL_VOUCHERENTRY_UPDATE_RECI, params);
                        } else {
                            this.updateVoucherEbtry(SQL_VOUCHERENTRY_UPDATE, params);
                        }
                    }
                    logger.info("-----------update voucher finish--------------" + i);
                }
                HashSet<Long> accountMasterIds = new HashSet<Long>(1);
                accountMasterIds.add(account.getMasterId());
                this.reCalculate(useOrgId, book.getLong("bookstype"), accountStartPeriod, accountMasterIds, this.getAllPeriodids(useOrgId, book.getLong("bookstype"), book.getLong("periodtype"), accountStartPeriod));
                logger.info("-----------update balance finish--------------");
            }
        }
        return true;
    }

    private String getKey(Long accountId, Long assgrpId) {
        StringBuilder sb = new StringBuilder(2);
        sb.append(accountId);
        sb.append("_");
        sb.append(assgrpId);
        return sb.toString();
    }

    private Map<String, Object> getAssgrpMap(String assgrpJson) {
        HashMap<String, Object> assgrpMap = new HashMap(8);
        try {
            assgrpMap = (Map)JSONUtils.cast((String)assgrpJson, Map.class);
        }
        catch (Exception e) {
            throw new KDBizException(e.getCause(), new ErrorCode("", String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u89e3\u6790\u5931\u8d25\uff1a%s\u3002", (String)"UpdateVoucherServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0]), assgrpJson)), new Object[0]);
        }
        return assgrpMap;
    }

    private void updateVoucherEbtry(String sql, List<Object[]> params) {
        try (TXHandle x = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, params);
                params.clear();
            }
            catch (Exception ex) {
                x.markRollback();
                throw new KDBizException(ex.getCause(), new ErrorCode("", ResManager.loadKDString((String)"\u51ed\u8bc1\u66f4\u65b0\u5931\u8d25\uff1a", (String)"UpdateVoucherServiceImpl_2", (String)"fi-gl-mservice", (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    private boolean reCalculate(long orgId, long bookTypeId, long periodId, Set<Long> accountMasterIds, List<Long> periodids) {
        LockKey lockKey = LockKey.BalanceCal;
        try (TXHandle txh = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)this.getSql(SQL_BALANCE_DELETE, accountMasterIds.size()), (Object[])this.getParam(new Object[]{orgId, bookTypeId, periodId}, accountMasterIds));
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)this.getSql(SQL_BALANCE_UPDATE, accountMasterIds.size()), (Object[])this.getParam(new Object[]{orgId, bookTypeId, periodId, periodId}, accountMasterIds));
            }
            catch (Exception ex) {
                txh.markRollback();
                throw ex;
            }
        }
        return Lock.tryLock((long)orgId, (long)bookTypeId, (LockKey)lockKey, () -> {
            ICalculator calculator = CalculatorFactory.createBalanceCalculator();
            for (Long period : periodids) {
                calculator.reCalculateByAccount(orgId, bookTypeId, period.longValue(), accountMasterIds);
            }
            logger.info("-----------update balance recalculate --------------end");
        });
    }

    private Object[] getParam(Object[] params, Set<Long> accounts) {
        ArrayList<Object> paramList = new ArrayList<Object>(params.length + accounts.size());
        paramList.addAll(new ArrayList<Object>(Arrays.asList(params)));
        paramList.addAll(accounts);
        return paramList.toArray();
    }

    private String getSql(String sql, int size) {
        StringBuilder sb = new StringBuilder(sql);
        for (int i = 1; i < size; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        return sb.toString();
    }

    private List<Long> getAllPeriodids(Long orgId, Long bookTypeId, Long periodTypeId, Long startPeriodId) {
        ArrayList<Long> periodIds = new ArrayList<Long>(1);
        Long vperiodId = this.getMaxVchPeriodId(orgId, bookTypeId);
        if (vperiodId == null) {
            periodIds.add(startPeriodId);
            return periodIds;
        }
        QFilter ftypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter fid1 = new QFilter("id", ">=", (Object)startPeriodId);
        QFilter fid2 = new QFilter("id", "<=", (Object)vperiodId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fid1, fid2, ftypeId}, (String)"id");){
            for (Row row : ds) {
                periodIds.add(row.getLong("id"));
            }
        }
        return periodIds;
    }

    private Long getMaxVchPeriodId(long orgId, long btId) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select max(fperiodid) endperiod from t_gl_voucher where forgid=? and fbooktypeid=? and fbillstatus!='A'", (Object[])new Object[]{orgId, btId}, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getLong("endperiod");
                }
                return null;
            }
        });
    }
}

