/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.synvoucher;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.util.DateUtils;

public class AccountMapCache {
    private final Map<String, Map<Long, Long>> cache = new HashMap<String, Map<Long, Long>>(4);

    public Map<Long, Long> getAccountMap(long srcOrgID, long srcAcctTableID, long destOrgID, long destAcctTableID, Date useDate) {
        String useDateStr = DateUtils.formatString((Date)useDate, (String)"yyyy-MM-dd");
        String key = "" + srcOrgID + srcAcctTableID + destOrgID + destAcctTableID + useDateStr;
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(32);
        if (srcAcctTableID != destAcctTableID) {
            DynamicObject[] acMappings;
            QFilter amFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountmapping", (Long)srcOrgID);
            QFilter srcFilter = new QFilter("srcacttable", "=", (Object)srcAcctTableID);
            QFilter typeFilter = new QFilter("mappingtype", "=", (Object)Character.valueOf('0'));
            for (DynamicObject dyo : acMappings = BusinessDataServiceHelper.load((String)"bd_accountmapping", (String)"id,goalacttable.id,mappinginfoentry.id,mappinginfoentry.goalact,mappinginfoentry.goalact.id,mappinginfoentry.goalact.number,mappinginfoentry.goalact.accounttable.id,mappinginfoentry.srcact,mappinginfoentry.srcact.id,mappinginfoentry.srcact.masterid\uff0cmappinginfoentry.srcact.isleaf", (QFilter[])new QFilter[]{amFilter, srcFilter, typeFilter, new QFilter("enable", "=", (Object)Boolean.TRUE)})) {
                ArrayList<QFilter> qFilters;
                DynamicObjectCollection destTables = dyo.getDynamicObjectCollection("goalacttable");
                boolean destTableExt = false;
                for (DynamicObject destTable : destTables) {
                    if (destTable.getLong("fbasedataid_id") != destAcctTableID) continue;
                    destTableExt = true;
                    break;
                }
                if (!destTableExt) continue;
                DynamicObjectCollection entries = dyo.getDynamicObjectCollection("mappinginfoentry");
                HashMap<Long, Long> masterIdMap = new HashMap<Long, Long>(32);
                for (DynamicObject entry2 : entries) {
                    if (entry2.getLong("goalact.accounttable.id") != destAcctTableID) continue;
                    masterIdMap.put(entry2.getLong("srcact.masterid"), entry2.getLong("goalact.masterid"));
                }
                Map<String, DynamicObject> unleafSourceAccountNumberEntryRowMap = entries.stream().filter(entry -> !entry.getBoolean("srcact.isleaf")).collect(Collectors.toMap(row -> row.getString("srcact.number"), row -> row));
                if (!unleafSourceAccountNumberEntryRowMap.isEmpty()) {
                    qFilters = new ArrayList<QFilter>(10);
                    qFilters.add(new QFilter("number", "in", unleafSourceAccountNumberEntryRowMap.keySet()));
                    qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
                    qFilters.add(new QFilter("enable", "=", (Object)"1"));
                    DataSet accountDataSet = AccountUtils.queryAccountDataSet((long)srcOrgID, (long)srcAcctTableID, (String)String.join((CharSequence)",", "number", "masterid"), qFilters, null);
                    Object object = null;
                    try {
                        for (Row row2 : accountDataSet) {
                            masterIdMap.put(row2.getLong("masterid"), unleafSourceAccountNumberEntryRowMap.get(row2.getString("number")).getLong("goalact.masterid"));
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (accountDataSet != null) {
                            if (object != null) {
                                try {
                                    accountDataSet.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                accountDataSet.close();
                            }
                        }
                    }
                }
                qFilters = new ArrayList(10);
                qFilters.add(new QFilter("masterid", "in", masterIdMap.values()));
                qFilters.add(new QFilter("startdate", "<=", (Object)useDate));
                qFilters.add(new QFilter("enddate", ">=", (Object)useDate));
                qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
                HashMap<Long, Long> destAvs = new HashMap<Long, Long>(16);
                Throwable throwable = null;
                try (DataSet accountDataSet = AccountUtils.queryAccountDataSet((long)destOrgID, (long)destAcctTableID, (String)"id,number,masterid", qFilters, null);){
                    for (Row row3 : accountDataSet) {
                        destAvs.put(row3.getLong("masterid"), row3.getLong("id"));
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                for (Map.Entry entry2 : masterIdMap.entrySet()) {
                    result.put((Long)entry2.getKey(), (Long)destAvs.get(entry2.getValue()));
                }
            }
        }
        this.cache.put(key, result);
        return result;
    }
}

