/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.synvoucher;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.finalprocess.merge.EntryMergeOption;
import kd.fi.gl.synvoucher.GLVoucherEntryGroupKey;
import kd.fi.gl.synvoucher.IGetExplanation;
import kd.fi.gl.synvoucher.IGetLocalRate;
import kd.fi.gl.synvoucher.IGetPrice;
import kd.fi.gl.synvoucher.IMergeDc;
import kd.fi.gl.synvoucher.IMergeExplanation;
import kd.fi.gl.synvoucher.IMergeLocalRate;
import kd.fi.gl.synvoucher.IMergePrice;

@Deprecated
public class VoucherEntryMergeHelper {
    private IGetExplanation getExplanation;
    private IGetLocalRate getLocalExchangeRate;
    private IGetPrice getPrice;
    private IMergeExplanation mergeExplanation;
    private IMergeLocalRate mergeLocalRate;
    private IMergePrice mergePrice;
    private IMergeDc mergeDc;
    private EntryMergeOption entryMergeOption;

    public VoucherEntryMergeHelper(EntryMergeOption entryMergeOption) {
        this.entryMergeOption = entryMergeOption;
        if (entryMergeOption == null) {
            this.entryMergeOption = new EntryMergeOption();
        }
        this.buildGetExplanation();
        this.buildGetLocalExchangeRate();
        this.buildGetPrice();
        this.buildMergeExplanation();
        this.buildMergeLocalRate();
        this.buildMergePrice();
        this.buildMergeDc();
    }

    public void mergeEntries(DynamicObject voucher) {
        DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
        HashMap<GLVoucherEntryGroupKey, DynamicObject> newEntries = new HashMap<GLVoucherEntryGroupKey, DynamicObject>();
        for (DynamicObject entry : entries) {
            GLVoucherEntryGroupKey key = this.createEntryGroupKey(entry);
            if (newEntries.containsKey(key)) {
                DynamicObject oldEntry = (DynamicObject)newEntries.get(key);
                this.mergeSingleEntryRow(oldEntry, entry);
                continue;
            }
            newEntries.put(key, entry);
        }
        entries.clear();
        entries.addAll(newEntries.values());
    }

    private GLVoucherEntryGroupKey createEntryGroupKey(DynamicObject entry) {
        GLVoucherEntryGroupKey groupKey = new GLVoucherEntryGroupKey(this.getExplanation(entry), entry.getLong("account.id"), entry.getLong("assgrp.id"), entry.getLong("currency.id"), this.getLocalExchangeRate(entry), entry.getInt("entrydc"), entry.getLong("measureunit.id"), this.getPrice(entry), entry.getLong("maincfitem.id"), this.entryMergeOption);
        return groupKey;
    }

    private void mergeSingleEntryRow(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
        this.mergeExplanation(oldEntryRow, newEntryRow);
        BigDecimal oldOriDebit = oldEntryRow.getBigDecimal("debitori");
        BigDecimal oldOriCredit = oldEntryRow.getBigDecimal("creditori");
        BigDecimal oldLocalDebit = oldEntryRow.getBigDecimal("debitlocal");
        BigDecimal oldLocalCredit = oldEntryRow.getBigDecimal("creditlocal");
        BigDecimal oldMainCf = oldEntryRow.getBigDecimal("maincfamount");
        BigDecimal oldSuppCf = oldEntryRow.getBigDecimal("suppcfamount");
        BigDecimal newOriDebit = oldOriDebit.add(newEntryRow.getBigDecimal("debitori"));
        BigDecimal newOriCredit = oldOriCredit.add(newEntryRow.getBigDecimal("creditori"));
        BigDecimal newLocalDebit = oldLocalDebit.add(newEntryRow.getBigDecimal("debitlocal"));
        BigDecimal newLocalCredit = oldLocalCredit.add(newEntryRow.getBigDecimal("creditlocal"));
        BigDecimal newMainCf = oldMainCf.add(newEntryRow.getBigDecimal("maincfamount"));
        BigDecimal newSuppCf = oldSuppCf.add(newEntryRow.getBigDecimal("suppcfamount"));
        oldEntryRow.set("debitori", (Object)newOriDebit);
        oldEntryRow.set("creditori", (Object)newOriCredit);
        oldEntryRow.set("debitlocal", (Object)newLocalDebit);
        oldEntryRow.set("creditlocal", (Object)newLocalCredit);
        oldEntryRow.set("maincfamount", (Object)newMainCf);
        oldEntryRow.set("suppcfamount", (Object)newSuppCf);
        if (oldEntryRow.getInt("entrydc") == newEntryRow.getInt("entrydc")) {
            BigDecimal oldQty = oldEntryRow.getBigDecimal("quantity");
            BigDecimal newQty = oldQty.add(newEntryRow.getBigDecimal("quantity"));
            oldEntryRow.set("quantity", (Object)newQty);
        }
        this.mergeDc.merge(oldEntryRow, newEntryRow);
        this.mergeLocalRate(oldEntryRow, newEntryRow);
        this.mergePrice(oldEntryRow, newEntryRow);
    }

    private String getExplanation(DynamicObject entryRow) {
        String explanation = this.getExplanation.getValue(entryRow);
        return explanation;
    }

    private BigDecimal getLocalExchangeRate(DynamicObject entryRow) {
        BigDecimal rate = this.getLocalExchangeRate.getValue(entryRow);
        return rate;
    }

    private BigDecimal getPrice(DynamicObject entryRow) {
        BigDecimal price = this.getPrice.getValue(entryRow);
        return price;
    }

    private boolean mergeExplanation(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
        boolean mergeSuccess = this.mergeExplanation.merge(oldEntryRow, newEntryRow);
        return mergeSuccess;
    }

    private boolean mergeLocalRate(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
        boolean mergeSuccess = this.mergeLocalRate.merge(oldEntryRow, newEntryRow);
        return mergeSuccess;
    }

    private boolean mergePrice(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
        boolean mergeSuccess = this.mergePrice.merge(oldEntryRow, newEntryRow);
        return mergeSuccess;
    }

    private void buildGetExplanation() {
        this.getExplanation = this.entryMergeOption.isDescriptionMerge() ? new IGetExplanation(){

            @Override
            public String getValue(DynamicObject entryRow) {
                return "";
            }
        } : new IGetExplanation(){

            @Override
            public String getValue(DynamicObject entryRow) {
                return entryRow.getString("edescription");
            }
        };
    }

    private void buildGetLocalExchangeRate() {
        this.getLocalExchangeRate = new IGetLocalRate(){

            @Override
            public BigDecimal getValue(DynamicObject entryRow) {
                return entryRow.getBigDecimal("localrate");
            }
        };
    }

    private void buildGetPrice() {
        this.getPrice = this.entryMergeOption.isPriceMerge() ? new IGetPrice(){

            @Override
            public BigDecimal getValue(DynamicObject entryRow) {
                return new BigDecimal(Integer.toString(9999));
            }
        } : new IGetPrice(){

            @Override
            public BigDecimal getValue(DynamicObject entryRow) {
                return entryRow.getBigDecimal("price");
            }
        };
    }

    private void buildMergeExplanation() {
        if (!this.entryMergeOption.isDescriptionMerge()) {
            this.mergeExplanation = new IMergeExplanation(){

                @Override
                public boolean merge(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
                    return true;
                }
            };
            return;
        }
        this.mergeExplanation = new IMergeExplanation(){

            @Override
            public boolean merge(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
                String explanation = newEntryRow.getString("edescription");
                oldEntryRow.set("edescription", (Object)explanation);
                return true;
            }
        };
    }

    private void buildMergeLocalRate() {
        this.mergeLocalRate = new IMergeLocalRate(){

            @Override
            public boolean merge(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
                return true;
            }
        };
    }

    private void buildMergePrice() {
        if (!this.entryMergeOption.isPriceMerge()) {
            this.mergePrice = new IMergePrice(){

                @Override
                public boolean merge(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
                    return true;
                }
            };
        } else {
            final HashMap currencyMap = new HashMap();
            this.mergePrice = new IMergePrice(){

                @Override
                public boolean merge(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
                    BigDecimal oriAmount = oldEntryRow.getBigDecimal("debitori").add(oldEntryRow.getBigDecimal("creditori"));
                    BigDecimal qty = oldEntryRow.getBigDecimal("quantity");
                    if (qty.compareTo(BigDecimal.ZERO) == 0) {
                        oldEntryRow.set("price", (Object)BigDecimal.ZERO);
                    } else {
                        DynamicObject curr = (DynamicObject)currencyMap.get(oldEntryRow.getLong("currency.id"));
                        if (curr == null) {
                            curr = BusinessDataServiceHelper.loadSingleFromCache((Object)oldEntryRow.getLong("currency.id"), (String)"bd_currency", (String)"amtprecision,priceprecision");
                            currencyMap.put(oldEntryRow.getLong("currency.id"), curr);
                        }
                        BigDecimal price = oriAmount.divide(qty, curr == null ? 4 : curr.getInt("priceprecision"), RoundingMode.HALF_UP);
                        oldEntryRow.set("price", (Object)price);
                    }
                    return true;
                }
            };
        }
    }

    private void buildMergeDc() {
        this.mergeDc = !this.entryMergeOption.isDcMerge() ? new IMergeDc(){

            @Override
            public boolean merge(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
                return true;
            }
        } : new IMergeDc(){

            @Override
            public boolean merge(DynamicObject oldEntryRow, DynamicObject newEntryRow) {
                if (oldEntryRow.getInt("entrydc") != newEntryRow.getInt("entrydc")) {
                    BigDecimal oldQty = oldEntryRow.getBigDecimal("quantity");
                    BigDecimal newQty = newEntryRow.getBigDecimal("quantity");
                    BigDecimal qtyBalance = oldQty.multiply(new BigDecimal(oldEntryRow.getInt("entrydc"))).add(newQty.multiply(new BigDecimal(newEntryRow.getInt("entrydc"))));
                    if (oldEntryRow.getBigDecimal("creditori").compareTo(oldEntryRow.getBigDecimal("debitori")) > 0) {
                        oldEntryRow.set("entrydc", (Object)-1);
                        oldEntryRow.set("creditori", (Object)oldEntryRow.getBigDecimal("creditori").subtract(oldEntryRow.getBigDecimal("debitori")));
                        oldEntryRow.set("debitori", (Object)BigDecimal.ZERO);
                        oldEntryRow.set("creditlocal", (Object)oldEntryRow.getBigDecimal("creditlocal").subtract(oldEntryRow.getBigDecimal("debitlocal")));
                        oldEntryRow.set("debitlocal", (Object)BigDecimal.ZERO);
                        oldEntryRow.set("quantity", (Object)qtyBalance.negate());
                    } else {
                        oldEntryRow.set("entrydc", (Object)1);
                        oldEntryRow.set("debitori", (Object)oldEntryRow.getBigDecimal("debitori").subtract(oldEntryRow.getBigDecimal("creditori")));
                        oldEntryRow.set("creditori", (Object)BigDecimal.ZERO);
                        oldEntryRow.set("debitlocal", (Object)oldEntryRow.getBigDecimal("debitlocal").subtract(oldEntryRow.getBigDecimal("creditlocal")));
                        oldEntryRow.set("creditlocal", (Object)BigDecimal.ZERO);
                        oldEntryRow.set("quantity", (Object)qtyBalance);
                    }
                }
                return true;
            }
        };
    }
}

