/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.service.BalanceQueryParam;
import kd.fi.gl.util.FlexUtils;
import org.apache.commons.lang3.tuple.Triple;

public class AcctAndAssistHelper {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public DataSet getAssFilterAndAssDs(String sels, BalanceQueryParam param, QueryParam queryParam, Map<Long, List<Map<String, Long>>> accountAssgrp, Map<String, Object> deriveMap) {
        if (accountAssgrp == null) {
            accountAssgrp = new HashMap<Long, List<Map<String, Long>>>();
        }
        Map<String, Set<Long>> flexToIdsMap = this.collectFlexsAndVal(accountAssgrp);
        HashMap<Map<String, Long>, Set<Long>> flexsAcctIdsMap = new HashMap<Map<String, Long>, Set<Long>>();
        this.putFlexsToDsMap(accountAssgrp, flexToIdsMap, flexsAcctIdsMap);
        Tuple<Map<Set<String>, Set<Long>>, Map<Long, Set<String>>> tuple = this.getLeafAcctByFlexs(flexsAcctIdsMap, param);
        if (tuple == null) {
            return null;
        }
        Map allFlexsToLeafAcctMap = (Map)tuple.item1;
        Map idToLeafNumbersMap = (Map)tuple.item2;
        this.log.info("\u4f59\u989d\u8868\u53d6\u6570accountAssgrp\uff1a" + accountAssgrp.toString());
        this.log.info("\u4f59\u989d\u8868\u53d6\u6570flexToIdsMap\uff1a" + flexToIdsMap.toString());
        this.log.info("\u4f59\u989d\u8868\u53d6\u6570flexsAcctIdsMap\uff1a" + ((Object)flexsAcctIdsMap).toString());
        this.log.info("\u4f59\u989d\u8868\u53d6\u6570allFlexsToLeafAcctMap: " + allFlexsToLeafAcctMap.toString());
        DataSet resultSet = this.joinAssistSet(param, queryParam, sels, allFlexsToLeafAcctMap, flexsAcctIdsMap, deriveMap, flexToIdsMap, idToLeafNumbersMap);
        return resultSet;
    }

    private DataSet joinAssistSet(BalanceQueryParam param, QueryParam queryParam, String sels, Map<Set<String>, Set<Long>> allFlexsToLeafAcctMap, Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap, Map<String, Object> deriveMap, Map<String, Set<Long>> flexToIdsMap, Map<Long, Set<String>> idToLeafNumbersMap) {
        Set<String> allFlexs = flexToIdsMap.keySet();
        DataSet resultSet = null;
        List resultList = new ArrayList();
        boolean specialAccount = queryParam.isSpecialAccount();
        String acctKey = (String)deriveMap.get("aliasAcct");
        for (Map.Entry<Set<String>, Set<Long>> allFlexEntry : allFlexsToLeafAcctMap.entrySet()) {
            Set<String> allFlexsSet = allFlexEntry.getKey();
            Set<Long> leafAcctSet = allFlexEntry.getValue();
            queryParam.setAccountFilter(new QFilter("id", "in", leafAcctSet));
            queryParam.setSpecialAccount(false);
            queryParam.setOnlyLeafAcctBal(false);
            DataSet balanceSet = this.queryBalance(param, sels, queryParam, allFlexsSet);
            List balList = ReportUtils.getSetField((DataSet)balanceSet);
            for (Map.Entry<Map<String, Long>, Set<Long>> entry : flexsAcctIdsMap.entrySet()) {
                DataSet assistBalSet;
                Map<String, Long> flexMap = entry.getKey();
                Set<Long> acctIds = entry.getValue();
                Set<String> flexs = flexMap.keySet();
                if (!allFlexsSet.equals(flexs) || acctIds == null || acctIds.isEmpty()) continue;
                HashMap<String, Object> acctMap = new HashMap<String, Object>();
                if (!specialAccount && balList.contains("number")) {
                    HashSet acctSet = new HashSet(128);
                    HashSet hashSet = new HashSet(128);
                    acctIds.stream().forEach(x -> leafAcctIds.addAll((Collection)idToLeafNumbersMap.get(x)));
                    acctSet.addAll(hashSet);
                    acctMap.put("acctIds", acctSet);
                    assistBalSet = balanceSet.filter("number in acctIds", acctMap);
                } else {
                    acctMap.put("acctIds", acctIds);
                    assistBalSet = balanceSet.filter(acctKey + " in acctIds", acctMap);
                }
                if (flexMap.isEmpty()) {
                    assistBalSet = assistBalSet.addNullField(allFlexs.toArray(new String[0]));
                } else {
                    for (Map.Entry entry2 : flexMap.entrySet()) {
                        String flex = (String)entry2.getKey();
                        if (entry2.getValue() == null) continue;
                        assistBalSet = assistBalSet.filter(flex + "=" + entry2.getValue());
                    }
                    ArrayList<String> selNull = new ArrayList<String>(balList.size() + flexs.size());
                    selNull.addAll(balList);
                    for (String flex : flexs) {
                        selNull.removeIf(x -> flex.equals(x));
                        selNull.add("case when " + flex + "=null then 0L else " + flex + " end as " + flex);
                    }
                    assistBalSet = assistBalSet.select(selNull.toArray(new String[0]));
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(allFlexs);
                    arrayList.removeAll(flexs);
                    assistBalSet = assistBalSet.addNullField(arrayList.toArray(new String[0]));
                }
                if (resultSet != null) {
                    if (resultList.isEmpty()) {
                        resultList = ReportUtils.getSetField((DataSet)resultSet);
                    }
                    assistBalSet = assistBalSet.select(resultList.toArray(new String[0]));
                    resultSet = resultSet.union(assistBalSet);
                    continue;
                }
                resultSet = assistBalSet;
            }
        }
        return resultSet;
    }

    private DataSet queryBalance(BalanceQueryParam param, String sels, QueryParam queryParam, Set<String> allFlexSet) {
        String selBal = sels;
        if (!allFlexSet.isEmpty()) {
            ArrayList<String> flexList = new ArrayList<String>(allFlexSet.size());
            flexList.addAll(allFlexSet);
            Triple entityTriple = FlexUtils.buildDynamicORMAssistOnBalance(flexList, (String)"gl_balance", (boolean)true);
            queryParam.setBalEntityType((MainEntityType)entityTriple.getLeft());
            ArrayList customFiter = new ArrayList(flexList.size());
            customFiter.addAll((Collection)entityTriple.getMiddle());
            queryParam.setCustomFilter(customFiter);
            selBal = selBal + "," + Joiner.on((String)",").join((Iterable)entityTriple.getRight());
        }
        DataSet balanceSet = param.getOrgIds() != null && param.getOrgIds().length > 0 ? BalanceQueryExecutor.getInstance().getBalance(selBal, this.toLongArray(param.getOrgIds()), param.getBookTypeId(), param.getAccountTableId(), param.getPeriodId(), param.getPeriodId(), queryParam) : BalanceQueryExecutor.getInstance().getBalance(selBal, new Long[]{param.getOrgId()}, param.getBookTypeId(), param.getAccountTableId(), param.getPeriodId(), param.getPeriodId(), queryParam);
        return balanceSet;
    }

    public Long[] toLongArray(long[] values) {
        Long[] value = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            value[i] = values[i];
        }
        return value;
    }

    private Map<String, Set<Long>> collectFlexsAndVal(Map<Long, List<Map<String, Long>>> accountAssgrp) {
        HashMap<String, Set<Long>> flexToIdsMap = new HashMap<String, Set<Long>>();
        for (Map.Entry<Long, List<Map<String, Long>>> entry : accountAssgrp.entrySet()) {
            List<Map<String, Long>> listFlexs = entry.getValue();
            if (listFlexs == null) continue;
            for (Map<String, Long> map : listFlexs) {
                for (Map.Entry<String, Long> entryFlex : map.entrySet()) {
                    String flex = entryFlex.getKey();
                    if (flexToIdsMap.get(flex) == null) {
                        HashSet<Long> ids = new HashSet<Long>();
                        if (entryFlex.getValue() != null && entryFlex.getValue() != 0L) {
                            ids.add(entryFlex.getValue());
                        }
                        flexToIdsMap.put(flex, ids);
                        continue;
                    }
                    if (((Set)flexToIdsMap.get(flex)).isEmpty()) continue;
                    if (entryFlex.getValue() != null && entryFlex.getValue() != 0L) {
                        ((Set)flexToIdsMap.get(flex)).add(entryFlex.getValue());
                        continue;
                    }
                    flexToIdsMap.put(flex, new HashSet());
                }
            }
        }
        return flexToIdsMap;
    }

    private Map<Set<String>, Set<Long>> flexsToAcct(Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap) {
        HashMap<Set<String>, Set<Long>> flexsToAcctMap = new HashMap<Set<String>, Set<Long>>();
        for (Map.Entry<Map<String, Long>, Set<Long>> entry : flexsAcctIdsMap.entrySet()) {
            Set<String> flexs = entry.getKey().keySet();
            Set acctIds = flexsToAcctMap.computeIfAbsent(flexs, x -> new HashSet());
            acctIds.addAll((Collection)entry.getValue());
        }
        return flexsToAcctMap;
    }

    private Tuple<Map<Set<String>, Set<Long>>, Map<Long, Set<String>>> getLeafAcctByFlexs(Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap, BalanceQueryParam param) {
        if (flexsAcctIdsMap.isEmpty()) {
            return null;
        }
        long[] orgIds = param.getOrgIds() != null && param.getOrgIds().length > 0 ? param.getOrgIds() : new long[]{param.getOrgId()};
        Map<Set<String>, Set<Long>> flexsToAcctMap = this.flexsToAcct(flexsAcctIdsMap);
        HashSet allFlexs = new HashSet();
        HashSet<Long> allAcctIds = new HashSet<Long>();
        for (Map.Entry<Set<String>, Set<Long>> entry : flexsToAcctMap.entrySet()) {
            allFlexs.addAll(entry.getKey());
            allAcctIds.addAll((Collection)entry.getValue());
        }
        DynamicObjectCollection acttypeColl = QueryServiceHelper.query((String)"bd_asstacttype", (String)"id,flexfield", (QFilter[])new QFilter("flexfield", "in", allFlexs).toArray());
        HashMap<String, Long> typeMap = new HashMap<String, Long>(8);
        for (DynamicObject acttype : acttypeColl) {
            typeMap.put(acttype.getString("flexfield"), acttype.getLong("id"));
        }
        Map<String, Long> numberToIdMap = this.queryNumberById(allAcctIds);
        HashMap<Long, Set> idToLeafNumbersMap = new HashMap<Long, Set>(8);
        HashMap<Long, Set<Long>> idToLeafIdsMap = new HashMap<Long, Set<Long>>(8);
        for (long orgId : orgIds) {
            long keyId;
            Tuple<Map<Long, Set<String>>, Map<Long, Set<Long>>> tuple = this.queryAcctAllLeaf(orgId, param.getAccountTableId(), numberToIdMap);
            Map idToLeafNumbersByOrgMap = (Map)tuple.item1;
            Map idToLeafIdsByOrgMap = (Map)tuple.item2;
            for (Map.Entry entry : idToLeafNumbersByOrgMap.entrySet()) {
                keyId = (Long)entry.getKey();
                Set valNumbers = (Set)entry.getValue();
                Set leafNumberSet = idToLeafNumbersMap.computeIfAbsent(keyId, x -> new HashSet(8));
                leafNumberSet.addAll(valNumbers);
            }
            for (Map.Entry entry : idToLeafIdsByOrgMap.entrySet()) {
                keyId = (Long)entry.getKey();
                Set valIds = (Set)entry.getValue();
                Set leafIdSet = idToLeafIdsMap.computeIfAbsent(keyId, x -> new HashSet(8));
                leafIdSet.addAll(valIds);
            }
        }
        Object object = allAcctIds.iterator();
        while (object.hasNext()) {
            long acctId = (Long)object.next();
            Set allLeafAcctIds = idToLeafIdsMap.computeIfAbsent(acctId, x -> new HashSet());
            if (!allLeafAcctIds.isEmpty()) continue;
            allLeafAcctIds.add(acctId);
        }
        Map<Set<String>, Set<Long>> flexsToLeafAcctMap = this.dbFlexs(flexsToAcctMap, idToLeafIdsMap, typeMap);
        Tuple tuple = new Tuple(flexsToLeafAcctMap, idToLeafNumbersMap);
        return tuple;
    }

    private Map<String, Long> queryNumberById(Set<Long> acctSet) {
        HashMap<String, Long> acctNumberToIdMap = new HashMap<String, Long>(128);
        DataSet acctDataSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, number, longnumber", new QFilter[]{new QFilter("id", "in", acctSet)});
        for (Row row : acctDataSet) {
            acctNumberToIdMap.put(row.getString("number"), row.getLong("id"));
        }
        return acctNumberToIdMap;
    }

    private Tuple<Map<Long, Set<String>>, Map<Long, Set<Long>>> queryAcctAllLeaf(long orgId, long accountTableId, Map<String, Long> acctNumberToIdMap) {
        HashMap<Long, Set> idToAllLeafNumbersMap = new HashMap<Long, Set>(128);
        HashMap<Long, Set> idToAllLeafIdsMap = new HashMap<Long, Set>(128);
        Tuple tuple = new Tuple(idToAllLeafNumbersMap, idToAllLeafIdsMap);
        DataSet leafAcctSet = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)"id, masterid, number, longnumber", null);
        for (Row row : leafAcctSet) {
            String[] split;
            String longNumber = row.getString("longnumber");
            for (String number : split = longNumber.split("_")) {
                if (acctNumberToIdMap.get(number) == null) continue;
                long acctId = acctNumberToIdMap.get(number);
                Set leafNumberSet = idToAllLeafNumbersMap.computeIfAbsent(acctId, x -> new HashSet(128));
                Set leafIdSet = idToAllLeafIdsMap.computeIfAbsent(acctId, x -> new HashSet(128));
                leafNumberSet.add(row.getString("number"));
                leafIdSet.add(row.getLong("id"));
            }
        }
        return tuple;
    }

    private Map<Set<String>, Set<Long>> dbFlexs(Map<Set<String>, Set<Long>> flexsToAcctMap, Map<Long, Set<Long>> idToLeafMap, Map<String, Long> typeMap) {
        HashMap<Set<String>, Set<Long>> flexsToLeafAcctMap = new HashMap<Set<String>, Set<Long>>(flexsToAcctMap.size());
        for (Map.Entry<Set<String>, Set<Long>> entry : flexsToAcctMap.entrySet()) {
            HashSet leafAcctIds = new HashSet();
            Set<Long> acctIds = entry.getValue();
            for (Long acctId : acctIds) {
                leafAcctIds.addAll(idToLeafMap.get(acctId));
            }
            Set<String> flexs = entry.getKey();
            StringBuilder sql = new StringBuilder();
            sql.append("select a.fid from T_BD_Account a ");
            StringBuffer where = new StringBuffer();
            ArrayList<Long> sp = new ArrayList<Long>(32);
            where.append(" WHERE a.fid in (");
            for (Long acctId : leafAcctIds) {
                where.append("?,");
                sp.add(acctId);
            }
            where = where.deleteCharAt(where.length() - 1);
            where.append(')');
            HashSet<Long> flexAcctIds = new HashSet<Long>(32);
            int i = 1;
            for (String s : flexs) {
                sql.append(" INNER JOIN T_BD_AccountAsstActItem a").append(i).append(" ON a.fid=a").append(i).append(".fid");
                where.append(" and a").append(i).append(".fasstactitemid = ? ");
                sp.add(typeMap.get(s));
                ++i;
            }
            try (DataSet dataSet = this.queryDataSetMethod(this.getClass().getName(), DBRoute.of((String)"gl"), sql.append(where).toString(), sp.toArray());){
                while (dataSet.hasNext()) {
                    flexAcctIds.add(dataSet.next().getLong("fid"));
                }
            }
            flexsToLeafAcctMap.put(flexs, flexAcctIds);
        }
        return flexsToLeafAcctMap;
    }

    private DataSet queryDataSetMethod(String name, DBRoute gl, String toString, Object[] toArray) {
        return DB.queryDataSet((String)name, (DBRoute)gl, (String)toString, (Object[])toArray);
    }

    private void getAcctLeaf(Set<Long> acctIds, Map<Long, Set<String>> idToLeafMap, long orgId) {
        HashSet<Long> allAcctIds = new HashSet<Long>();
        allAcctIds.addAll(acctIds);
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        this.getMidAndNumByAcctId(allAcctIds, numberToIdMap);
        HashMap<Long, Set<Long>> pIdToIdMap = new HashMap<Long, Set<Long>>(allAcctIds.size());
        Iterator iterator = allAcctIds.iterator();
        while (iterator.hasNext()) {
            long acctId = (Long)iterator.next();
            HashSet<Long> idSet = new HashSet<Long>();
            idSet.add(acctId);
            pIdToIdMap.put(acctId, idSet);
        }
        this.queryAcctAllLeaf(allAcctIds, pIdToIdMap, idToLeafMap, 0);
        QFilter fbasedata = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
    }

    private void getMidAndNumByAcctId(Set<Long> acctIds, Map<String, Long> numberToIdMap) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, number", new QFilter[]{new QFilter("id", "in", acctIds)});
        HashSet<String> numberSet = new HashSet<String>(128);
        for (Row row : acctSet) {
            long masterId = row.getLong("masterid");
            String number = row.getString("number");
            numberToIdMap.put(number, row.getLong("id"));
            numberSet.add(number);
            acctIds.add(masterId);
        }
        DataSet numebrAcctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id,number,masterid", new QFilter[]{new QFilter("number", "in", numberSet)});
        for (Row row : numebrAcctSet) {
            numberToIdMap.putIfAbsent(row.getString("number"), row.getLong("id"));
            acctIds.add(row.getLong("id"));
        }
    }

    private void queryAcctAllLeaf(Set<Long> acctIds, Map<Long, Set<Long>> leafIdsToAcctIdsMap, Map<Long, Set<String>> idToAllLeafMap, int isRepeatIndex) {
        try (DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id,number, masterid, parent, isleaf", new QFilter[]{new QFilter("parent", "in", acctIds)});){
            acctIds.clear();
            for (Row row : acctSet) {
                long pid = row.getLong("parent");
                long id = row.getLong("id");
                long masterId = row.getLong("masterid");
                String number = row.getString("number");
                Set<Long> acctIdSet = leafIdsToAcctIdsMap.get(pid);
                boolean isLeaf = row.getBoolean("isleaf");
                for (Long acctId : acctIdSet) {
                    Set allLeaf = idToAllLeafMap.computeIfAbsent(acctId, x -> new HashSet(8));
                    allLeaf.add(number);
                    idToAllLeafMap.put(acctId, allLeaf);
                }
                if (isLeaf) continue;
                acctIds.add(id);
                acctIds.add(masterId);
                HashSet<Long> idSet = leafIdsToAcctIdsMap.get(id) == null ? new HashSet<Long>() : leafIdsToAcctIdsMap.get(id);
                idSet.addAll(acctIdSet);
                leafIdsToAcctIdsMap.put(id, idSet);
                leafIdsToAcctIdsMap.put(masterId, idSet);
            }
            if (!acctIds.isEmpty()) {
                if (isRepeatIndex > 1000) {
                    return;
                }
                this.queryAcctAllLeaf(acctIds, leafIdsToAcctIdsMap, idToAllLeafMap, ++isRepeatIndex);
            }
        }
    }

    private DataSet queryDataSet(String algoKey, String entityId, String sel, QFilter[] filters) {
        DataSet assistSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityId, (String)sel, (QFilter[])filters, null);
        return assistSet;
    }

    private void putFlexsToDsMap(Map<Long, List<Map<String, Long>>> accountAssgrp, Map<String, Set<Long>> flexToIdsMap, Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap) {
        for (Map.Entry<Long, List<Map<String, Long>>> entry : accountAssgrp.entrySet()) {
            long acctId = entry.getKey();
            List<Map<String, Long>> mapList = entry.getValue();
            if (mapList == null || mapList.isEmpty()) {
                HashMap<String, Long> flexMap = new HashMap<String, Long>();
                this.putFlexToAcct(flexsAcctIdsMap, flexMap, acctId);
                continue;
            }
            for (Map<String, Long> singFlexs : mapList) {
                if (singFlexs == null || singFlexs.isEmpty()) {
                    HashMap<String, Long> flexMap = new HashMap<String, Long>();
                    this.putFlexToAcct(flexsAcctIdsMap, flexMap, acctId);
                    continue;
                }
                this.putFlexToAcct(flexsAcctIdsMap, singFlexs, acctId);
            }
            if (flexsAcctIdsMap.size() <= 200) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7ef4\u5ea6\u7ec4\u5408\u6700\u591a\u4e3a200\u79cd\u3002", (String)"AcctAndAssistHelper_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
    }

    private void putFlexToAcct(Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap, Map<String, Long> flexMap, long acctId) {
        Set<Object> acctIds = flexsAcctIdsMap.get(flexMap) == null ? new HashSet() : flexsAcctIdsMap.get(flexMap);
        acctIds.add(acctId);
        flexsAcctIdsMap.put(flexMap, acctIds);
    }

    private Map<String, DataSet> putFlexToDSMap(Map<String, Set<Long>> flexToIdsMap) {
        HashMap<String, DataSet> flexToDSMap = new HashMap<String, DataSet>(flexToIdsMap.size());
        for (Map.Entry<String, Set<Long>> entry : flexToIdsMap.entrySet()) {
            String flex = entry.getKey();
            Set<Long> assVals = entry.getValue();
            String selectFields = "hg id, assval " + flex;
            QFilter fasstype = new QFilter("asstype", "=", (Object)flex);
            QFilter fassval = null;
            if (!assVals.isEmpty()) {
                fassval = new QFilter("assval", "in", assVals);
            }
            DataSet assValSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_assist_bd", (String)selectFields, (QFilter[])fasstype.and(fassval).toArray(), null);
            flexToDSMap.put(flex, assValSet);
        }
        return flexToDSMap;
    }
}

