/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheType;

public class AssistMulValLocalCacheHelper {
    private static int ACCT_ASSISTMULVAL_CACHE_COUNT = Integer.parseInt(System.getProperty("fi.gl.acct_assistmulval_cache_count", "100"));
    private static int ACCT_ASSISTMULVAL_CLEAR_COUNT = 100000;
    private static int ACCT_ASSISTMULVAL_CLEAR_TIMEOUT = 300;
    private static int ACCT_FLOAT_BATCH_COUNT = 1000;
    private static final String GL = "gl";

    private static Map<String, Map<String, Long>> getLocalCacheMap(CacheKey cacheKey) {
        CacheConfigInfo cacheConfigInfo = AssistMulValLocalCacheHelper.getCacheConfigInfo();
        LocalMemoryCache localCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), GL, cacheConfigInfo);
        Object cacheObj = localCache.get(cacheKey.toString());
        return cacheObj == null ? new HashMap(0) : (Map)cacheObj;
    }

    private static void putLocalCacheMap(CacheKey cacheKey, Map<String, Map<String, Long>> cacheAssistNumberValMap) {
        CacheConfigInfo cacheConfigInfo = AssistMulValLocalCacheHelper.getCacheConfigInfo();
        LocalMemoryCache localCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), GL, cacheConfigInfo);
        localCache.put(cacheKey.toString(), cacheAssistNumberValMap);
    }

    private static CacheConfigInfo getCacheConfigInfo() {
        CacheConfigInfo cacheConfigInfo = new CacheConfigInfo();
        cacheConfigInfo.setMaxItemSize(ACCT_ASSISTMULVAL_CLEAR_COUNT);
        cacheConfigInfo.setTimeout(ACCT_ASSISTMULVAL_CLEAR_TIMEOUT);
        cacheConfigInfo.setTimeToLive(LocalCacheType.TIME_TO_IDLE.getTimeToLive());
        return cacheConfigInfo;
    }

    public static Map<String, Long> queryAssistMulVals(String entityName, long orgId, Set<String> valNumbers, List<QFilter> filters) {
        if (CollectionUtils.isEmpty(valNumbers)) {
            return new HashMap<String, Long>(2);
        }
        Tuple<Map<String, Long>, Set<String>> cacheTuple = AssistMulValLocalCacheHelper.getCacheNumberToMId(entityName, valNumbers, filters);
        Map matchNumberMateridMap = (Map)cacheTuple.item1;
        Set unMatchNumberSet = (Set)cacheTuple.item2;
        if (unMatchNumberSet.size() > 0) {
            Map<String, Long> orgNumberMIdMap = AssistMulValLocalCacheHelper.queryNumberByOrg(orgId, entityName, unMatchNumberSet, filters);
            matchNumberMateridMap.putAll(orgNumberMIdMap);
        }
        return matchNumberMateridMap;
    }

    private static Tuple<Map<String, Long>, Set<String>> getCacheNumberToMId(String entityName, Set<String> valNumbers, List<QFilter> filters) {
        Object resultMatchTuple;
        CacheKey cacheKey = CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.ACCT_FLOAT_ASSSIST_VALUE, (Object[])new Object[0]);
        Map<String, Map<String, Long>> cacheAssistNumberValMap = AssistMulValLocalCacheHelper.getLocalCacheMap(cacheKey);
        if (cacheAssistNumberValMap != null) {
            Map<String, Long> cacheNumberValMap = cacheAssistNumberValMap.get(entityName);
            resultMatchTuple = cacheNumberValMap == null ? AssistMulValLocalCacheHelper.newCacheNumberMasterMap(cacheAssistNumberValMap, cacheKey, entityName, valNumbers, filters) : (cacheNumberValMap.size() > 0 ? AssistMulValLocalCacheHelper.updateCacheNumberMasterMap(cacheAssistNumberValMap, cacheKey, entityName, cacheNumberValMap, valNumbers, filters) : new Tuple(new HashMap(0), valNumbers));
        } else {
            cacheAssistNumberValMap = new HashMap<String, Map<String, Long>>(8);
            resultMatchTuple = AssistMulValLocalCacheHelper.newCacheNumberMasterMap(cacheAssistNumberValMap, cacheKey, entityName, valNumbers, filters);
        }
        return resultMatchTuple;
    }

    private static Tuple<Map<String, Long>, Set<String>> updateCacheNumberMasterMap(Map<String, Map<String, Long>> cacheAssistNumberValMap, CacheKey cacheKey, String entityName, Map<String, Long> cacheNumberValMap, Set<String> valNumbers, List<QFilter> filters) {
        Tuple<Map<String, Long>, Set<String>> unMatchTuple = AssistMulValLocalCacheHelper.matchCacheNumberToMId(cacheNumberValMap, valNumbers);
        Tuple<Map<String, Long>, Set<String>> cacheTuple = AssistMulValLocalCacheHelper.updateCacheNumberMIdScheme(cacheAssistNumberValMap, cacheKey, entityName, unMatchTuple, filters);
        return cacheTuple;
    }

    private static Tuple<Map<String, Long>, Set<String>> newCacheNumberMasterMap(Map<String, Map<String, Long>> cacheAssistNumberValMap, CacheKey cacheKey, String entityName, Set<String> valNumbers, List<QFilter> filters) {
        Tuple<Map<String, Long>, Set<String>> matchCacheTuple = AssistMulValLocalCacheHelper.queryValNumbers(entityName, valNumbers, filters);
        AssistMulValLocalCacheHelper.newCacheNumberMIdScheme(cacheAssistNumberValMap, cacheKey, entityName, matchCacheTuple);
        return matchCacheTuple;
    }

    private static void newCacheNumberMIdScheme(Map<String, Map<String, Long>> cacheAssistNumberValMap, CacheKey cacheKey, String entityName, Tuple<Map<String, Long>, Set<String>> cacheTuple) {
        Map cacheNumberValMap = (Map)cacheTuple.item1;
        Set unMatchNumberSet = (Set)cacheTuple.item2;
        if (!AssistMulValLocalCacheHelper.isLargeMaxCacheCount(unMatchNumberSet)) {
            cacheAssistNumberValMap.put(entityName, cacheNumberValMap);
            AssistMulValLocalCacheHelper.putLocalCacheMap(cacheKey, cacheAssistNumberValMap);
        }
    }

    private static Tuple<Map<String, Long>, Set<String>> updateCacheNumberMIdScheme(Map<String, Map<String, Long>> cacheAssistNumberValMap, CacheKey cacheKey, String entityName, Tuple<Map<String, Long>, Set<String>> unMatchTuple, List<QFilter> filters) {
        Map matchCacheNumberValMap = (Map)unMatchTuple.item1;
        Set unMatchCacheNumberSet = (Set)unMatchTuple.item2;
        HashSet<String> unMatchNumberSet = new HashSet<String>(64);
        Tuple resultCacheTuple = new Tuple((Object)matchCacheNumberValMap, unMatchNumberSet);
        if (AssistMulValLocalCacheHelper.isLargeMaxCacheCount(unMatchCacheNumberSet)) {
            Tuple<Map<String, Long>, Set<String>> updateUnMatchTuple = AssistMulValLocalCacheHelper.queryValNumbers(entityName, unMatchCacheNumberSet, filters);
            Map updateCacheNumberValMap = (Map)updateUnMatchTuple.item1;
            Set updateUnMatchSet = (Set)updateUnMatchTuple.item2;
            matchCacheNumberValMap.putAll(updateCacheNumberValMap);
            unMatchNumberSet.addAll(updateUnMatchSet);
            if (!AssistMulValLocalCacheHelper.isLargeMaxCacheCount(unMatchNumberSet)) {
                Map<String, Long> cacheNumberValMap = cacheAssistNumberValMap.get(entityName);
                cacheNumberValMap.putAll(updateCacheNumberValMap);
                cacheAssistNumberValMap.put(entityName, cacheNumberValMap);
                AssistMulValLocalCacheHelper.putLocalCacheMap(cacheKey, cacheAssistNumberValMap);
            } else {
                cacheAssistNumberValMap.put(entityName, new HashMap(0));
                AssistMulValLocalCacheHelper.putLocalCacheMap(cacheKey, cacheAssistNumberValMap);
            }
        } else {
            unMatchNumberSet.addAll(unMatchCacheNumberSet);
        }
        return resultCacheTuple;
    }

    private static Tuple<Map<String, Long>, Set<String>> matchCacheNumberToMId(Map<String, Long> cacheNumberValMap, Set<String> valNumbers) {
        HashMap<String, Long> numberToMidMap = new HashMap<String, Long>(1024);
        HashSet<String> unMatchNumberSet = new HashSet<String>(8);
        for (String number : valNumbers) {
            Long masterId = cacheNumberValMap.get(number);
            if (masterId == null) {
                unMatchNumberSet.add(number);
                continue;
            }
            numberToMidMap.put(number, masterId);
        }
        return new Tuple(numberToMidMap, unMatchNumberSet);
    }

    private static Tuple<Map<String, Long>, Set<String>> queryValNumbers(String entityName, Set<String> valNumbers, List<QFilter> filters) {
        Tuple<String, String> tupleKey = AssistMulValLocalCacheHelper.getNumberMasteridKey(entityName);
        String numberKey = (String)tupleKey.item1;
        String masteridKey = (String)tupleKey.item2;
        HashSet<String> unMatchNumberSet = new HashSet<String>(128);
        HashMap<String, Long> valNumberToMasterMap = new HashMap<String, Long>(128);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        ArrayList<String> queryNumbers = new ArrayList<String>(1024);
        for (String valNum : valNumbers) {
            queryNumbers.add(valNum);
            if (queryNumbers.size() < ACCT_FLOAT_BATCH_COUNT) continue;
            qFilters.addAll(filters);
            qFilters.add(new QFilter(numberKey, "in", queryNumbers));
            DataSet numberSet = AssistMulValLocalCacheHelper.queryDataSet(qFilters.toArray(new QFilter[2]), entityName, numberKey + "," + masteridKey);
            queryNumbers.clear();
            qFilters.clear();
            unMatchNumberSet.addAll(AssistMulValLocalCacheHelper.matchDataSetSingleMId(numberSet, numberKey, masteridKey, valNumberToMasterMap));
        }
        if (queryNumbers.size() > 0) {
            qFilters.addAll(filters);
            qFilters.add(new QFilter(numberKey, "in", queryNumbers));
            DataSet numberSet = AssistMulValLocalCacheHelper.queryDataSet(qFilters.toArray(new QFilter[2]), entityName, numberKey + "," + masteridKey);
            unMatchNumberSet.addAll(AssistMulValLocalCacheHelper.matchDataSetSingleMId(numberSet, numberKey, masteridKey, valNumberToMasterMap));
        }
        Tuple cacheTuple = new Tuple(valNumberToMasterMap, unMatchNumberSet);
        return cacheTuple;
    }

    private static Tuple<String, String> getNumberMasteridKey(String entityName) {
        String numberKey = "number";
        String masteridKey = "masterid";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (mainEntityType instanceof BasedataEntityType) {
            numberKey = ((BasedataEntityType)mainEntityType).getNumberProperty();
            DynamicProperty masterid = mainEntityType.getProperty("masterid");
            masteridKey = Objects.nonNull(masterid) && Objects.nonNull(masterid.getAlias()) ? masteridKey : "id";
        }
        return new Tuple((Object)numberKey, (Object)masteridKey);
    }

    private static Map<String, Long> queryNumberByOrg(long orgId, String entityName, Set<String> versionNumberSet, List<QFilter> filters) {
        HashMap<String, Long> numberMIdMap = new HashMap<String, Long>(1024);
        Tuple<String, String> tupleKey = AssistMulValLocalCacheHelper.getNumberMasteridKey(entityName);
        String numberKey = (String)tupleKey.item1;
        String masteridKey = (String)tupleKey.item2;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        QFilter baseQfilter = null;
        if (orgId != 0L) {
            baseQfilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)orgId);
        }
        ArrayList<String> queryNumbers = new ArrayList<String>(1024);
        for (String valNum : versionNumberSet) {
            queryNumbers.add(valNum);
            if (queryNumbers.size() < ACCT_FLOAT_BATCH_COUNT) continue;
            if (baseQfilter != null) {
                qFilters.add(baseQfilter.copy());
            }
            qFilters.addAll(filters);
            qFilters.add(new QFilter(numberKey, "in", queryNumbers));
            DataSet numberSet = AssistMulValLocalCacheHelper.queryDataSet(qFilters.toArray(new QFilter[2]), entityName, numberKey + "," + masteridKey);
            for (Row row : numberSet) {
                numberMIdMap.put(row.getString(numberKey), row.getLong(masteridKey));
            }
            qFilters.clear();
            queryNumbers.clear();
        }
        if (queryNumbers.size() > 0) {
            if (baseQfilter != null) {
                qFilters.add(baseQfilter.copy());
            }
            qFilters.addAll(filters);
            qFilters.add(new QFilter(numberKey, "in", queryNumbers));
            DataSet numberSet = AssistMulValLocalCacheHelper.queryDataSet(qFilters.toArray(new QFilter[2]), entityName, numberKey + "," + masteridKey);
            for (Row row : numberSet) {
                numberMIdMap.put(row.getString(numberKey), row.getLong(masteridKey));
            }
        }
        return numberMIdMap;
    }

    private static boolean isLargeMaxCacheCount(Set<String> unMatchNumberSet) {
        return unMatchNumberSet.size() > ACCT_ASSISTMULVAL_CACHE_COUNT;
    }

    private static Set<String> matchDataSetSingleMId(DataSet dataSet, String numberKey, String masteridKey, Map<String, Long> cacheValNumberToMasterMap) {
        HashSet<String> unMatchNumberSet = new HashSet<String>(1024);
        for (Row row : dataSet) {
            String number = row.getString(numberKey);
            Long masterid = row.getLong(masteridKey);
            Long mid = cacheValNumberToMasterMap.get(number);
            if (mid == null) {
                cacheValNumberToMasterMap.put(number, masterid);
                continue;
            }
            if (!mid.equals(masterid)) continue;
            unMatchNumberSet.add(number);
        }
        unMatchNumberSet.forEach(x -> {
            Long cfr_ignored_0 = (Long)cacheValNumberToMasterMap.remove(x);
        });
        return unMatchNumberSet;
    }

    private static DataSet queryDataSet(QFilter[] qFilters, String entityName, String selector) {
        return QueryServiceHelper.queryDataSet((String)"AssistMulValLocalCacheHelper", (String)entityName, (String)selector, (QFilter[])qFilters, null);
    }
}

