/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.AssitQuickSearchDs;
import kd.fi.gl.util.ReClassParam;
import kd.fi.gl.util.ReClassUtils;

public class ReClassNumberIDParam {
    private static final String ASSISTBD = "gl_assist_bd";
    private static final String ASSISTTXT = "gl_assist_txt";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private static final String FLEXFIELD = "flexfield";
    private static final String VALUETYPE = "valuetype";
    private Set<String> orgNumberSet = new HashSet<String>();
    private Set<String> bookTypeNumberSet = new HashSet<String>();
    private Set<String> currencyNumberSet = new HashSet<String>();
    private Set<String> periodNumberSet = new HashSet<String>();
    private Map<String, String> errorInfoMap = new HashMap<String, String>();
    private Set<String> acctNumberSet = new HashSet<String>();
    private Set<String> acctRangeNumberSet = new HashSet<String>();
    private Map<String, Set<String>> assistToValNumbersMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> assistToValRangeNumbersMap = new HashMap<String, Set<String>>();
    private Map<String, Long> orgNumberToIdsMap;
    private Map<String, Long> bookTypeNumberToIdsMap;
    private Map<String, Long> currencyNumberToIdsMap;
    private Map<String, Long> periodIdsMap = new HashMap<String, Long>();
    private Map<String, Long> acctNumberToIdsMap = new HashMap<String, Long>();
    private Map<String, String> acctNumberToDcMap = new HashMap<String, String>();
    private Map<String, Set<Long>> acctRangeKeyToIdsMap = new HashMap<String, Set<Long>>();
    private Map<String, String> acctRangeKeyToDcMap = new HashMap<String, String>();
    private Map<Long, Long> acctIdToMasterIdMap = new HashMap<Long, Long>();
    private Map<Long, Set<Long>> acctToDirectLeafMap = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> acctToAllLeafMap = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<String>> acctToFlexsMap = new HashMap<Long, Set<String>>();
    private Map<String, String> assistToFlexMap = new HashMap<String, String>();
    private Map<String, String> flexToAssistEntityMap = new HashMap<String, String>();
    private Map<String, Object> assistValNumberToObjMap = new HashMap<String, Object>();
    private Map<String, Set<Object>> assistValRangeNumberToObjsMap = new HashMap<String, Set<Object>>();
    private Map<String, DataSet> flexToIDHgSet = new HashMap<String, DataSet>();
    private AssitQuickSearchDs assistQuickSearchInstance;
    private Set<String> assistNumberAllVal = new HashSet<String>();
    private Set<String> flexAllVal = new HashSet<String>();
    private Map<String, Long> standardMap = new HashMap<String, Long>();
    private Map<String, DataSet> groupMap = new HashMap<String, DataSet>();
    private String orgNumber;
    private String bookTypeNumber;
    private long orgId = 0L;
    private long bookTypeId = 0L;
    private long acctTableId = 0L;

    public ReClassNumberIDParam(String comBookTypeNumber, ReClassParam param, String bookStr) {
        this.parseAcctFormula(comBookTypeNumber, param, bookStr);
    }

    private void parseAcctFormula(String comBookTypeNumber, ReClassParam param, String bookStr) {
        Map<String, Object> paramMap = param.getAcctFormulaMap();
        String comOrgNumber = param.getOrgNumber();
        String[] orgBookTypes = bookStr.split(",");
        this.orgNumber = orgBookTypes[0];
        this.bookTypeNumber = orgBookTypes[1];
        this.orgNumberSet.add(this.orgNumber);
        this.bookTypeNumberSet.add(this.bookTypeNumber);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String tmpBookTypeNumber;
            List paramFields = (List)entry.getValue();
            String tmpOrgNumber = (String)paramFields.get(0);
            if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                tmpOrgNumber = comOrgNumber;
            }
            if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                tmpBookTypeNumber = comBookTypeNumber;
            }
            if (!bookStr.equals(tmpOrgNumber + "," + tmpBookTypeNumber)) continue;
            String acctToAssistStr = (String)paramFields.get(2);
            this.getBatchAcctAndAssist(acctToAssistStr, entry.getKey());
            String fy = (String)paramFields.get(4);
            String periodNumber = (String)paramFields.get(5);
            this.periodNumberSet.add(fy + "," + periodNumber);
            String currencyNumber = (String)paramFields.get(6);
            this.currencyNumberSet.add(currencyNumber);
        }
        this.numberToIDParam();
        if (this.orgNumberToIdsMap.get(this.orgNumber) == null) {
            return;
        }
        this.orgId = this.orgNumberToIdsMap.get(this.orgNumber);
        if (this.bookTypeNumberToIdsMap.get(this.bookTypeNumber) == null) {
            return;
        }
        this.bookTypeId = this.bookTypeNumberToIdsMap.get(this.bookTypeNumber);
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgNumberToIdsMap.get(this.orgNumber), (long)this.bookTypeNumberToIdsMap.get(this.bookTypeNumber));
        if (bookInfo == null) {
            return;
        }
        this.acctTableId = bookInfo.getAccountTableId();
        this.queryPeriodIdByBook(param.getFy(), param.getPeriod());
        QFilter facctBaseData = AccountUtils.getAccountDataFilter((long)this.orgId, (long)this.acctTableId);
        this.queryAcctId(facctBaseData.copy());
        this.queryDLAndALAcct(facctBaseData.copy());
        this.queryAssistId(new HashSet<Long>());
    }

    private void queyAllAcctFlexs(Set<Long> acctIds) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, checkitementry.asstactitem.flexfield flexfield, checkitementry.asstactitem.valuetype valuetype", new QFilter[]{new QFilter("id", "in", acctIds)});
        for (Row row : acctSet) {
            long acctId = row.getLong("id");
            long masterId = row.getLong("masterid");
            String flexField = row.getString(FLEXFIELD);
            this.acctIdToMasterIdMap.put(acctId, masterId);
            if (flexField == null) {
                this.acctToFlexsMap.put(acctId, null);
                continue;
            }
            HashSet<String> flexMap = this.acctToFlexsMap.get(acctId) == null ? new HashSet<String>() : this.acctToFlexsMap.get(acctId);
            flexMap.add(flexField);
            this.acctToFlexsMap.put(acctId, flexMap);
            String valueType = row.getString(VALUETYPE);
            if ("3".equals(valueType)) {
                this.flexToAssistEntityMap.put(flexField, ASSISTTXT);
                continue;
            }
            this.flexToAssistEntityMap.put(flexField, ASSISTBD);
        }
    }

    private void queryDLAndALAcct(QFilter facctBaseData) {
        Object row22;
        HashSet<Long> acctIds = new HashSet<Long>();
        acctIds.addAll(this.acctNumberToIdsMap.values());
        for (Collection collection : this.acctRangeKeyToIdsMap.values()) {
            acctIds.addAll(collection);
        }
        this.getMasterIdByAcctId(acctIds);
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, parent", new QFilter[]{new QFilter("parent", "in", acctIds), facctBaseData.copy()});
        for (Object row22 : acctSet) {
            long leafAcctId = row22.getLong("id");
            long acctId = row22.getLong("parent");
            HashSet<Long> directLeafAcctIds = this.acctToDirectLeafMap.get(acctId) == null ? new HashSet<Long>() : this.acctToDirectLeafMap.get(acctId);
            directLeafAcctIds.add(leafAcctId);
            this.acctToDirectLeafMap.put(acctId, directLeafAcctIds);
        }
        HashMap<Long, Set<Long>> hashMap = new HashMap<Long, Set<Long>>(acctIds.size());
        row22 = acctIds.iterator();
        while (row22.hasNext()) {
            long acctId = (Long)row22.next();
            HashSet<Long> idSet = new HashSet<Long>();
            idSet.add(acctId);
            hashMap.put(acctId, idSet);
        }
        HashSet<Long> leafIds = new HashSet<Long>();
        leafIds.addAll(acctIds);
        this.getAcctAllLeaf(leafIds, hashMap, this.acctToAllLeafMap, 0, facctBaseData);
        this.filterBaseAcct();
        Iterator acctId = acctIds.iterator();
        while (acctId.hasNext()) {
            HashSet<Long> allLeafAcctIds;
            HashSet<Long> leafAcctIds;
            long acctId2 = (Long)acctId.next();
            Set<Long> set = leafAcctIds = this.acctToDirectLeafMap.get(acctId2) == null ? new HashSet<Long>() : this.acctToDirectLeafMap.get(acctId2);
            if (leafAcctIds.isEmpty()) {
                leafAcctIds.add(acctId2);
                this.acctToDirectLeafMap.put(acctId2, leafAcctIds);
            }
            if (!(allLeafAcctIds = this.acctToAllLeafMap.get(acctId2) == null ? new HashSet<Long>() : this.acctToAllLeafMap.get(acctId2)).isEmpty()) continue;
            allLeafAcctIds.add(acctId2);
            this.acctToAllLeafMap.put(acctId2, allLeafAcctIds);
        }
        HashSet<Long> allActtIds = new HashSet<Long>();
        for (Map.Entry<Long, Set<Long>> entry : this.acctToDirectLeafMap.entrySet()) {
            allActtIds.add(entry.getKey());
            allActtIds.addAll((Collection<Long>)entry.getValue());
        }
        for (Map.Entry<Long, Set<Long>> entry : this.acctToAllLeafMap.entrySet()) {
            allActtIds.add(entry.getKey());
            allActtIds.addAll((Collection<Long>)entry.getValue());
        }
        this.queyAllAcctFlexs(allActtIds);
    }

    private void filterBaseAcct() {
        Set<Long> leafSet;
        DataSet acctSet = AccountUtils.queryAccountDataSet((long)this.orgId, (long)this.acctTableId, (String)"id, masterid", null);
        HashSet<Long> acctIds = new HashSet<Long>();
        for (Row row : acctSet) {
            acctIds.add(row.getLong("id"));
        }
        for (Map.Entry<Long, Set<Long>> entry : this.acctToAllLeafMap.entrySet()) {
            leafSet = entry.getValue();
            leafSet.retainAll(acctIds);
        }
        for (Map.Entry<Long, Set<Long>> entry : this.acctToDirectLeafMap.entrySet()) {
            leafSet = entry.getValue();
            leafSet.retainAll(acctIds);
        }
    }

    private void getMasterIdByAcctId(Set<Long> acctIds) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid", new QFilter[]{new QFilter("id", "in", acctIds)});
        for (Row row : acctSet) {
            long id = row.getLong("id");
            long masterId = row.getLong("masterid");
            acctIds.add(masterId);
            this.acctIdToMasterIdMap.put(id, masterId);
        }
    }

    private void getAcctAllLeaf(Set<Long> acctIds, Map<Long, Set<Long>> leafIdsToAcctIdsMap, Map<Long, Set<Long>> idToAllLeafMap, int isRepeatIndex, QFilter facctBaseData) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id,number, masterid, parent, isleaf", new QFilter[]{new QFilter("parent", "in", acctIds), facctBaseData.copy()});
        acctIds.clear();
        HashSet<Long> noLeafAcctMids = new HashSet<Long>();
        for (Row row : acctSet) {
            long pid = row.getLong("parent");
            long id = row.getLong("id");
            long masterId = row.getLong("masterid");
            Set<Long> acctIdSet = leafIdsToAcctIdsMap.get(pid);
            boolean isLeaf = row.getBoolean("isleaf");
            if (isLeaf) {
                for (Long acctId : acctIdSet) {
                    Set<Object> allLeaf = idToAllLeafMap.get(acctId) == null ? new HashSet() : idToAllLeafMap.get(acctId);
                    allLeaf.add(id);
                    allLeaf.add(masterId);
                    idToAllLeafMap.put(acctId, allLeaf);
                }
                continue;
            }
            acctIds.add(id);
            acctIds.add(masterId);
            if (id != masterId) {
                noLeafAcctMids.add(masterId);
            }
            HashSet<Long> idSet = leafIdsToAcctIdsMap.get(id) == null ? new HashSet<Long>() : leafIdsToAcctIdsMap.get(id);
            idSet.addAll(acctIdSet);
            leafIdsToAcctIdsMap.put(id, idSet);
            leafIdsToAcctIdsMap.put(masterId, idSet);
        }
        for (Map.Entry<Long, Set<Long>> entry : idToAllLeafMap.entrySet()) {
            Set<Long> allLeaf = entry.getValue();
            allLeaf.removeAll(noLeafAcctMids);
        }
        if (!acctIds.isEmpty()) {
            if (isRepeatIndex > 1000) {
                return;
            }
            this.getAcctAllLeaf(acctIds, leafIdsToAcctIdsMap, idToAllLeafMap, ++isRepeatIndex, facctBaseData);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void queryAssistId(Set<Long> hgIds) {
        Object flex;
        String entityId;
        String assistNumber;
        HashMap<String, Set<Object>> flexToValIdsMap = new HashMap<String, Set<Object>>(this.assistNumberAllVal.size());
        HashSet<String> asstactTypeNumbers = new HashSet<String>();
        asstactTypeNumbers.addAll(this.assistNumberAllVal);
        if (!this.assistToValNumbersMap.keySet().isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValNumbersMap.keySet());
        }
        if (!this.assistToValRangeNumbersMap.keySet().isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValRangeNumbersMap.keySet());
        }
        HashMap<String, Long> numberToDetailGroupMap = new HashMap<String, Long>();
        HashMap<String, String> assistNnumberToEntityMap = new HashMap<String, String>();
        this.getFlexToAssistTypeMap(assistNnumberToEntityMap, numberToDetailGroupMap, asstactTypeNumbers);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        for (Map.Entry<String, Set<String>> entry : this.assistToValNumbersMap.entrySet()) {
            assistNumber = entry.getKey();
            entityId = (String)assistNnumberToEntityMap.get(assistNumber);
            Set<String> valNumber = entry.getValue();
            filters.clear();
            if (this.orgId != 0L && entityId != null) {
                this.dealBasedataFilter(filters, entityId, this.orgId);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long assistGroupId = (Long)numberToDetailGroupMap.get(assistNumber);
                filters.add(new QFilter("group", "=", (Object)assistGroupId));
            }
            HashMap<String, Object> numberToObjsMap = new HashMap<String, Object>();
            if (entityId == null) {
                for (String string : valNumber) {
                    numberToObjsMap.put(string, string);
                }
            } else {
                Map<String, Long> numberToIdsMap1 = ReClassUtils.numbersToMasterids(entityId, valNumber, filters);
                numberToObjsMap.putAll(numberToIdsMap1);
            }
            for (Map.Entry entry2 : numberToObjsMap.entrySet()) {
                this.assistValNumberToObjMap.put(assistNumber + "*" + (String)entry2.getKey(), entry2.getValue());
            }
            flex = this.assistToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            flexToValIdsMap.put((String)flex, new HashSet(numberToObjsMap.values()));
        }
        for (Map.Entry<String, Set<String>> entry : this.assistToValRangeNumbersMap.entrySet()) {
            assistNumber = entry.getKey();
            entityId = (String)assistNnumberToEntityMap.get(assistNumber);
            Set<String> rangeValNumber = entry.getValue();
            filters.clear();
            if (this.orgId != 0L) {
                this.dealBasedataFilter(filters, entityId, this.orgId);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long assistGroupId = (Long)numberToDetailGroupMap.get(assistNumber);
                filters.add(new QFilter("group", "=", (Object)assistGroupId));
            }
            HashSet allValIds = new HashSet();
            flex = rangeValNumber.iterator();
            while (flex.hasNext()) {
                void var14_22;
                String string;
                String key = string = flex.next();
                HashSet<Object> assistValIds = new HashSet<Object>();
                boolean isNoCategory = ReClassUtils.isCollectionNumber(string);
                if (!isNoCategory) {
                    String string2 = string.substring(1, string.length() - 1);
                }
                String[] assisttContinueNumbers = var14_22.split(",");
                if (entityId == null) {
                    assistValIds.addAll(Arrays.asList(assisttContinueNumbers));
                    allValIds.addAll(assistValIds);
                    this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                    continue;
                }
                DataSet assistSet = null;
                assistSet = !isNoCategory ? this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), filters, "masterid", entityId) : this.queryAssistValByGroup((String)var14_22, entityId);
                if (assistSet == null) continue;
                for (Row row : assistSet) {
                    assistValIds.add(row.getLong("masterid"));
                }
                this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                allValIds.addAll(assistValIds);
            }
            flex = this.assistToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            Set set = flexToValIdsMap.get(flex) == null ? new HashSet() : (Set)flexToValIdsMap.get(flex);
            set.addAll(allValIds);
            flexToValIdsMap.put((String)flex, set);
        }
        for (String assistNumber2 : this.assistNumberAllVal) {
            String flex2 = this.assistToFlexMap.get(assistNumber2);
            this.flexAllVal.add(flex2);
        }
        for (String flex3 : this.flexAllVal) {
            flexToValIdsMap.put(flex3, new HashSet());
        }
        this.addFlexAllVal(flexToValIdsMap, hgIds);
    }

    public void addFlexAllVal(Map<String, Set<Object>> flexToValIdsMap, Set<Long> hgIds) {
        this.assistQuickSearchInstance = new AssitQuickSearchDs();
        for (Map.Entry<String, Set<Object>> assistEntry : flexToValIdsMap.entrySet()) {
            QFilter ValFilter;
            boolean isFilterVal;
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            String flex = assistEntry.getKey();
            Set<Object> valIds = assistEntry.getValue();
            QFilter typeFilter = new QFilter("asstype", "=", (Object)flex);
            filters.add(typeFilter);
            if (valIds == null) {
                valIds = new HashSet<Object>();
            }
            String entityId = this.flexToAssistEntityMap.get(flex);
            boolean bl = isFilterVal = valIds.size() < 1000;
            if (isFilterVal && valIds.size() != 0 && !this.flexAllVal.contains(flex)) {
                ValFilter = new QFilter("assval", "in", valIds);
                filters.add(ValFilter);
            } else if (valIds.size() == 0) {
                if (ASSISTBD.equals(entityId)) {
                    ValFilter = new QFilter("assval", "!=", (Object)0L);
                    filters.add(ValFilter);
                } else if (ASSISTTXT.equals(entityId)) {
                    ValFilter = new QFilter("assval", "!=", (Object)"0");
                    filters.add(ValFilter);
                }
                this.flexAllVal.add(flex);
            }
            if (hgIds != null && !hgIds.isEmpty()) {
                filters.add(new QFilter("hg", "in", hgIds));
            }
            DataSet hgSet = ReClassUtils.queryDataSet(entityId, "hg, assval " + flex, filters);
            if (!isFilterVal && valIds.size() != 0 && !this.flexAllVal.contains(flex)) {
                HashMap<String, Set<Object>> filterMap = new HashMap<String, Set<Object>>();
                filterMap.put("valIds", valIds);
                hgSet = hgSet.filter(flex + " in valIds", filterMap);
            }
            this.assistQuickSearchInstance.initInvolve(flex, hgSet);
        }
    }

    private void dealBasedataFilter(List<QFilter> filters, String entityId, long orgId) {
        QFilter qf = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId);
        if (qf != null) {
            filters.add(qf);
        }
    }

    private void getFlexToAssistTypeMap(Map<String, String> numberToEntityMap, Map<String, Long> numberToDetailGroupMap, Set<String> asstactTypeNumbers) {
        QFilter fnumber = new QFilter("number", "in", asstactTypeNumbers);
        DataSet asstactSet = this.queryDataSet(this.getClass().getName(), ASSIST_TYPE, "number,valuetype,assistanttype,valuesource,flexfield", new QFilter[]{fnumber});
        for (Row row : asstactSet) {
            long assistGroupId = 0L;
            String valType = row.getString(VALUETYPE);
            String entityId = null;
            switch (valType) {
                case "1": {
                    entityId = row.getString("valuesource");
                    break;
                }
                case "2": {
                    entityId = "bos_assistantdata_detail";
                    assistGroupId = row.getLong("assistanttype");
                    break;
                }
                case "3": {
                    entityId = null;
                }
            }
            String number = row.getString("number");
            String flex = row.getString(FLEXFIELD);
            if (entityId != null) {
                this.flexToAssistEntityMap.put(flex, ASSISTBD);
            } else {
                this.flexToAssistEntityMap.put(flex, ASSISTTXT);
            }
            this.assistToFlexMap.put(number, flex);
            if (assistGroupId != 0L) {
                numberToDetailGroupMap.put(number, assistGroupId);
            }
            numberToEntityMap.put(number, entityId);
        }
    }

    private void getBatchAcctAndAssist(String acctAssistListStr, String acctKeyId) {
        acctAssistListStr = acctAssistListStr.replaceAll("\\|", "\\| ");
        String[] accountValues = acctAssistListStr.split("\\|");
        String accountNumberStr = "";
        if (accountValues.length == 1) {
            accountNumberStr = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                this.errorInfoMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u683c\u5f0f\u9519\u8bef\u3002", (String)"ReClassNumberIDParam_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
                return;
            }
            accountNumberStr = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)accountNumberStr)) {
            this.errorInfoMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"ReClassNumberIDParam_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return;
        }
        boolean isContinueAcct = this.isContinueNumber(accountNumberStr);
        if (!isContinueAcct) {
            String[] accts = accountNumberStr.split(",");
            this.acctNumberSet.addAll(Arrays.asList(accts));
        } else {
            this.acctRangeNumberSet.add(accountNumberStr);
        }
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            if (StringUtils.isBlank((CharSequence)assistNumber)) continue;
            HashSet<String> vals = new HashSet<String>();
            String rangeVals = "";
            String valStr = accountValues[i + 1].trim();
            if (!StringUtils.isBlank((CharSequence)valStr)) {
                if (ReClassUtils.isContinueNumber(valStr)) {
                    rangeVals = valStr;
                    HashSet<String> rangeValNumbers = this.assistToValRangeNumbersMap.get(assistNumber) == null ? new HashSet<String>() : this.assistToValRangeNumbersMap.get(assistNumber);
                    rangeValNumbers.add(rangeVals);
                    this.assistToValRangeNumbersMap.put(assistNumber, rangeValNumbers);
                    continue;
                }
                String[] valList = valStr.split(",");
                vals.addAll(Arrays.asList(valList));
                Set<String> valNumbers = this.assistToValNumbersMap.get(assistNumber);
                if (valNumbers == null) {
                    valNumbers = new HashSet<String>();
                    valNumbers.addAll(vals);
                } else {
                    if (valNumbers.size() == 0) continue;
                    valNumbers.addAll(vals);
                }
                this.assistToValNumbersMap.put(assistNumber, valNumbers);
                continue;
            }
            this.assistNumberAllVal.add(assistNumber);
        }
    }

    private boolean isContinueNumber(String numberStr) {
        if (!StringUtils.isBlank((CharSequence)numberStr)) {
            return numberStr.contains("[") && numberStr.contains("]");
        }
        return false;
    }

    private void numberToIDParam() {
        this.orgNumberToIdsMap = ReClassUtils.numbersToIds("bos_org", this.orgNumberSet, null);
        this.bookTypeNumberToIdsMap = ReClassUtils.numbersToIds("bd_accountbookstype", this.bookTypeNumberSet, null);
        this.currencyNumberToIdsMap = ReClassUtils.numbersToIds("bd_currency", this.currencyNumberSet, null);
    }

    private void queryPeriodIdByBook(int comFy, int comPeriod) {
        int year;
        HashSet<Integer> yearList = new HashSet<Integer>(this.periodNumberSet.size());
        HashSet<Integer> periodList = new HashSet<Integer>(this.periodNumberSet.size());
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgId, (long)this.bookTypeId);
        if (bookInfo == null) {
            return;
        }
        HashMap negativePeriodMap = new HashMap();
        for (String str : this.periodNumberSet) {
            String[] yearPeriodNumber = str.split(",");
            if (yearPeriodNumber.length != 2) continue;
            String yearStr = yearPeriodNumber[0];
            String periodStr = yearPeriodNumber[1];
            int period = this.dealPeriod(periodStr, comPeriod);
            year = this.dealYear(yearStr, comFy, period);
            if (period <= 0) {
                periodList = null;
                HashSet<Integer> nperiodSet = negativePeriodMap.get(year) == null ? new HashSet<Integer>() : (Set)negativePeriodMap.get(year);
                nperiodSet.add(period);
                negativePeriodMap.put(year, nperiodSet);
            } else if (periodList != null) {
                periodList.add(period);
            }
            yearList.add(year);
        }
        long periodTypeId = bookInfo.getPeriodTypeId();
        HashMap<Integer, Integer> yearMaxPeriodMap = new HashMap<Integer, Integer>();
        DataSet periodDataSet = this.queryPeriodByNumber("periodyear, periodnumber, id", yearList, periodList, periodTypeId);
        for (Row row : periodDataSet) {
            int maxPeriod;
            year = row.getInteger("periodyear");
            int periodNumber = row.getInteger("periodnumber");
            this.periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
            int n = maxPeriod = yearMaxPeriodMap.get(year) == null ? 1 : (Integer)yearMaxPeriodMap.get(year);
            if (periodNumber > maxPeriod) {
                maxPeriod = periodNumber;
            }
            yearMaxPeriodMap.put(year, maxPeriod);
        }
        if (!negativePeriodMap.isEmpty()) {
            for (Map.Entry nEntry : negativePeriodMap.entrySet()) {
                year = (Integer)nEntry.getKey();
                Set periodNumberSet = (Set)nEntry.getValue();
                for (Integer nperiod : periodNumberSet) {
                    if (yearMaxPeriodMap.get(year) == null) continue;
                    int maxPeriod = (Integer)yearMaxPeriodMap.get(year);
                    int period = maxPeriod + nperiod;
                    if (this.periodIdsMap.get(year + "," + period) == null) continue;
                    long periodId = this.periodIdsMap.get(year + "," + period);
                    this.periodIdsMap.put(year + "," + nperiod, periodId);
                }
            }
        }
    }

    protected int dealPeriod(String periodStr, int comPeriod) {
        int period = Integer.parseInt(periodStr = StringUtils.isBlank((CharSequence)periodStr) ? "0" : periodStr);
        if (period <= 0) {
            period += comPeriod;
        }
        return period;
    }

    protected int dealYear(String yearStr, int comFy, int period) {
        int year = Integer.parseInt(yearStr = StringUtils.isBlank((CharSequence)yearStr) ? "0" : yearStr);
        if (year <= 1000) {
            year += comFy;
        }
        if (period > -12 && period <= 0) {
            --year;
        }
        return year;
    }

    private DataSet queryPeriodByNumber(String selFields, Set<Integer> fys, Set<Integer> periodNumbers, long periodTypeId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter fperiodTypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter ffy = new QFilter("periodyear", "in", fys);
        if (periodNumbers != null && periodNumbers.size() > 0) {
            QFilter fperiod = new QFilter("periodnumber", "in", periodNumbers);
            filters.add(fperiod);
        }
        filters.add(fperiodTypeId);
        filters.add(ffy);
        DataSet periodSet = this.queryDataSet(this.getClass().getName(), "bd_period", selFields, filters.toArray(new QFilter[0]));
        return periodSet;
    }

    private void queryAcctId(QFilter facctBaseData) {
        QFilter filterAcctTable = new QFilter("accounttable", "=", (Object)this.acctTableId);
        QFilter fnumbers = new QFilter("number", "in", this.acctNumberSet);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filterAcctTable);
        filters.add(facctBaseData.copy());
        filters.add(fnumbers);
        DataSet acctSet = ReClassUtils.queryDataSet("bd_accountview", "id, number, masterid,dc", filters);
        for (Row row : acctSet) {
            long acctId = row.getLong("id");
            String number = row.getString("number");
            this.acctNumberToIdsMap.put(number, acctId);
            this.acctNumberToDcMap.put(number, row.getString("dc"));
        }
        for (String acctRangeNumber : this.acctRangeNumberSet) {
            ArrayList<QFilter> rangFilters = new ArrayList<QFilter>();
            rangFilters.add(filterAcctTable);
            rangFilters.add(facctBaseData.copy());
            String key = acctRangeNumber;
            acctRangeNumber = acctRangeNumber.substring(1, acctRangeNumber.length() - 1);
            String[] acctContinueNumbers = acctRangeNumber.split(",");
            DataSet rangeAcctSet = this.queryContinueNumber(Arrays.asList(acctContinueNumbers), rangFilters, "id,masterid,dc,level,number", "bd_accountview");
            HashSet<Long> acctIds = new HashSet<Long>();
            String dc = null;
            int level = 0;
            for (Row row : rangeAcctSet) {
                if (level == 0) {
                    level = row.getInteger("level");
                }
                if (level != row.getInteger("level")) continue;
                if (dc == null) {
                    dc = row.getString("dc");
                }
                long acctId = row.getLong("id");
                acctIds.add(acctId);
            }
            this.acctRangeKeyToIdsMap.put(key, acctIds);
            this.acctRangeKeyToDcMap.put(key, dc);
        }
    }

    private DataSet queryContinueNumber(List<String> acctNumbers, List<QFilter> filters, String sel, String entityName) {
        if (acctNumbers != null && acctNumbers.size() == 2) {
            String acctNumber0 = acctNumbers.get(0);
            String acctNumber1 = acctNumbers.get(1);
            QFilter filterMin = new QFilter("number", ">=", (Object)acctNumber0);
            QFilter filterMax = new QFilter("number", "<=", (Object)acctNumber1);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.addAll(filters);
            filterList.add(filterMin);
            filterList.add(filterMax);
            DataSet acctSet = QueryServiceHelper.queryDataSet((String)"ReClassUtils.queryDataSet", (String)entityName, (String)sel, (QFilter[])filterList.toArray(new QFilter[0]), (String)"number");
            return acctSet;
        }
        return null;
    }

    private Set<Long> queryLeafCategory(String categoryNumber, String entityId) {
        entityId = entityId + "group";
        String[] assisttContinueNumbers = null;
        String sel = "parent pid, id, isleaf";
        DataSet dataSet = null;
        if (categoryNumber.startsWith("[")) {
            categoryNumber = categoryNumber.substring(1, categoryNumber.length() - 1);
            assisttContinueNumbers = categoryNumber.split(",");
            dataSet = this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), new ArrayList<QFilter>(), sel, entityId);
        } else if (categoryNumber.contains(",")) {
            String[] categroyList = categoryNumber.split(",");
            QFilter fid = new QFilter("number", "in", (Object)categroyList);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        } else {
            QFilter fid = new QFilter("number", "=", (Object)categoryNumber);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        }
        HashSet<Long> allIds = new HashSet<Long>();
        HashSet<Long> noLeafIds = new HashSet<Long>();
        this.getLeafAndNoLeaf(dataSet, noLeafIds, allIds);
        this.getAllLeaf(noLeafIds, entityId, allIds);
        return allIds;
    }

    private DataSet queryAssistValByGroup(String categoryNumber, String entityId) {
        String groupKey = entityId.substring(3);
        String[] categoryList = categoryNumber.split("#");
        if (categoryList.length != 2) {
            return null;
        }
        String standardNumber = categoryList[0];
        long standardId = 0L;
        if (this.standardMap.get(entityId + "*" + standardNumber) == null) {
            DataSet standardSet = this.queryDataSet(this.getClass().getName(), entityId + "groupstandard", "id", new QFilter[]{new QFilter("number", "=", (Object)standardNumber)});
            for (Row row : standardSet) {
                standardId = row.getLong("id");
            }
            this.standardMap.put(entityId + "*" + standardNumber, standardId);
        } else {
            standardId = this.standardMap.get(entityId + "*" + standardNumber);
        }
        String groupNumber = categoryList[1];
        DataSet assistSet = null;
        if (this.groupMap.get(entityId + "*" + groupNumber) == null) {
            Set<Long> allGroupIds = this.queryLeafCategory(groupNumber, entityId);
            QFilter fgid = new QFilter("group", "in", allGroupIds);
            QFilter fstandard = new QFilter("standard", "=", (Object)standardId);
            String sel = groupKey + " masterid";
            assistSet = this.queryDataSet(this.getClass().getName(), entityId + "groupdetail", sel, new QFilter[]{fgid, fstandard});
            this.groupMap.put(entityId + "*" + groupNumber, assistSet);
        } else {
            assistSet = this.groupMap.get(entityId + "*" + groupNumber);
        }
        return assistSet;
    }

    private DataSet queryDataSet(String algoKey, String entityId, String sel, QFilter[] filters) {
        DataSet assistSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityId, (String)sel, (QFilter[])filters, null);
        return assistSet;
    }

    private void getAllLeaf(Set<Long> noLeafIds, String entityId, Set<Long> leafIds) {
        if (noLeafIds.isEmpty()) {
            return;
        }
        QFilter fid = new QFilter("parent", "in", noLeafIds);
        String sel = "id, isleaf";
        DataSet childSet = this.queryDataSet(this.getClass().getName(), entityId, sel, new QFilter[]{fid});
        noLeafIds.clear();
        this.getLeafAndNoLeaf(childSet, noLeafIds, leafIds);
        this.getAllLeaf(noLeafIds, entityId, leafIds);
    }

    private void getLeafAndNoLeaf(DataSet childSet, Set<Long> noLeafIds, Set<Long> allIds) {
        if (childSet == null) {
            return;
        }
        for (Row row : childSet) {
            long id = row.getLong("id");
            if (row.getBoolean("isleaf").booleanValue()) {
                allIds.add(id);
                continue;
            }
            allIds.add(id);
            noLeafIds.add(id);
        }
    }

    public Set<String> getOrgNumberSet() {
        return this.orgNumberSet;
    }

    public void setOrgNumberSet(Set<String> orgNumberSet) {
        this.orgNumberSet = orgNumberSet;
    }

    public Set<String> getBookTypeNumberSet() {
        return this.bookTypeNumberSet;
    }

    public void setBookTypeNumberSet(Set<String> bookTypeNumberSet) {
        this.bookTypeNumberSet = bookTypeNumberSet;
    }

    public Set<String> getCurrencyNumberSet() {
        return this.currencyNumberSet;
    }

    public void setCurrencyNumberSet(Set<String> currencyNumberSet) {
        this.currencyNumberSet = currencyNumberSet;
    }

    public Set<String> getPeriodNumberSet() {
        return this.periodNumberSet;
    }

    public void setPeriodNumberSet(Set<String> periodNumberSet) {
        this.periodNumberSet = periodNumberSet;
    }

    public Set<String> getAcctNumberSet() {
        return this.acctNumberSet;
    }

    public void setAcctNumberSet(Set<String> acctNumberSet) {
        this.acctNumberSet = acctNumberSet;
    }

    public Map<String, Long> getOrgNumberToIdsMap() {
        return this.orgNumberToIdsMap;
    }

    public void setOrgNumberToIdsMap(Map<String, Long> orgNumberToIdsMap) {
        this.orgNumberToIdsMap = orgNumberToIdsMap;
    }

    public Map<String, Long> getBookTypeNumberToIdsMap() {
        return this.bookTypeNumberToIdsMap;
    }

    public void setBookTypeNumberToIdsMap(Map<String, Long> bookTypeNumberToIdsMap) {
        this.bookTypeNumberToIdsMap = bookTypeNumberToIdsMap;
    }

    public Map<String, Long> getCurrencyNumberToIdsMap() {
        return this.currencyNumberToIdsMap;
    }

    public void setCurrencyNumberToIdsMap(Map<String, Long> currencyNumberToIdsMap) {
        this.currencyNumberToIdsMap = currencyNumberToIdsMap;
    }

    public Map<String, String> getAcctNumberToDcMap() {
        return this.acctNumberToDcMap;
    }

    public Map<String, Long> getAcctNumberToIdsMap() {
        return this.acctNumberToIdsMap;
    }

    public void setAcctNumberToIdsMap(Map<String, Long> acctNumberToIdsMap) {
        this.acctNumberToIdsMap = acctNumberToIdsMap;
    }

    public Map<String, Long> getPeriodIdsMap() {
        return this.periodIdsMap;
    }

    public void setPeriodIdsMap(Map<String, Long> periodIdsMap) {
        this.periodIdsMap = periodIdsMap;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public long getBookTypeId() {
        return this.bookTypeId;
    }

    public long getAcctTableId() {
        return this.acctTableId;
    }

    public Set<String> getAcctRangeNumberSet() {
        return this.acctRangeNumberSet;
    }

    public void setAcctRangeNumberSet(Set<String> acctRangeNumberSet) {
        this.acctRangeNumberSet = acctRangeNumberSet;
    }

    public Map<String, Set<String>> getAssistToValNumbersMap() {
        return this.assistToValNumbersMap;
    }

    public void setAssistToValNumbersMap(Map<String, Set<String>> assistToValNumbersMap) {
        this.assistToValNumbersMap = assistToValNumbersMap;
    }

    public Map<String, Set<String>> getAssistToValRangeNumbersMap() {
        return this.assistToValRangeNumbersMap;
    }

    public void setAssistToValRangeNumbersMap(Map<String, Set<String>> assistToValRangeNumbersMap) {
        this.assistToValRangeNumbersMap = assistToValRangeNumbersMap;
    }

    public Map<String, String> getAcctRangeKeyToDcMap() {
        return this.acctRangeKeyToDcMap;
    }

    public Map<String, Set<Long>> getAcctRangeKeyToIdsMap() {
        return this.acctRangeKeyToIdsMap;
    }

    public void setAcctRangeKeyToIdsMap(Map<String, Set<Long>> acctRangeKeyToIdsMap) {
        this.acctRangeKeyToIdsMap = acctRangeKeyToIdsMap;
    }

    public Map<Long, Set<Long>> getAcctToDirectLeafMap() {
        return this.acctToDirectLeafMap;
    }

    public void setAcctToDirectLeafMap(Map<Long, Set<Long>> acctToDirectLeafMap) {
        this.acctToDirectLeafMap = acctToDirectLeafMap;
    }

    public Map<Long, Set<Long>> getAcctToAllLeafMap() {
        return this.acctToAllLeafMap;
    }

    public void setAcctToAllLeafMap(Map<Long, Set<Long>> acctToAllLeafMap) {
        this.acctToAllLeafMap = acctToAllLeafMap;
    }

    public Map<Long, Set<String>> getAcctToFlexsMap() {
        return this.acctToFlexsMap;
    }

    public void setAcctToFlexsMap(Map<Long, Set<String>> acctToFlexsMap) {
        this.acctToFlexsMap = acctToFlexsMap;
    }

    public Map<String, String> getAssistToFlexMap() {
        return this.assistToFlexMap;
    }

    public void setAssistToFlexMap(Map<String, String> assistToFlexMap) {
        this.assistToFlexMap = assistToFlexMap;
    }

    public Map<String, Object> getassistValNumberToObjMap() {
        return this.assistValNumberToObjMap;
    }

    public void setassistValNumberToObjMap(Map<String, Object> assistValNumberToObjMap) {
        this.assistValNumberToObjMap = assistValNumberToObjMap;
    }

    public Map<String, Set<Object>> getassistValRangeNumberToObjsMap() {
        return this.assistValRangeNumberToObjsMap;
    }

    public void setassistValRangeNumberToObjsMap(Map<String, Set<Object>> assistValRangeNumberToObjsMap) {
        this.assistValRangeNumberToObjsMap = assistValRangeNumberToObjsMap;
    }

    public Map<String, DataSet> getFlexToIDHgSet() {
        return this.flexToIDHgSet;
    }

    public void setFlexToIDHgSet(Map<String, DataSet> flexToIDHgSet) {
        this.flexToIDHgSet = flexToIDHgSet;
    }

    public String getBookTypeNumber() {
        return this.bookTypeNumber;
    }

    public void setBookTypeNumber(String bookTypeNumber) {
        this.bookTypeNumber = bookTypeNumber;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public void setBookTypeId(long bookTypeId) {
        this.bookTypeId = bookTypeId;
    }

    public void setAcctTableId(long acctTableId) {
        this.acctTableId = acctTableId;
    }

    public Set<String> getAssistNumberAllVal() {
        return this.assistNumberAllVal;
    }

    public void setAssistNumberAllVal(Set<String> assistNumberAllVal) {
        this.assistNumberAllVal = assistNumberAllVal;
    }

    public void setErrorInfoMap(Map<String, String> errorInfoMap) {
        this.errorInfoMap = errorInfoMap;
    }

    public Map<String, String> getErrorInfoMap() {
        return this.errorInfoMap;
    }

    public Set<String> getFlexAllVal() {
        return this.flexAllVal;
    }

    public void setFlexAllVal(Set<String> flexAllVal) {
        this.flexAllVal = flexAllVal;
    }

    public Map<Long, Long> getAcctIdToMasterIdMap() {
        return this.acctIdToMasterIdMap;
    }

    public void setAcctIdToMasterIdMap(Map<Long, Long> acctIdToMasterIdMap) {
        this.acctIdToMasterIdMap = acctIdToMasterIdMap;
    }

    public Map<String, String> getFlexToAssistEntityMap() {
        return this.flexToAssistEntityMap;
    }

    public void setFlexToAssistEntityMap(Map<String, String> flexToAssistEntityMap) {
        this.flexToAssistEntityMap = flexToAssistEntityMap;
    }

    public AssitQuickSearchDs getAssistQuickSearchInstance() {
        return this.assistQuickSearchInstance;
    }

    public void setAssistQuickSearchInstance(AssitQuickSearchDs assistQuickSearchInstance) {
        this.assistQuickSearchInstance = assistQuickSearchInstance;
    }
}

