/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.assistgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.assistgroup.AbstractAssistGroup;
import kd.fi.gl.util.assistgroup.assistgroupids.AssistGroupIdsProcesserFactory;

public class DefaultAssistGroupImpl
extends AbstractAssistGroup {
    @Override
    public DataSet queryAssistValByGroup(String categoryNumber, String entityId) {
        String groupKey = entityId.substring(3);
        String[] categoryList = categoryNumber.split("#");
        if (categoryList.length != 2) {
            return null;
        }
        String standardNumber = categoryList[0];
        long standardId = 0L;
        if (this.standardMap.get(entityId + "*" + standardNumber) == null) {
            DataSet standardSet = this.queryDataSet(this.getClass().getName(), entityId + "groupstandard", "id", new QFilter[]{new QFilter("number", "=", (Object)standardNumber)});
            for (Row row : standardSet) {
                standardId = row.getLong("id");
            }
            this.standardMap.put(entityId + "*" + standardNumber, standardId);
        } else {
            standardId = (Long)this.standardMap.get(entityId + "*" + standardNumber);
        }
        String groupNumber = categoryList[1];
        DataSet assistSet = null;
        if (this.groupMap.get(entityId + "*" + groupNumber) == null) {
            Set<Long> allGroupIds = this.queryLeafCategory(groupNumber, entityId);
            QFilter fgid = new QFilter("group", "in", allGroupIds);
            QFilter fstandard = new QFilter("standard", "=", (Object)standardId);
            String sel = groupKey + " masterid";
            assistSet = this.queryDataSet(this.getClass().getName(), entityId + "groupdetail", sel, new QFilter[]{fgid, fstandard});
            this.groupMap.put(entityId + "*" + groupNumber, assistSet);
        } else {
            assistSet = (DataSet)this.groupMap.get(entityId + "*" + groupNumber);
        }
        return assistSet;
    }

    private Set<Long> queryLeafCategory(String categoryNumber, String entityId) {
        entityId = entityId + "group";
        String[] assisttContinueNumbers = null;
        String sel = "parent pid, id, isleaf";
        DataSet dataSet = null;
        if (categoryNumber.startsWith("[")) {
            categoryNumber = categoryNumber.substring(1, categoryNumber.length() - 1);
            assisttContinueNumbers = categoryNumber.split(",");
            dataSet = this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), new ArrayList<QFilter>(), sel, entityId);
        } else if (categoryNumber.contains(",")) {
            String[] categroyList = categoryNumber.split(",");
            QFilter fid = new QFilter("number", "in", (Object)categroyList);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        } else {
            QFilter fid = new QFilter("number", "=", (Object)categoryNumber);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        }
        Set<Long> allIds = AssistGroupIdsProcesserFactory.getProcesser(true).init(dataSet, entityId).getAllIds();
        return allIds;
    }
}

