/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.formplugin.CardHomePlugin;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;

public class AccRiskCtlPlugin
extends CardHomePlugin
implements HyperLinkClickListener {
    public static final String ADD_OP = "addop";
    public static final String DEL_OP = "delop";
    public static final String EDIT_OP = "editop";
    public static final String ACCOUNT = "account";
    public static final String ACCOUNTS = "accounts";
    public static final String CURRENCY_NUMBER = "currency.number";
    public static final String RISK_COND = "riskcond";
    public static final String RISK_STAT = "riskstatus";
    public static final String RISK_ID = "riskid";
    public static final String BASEDATA_ID = "fbasedataid_id";
    public static final String VALUE = "value";
    public static final String CURRENCY = "currency";
    public static final String ENTRY_NAME = "entryentity";
    private static final String CALLBACK_KEY = "accrisksettingcallback";

    public void afterCreateNewData(EventObject e) {
        if (this.getAccountBook() == null) {
            return;
        }
        this.loadRiskControlData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_OP, EDIT_OP, DEL_OP});
        this.addItemClickListeners(new String[]{ENTRY_NAME});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_NAME);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        this.hyperAccbalanceFormRpt();
    }

    private void hyperAccbalanceFormRpt() {
        Object accPkValue = ((DynamicObject)this.getModel().getValue(ACCOUNT)).getPkValue();
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)accPkValue, (String)"bd_accountview", (String)"level");
        DynamicObject org = (DynamicObject)this.getView().getParentView().getModel().getValue("orgid");
        AccountBookInfo bookInfo = this.getAccountBook();
        Long riskId = (Long)this.getModel().getValue(RISK_ID);
        DynamicObject riskSet = BusinessDataServiceHelper.loadSingle((String)"gl_bill_accriskset", (String)"curfor", (QFilter[])new QFilter("id", "=", (Object)riskId).toArray());
        long curforId = 0L;
        if (riskSet != null) {
            curforId = riskSet.getLong("curfor_id");
        }
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId("gl_rpt_accountbalance");
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("orgs", (Object)org.getLong("id"));
        filter.addFilterItem("booktype", (Object)bookInfo.getBookTypeId());
        filter.addFilterItem("periodtype", (Object)bookInfo.getPeriodTypeId());
        filter.addFilterItem("startperiod", (Object)bookInfo.getCurPeriodId());
        filter.addFilterItem("endperiod", (Object)bookInfo.getCurPeriodId());
        filter.addFilterItem("accounttable", (Object)bookInfo.getAccountTableId());
        filter.addFilterItem(ACCOUNT, (Object)account.getLong("id"));
        filter.addFilterItem("accountlevel", (Object)String.valueOf(account.get("level")));
        if (curforId != 0L) {
            filter.addFilterItem(CURRENCY, (Object)String.valueOf(curforId));
        } else {
            filter.addFilterItem(CURRENCY, (Object)"basecurrency");
        }
        filter.addFilterItem("orgview", (Object)AccSysUtil.getMainViewByOrgAndBT((Long)org.getLong("id"), (Long)bookInfo.getBookTypeId()));
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)report);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (this.getAccountBook() == null) {
            return;
        }
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (ADD_OP.equals(key)) {
            this.addAccRiskSetting(null);
        } else if (EDIT_OP.equals(key)) {
            Map<Long, Set<Long>> map = this.getSelectedRiskAccMap();
            if (map.size() == 0) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7f16\u8f91\u7684\u884c\u3002", (String)"AccRiskCtlPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                return;
            }
            this.addAccRiskSetting(map);
        } else if (DEL_OP.equals(key)) {
            Map<Long, Set<Long>> map = this.getSelectedRiskAccMap();
            if (map.size() == 0) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"AccRiskCtlPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                return;
            }
            this.deleteAccRiskSetting(map);
        }
    }

    private void deleteAccRiskSetting(Map<Long, Set<Long>> riskAccMap) {
        DynamicObject[] cols;
        QFilter filter = new QFilter("id", "in", riskAccMap.keySet());
        for (DynamicObject col : cols = BusinessDataServiceHelper.load((String)"gl_bill_accriskset", (String)"id,accounts", (QFilter[])new QFilter[]{filter})) {
            Set<Long> rmvAccSet = riskAccMap.get(col.getLong("id"));
            DynamicObjectCollection accounts = col.getDynamicObjectCollection(ACCOUNTS);
            accounts.removeIf(x -> rmvAccSet.contains(x.getLong(BASEDATA_ID)));
        }
        long[] emptyRiskIds = Stream.of(cols).filter(x -> x.getDynamicObjectCollection(ACCOUNTS).isEmpty()).mapToLong(y -> y.getLong("id")).toArray();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_NAME);
        int[] selectRows = entryGrid.getSelectRows();
        try (TXHandle h = TX.required((String)("fi_gl_" + ((Object)((Object)this)).getClass().getName()));){
            try {
                SaveServiceHelper.save((DynamicObject[])cols);
                DeleteServiceHelper.delete((String)"gl_bill_accriskset", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)emptyRiskIds)});
                this.getModel().deleteEntryRows(ENTRY_NAME, selectRows);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private Map<Long, Set<Long>> getSelectedRiskAccMap() {
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_NAME);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRY_NAME);
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        for (int rowNo : selectRows) {
            DynamicObject dyn = (DynamicObject)entryEntity.get(rowNo);
            long riskId = dyn.getLong(RISK_ID);
            long accId = dyn.getLong("account_id");
            GlFormUtil.putMap(map, riskId, accId);
        }
        return map;
    }

    private void loadRiskControlData() {
        List<RiskControl> riskControls = RiskControlDAO.queryRiskControl(this.getAccountBook());
        List<RiskControlBalance> balances = this.getBalances(riskControls);
        this.fillEntries(balances);
    }

    private List<RiskControlBalance> getBalances(List<RiskControl> riskControls) {
        ArrayList<RiskControlBalance> result = new ArrayList<RiskControlBalance>(riskControls.size());
        Set<RiskControlAccount> allAccounts = riskControls.stream().map(RiskControl::getAccounts).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toSet());
        Map<String, RiskControlAccount> accountNumberMap = allAccounts.stream().collect(Collectors.toMap(RiskControlAccount::getNumber, x -> x));
        try (DataSet balance = BalanceDAO.queryBalance(this.getAccountBook(), allAccounts);){
            for (RiskControl riskControl : riskControls) {
                Set<RiskControlAccount> accounts = riskControl.getAccounts();
                DataSet accountBalance = this.getAccountBalance(balance.copy(), riskControl);
                ArrayList<RiskControlBalance> balanceList = new ArrayList<RiskControlBalance>(accounts.size());
                for (Row row2 : accountBalance.copy()) {
                    RiskControlBalance riskControlBalance = new RiskControlBalance();
                    riskControlBalance.setRiskControl(riskControl);
                    riskControlBalance.setAccount(accountNumberMap.get(row2.getString("number")));
                    riskControlBalance.setCurrencyId(row2.getLong("basecurrency"));
                    riskControlBalance.setBalance(row2.getBigDecimal(riskControl.getBalanceField()));
                    balanceList.add(riskControlBalance);
                }
                DataSet riskBalance = accountBalance.filter(riskControl.getRiskCondition());
                Map<RiskControlAccount, RiskControlBalance> accountBalanceMap = balanceList.stream().collect(Collectors.toMap(RiskControlBalance::getAccount, x -> x, (o, n) -> n));
                riskBalance.forEach(row -> ((RiskControlBalance)accountBalanceMap.get(accountNumberMap.get(row.getString("number")))).setMatchCondition(true));
                result.addAll(balanceList);
            }
        }
        return result;
    }

    private DataSet getAccountBalance(DataSet balanceCopy, RiskControl riskControl) {
        Set<RiskControlAccount> accounts = riskControl.getAccounts();
        String accountFilter = CollectionUtils.isEmpty(accounts) ? "(' ')" : "(" + accounts.stream().map(x -> "'" + x.getNumber() + "'").collect(Collectors.joining(",")) + ")";
        balanceCopy = balanceCopy.filter("number in" + accountFilter);
        balanceCopy = StringUtils.isEmpty((String)riskControl.getCurrencyCondition()) ? balanceCopy.select(new String[]{"number", CURRENCY, CURRENCY_NUMBER, "debitlocal", "creditlocal", "endlocal"}).groupBy(new String[]{"number", CURRENCY, CURRENCY_NUMBER}).sum("debitlocal").sum("creditlocal").sum("endlocal").finish() : balanceCopy.filter(riskControl.getCurrencyCondition());
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(new RowMeta(new Field[]{new Field("number", (DataType)DataType.StringType)}));
        accounts.forEach(x -> dataSetBuilder.append(new Object[]{x.getNumber()}));
        return dataSetBuilder.build().leftJoin(balanceCopy).on("number", "number").select(new String[]{"number"}, new String[]{CURRENCY, CURRENCY_NUMBER, "debitlocal", "creditlocal", "endlocal"}).finish().select(new String[]{"number", CURRENCY, CURRENCY_NUMBER, "case debitlocal when null then 0.0 else debitlocal end as debitlocal", "case creditlocal when null then 0.0 else creditlocal end as creditlocal", "case endlocal when null then 0.0 else endlocal end as endlocal"}).addField(String.valueOf(this.getAccountBook().getBaseCurrencyId()), "basecurrency");
    }

    private void fillEntries(List<RiskControlBalance> balances) {
        balances.sort(Comparator.comparing(x -> ((RiskControlBalance)x).getAccount().getNumber()).thenComparing(x -> ((RiskControlBalance)x).getRiskControl().getId()));
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(ENTRY_NAME);
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        TableValueSetter vs = new TableValueSetter(new String[]{RISK_ID, RISK_COND, ACCOUNT, RISK_STAT, VALUE, CURRENCY});
        for (RiskControlBalance balance : balances) {
            vs.addRow(new Object[]{balance.getRiskControl().getId(), balance.getRiskControl().getConditionDesc(), balance.getAccount().getId(), balance.isMatchCondition() ? "0" : "1", balance.getBalance(), balance.getCurrencyId()});
        }
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRY_NAME, vs);
        model.endInit();
        this.getView().updateView(ENTRY_NAME);
    }

    private void addAccRiskSetting(Map<Long, Set<Long>> riskAccMap) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId("gl_bill_accriskset");
        param.setCustomParam("accountbookinfo", (Object)GLUtil.toSerializedString((Object)super.getAccountBook()));
        if (riskAccMap != null) {
            param.setCustomParam("riskAccMap", (Object)GLUtil.toSerializedString(riskAccMap));
        }
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY));
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (CALLBACK_KEY.equals(e.getActionId())) {
            this.loadRiskControlData();
        }
    }

    private static class RiskControlAccount {
        private Long id;
        private String number;

        private RiskControlAccount() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RiskControlAccount that = (RiskControlAccount)o;
            return Objects.equals(this.number, that.number);
        }

        public int hashCode() {
            return Objects.hash(this.number);
        }
    }

    private static class BalanceDAO {
        private BalanceDAO() {
        }

        public static DataSet queryBalance(AccountBookInfo accountBook, Collection<RiskControlAccount> accounts) {
            String selectFields = "account.number number,currency,currency.number,debitlocal,creditlocal,endlocal";
            QueryParam param = new QueryParam();
            param.setAccountFilter(new QFilter("number", "in", accounts.stream().filter(Objects::nonNull).map(RiskControlAccount::getNumber).collect(Collectors.toSet())));
            return BalanceQueryExecutor.getInstance().getBalance(selectFields, new Long[]{accountBook.getOrgId()}, accountBook.getBookTypeId(), accountBook.getAccountTableId(), accountBook.getCurPeriodId(), accountBook.getCurPeriodId(), param);
        }
    }

    private static class RiskControlBalance {
        private RiskControl riskControl;
        private RiskControlAccount account;
        private Long currencyId;
        private BigDecimal balance;
        private boolean matchCondition;

        private RiskControlBalance() {
        }

        public RiskControl getRiskControl() {
            return this.riskControl;
        }

        public void setRiskControl(RiskControl riskControl) {
            this.riskControl = riskControl;
        }

        public RiskControlAccount getAccount() {
            return this.account;
        }

        public void setAccount(RiskControlAccount account) {
            this.account = account;
        }

        public Long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(Long currencyId) {
            this.currencyId = currencyId;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public void setBalance(BigDecimal balance) {
            this.balance = balance;
        }

        public boolean isMatchCondition() {
            return this.matchCondition;
        }

        public void setMatchCondition(boolean matchCondition) {
            this.matchCondition = matchCondition;
        }
    }

    private static class RiskControl {
        private Long id;
        private Set<RiskControlAccount> accounts;
        private String condition;
        private String balanceField;
        private String balanceCondition;
        private String currencyNumber;
        private String currencyCondition;
        private String conditionDesc;

        private RiskControl() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Set<RiskControlAccount> getAccounts() {
            return this.accounts;
        }

        public void setAccounts(Set<RiskControlAccount> accounts) {
            this.accounts = accounts;
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public String getBalanceField() {
            return this.balanceField;
        }

        public void setBalanceField(String balanceField) {
            this.balanceField = balanceField;
        }

        public String getBalanceCondition() {
            return this.balanceCondition;
        }

        public void setBalanceCondition(String balanceCondition) {
            this.balanceCondition = balanceCondition;
        }

        public String getCurrencyNumber() {
            return this.currencyNumber;
        }

        public void setCurrencyNumber(String currencyNumber) {
            this.currencyNumber = currencyNumber;
        }

        public String getCurrencyCondition() {
            return this.currencyCondition;
        }

        public void setCurrencyCondition(String currencyCondition) {
            this.currencyCondition = currencyCondition;
        }

        public String getConditionDesc() {
            return this.conditionDesc;
        }

        public void setConditionDesc(String conditionDesc) {
            this.conditionDesc = conditionDesc;
        }

        public String getRiskCondition() {
            if (StringUtils.isNotEmpty((String)this.getCurrencyCondition())) {
                return this.getCondition() + " or (" + this.getBalanceCondition() + " and " + AccRiskCtlPlugin.CURRENCY_NUMBER + " = null)";
            }
            return this.getCondition();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RiskControl that = (RiskControl)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class RiskControlDAO {
        private RiskControlDAO() {
        }

        public static List<RiskControl> queryRiskControl(AccountBookInfo accountBook) {
            QFilter filter = new QFilter("org", "=", (Object)accountBook.getOrgId()).and("user", "=", (Object)ContextUtil.getUserId());
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"gl_bill_accriskset", (String)"accounts,encodefilter", (QFilter[])filter.toArray());
            List<RiskControl> riskControls = Arrays.stream(loads).map(x -> {
                RiskControl riskControl = new RiskControl();
                riskControl.setId(x.getLong("id"));
                riskControl.setCondition(x.getString("encodefilter"));
                riskControl.setAccounts(x.getDynamicObjectCollection(AccRiskCtlPlugin.ACCOUNTS).stream().map(y -> y.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(y -> {
                    RiskControlAccount account = new RiskControlAccount();
                    account.setId(y.getLong("id"));
                    account.setNumber(y.getString("number"));
                    return account;
                }).collect(Collectors.toSet()));
                riskControl.setBalanceField(riskControl.getCondition().split("local")[0] + "local");
                riskControl.setBalanceCondition(riskControl.getCondition().split("AND")[0]);
                if (riskControl.getCondition().contains(AccRiskCtlPlugin.CURRENCY_NUMBER)) {
                    riskControl.setCurrencyCondition(riskControl.getCondition().split("AND")[1]);
                    String[] currencies = riskControl.getCurrencyCondition().split("'");
                    if (currencies.length == 2) {
                        riskControl.setCurrencyNumber(currencies[1]);
                    }
                }
                riskControl.setConditionDesc(RiskControlDAO.formatCondition(riskControl.getCondition()));
                return riskControl;
            }).collect(Collectors.toList());
            Set currencyNumbers = riskControls.stream().map(RiskControl::getCurrencyNumber).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            if (!currencyNumbers.isEmpty()) {
                Map currencies = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"number,name", (QFilter[])new QFilter("number", "in", currencyNumbers).toArray());
                Map<String, String> currencyNumberName = currencies.values().stream().collect(Collectors.toMap(x -> x.getString("number"), x -> x.getString("name"), (o, n) -> n));
                riskControls.forEach(x -> {
                    if (StringUtils.isNotEmpty((String)x.getCurrencyCondition()) && StringUtils.isNotEmpty((String)x.getCurrencyNumber())) {
                        x.setConditionDesc(x.getConditionDesc().replace(x.getCurrencyNumber(), currencyNumberName.getOrDefault(x.getCurrencyNumber(), "")));
                    }
                });
            }
            return riskControls;
        }

        private static String formatCondition(String condition) {
            return condition.replace(AccRiskCtlPlugin.CURRENCY_NUMBER, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"AccRiskCtlPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0])).replace("debitlocal", ResManager.loadKDString((String)"\u501f\u65b9\u53d1\u751f\u989d", (String)"AccRiskCtlPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0])).replace("creditlocal", ResManager.loadKDString((String)"\u8d37\u65b9\u53d1\u751f\u989d", (String)"AccRiskCtlPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0])).replace("endlocal", ResManager.loadKDString((String)"\u4f59\u989d", (String)"AccRiskCtlPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0])).replace("AND", ResManager.loadKDString((String)"\u5e76\u4e14", (String)"AccRiskCtlPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0])).replace("OR", ResManager.loadKDString((String)"\u6216\u8005", (String)"AccRiskCtlPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }
}

