/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.util.GLUtil;

public class AddendumAccEdit
extends AbstractBillPlugIn {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTITY_NAME = "gl_accedit";
    private static final String CASHFLOWITEM = "gl_cashflowitem";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterLoadData(EventObject e) {
        this.doLoadData();
        this.setFilter();
        this.getModel().setDataChanged(false);
    }

    private void setFilter() {
        String orgStr = (String)this.getView().getFormShowParameter().getCustomParam("org");
        String booktype = (String)this.getView().getFormShowParameter().getCustomParam("booktype");
        if (orgStr != null) {
            DynamicObject book = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)"id,accounttable.id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgStr)), new QFilter("bookstype", "=", (Object)Long.parseLong(booktype))});
            MulBasedataEdit accountCtl = (MulBasedataEdit)this.getControl("accounts");
            if (book != null) {
                long accountTabled = book.getLong("accounttable.id");
                accountCtl.setQFilter(new QFilter("accounttable", "=", (Object)accountTabled).and(new QFilter("enddate", ">=", (Object)GLUtil.getEndDate())));
            } else {
                accountCtl.setQFilter(new QFilter("1", "!=", (Object)"1", true));
            }
        }
    }

    private void doLoadData() {
        String org = (String)this.getView().getFormShowParameter().getCustomParam("org");
        if (org == null) {
            return;
        }
        DynamicObject[] items = this.queryCashFlowItem(Long.parseLong(org));
        ArrayList<Long> newItems = new ArrayList<Long>(items.length);
        HashMap<Long, DynamicObject> newItemMap = new HashMap<Long, DynamicObject>(items.length);
        for (DynamicObject item : items) {
            long id = item.getLong("id");
            newItems.add(id);
            newItemMap.put(id, item);
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        entryEntity.removeIf(dyn -> !newItems.contains(dyn.getLong("suppitem.id")));
        ArrayList<Long> oldItems = new ArrayList<Long>(entryEntity.size());
        for (DynamicObject dyn2 : entryEntity) {
            oldItems.add(dyn2.getLong("suppitem.id"));
        }
        ArrayList copy = new ArrayList(newItems);
        newItems.removeAll(oldItems);
        for (Long newItem : newItems) {
            int index = copy.indexOf(newItem);
            DynamicObject dd = new DynamicObject(entryEntity.getDynamicObjectType());
            dd.set("suppitem", newItemMap.get(newItem));
            dd.set("seq", (Object)(index + 1));
            entryEntity.add(index, dd);
        }
        int seq = 1;
        for (DynamicObject dyn3 : entryEntity) {
            dyn3.set("seq", (Object)seq++);
        }
    }

    public void afterCreateNewData(EventObject e) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String org = (String)this.getView().getFormShowParameter().getCustomParam("org");
        if (org == null) {
            return;
        }
        model.setValue("org", (Object)Long.valueOf(org));
        String booktype = (String)this.getView().getFormShowParameter().getCustomParam("booktype");
        if (booktype == null) {
            return;
        }
        model.setValue("booktype", (Object)Long.valueOf(booktype));
        DynamicObject[] dync = this.queryCashFlowItem(Long.parseLong(org));
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("suppitem", new Object[0]);
        vs.addField("accounts", new Object[0]);
        for (DynamicObject dyn : dync) {
            vs.addRow(new Object[]{dyn.getLong("id"), null});
        }
        model.deleteEntryData(ENTRYENTITY);
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        this.getView().updateView(ENTRYENTITY);
        this.setFilter();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
    }

    private DynamicObject[] queryCashFlowItem(long org) {
        QFilter supp = new QFilter("type", "=", (Object)"3");
        QFilter isleaf = new QFilter("isleaf", "=", (Object)true);
        QFilter netFilter = new QFilter("isprefit", "=", (Object)false);
        QFilter idFilter = BaseDataServiceHelper.getBaseDataFilter((String)CASHFLOWITEM, (Long)org);
        return BusinessDataServiceHelper.load((String)CASHFLOWITEM, (String)"id,name,type", (QFilter[])new QFilter[]{supp, isleaf, idFilter, netFilter}, (String)"number");
    }
}

