/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.UserAvatarEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.AccountType;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.formplugin.FPFormUtil;
import kd.fi.gl.formplugin.FlexBasedataBeforeF7SelectListener;
import kd.fi.gl.formplugin.finalprocess.FPAssgrpDescLengthConfig;
import kd.fi.gl.util.GLFabulousOperation;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PeriodEndingSolveUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.ValidateUtils;

public class AdjustExchangeRateEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String KEY_USERAVATAR = "useravatarfield";
    private static final String KEY_CREATOR = "creator";
    private static final String BTN_VIEWRATE = "viewrate";
    private static final String BTN_GENVOUCHER = "generatevoucher";
    private static final String BTN_QUERYVOUCHER = "queryvoucher";
    private static final String BTN_DELETEVOUCHER = "deletevoucher";

    public void afterLoadData(EventObject e) {
        long bookstypeId;
        long orgId;
        AccountBookInfo book;
        String bookstype;
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection coll = this.getModel().getEntryEntity("accountentry");
        for (DynamicObject row : coll) {
            DynamicObjectCollection assgrpEntry = row.getDynamicObjectCollection("assgrpentry");
            String desc = FPFormUtil.getDesc(assgrpEntry, FPAssgrpDescLengthConfig.fromProperty("gl_adjustexchangerate"));
            row.set("assgrpdesc", (Object)desc);
        }
        String org = model.getValue("org") == null ? null : ((DynamicObject)model.getValue("org")).toString();
        String string = bookstype = model.getValue("bookstype") == null ? null : ((DynamicObject)model.getValue("bookstype")).toString();
        if (org != null && bookstype != null && (book = AccSysUtil.getBookFromAccSys((long)(orgId = ((DynamicObject)model.getValue("org")).getLong("id")), (long)(bookstypeId = ((DynamicObject)model.getValue("bookstype")).getLong("id")))) != null) {
            long accountTableId = book.getAccountTableId();
            if (accountTableId == 0L) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u79d1\u76ee\u8868\uff0c\u8bf7\u5b8c\u5584\u3002", (String)"AdjustExchangeRateEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            this.initMulCurAdjustItem(orgId, bookstypeId);
        }
        this.setDptName();
        UserAvatarEdit image = (UserAvatarEdit)this.getControl(KEY_USERAVATAR);
        image.setRefBasedataProp(KEY_CREATOR);
    }

    private void initMulCurAdjustItem(Long orgId, Long booksTypeId) {
        ComboEdit mulCurAdjustEdit = (ComboEdit)this.getView().getControl("mulcuradjust");
        Collection configs = LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)booksTypeId);
        this.getView().setVisible(Boolean.valueOf(CollectionUtils.isNotEmpty((Collection)configs)), new String[]{"mulcuradjust"});
        ArrayList<ComboItem> mulCurAdjustItem = new ArrayList<ComboItem>(configs.size());
        for (LocalCurrencyConfigVO enableCurrency : configs) {
            ComboItem comboItem = new ComboItem();
            ILocaleString name = enableCurrency.getName();
            if (name instanceof LocaleString) {
                comboItem.setCaption((LocaleString)name);
            } else {
                comboItem.setCaption(LocaleString.fromMap((Map)name));
            }
            comboItem.setValue(enableCurrency.getNumber());
            mulCurAdjustItem.add(comboItem);
        }
        mulCurAdjustEdit.setComboItems(mulCurAdjustItem);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"assgrpdesc"});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        if (orgEdit != null) {
            orgEdit.addBeforeF7SelectListener(e -> {
                QFilter filter = AccSysUtil.getAcctOrgFilter((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
                ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter filterParam = showParam.getListFilterParameter();
                filterParam.getQFilters().add(filter);
            });
        }
        this.addItemClickListeners(new String[]{BTN_VIEWRATE});
        BasedataEdit loccurrency = (BasedataEdit)this.getControl("loccurrency");
        loccurrency.addBeforeF7SelectListener(e -> {
            IDataModel model = this.getModel();
            HashSet<Object> currencyPks = new HashSet<Object>();
            if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("mulcuradjust"))) || !"2".equals(this.getModel().getValue("adjuststyle"))) {
                long booksType;
                int locentryrow = model.getEntryRowCount("locentry");
                for (int i = 0; i < locentryrow; ++i) {
                    DynamicObject currency = (DynamicObject)model.getValue("loccurrency", i);
                    if (currency == null) continue;
                    currencyPks.add(currency.getPkValue());
                }
                long orgId = (Long)this.getModel().getValue("org_id");
                if (LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)(booksType = ((Long)this.getModel().getValue("bookstype_id")).longValue())).isEmpty() || StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("mulcuradjust")))) {
                    AccountBookInfo bookInfo = new AccountBookInfo(orgId, booksType);
                    currencyPks.add(bookInfo.getBaseCurrencyId());
                }
            }
            if (!currencyPks.isEmpty()) {
                QFilter filter = new QFilter("id", "not in", currencyPks);
                ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter filterParam = showParam.getListFilterParameter();
                filterParam.getQFilters().add(filter);
            }
        });
        BasedataEdit placcountid = (BasedataEdit)this.getControl("placcountid");
        BasedataEdit lossaccount = (BasedataEdit)this.getControl("lossaccount");
        placcountid.addBeforeF7SelectListener(e -> this.addAccountFilter(e, Boolean.FALSE, Boolean.TRUE));
        lossaccount.addBeforeF7SelectListener(e -> this.addAccountFilter(e, Boolean.FALSE, Boolean.TRUE));
        BasedataEdit accountid = (BasedataEdit)this.getControl("accountid");
        accountid.addBeforeF7SelectListener(e -> this.addAccountFilter(e, Boolean.TRUE, Boolean.FALSE));
        BasedataEdit vouchertypeid = (BasedataEdit)this.getControl("vouchertypeid");
        vouchertypeid.addBeforeF7SelectListener(e -> {
            long orgId = (Long)this.getModel().getValue("org_id");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgId);
            qFilters.add(qFilter);
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        });
        BasedataEdit bookstype = (BasedataEdit)this.getControl("bookstype");
        bookstype.addBeforeF7SelectListener(e -> {
            this.checkBookstype(e);
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            Object orgId = this.getModel().getValue("org_id");
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter("org", "=", orgId).toArray());
            ArrayList<Object> booktypeIds = new ArrayList<Object>();
            for (DynamicObject b : books) {
                booktypeIds.add(b.get("bookstype"));
            }
            showParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", booktypeIds));
            showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changeBook"));
        });
        BasedataEdit ass = (BasedataEdit)this.getControl("value");
        ass.addBeforeF7SelectListener((BeforeF7SelectListener)new FlexBasedataBeforeF7SelectListener());
        BasedataEdit tarCurCtrl = (BasedataEdit)this.getControl("tarcur");
        tarCurCtrl.addBeforeF7SelectListener(this::addTarCurFilter);
    }

    private void addTarCurFilter(BeforeF7SelectEvent e) {
        this.checkBookstype(e);
        String value = (String)this.getModel().getValue("mulcuradjust");
        HashSet<Long> mulCurIds = new HashSet<Long>();
        long orgId = (Long)this.getModel().getValue("org_id");
        long booksType = (Long)this.getModel().getValue("bookstype_id");
        AccountBookInfo bookInfo = new AccountBookInfo(orgId, booksType);
        mulCurIds.add(bookInfo.getBaseCurrencyId());
        if (value != null) {
            HashSet<String> mulCurItems = new HashSet<String>();
            Collections.addAll(mulCurItems, value.split(","));
            mulCurItems.removeIf(StringUtils::isBlank);
            for (LocalCurrencyConfigVO config : LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)booksType)) {
                if (!mulCurItems.contains(config.getNumber())) continue;
                mulCurIds.add(config.getCurrencyId(orgId, booksType));
            }
        }
        int row = e.getRow();
        Long srcCurId = (Long)this.getModel().getValue(GLField.id_((String)"loccurrency"), row);
        mulCurIds.remove(srcCurId);
        Map<Long, Set<Long>> curMap = this.getCurMap();
        mulCurIds.removeAll(curMap.getOrDefault(srcCurId, new HashSet()));
        e.addCustomQFilter(new QFilter("id", "in", mulCurIds));
    }

    private Map<Long, Set<Long>> getCurMap() {
        int entryRowCount = this.getModel().getEntryRowCount("locentry");
        HashMap<Long, Set<Long>> oriCurIds = new HashMap<Long, Set<Long>>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            Long locCurId = (Long)this.getModel().getValue(GLField.id_((String)"loccurrency"), i);
            Set mulCur = oriCurIds.getOrDefault(locCurId, new HashSet());
            mulCur.add((Long)this.getModel().getValue(GLField.id_((String)"tarcur"), i));
            oriCurIds.put(locCurId, mulCur);
        }
        return oriCurIds;
    }

    private void addAccountFilter(BeforeF7SelectEvent e, Boolean isChangeCurrency, boolean onlyLeafAccount) {
        if (!this.checkBookstype(e)) {
            return;
        }
        long orgId = (Long)this.getModel().getValue("org_id");
        long bookstype = (Long)this.getModel().getValue("bookstype_id");
        this.checkBook(bookstype);
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookstype);
        long accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookstype, (long)bookInfo.getCurPeriodId());
        String fieldChangeCurrency = "ischangecurrency";
        QFilter customeFilter = isChangeCurrency != false ? new QFilter(fieldChangeCurrency, "=", (Object)"1") : new QFilter(fieldChangeCurrency, "=", (Object)"0");
        String source = ((BasedataEdit)e.getSource()).getKey();
        String lossAcc = (String)this.getModel().getValue("adjusttype");
        if (source.equals("accountid") || source.equals("placcountid") || source.equals("lossaccount")) {
            this.setFinancialOrBudgeFilter(customeFilter, lossAcc);
        }
        QFBuilder accountFilter = kd.fi.gl.util.AccountUtils.getAccountFilter((long)orgId, (long)accountTableId, (long)bookInfo.getCurPeriodId(), (boolean)onlyLeafAccount, (QFilter)customeFilter);
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        filterParam.setQFilters(accountFilter.toList());
    }

    private void checkBook(long bookstype) {
        if (bookstype == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"TransPLProgramsEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkBookstype(BeforeF7SelectEvent e) {
        HashMap<String, Object> booktype;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AdjustExchangeRateEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        long orgId = 0L;
        long curOrgId = org.getLong("id");
        if (org != null && AccSysUtil.isBizUnit((long)curOrgId)) {
            orgId = curOrgId;
        }
        if (Long.parseLong((booktype = this.getAllBookByOrg(orgId)).get("bookstype").toString()) == 0L) {
            e.setCancel(true);
            return false;
        }
        return true;
    }

    private void setFinancialOrBudgeFilter(QFilter qFilter, String acc) {
        if ("1".equals(acc)) {
            qFilter.and(new QFilter("accounttype.accounttype", "in", (Object)AccountType.FINANCIAL_ACCOUNT));
        } else {
            qFilter.and(new QFilter("accounttype.accounttype", "in", (Object)AccountType.BUDGET_ACCOUNT));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_VIEWRATE.equals(key)) {
            String whpjUrl = "http://www.boc.cn/sourcedb/whpj/";
            this.getView().openUrl(whpjUrl);
        }
    }

    public void afterCopyData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_GENVOUCHER, BTN_QUERYVOUCHER, BTN_DELETEVOUCHER});
        Object mulCurChoose = this.getModel().getValue("mulcuradjust");
        Object adjustStyle = this.getModel().getValue("adjuststyle");
        if (!"2".equals(adjustStyle) || StringUtils.isBlank((Object)mulCurChoose) || ",,".equals(mulCurChoose)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tarcur"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_GENVOUCHER, BTN_QUERYVOUCHER, BTN_DELETEVOUCHER});
        this.getModel().setValue("voucherdesc", (Object)ResManager.loadKDString((String)"\u671f\u672b\u8c03\u6c47", (String)"AdjustExchangeRateEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("voucherdatetype", (Object)"1");
        this.setDptName();
        this.setDefaultVouchertype();
        long orgId = (Long)this.getModel().getValue("org_id");
        List orgIds = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
        if (orgIds == null || orgIds.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"titlepanelflex", "contentpanelflex"});
        } else if (!orgIds.contains(orgId)) {
            this.getModel().setValue("org", null);
        }
        this.setVisibleWhileAdjustRateByAssignedDate();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultHeart();
        IDataModel model = this.getModel();
        DynamicObject book = (DynamicObject)this.getModel().getValue("bookstype");
        if (book != null) {
            String bookId = book.getString("id");
            this.getPageCache().put("oldBookId", bookId);
        }
        this.setPlAccountTitle((Boolean)this.getModel().getValue("bypl"));
        this.setVisibleWhileAdjustRateByAssignedDate();
        if (this.getModel().getValue("adjusttype") == null) {
            this.setAdjustType();
        }
        long orgId = Long.parseLong(String.valueOf(model.getValue("org_id")));
        long bookTypeId = Long.parseLong(String.valueOf(model.getValue("bookstype_id")));
        this.setAdjustTypeVisible(orgId, bookTypeId);
        this.initMulCurAdjustItem(orgId, bookTypeId);
    }

    private void setAdjustTypeVisible(long orgId, long booksTypeId) {
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)booksTypeId);
        if (accountBookInfo == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjusttype"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(accountBookInfo.isBudget()), new String[]{"adjusttype"});
    }

    private void setAdjustType() {
        IDataModel model = this.getModel();
        Object plAccDyn = model.getValue("placcountid");
        if (plAccDyn == null) {
            model.setValue("adjusttype", (Object)"1");
            return;
        }
        Long value = ((DynamicObject)plAccDyn).getLong("id");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"accounttype.accounttype", (QFilter[])new QFilter("id", "=", (Object)value).toArray());
        String accType = dyn.getString("accounttype.accounttype");
        if (AccountType.isBudGetType((String)accType)) {
            model.setValue("adjusttype", (Object)"2");
        } else {
            model.setValue("adjusttype", (Object)"1");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("changeBook".equals(actionId)) {
            String oldId = this.getPageCache().get("oldBookId");
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (rows.size() == 0) {
                return;
            }
            long newId = (Long)rows.get(0).getPrimaryKeyValue();
            this.getPageCache().put("newBookId", newId + "");
            if (!(newId + "").equals(oldId)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8d26\u7c3f\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"AdjustExchangeRateEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("submit", (IFormPlugin)this));
            }
        } else if ("assgrpdesc".equals(actionId)) {
            Map returnParams = (Map)returnData;
            Object rowIndexObj = returnParams.get("index");
            if (rowIndexObj == null) {
                return;
            }
            int rowIndex = Integer.parseInt(rowIndexObj.toString());
            Object jsonVal = returnParams.get("json");
            if (StringUtils.isNotBlank(jsonVal)) {
                DynamicObjectCollection returnDyns = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)jsonVal.toString());
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("accountentry", rowIndex);
                String express = (String)returnParams.get("express");
                if (StringUtils.isNotBlank((CharSequence)express)) {
                    express = express.length() <= 50 ? express : express.substring(0, 50);
                    rowEntity.set("assgrpdesc", (Object)express);
                }
                this.setSubEntryData(rowEntity, returnDyns);
                this.getView().updateView("accountentry");
            }
        }
    }

    private void setSubEntryData(DynamicObject rowEntity, DynamicObjectCollection returnDyns) {
        DynamicObjectCollection subEntries = rowEntity.getDynamicObjectCollection("assgrpentry");
        subEntries.clear();
        for (DynamicObject returnRow : returnDyns) {
            DynamicObject newRow = subEntries.addNew();
            newRow.set("fieldname_id", (Object)returnRow.getLong("fieldname_id"));
            String valuetype = returnRow.getString("fieldname.valuetype");
            if ("3".equals(valuetype)) {
                newRow.set("txtval", (Object)returnRow.getString("txtval"));
                continue;
            }
            DynamicObjectCollection newBaseDataVals = newRow.getDynamicObjectCollection("value");
            newBaseDataVals.clear();
            DynamicObjectCollection baseDataVals = returnRow.getDynamicObjectCollection("value");
            if (baseDataVals != null && !baseDataVals.isEmpty()) {
                for (DynamicObject baseDataVal : baseDataVals) {
                    DynamicObject newBaseDataVal = newBaseDataVals.addNew();
                    newBaseDataVal.set("fbasedataid_id", (Object)baseDataVal.getLong("fbasedataid_id"));
                }
            }
            newRow.set("value", (Object)newBaseDataVals);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes) {
            IFormView formView = (IFormView)e.getSource();
            String bookid = this.getPageCache().get("newBookId");
            this.getPageCache().put("exchangeBook", "true");
            PeriodEndingSolveUtil.exchangeBook(formView, bookid, "bookstype");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("thumbimg".equals(key)) {
            this.doFabulous();
        } else if ("assgrpdesc".equals(key)) {
            this.showAssgrpEdit();
        }
    }

    private void showAssgrpEdit() {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("accountentry");
        if (rowIndex < 0) {
            return;
        }
        DynamicObject entryRowEntity = model.getEntryRowEntity("accountentry", rowIndex);
        if (entryRowEntity == null) {
            return;
        }
        DynamicObject accountDyn = entryRowEntity.getDynamicObject("accountid");
        if (accountDyn == null || !accountDyn.getBoolean("isassist")) {
            return;
        }
        String jsonVal = null;
        DynamicObjectCollection assgrpEntryVals = entryRowEntity.getDynamicObjectCollection("assgrpentry");
        if (assgrpEntryVals != null && !assgrpEntryVals.isEmpty()) {
            jsonVal = SerializationUtils.serializeToBase64((Object)assgrpEntryVals);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)jsonVal)) {
            customParams.put("json", jsonVal);
        }
        customParams.put("index", rowIndex);
        Object orgId = model.getValue("org_id");
        Object bookstypeId = model.getValue("bookstype_id");
        customParams.put("orgId", orgId);
        customParams.put("accountId", accountDyn.getPkValue());
        customParams.put("donotquery", true);
        customParams.put("bookstypeId", bookstypeId);
        FPFormUtil.showFinalProcessAssgrpEdit(this.getView(), new CloseCallBack((IFormPlugin)this, "assgrpdesc"), customParams);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_GENVOUCHER, BTN_QUERYVOUCHER, BTN_DELETEVOUCHER});
        } else if (BTN_QUERYVOUCHER.equalsIgnoreCase(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            FPFormUtil.queryVcouher(this.getView());
        }
    }

    public void doFabulous() {
        Long creator = ((DynamicObject)this.getModel().getValue(KEY_CREATOR)).getLong("id");
        if (GLFabulousOperation.isCanThumbUp((long)creator, (String)"gl_adjustexchangerate")) {
            GLFabulousOperation.createFabulous((long)creator, (String)"gl_adjustexchangerate");
            this.setDefaultHeart();
        }
    }

    public void setDefaultHeart() {
        Long creator = ((DynamicObject)this.getModel().getValue(KEY_CREATOR)).getLong("id");
        Label heart = (Label)this.getControl("heart");
        if (creator != 0L) {
            int heartQu = GLFabulousOperation.getFabulousOne((Long)creator, null, (boolean)false, (boolean)true);
            heart.setText(String.valueOf(heartQu));
        } else {
            heart.setText(String.valueOf(0));
        }
        if (!GLFabulousOperation.isThumbUp((long)creator, (String)"gl_adjustexchangerate")) {
            ((Image)this.getControl("thumbimg")).setUrl("/icons/pc/state/praised.png");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        AccountBookInfo book;
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        String org = null;
        String bookstype = null;
        long orgId = 0L;
        long bookstypeId = 0L;
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (key.equals("assgrpdesc") && changeData.getNewValue().equals("")) {
            this.getModel().deleteEntryData("assgrpentry");
        }
        if (key.equals("org")) {
            org = ((DynamicObject)model.getValue("org")).toString();
        } else {
            String string = org = model.getValue("org") == null ? null : ((DynamicObject)model.getValue("org")).toString();
        }
        if (key.equals("bookstype")) {
            if (null == model.getValue("bookstype")) {
                return;
            }
            bookstype = ((DynamicObject)model.getValue("bookstype")).toString();
        } else {
            String string = bookstype = model.getValue("bookstype") == null ? null : ((DynamicObject)model.getValue("bookstype")).toString();
        }
        if (org != null && bookstype != null && (book = AccSysUtil.getBookFromAccSys((long)(orgId = ((DynamicObject)model.getValue("org")).getLong("id")), (long)(bookstypeId = ((DynamicObject)model.getValue("bookstype")).getLong("id")))) != null) {
            long accountTableId = book.getAccountTableId();
            if (accountTableId == 0L) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u79d1\u76ee\u8868\uff0c\u8bf7\u5b8c\u5584\u3002", (String)"AdjustExchangeRateEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("bookstype".equals(key)) {
                this.setAdjustTypeVisible(orgId, bookstypeId);
                this.getModel().setValue("adjusttype", (Object)"1");
                if (changeData.getNewValue() != null) {
                    this.getPageCache().put("newBookId", ((DynamicObject)changeData.getNewValue()).getPkValue() + "");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8d26\u7c3f\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"AdjustExchangeRateEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("submit", (IFormPlugin)this));
                }
            }
        }
        if (key.equals("setaccountgroup")) {
            this.clearAccountEntry();
        } else if (key.equals("setcuruencygroup")) {
            this.clearCuruencyEntry();
        } else if ("adjuststyle".equals(key)) {
            if (!"2".equals(changeData.getNewValue())) {
                this.removeDuplicationCur(this.getModel(), "adjuststyle");
            }
            this.setVisibleWhileAdjustRateByAssignedDate();
        } else if ("loccurrency".equals(key)) {
            if ("2".equals(model.getValue("adjuststyle"))) {
                this.fillRate(rowIndex);
            }
        } else if ("rate".equals(key)) {
            newValue = changeData.getNewValue();
            if (newValue instanceof BigDecimal) {
                BigDecimal newDecimalVal = (BigDecimal)newValue;
                this.setScale(rowIndex, newDecimalVal, model);
            }
        } else if ("bypl".equals(key)) {
            newValue = (Boolean)changeData.getNewValue();
            this.setPlAccountTitle((Boolean)newValue);
            model.setValue("lossaccount", ((Boolean)newValue).booleanValue() ? model.getValue("placcountid") : null);
        } else if ("accountid".equals(key)) {
            this.clearAssgrp(changeData.getRowIndex());
        } else if ("adjusttype".equals(key)) {
            newValue = (String)changeData.getNewValue();
            if (StringUtils.isNotBlank((Object)changeData.getOldValue()) && StringUtils.isNotEmpty((CharSequence)newValue)) {
                this.clearAccount();
            }
        }
        switch (key) {
            case "mulcuradjust": {
                String oldValue = String.valueOf(changeData.getOldValue());
                String newValue2 = String.valueOf(changeData.getNewValue() == null ? "" : changeData.getNewValue());
                if (!StringUtils.isNotBlank((Object)changeData.getOldValue()) || oldValue.length() <= newValue2.length()) break;
                this.removeDuplicationCur(this.getModel(), "mulcuradjust");
                break;
            }
            case "tarcur": {
                if (!"2".equals(model.getValue("adjuststyle"))) break;
                this.fillRate(rowIndex);
            }
        }
    }

    private void removeDuplicationCur(IDataModel model, String field) {
        DynamicObjectCollection locEntryDyn = (DynamicObjectCollection)model.getValue("locentry");
        long orgId = (Long)model.getValue("org_id");
        long booksType = (Long)model.getValue("bookstype_id");
        AccountBookInfo bookInfo = new AccountBookInfo(orgId, booksType);
        String mulCurChoose = (String)model.getValue("mulcuradjust");
        boolean mulCurIsEmpty = StringUtils.isBlank((CharSequence)mulCurChoose);
        Map<String, Long> numToIds = LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)booksType).stream().collect(Collectors.toMap(LocalCurrencyConfigVO::getNumber, configVO -> configVO.getCurrencyId(orgId, booksType)));
        if ("mulcuradjust".equals(field)) {
            if ("2".equals(model.getValue("adjuststyle"))) {
                HashSet<Long> chooseTarId = new HashSet<Long>(numToIds.size());
                if (!mulCurIsEmpty) {
                    chooseTarId.addAll(Arrays.stream(mulCurChoose.split(",")).map(numToIds::get).collect(Collectors.toSet()));
                }
                chooseTarId.add(bookInfo.getBaseCurrencyId());
                locEntryDyn.removeIf(dynamicObject -> !chooseTarId.contains(dynamicObject.getLong(GLField.id_((String)"tarcur"))));
            } else {
                HashSet<Long> chooseLocId = new HashSet<Long>(locEntryDyn.size());
                Iterator iterator = locEntryDyn.iterator();
                while (iterator.hasNext()) {
                    DynamicObject next = (DynamicObject)iterator.next();
                    if (chooseLocId.contains(next.getLong(GLField.id_((String)"loccurrency")))) {
                        iterator.remove();
                        continue;
                    }
                    chooseLocId.add(next.getLong(GLField.id_((String)"loccurrency")));
                }
            }
            if (mulCurIsEmpty) {
                locEntryDyn.removeIf(dynamicObject -> bookInfo.getBaseCurrencyId() == dynamicObject.getLong(GLField.id_((String)"loccurrency")));
            }
        } else {
            Optional<DynamicObject> first = locEntryDyn.stream().filter(dynamicObject -> bookInfo.getBaseCurrencyId() == dynamicObject.getLong(GLField.id_((String)"loccurrency"))).findFirst();
            locEntryDyn.removeIf(dynamicObject -> numToIds.containsValue(dynamicObject.getLong(GLField.id_((String)"tarcur"))));
            if (!mulCurIsEmpty && first.isPresent()) {
                DynamicObject newRow = locEntryDyn.addNew();
                newRow.set("loccurrency", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)bookInfo.getBaseCurrencyId(), (String)"bd_currency"));
            }
        }
        this.getView().updateView("locentry");
    }

    private void clearAccount() {
        IDataModel model = this.getModel();
        this.clearAccountEntry();
        model.setValue("placcountid", null);
        model.setValue("lossaccount", null);
    }

    private void setVisibleWhileAdjustRateByAssignedDate() {
        String adjustRateByAssignedDate = "3";
        boolean visible = false;
        IFormView v = this.getView();
        IDataModel m = this.getModel();
        visible = m.getValue("adjuststyle").equals(adjustRateByAssignedDate) ? true : visible;
        v.setVisible(Boolean.valueOf(visible), new String[]{"asigneddateratepanel"});
    }

    private void clearAssgrp(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("assgrpdesc", (Object)"", rowIndex);
        model.getEntryRowEntity("accountentry", rowIndex).getDynamicObjectCollection("assgrpentry").clear();
    }

    private void setPlAccountTitle(Boolean newValue) {
        BasedataEdit lossAccountEdit = (BasedataEdit)this.getControl("lossaccount");
        lossAccountEdit.setMustInput(newValue.booleanValue());
        BasedataEdit plAccountEdit = (BasedataEdit)this.getControl("placcountid");
        FlexEdit assgrpEdit = (FlexEdit)this.getControl("assgrp");
        if (newValue.booleanValue()) {
            plAccountEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6c47\u5151\u6536\u76ca\u79d1\u76ee", (String)"AdjustExchangeRateEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0])));
            assgrpEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u76ca\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6", (String)"AdjustExchangeRateEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        } else {
            plAccountEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6c47\u5151\u635f\u76ca\u79d1\u76ee", (String)"AdjustExchangeRateEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0])));
            assgrpEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u635f\u76ca\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6", (String)"AdjustExchangeRateEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        }
    }

    private void fillRate(int rowIndex) {
        if (rowIndex >= 0) {
            DynamicObject curPeriodDyn;
            AccountBookInfo accountBookInfo;
            long bookTypeId;
            IDataModel model = this.getModel();
            long orgId = model.getValue("org") == null ? 0L : (Long)model.getValue("org_id");
            long l = bookTypeId = model.getValue("bookstype") == null ? 0L : (Long)model.getValue("bookstype_id");
            if (orgId != 0L && bookTypeId != 0L && (accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId)) != null && (curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)accountBookInfo.getCurPeriodId()).toArray())) != null) {
                boolean fillRate;
                long currencyId = (Long)model.getValue("loccurrency_id", rowIndex);
                long tarCurId = (Long)model.getValue(GLField.id_((String)"tarcur"), rowIndex);
                long exRateTableId = accountBookInfo.getExrateTableId();
                long baseCurrencyId = accountBookInfo.getBaseCurrencyId();
                Collection vos = LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)bookTypeId);
                Optional<LocalCurrencyConfigVO> config = vos.stream().filter(configVO -> configVO.getCurrencyId(orgId, bookTypeId) == tarCurId).findFirst();
                if (model.getValue("mulcuradjust") == null || vos.isEmpty()) {
                    fillRate = currencyId != 0L;
                } else {
                    exRateTableId = config.map(configVO -> configVO.getExRateTableId(orgId, bookTypeId)).orElse(exRateTableId);
                    baseCurrencyId = config.map(configVO -> configVO.getCurrencyId(orgId, bookTypeId)).orElse(baseCurrencyId);
                    boolean bl = fillRate = currencyId != 0L && tarCurId != 0L;
                }
                if (fillRate) {
                    BigDecimal exchangeRate = GLUtil.getExchangeRate((Long)exRateTableId, (Long)currencyId, (Long)baseCurrencyId, (Date)curPeriodDyn.getDate("enddate"));
                    model.setValue("rate", (Object)exchangeRate, rowIndex);
                    String scale = exchangeRate == null ? "8" : String.valueOf(exchangeRate.scale());
                    this.getPageCache().put("rate-scale-" + rowIndex, scale);
                }
            }
        }
    }

    private void setScale(int rowIndex, BigDecimal newDecimalVal, IDataModel model) {
        if (rowIndex > -1) {
            newDecimalVal = newDecimalVal.setScale(this.getScaleFromCache(rowIndex), RoundingMode.HALF_UP);
            model.setValue("rate", (Object)newDecimalVal, rowIndex);
        }
    }

    private int getScaleFromCache(int rowIndex) {
        AccountBookInfo accountBookInfo;
        long bookTypeId;
        IPageCache cache = this.getPageCache();
        String scale = cache.get("rate-scale-" + rowIndex);
        if (StringUtils.isNotBlank((CharSequence)scale)) {
            return Integer.parseInt(scale);
        }
        IDataModel model = this.getModel();
        long orgId = model.getValue("org") == null ? 0L : (Long)model.getValue("org_id");
        long l = bookTypeId = model.getValue("bookstype") == null ? 0L : (Long)model.getValue("bookstype_id");
        if (orgId != 0L && bookTypeId != 0L && (accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId)) != null) {
            long currencyId = (Long)model.getValue("loccurrency_id", rowIndex);
            DynamicObject curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)accountBookInfo.getCurPeriodId()).toArray());
            if (curPeriodDyn != null) {
                int scaleIntVal = GLUtil.getRatePrecision((Long)accountBookInfo.getExrateTableId(), (Long)currencyId, (Long)accountBookInfo.getBaseCurrencyId(), (Date)curPeriodDyn.getDate("enddate"));
                cache.put("rate-scale-" + rowIndex, String.valueOf(scaleIntVal));
                return scaleIntVal;
            }
        }
        return 8;
    }

    private void clearAccountEntry() {
        if (this.getModel().getEntryRowCount("accountentry") == 0) {
            return;
        }
        this.getModel().deleteEntryData("accountentry");
    }

    private void clearCuruencyEntry() {
        if (this.getModel().getEntryRowCount("locentry") == 0) {
            return;
        }
        this.getModel().deleteEntryData("locentry");
    }

    private void setDptName() {
        DynamicObject creator = (DynamicObject)this.getModel().getValue(KEY_CREATOR);
        if (creator != null) {
            Long creatorId = creator.getLong("id");
            String selectField = "id,entryentity.dpt,entryentity.ispartjob,name";
            QFilter idFilter = new QFilter("id", "=", (Object)creatorId);
            HashMap<String, Long> userDpt = new HashMap<String, Long>();
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl.TransPLProgramEditPlugin.getDptNameByUserId", (String)"bos_user", (String)selectField, (QFilter[])new QFilter[]{idFilter}, (String)"");
            if (collection.size() == 0) {
                return;
            }
            for (DynamicObject userObj : collection) {
                boolean ispartjob = userObj.getBoolean("entryentity.ispartjob");
                Long dpt = 0L;
                if (!ispartjob) {
                    dpt = (Long)userObj.get("entryentity.dpt");
                    userDpt.put("dpt", dpt);
                    continue;
                }
                userDpt.put("dpt", dpt);
            }
            this.getModel().setValue("dptnames", userDpt.get("dpt"));
        }
    }

    private void setDefaultVouchertype() {
        long orgId;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            orgId = AccSysUtil.getAccountingOrg((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.NEW);
        } else {
            orgId = org.getLong("id");
            if (!AccSysUtil.isBizUnit((long)orgId)) {
                orgId = AccSysUtil.getAccountingOrg((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.NEW);
            }
        }
        model.setValue("org", (Object)orgId);
        String exchangeBook = this.getPageCache().get("exchangeBook");
        if (exchangeBook == null) {
            HashMap<String, Object> booktype = this.getAllBookByOrg(orgId);
            model.setValue("bookstype", booktype.get("bookstype"));
            model.setValue("ismultiplebook", booktype.get("ismultiplebook"));
            model.setValue("vouchertypeid", booktype.get("vouchertype"));
            model.setValue("exratetable", booktype.get("exratetable"));
        } else {
            DynamicObject curOrg = (DynamicObject)this.getModel().getContextVariable("org");
            model.setValue("org", (Object)curOrg);
            model.setValue("ismultiplebook", (Object)"1");
            this.getPageCache().remove("exchangeBook");
        }
    }

    private HashMap<String, Object> getAllBookByOrg(Long orgId) {
        HashMap<String, Object> bookInfoMap = new HashMap<String, Object>();
        List bookIdLIst = AccSysUtil.getAllBookFromAccSys((long)orgId);
        if (bookIdLIst.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4f53\u7cfb\u4e0b\u6ca1\u6709\u8d26\u7c3f\uff0c\u8bf7\u6dfb\u52a0\u8d26\u7c3f\u540e\u91cd\u8bd5\u3002", (String)"AdjustExchangeRateEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            bookInfoMap.put("bookstype", 0);
            bookInfoMap.put("ismultiplebook", "0");
        } else {
            bookInfoMap.put("ismultiplebook", bookIdLIst.size() > 1 ? "1" : "0");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object booktypeId = customParams.get("bookstype");
            Map books = BusinessDataServiceHelper.loadFromCache((Object[])bookIdLIst.toArray(), (String)"gl_accountbook");
            DynamicObject mainBook = null;
            if (booktypeId != null) {
                for (Long id : bookIdLIst) {
                    long btypeid = ((DynamicObject)books.get(id)).getLong("bookstype_id");
                    if (btypeid != Long.parseLong(booktypeId.toString())) continue;
                    mainBook = (DynamicObject)books.get(id);
                    break;
                }
                if (mainBook == null) {
                    mainBook = (DynamicObject)books.get(bookIdLIst.get(0));
                }
            } else {
                mainBook = (DynamicObject)books.get(bookIdLIst.get(0));
            }
            bookInfoMap.put("bookstype", mainBook.getLong("bookstype.id"));
            if (mainBook.getDynamicObject("defaultvouchertype") != null) {
                bookInfoMap.put("vouchertype", mainBook.getLong("defaultvouchertype.id"));
            }
            long exrateTableId = mainBook.getLong("exratetable.id");
            bookInfoMap.put("exratetable", exrateTableId);
        }
        return bookInfoMap;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        if (data != null) {
            long bookTypeId;
            Boolean bypl = data.get("bypl") == null ? Boolean.FALSE : (Boolean)data.get("bypl");
            String orgNum = (String)((Map)data.get("org")).get("number");
            String bookTypeNum = (String)((Map)data.get("bookstype")).get("number");
            long orgId = ValidateUtils.checkLegalOrg((String)orgNum);
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)(bookTypeId = this.getBookTypeIdByNumber(bookTypeNum).longValue()));
            if (bookInfo == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u8d26\u7c3f\u7c7b\u578b%2$s\u4e0b\u6ca1\u6709\u53ef\u7528\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"AdjustExchangeRateEdit_15", (String)"fi-gl-formplugin", (Object[])new Object[0]), orgNum, bookTypeNum));
            }
            Map plAccount = (Map)data.get("placcountid");
            String placcountid = plAccount.get("number") == null ? "" : (String)plAccount.get("number");
            DynamicObject plAccountDyn = this.getAccount(bookInfo, placcountid);
            if (plAccountDyn == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%1$s\u7684\u6c47\u5151\u635f\u76ca(\u6536\u76ca)\u79d1\u76ee\u6ca1\u6709\u53ef\u7528\u4f1a\u8ba1\u79d1\u76ee\u3002", (String)"AdjustExchangeRateEdit_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), placcountid));
            }
            plAccount.put("id", plAccountDyn.getLong("id"));
            boolean plIsBudget = AccountType.isBudGetType((String)plAccountDyn.getString("accounttype.accounttype"));
            Map lossAccount = (Map)data.get("lossaccount");
            DynamicObject lossAccountDyn = null;
            if (lossAccount != null) {
                String lossAccountId = lossAccount.get("number") == null ? "" : (String)lossAccount.get("number");
                lossAccountDyn = this.getAccount(bookInfo, lossAccountId);
                if (lossAccountDyn == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%1$s\u7684\u6c47\u5151\u635f\u5931\u79d1\u76ee\u6ca1\u6709\u53ef\u7528\u4f1a\u8ba1\u79d1\u76ee\u3002", (String)"AdjustExchangeRateEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), lossAccountId));
                }
                lossAccount.put("id", lossAccountDyn.getLong("id"));
                if (bypl.booleanValue() && plIsBudget != AccountType.isBudGetType((String)lossAccountDyn.getString("accounttype.accounttype"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6c47\u5151\u635f\u5931\u79d1\u76ee%1$s\u7684\u7c7b\u578b\uff08\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee/\u8d22\u52a1\u4f1a\u8ba1\u79d1\u76ee\uff09\u4e0e\u6c47\u5151\u635f\u76ca(\u6536\u76ca)\u79d1\u76ee%2$s\u7684\u7c7b\u578b\u5fc5\u987b\u4e00\u81f4\u3002", (String)"AdjustExchangeRateEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), lossAccountId, placcountid));
                }
            }
            String isSetAccount = (String)data.get("setaccountgroup");
            List accountEntryList = data.getOrDefault("accountentry", new ArrayList());
            if ("2".equals(isSetAccount)) {
                if (accountEntryList != null && accountEntryList.size() > 0) {
                    accountEntryList.forEach(accountEntry -> {
                        Map designatedAcc = (Map)((Map)accountEntry).get("accountid");
                        if (designatedAcc == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u79d1\u76ee\u8c03\u6c47\u65f6\uff0c\u5fc5\u987b\u5f55\u5165\u6307\u5b9a\u79d1\u76ee\u3002", (String)"AdjustExchangeRateEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), new Object[0]));
                        }
                        String accountNumber = (String)designatedAcc.get("number");
                        DynamicObject accountDyn = this.getAccount(bookInfo, accountNumber);
                        if (accountDyn != null) {
                            designatedAcc.put("id", accountDyn.getLong("id"));
                            if (plIsBudget != AccountType.isBudGetType((String)accountDyn.getString("accounttype.accounttype"))) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u79d1\u76ee%1$s\u7684\u7c7b\u578b\uff08\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee/\u8d22\u52a1\u4f1a\u8ba1\u79d1\u76ee\uff09\u4e0e\u6c47\u5151\u635f\u76ca(\u6536\u76ca)\u79d1\u76ee%2$s\u7684\u7c7b\u578b\u5fc5\u987b\u4e00\u81f4\u3002", (String)"AdjustExchangeRateEdit_12", (String)"fi-gl-formplugin", (Object[])new Object[0]), accountNumber, placcountid));
                            }
                            if (!accountDyn.getBoolean("ischangecurrency")) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u79d1\u76ee%1$s\u672a\u52fe\u9009\u671f\u672b\u8c03\u6c47\u3002", (String)"AdjustExchangeRateEdit_14", (String)"fi-gl-formplugin", (Object[])new Object[0]), accountNumber));
                            }
                        }
                    });
                }
            } else {
                accountEntryList.clear();
            }
            Collection mulCurConfig = LocalCurrencyConfigService.queryEnableCurrencies((long)bookInfo.getOrgId(), (long)bookInfo.getBookTypeId());
            String mulCurAdjust = (String)data.get("mulcuradjust");
            if (StringUtils.isNotBlank((CharSequence)mulCurAdjust)) {
                Map<String, String> collect = mulCurConfig.stream().collect(Collectors.toMap(configVO -> configVO.getName().getLocaleValue(), LocalCurrencyConfigVO::getNumber));
                for (Map.Entry<String, String> entry : collect.entrySet()) {
                    mulCurAdjust = mulCurAdjust.replace(entry.getKey(), entry.getValue());
                }
                data.put("mulcuradjust", mulCurAdjust);
                String finalMulCurAdjust = mulCurAdjust;
                mulCurConfig = mulCurConfig.stream().filter(configVO -> finalMulCurAdjust.contains(configVO.getNumber())).collect(Collectors.toSet());
            }
            JSONArray locEntry = (JSONArray)data.get("locentry");
            String adjustStyle = (String)data.get("adjuststyle");
            if (mulCurConfig.isEmpty() || !"2".equals(adjustStyle)) {
                boolean validate = true;
                if (!locEntry.isEmpty()) {
                    for (int i = 0; i < locEntry.size(); ++i) {
                        if (locEntry.getJSONObject(i).getJSONObject("tarcur") == null) continue;
                        validate = false;
                        break;
                    }
                }
                if (!validate) {
                    String mes = mulCurConfig.isEmpty() ? ResManager.loadKDString((String)"\u5f00\u542f\u672c\u4f4d\u5e01", (String)"AdjustExchangeRateEdit_18", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8c03\u6c47\u65b9\u5f0f\u4e3a\u201c\u6309\u6307\u5b9a\u6c47\u7387\u201d", (String)"AdjustExchangeRateEdit_17", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a %1$s\u7684\u65b9\u6848\uff0c%2$s\u65f6\u624d\u53ef\u4ee5\u586b\u5199\u76ee\u6807\u5e01\u5e01\u522b\u3002", (String)"AdjustExchangeRateEdit_16", (String)"fi-gl-formplugin", (Object[])new Object[0]), data.get("billno"), mes));
                }
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObjectCollection acctSetupEntries = this.getModel().getEntryEntity("accountentry");
        String isMultipleBook = AccSysUtil.getAllBookFromAccSys((long)((Long)this.getModel().getValue("org_id"))).size() > 1 ? "1" : "0";
        this.getModel().setValue("ismultiplebook", (Object)isMultipleBook);
        this.parseAssistSetup(acctSetupEntries);
        if (this.getModel().getValue("adjusttype") == null) {
            this.setAdjustType();
        }
    }

    private void parseAssistSetup(DynamicObjectCollection acctSetupEntries) {
        acctSetupEntries.forEach(FPFormUtil::createAssistSetupAfterImport);
    }

    private Long getBookTypeIdByNumber(String bookTypeNumber) {
        QFilter orgFilter = new QFilter("number", "=", (Object)bookTypeNumber);
        DynamicObject accountBooksType = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{orgFilter});
        return accountBooksType == null ? 0L : accountBooksType.getLong("id");
    }

    private DynamicObject getAccount(AccountBookInfo bookInfo, String accountNumber) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("number", "=", (Object)accountNumber));
        qFilters.add(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
        QFilter ctrlFilter = AccountUtils.getAccountDataFilter((long)bookInfo.getOrgId(), (long)bookInfo.getAccountTableId(), qFilters);
        return QueryServiceHelper.queryOne((String)"bd_accountview", (String)String.join((CharSequence)",", "id", "accounttype.accounttype", "ischangecurrency"), (QFilter[])ctrlFilter.toArray());
    }
}

