/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.gl.formplugin.FlexBasedataBeforeF7SelectListener;
import kd.fi.gl.util.GLUtil;

public class AssgrpDefValEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String Key_Entry = "entryentity";
    private static final String Key_Account = "account";
    private static final String Key_Assgrp = "assgrptype";
    private static final String Key_BaseVal = "basedataval";
    private static final String Key_TxtVal = "txtval";
    private static final String Key_BasePk = "basepk";
    private static final String Key_Currency = "currency";
    private static final String Key_ASSGRP_NAME = "assgrpname";
    private static final String Key_ASSGRP_NUMBER = "assgrpnumber";
    private static final String ASSIST_DETAIL = "bos_assistantdata_detail";
    private static final Log logger = LogFactory.getLog(AssgrpDefValEdit.class);

    public void registerListener(EventObject e) {
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex(Key_Entry);
        long orgid = (Long)model.getValue("org_id");
        BasedataEdit accountEdit = (BasedataEdit)this.getControl(Key_Account);
        Long accounttableid = (Long)model.getValue("accounttable_id");
        accountEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("accounttable", "=", (Object)accounttableid));
            qFilters.add(new QFilter("isassist", "=", (Object)Boolean.TRUE));
        });
        accountEdit.addAfterF7SelectListener(paramAfterF7SelectEvent -> this.clearNoDataRow());
        BasedataEdit assgrpEdit = (BasedataEdit)this.getControl(Key_Assgrp);
        ArrayList<Object> assgrppks = new ArrayList<Object>();
        DynamicObject account = (DynamicObject)model.getValue(Key_Account, row);
        if (account != null) {
            DynamicObjectCollection col = account.getDynamicObjectCollection("checkitementry");
            for (DynamicObject dyn : col) {
                DynamicObject assgrp = dyn.getDynamicObject("asstactitem");
                if (assgrp == null) continue;
                assgrppks.add(assgrp.getPkValue());
            }
        } else {
            List assistPKByOrg = GLUtil.getAssistPKByOrg((Long)orgid);
            assgrppks.addAll(assistPKByOrg);
        }
        assgrpEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)assgrppks));
        });
        BasedataEdit basedatavalEdit = (BasedataEdit)this.getControl(Key_BaseVal);
        DynamicObject assgrpType = (DynamicObject)model.getValue(Key_Assgrp, row);
        if (assgrpType != null) {
            this.setValProp(row, this.getModel().getDataEntityType());
            basedatavalEdit.addBeforeF7SelectListener((BeforeF7SelectListener)new FlexBasedataBeforeF7SelectListener());
        }
    }

    private void clearNoDataRow() {
        IDataModel model = this.getModel();
        model.clearNoDataRow();
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            Object org = customParams.get("org");
            if (org != null) {
                model.setValue("org", (Object)Long.valueOf(org.toString()));
            }
            Object accounttable = customParams.get("accounttable");
            if (org != null) {
                model.setValue("accounttable", (Object)Long.valueOf(accounttable.toString()));
            }
        }
        this.updateBasedataVal();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private void updateBasedataVal() {
        IDataModel model = this.getModel();
        int entriesSize = model.getEntryRowCount(Key_Entry);
        for (int index = 0; index < entriesSize; ++index) {
            DynamicObject row = model.getEntryRowEntity(Key_Entry, index);
            Object pk = row.get(Key_BasePk);
            if (!this.isIdNotNull(pk)) continue;
            this.setValProp(index, this.getModel().getDataEntityType());
            model.setValue(Key_BaseVal, pk, index);
            model.setValue("basedataval_id", pk, index);
        }
    }

    private boolean isIdNotNull(Object pk) {
        String pkStr = pk.toString();
        return StringUtils.isNotBlank((Object)pk) && !"0".equalsIgnoreCase(pkStr);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        int rowIndex = changeSet.getRowIndex();
        DynamicObjectCollection entryEntity = model.getEntryEntity(Key_Entry);
        switch (name) {
            case "account": {
                DynamicObject account = (DynamicObject)changeSet.getNewValue();
                this.autoSetAssgrp(account, model, rowIndex);
                break;
            }
            case "assgrptype": {
                DynamicObject currencyDyo = ((DynamicObject)entryEntity.get(rowIndex)).getDynamicObject(Key_Currency);
                Long currencyID = currencyDyo != null ? (Long)currencyDyo.getPkValue() : 0L;
                DynamicObject assgrp = (DynamicObject)changeSet.getNewValue();
                this.clearValue(rowIndex);
                this.existAccountAndAssgrp(currencyID, assgrp, model, rowIndex);
                break;
            }
            case "basedataval": {
                DynamicObject newObj = (DynamicObject)changeSet.getNewValue();
                this.setBasePk(newObj, model, rowIndex);
                break;
            }
            case "currency": {
                DynamicObject newCurrencyDyo = (DynamicObject)changeSet.getNewValue();
                Long newCurrencyID = newCurrencyDyo != null ? (Long)newCurrencyDyo.getPkValue() : 0L;
                DynamicObject assgrpDyo = ((DynamicObject)entryEntity.get(rowIndex)).getDynamicObject(Key_Assgrp);
                this.existAccountAndAssgrp(newCurrencyID, assgrpDyo, model, rowIndex);
                break;
            }
        }
    }

    private void setBasePk(DynamicObject newObj, IDataModel model, int rowIndex) {
        if (newObj != null) {
            model.setValue(Key_BasePk, newObj.getPkValue(), rowIndex);
        } else {
            model.setValue(Key_BasePk, null, rowIndex);
        }
    }

    private void clearValue(int rowIndex) {
        this.getModel().setValue(Key_BaseVal, null, rowIndex);
        this.getModel().setValue(Key_BasePk, null, rowIndex);
        this.getModel().setValue(Key_TxtVal, null, rowIndex);
        this.getModel().setValue(Key_ASSGRP_NAME, null, rowIndex);
        this.getModel().setValue(Key_ASSGRP_NUMBER, null, rowIndex);
        this.getView().updateView(Key_BaseVal, rowIndex);
    }

    private void autoSetAssgrp(DynamicObject account, IDataModel model, int row) {
        if (account == null || row < 0) {
            return;
        }
        Long newid = account.getLong("id");
        DynamicObjectCollection entryEntity = model.getEntryEntity(Key_Entry);
        for (DynamicObject entry : entryEntity) {
            Long accountid;
            if (entry.getInt("seq") == row + 1 || !(accountid = Long.valueOf(entry.getLong("account_id"))).equals(newid)) continue;
            model.setValue(Key_Assgrp, null, row);
            return;
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{Key_Account, Key_Assgrp});
        DynamicObjectCollection col = account.getDynamicObjectCollection("checkitementry");
        boolean first = true;
        for (DynamicObject dyn : col) {
            DynamicObject assgrp = dyn.getDynamicObject("asstactitem");
            if (assgrp == null) continue;
            if (first) {
                model.setValue(Key_Assgrp, (Object)assgrp.getLong("id"), row);
                model.setValue(Key_BaseVal, null, row);
                model.setValue(Key_BasePk, null, row);
                model.setValue(Key_TxtVal, null, row);
                first = false;
                continue;
            }
            vs.addRow(new Object[]{newid, assgrp.getLong("id")});
        }
        dataModel.batchCreateNewEntryRow(Key_Entry, vs);
        dataModel.endInit();
        this.getView().updateView(Key_Entry);
        this.updateBasedataVal();
    }

    private void existAccountAndAssgrp(Long newCurrencyID, DynamicObject assgrp, IDataModel model, int row) {
        Long assgrpid;
        if (assgrp == null || (assgrpid = Long.valueOf(assgrp.getLong("id"))) <= 0L) {
            this.clearValue(row);
            return;
        }
        Long accountid = (Long)model.getValue("account_id", row);
        DynamicObjectCollection entryEntity = model.getEntryEntity(Key_Entry);
        for (DynamicObject entry : entryEntity) {
            if (entry.getInt("seq") == row + 1) continue;
            Long rowaccountid = entry.getLong("account_id");
            Long rowassgrpid = entry.getLong("assgrptype_id");
            Long currencyID = entry.getLong("currency_id");
            if (!accountid.equals(rowaccountid) || !assgrpid.equals(rowassgrpid) || !currencyID.equals(newCurrencyID)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u3001\u5e01\u79cd\u4e0e\u6838\u7b97\u7ef4\u5ea6\u7684\u7ec4\u5408\u5df2\u7ecf\u5b58\u5728\u3002", (String)"AssgrpDefValEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            model.setValue(Key_Assgrp, null, row);
            model.setValue(Key_TxtVal, null, row);
            break;
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType entitytype = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)entitytype.clone();
        }
        catch (CloneNotSupportedException exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
            throw new KDBizException((Throwable)exp, BosErrorCode.systemError, new Object[0]);
        }
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex(Key_Entry);
        this.setValProp(row, newMainType);
        e.setNewEntityType(newMainType);
    }

    private void setValProp(int row, MainEntityType newMainType) {
        IDataModel model = this.getModel();
        DynamicObject assisType = (DynamicObject)model.getValue(Key_Assgrp, row);
        if (assisType == null) {
            return;
        }
        EntryProp entry = (EntryProp)newMainType.getProperty(Key_Entry);
        BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(Key_BaseVal);
        DynamicObject valueSource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("valuesource");
            entityId = valueSource.getString("id");
        } else if ("2".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("assistanttype");
            entityId = ASSIST_DETAIL;
        }
        if (valueSource != null) {
            prop.setBaseEntityId(entityId);
            prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
        }
    }

    public void initImportData(InitImportDataEventArgs importArgs) {
        List importDataMapList = importArgs.getSourceDataList();
        HashSet<String> orgNumberSet = new HashSet<String>(16);
        HashSet<String> accTableNumberSet = new HashSet<String>(16);
        HashSet<String> assistNumberSet = new HashSet<String>(16);
        HashSet<String> assistValSet = new HashSet<String>(16);
        HashSet<String> accNumberSet = new HashSet<String>(16);
        HashMap<String, Set<String>> numberTableToOrgMap = new HashMap<String, Set<String>>(16);
        HashMap<Integer, Boolean> cancelRowMap = new HashMap<Integer, Boolean>(8);
        this.initData(importDataMapList, orgNumberSet, accTableNumberSet, assistNumberSet, assistValSet, accNumberSet, numberTableToOrgMap, cancelRowMap, importArgs);
        Map<String, Long> orgNumberToIdMap = this.dealNumberToIdMap("bos_org", orgNumberSet);
        Map<String, Long> accTableNumberToIdMap = this.dealNumberToIdMap("bd_accounttable", accTableNumberSet);
        HashMap<String, Long> numberAndSourceToIdMap = new HashMap(16);
        HashMap<String, Long> numberToDetailGroupMap = new HashMap<String, Long>(8);
        HashMap<String, Long> assNumberToIdMap = new HashMap<String, Long>(8);
        Map<String, String> numberToEntityMap = this.dealAssist(numberToDetailGroupMap, assistNumberSet, assNumberToIdMap);
        if (!numberToEntityMap.isEmpty()) {
            numberAndSourceToIdMap = this.dealAssistValToId(numberToDetailGroupMap, numberToEntityMap, assistValSet);
        }
        HashMap<Long, Set<Long>> accountToAssMap = new HashMap<Long, Set<Long>>(8);
        Map<String, Long> orgTableNumToIdMap = this.dealAccountNumberToId(orgNumberToIdMap, accTableNumberToIdMap, accNumberSet, numberTableToOrgMap, accountToAssMap);
        this.packageImportData(importDataMapList, numberToEntityMap, orgNumberToIdMap, accTableNumberToIdMap, numberAndSourceToIdMap, orgTableNumToIdMap, cancelRowMap, importArgs, accountToAssMap, assNumberToIdMap);
    }

    private void packageImportData(List<Map<String, Object>> importDataMapList, Map<String, String> numberToEntityMap, Map<String, Long> orgNumberToIdMap, Map<String, Long> accTableNumberToIdMap, Map<String, Long> numberAndSourceToIdMap, Map<String, Long> orgTableNumToIdMap, Map<Integer, Boolean> cancelRowMap, InitImportDataEventArgs importArgs, Map<Long, Set<Long>> accountToAssMap, Map<String, Long> assNumberToIdMap) {
        for (int i = 0; i < importDataMapList.size(); ++i) {
            Integer rowNum;
            Map<String, Object> data = importDataMapList.get(i);
            Map orgnization = (Map)data.get("org");
            if (orgnization.isEmpty() || cancelRowMap.containsKey(rowNum = (Integer)data.get("rowNum"))) continue;
            String orgNumber = String.valueOf(orgnization.get("number"));
            if (null == orgNumberToIdMap.get(orgNumber)) {
                importArgs.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801(%1$s)\uff1a \u7ec4\u7ec7\u7f16\u7801(%2$s)\u5bf9\u5e94\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5excel\u914d\u7f6e\u3002", (String)"AssgrpDefValEdit_3", (String)"bd-master-formplugin", (Object[])new Object[0]), data.get("number"), orgNumber));
                continue;
            }
            long orgId = orgNumberToIdMap.get(orgNumber);
            orgnization.put("id", orgId);
            String accountTableNumber = (String)((Map)data.get("accounttable")).get("number");
            if (null == accTableNumberToIdMap.get(accountTableNumber)) {
                importArgs.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801(%1$s)\uff1a \u79d1\u76ee\u8868\u7f16\u7801(%2$s)\u5bf9\u5e94\u79d1\u76ee\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5excel\u914d\u7f6e\u3002", (String)"AssgrpDefValEdit_4", (String)"bd-master-formplugin", (Object[])new Object[0]), data.get("number"), accountTableNumber));
                continue;
            }
            long accountTableId = accTableNumberToIdMap.get(accountTableNumber);
            List entitys = (List)data.get(Key_Entry);
            for (int j = 0; j < entitys.size(); ++j) {
                Map entry = (Map)entitys.get(j);
                Map account = (Map)entry.get(Key_Account);
                if (!CollectionUtils.isEmpty((Map)account)) {
                    String accNumber = (String)account.get("number");
                    Long accountId = orgTableNumToIdMap.get(AssgrpDefValEdit.buildKey(new Object[]{orgId, accountTableId, accNumber}));
                    if (null == accountId) {
                        importArgs.addCancelMessage(Integer.valueOf(i), Integer.valueOf(j), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801(%1$s)\uff1a \u5f53\u524d\u7ec4\u7ec7(%2$s)\u5728\u79d1\u76ee\u8868(%3$s)\u4e2d\u4e0d\u5b58\u5728\u8be5\u79d1\u76ee(%4$s)\u6216\u65e0\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5excel\u914d\u7f6e\u3002", (String)"AssgrpDefValEdit_6", (String)"bd-master-formplugin", (Object[])new Object[0]), data.get("number"), orgNumber, accountTableNumber, accNumber));
                        continue;
                    }
                    account.put("id", accountId);
                    if (this.checkCurrAssist(importArgs, accountToAssMap, assNumberToIdMap, i, data, j, entry)) continue;
                }
                this.setAssgrpId(numberToEntityMap, numberAndSourceToIdMap, entry, i, j, importArgs, data, accountToAssMap);
            }
        }
    }

    private boolean checkCurrAssist(InitImportDataEventArgs importArgs, Map<Long, Set<Long>> accountToAssMap, Map<String, Long> assNumberToIdMap, int i, Map<String, Object> data, int j, Map<String, Object> entry) {
        Map account = (Map)entry.get(Key_Account);
        String accNumber = (String)account.get("number");
        Map assgrpType = (Map)entry.get(Key_Assgrp);
        String assgrpNumber = (String)assgrpType.get("number");
        if (StringUtils.isNotBlank((CharSequence)assgrpNumber)) {
            Set<Long> assistIds = accountToAssMap.get(account.get("id"));
            if (CollectionUtils.isEmpty(assistIds)) {
                importArgs.addCancelMessage(Integer.valueOf(i), Integer.valueOf(j), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801(%1$s)\uff1a \u79d1\u76ee(%2$s)\u65e0\u8be5\u6838\u7b97\u7ef4\u5ea6(%3$s),\u8bf7\u68c0\u67e5excel\u914d\u7f6e\u3002", (String)"AssgrpDefValEdit_5", (String)"bd-master-formplugin", (Object[])new Object[0]), data.get("number"), accNumber, assgrpNumber));
                return true;
            }
            if (!CollectionUtils.isEmpty(assNumberToIdMap) && !assistIds.contains(assNumberToIdMap.get(assgrpNumber))) {
                importArgs.addCancelMessage(Integer.valueOf(i), Integer.valueOf(j), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801(%1$s)\uff1a \u79d1\u76ee(%2$s)\u65e0\u8be5\u6838\u7b97\u7ef4\u5ea6(%3$s),\u8bf7\u68c0\u67e5excel\u914d\u7f6e\u3002", (String)"AssgrpDefValEdit_5", (String)"bd-master-formplugin", (Object[])new Object[0]), data.get("number"), accNumber, assgrpNumber));
                return true;
            }
        }
        return false;
    }

    private Map<String, Long> dealAccountNumberToId(Map<String, Long> orgNumberToIdMap, Map<String, Long> accTableNumberToIdMap, Set<String> accNumberSet, Map<String, Set<String>> numberTableToOrgMap, Map<Long, Set<Long>> accountToAssMap) {
        Collection<Long> orgIds = orgNumberToIdMap.values();
        Collection<Long> accTableIds = accTableNumberToIdMap.values();
        HashMap<String, Long> orgTableNumToIdMap = new HashMap<String, Long>(16);
        HashSet<Long> accountIds = new HashSet<Long>(8);
        if (!(accNumberSet.isEmpty() || orgIds.isEmpty() || accTableIds.isEmpty())) {
            Set<Long> shareAccIds = this.dealShareAccount(orgNumberToIdMap, accNumberSet, numberTableToOrgMap, accTableIds, orgTableNumToIdMap);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select a.fid, a.fnumber,a.faccounttableid,b.fuseorgid from t_bd_account a inner join ", new Object[0]);
            sqlBuilder.append(" t_bd_account_u b on a.fid = b.fdataid where ", new Object[0]);
            sqlBuilder.append(" a.fenddate = ?", new Object[]{AccountVersionUtil.getEndDate()});
            sqlBuilder.appendIn(" and a.fnumber ", new ArrayList<String>(accNumberSet));
            sqlBuilder.appendIn(" and b.fuseorgid ", new ArrayList<Long>(orgIds));
            sqlBuilder.appendIn(" and a.faccounttableid ", new ArrayList<Long>(accTableIds));
            DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
            for (Row row : dataSet) {
                String orgTableNum = AssgrpDefValEdit.buildKey(new Object[]{row.getLong("fuseorgid"), row.getLong("faccounttableid"), row.getString("fnumber")});
                long accId = row.getLong("fid");
                orgTableNumToIdMap.put(orgTableNum, accId);
                accountIds.add(accId);
            }
            if (!CollectionUtils.isEmpty(shareAccIds)) {
                accountIds.addAll(shareAccIds);
            }
            if (!accountIds.isEmpty()) {
                SqlBuilder sql = new SqlBuilder();
                sql.appendIn("select fid,fasstactitemid from t_bd_accountasstactitem where fid ", accountIds.toArray());
                try (DataSet assSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
                    for (Row row : assSet) {
                        accountToAssMap.computeIfAbsent(row.getLong("fid"), k -> new HashSet(8)).add(row.getLong("fasstactitemid"));
                    }
                }
            }
        }
        return orgTableNumToIdMap;
    }

    private Set<Long> dealShareAccount(Map<String, Long> orgNumberToIdMap, Set<String> accNumberSet, Map<String, Set<String>> numberTableToOrgMap, Collection<Long> accTableIds, Map<String, Long> orgTableNumToIdMap) {
        HashSet<Long> shareAccountIds = new HashSet<Long>(8);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.fid,a.fnumber as accNumber,a.faccounttableid,a.fctrlstrategy,b.fnumber as tableNumber ", new Object[0]);
        sql.append(" from t_bd_account a inner join t_bd_accounttable b ", new Object[0]);
        sql.append(" on a.faccounttableid = b.fid where ", new Object[0]);
        sql.appendIn(" a.fnumber ", new ArrayList<String>(accNumberSet));
        sql.appendIn(" and a.faccounttableid ", new ArrayList<Long>(accTableIds));
        sql.append(" and a.fenddate = ? ", new Object[]{AccountVersionUtil.getEndDate()});
        DataSet resDataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);
        for (Row row : resDataSet) {
            String accNumber = row.getString("accNumber");
            String tableNumber = row.getString("tableNumber");
            String accNumberTable = AssgrpDefValEdit.buildKey(new Object[]{accNumber, tableNumber});
            if (!AccountVersionUtil.CTRL_SHARE_STRATEGY.contains(row.getString("fctrlstrategy")) || !numberTableToOrgMap.containsKey(accNumberTable)) continue;
            Set<String> orgNumberSet = numberTableToOrgMap.get(accNumberTable);
            for (String orgNumber : orgNumberSet) {
                Long accId = row.getLong("fid");
                orgTableNumToIdMap.put(AssgrpDefValEdit.buildKey(new Object[]{orgNumberToIdMap.get(orgNumber), row.getLong("faccounttableid"), accNumber}), accId);
                shareAccountIds.add(accId);
            }
        }
        return shareAccountIds;
    }

    private void setAssgrpId(Map<String, String> numberToEntityMap, Map<String, Long> numberAndSourceToIdMap, Map<String, Object> entry, int i, int j, InitImportDataEventArgs importArgs, Map<String, Object> importDataMap, Map<Long, Set<Long>> accountToAssMap) {
        Map assgrpType = (Map)entry.get(Key_Assgrp);
        String assgrpNumber = (String)assgrpType.get("number");
        String valueSource = numberToEntityMap.get(assgrpNumber);
        if (StringUtils.isNotBlank((CharSequence)valueSource)) {
            Map basedataval;
            String number = (String)entry.get(Key_ASSGRP_NUMBER);
            if (StringUtils.isBlank((CharSequence)number) && entry.containsKey(Key_BaseVal) && !(basedataval = (Map)entry.get(Key_BaseVal)).isEmpty()) {
                number = basedataval.get("number").toString();
            }
            String key = AssgrpDefValEdit.buildKey(new Object[]{number, valueSource});
            if (!numberAndSourceToIdMap.isEmpty() && null != numberAndSourceToIdMap.get(key)) {
                long assistValId = numberAndSourceToIdMap.get(AssgrpDefValEdit.buildKey(new Object[]{number, valueSource}));
                entry.put(Key_BasePk, assistValId);
                Object baseVal = entry.get(Key_BaseVal);
                entry.remove(Key_BaseVal, baseVal);
            } else {
                importArgs.addCancelMessage(Integer.valueOf(i), Integer.valueOf(j), Integer.valueOf(0), ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801(%s)\uff1a \u8bf7\u8bbe\u7f6e\u6838\u7b97\u7ef4\u5ea6\u503c\u3002", (String)"AssgrpDefValEdit_2", (String)"bd-master-formplugin", (Object[])new Object[]{importDataMap.get("number")}));
            }
        }
    }

    private static String buildKey(Object[] field) {
        return org.apache.commons.lang3.StringUtils.join((Object[])field, (String)"*");
    }

    private Map<String, Long> dealAssistValToId(Map<String, Long> numberToDetailGroupMap, Map<String, String> numberToEntityMap, Set<String> assistValSet) {
        HashMap<String, Long> numberAndSourceToIdMap = new HashMap<String, Long>(16);
        for (Map.Entry<String, String> entry : numberToEntityMap.entrySet()) {
            String valueSource = entry.getValue();
            String assistNumber = entry.getKey();
            if (StringUtils.isBlank((CharSequence)valueSource)) continue;
            QFilter qFilter = new QFilter("number", "in", assistValSet);
            if (valueSource.equalsIgnoreCase(ASSIST_DETAIL)) {
                qFilter.and(new QFilter("group", "=", (Object)numberToDetailGroupMap.get(assistNumber)));
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)valueSource, (String)"number,id", (QFilter[])new QFilter[]{qFilter}, null);
            for (Row row : dataSet) {
                numberAndSourceToIdMap.put(row.getString("number") + "*" + valueSource, row.getLong("id"));
            }
        }
        return numberAndSourceToIdMap;
    }

    private Map<String, String> dealAssist(Map<String, Long> numberToDetailGroupMap, Set<String> assistNumberSet, Map<String, Long> assNumberToIdMap) {
        HashMap<String, String> numberToEntityMap = new HashMap<String, String>(16);
        QFilter numberFilter = new QFilter("number", "in", assistNumberSet);
        DataSet asstactSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_asstacttype", (String)"id,number,valuetype,assistanttype,valuesource", (QFilter[])new QFilter[]{numberFilter}, null);
        for (Row row : asstactSet) {
            long assistGroupId = 0L;
            String valType = row.getString("valuetype");
            String entityId = null;
            switch (valType) {
                case "1": {
                    entityId = row.getString("valuesource");
                    break;
                }
                case "2": {
                    entityId = ASSIST_DETAIL;
                    assistGroupId = row.getLong("assistanttype");
                    break;
                }
                case "3": {
                    entityId = null;
                }
            }
            String number = row.getString("number");
            if (assistGroupId != 0L) {
                numberToDetailGroupMap.put(number, assistGroupId);
            }
            numberToEntityMap.put(number, entityId);
            assNumberToIdMap.put(number, row.getLong("id"));
        }
        return numberToEntityMap;
    }

    private void initData(List<Map<String, Object>> importDataMapList, Set<String> orgNumberSet, Set<String> accTableNumberSet, Set<String> assistNumberSet, Set<String> assistValSet, Set<String> accNumberSet, Map<String, Set<String>> numberTableToOrgMap, Map<Integer, Boolean> cancelRowMap, InitImportDataEventArgs importArgs) {
        for (int i = 0; i < importDataMapList.size(); ++i) {
            HashSet<String> currRowAssistNumberSet = new HashSet<String>(8);
            Map<String, Object> importDataMap = importDataMapList.get(i);
            Map orgnization = (Map)importDataMap.get("org");
            String orgNumber = String.valueOf(orgnization.get("number"));
            orgNumberSet.add(orgNumber);
            String accTableNumber = (String)((Map)importDataMap.get("accounttable")).get("number");
            accTableNumberSet.add(accTableNumber);
            List entity = (List)importDataMap.get(Key_Entry);
            for (int j = 0; j < entity.size(); ++j) {
                Map basedataval;
                String uniqueCombination;
                Map entry = (Map)entity.get(j);
                Map assgrpType = (Map)entry.get(Key_Assgrp);
                String assgrpNumber = (String)assgrpType.get("number");
                assistNumberSet.add(assgrpNumber);
                Map account = (Map)entry.get(Key_Account);
                String accNumber = " ";
                if (!CollectionUtils.isEmpty((Map)account)) {
                    accNumber = (String)account.get("number");
                    accNumberSet.add(accNumber);
                    numberTableToOrgMap.computeIfAbsent(AssgrpDefValEdit.buildKey(new Object[]{accNumber, accTableNumber}), k -> new HashSet()).add(orgNumber);
                }
                Map currency = (Map)entry.get(Key_Currency);
                String currencyNumber = " ";
                if (!CollectionUtils.isEmpty((Map)currency)) {
                    currencyNumber = (String)currency.get("number");
                }
                if (!currRowAssistNumberSet.add(uniqueCombination = AssgrpDefValEdit.buildKey(new Object[]{assgrpNumber, accNumber, currencyNumber}))) {
                    Integer rowNum = (Integer)importDataMap.get("rowNum");
                    importArgs.addCancelMessage(Integer.valueOf(i), Integer.valueOf(j), Integer.valueOf(0), ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801(%s)\uff1a \u79d1\u76ee-\u5e01\u522b-\u6838\u7b97\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5excel\u914d\u7f6e\u3002", (String)"AssgrpDefValEdit_1", (String)"bd-master-formplugin", (Object[])new Object[]{importDataMap.get("number")}));
                    cancelRowMap.put(rowNum, false);
                    continue;
                }
                String assgrValNumber = (String)entry.get(Key_ASSGRP_NUMBER);
                if (StringUtils.isBlank((CharSequence)assgrValNumber) && entry.containsKey(Key_BaseVal) && !(basedataval = (Map)entry.get(Key_BaseVal)).isEmpty()) {
                    assgrValNumber = basedataval.get("number").toString();
                }
                assistValSet.add(assgrValNumber);
            }
        }
    }

    private Map<String, Long> dealNumberToIdMap(String entityName, Set<String> orgNumberSet) {
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>(16);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("number", "in", orgNumberSet));
        DynamicObjectCollection resultCollection = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])qFilterList.toArray(new QFilter[0]));
        if (!resultCollection.isEmpty()) {
            resultCollection.stream().forEach(orgData -> numberToIdMap.put(orgData.getString("number"), orgData.getLong("id")));
        }
        return numberToIdMap;
    }
}

