/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class AssgrpRelationList
extends AbstractListPlugin {
    private static final String GL_ASSGRPRELATION = "gl_assgrprelation";
    private static final String CREATEORG_PREFIX = "createorg";
    private static final String DELETE = "delete";
    private static final String SELECT_CREATE_ORG_ID = "select_create_org_id";
    private static final String PARAM_CREATE_ORG = "createOrg";
    private static final String OPTION_DELETE_ORG = "deleteOrg";
    private static final String ILLEGA_FILTER_EXP = "1 != 1";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter orgFilter = this.removeCreateOrgFilter(e);
        if (orgFilter == null) {
            this.addIllegalFilter(e);
            this.setOrgIdToCache(0L);
            this.showMessage();
        } else {
            long orgId = this.getOrgId(orgFilter);
            this.addIdFilter(e, orgId);
        }
    }

    private QFilter removeCreateOrgFilter(SetFilterEvent e) {
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter != null) {
            if (mainOrgQFilter.getProperty().contains(CREATEORG_PREFIX)) {
                e.setMainOrgQFilter(null);
                return mainOrgQFilter;
            }
            e.setMainOrgQFilter(null);
        }
        Iterator filterIter = e.getQFilters().iterator();
        while (filterIter.hasNext()) {
            QFilter qFilter = (QFilter)filterIter.next();
            if (!qFilter.getProperty().contains(CREATEORG_PREFIX)) continue;
            filterIter.remove();
            return qFilter;
        }
        return null;
    }

    private void showMessage() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"AssgrpRelationList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    private void addIllegalFilter(SetFilterEvent e) {
        e.getQFilters().add(QFilter.of((String)ILLEGA_FILTER_EXP, (Object[])new Object[0]));
    }

    private void addIdFilter(SetFilterEvent e, long orgId) {
        List relationIdList = GLUtil.getAssgrRelaPKByOrg((Long)orgId);
        e.getQFilters().add(new QFilter("id", "in", (Object)relationIdList));
    }

    private long getOrgId(QFilter orgFilter) {
        Collection valueColl;
        Optional first;
        Object value = orgFilter.getValue();
        long orgId = 0L;
        if (value instanceof Long || value instanceof Integer) {
            orgId = Long.parseLong(value.toString());
        } else if (value instanceof Collection && (first = (valueColl = (Collection)value).stream().findFirst()).isPresent() && first.get() instanceof Long) {
            orgId = Long.parseLong(first.get().toString());
        }
        this.setOrgIdToCache(orgId);
        return orgId;
    }

    private void setOrgIdToCache(long orgId) {
        this.getPageCache().put(SELECT_CREATE_ORG_ID, String.valueOf(orgId));
    }

    private long getOrgIdFromCache() {
        String orgCache = this.getPageCache().get(SELECT_CREATE_ORG_ID);
        return StringUtils.isBlank((String)orgCache) ? 0L : Long.parseLong(orgCache);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field.startsWith(CREATEORG_PREFIX)) {
            args.getQfilters().clear();
            args.addCustomQFilter(this.getCreateOrgF7Filter());
        }
    }

    private QFilter getCreateOrgF7Filter() {
        List orgPkList = AccSysUtil.getAcctOrgPkList((String)GL_ASSGRPRELATION, (boolean)Boolean.TRUE, (PermissonType)PermissonType.VIEW);
        return new QFilter("id", "in", (Object)orgPkList);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : commonFilterColumns) {
            FormShowParameter showParameter;
            String orgId;
            if (!column.getFieldName().startsWith(CREATEORG_PREFIX)) continue;
            CommonFilterColumn commFilter = (CommonFilterColumn)column;
            List comboItems = AccSysUtil.getAcctOrgComboItem((String)GL_ASSGRPRELATION, (boolean)Boolean.TRUE, (PermissonType)PermissonType.VIEW);
            commFilter.setComboItems(comboItems);
            Long defaultOrgId = AccSysUtil.getDefaultOrgId((String)((ListView)this.getView()).getBillFormId(), (boolean)false, (PermissonType)PermissonType.VIEW);
            if (AccSysUtil.getAllOrgIdByComboItems((Collection)comboItems).contains(defaultOrgId)) {
                commFilter.setDefaultValue(String.valueOf(defaultOrgId));
            } else if (!comboItems.isEmpty()) {
                commFilter.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
            }
            if (!StringUtils.isNotEmpty((String)(orgId = (String)(showParameter = this.getView().getFormShowParameter()).getCustomParam("imicdimension_bos_org")))) continue;
            commFilter.setDefaultValue(orgId);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        long orgId = this.getOrgIdFromCache();
        if (orgId == 0L) {
            this.showMessage();
            e.setCancel(true);
        }
        BillShowParameter billParam = e.getParameter();
        billParam.setCustomParam(PARAM_CREATE_ORG, (Object)orgId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (DELETE.equals(operateKey)) {
            long orgId = this.getOrgIdFromCache();
            if (orgId == 0L) {
                this.showMessage();
                args.setCancel(true);
            }
            op.getOption().setVariableValue(OPTION_DELETE_ORG, String.valueOf(orgId));
        }
    }
}

