/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.constant.Constant;
import kd.fi.gl.finalprocess.constant.AutoTransConstant;
import kd.fi.gl.finalprocess.info.scheme.AutoTransScheme;
import kd.fi.gl.finalprocess.service.impl.AutoTransService;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;

public class AutoTransExpEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String org = "org";
    private static final String autoRowKey = "autorowid";
    private static final String accountKey = "account";
    private static final String assgrpKey = "assgrp";
    private static final String currencyKey = "currency";
    private static final String unitKey = "unit";
    private static final String qtyKey = "qty";
    private static final String amountTypeKey = "amounttype";
    private static final String periodRange = "periodrange";
    private static final String btnOk = "okbtn";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{btnOk});
        IFormView formView = GLUtil.getSpecifiedUpperFormView((IFormView)this.getView(), (Constant)new AutoTransConstant());
        if (formView != null) {
            QFilter customFilter = new QFilter("ismanual", "=", (Object)true);
            AutoTransScheme scheme = new AutoTransScheme(formView.getModel().getDataEntity());
            List filterList = new AutoTransService(scheme).getAccountFilterInVersion(customFilter).toList();
            GLUtil.registerListener((BasedataEdit)((BasedataEdit)this.getView().getControl(accountKey)), (List)filterList, (boolean)true);
        }
        BasedataEdit curEdit = (BasedataEdit)this.getControl(currencyKey);
        curEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject accoutDyn = (DynamicObject)this.getModel().getValue(accountKey);
            if (accoutDyn != null) {
                ArrayList<Long> ids = new ArrayList<Long>();
                if ("descurrency".equals(accoutDyn.get("acctcurrency"))) {
                    DynamicObjectCollection coll = (DynamicObjectCollection)accoutDyn.get("currencyentry");
                    for (DynamicObject dyn : coll) {
                        Long acctCur = dyn.getLong("currency_id");
                        ids.add(acctCur);
                    }
                    QFilter filter = new QFilter("id", "in", ids);
                    ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(filter);
                }
            }
        });
        BasedataEdit unitEdit = (BasedataEdit)this.getControl(unitKey);
        unitEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject accoutDyn = (DynamicObject)this.getModel().getValue(accountKey);
            if (accoutDyn != null) {
                Long groupId = accoutDyn.getLong("measureunitgroup_id");
                QFilter filter = null;
                if (groupId != 0L) {
                    filter = new QFilter("group.id", "=", (Object)groupId);
                }
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customValue = formShowParameter.getCustomParams();
        if (customValue == null) {
            return;
        }
        IDataModel model = this.getModel();
        Object accountTableId = customValue.get("accountTableId");
        if (accountTableId != null) {
            this.getPageCache().put("accountTableId", accountTableId.toString());
        }
        Object orgVal = customValue.get(org);
        Object assgrpRowVal = customValue.get("autoRowId");
        Object baseCurrencyId = customValue.get("baseCurrency");
        model.setValue(org, orgVal);
        model.setValue(autoRowKey, assgrpRowVal);
        model.setValue(currencyKey, baseCurrencyId);
        this.enableKey();
        if (customValue.get("value") != null) {
            MainEntityType mainEntityType = model.getDataEntityType();
            DynamicObject dynamicObject = GlFormUtil.fromDynamicString((String)customValue.get("value"), mainEntityType);
            this.initDefault(dynamicObject);
        } else {
            for (Map.Entry customValueEntry : customValue.entrySet()) {
                String valueKey = (String)customValueEntry.getKey();
                if (!valueKey.startsWith("comassist")) continue;
                List valueIdList = (List)JSONObject.toJavaObject((JSON)((JSON)customValueEntry.getValue()), List.class);
                model.setValue(valueKey, (Object)valueIdList.toArray());
            }
        }
    }

    public void afterBindData(EventObject eventobject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customValue = formShowParameter.getCustomParams();
        if (customValue == null) {
            return;
        }
        Object accountTableId = customValue.get("accountTableId");
        Object baseCurrencyId = customValue.get("baseCurrency");
        if (accountTableId != null) {
            this.getPageCache().put("accountTableId", accountTableId.toString());
        }
        if (accountTableId != null) {
            this.getPageCache().put("baseCurrency", baseCurrencyId.toString());
        }
        DynamicObject account = (DynamicObject)this.getModel().getValue(accountKey);
        this.changeAccount(account);
    }

    private void initDefault(DynamicObject dyn) {
        IDataModel model = this.getModel();
        model.setValue(org, (Object)dyn.getLong("org_id"));
        model.setValue(accountKey, (Object)dyn.getLong("account_id"));
        model.setValue(assgrpKey, (Object)dyn.getLong("assgrp_id"));
        model.setValue(currencyKey, (Object)dyn.getDynamicObject(currencyKey));
        model.setValue(unitKey, (Object)dyn.getLong("unit_id"));
        model.setValue(qtyKey, (Object)dyn.getBigDecimal(qtyKey));
        model.setValue(amountTypeKey, (Object)dyn.getString(amountTypeKey));
        model.setValue(periodRange, (Object)dyn.getString(periodRange));
        List allComAssistKeys = this.getModel().getDataEntityType().getAllFields().keySet().stream().filter(field -> field.startsWith("comassist")).collect(Collectors.toList());
        for (String comAssistKey : allComAssistKeys) {
            DynamicObjectCollection comAssistDys = dyn.getDynamicObjectCollection(comAssistKey);
            if (!CollectionUtils.isNotEmpty((Collection)comAssistDys)) continue;
            model.setValue(comAssistKey, (Object)comAssistDys);
        }
    }

    private void enableKey() {
        if (this.getModel().getValue(accountKey) == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{currencyKey, assgrpKey, unitKey, qtyKey});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{assgrpKey});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (key == null) {
            return;
        }
        if (accountKey.equals(key)) {
            ChangeData[] data = e.getChangeSet();
            DynamicObject account = (DynamicObject)data[0].getNewValue();
            if (account == null) {
                this.enableKey();
                return;
            }
            this.changeAccount(account);
        }
    }

    private void changeAccount(DynamicObject account) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (account == null) {
            return;
        }
        if (account.getBoolean("isassist")) {
            view.setVisible(Boolean.valueOf(true), new String[]{assgrpKey});
            view.setEnable(Boolean.valueOf(true), new String[]{assgrpKey});
        } else {
            model.setValue(assgrpKey, null);
            view.setVisible(Boolean.valueOf(false), new String[]{assgrpKey});
            view.setEnable(Boolean.valueOf(false), new String[]{assgrpKey});
        }
        if ("nocurrency".equals(account.getString("acctcurrency"))) {
            String baseCurrencyStr = this.getPageCache().get("baseCurrency");
            long baseCurrencyId = 0L;
            if (!StringUtils.isBlank((CharSequence)baseCurrencyStr)) {
                baseCurrencyId = Long.parseLong(baseCurrencyStr);
            }
            model.setValue(currencyKey, (Object)baseCurrencyId);
            view.setEnable(Boolean.valueOf(false), new String[]{currencyKey});
        } else {
            view.setEnable(Boolean.valueOf(true), new String[]{currencyKey});
        }
        if (account.getBoolean("isqty")) {
            view.setEnable(Boolean.valueOf(true), new String[]{unitKey, qtyKey});
        } else {
            model.setValue(unitKey, null);
            model.setValue(qtyKey, null);
            view.setEnable(Boolean.valueOf(false), new String[]{unitKey, qtyKey});
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(btnOk)) {
            this.returnToData();
        }
    }

    private boolean checkMustFill() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        long accountId = (Long)model.getValue("account_id");
        if (accountId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f1a\u8ba1\u79d1\u76ee\u3002", (String)"AutoTransExpEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void returnToData() {
        if (this.checkMustFill()) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("value", GlFormUtil.toDynamicObjectJson(this.getModel().getDataEntity(true)));
            IFormView view = this.getView();
            para.put("autoRowId", this.getModel().getValue(autoRowKey));
            view.returnDataToParent(para);
            view.close();
        }
    }

    public void beforeClosed(BeforeClosedEvent b) {
        super.beforeClosed(b);
        b.setCheckDataChange(false);
    }
}

