/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.text.Format;
import java.util.LinkedList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.exception.BOSException;

public class BalanceSheetPrintPluginNew
extends AbstractPrintPlugin {
    private final FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());

    public void loadCustomData(CustomDataLoadEvent evt) {
        String dsName;
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        FormDataModel model = this.getModel(pageId);
        if (model == null) {
            return;
        }
        List customDataRows = evt.getCustomDataRows();
        switch (dsName = dataSource.getDsName()) {
            case "head": {
                this.handleHeadDataSource(customDataRows, model);
                break;
            }
            case "custombody": {
                try {
                    this.handleRowDataSource(customDataRows, model);
                    break;
                }
                catch (Exception exp) {
                    throw new BOSException((Throwable)exp);
                }
            }
        }
    }

    private void handleHeadDataSource(List<DataRowSet> customDataRows, FormDataModel model) {
        DataRowSet dataRowSet = new DataRowSet();
        StringBuilder builder = new StringBuilder();
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("orgs");
        LinkedList<Long> orgId = new LinkedList<Long>();
        for (DynamicObject org : orgs) {
            orgId.add((Long)org.getDynamicObject("fbasedataid").getPkValue());
        }
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "in", (Object)orgId.toArray()).toArray());
        if (orgDyn != null) {
            builder.append(orgDyn.getString("name"));
        }
        dataRowSet.put("org", (Field)new TextField(builder.toString()));
        DynamicObject period = (DynamicObject)model.getValue("period");
        dataRowSet.put("period", (Field)new TextField(period.getString("name")));
        DynamicObject bookType = (DynamicObject)model.getValue("booktype");
        dataRowSet.put("booktype", (Field)new TextField(bookType.getString("name")));
        customDataRows.add(dataRowSet);
    }

    private void handleRowDataSource(List<DataRowSet> customDataRows, FormDataModel model) {
        String name = model.getDataEntityType().getName();
        if ("gl_balancesheet".equals(name)) {
            String[] entries = new String[]{"assetentryentity", "equityentryentity"};
            this.setObjects(entries, customDataRows, model);
        } else {
            DynamicObjectCollection entryentity = model.getEntityEntity("entryentity");
            Format format = this.getCurFormat(model, "basecurrency");
            for (DynamicObject entity : entryentity) {
                DataRowSet rowSet = new DataRowSet();
                DynamicObject object = entity.getDynamicObject("project");
                if (object != null) {
                    rowSet.put("project", (Field)new TextField(object.getString("name")));
                }
                rowSet.put("index", (Field)new TextField(entity.getString("index")));
                rowSet.put("balrowid", (Field)new TextField(entity.getString("balrowid")));
                this.handleMoneyWithCur(rowSet, format, entity, "currentperiod");
                this.handleMoneyWithCur(rowSet, format, entity, "yearcount");
                if ("gl_taxshow".equals(name)) {
                    rowSet.put("preyearperiodrate", (Field)new TextField(entity.getString("preyearperiodrate")));
                    rowSet.put("preperiodrate", (Field)new TextField(entity.getString("preperiodrate")));
                    rowSet.put("preyearrate", (Field)new TextField(entity.getString("preyearrate")));
                }
                customDataRows.add(rowSet);
            }
        }
    }

    private void setObjects(String[] entries, List<DataRowSet> objectList, FormDataModel model) {
        DynamicObjectCollection assetColl = model.getEntryEntity(entries[0]);
        DynamicObjectCollection equityColl = model.getEntryEntity(entries[1]);
        boolean flag = assetColl.size() > equityColl.size();
        Format format = this.getCurFormat(model, "basecurrency");
        DynamicObjectCollection minColl = flag ? equityColl : assetColl;
        for (int i = 0; i < minColl.size(); ++i) {
            DataRowSet rowSet = new DataRowSet();
            if (minColl.get(i) != null) {
                rowSet.put("seq", (Field)new TextField(((DynamicObject)minColl.get(i)).getString("seq")));
            }
            this.buildAsset((DynamicObject)assetColl.get(i), rowSet, format);
            this.buildEquity((DynamicObject)equityColl.get(i), rowSet, format);
            objectList.add(rowSet);
        }
        DynamicObjectCollection maxColl = flag ? assetColl : equityColl;
        for (int i = minColl.size(); i < maxColl.size(); ++i) {
            DataRowSet rowSet = new DataRowSet();
            if (maxColl.get(i) != null) {
                rowSet.put("seq", (Field)new TextField(((DynamicObject)maxColl.get(i)).getString("seq")));
            }
            if (flag) {
                this.buildAsset((DynamicObject)assetColl.get(i), rowSet, format);
            } else {
                this.buildEquity((DynamicObject)equityColl.get(i), rowSet, format);
            }
            objectList.add(rowSet);
        }
    }

    private void buildAsset(DynamicObject dynamicObject, DataRowSet rowSet, Format format) {
        if (dynamicObject == null) {
            return;
        }
        DynamicObject assetObject = dynamicObject.getDynamicObject("asset");
        String asset = "";
        if (assetObject != null) {
            asset = assetObject.getString("name");
        }
        rowSet.put("asset", (Field)new TextField(asset));
        this.handleMoneyWithCur(rowSet, format, dynamicObject, "assetbegin");
        this.handleMoneyWithCur(rowSet, format, dynamicObject, "assetclose");
    }

    private void buildEquity(DynamicObject dynamicObject, DataRowSet rowSet, Format format) {
        if (dynamicObject == null) {
            return;
        }
        DynamicObject equityObject = dynamicObject.getDynamicObject("equity");
        String equity = null;
        if (equityObject != null) {
            equity = equityObject.getString("name");
        }
        rowSet.put("equity", (Field)new TextField(equity));
        this.handleMoneyWithCur(rowSet, format, dynamicObject, "equitybegin");
        this.handleMoneyWithCur(rowSet, format, dynamicObject, "equityclose");
    }

    private FormDataModel getModel(String pageId) {
        FormView view = (FormView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        return (FormDataModel)view.getModel();
    }

    private Format getCurFormat(FormDataModel model, String cur) {
        DynamicObject curDyn = (DynamicObject)model.getValue(cur);
        if (curDyn == null) {
            this.fobj.getCurrencyFormat().setCurrencySymbols("\uffe5");
            this.fobj.getCurrencyFormat().setMinimumFractionDigits(4);
            return FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.fobj);
        }
        int amtprecision = curDyn.getInt("amtprecision");
        String signStr = curDyn.getString("sign") == null ? "" : curDyn.getString("sign");
        this.fobj.getCurrencyFormat().setCurrencySymbols(signStr);
        this.fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
        return FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.fobj);
    }

    private void handleMoneyWithCur(DataRowSet rowSet, Format format, DynamicObject object, String money) {
        if (object == null) {
            return;
        }
        BigDecimal bigDecimal = object.getBigDecimal(money);
        if (BigDecimal.ZERO.compareTo(bigDecimal) != 0) {
            rowSet.put(money, (Field)new TextField(format.format(bigDecimal)));
        }
    }
}

