/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;

public class BillOrgTplEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String S_BOOKSTYPE = "bookstype";

    public void initialize() {
        super.initialize();
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(e -> {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            List<Long> orgIds = this.getBizUnitOrgIDs();
            QFilter qFilter = new QFilter("id", "in", orgIds);
            qFilters.add(qFilter);
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.setQFilters(qFilters);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"pic"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.changeBookVision();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "bookstype": {
                DynamicObject obj = e.getChangeSet()[0].getDataEntity();
                DynamicObject book = (DynamicObject)obj.get(S_BOOKSTYPE);
                if (book == null) {
                    return;
                }
                if (this.getModel().getValue("org") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BillOrgTplEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(S_BOOKSTYPE, (Object)0);
                    return;
                }
                Long bookid = book.getLong("id");
                AccountBookInfo cc = AccSysUtil.getBookFromAccSys((long)((DynamicObject)this.getModel().getValue("org")).getLong("id"), (long)bookid);
                if (cc != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u5bf9\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u8d26\u7c3f\u8fdb\u884c\u671f\u95f4\u8bbe\u7f6e\u3002", (String)"BillOrgTplEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(S_BOOKSTYPE, (Object)0);
                return;
            }
        }
    }

    private List<Long> getBizUnitOrgIDs() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        QFilter qFilter = new QFilter("isbizunit", "=", (Object)true);
        DynamicObjectCollection dync = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dyn : dync) {
            orgIds.add(dyn.getLong("org"));
        }
        return orgIds;
    }

    private void changeBookVision() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject creator = (DynamicObject)this.getModel().getValue("creator");
        if (creator != null) {
            Long creatorId = creator.getLong("id");
            Map<String, Object> dpt = GlFormUtil.getDptNameByUserId(creatorId);
            this.getModel().setValue("dptnames", dpt.get("dpt"));
            long orgId = 0L;
            long curOrgId = org.getLong("id");
            orgId = org != null && AccSysUtil.isBizUnit((long)curOrgId) ? curOrgId : AccSysUtil.getAccountingOrg((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.NEW);
            if (orgId != 0L) {
                this.getModel().setValue("org", (Object)orgId);
                HashMap<String, Object> book = this.getAllBookByOrg(orgId);
                this.getModel().setValue(S_BOOKSTYPE, book.get(S_BOOKSTYPE));
                this.getModel().setValue("book", book.get("bookid"));
                this.getModel().setValue("ismultiplebook", book.get("ismultiplebook"));
            } else {
                this.getModel().setValue("org", null);
            }
        }
    }

    private HashMap<String, Object> getAllBookByOrg(Long orgId) {
        HashMap<String, Object> bookInfoMap = new HashMap<String, Object>();
        List bookIdList = AccSysUtil.getAllBookFromAccSys((long)orgId);
        if (bookIdList.isEmpty()) {
            bookInfoMap.put(S_BOOKSTYPE, 0L);
            bookInfoMap.put("bookid", 0L);
            bookInfoMap.put("ismultiplebook", "1");
        } else {
            DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache(bookIdList.get(0), (String)"gl_accountbook");
            bookInfoMap.put(S_BOOKSTYPE, book.getLong("bookstype.id"));
            if (bookIdList.size() > 1) {
                bookInfoMap.put("ismultiplebook", "1");
            }
            bookInfoMap.put("bookid", book.getLong("id"));
        }
        return bookInfoMap;
    }
}

