/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.formplugin.comassist.CommonAssistListPlugin;
import kd.fi.gl.formplugin.voucher.VoucherList;
import kd.fi.gl.formplugin.voucher.VoucherListDataProvider;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.util.voucher.VoucherHintBuilder;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CashFlowItemList
extends CommonAssistListPlugin {
    public static final String BTN_SET_CASH_FLOW = "barsetcashflow";
    public static final String FORM_ID_CASH_FLOW = "gl_voucher_cashflowedit";
    private String[] value = new String[]{"0", "a"};
    private static final String FLAG_FIRST_COUNT = "flag_first_count";
    private static final Log logger = LogFactory.getLog(CashFlowItemList.class);

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new VoucherListDataProvider(this.getView()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener(e1 -> {
            String field = e1.getFieldName();
            if (field.startsWith("org.")) {
                List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
                e1.getQfilters().add(new QFilter("id", "in", (Object)pkSet));
            }
        });
        this.addItemClickListeners(new String[]{BTN_SET_CASH_FLOW});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)BTN_SET_CASH_FLOW)) {
            StringBuilder msg;
            if (!this.canShowCashFlowModal()) {
                return;
            }
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object voucherId = selectedRows.get(0).getPrimaryKeyValue();
            boolean release = MutexHelper.require((String)"gl_voucher", (Object)voucherId, (String)"modify", (StringBuilder)(msg = new StringBuilder(16)));
            if (release) {
                this.showCashFlowModal();
            } else {
                this.getView().showErrorNotification(msg.toString());
            }
        }
    }

    @Override
    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.isCashHyperAndFirst()) {
            Map map = this.getView().getFormShowParameter().getCustomParams();
            if (map != null && map.size() > 0) {
                String num = (String)map.get("num");
                JSONArray voucherIds = (JSONArray)map.get("ids");
                String type = (String)map.get("type");
                e.getQFilters().add(new QFilter("id", "in", (Object)voucherIds));
                if (StringUtils.isNotEmpty((CharSequence)num)) {
                    List<Long> itemIds = this.getCashflowItemIdByNumber(num);
                    if (type.equals("main")) {
                        e.getQFilters().add(new QFilter("entries.maincfitem", "in", itemIds));
                    } else if (type.equals("supp")) {
                        e.getQFilters().add(new QFilter("entries.suppcfitem", "in", itemIds));
                    }
                }
            }
        } else {
            QFilter qFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
            e.getQFilters().add(qFilter);
        }
        String cfitemnumber = (String)this.getView().getFormShowParameter().getCustomParam("cfitemnumber");
        if (StringUtils.isNotEmpty((CharSequence)cfitemnumber) && (this.getPageCache().get("caniremovecustomparam") == null || this.getPageCache().get(FLAG_FIRST_COUNT) == null)) {
            this.setFilterFromCashFlowFormRpt(e);
        }
        QFilter cashQF = this.changeCashFlowQF(e);
        e.getQFilters().add(cashQF);
        this.addPeriodIdFilterIfPossible(e);
        QFilter sourcetypeQF = new QFilter("sourcetype", "!=", (Object)"1");
        e.getQFilters().add(sourcetypeQF);
        if (DebugTrace.enable()) {
            logger.info("CashFlowItemList setFilter : " + e.getQFilters().toString());
        }
    }

    private void addPeriodIdFilterIfPossible(SetFilterEvent e) {
        if (CollectionUtils.isEmpty((Collection)e.getQFilters())) {
            return;
        }
        Date startDate = null;
        Date endDate = null;
        Long orgId = null;
        Long bookTypeId = null;
        for (QFilter qFilter : e.getQFilters()) {
            if (qFilter == null) continue;
            if ("period".equals(qFilter.getProperty())) {
                return;
            }
            if ("bookeddate".equals(qFilter.getProperty())) {
                startDate = (Date)qFilter.getValue();
                List nestFilters = qFilter.getNests(false);
                if (CollectionUtils.isEmpty((Collection)nestFilters)) continue;
                if (nestFilters.size() > 1) {
                    logger.warn("\u975e\u6cd5\u7684\u65e5\u671f\u8fc7\u6ee4\u6761\u4ef6!filter={}", (Object)qFilter);
                }
                endDate = (Date)((QFilter.QFilterNest)nestFilters.get(0)).getFilter().getValue();
                continue;
            }
            if (orgId == null && "org".equals(qFilter.getProperty())) {
                if (qFilter.getValue() instanceof List) {
                    List orgIds = (List)qFilter.getValue();
                    if (orgIds.size() != 1) continue;
                    orgId = (Long)orgIds.get(0);
                    continue;
                }
                orgId = (Long)qFilter.getValue();
                continue;
            }
            if (!"booktype.id".equals(qFilter.getProperty())) continue;
            if (qFilter.getValue() instanceof List) {
                List bookTypeIds = (List)qFilter.getValue();
                if (bookTypeIds.size() <= 0) continue;
                bookTypeId = (Long)bookTypeIds.get(0);
                continue;
            }
            bookTypeId = (Long)qFilter.getValue();
        }
        if (startDate == null || bookTypeId == null) {
            logger.warn("\u67e5\u8be2\u73b0\u91d1\u6d41\u91cf\u5217\u8868\u65f6,\u53c2\u6570\u4e0d\u80fd\u4e3anull!date={},orgId={},bookTypeId={}", new Object[]{startDate, orgId, bookTypeId});
            return;
        }
        Set<Long> periodIds = this.getPeriodIdByDate(startDate, endDate, orgId, bookTypeId);
        if (CollectionUtils.isEmpty(periodIds)) {
            logger.warn("\u67e5\u8be2\u671f\u95f4\u6570\u636e\u4e3a\u7a7a!startDate={},endDate={},orgId={},bookTypeId={}", new Object[]{startDate, endDate, orgId, bookTypeId});
            return;
        }
        QFilter periodIdFilter = new QFilter("period.id", "in", periodIds);
        e.getQFilters().add(periodIdFilter);
    }

    private Set<Long> getPeriodIdByDate(Date startDate, Date endDate, Long orgId, Long bookTypeId) {
        Set<Object> periodIds;
        if (orgId == null || orgId == 0L) {
            periodIds = endDate == null ? CashFlowItemList.getPeriodByDate(startDate) : GLUtil.getPeriodIdSet((Date)startDate, (Date)endDate);
        } else {
            DynamicObjectCollection periodResult;
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
            periodIds = endDate == null ? (CollectionUtils.isEmpty((Collection)(periodResult = GLUtil.getPeriodByDate((Date)startDate, (String)"id", (long)bookInfo.getPeriodTypeId(), (Boolean)Boolean.TRUE))) ? Collections.emptySet() : periodResult.stream().map(o -> (Long)o.get("id")).collect(Collectors.toSet())) : GLUtil.getPeriodIdSet((Date)startDate, (Date)endDate, (long)bookInfo.getPeriodTypeId(), (Boolean)Boolean.TRUE);
        }
        return periodIds;
    }

    private static Set<Long> getPeriodByDate(Date date) {
        Date end = DateUtil.makeDateOnDayEnd((Date)date);
        QFilter f = new QFilter("beginDate", "<=", (Object)end);
        QFilter g = new QFilter("enddate", ">=", (Object)end);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{f, g}, (String)"id desc");
        HashSet<Long> pdIdSet = new HashSet<Long>();
        for (DynamicObject pd : coll) {
            pdIdSet.add(pd.getLong("id"));
        }
        return pdIdSet;
    }

    private void setFilterFromCashFlowFormRpt(SetFilterEvent e) {
        String cfitemLongNumber;
        List periods;
        FormShowParameter formShow = this.getView().getFormShowParameter();
        Map comassistMultiMap = (Map)formShow.getCustomParam("comassist");
        if (MapUtils.isNotEmpty((Map)comassistMultiMap)) {
            comassistMultiMap.forEach((comAssistKey, values) -> e.getQFilters().add(new QFilter(String.join((CharSequence)".", "entries", comAssistKey), "in", values)));
        }
        if (!CollectionUtils.isEmpty((Collection)(periods = (List)formShow.getCustomParam("periods")))) {
            e.getQFilters().add(new QFilter("period", "in", (Object)periods));
        }
        if (StringUtils.isNotEmpty((CharSequence)(cfitemLongNumber = (String)this.getView().getFormShowParameter().getCustomParam("cfitemlongnumber")))) {
            JSONArray jsonArray = (JSONArray)formShow.getCustomParam("sublongnumber");
            List subLongNumber = new ArrayList();
            if (jsonArray != null) {
                subLongNumber = JSONObject.parseArray((String)jsonArray.toJSONString(), String.class);
            }
            List<Long> itemList = this.getCashflowItemIdByLongNumber(cfitemLongNumber, subLongNumber);
            String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
            QFilter cfFilter = "1".equals(type) ? new QFilter("entries.maincfitem", "in", itemList) : new QFilter("entries.suppcfitem", "in", itemList);
            e.getQFilters().add(cfFilter);
        }
        this.getPageCache().put("caniremovecustomparam", "no");
        JSONArray assgrp = (JSONArray)formShow.getCustomParam("assgrp");
        if (assgrp != null) {
            e.getQFilters().add(new QFilter(String.join((CharSequence)".", "entries", "maincfassgrp"), "in", (Object)assgrp));
        } else {
            Boolean showinsidecf = (Boolean)formShow.getCustomParam("showinsidecf");
            if (showinsidecf == null) {
                return;
            }
            JSONArray intassgrp = (JSONArray)formShow.getCustomParam("intassgrp");
            if (showinsidecf.booleanValue()) {
                e.getQFilters().add(new QFilter(String.join((CharSequence)".", "entries", "maincfassgrp"), "in", (Object)intassgrp));
            } else {
                e.getQFilters().add(new QFilter(String.join((CharSequence)".", "entries", "maincfassgrp"), "not in", (Object)intassgrp));
            }
        }
    }

    private QFilter changeCashFlowQF(SetFilterEvent e) {
        ListIterator iterator = e.getQFilters().listIterator();
        String mainQfValue = "";
        String suppQfValue = "";
        while (iterator.hasNext()) {
            QFilter qf = (QFilter)iterator.next();
            String value = qf.getValue() + "";
            if ("mainstatus".equals(qf.getProperty())) {
                if (!"6".equals(value) && !"7".equals(value)) continue;
                mainQfValue = value;
                iterator.remove();
                continue;
            }
            if (!"suppstatus".equals(qf.getProperty()) || !"4".equals(value) && !"5".equals(value)) continue;
            suppQfValue = value;
            iterator.remove();
        }
        switch (suppQfValue + mainQfValue) {
            case "46": {
                this.value = new String[]{"1", "2"};
                return new QFilter("mainstatus", "in", (Object)this.value);
            }
            case "47": {
                return new QFilter("mainstatus", "=", (Object)"3");
            }
            case "56": {
                this.value = new String[]{"1", "2", "b"};
                return new QFilter("suppstatus", "in", (Object)this.value);
            }
            case "57": {
                this.value = new String[]{"3", "c"};
                return new QFilter("suppstatus", "in", (Object)this.value);
            }
            case "4": {
                return new QFilter("mainstatus", "!=", (Object)"0");
            }
            case "5": {
                this.value = new String[]{"0", "a"};
                return new QFilter("suppstatus", "not in", (Object)this.value);
            }
            case "6": {
                this.value = new String[]{"1", "2", "b"};
                return new QFilter("mainstatus", "in", (Object)this.value).or(new QFilter("suppstatus", "in", (Object)this.value));
            }
            case "7": {
                this.value = new String[]{"3", "c"};
                return new QFilter("mainstatus", "in", (Object)this.value).or(new QFilter("suppstatus", "in", (Object)this.value));
            }
        }
        return new QFilter("mainstatus", "not in", (Object)this.value).or(new QFilter("suppstatus", "not in", (Object)this.value));
    }

    private boolean isCashHyperAndFirst() {
        String source;
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return map != null && map.size() > 0 && ("CashFlowDesignate".equals(source = (String)map.get("source")) || "MainDesignate".equals(source)) && this.getPageCache().get(FLAG_FIRST_COUNT) == null;
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if ("org.name".equals(args.getFieldName())) {
            FilterColumn column = (FilterColumn)args.getSource();
            String entityId = column.getEntityType().getName();
            QFilter filter = AccSysUtil.getAccountingOrgFilter((String)entityId, (boolean)false, (PermissonType)PermissonType.VIEW);
            args.getQFilters().add(filter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Long customFilterOrgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
        Long loginorg = 0L;
        Long customOrg = 0L;
        IPageCache cache = this.getPageCache();
        FormShowParameter formShow = this.getView().getFormShowParameter();
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        block10: for (FilterColumn filterColumn : listFilterColumns) {
            String fieldName;
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            switch (fieldName = commFilter.getFieldName()) {
                case "org.name": {
                    Set comboOrgIds = AccSysUtil.getAllOrgIdByComboItems((Collection)commFilter.getComboItems());
                    Object org = formShow.getCustomParam("org");
                    if (org != null) {
                        commFilter.setDefaultValue(org.toString());
                        customOrg = Long.valueOf(org + "");
                        break;
                    }
                    if (comboOrgIds.size() <= 0) break;
                    Long defaultOrgId = AccSysUtil.getDefaultOrgId((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
                    if (!comboOrgIds.contains(defaultOrgId)) {
                        defaultOrgId = GlFormUtil.getDefaultAcctOrg(new ArrayList<Long>(comboOrgIds));
                    }
                    if (defaultOrgId == null) continue block10;
                    commFilter.setDefaultValue(defaultOrgId.toString());
                    loginorg = defaultOrgId;
                    break;
                }
                case "bookeddate": {
                    List bookedDate = (List)formShow.getCustomParam("bookeddate");
                    if (bookedDate == null) break;
                    commFilter.setDefaultValues(bookedDate);
                    break;
                }
                case "booktype.name": {
                    List bookTypeCombos;
                    if (customFilterOrgId != null) {
                        bookTypeCombos = AccSysUtil.getBookTypeComboByOrg((long)customFilterOrgId);
                    } else if (customOrg > 0L && StringUtils.isEmpty((CharSequence)cache.get("firstQueryFormOther"))) {
                        cache.put("firstQueryFormOther", "true");
                        cache.put("firstView", "true");
                        bookTypeCombos = AccSysUtil.getBookTypeComboByOrg((long)customOrg);
                    } else if (StringUtils.isEmpty((CharSequence)cache.get("firstView"))) {
                        cache.put("firstView", "true");
                        bookTypeCombos = AccSysUtil.getBookTypeComboByOrg((long)loginorg);
                    } else {
                        List orgs = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
                        bookTypeCombos = AccSysUtil.getBookTypeCombo((List)orgs);
                    }
                    commFilter.setComboItems(bookTypeCombos);
                    if (!bookTypeCombos.isEmpty()) {
                        String defBookType = null;
                        List values = bookTypeCombos.stream().map(ComboItem::getValue).collect(Collectors.toList());
                        String cusBookType = (String)formShow.getCustomParam("booktype");
                        if (cusBookType != null && values.contains(cusBookType)) {
                            defBookType = cusBookType;
                        } else if (StringUtils.isEmpty((CharSequence)cache.get("firstQueryFormOther"))) {
                            defBookType = ((ComboItem)bookTypeCombos.get(0)).getValue();
                        }
                        commFilter.setDefaultValue(defBookType);
                        break;
                    }
                    cache.put("nobooktype", "true");
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
        if ("account_number".equals(hyperClick.getFieldName())) {
            this.viewSubledgerRpt(hyperClick);
            args.setCancel(true);
        }
    }

    private void viewSubledgerRpt(HyperLinkClickEvent hyperClick) {
        DynamicObject voucherDyn;
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)hyperClick).getCurrentRow();
        Long voucherId = (Long)currentRow.getPrimaryKeyValue();
        Long entryId = (Long)currentRow.getEntryPrimaryKeyValue();
        String selectFields = String.join((CharSequence)",", "org", "booktype", "book.periodtype", "period", "entries.currency", "entries.account", "entries.account.accounttable", "entries.account.level", CommonAssistUtil.getAllSelectKeys((String)"gl_voucher"));
        try (ShardingHintContext ignored = VoucherHintBuilder.buildPKHint(Collections.singletonList(voucherId));){
            voucherDyn = QueryServiceHelper.queryOne((String)"gl_voucher", (String)selectFields, (QFilter[])new QFilterBuilder().addEqual("id", (Object)voucherId).addEqual("entries.id", (Object)entryId).toArray(new QFilter[0]));
        }
        if (null == voucherDyn) {
            return;
        }
        long orgID = voucherDyn.getLong("org");
        long accountTableId = voucherDyn.getLong("entries.account.accounttable");
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("booktype", (Object)voucherDyn.getLong("booktype"));
        filter.addFilterItem("orgs", Collections.singletonList(orgID));
        filter.addFilterItem("orgview", null);
        filter.addFilterItem("periodtype", (Object)voucherDyn.getLong("book.periodtype"));
        filter.addFilterItem("startperiod", (Object)voucherDyn.getLong("period"));
        filter.addFilterItem("endperiod", (Object)voucherDyn.getLong("period"));
        filter.addFilterItem("searchtype", (Object)"1");
        filter.addFilterItem("currency", (Object)voucherDyn.getLong("entries.currency"));
        filter.addFilterItem("accounttable", (Object)accountTableId);
        filter.addFilterItem("accountlevel", (Object)voucherDyn.getInt("entries.account.level"));
        filter.addFilterItem("showleafaccount", (Object)(voucherDyn.getInt("entries.account.level") > 1 ? 1 : 0));
        filter.addFilterItem("account", (Object)voucherDyn.getLong("entries.account"));
        ComAssistTable comAssistTable = ComAssistTable.get((Long)accountTableId);
        comAssistTable.getCommonAssists().forEach(commonAssist -> filter.addFilterItem(commonAssist.key, (Object)voucherDyn.getLong(commonAssist.key)));
        if (!CollectionUtils.isEmpty((Collection)comAssistTable.getCommonAssists())) {
            filter.addFilterItem("showcomassist", (Object)"1");
        }
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId("gl_rpt_subledger");
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)report);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList list = (BillList)this.getControl("billlistap");
        List orgIds = list.getSelectedMainOrgIds();
        if (orgIds != null && orgIds.size() > 1) {
            List columns = list.getBeforeCreateListColumnsArgs().getListColumns();
            for (IListColumn column : columns) {
                DecimalListColumn c;
                if (column.getListFieldKey().equals("debitlocal")) {
                    c = (DecimalListColumn)column;
                    c.setSummary(0);
                }
                if (column.getListFieldKey().equals("creditlocal")) {
                    c = (DecimalListColumn)column;
                    c.setSummary(0);
                }
                if (column.getListFieldKey().equals("maincfamount")) {
                    c = (DecimalListColumn)column;
                    c.setSummary(0);
                }
                if (!column.getListFieldKey().equals("suppcfamount")) continue;
                c = (DecimalListColumn)column;
                c.setSummary(0);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        IListView view = (IListView)this.getView();
        ControlFilters cfs = view.getControlFilters();
        Map map = cfs.getFilters();
        if (map.containsKey("org.name")) {
            if (field.startsWith("account.")) {
                ControlFilter cf = (ControlFilter)map.get("org.name");
                String type = cf.getCompareType();
                List vals = cf.getValue();
                if (vals.size() == 1 && !"".equals(vals.get(0).toString().trim())) {
                    QFilter filter = null;
                    if ("110".equals(type) || "111".equals(type)) {
                        filter = new QFilter("name", "=", vals.get(0));
                    } else if ("59".equals(type)) {
                        filter = new QFilter("name", "like", vals.get(0));
                    }
                    DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter});
                    if (null != org && field.startsWith("account.")) {
                        QFilter orgId;
                        List val;
                        QFilter bf;
                        DynamicObject acctbook;
                        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)org.getLong("id"));
                        args.addCustomQFilter(acctFilter);
                        ControlFilter booktype = (ControlFilter)map.get("booktype.name");
                        if (null != booktype && null != (acctbook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{bf = new QFilter("bookstype.name", "=", (val = booktype.getValue()).get(0)), orgId = new QFilter("org", "=", (Object)org.getLong("id"))}))) {
                            QFilter faccttable = new QFilter("accounttable", "=", (Object)acctbook.getLong("accounttable"));
                            args.addCustomQFilter(faccttable);
                        }
                    }
                }
            }
        } else if (field.startsWith("booktype")) {
            List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
            List bookTypeIdList = AccSysUtil.getBookTypeIdList((List)orgIds);
            args.addCustomQFilter(new QFilter("id", "in", (Object)bookTypeIdList));
        } else if (field.startsWith("maincfitem")) {
            args.addCustomQFilter(new QFilter("masterid", "=", (Object)"id", true));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.getPageCache().put(FLAG_FIRST_COUNT, "false");
        Map filValues = args.getFilterValues();
        List customFils = (List)filValues.get("customfilter");
        if (customFils == null || customFils.size() == 0) {
            return;
        }
        boolean isClear = true;
        Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
        if (null == orgId) {
            return;
        }
        List comboItems = AccSysUtil.getBookTypeComboByOrg((long)orgId);
        for (Map map : customFils) {
            String fieldName = (String)((List)map.get("FieldName")).get(0);
            List val = (List)map.get("Value");
            if (!"booktype.id".equals(fieldName)) continue;
            if (val.isEmpty() || val.get(0).equals("")) break;
            for (ComboItem ci : comboItems) {
                if (!ci.getValue().equals(val.get(0).toString())) continue;
                isClear = false;
                break;
            }
            if (!isClear) continue;
            val.clear();
            if (comboItems.size() > 0) {
                val.add(((ComboItem)comboItems.get(0)).getValue());
                continue;
            }
            val.add("");
        }
    }

    private boolean canShowCashFlowModal() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (this.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CashFlowItemList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long voucherId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        if (selectedRows.size() > 1 && !this.isSameVoucher(voucherId, selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u51ed\u8bc1\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CashFlowItemList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject voucher = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_voucher", (String)"org.id, booktype.id, period.id, billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)voucherId)});
        Long orgId = (Long)voucher.get("org.id");
        if (!GLUtil.isCurrentVoucherAllowModifyCF((long)orgId, (long)voucher.getLong("booktype.id"), (long)voucher.getLong("period.id"), (String)voucher.getString("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u6216\u5df2\u8fc7\u8d26\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u3002", (String)"CashFlowItemList_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)voucher.getLong("org.id"), (long)voucher.getLong("booktype.id"));
        if (accountBookInfo.getCashinitPeriodId() == 0L || accountBookInfo.getCashinitPeriodId() > voucher.getLong("period.id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u672a\u8bbe\u7f6e\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\uff0c\u6216\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u5927\u4e8e\u51ed\u8bc1\u6240\u5c5e\u4f1a\u8ba1\u671f\u95f4\u3002\u8bf7\u68c0\u67e5\u8d26\u7c3f\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u662f\u5426\u6b63\u786e\u3002", (String)"CashFlowItemList_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.isCurrentPeriod(accountBookInfo, voucher) || orgId != null && SystemParamHelper.getBooleanParam((String)"mdifyhiscfitem", (long)orgId, (boolean)false)) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u5f00\u542f\u7cfb\u7edf\u53c2\u6570:\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u3002", (String)"CashFlowItemList_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        return false;
    }

    private boolean isCurrentPeriod(AccountBookInfo accountBookInfo, DynamicObject voucher) {
        Long periodId = voucher.getLong("period.id");
        return periodId >= accountBookInfo.getCurPeriodId();
    }

    private boolean isSameVoucher(Long voucherId, ListSelectedRowCollection selectedRows) {
        return voucherId.equals(selectedRows.get(selectedRows.size() - 1).getPrimaryKeyValue());
    }

    private void showCashFlowModal() {
        ListSelectedRow selectedRow = this.getSelectedRows().get(0);
        BillShowParameter param = new BillShowParameter();
        param.setFormId(FORM_ID_CASH_FLOW);
        param.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e\u73b0\u91d1\u6d41\u91cf", (String)"CashFlowItemList_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        param.setPkId(selectedRow.getPrimaryKeyValue());
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SET_CASH_FLOW));
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (BTN_SET_CASH_FLOW.equals(closedCallBackEvent.getActionId()) && Boolean.TRUE.equals(closedCallBackEvent.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    protected String getBillEntity() {
        return "gl_voucher";
    }

    @Override
    protected List<Long> getOrgID() {
        FormShowParameter formShow;
        Object cusOrg;
        List filterValues = CommonAssistUtil.getOrgCommonFilterColumnValues((IFormView)this.getView(), (String)this.getOrgKey());
        this.getPageCache().put("alluseorg", JSONObject.toJSONString((Object)filterValues));
        if (CollectionUtils.isEmpty((Collection)filterValues) && ObjectUtils.isNotEmpty((Object)(cusOrg = (formShow = this.getView().getFormShowParameter()).getCustomParam("org")))) {
            return Collections.singletonList(Long.parseLong(cusOrg.toString()));
        }
        return super.getOrgID();
    }

    @Override
    protected List<Long> getBookTypeID(List<Long> orgIdList) {
        FormShowParameter formShow;
        Object cusBookType;
        List filterValues = CommonAssistUtil.getBookTypeCommonFilterColumnValues((IFormView)this.getView(), (String)this.getBookTypeKey());
        if (CollectionUtils.isEmpty((Collection)filterValues) && ObjectUtils.isNotEmpty((Object)(cusBookType = (formShow = this.getView().getFormShowParameter()).getCustomParam("booktype")))) {
            return Collections.singletonList(Long.parseLong(cusBookType.toString()));
        }
        return super.getBookTypeID(orgIdList);
    }

    private List<Long> getCashflowItemIdByNumber(String number) {
        Map cashflowItems = BusinessDataServiceHelper.loadFromCache((String)"gl_cashflowitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        ArrayList<Long> itemList = new ArrayList<Long>(8);
        for (Map.Entry cashflowItem : cashflowItems.entrySet()) {
            itemList.add(((DynamicObject)cashflowItem.getValue()).getLong("id"));
        }
        return itemList;
    }

    private List<Long> getCashflowItemIdByLongNumber(String longNumber, List subLongNumber) {
        QFilter longNumberQf = new QFilter("longnumber", "=", (Object)longNumber).or(new QFilter("longnumber", "like", (Object)(longNumber + "@%")));
        QFilter subLongNumberQf = new QFilter("longnumber", "not in", (Object)subLongNumber);
        Map cashflowItems = BusinessDataServiceHelper.loadFromCache((String)"gl_cashflowitem", (String)"id", (QFilter[])new QFilter[]{longNumberQf, subLongNumberQf});
        ArrayList<Long> itemList = new ArrayList<Long>(8);
        for (Map.Entry cashflowItem : cashflowItems.entrySet()) {
            itemList.add(((DynamicObject)cashflowItem.getValue()).getLong("id"));
        }
        return itemList;
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        new VoucherList().listColumnCompareTypesSet(args);
    }
}

