/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.assign.OpLogHelper;
import kd.fi.bd.cache.CacheHelper;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.DistributeCache;
import kd.fi.bd.cashflow.CashflowRelationFactory;
import kd.fi.bd.cfversion.CashflowItemOptionVarManager;
import kd.fi.bd.cfversion.addassist.CfitemAddingAssistService;
import kd.fi.bd.cfversion.addassist.CfitemAddingAssistServiceImpl;
import kd.fi.bd.cfversion.addassist.CfitemAssistAddingContext;
import kd.fi.bd.enhance.treetask.CfitemContext;
import kd.fi.bd.enhance.treetask.DependBiTreeNode;
import kd.fi.bd.enums.CashFlowItemErrorCode;
import kd.fi.bd.lock.AssisstAddingLockHelper;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.CashflowItemVersionUtil;
import kd.fi.bd.util.POIUtils;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.CashflowItemOrgVo;
import kd.fi.gl.formplugin.cfext.CashflowVersionSaveExtension;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CashflowItemVersionEdit
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(CashflowItemVersionEdit.class);
    public static final String BATCHADDINGASSIST = "batchAddingAssist";
    public static final String IS_FINISH = "batchAddingAssistisFinish";
    public static final String IS_SUCCESS = "batchAddingAssistisSuccess";
    public static final String TOTAL_COUNT = "batchAddingAssisttotalCount";
    public static final String ACCOUNTNUMBER = "batchAddingAssistaccountNumber";
    public static final String TASKEXECUTIONRESULTS = "batchAddingAssisttaskExecutionResults";
    public static final String ERROR_INFO = "batchAddingAssisterrorInfo";
    public static final String PROGRESSBARAP = "progressbarap";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.addingassit);
    private Boolean isShare = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String operationKey = ((Control)evt.getSource()).getKey();
        if ("save".equalsIgnoreCase(operationKey)) {
            DynamicObject cashflowItem = this.getModel().getDataEntity(true);
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.EDIT.equals((Object)status) && Long.parseLong(String.valueOf(this.getModel().getDataEntity().getPkValue())) != 0L) {
                boolean isVersioning = this.getView().getFormShowParameter().getCustomParam("isPersonalizeData") != null;
                boolean isLeafOrg = BDUtil.isLeafOrg((Object)cashflowItem.getLong("useorg_id"));
                boolean isLeafItem = cashflowItem.getBoolean("isleaf");
                DynamicObject dbItem = BusinessDataServiceHelper.loadSingle((Object)cashflowItem.getLong("id"), (String)"gl_cashflowitem");
                List addingAssistList = CashflowItemVersionUtil.getAddingAssistList((DynamicObject)cashflowItem, (DynamicObject)dbItem);
                boolean isAddAssistGrp = !CollectionUtils.isEmpty((Collection)addingAssistList);
                this.isShare = CashflowItemVersionUtil.isShareCtrlStrategy((DynamicObject)cashflowItem);
                if ((!isLeafItem || !isLeafOrg && CashflowItemVersionUtil.isPersonalized((long)cashflowItem.getLong("id")).booleanValue()) && isVersioning && isAddAssistGrp) {
                    OperateOption option = OperateOption.create();
                    CashflowItemOptionVarManager.setBatchaddingAssist((OperateOption)option, (boolean)true);
                    CashflowItemOptionVarManager.setIsVersion((OperateOption)option, (boolean)true);
                    CashflowItemOptionVarManager.setIsOnlyValidate((OperateOption)option, (boolean)true);
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"gl_cashflowitem", (DynamicObject[])new DynamicObject[]{cashflowItem}, (OperateOption)option);
                    String validateMsg = BDUtil.buildOperationResultFailedMsg((OperationResult)operationResult, (boolean)true);
                    if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
                        this.getView().showTipNotification(validateMsg);
                        return;
                    }
                    boolean isValidateSuccess = this.dealChildOrgAndAccAddingAssistValidate(cashflowItem, CashflowItemVersionUtil.getAllAssistList((DynamicObject)cashflowItem));
                    if (isValidateSuccess) {
                        this.executeSaveop(true, true);
                    }
                } else {
                    DynamicObject dbDyo = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"gl_cashflowitem");
                    DynamicObject dyn = this.getModel().getDataEntity(true);
                    boolean isAddAssgrp = this.isAddAssgrp(dyn, dbDyo);
                    this.executeSaveop(isAddAssgrp, false);
                }
            } else {
                boolean isversionaddleaf = this.isFirstAddLeaf();
                boolean assign = this.needAssignFirstLeaf();
                if (isversionaddleaf && assign) {
                    ConfirmCallBackListener confirm = new ConfirmCallBackListener("version_add_leaf_save_confirmsdf", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u65b0\u589e\u7684\u7b2c\u4e00\u4e2a\u4e0b\u7ea7\u9879\u76ee\u4f1a\u81ea\u52a8\u5206\u914d\u7ed9\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fdd\u5b58\uff1f", (String)"CashflowItemVersionEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
                } else {
                    String key = this.getLockKey();
                    try (DLock lock = DLock.create((String)key).fastMode();){
                        if (lock.tryLock()) {
                            this.executeSaveop(false, false);
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u4fdd\u5b58\u76f8\u540c\u7f16\u7801\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CashflowItemVersionEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }
        }
    }

    private boolean needAssignFirstLeaf() {
        DynamicObject oldObj = this.getModel().getDataEntity();
        DynamicObject parent = oldObj.getDynamicObject("parent");
        if (parent == null || "5".equals(parent.getString("ctrlstrategy"))) {
            return false;
        }
        return CashflowRelationFactory.get().isAssigned(parent.getLong("id"), oldObj.getLong("useorg_id"));
    }

    private boolean isAddAssgrp(DynamicObject dyo, DynamicObject dyoDb) {
        DynamicObjectCollection entry = dyo.getDynamicObjectCollection("assistentry");
        DynamicObjectCollection entryDb = dyoDb.getDynamicObjectCollection("assistentry");
        List entryDbItemIds = BDUtil.getKeyFieldIdsInEntry((DynamicObjectCollection)entryDb, (String)"asstypeid");
        for (DynamicObject erow : entry) {
            DynamicObject item = erow.getDynamicObject("asstypeid");
            if (item == null || entryDbItemIds.contains(item.getLong("id"))) continue;
            return true;
        }
        return false;
    }

    private boolean dealChildOrgAndAccAddingAssistValidate(DynamicObject cashflowItem, List<AssistEntryVO> addingAssistList) {
        boolean hasFailedResult = false;
        long useorgId = cashflowItem.getLong("useorg_id");
        Date versionDate = cashflowItem.getDate("startdate");
        long itemId = cashflowItem.getLong("id");
        String cfNumber = cashflowItem.getString("number");
        try {
            CfitemAddingAssistServiceImpl addingAssistService = new CfitemAddingAssistServiceImpl();
            CfitemAssistAddingContext assistAddingContext = new CfitemAssistAddingContext(itemId, useorgId, versionDate, addingAssistList, (CfitemAddingAssistService)addingAssistService);
            List<Object> taskExecutionResults = CashflowVersionSaveExtension.executeValidateAssistOp(assistAddingContext);
            hasFailedResult = taskExecutionResults.stream().anyMatch(x -> TaskExecutionResult.Status.failed == x.getStatus());
            if (!hasFailedResult) {
                return true;
            }
            Set resultSet = taskExecutionResults.stream().map(x -> (CashflowItemOrgVo)x.getData()).collect(Collectors.toSet());
            List orgIdList = resultSet.stream().map(x -> x.getOrgId()).collect(Collectors.toList());
            Map orgIdNameMap = AccountVersionUtil.getOrgNameByIds(orgIdList);
            for (TaskExecutionResult<CashflowItemOrgVo> taskExecutionResult : taskExecutionResults) {
                CashflowItemOrgVo data = (CashflowItemOrgVo)taskExecutionResult.getData();
                data.setOrgName((String)orgIdNameMap.get(data.getOrgId()));
            }
            taskExecutionResults = taskExecutionResults.stream().filter(x -> !"S001".equals(x.getMsgCode())).collect(Collectors.toList());
            String url = POIUtils.getDownloadUrl((SXSSFWorkbook)POIUtils.fillCashflowItemResultWorkbook(taskExecutionResults), (String)POIUtils.generateFileName((String)String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee%s\u6821\u9a8c\u660e\u7ec6", (String)"CashflowItemVersionEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), cfNumber)));
            this.getPageCache().put("beforeDownloadUrl", url);
            StringBuilder stringBuilder = new StringBuilder();
            int failedCount = 0;
            List<TaskExecutionResult> failedResultList = taskExecutionResults.stream().filter(x -> TaskExecutionResult.Status.failed == x.getStatus() || TaskExecutionResult.Status.fast_failed == x.getStatus()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(failedResultList)) {
                failedCount = failedResultList.size();
                failedResultList.forEach(x -> resultDetail.append(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7-%2$s\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff1a", (String)"CashflowItemVersionEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), ((CashflowItemOrgVo)x.getData()).getOrgName(), ((CashflowItemOrgVo)x.getData()).getItemNumber())).append(x.getFailedMsg()).append("\r\n"));
            }
            int successCount = 0;
            List successResultList = taskExecutionResults.stream().filter(x -> TaskExecutionResult.Status.success == x.getStatus()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(successResultList)) {
                successCount = successResultList.size();
            }
            StringBuilder resultSummary = new StringBuilder(String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee%s\u6821\u9a8c\u660e\u7ec6", (String)"CashflowItemVersionEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), successCount + failedCount, successCount, failedCount));
            MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
            ConfirmTypes confirmTypes = ConfirmTypes.Save;
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("before_save_confirm", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
            btnNameMaps.put(6, ResManager.loadKDString((String)"\u4e0b\u8f7d\u660e\u7ec6", (String)"CashflowItemVersionEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(2, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CashflowItemVersionEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(7, ResManager.loadKDString((String)"\u7ee7\u7eed\u4fdd\u5b58", (String)"CashflowItemVersionEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(resultSummary.toString(), stringBuilder.toString(), options, confirmTypes, callBackListener, btnNameMaps);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        var2_2 = e.getCallBackId();
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case -1692790082: {
                if (!var2_2.equals("before_save_confirm")) break;
                var3_3 = 0;
                break;
            }
            case 496061313: {
                if (!var2_2.equals("after_save_confirm")) break;
                var3_3 = 1;
                break;
            }
            case -1681677061: {
                if (!var2_2.equals("version_add_leaf_save_confirmsdf")) break;
                var3_3 = 2;
            }
        }
        switch (var3_3) {
            case 0: {
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)this.getPageCache().get("beforeDownloadUrl"));
                    break;
                }
                if (!MessageBoxResult.No.equals((Object)e.getResult())) break;
                this.executeSaveop(true, true);
                break;
            }
            case 1: {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)this.getPageCache().get("afterDownloadUrl"));
                break;
            }
            case 2: {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                key = this.getLockKey();
                lock = DLock.create((String)key).fastMode();
                var6_6 = null;
                if (lock.tryLock()) {
                    this.executeSaveop(false, false);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u4fdd\u5b58\u76f8\u540c\u7f16\u7801\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CashflowItemVersionEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
                if (lock == null) break;
                if (var6_6 == null) ** GOTO lbl46
                try {
                    lock.close();
                }
                catch (Throwable var7_7) {
                    var6_6.addSuppressed(var7_7);
                }
                break;
lbl46:
                // 1 sources

                lock.close();
                break;
                catch (Throwable var7_8) {
                    try {
                        var6_6 = var7_8;
                        throw var7_8;
                    }
                    catch (Throwable var8_9) {
                        if (lock != null) {
                            if (var6_6 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable var9_10) {
                                    var6_6.addSuppressed(var9_10);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        throw var8_9;
                    }
                }
            }
        }
    }

    private boolean isFirstAddLeaf() {
        DynamicObject oldObj = this.getModel().getDataEntity();
        return Objects.nonNull(oldObj.getDynamicObject("parent")) && oldObj.getDynamicObject("parent").getBoolean("isleaf");
    }

    private String getLockKey() {
        String key = "fi/bd/savecfitem/" + this.getModel().getValue("number");
        return key;
    }

    private void executeSaveop(boolean isAddAssgrp, boolean isSupervisor) {
        boolean isVersioning = this.getView().getFormShowParameter().getCustomParam("isPersonalizeData") != null;
        OperateOption op = OperateOption.create();
        if (!this.setPersonalOp(op)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject cashflowItem = model.getDataEntity(true);
        if (isVersioning || this.isFirstAddLeaf()) {
            CashflowItemOptionVarManager.setIsVersion((OperateOption)op, (boolean)true);
        }
        if (isAddAssgrp && isSupervisor) {
            long useOrgId = cashflowItem.getLong("useorg_id");
            Date versionDate = cashflowItem.getDate("startdate");
            long accountId = cashflowItem.getLong("id");
            List addingAssistList = CashflowItemVersionUtil.getAllAssistList((DynamicObject)cashflowItem);
            CfitemAddingAssistServiceImpl addingAssistService = new CfitemAddingAssistServiceImpl();
            CfitemAssistAddingContext opContext = new CfitemAssistAddingContext(accountId, useOrgId, versionDate, addingAssistList, (CfitemAddingAssistService)addingAssistService);
            String accLongNum = cashflowItem.getString("longnumber");
            String firstAccNum = accLongNum.split("_")[0];
            Optional workingLockInfo = AssisstAddingLockHelper.getWorkingLockInfo((String)firstAccNum);
            if (workingLockInfo.isPresent()) {
                this.getView().showTipNotification(((DLockInfo)workingLockInfo.get()).getDesc());
            } else {
                this.executeAddingAssist(opContext, firstAccNum, useOrgId, cashflowItem, op);
            }
        } else {
            OperationResult rs = OperationServiceHelper.executeOperate((String)"save", (String)"gl_cashflowitem", (DynamicObject[])new DynamicObject[]{cashflowItem}, (OperateOption)op);
            if (rs != null) {
                if (rs.isSuccess()) {
                    String[] descParams = new String[]{};
                    this.addSaveOperateLog(new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "CashflowItemVersionEdit_8", "fi-gl-formplugin"), descParams);
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CashflowItemVersionEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                } else {
                    String[] descParams = new String[]{};
                    this.addSaveOperateLog(new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25\u3002", "CashflowItemVersionEdit_16", "fi-gl-formplugin"), descParams);
                    StringBuilder mes = new StringBuilder();
                    for (ValidateResult vr : rs.getValidateResult().getValidateErrors()) {
                        for (OperateErrorInfo orinfo : vr.getAllErrorInfo()) {
                            mes.append(orinfo.getMessage()).append("\n");
                        }
                    }
                    boolean isCloseCurrView = true;
                    if (mes.length() > 0) {
                        isCloseCurrView = false;
                    }
                    if (!CollectionUtils.isEmpty((Collection)rs.getAllErrorInfo())) {
                        mes.append(rs.getAllErrorInfo().stream().map(x -> x.getMessage()).collect(Collectors.joining("\n")));
                        if (isCloseCurrView && rs.getAllErrorInfo().stream().anyMatch(x -> null == x.getErrorCode() || !x.getErrorCode().equals(CashFlowItemErrorCode.AUTO_ASSIGN.getValue()))) {
                            isCloseCurrView = false;
                        }
                    }
                    if (isCloseCurrView) {
                        this.getView().getParentView().showTipNotification(mes.toString());
                        this.getView().close();
                    } else {
                        this.getView().showTipNotification(mes.toString());
                        this.getView().updateView("assistentry");
                    }
                }
            }
        }
    }

    private void addSaveOperateLog(MultiLangEnumBridge opDescBridge, String ... params) {
        long useorgId = Long.parseLong(String.valueOf(this.getModel().getValue("useorg_id")));
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "CashflowItemVersionEdit_17", "fi-gl-formplugin");
        new OpLogHelper().addOperateLog(this.getView(), useorgId, "", "cashflowSave", opNameBridge, opDescBridge, params);
    }

    private void executeAddingAssist(CfitemAssistAddingContext opContext, String firstAccNum, long useOrgId, DynamicObject cashflowItem, OperateOption op) {
        String desc = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6b63\u5728\u88ab\u7528\u6237%s\u8fdb\u884c\u6dfb\u52a0\u7ef4\u5ea6\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CashflowItemVersionEdit_9", (String)"fi-bd-formplugin", (Object[])new Object[0]), RequestContext.get().getUserName());
        AssisstAddingLockHelper.assistAddingWithLock((String)firstAccNum, (String)desc, lock -> {
            Optional errorMsg = Optional.empty();
            if (errorMsg.isPresent()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"FormpluginResource_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), (String)errorMsg.get(), MessageTypes.Default);
            } else {
                long reInitTick = System.currentTimeMillis();
                opContext.initContext();
                opContext.initRootTask();
                LOGGER.info(String.format("assist_adding_context re_initialization cost: %s", System.currentTimeMillis() - reInitTick));
                DependBiTreeNode rootTaskNode = opContext.getRootTask();
                int totalCount = rootTaskNode.collect(BiTreeNode::getId).size();
                if (this.isShare.booleanValue()) {
                    totalCount = opContext.getAllCreateOrgCfitemIdSet().size();
                }
                String pageId = this.getView().getPageId();
                String finishedCountCacheKey = pageId + "finishedCount";
                this.cache.put(finishedCountCacheKey, "0");
                this.getPageCache().put(IS_FINISH, "false");
                this.getPageCache().put(TOTAL_COUNT, String.valueOf(totalCount));
                ((ProgressBar)this.getControl(PROGRESSBARAP)).start();
                LOGGER.info("\u9884\u8ba1\u7248\u672c\u5316\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6570\u91cf 1074 :" + this.isShare);
                this.getView().showLoading(new LocaleString(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u7248\u672c\u5316\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6570\u91cf:%1$s,\u5df2\u5b8c\u6210:%2$s,\u8fdb\u5ea6:%3$s%%", (String)"CashflowItemVersionEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), totalCount, 0, 0)));
                String requestId = RequestContext.get().getRequestId();
                ThreadService.execute(() -> {
                    try {
                        RequestContext.getOrCreate().setRequestId(requestId);
                        ThreadCache.put((Object)"viewPageId", (Object)pageId);
                        DependBiTreeNode<CfitemContext> taskRootNode = CashflowVersionSaveExtension.executeAddAssistOp(opContext);
                        String number = cashflowItem.getString("number");
                        this.getPageCache().put(ACCOUNTNUMBER, number);
                        TaskExecutionResult rootTaskResult = ((CfitemContext)taskRootNode.getData()).getExecutionResult();
                        if (TaskExecutionResult.Status.skip == rootTaskResult.getStatus()) {
                            boolean isLeafOrg = BDUtil.isLeafOrg((Object)useOrgId);
                            boolean isLeaf = cashflowItem.getBoolean("isleaf");
                            CashflowItemOptionVarManager.setBatchaddingAssist((OperateOption)op, (!isLeafOrg || !isLeaf ? 1 : 0) != 0);
                            OperationResult rs = OperationServiceHelper.executeOperate((String)"save", (String)"gl_cashflowitem", (DynamicObject[])new DynamicObject[]{cashflowItem}, (OperateOption)op);
                            if (!rs.isSuccess()) {
                                String failedMsg = BDUtil.buildOperationResultFailedMsg((OperationResult)rs, (boolean)false);
                                rootTaskResult.setStatus(TaskExecutionResult.Status.failed);
                                rootTaskResult.setFailedMsg(failedMsg);
                                List<TaskExecutionResult<CashflowItemOrgVo>> taskExecutionResults = CashflowVersionSaveExtension.collectResults(taskRootNode, false);
                                this.getPageCache().put(TASKEXECUTIONRESULTS, SerializationUtils.toJsonString(taskExecutionResults));
                                this.getPageCache().put(IS_SUCCESS, "false");
                                this.getPageCache().put(IS_FINISH, "true");
                            } else {
                                this.getPageCache().put(IS_SUCCESS, "true");
                                this.getPageCache().put(IS_FINISH, "true");
                                rootTaskResult.setStatus(TaskExecutionResult.Status.success);
                                rootTaskResult.setFailedMsg(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"AccountviewEdit_26", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AccountviewEdit_15", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                                this.getView().getParentView().invokeOperation("refresh");
                                this.getModel().setDataChanged(false);
                                this.getView().close();
                            }
                        } else {
                            List<TaskExecutionResult<CashflowItemOrgVo>> taskExecutionResults = CashflowVersionSaveExtension.collectResults(taskRootNode, false);
                            this.getPageCache().put(TASKEXECUTIONRESULTS, SerializationUtils.toJsonString(taskExecutionResults));
                            this.getPageCache().put(IS_SUCCESS, "false");
                            this.getPageCache().put(IS_FINISH, "true");
                        }
                    }
                    catch (Exception e) {
                        this.getPageCache().put(ERROR_INFO, e.getMessage());
                        this.getPageCache().put(IS_SUCCESS, "false");
                        this.getPageCache().put(IS_FINISH, "true");
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        lock.unlock();
                    }
                }, (TaskType)TaskType.FIBD_CASHFLOWITEM_ADDING_ASSIST_TASK);
                LOGGER.info("async thread for adding assist done");
            }
        });
    }

    public void onProgress(ProgressEvent progressEvent) {
        int totalCount = StringUtils.isEmpty((CharSequence)this.getPageCache().get(TOTAL_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(TOTAL_COUNT));
        String finishedCountCacheKey = this.getView().getPageId() + "finishedCount";
        int finishedCount = StringUtils.isEmpty((CharSequence)this.cache.get(finishedCountCacheKey)) ? 0 : Integer.parseInt(this.cache.get(finishedCountCacheKey));
        boolean isFinish = Boolean.parseBoolean(this.getPageCache().get(IS_FINISH));
        boolean isSuccess = Boolean.parseBoolean(this.getPageCache().get(IS_SUCCESS));
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        if (isFinish) {
            bar.stop();
            if (isSuccess) {
                String[] descParams = new String[]{};
                this.addSaveOperateLog(new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "CashflowItemVersionEdit_8", "fi-gl-formplugin"), descParams);
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AccountviewEdit_15", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                this.getView().getParentView().invokeOperation("refresh");
                this.getModel().setDataChanged(false);
                this.getView().hideLoading();
                this.getView().close();
            } else {
                String errorInfo = this.getPageCache().get(ERROR_INFO);
                if (StringUtils.isNotEmpty((CharSequence)errorInfo)) {
                    this.addSaveOperateLog(new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\uff1a%1$s", "CashflowItemVersionEdit_18", "fi-gl-formplugin"), errorInfo);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38:%s", (String)"AccountviewEdit_28", (String)"fi-bd-formplugin", (Object[])new Object[0]), errorInfo));
                } else {
                    String accountNumber = this.getPageCache().get(ACCOUNTNUMBER);
                    if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(TASKEXECUTIONRESULTS))) {
                        List taskExecutionResults = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(TASKEXECUTIONRESULTS), TaskExecutionResult.class);
                        this.dealAssistAddingResult(accountNumber, taskExecutionResults);
                    }
                }
                this.getView().hideLoading();
            }
            this.cleanPageCache(finishedCountCacheKey);
        } else if (totalCount != 0) {
            int progress = finishedCount * 100 / totalCount;
            LOGGER.info("\u9884\u8ba1\u7248\u672c\u5316\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6570\u91cf 309 :" + this.isShare);
            if (progress < 100) {
                this.getView().showLoading(new LocaleString(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u7248\u672c\u5316\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6570\u91cf:%1$s,\u5df2\u5b8c\u6210:%2$s,\u8fdb\u5ea6:%3$s%%", (String)"CashflowItemVersionEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), totalCount, finishedCount, progress)));
            }
        }
    }

    private void dealAssistAddingResult(String accountNumber, List<TaskExecutionResult<CashflowItemOrgVo>> taskExecutionResults) {
        taskExecutionResults.stream().forEach(x -> {
            Map dataMap = (Map)x.getData();
            CashflowItemOrgVo flowItemOrgVo = new CashflowItemOrgVo((String)dataMap.get("itemNumber"), Long.valueOf(Long.parseLong(String.valueOf(dataMap.get("orgId")))));
            x.setData((Object)flowItemOrgVo);
        });
        Set resultSet = taskExecutionResults.stream().map(x -> (CashflowItemOrgVo)x.getData()).collect(Collectors.toSet());
        List orgIdList = resultSet.stream().map(x -> x.getOrgId()).collect(Collectors.toList());
        Map orgIdNameMap = AccountVersionUtil.getOrgNameByIds(orgIdList);
        for (TaskExecutionResult<CashflowItemOrgVo> result : taskExecutionResults) {
            CashflowItemOrgVo data = (CashflowItemOrgVo)result.getData();
            data.setOrgName((String)orgIdNameMap.get(data.getOrgId()));
        }
        StringBuilder resultDetail = new StringBuilder();
        int successCount = 0;
        List successResultList = taskExecutionResults.stream().filter(x -> TaskExecutionResult.Status.success == x.getStatus()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(successResultList)) {
            successCount = successResultList.size();
        }
        int failedCount = 0;
        List<TaskExecutionResult> failedResultList = taskExecutionResults.stream().filter(x -> TaskExecutionResult.Status.failed == x.getStatus() || TaskExecutionResult.Status.fast_failed == x.getStatus()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(failedResultList)) {
            failedCount = failedResultList.size();
            failedResultList.forEach(x -> resultDetail.append(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7-%2$s\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff1a", (String)"CashflowItemVersionEdit_11", (String)"fi-bd-formplugin", (Object[])new Object[0]), ((CashflowItemOrgVo)x.getData()).getOrgName(), ((CashflowItemOrgVo)x.getData()).getItemNumber())).append(x.getFailedMsg()).append("\r\n"));
        }
        taskExecutionResults = taskExecutionResults.stream().filter(x -> !"S001".equals(x.getMsgCode())).collect(Collectors.toList());
        String url = POIUtils.getDownloadUrl((SXSSFWorkbook)POIUtils.fillCashflowItemResultWorkbook(taskExecutionResults), (String)POIUtils.generateFileName((String)String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf%s\u4fdd\u5b58\u660e\u7ec6", (String)"CashflowItemVersionEdit_12", (String)"fi-bd-formplugin", (Object[])new Object[0]), accountNumber)));
        this.getPageCache().put("afterDownloadUrl", url);
        StringBuilder resultSummary = new StringBuilder(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u6dfb\u52a0\u6838\u7b97\u7ef4\u5ea6\uff0c\u4e0b\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u540c\u4e00\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4f1a\u81ea\u52a8\u6dfb\u52a0\u8be5\u7ef4\u5ea6\u3002\u5f53\u524d\u5df2\u64cd\u4f5c%1$s\u4e2a\u7ec4\u7ec7\uff0c%2$s\u4e2a\u7ec4\u7ec7\u6dfb\u52a0\u8be5\u7ef4\u5ea6\u6210\u529f\uff0c%3$s\u4e2a\u7ec4\u7ec7\u6dfb\u52a0\u6838\u7b97\u7ef4\u5ea6\u5931\u8d25\u3002", (String)"CashflowItemVersionEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), successCount + failedCount, successCount, failedCount));
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        ConfirmTypes confirmTypes = ConfirmTypes.Default;
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("after_save_confirm", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
        btnNameMaps.put(6, ResManager.loadKDString((String)"\u4e0b\u8f7d\u660e\u7ec6", (String)"AccountviewEdit_19", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(7, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AccountviewEdit_18", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        this.addSaveOperateLog(new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\uff1a%1$s", "CashflowItemVersionEdit_18", "fi-gl-formplugin"), resultDetail.toString());
        this.getView().showConfirm(resultSummary.toString(), resultDetail.toString(), options, confirmTypes, callBackListener, btnNameMaps);
    }

    private void cleanPageCache(String finishedCountCacheKey) {
        this.cache.remove(finishedCountCacheKey);
        this.getPageCache().remove(IS_FINISH);
        this.getPageCache().remove(IS_SUCCESS);
        this.getPageCache().remove(TOTAL_COUNT);
        this.getPageCache().remove(TASKEXECUTIONRESULTS);
        this.getPageCache().remove(ERROR_INFO);
    }

    private boolean setPersonalOp(OperateOption op) {
        String createorgId;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object isPersonalizeData = view.getFormShowParameter().getCustomParam("isPersonalizeData");
        String useOrgID = (String)view.getFormShowParameter().getCustomParam("useorgId");
        if (useOrgID != null) {
            model.setValue("useorg", (Object)useOrgID);
        }
        DynamicObject createorg = (DynamicObject)model.getValue("createorg");
        if (null == useOrgID && null != model.getValue("useOrg")) {
            useOrgID = ((DynamicObject)model.getValue("useOrg")).getPkValue().toString();
        }
        LOGGER.info("useOrg:{},createOrg:{}", (Object)useOrgID, createorg.getPkValue());
        if (!(null == createorg || (createorgId = String.valueOf(createorg.getPkValue())).equals(useOrgID) || null != isPersonalizeData && ((Boolean)isPersonalizeData).booleanValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"AccountviewEdit_16", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        op.setVariableValue("useOrgID", useOrgID);
        if (null != isPersonalizeData && ((Boolean)isPersonalizeData).booleanValue()) {
            op.setVariableValue("isPersonalizeData", "1");
        } else {
            op.setVariableValue("isPersonalizeData", "0");
        }
        return true;
    }
}

