/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.cache.CacheHelper;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.DistributeCache;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.formplugin.CashFlowDesignate;
import kd.fi.gl.formplugin.PresetCashFlowDesignate;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.util.cashflow.FilterContext;
import org.apache.commons.lang3.StringUtils;

public abstract class DesignateCommonPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(DesignateCommonPlugin.class);
    protected static final String SUPP = "supp";
    protected static final String MAIN = "main";
    public static final String CURPERIOD = "curperiod";
    public static final String BOOKTYPE = "booktype";
    protected static final String ACCT_T = "1";
    protected static final String CFIT_T = "2";
    protected static final String ASSGRP_ACCT = "31";
    protected static final String ASSGRP_CFIT = "32";
    public static final int DEFAULT_BATCH_SIZE = 999;
    public static final String DESIGNATE_V1_PARAMS_CACHE = "designateV1Params";
    protected static final String CACHEKEY_ORGCOMBOITEMS = "orgcomboitems";
    protected static final String CACHEKEY_BOOKTYPEID = "booktype:id";
    protected static final String CACHEKEY_FILTER_CONTEXT = "filterContext";
    protected static final String FILTER_VALUE_ORGID = "org.id";
    protected static final String FILTER_VALUE_BOOKTYPE = "booktype.id";
    protected static final String FILTER_VALUE_BOOKEDDATE = "bookeddate";
    protected static final String QFILTER_NAME_BOOKEDDATE = "bookeddate";
    protected static final String QFILTER_NAME_PERIOD = "period";
    protected static final String QFILTER_NAME_BOOKTYPE = "booktype.id";
    protected static final String FILTER_NAME_ORG = "org.name";
    protected static final String FILTER_NAME_BOOKTYPE = "booktype.name";
    protected static final String ACCT_SELECT = "a.fid,a.fisleaf,a.fnumber,a.flevel,a.fmasterid";
    protected static final String CACHEKEY_HASPERMORG = "hasPermOrg";

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setBillFormId("gl_cashflowdesignatebill");
        filterContainer.addFilterContainerInitListener(this::filterContainerInit);
        filterContainer.addAfterBindDataListener(this::afterBindData);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer container = (FilterContainer)this.getControl("filtercontainerap");
        container.addSearchClickListener(this::resetBookTypeFilterValue);
        container.addBeforeF7SelectListener(this::beforeF7Select);
        container.addAfterSearchClickListener(this::afterSearchClick);
    }

    protected void resetBookTypeFilterValue(SearchClickEvent arg0) {
        if (arg0.getCurrentCommonFilter() == null || !FILTER_VALUE_ORGID.equals(((List)arg0.getCurrentCommonFilter().get("FieldName")).get(0))) {
            return;
        }
        Object orgFilterValue = arg0.getFilterValue(FILTER_VALUE_ORGID);
        if (orgFilterValue == null) {
            logger.error("org.id filter value is null");
            return;
        }
        List customFilterList = (List)arg0.getFilterValues().get("customfilter");
        if (CollectionUtils.isEmpty((Collection)customFilterList)) {
            logger.error("customfilter is null");
            return;
        }
        Map bookTypeFilterMap = customFilterList.stream().filter(i -> "booktype.id".equals(((List)i.get("FieldName")).get(0))).findAny().orElse(null);
        if (bookTypeFilterMap == null) {
            logger.info("\u8d26\u7c3f\u7c7b\u578b\u63a7\u4ef6\u5df2\u9690\u85cf,\u4e0d\u9700\u8981\u91cd\u7f6e!");
            return;
        }
        List bookTypeFilterVal = (List)bookTypeFilterMap.get("Value");
        if (CollectionUtils.isEmpty((Collection)bookTypeFilterVal)) {
            logger.error("booktype.id filter value is null,but filter map is not null!");
            return;
        }
        Object bookTypeId = bookTypeFilterVal.get(0);
        if (bookTypeId == null) {
            logger.error("booktype.id filter value is null!");
            return;
        }
        Long orgId = (Long)orgFilterValue;
        List bookTypeComboItems = AccSysUtil.getBookTypeComboByOrg((long)orgId);
        if (bookTypeComboItems.stream().noneMatch(i -> bookTypeId.equals(i.getValue()))) {
            bookTypeFilterVal.clear();
            bookTypeFilterVal.add(((ComboItem)bookTypeComboItems.get(0)).getValue());
        }
    }

    public void afterBindData(AfterBindDataEvent e) {
        super.afterBindData((EventObject)e);
        FilterContainer fc = (FilterContainer)e.getSource();
        List filters = fc.getContext().getClientQueryFilterParameter().getQFilters();
        this.QueryData(filters);
    }

    protected void afterSearchClick(SearchClickEvent e) {
        List filters = e.getFilterParameter().getQFilters();
        logger.info("afterSearchClick Fliter:" + filters);
        this.QueryData(filters);
    }

    protected void QueryData(List<QFilter> filters) {
        FilterContext filterContext = this.buildFilterContext(filters);
        if (!this.checkFilterContext(filterContext)) {
            this.doUpdateView();
            return;
        }
        this.getPageCache().put(CACHEKEY_FILTER_CONTEXT, SerializationUtils.serializeToBase64((Object)filterContext));
        this.doQuery(filterContext);
    }

    protected abstract void doUpdateView();

    protected FilterContext getFilterContextFromPageCache() {
        String filterContextCacheVal = this.getPageCache().get(CACHEKEY_FILTER_CONTEXT);
        if (filterContextCacheVal == null) {
            throw new KDBizException("load filterContext from pageCache return null!");
        }
        return (FilterContext)SerializationUtils.deSerializeFromBase64((String)filterContextCacheVal);
    }

    protected FilterContext buildFilterContext(List<QFilter> filters) {
        DynamicObject period;
        AccountBookInfo book;
        Long bookTypeId;
        String hasPermOrg = this.getPageCache().get(CACHEKEY_HASPERMORG);
        if (hasPermOrg != null && "0".equals(hasPermOrg)) {
            return null;
        }
        Long orgId = this.getFilterValue(FILTER_VALUE_ORGID);
        Object originBookedDate = this.getBookedDateFilterValue();
        FilterContext context = new FilterContext();
        context.setOrgId(orgId);
        context.setOriginBookedDate(originBookedDate);
        List acctOrgPkList = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)true, (PermissonType)PermissonType.VIEW);
        if (!acctOrgPkList.contains(orgId)) {
            this.getPageCache().put(CACHEKEY_HASPERMORG, "0");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u201c\u51ed\u8bc1\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u6216\u8005\u6ca1\u6709\u53ef\u7528\u7684\u7ec4\u7ec7\u8d26\u7c3f\u3002", (String)"DesignateCommonPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return null;
        }
        this.getPageCache().put(CACHEKEY_HASPERMORG, ACCT_T);
        boolean isExistBookTypeFilter = false;
        if (filters.size() > 1) {
            for (QFilter qFilter : filters) {
                this.setFilter(qFilter, context, false);
            }
        } else {
            QFilter qFilter = filters.get(0);
            this.setFilter(qFilter, context, true);
            List nests = qFilter.getNests(true);
            for (Object nest : nests) {
                this.setFilter(nest.getFilter(), context, true);
            }
        }
        if ((bookTypeId = context.getBookTypeId()) == null) {
            String cacheBookTypeId = this.getPageCache().get(CACHEKEY_BOOKTYPEID);
            logger.info("load bookTypeId={} from pageCache!", (Object)cacheBookTypeId);
            if (cacheBookTypeId == null) {
                List bookTypeComboItems = AccSysUtil.getBookTypeComboByOrg((long)orgId);
                if (CollectionUtils.isEmpty((Collection)bookTypeComboItems)) {
                    logger.error("\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u8d26\u7c3f\u7c7b\u578b!orgId={}", (Object)orgId);
                    throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MainDesignateEdit_21", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
                cacheBookTypeId = ((ComboItem)bookTypeComboItems.get(0)).getValue();
            }
            bookTypeId = Long.parseLong(cacheBookTypeId);
        } else {
            isExistBookTypeFilter = true;
        }
        AccountBookInfo accountBookInfo = book = bookTypeId == 0L ? AccSysUtil.getDefaultBookFromAccSys((Long)orgId) : AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (book == null) {
            book = AccSysUtil.getDefaultBookFromAccSys((Long)orgId);
            bookTypeId = book.getBookTypeId();
        }
        if (book == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u8d26\u7c3f\u3002", (String)"MainDesignateEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        context.setBookTypeId(bookTypeId);
        context.setBook(book);
        this.setBaseCurrency(book);
        if (context.getPeriodId() != null && (period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)context.getPeriodId())})) != null) {
            context.setStartDate(period.getDate("begindate"));
            context.setEndDate(period.getDate("enddate"));
        }
        QFilter qfilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("billstatus", "in", Arrays.asList("B", "C"))).and(new QFilter("sourcetype", "!=", (Object)ACCT_T));
        for (QFilter qFilter : filters) {
            if ("booktype.id".equals(qFilter.getProperty())) {
                qfilter.and(new QFilter("booktype.id", "=", (Object)context.getBookTypeId()));
                continue;
            }
            qfilter.and(qFilter);
        }
        Long periodId = 0L;
        if (context.getPeriodId() == null) {
            QFBuilder periodFilterBuilder = new QFBuilder("periodtype", "=", (Object)book.getPeriodTypeId());
            periodFilterBuilder.add("begindate", "<", (Object)context.getEndDate());
            periodFilterBuilder.add("enddate", ">=", (Object)context.getStartDate());
            List periodPkValueList = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])periodFilterBuilder.toArray(), (String)"id", (int)-1);
            if (!periodPkValueList.isEmpty()) {
                qfilter.and(new QFilter(QFILTER_NAME_PERIOD, "in", (Object)periodPkValueList));
                Set periodIds = periodPkValueList.stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toSet());
                context.setPeriodIds(periodIds);
                periodId = (Long)periodPkValueList.get(periodPkValueList.size() - 1);
            }
        } else {
            periodId = context.getPeriodId();
        }
        long accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
        context.getBook().setAccounttable(accountTableId);
        if (!isExistBookTypeFilter) {
            qfilter.and(new QFilter("booktype.id", "=", (Object)context.getBookTypeId()));
        }
        logger.info("AfterbuildFilterContextFilters:" + context.toString());
        if (book.isLocalSet()) {
            qfilter.and(new QFilter("bookeddate", "<", (Object)book.getLocalSetDate()));
        }
        if (book.getCashinitPeriodId() == 0L) {
            qfilter.and(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        } else {
            qfilter.and(new QFilter(QFILTER_NAME_PERIOD, ">=", (Object)book.getCashinitPeriodId()));
        }
        context.setqFilter(qfilter);
        return context;
    }

    private void setFilter(QFilter qFilter, FilterContext context, boolean isOrQuery) {
        if ("booktype.id".equals(qFilter.getProperty())) {
            context.setBookTypeId((Long)qFilter.getValue());
        } else if (QFILTER_NAME_PERIOD.equals(qFilter.getProperty())) {
            Object value = qFilter.getValue();
            context.setFilterByPeriod(true);
            if (value instanceof List) {
                context.setPeriodId((Long)((List)value).get(0));
            } else {
                context.setPeriodId((Long)value);
            }
        } else if ("bookeddate".equals(qFilter.getProperty())) {
            if (isOrQuery) {
                if (qFilter.getCP().startsWith(">")) {
                    context.setStartDate((Date)qFilter.getValue());
                } else {
                    context.setEndDate((Date)qFilter.getValue());
                }
            } else {
                context.setStartDate((Date)qFilter.getValue());
                context.setEndDate((Date)((QFilter.QFilterNest)qFilter.getNests(false).get(0)).getFilter().getValue());
            }
        }
    }

    protected boolean checkFilterContext(FilterContext filterContext) {
        String period;
        if (filterContext == null) {
            logger.error("filterContext is null");
            return false;
        }
        if (filterContext.getBook() == null) {
            logger.warn("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d26\u7c3f! filterContext={}", (Object)filterContext);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u8d26\u7c3f\u3002", (String)"MainDesignateEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterContext.getStartDate() == null && filterContext.getEndDate() == null) {
            logger.warn("\u5f00\u59cb\u65e5\u671f\u4e0e\u7ed3\u675f\u65e5\u671f\u4e3anull! filterContext={}", (Object)filterContext);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8d26\u7c3f\u671f\u95f4\u914d\u7f6e\u3002", (String)"MainDesignateEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!filterContext.isFilterByPeriod() && null != (period = this.isOverAcctVer(filterContext.getStartDate(), filterContext.getEndDate(), filterContext.getBook().getPeriodTypeId(), filterContext.getOrgId(), filterContext.getBookTypeId()))) {
            logger.warn("\u671f\u95f4\u8de8\u7248\u672c\u5316\u67e5\u8be2! filterContext={}", (Object)filterContext);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u6240\u67e5\u65e5\u671f\u5bf9\u5e94%s\u8fdb\u884c\u4e86\u79d1\u76ee\u8868\u7248\u672c\u5316\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u8de8\u7248\u672c\u5316\u67e5\u8be2\uff0c\u8bf7\u8c03\u6574\u3002", (String)"CashFlowDesignatePlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), period));
            return false;
        }
        return true;
    }

    protected abstract void doQuery(FilterContext var1);

    protected void filterContainerInit(FilterContainerInitEvent args) {
        List acctOrgPkList = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)true, (PermissonType)PermissonType.VIEW);
        if (acctOrgPkList.isEmpty()) {
            this.getPageCache().put(CACHEKEY_HASPERMORG, "0");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u201c\u51ed\u8bc1\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u6216\u8005\u6ca1\u6709\u53ef\u7528\u7684\u7ec4\u7ec7\u8d26\u7c3f\u3002", (String)"DesignateCommonPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(CACHEKEY_HASPERMORG, ACCT_T);
        List listFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn orgFilterColumn = null;
        CommonFilterColumn bookTypeFilterColumn = null;
        for (FilterColumn listFilter : listFilterColumns) {
            if (FILTER_NAME_ORG.equals(listFilter.getFieldName())) {
                orgFilterColumn = (CommonFilterColumn)listFilter;
                continue;
            }
            if (!FILTER_NAME_BOOKTYPE.equals(listFilter.getFieldName())) continue;
            bookTypeFilterColumn = (CommonFilterColumn)listFilter;
        }
        if (orgFilterColumn == null || bookTypeFilterColumn == null) {
            logger.error("\u63a7\u4ef6\u5f02\u5e38!\u7ec4\u7ec7\u8fc7\u6ee4\u63a7\u4ef6\u5b58\u5728?={},\u8d26\u7c3f\u7c7b\u578b\u8fc7\u6ee4\u63a7\u4ef6\u5b58\u5728?={}", (Object)(orgFilterColumn != null ? 1 : 0), (Object)(bookTypeFilterColumn != null ? 1 : 0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u8d26\u7c3f\u3002", (String)"MainDesignateEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Long orgIdValue = this.getFilterValue(FILTER_VALUE_ORGID);
        long orgId = orgIdValue == null ? AccSysUtil.getDefaultOrgId((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW) : orgIdValue;
        List<ComboItem> orgComboItems = this.buildOrgComboItems();
        orgFilterColumn.setComboItems(orgComboItems);
        if (CollectionUtils.isEmpty(orgComboItems)) {
            logger.error("\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u7ec4\u7ec7!");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MainDesignateEdit_16", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        orgFilterColumn.setDefaultValue(Long.toString(orgId));
        List bookTypeComboItems = AccSysUtil.getBookTypeComboByOrg((long)orgId);
        if (CollectionUtils.isEmpty((Collection)bookTypeComboItems)) {
            logger.error("\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u8d26\u7c3f\u7c7b\u578b!orgId={}", (Object)orgId);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MainDesignateEdit_21", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        int bookTypeCount = AccSysUtil.getAllBookTypeCount();
        if (bookTypeCount == 1) {
            logger.info("\u9690\u85cf\u8d26\u7c3f\u7c7b\u578b!\u7f13\u5b58value={}", (Object)((ComboItem)bookTypeComboItems.get(0)).getValue());
            this.getPageCache().put(CACHEKEY_BOOKTYPEID, ((ComboItem)bookTypeComboItems.get(0)).getValue());
            listFilterColumns.remove(bookTypeFilterColumn);
        } else {
            bookTypeFilterColumn.setComboItems(bookTypeComboItems);
            bookTypeFilterColumn.setDefaultValue(((ComboItem)bookTypeComboItems.get(0)).getValue());
        }
    }

    private List<ComboItem> buildOrgComboItems() {
        String cacheString = this.getPageCache().get(CACHEKEY_ORGCOMBOITEMS);
        if (StringUtils.isNotBlank((CharSequence)cacheString)) {
            return SerializationUtils.fromJsonStringToList((String)cacheString, ComboItem.class);
        }
        List comboItems = AccSysUtil.getAcctOrgComboItem((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
        cacheString = SerializationUtils.toJsonString((Object)comboItems);
        this.getPageCache().put(CACHEKEY_ORGCOMBOITEMS, cacheString);
        return comboItems;
    }

    protected Long getFilterValue(String field) {
        Object filterValue = this.getFilterValueByFieldName(field);
        if (filterValue == null && "booktype.id".equals(field)) {
            filterValue = this.getPageCache().get(CACHEKEY_BOOKTYPEID);
        }
        if (filterValue == null) {
            return null;
        }
        if (filterValue instanceof List) {
            filterValue = ((List)filterValue).get(0);
        }
        return Long.parseLong((String)filterValue);
    }

    protected Object getBookedDateFilterValue() {
        return this.getFilterValueByFieldName("bookeddate");
    }

    protected Map<Object, TreeNode> getAccountMap() {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        HashMap<Object, TreeNode> accIdMap = new HashMap<Object, TreeNode>();
        QFilter atFilter = new QFilter("accounttable", "=", (Object)filterContext.getBook().getAccountTableId());
        String sel = "id,parent,name,number,level,isleaf,masterid,longnumber";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".account"), (String)"bd_accountview", (String)sel, (QFilter[])new QFilter[]{atFilter}, null);){
            for (Row row : ds) {
                Long id = row.getLong("id");
                String number = row.getString("number");
                TreeNode node = new TreeNode(id.longValue());
                node.setParentId(row.getLong("parent").longValue());
                node.setMasterId(row.getLong("masterid").longValue());
                node.setPropValue("name", (Object)row.getString("name"));
                node.setPropValue("number", (Object)row.getString("number"));
                node.setPropValue("level", (Object)row.getInteger("level"));
                node.setPropValue("isleaf", (Object)row.getBoolean("isleaf"));
                node.setPropValue("longnumber", (Object)row.getString("longnumber"));
                accIdMap.put(id, node);
            }
        }
        for (TreeNode node : accIdMap.values()) {
            node.setParent((TreeNode)accIdMap.get(node.getParentId()));
        }
        return accIdMap;
    }

    private Object getFilterValueByFieldName(String fieldName) {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterKeyValueCollections filterKeyValueList = filterContainer.getCachedFilterValues().getOtherFilterValues();
        if (null == filterKeyValueList) {
            return null;
        }
        FilterKeyValueCollection orgFilterKeyValueCollection = null;
        for (FilterKeyValueCollection v : filterKeyValueList.getFilterValueCollection()) {
            for (FilterKeyValue fkv : v.getFilterKeyValues()) {
                Object value;
                String key = fkv.getKey();
                Object v0 = value = CollectionUtils.isEmpty((Collection)fkv.getValue()) ? null : fkv.getValue().get(0);
                if (!"FieldName".equals(key) || !fieldName.equals(value)) continue;
                orgFilterKeyValueCollection = v;
            }
        }
        if (orgFilterKeyValueCollection == null) {
            return null;
        }
        for (FilterKeyValue fkv : orgFilterKeyValueCollection.getFilterKeyValues()) {
            if (!"Value".equals(fkv.getKey()) || CollectionUtils.isEmpty((Collection)fkv.getValue())) continue;
            return fkv.getValue();
        }
        return null;
    }

    public void setBaseCurrency(AccountBookInfo book) {
        if (book.getBaseCurrencyId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"DesignateCommonPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("currency", (Object)book.getBaseCurrencyId());
    }

    protected Set<Long> getPeriodIdSet(QFilter dateFilter, long periodTypeId) {
        QFilter bF;
        bF.__setProperty((bF = dateFilter.copy()).getCP().startsWith(">") ? "enddate" : "begindate");
        QFilter eF = ((QFilter.QFilterNest)bF.getNests(false).get(0)).getFilter();
        eF.__setProperty(eF.getCP().startsWith(">") ? "enddate" : "begindate");
        QFilter ftype = new QFilter("periodtype", "=", (Object)periodTypeId);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{bF, ftype});
        HashSet<Long> pdIdSet = new HashSet<Long>();
        for (DynamicObject pd : coll) {
            pdIdSet.add(pd.getLong("id"));
        }
        return pdIdSet;
    }

    public void hyperVoucher(QFilter fid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filter", fid.toSerializedString());
        map.put("source", "CashFlowDesignate");
        FilterContext filterContext = this.getFilterContextFromPageCache();
        map.put(BOOKTYPE, filterContext.getBookTypeId().toString());
        map.put("org", filterContext.getOrgId().toString());
        Object originBookedDate = filterContext.getOriginBookedDate();
        List<Object> bookedDate = originBookedDate instanceof List ? (List<Object>)originBookedDate : Collections.singletonList(originBookedDate);
        map.put("bookeddate", new JSONArray(bookedDate));
        this.openView(map, "gl_voucher");
    }

    public void hyperCashFlowList(String num, Set<Long> ids, String type) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("num", num);
        map.put("ids", ids);
        map.put(BOOKTYPE, filterContext.getBookTypeId().toString());
        map.put("type", type);
        map.put("source", "CashFlowDesignate");
        map.put("org", filterContext.getOrgId().toString());
        Object originBookedDate = filterContext.getOriginBookedDate();
        List<Object> bookedDate = originBookedDate instanceof List ? (List<Object>)originBookedDate : Collections.singletonList(originBookedDate);
        map.put("bookeddate", new JSONArray(bookedDate));
        this.openView(map, "gl_cashflowlist");
    }

    private void openView(Map<String, Object> param, String key) {
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId(key);
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParams(param);
        this.getView().showForm((FormShowParameter)show);
    }

    protected void checkParam(QFilter qFilter) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        long orgId = filterContext.getOrgId();
        boolean modifyHisCf = SystemParamHelper.getBooleanParam((String)"mdifyhiscfitem", (long)orgId, (boolean)false);
        if (!modifyHisCf) {
            AccountBookInfo book = filterContext.getBook();
            qFilter.and(new QFilter(QFILTER_NAME_PERIOD, ">=", (Object)book.getCurPeriodId()));
        }
    }

    protected void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
        List ids;
        String field = arg0.getFieldName();
        if (field.startsWith("org.")) {
            List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
            arg0.getQfilters().add(new QFilter("id", "in", (Object)pkSet));
        } else if (field.startsWith(BOOKTYPE) && null != (ids = AccSysUtil.getBookTypeDataPermission(null))) {
            arg0.addCustomQFilter(new QFilter("id", "in", (Object)ids));
        }
    }

    protected String presetMapToString(Map<PresetCashFlowItemParam, Long> presetMap) {
        Iterator<Map.Entry<PresetCashFlowItemParam, Long>> i = presetMap.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<PresetCashFlowItemParam, Long> e = i.next();
            PresetCashFlowItemParam key = e.getKey();
            Long value = e.getValue();
            sb.append(key.getAcctId()).append('-').append(key.getAcctLongnumber()).append('-').append(key.getAssgrp()).append('-').append(key.getDc()).append('-').append(key.getItemType());
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    protected boolean checkModifyHisCf(Set<Long> vchIdArr) {
        long checkModifyHisCfStart = System.currentTimeMillis();
        boolean isexists = false;
        FilterContext filterContext = this.getFilterContextFromPageCache();
        long orgId = filterContext.getOrgId();
        boolean modifyHisCf = SystemParamHelper.getBooleanParam((String)"mdifyhiscfitem", (long)orgId, (boolean)false);
        if (!modifyHisCf) {
            Long voucherPeriod = filterContext.getPeriodId();
            if (voucherPeriod == null) {
                ArrayList periodIds = new ArrayList(filterContext.getPeriodIds());
                Collections.sort(periodIds);
                voucherPeriod = (Long)periodIds.get(0);
            }
            AccountBookInfo book = filterContext.getBook();
            isexists = voucherPeriod < book.getCurPeriodId();
        }
        long checkModifyHisCfEnd = System.currentTimeMillis();
        logger.info("[T_preset]checkModifyHisCf_cost: {} ms, modifyHisCf: {}", (Object)(checkModifyHisCfEnd - checkModifyHisCfStart), (Object)modifyHisCf);
        return isexists;
    }

    protected String checkPeriod(AccountBookInfo book, Set<Long> voucherIdSet) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        Long voucherPeriod = filterContext.getPeriodId();
        if (voucherPeriod == null) {
            ArrayList periodIds = new ArrayList(filterContext.getPeriodIds());
            Collections.sort(periodIds);
            voucherPeriod = (Long)periodIds.get(0);
        }
        if (!book.isIsendinitcashflow() && book.getCurPeriodId() > voucherPeriod) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u8d26\u7c3f\u672a\u7ed3\u675f\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\uff0c\u4e14\u5f53\u524d\u6240\u9009\u671f\u95f4\u65e9\u4e8e\u4f1a\u8ba1\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u53cd\u7ed3\u8d26\u81f3\u9700\u8981\u6307\u5b9a\u73b0\u91d1\u6d41\u91cf\u7684\u6700\u65e9\u671f\u95f4\u8fdb\u884c\u6307\u5b9a\u3002", (String)"MainDesignateEdit_22", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        if (book.isIsendinitcashflow() && book.getCashinitPeriodId() > voucherPeriod) {
            return ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u65e9\u4e8e\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u671f\u95f4\u3002", (String)"MainDesignateEdit_23", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    protected PresetCashFlowItemParam buildPresetParam(PresetCashFlowDesignate cashFlowDesignate) {
        PresetCashFlowItemParam data = new PresetCashFlowItemParam();
        data.setAcctId(cashFlowDesignate.getAcctId());
        data.setDc(cashFlowDesignate.getDc());
        data.setAssgrp(cashFlowDesignate.getAssgrpId());
        data.setItemType(cashFlowDesignate.getItemType());
        data.setAcctLongnumber(cashFlowDesignate.getAcctLongNumber());
        return data;
    }

    protected String initPresetParamAndVoucherIds(Map<String, PresetCashFlowDesignate> subAcct, List<PresetCashFlowItemParam> paramList, Set<Long> voucherIdSet) {
        if (CollectionUtils.isEmpty(subAcct)) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u9884\u8bbe\u7684\u79d1\u76ee\u3002", (String)"CashFlowDesignatePlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        for (Map.Entry<String, PresetCashFlowDesignate> entry : subAcct.entrySet()) {
            CashFlowDesignate value = entry.getValue();
            voucherIdSet.addAll(value.getVchIds());
            paramList.add(this.buildPresetParam((PresetCashFlowDesignate)value));
        }
        return null;
    }

    protected String initPresetParamAndVoucherIdsByPeriod(Map<Long, Map<String, PresetCashFlowDesignate>> subAcct, Map<Long, List<PresetCashFlowItemParam>> paramListMap, Set<Long> voucherIdSet) {
        if (CollectionUtils.isEmpty(subAcct)) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u9884\u8bbe\u7684\u79d1\u76ee\u3002", (String)"CashFlowDesignatePlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        for (Map.Entry<Long, Map<String, PresetCashFlowDesignate>> entry : subAcct.entrySet()) {
            long period = entry.getKey();
            ArrayList<PresetCashFlowItemParam> paramList = new ArrayList<PresetCashFlowItemParam>(10);
            for (Map.Entry<String, PresetCashFlowDesignate> preset : entry.getValue().entrySet()) {
                CashFlowDesignate value = preset.getValue();
                voucherIdSet.addAll(value.getVchIds());
                paramList.add(this.buildPresetParam((PresetCashFlowDesignate)value));
            }
            paramListMap.put(period, paramList);
        }
        return null;
    }

    protected long[] batchGenGlobalIds(int count) {
        return DB.genGlobalLongIds((int)count);
    }

    protected Map<Long, Set<Long>> getCache() {
        long getCacheStart = System.currentTimeMillis();
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.cashItemDesignate);
        String cacheStr = cache.get(this.getView().getPageId());
        HashMap<Long, Set<Long>> resMap = StringUtils.isNotBlank((CharSequence)cacheStr) ? (HashMap<Long, Set<Long>>)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new HashMap<Long, Set<Long>>(16);
        long getCacheEnd = System.currentTimeMillis();
        Map<Long, Integer> summaryMap = this.getCacheVoucherIdsSummary(resMap);
        logger.info("[T_preset]getCache_cost:{} ms ,CacheVoucherIdsSummary: {}", (Object)(getCacheEnd - getCacheStart), summaryMap);
        return resMap;
    }

    protected void putCache(Map<Long, Set<Long>> voucherIdsCache) {
        long putCacheStart = System.currentTimeMillis();
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.cashItemDesignate);
        cache.put(this.getView().getPageId(), SerializationUtils.serializeToBase64(voucherIdsCache));
        long putCacheEnd = System.currentTimeMillis();
        Map<Long, Integer> summaryMap = this.getCacheVoucherIdsSummary(voucherIdsCache);
        logger.info("[T_preset]putCache_cost: {} ms, CacheVoucherIdsSummary: {}", (Object)(putCacheEnd - putCacheStart), summaryMap);
    }

    protected Set<Long> getCacheVoucherIds(String infoKey) {
        Map<Long, Set<Long>> key2VoucherIds = this.getCache();
        Map<Long, Integer> summaryMap = this.getCacheVoucherIdsSummary(key2VoucherIds);
        logger.info("[T_preset][voucherIdsCache]getCacheVoucherIds_infoKey:{},CacheVoucherIdsSummary: {}", (Object)infoKey, summaryMap);
        if (!key2VoucherIds.isEmpty() && infoKey != null) {
            return key2VoucherIds.get(Long.valueOf(infoKey));
        }
        return new HashSet<Long>(16);
    }

    protected Map<Long, Integer> getCacheVoucherIdsSummary(Map<Long, Set<Long>> key2VoucherIds) {
        if (null == key2VoucherIds) {
            return null;
        }
        HashMap<Long, Integer> summaryMap = new HashMap<Long, Integer>(key2VoucherIds.size());
        for (Map.Entry<Long, Set<Long>> entry : key2VoucherIds.entrySet()) {
            summaryMap.put(entry.getKey(), entry.getValue().size());
        }
        return summaryMap;
    }

    private static void removeCache(String pageId) {
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.cashItemDesignate);
        cache.remove(pageId);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DesignateCommonPlugin.removeCache(this.getView().getPageId());
    }

    public void showConfirmTip(String callbackId, String tips1, String tips2) {
        ConfirmCallBackListener designate = new ConfirmCallBackListener(callbackId);
        if (!SystemParamHelper.getBooleanParam((String)"mdifyauditcfitem", (long)this.getFilterValue(FILTER_VALUE_ORGID), (boolean)true)) {
            this.getView().showConfirm(tips1, tips2, MessageBoxOptions.OKCancel, ConfirmTypes.Default, designate);
        } else {
            this.getView().showConfirm(tips1, MessageBoxOptions.OKCancel, designate);
        }
    }

    public void showConfirmTipForPreset(String callbackId, String tips1, String tips2) {
        ConfirmCallBackListener designate = new ConfirmCallBackListener(callbackId);
        if (!SystemParamHelper.getBooleanParam((String)"mdifyauditcfitem", (long)this.getFilterValue(FILTER_VALUE_ORGID), (boolean)true)) {
            this.getView().showConfirm(tips1, tips2, MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, designate);
        } else {
            this.getView().showConfirm(tips1, MessageBoxOptions.YesNoCancel, designate);
        }
    }

    private String isOverAcctVer(Date begin, Date end, long periodTypeId, long orgId, long bookTypeId) {
        QFilter fbegin = new QFilter("begindate", "<=", (Object)begin);
        QFilter fend = new QFilter("enddate", ">=", (Object)begin);
        QFilter ftype = new QFilter("periodtype", "=", (Object)periodTypeId);
        DynamicObject startP = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,periodyear", (QFilter[])new QFilter[]{fbegin, fend, ftype});
        if (startP == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DesignateCommonPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(end);
        if (c.get(10) == 0) {
            c.add(5, -1);
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 0);
            end = c.getTime();
        }
        fbegin = new QFilter("begindate", "<=", (Object)end);
        fend = new QFilter("enddate", ">=", (Object)end);
        DynamicObjectCollection pCol = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear", (QFilter[])new QFilter[]{fbegin, fend, ftype}, (String)"id desc", (int)1);
        DynamicObject endP = null;
        if (pCol.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DesignateCommonPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return null;
        }
        endP = (DynamicObject)pCol.get(0);
        long endPId = endP.getLong("id");
        QFilter forg = new QFilter("org", "=", (Object)orgId);
        QFilter fbt = new QFilter(BOOKTYPE, "=", (Object)bookTypeId);
        QFilter fs = null;
        QFilter fe = null;
        long startPId = startP.getLong("id");
        if (startPId == endPId) {
            fs = new QFilter("enableperiod", ">", (Object)startPId);
            fe = new QFilter("enableperiod", "<", (Object)endPId);
        } else {
            fs = new QFilter("enableperiod", ">=", (Object)startPId);
            fe = new QFilter("enableperiod", "<=", (Object)endPId);
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_book_version", (String)"enableperiod.name", (QFilter[])new QFilter[]{fs, fe, forg, fbt}, (String)"enableperiod desc", (int)1);
        if (col != null && !col.isEmpty()) {
            return ((DynamicObject)col.get(0)).getString("enableperiod.name");
        }
        return null;
    }

    protected DataSet getDataSetByNumber(String acctNum) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        AccountBookInfo book = filterContext.getBook();
        long orgId = book.getOrgId();
        SqlBuilder sql = new SqlBuilder();
        sql.append(" and a.fnumber = ?", new Object[]{acctNum});
        DataSet acctDataSet = AccountUtils.queryHistoryAcct((long)orgId, (long)book.getAccountTableId(), (Date)filterContext.getStartDate(), (Date)filterContext.getEndDate(), (String)ACCT_SELECT, (SqlBuilder)sql);
        return acctDataSet;
    }

    protected DataSet getDataSetByParentId(Set<Long> parentIds) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        AccountBookInfo book = filterContext.getBook();
        long orgId = book.getOrgId();
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn(" and a.fparentid ", new ArrayList<Long>(parentIds));
        DataSet acctDataSet = AccountUtils.queryHistoryAcct((long)orgId, (long)book.getAccountTableId(), (Date)filterContext.getStartDate(), (Date)filterContext.getEndDate(), (String)ACCT_SELECT, (SqlBuilder)sql);
        return acctDataSet;
    }

    protected void getLeafAccount(DataSet dyn, Set<String> result, String field) {
        HashSet<Long> parentIds = new HashSet<Long>();
        for (Row row : dyn) {
            if (row.getBoolean("fisleaf").booleanValue()) {
                result.add(row.getString(field));
                continue;
            }
            parentIds.add(row.getLong("fmasterid"));
            parentIds.add(row.getLong("fid"));
        }
        if (parentIds.size() != 0) {
            DataSet children = this.getDataSetByParentId(parentIds);
            this.getLeafAccount(children, result, field);
        }
    }

    protected Map<Long, Long> loadAccounts() {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("startdate", "<=", (Object)filterContext.getEndDate()));
        filters.add(new QFilter("enddate", ">=", (Object)filterContext.getEndDate()));
        AccountBookInfo book = filterContext.getBook();
        Set ids = AccountUtils.queryAccountIds((long)filterContext.getOrgId(), (long)book.getAccountTableId(), filters);
        QFilter fids = new QFilter("id", "in", (Object)ids);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{fids});
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (DynamicObject acct : result) {
            map.put(acct.getLong("masterid"), acct.getLong("id"));
        }
        return map;
    }

    protected List<Tuple<Set<Long>, Set<Long>>> transToBatchList(Multimap<Long, Long> vchIdEntriesIdMap) {
        ArrayList<Tuple<Set<Long>, Set<Long>>> batchList = new ArrayList<Tuple<Set<Long>, Set<Long>>>(8);
        HashSet vchIdSet = new HashSet(999);
        HashSet veIdSet = new HashSet(999);
        for (Map.Entry entry : vchIdEntriesIdMap.asMap().entrySet()) {
            vchIdSet.add(entry.getKey());
            veIdSet.addAll((Collection)entry.getValue());
            if (vchIdSet.size() < 999) continue;
            batchList.add((Tuple<Set<Long>, Set<Long>>)Tuple.create(vchIdSet, veIdSet));
            vchIdSet = new HashSet(999);
            veIdSet = new HashSet(999);
        }
        if (vchIdSet.size() > 0) {
            batchList.add((Tuple<Set<Long>, Set<Long>>)Tuple.create(vchIdSet, veIdSet));
        }
        return batchList;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String hasPermOrg;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (!"return".equals(itemKey) && (hasPermOrg = this.getPageCache().get(CACHEKEY_HASPERMORG)) != null && "0".equals(hasPermOrg)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u201c\u51ed\u8bc1\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u6216\u8005\u6ca1\u6709\u53ef\u7528\u7684\u7ec4\u7ec7\u8d26\u7c3f\u3002", (String)"DesignateCommonPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    protected static class DesignateV1Params {
        protected int vchIdCount;
        protected Map<Long, Long> entryidItemIdMap = new HashMap<Long, Long>(999);
        protected Multimap<Long, Long> vchIdEntriesIdMap = ArrayListMultimap.create();

        protected DesignateV1Params() {
        }

        public void add(Long cfItem, Multimap<Long, Long> vchIdEntriesIdMap) {
            this.vchIdEntriesIdMap.putAll(vchIdEntriesIdMap);
            this.vchIdCount = this.vchIdEntriesIdMap.size();
            Collection entriesIds = vchIdEntriesIdMap.values();
            for (Long entryid : entriesIds) {
                this.entryidItemIdMap.put(entryid, cfItem);
            }
        }
    }
}

