/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.formplugin.FPFormUtil;
import kd.fi.gl.formplugin.FlexBasedataBeforeF7SelectListener;
import kd.fi.gl.formplugin.finalprocess.FPAssgrpDescLengthConfig;
import kd.fi.gl.util.GlFormUtil;

public class FinalProcessAssgrpEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String Key_Org = "org";
    private static final String Key_RowId = "assgrprow";
    private static final String Key_Entry = "entryentity";
    private static final String Key_AssgrpType = "fieldname";
    private static final String Key_AssgrpTypeId = "fieldname_id";
    private static final String Key_BaseDataVal = "value";
    private static final String Key_BtnOk = "okbtn";
    private static final String Key_TxtVal = "txtval";
    private static final Log logger = LogFactory.getLog(FinalProcessAssgrpEdit.class);

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{Key_BtnOk, Key_TxtVal});
        BasedataEdit ass = (BasedataEdit)this.getControl(Key_BaseDataVal);
        ass.addBeforeF7SelectListener((BeforeF7SelectListener)new FlexBasedataBeforeF7SelectListener());
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter form = this.getView().getFormShowParameter();
        Map customParams = form.getCustomParams();
        if (customParams == null) {
            this.getView().close();
            return;
        }
        Object orgIdVal = customParams.get("orgId");
        Object accountIdVal = customParams.get("accountId");
        if (orgIdVal == null || accountIdVal == null) {
            this.getView().close();
            return;
        }
        IDataModel model = this.getModel();
        model.setValue(Key_Org, orgIdVal);
        Object rowIdVal = customParams.get("accountRowId");
        model.setValue(Key_RowId, rowIdVal);
        Object value = customParams.get(Key_BaseDataVal);
        DynamicObjectCollection entryData = null;
        if (value != null) {
            MainEntityType mainEntityType = model.getDataEntityType();
            DynamicObject dynamicObject = GlFormUtil.fromDynamicString(value.toString(), mainEntityType);
            entryData = dynamicObject.getDynamicObjectCollection(Key_Entry);
        } else {
            value = customParams.get("json");
            if (value != null) {
                entryData = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)value.toString());
            } else {
                Object queryParam = customParams.get("donotquery");
                if (queryParam == null || !Boolean.parseBoolean(queryParam.toString())) {
                    QFilter filter2 = new QFilter(Key_Org, "=", (Object)Long.valueOf(orgIdVal.toString()));
                    QFilter filter3 = new QFilter(Key_RowId, "=", (Object)rowIdVal.toString());
                    QFilter[] filters = new QFilter[]{filter2, filter3};
                    DynamicObject assgrpDyn = BusinessDataServiceHelper.loadSingle((String)form.getFormId(), (String)"org,assgrprow,entryentity.fieldname,entryentity.value,entryentity.txtval", (QFilter[])filters);
                    if (assgrpDyn != null) {
                        entryData = assgrpDyn.getDynamicObjectCollection(Key_Entry);
                    }
                }
            }
        }
        this.setEntryData(entryData, Long.valueOf(accountIdVal.toString()));
    }

    private void setEntryData(DynamicObjectCollection entryData, Long accountId) {
        IDataModel model = this.getModel();
        model.deleteEntryData(Key_Entry);
        int index = 0;
        List<Long> assgrpTypeIds = this.getAssgrpTypeIdsFromAccount(accountId);
        if (entryData == null || entryData.isEmpty()) {
            int[] rows = model.batchCreateNewEntryRow(Key_Entry, assgrpTypeIds.size());
            for (Long assgrpId : assgrpTypeIds) {
                model.setValue(Key_AssgrpType, (Object)assgrpId, rows[index++]);
            }
        } else {
            HashSet<Long> assistItemSet = new HashSet<Long>(assgrpTypeIds);
            HashSet<Long> assistItemSetContained = new HashSet<Long>(assgrpTypeIds.size());
            int[] rows = model.batchCreateNewEntryRow(Key_Entry, Integer.max(entryData.size(), assistItemSet.size()));
            for (DynamicObject row : entryData) {
                model.setValue(Key_AssgrpType, (Object)row.getLong(Key_AssgrpTypeId), rows[index]);
                assistItemSetContained.add(row.getLong(Key_AssgrpTypeId));
                String valuetype = row.getString("fieldname.valuetype");
                if ("3".equals(valuetype)) {
                    model.setValue(Key_TxtVal, (Object)row.getString(Key_TxtVal), rows[index++]);
                    continue;
                }
                DynamicObjectCollection baseDataVals = row.getDynamicObjectCollection(Key_BaseDataVal);
                Long[] pks = null;
                if (baseDataVals != null && !baseDataVals.isEmpty()) {
                    pks = baseDataVals.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList()).toArray(new Long[0]);
                }
                this.setValProp(rows[index], this.getModel().getDataEntityType());
                model.setValue(Key_BaseDataVal, (Object)pks, rows[index++]);
            }
            assistItemSet.removeAll(assistItemSetContained);
            for (Long item : assistItemSet) {
                model.setValue(Key_AssgrpType, (Object)item, rows[index++]);
            }
        }
    }

    private List<Long> getAssgrpTypeIdsFromAccount(Long accountId) {
        String threadCacheKey = ((Object)((Object)this)).getClass().getName() + accountId;
        return (List)ThreadCache.get((Object)threadCacheKey, () -> {
            DynamicObject accountFromDb = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (String)"checkitementry.asstactitem", (QFilter[])new QFilter("id", "=", (Object)accountId).toArray());
            return accountFromDb.getDynamicObjectCollection("checkitementry").stream().map(x -> x.getLong("asstactitem_id")).collect(Collectors.toList());
        });
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(Key_BtnOk)) {
            this.returnDataToParent();
        } else if (Key_TxtVal.equals(key)) {
            this.showTxtValEdit();
        }
    }

    private void showTxtValEdit() {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex(Key_Entry);
        if (rowIndex < 0) {
            return;
        }
        FormShowParameter form = new FormShowParameter();
        form.setFormId("gl_assgrp_txtval_edit");
        form.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("operateType", "btnok");
        List params = null;
        String txtVal = model.getValue(Key_TxtVal, rowIndex).toString();
        if (StringUtils.isNotBlank((CharSequence)txtVal)) {
            params = Stream.of(txtVal.split(";")).collect(Collectors.toList());
        }
        customParam.put("params", params);
        form.setCustomParams(customParam);
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Key_TxtVal));
        this.getView().showForm(form);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (Key_TxtVal.equals(actionId) && (returnData = e.getReturnData()) != null) {
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex(Key_Entry);
            if (rowIndex < 0) {
                return;
            }
            if (returnData != null) {
                String txtVal = returnData.toString().replaceAll("\n", ";");
                model.setValue(Key_TxtVal, (Object)txtVal, rowIndex);
            }
        }
    }

    public void returnDataToParent() {
        HashMap<String, Object> para = new HashMap<String, Object>();
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (customParams.get("type") != null) {
            para.put("type", customParams.get("type"));
            para.put(Key_BaseDataVal, GlFormUtil.toDynamicObjectJson(this.getModel().getDataEntity(true)));
            para.put(Key_RowId, this.getModel().getValue(Key_RowId));
        } else {
            para.put("json", SerializationUtils.serializeToBase64((Object)this.getModel().getEntryEntity(Key_Entry)));
        }
        para.put("express", this.getDesc());
        para.put("index", customParams.get("index"));
        view.returnDataToParent(para);
        view.close();
    }

    private String getDesc() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity(Key_Entry);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        String entityId = "";
        if (StringUtils.isNotBlank((CharSequence)parentPageId)) {
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            entityId = parentView.getEntityId();
        }
        return FPFormUtil.getDesc(entries, FPAssgrpDescLengthConfig.fromProperty(entityId));
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType entitytype = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)entitytype.clone();
        }
        catch (CloneNotSupportedException exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
            throw new KDBizException((Throwable)exp, BosErrorCode.systemError, new Object[0]);
        }
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex(Key_Entry);
        this.setValProp(row, newMainType);
        e.setNewEntityType(newMainType);
    }

    private void setValProp(int row, MainEntityType newMainType) {
        IDataModel model = this.getModel();
        DynamicObject assisType = (DynamicObject)model.getValue(Key_AssgrpType, row);
        if (assisType == null) {
            return;
        }
        EntryProp entry = (EntryProp)newMainType.getProperty(Key_Entry);
        MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(Key_BaseDataVal);
        DynamicObject valueSource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("valuesource");
            entityId = valueSource.getString("id");
        } else if ("2".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("assistanttype");
            entityId = "bos_assistantdata_detail";
        }
        if (valueSource != null) {
            prop.setBaseEntityId(entityId);
            BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            baseProp.setBaseEntityId(entityId);
            baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
        }
    }
}

