/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.util.GLUtil;

public class FinancialIndicatorsEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String KPINAME = "kpiname";

    public void initialize() {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit kpiNameEdit = (BasedataEdit)this.getControl(KPINAME);
        kpiNameEdit.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            List analsKpiIds = model.getEntryEntity("entryentity").stream().map(entry -> entry.getLong("kpiname.id")).filter(i -> i != 0L).collect(Collectors.toList());
            ListShowParameter listParam = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("reporttype", "ftlike", this.getModel().getValue("type")).or(new QFilter("reporttype", "=", (Object)" "));
            QFilter analsKpiIdsFilter = new QFilter("id", "not in", analsKpiIds);
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_business_analskpi", (Long)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("org")));
            listParam.getListFilterParameter().getQFilters().add(qFilter);
            listParam.getListFilterParameter().getQFilters().add(orgFilter);
            listParam.getListFilterParameter().getQFilters().add(analsKpiIdsFilter);
            listParam.setCustomParam("useorg", (Object)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("org")));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long orgId = Long.parseLong((String)parameter.getCustomParam("org"));
        String type = (String)parameter.getCustomParam("type");
        String orgView = (String)parameter.getCustomParam("orgView");
        String bookType = (String)parameter.getCustomParam("bookType");
        String accTable = (String)parameter.getCustomParam("accTable");
        this.getModel().setValue("org", (Object)orgId);
        this.getModel().setValue("type", (Object)type);
        this.getModel().setValue("orgView", (Object)orgView);
        this.getModel().setValue("bookType", (Object)bookType);
        this.getModel().setValue("accounttable", (Object)accTable);
        String dyn = (String)parameter.getCustomParam("dyn");
        if (!StringUtils.isEmpty((CharSequence)dyn)) {
            DynamicObjectCollection kpis = (DynamicObjectCollection)GLUtil.fromSerializedString((String)dyn);
            this.setData(kpis);
        }
    }

    private void setData(DynamicObjectCollection kpis) {
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("entryentity", kpis.size());
        for (int i = 0; i < kpis.size(); ++i) {
            model.setValue(KPINAME, (Object)((DynamicObject)kpis.get(i)).getLong("id"), i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOp;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "save".equals(operateKey = (formOp = (FormOperate)args.getSource()).getOperateKey())) {
            int i;
            DynamicObjectCollection dyns = this.getModel().getEntryEntity("entryentity");
            ArrayList list = new ArrayList();
            HashSet<String> set = new HashSet<String>();
            for (i = 0; i < dyns.size(); ++i) {
                if (((DynamicObject)dyns.get(i)).get(KPINAME) == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                String id = ((DynamicObject)dyns.get(i)).getDynamicObject(KPINAME).getString("id");
                if (!set.add(id)) continue;
                map.put("id", ((DynamicObject)dyns.get(i)).getDynamicObject(KPINAME).getString("id"));
                list.add(map);
            }
            this.getModel().deleteEntryData("entryentity");
            if (list.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u4fe1\u606f\u3002", (String)"FinancialIndicatorsEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().batchCreateNewEntryRow("entryentity", list.size());
            for (i = 0; i < list.size(); ++i) {
                this.getModel().setValue(KPINAME, ((Map)list.get(i)).get("id"), i);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate formOp;
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!(afterDoOperationEventArgs.getSource() instanceof FormOperate) || "save".equals(operateKey = (formOp = (FormOperate)afterDoOperationEventArgs.getSource()).getOperateKey())) {
            // empty if block
        }
    }
}

