/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.ext.fi.flex.FlexFilterUtil;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.voucher.AssgrpDefaultValConstant;
import kd.fi.gl.util.AssgrpFilterUtil;
import kd.fi.gl.util.SystemParamHelper;

public class FlexBasedataBeforeF7SelectListener
implements BeforeF7SelectListener {
    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object source = e.getSource();
        IFormView view = null;
        String entityId = "";
        IDataModel model = null;
        String basedataId = null;
        if (source instanceof MulBasedataEdit) {
            MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)source;
            view = mulBasedataEdit.getView();
            model = view.getModel();
            entityId = view.getEntityId();
            MulBasedataProp mulBasedataProp = (MulBasedataProp)e.getProperty();
            basedataId = mulBasedataProp.getBaseEntityId();
        } else if (source instanceof BasedataEdit) {
            BasedataEdit basedataEdit = (BasedataEdit)source;
            view = basedataEdit.getView();
            model = view.getModel();
            entityId = view.getEntityId();
            BasedataProp basedataProp = (BasedataProp)e.getProperty();
            basedataId = basedataProp.getBaseEntityId();
        }
        if (null == model || null == view || null == basedataId) {
            return;
        }
        int row = e.getRow();
        switch (entityId) {
            case "gl_finalprocess_assgrp": {
                String flexfield;
                FlexProperty flexProperty;
                if ("bos_org".equals(basedataId) && null != (flexProperty = FlexEntityMetaUtils.getFlexProperty((String)(flexfield = ((FormDataModel)model).getEntryCurrentRow("entryentity").getDynamicObject("fieldname").getString("flexfield")))) && StringUtils.isNotBlank((CharSequence)flexProperty.getOrgFuncNumber())) {
                    e.getFormShowParameter().setCustomParam("orgFuncId", (Object)flexProperty.getOrgFuncNumber());
                }
                this.addFilterToFinalProcessAssgrp(e, view, model, row, basedataId);
                break;
            }
            case "gl_assgrpdefval": {
                this.addFilterToAssgrpDefValAssgrp(e, view, model, row, basedataId);
            }
        }
    }

    private void addFilter(BeforeF7SelectEvent e, QFilter filter) {
        ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
        List qFilters = list.getListFilterParameter().getQFilters();
        qFilters.add(filter);
    }

    private void addOrgFilter(BeforeF7SelectEvent e, long orgId, String basedataId, boolean isLeaf) {
        boolean param;
        if (isLeaf) {
            if ("bos_org".equals(basedataId)) {
                e.getFormShowParameter().setCustomParam("isOnlyDisplayOrgLeaves", (Object)Boolean.TRUE);
            } else if ("bos_adminorg".equals(basedataId)) {
                List<Long> ids = this.getLeafOrgId("01");
                this.addFilter(e, new QFilter("id", "in", ids));
            }
        }
        if ("bos_adminorg".equals(basedataId) && (param = SystemParamHelper.getBooleanParam((String)"currorg", (long)orgId, (boolean)Boolean.FALSE)) && this.isAdminOrg(orgId)) {
            List orgs = OrgServiceHelper.getOrgAllSubIds((Long)orgId, (String)"01", (boolean)Boolean.TRUE);
            this.addFilter(e, new QFilter("id", "in", (Object)orgs));
        }
    }

    private boolean isAdminOrg(long orgId) {
        QFilter filterOrgId = new QFilter("org.id", "=", (Object)orgId);
        QFilter filterTreeType = new QFilter("view.treetype", "=", (Object)"01");
        QFilter filterDefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filterOrgId, filterTreeType, filterDefault};
        return QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])filters);
    }

    private List<Long> getLeafOrgId(String orgViewType) {
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter fviewType = new QFilter("view.treetype", "=", (Object)orgViewType);
        QFilter fisleaf = new QFilter("isleaf", "=", (Object)"1");
        QFilter filterDefault = new QFilter("view.isdefault", "=", (Object)"1");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".getLeafOrgId"), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{fviewType, fisleaf, filterDefault}, null);){
            for (Row r : ds) {
                ids.add(r.getLong("org"));
            }
        }
        return ids;
    }

    private void addTreeBasedataLeafFilter(BeforeF7SelectEvent e, String baseEntityId, boolean isLeaf) {
        if (isLeaf && !"bos_org".equals(baseEntityId) && !"bos_adminorg".equals(baseEntityId) && !"bd_admindivision".equals(baseEntityId)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            Map fields = mainType.getFields();
            IDataEntityProperty parent = (IDataEntityProperty)fields.get("parent");
            IDataEntityProperty isleaf = (IDataEntityProperty)fields.get("isleaf");
            if (parent != null && isleaf != null && StringUtils.isNotBlank((CharSequence)isleaf.getAlias())) {
                this.addFilter(e, new QFilter("isleaf", "=", (Object)"1"));
            }
        }
    }

    private void addStatusFilter(BeforeF7SelectEvent e, String baseEntityId) {
        Map opParam;
        Map opMeta;
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)baseEntityId);
        if (ops != null && StringUtils.isNotBlank((CharSequence)ops.getAudit()) && (opMeta = EntityMetadataCache.getDataEntityOperate((String)baseEntityId, (String)ops.getAudit())) != null && opMeta.containsKey("parameter") && (opParam = (Map)opMeta.get("parameter")) != null) {
            MainEntityType dataEntityType;
            BillStatusProp statusProperty;
            String statusFieldKey;
            Object statusProp = opParam.get("statusProp");
            Object value = opParam.get("value");
            if (statusProp != null && value != null && StringUtils.isNotBlank((CharSequence)(statusFieldKey = (String)statusProp)) && (statusProperty = (BillStatusProp)(dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId)).getProperty(statusFieldKey)) != null && StringUtils.isNotBlank((CharSequence)statusProperty.getAlias())) {
                String val = (String)value;
                QFilter filter = new QFilter(statusFieldKey, "=", (Object)val);
                this.addFilter(e, filter);
            }
        }
    }

    private void addAssgrpFilter(BeforeF7SelectEvent e, long orgId, long accountTableId, long accountId, long assgrpId, MainEntityType mainType) {
        QFilter assgrpFilter;
        if (orgId > 0L && accountTableId > 0L && accountId >= 0L && assgrpId > 0L && (assgrpFilter = AssgrpFilterUtil.getAssgrpFilter((long)orgId, (long)accountTableId, (long)accountId, (long)assgrpId, (MainEntityType)mainType)) != null) {
            this.addFilter(e, assgrpFilter);
        }
    }

    private void addBankAccountFilter(BeforeF7SelectEvent e, String basedataId, Long booktypeId, Long orgId) {
        this.addBankAccountFilter(e, basedataId, booktypeId, orgId, -1L);
    }

    private void addBankAccountFilter(BeforeF7SelectEvent e, String basedataId, long booktypeId, Long orgId, Long currencyID) {
        if (basedataId.equals("bd_accountbanks") || basedataId.equals("am_accountbank") || basedataId.equals("cas_accountcash")) {
            ArrayList<Long> curIds = new ArrayList<Long>(1);
            if (currencyID > 0L) {
                curIds.add(currencyID);
            }
            FlexFilterUtil.getAccountbankFilter((String)basedataId, (BeforeF7SelectEvent)e, (long)orgId, (long)booktypeId, curIds);
        }
    }

    private void addAssistdataFilter(BeforeF7SelectEvent e, String basedataId, long orgId, DynamicObject assgrpDyn) {
        if ("bos_assistantdata_detail".equals(basedataId)) {
            this.addFilter(e, new QFilter("group.number", "=", (Object)assgrpDyn.getString("assistanttype.number")));
            List superiorIds = BDUtil.getAllSuperiorOrgIds((Object)orgId, (Long)assgrpDyn.getDynamicObject("assistanttype.ctrlview").getLong("id"), (boolean)true);
            this.addFilter(e, new QFilter("createorg.id", "in", (Object)superiorIds));
        }
    }

    private void addBaseDataFilter(BeforeF7SelectEvent e, String basedataId, long orgId) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)basedataId, (Long)orgId);
        if (baseDataFilter != null) {
            this.addFilter(e, baseDataFilter);
        }
    }

    private boolean getAccountAsstactitemIsDetail(DynamicObject account, String basedataId) {
        boolean result = false;
        if (account != null) {
            Boolean isDetail;
            QFilter sourceFilter;
            DynamicObjectCollection assgrps = account.getDynamicObjectCollection("checkitementry");
            HashMap<Long, Boolean> assgrpId2isDetail = new HashMap<Long, Boolean>(assgrps.size());
            for (DynamicObject assgrp : assgrps) {
                assgrpId2isDetail.put(assgrp.getLong("asstactitem_id"), assgrp.getBoolean("isdetail"));
            }
            QFilter idFilter = new QFilter("id", "in", assgrpId2isDetail.keySet());
            DynamicObject oneAssgrp = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (QFilter[])new QFilter[]{idFilter, sourceFilter = new QFilter("valuesource.number", "=", (Object)basedataId)});
            if (oneAssgrp != null && (isDetail = (Boolean)assgrpId2isDetail.get(oneAssgrp.getLong("id"))) != null) {
                result = isDetail;
            }
        }
        return result;
    }

    private void addFilterToFinalProcessAssgrp(BeforeF7SelectEvent e, IFormView view, IDataModel model, int row, String basedataId) {
        this.addStatusFilter(e, basedataId);
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object accountObj = customParams.get("accountId");
        if (accountObj != null) {
            Long accountId = Long.valueOf(accountObj.toString());
            DynamicObject accountDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (QFilter[])new QFilter("id", "=", (Object)accountId).toArray());
            boolean isDetail = this.getAccountAsstactitemIsDetail(accountDyn, basedataId);
            this.addTreeBasedataLeafFilter(e, basedataId, isDetail);
            Object orgObj = customParams.get("orgId");
            Object bookTypeObj = customParams.get("bookstypeId");
            if (orgObj != null && bookTypeObj != null) {
                Long orgId = Long.valueOf(orgObj.toString());
                this.addOrgFilter(e, orgId, basedataId, isDetail);
                Long bookTypeId = Long.valueOf(bookTypeObj.toString());
                AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
                if (bookInfo != null) {
                    Object assgrpObj;
                    this.addBankAccountFilter(e, basedataId, bookTypeId, orgId);
                    Long accountTableId = bookInfo.getAccountTableId();
                    if (row > -1 && (assgrpObj = model.getValue("fieldname_id", row)) != null) {
                        DynamicObject assgrpDyn;
                        Long assgrpId = Long.valueOf(assgrpObj.toString());
                        if ("bos_assistantdata_detail".equals(basedataId) && (assgrpDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (String)"assistanttype.number, assistanttype.ctrlview", (QFilter[])new QFilter("id", "=", (Object)assgrpId).toArray())) != null) {
                            this.addAssistdataFilter(e, basedataId, orgId, assgrpDyn);
                        }
                        this.addAssgrpFilter(e, orgId, accountTableId, accountId, assgrpId, EntityMetadataCache.getDataEntityType((String)basedataId));
                        this.addBaseDataFilter(e, basedataId, orgId);
                    }
                }
            }
        }
    }

    private void addFilterToAssgrpDefValAssgrp(BeforeF7SelectEvent e, IFormView view, IDataModel model, int row, String basedataId) {
        DynamicObject rowEntity;
        if (row > -1 && (rowEntity = model.getEntryRowEntity("entryentity", row)) != null) {
            DynamicObject assgrpDyn;
            long orgId = (Long)model.getValue("org_id");
            long accountTableId = (Long)model.getValue("accounttable_id");
            long accountId = rowEntity.getLong("account_id");
            long assgrpId = rowEntity.getLong("assgrptype_id");
            DynamicObject accountDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (QFilter[])new QFilter("id", "=", (Object)accountId).toArray());
            boolean isLeaf = this.getAccountAsstactitemIsDetail(accountDyn, basedataId);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)basedataId);
            this.addAssgrpFilter(e, orgId, accountTableId, accountId, assgrpId, mainType);
            this.addStatusFilter(e, basedataId);
            Map customParams = view.getFormShowParameter().getCustomParams();
            if (customParams != null) {
                Long bookid = Long.valueOf(customParams.get("book").toString());
                AccountBookInfo book = new AccountBookInfo(bookid.longValue());
                this.addBankAccountFilter(e, basedataId, book.getBookTypeId(), orgId, rowEntity.getLong(AssgrpDefaultValConstant.Entry_Currency.toIDString()));
            }
            if ((assgrpDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (String)"assistanttype.number, assistanttype.ctrlview", (QFilter[])new QFilter("id", "=", (Object)assgrpId).toArray())) != null) {
                this.addAssistdataFilter(e, basedataId, orgId, assgrpDyn);
            }
            this.addOrgFilter(e, orgId, basedataId, isLeaf);
            this.addTreeBasedataLeafFilter(e, basedataId, isLeaf);
        }
    }
}

