/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import kd.bos.dataentity.TypesContainer;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class GLAdmin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(GLAdmin.class);
    private static final String RESULT = "resultinfo";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String text = (String)this.getModel().getValue("class");
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "execute": {
                try {
                    Class pluginClazz = TypesContainer.getOrRegister((String)text);
                    IUpgradeService instance = (IUpgradeService)pluginClazz.newInstance();
                    UpgradeResult result = instance.beforeExecuteSqlWithResult(null, null, "gl", null);
                    if (result.isSuccess()) {
                        this.getView().showSuccessNotification("execute success");
                        this.getModel().setValue(RESULT, (Object)result.getLog());
                        break;
                    }
                    this.getView().showErrorNotification("execute failed");
                    this.getModel().setValue(RESULT, (Object)String.format("log:%s, errorinfo: %s", result.getLog(), result.getErrorInfo()));
                }
                catch (Exception e) {
                    this.getView().showErrorNotification("exception happens");
                    this.getModel().setValue(RESULT, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
                break;
            }
            case "setprop": {
                this.getModel().setValue(RESULT, (Object)System.setProperty(text.split("=")[0], text.split("=")[1]));
                break;
            }
            case "clearprop": {
                this.getModel().setValue(RESULT, (Object)System.clearProperty(text));
            }
        }
    }
}

