/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.GLUtil;

public class GLParamPlugin
extends AbstractFormPlugin {
    public void beforePropertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "timetosend": {
                this.validateForTimeToSend(e);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Boolean isbizvoucher = (Boolean)this.getModel().getValue("isbizvoucher");
        if (isbizvoucher.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizvoucherdate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizvoucherdate"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("isbizvoucher".equals(name)) {
            Boolean isbizvoucher = (Boolean)this.getModel().getValue("isbizvoucher");
            DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.ISBIZVOUCHER);
            distributeCache.remove("isbizvoucher");
            distributeCache.remove("openorgbizvoucher");
            if (isbizvoucher.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizvoucherdate"});
                this.getModel().setValue("bizvoucherdate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5386\u53f2\u6570\u636e\u4e0d\u53ef\u67e5\u770b\uff0c\u662f\u5426\u7ee7\u7eed\u7981\u7528\uff1f", (String)"GLParamPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("closeisbizvoucher", (IFormPlugin)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateForTimeToSend(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Long orgId = Long.parseLong(Optional.ofNullable(this.getView().getFormShowParameter().getCustomParams().get("orgid")).orElseThrow(() -> new KDBizException("org not found")).toString());
        String oldValue = (String)Optional.ofNullable(GLUtil.getSystemParam((String)"timetosend", (Long)orgId)).orElse("B");
        String newValue = (String)changeData.getNewValue();
        if (newValue.compareTo(oldValue) < 0) {
            Function<String, Boolean> loading = act -> {
                IFormView view = this.getView().getParentView();
                if (view != null) {
                    if (act.equals("show")) {
                        view.showLoading(new LocaleString(ResManager.loadKDString((String)"\u6821\u9a8c\u51ed\u8bc1\u4e2d", (String)"GLParamPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0])));
                    } else if (act.equals("hide")) {
                        view.hideLoading();
                    }
                }
                return true;
            };
            try {
                loading.apply("show");
                ArrayList<String> checkStatus = new ArrayList<String>(5);
                for (char c = newValue.charAt(0); c < oldValue.charAt(0); c = (char)(c + '\u0001')) {
                    checkStatus.add(String.valueOf(c));
                }
                List vchNos = NoticeUtils.getNonNoticeVchs(checkStatus, (Long)orgId);
                if (!vchNos.isEmpty()) {
                    ComboEdit time = (ComboEdit)this.getControl("timetosend");
                    String voucherNos = vchNos.toString().replaceAll(",", "");
                    String checkStatusTxt = checkStatus.stream().map(v -> ((ComboProp)time.getProperty()).getItemByName(v)).reduce((x, y) -> x + "\u3001" + y).orElse("error");
                    String tips = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u72b6\u6001\u672a\u901a\u8fc7\u5f53\u524d\u53d1\u9001\u8282\u70b9\uff08%s\uff09\u4e14\u672a\u53d1\u9001\u901a\u77e5\u5355\u7684\u5f80\u6765\u51ed\u8bc1\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u540e\u518d\u4fee\u6539\u53d1\u9001\u901a\u77e5\u5355\u8282\u70b9\uff1a", (String)"GLParamPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), checkStatusTxt);
                    this.getView().showMessage(tips + voucherNos, MessageTypes.Default, new ConfirmCallBackListener("switchmode_" + oldValue, (IFormPlugin)this));
                }
            }
            finally {
                loading.apply("hide");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.startsWith("switchmode") && MessageBoxResult.Cancel.equals((Object)e.getResult())) {
            this.getModel().setValue("timetosend", (Object)callBackId.substring(callBackId.length() - 1));
        } else if (callBackId.equals("closeisbizvoucher")) {
            if (MessageBoxResult.Cancel.equals((Object)e.getResult())) {
                this.getModel().setValue("isbizvoucher", (Object)true);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizvoucherdate"});
            }
        }
    }
}

