/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEdit;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class GLReportFormulaEdit
extends FormulaEdit {
    private TreeView treev;
    private Map<String, TreeNode> map = new HashMap<String, TreeNode>();
    private static final String GL_BALANCESHEET = "gl_balancesheet";
    private static final String GL_SHOWINCOME = "gl_showincome";
    private static final String GL_TAXSHOW = "gl_taxshow";
    private static final String GL_CASHFLOWSTAT = "gl_cashflowstat";

    public void click(EventObject evt) {
        try {
            super.click(evt);
        }
        catch (Throwable var3) {
            this.getView().showErrorNotification(var3.getMessage());
        }
    }

    public void initialize() {
        TreeView fieldTree;
        super.initialize();
        this.treev = fieldTree = (TreeView)this.getControl("tv_fields");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode firstRoot = new TreeNode();
        firstRoot.setParentid("");
        firstRoot.setId("0");
        firstRoot.setText(ResManager.loadKDString((String)"\u8d22\u52a1\u6307\u6807", (String)"GLReportFormulaEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        firstRoot.setIsOpened(true);
        this.treev.addNode(firstRoot);
        this.initSecondRoot(firstRoot);
        Object useorg = this.getView().getFormShowParameter().getCustomParam("useorg");
        QFilter useorgfilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_manage_rptitem", (Long)Long.parseLong(useorg + ""));
        DynamicObjectCollection reportItems = QueryServiceHelper.query((String)"gl_manage_rptitem", (String)"id,number,name,rptunit", (QFilter[])useorgfilter.toArray(), (String)"number");
        for (DynamicObject reportItem : reportItems) {
            String name = reportItem.getString("name");
            if (StringUtils.isEmpty((CharSequence)name)) continue;
            TreeNode treeNode = new TreeNode();
            TreeNode parent = this.map.get(reportItem.getString("rptunit"));
            treeNode.setParentid(reportItem.getString("rptunit"));
            treeNode.setId(reportItem.getString("number"));
            treeNode.setText(reportItem.getString("name"));
            parent.addChild(treeNode);
            this.setItemSonNode(treeNode, reportItem);
        }
        FormShowParameter showParam = this.getView().getFormShowParameter();
        this.getModel().setValue("fexpression", showParam.getCustomParam("desp"));
        this.getModel().setValue("ftranexpr", showParam.getCustomParam("desp"));
        this.getModel().setValue("fdescription", showParam.getCustomParam("expression"));
    }

    private void setItemSonNode(TreeNode treeNode, DynamicObject reportItem) {
        String rptunit = reportItem.getString("rptunit");
        if (GL_BALANCESHEET.equals(rptunit)) {
            this.setBalancesheet(treeNode, reportItem);
        } else if (GL_SHOWINCOME.equals(rptunit)) {
            this.setShowincome(treeNode, reportItem);
        } else if (GL_TAXSHOW.equals(rptunit)) {
            this.setTaxShow(treeNode, reportItem);
        } else if (GL_CASHFLOWSTAT.equals(rptunit)) {
            this.setCashflowstat(treeNode, reportItem);
        }
    }

    private void setTaxShow(TreeNode treeNode, DynamicObject reportItem) {
        TreeNode sonNode1 = new TreeNode();
        sonNode1.setParentid(treeNode.getId());
        sonNode1.setId(reportItem.getString("number") + "1");
        sonNode1.setText(ResManager.loadKDString((String)"\u672c\u671f\u91d1\u989d", (String)"GLReportFormulaEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode1);
        TreeNode sonNode2 = new TreeNode();
        sonNode2.setParentid(treeNode.getId());
        sonNode2.setId(reportItem.getString("number") + "2");
        sonNode2.setText(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"GLReportFormulaEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode2);
        TreeNode sonNode3 = new TreeNode();
        sonNode3.setParentid(treeNode.getId());
        sonNode3.setId(reportItem.getString("number") + "3");
        sonNode3.setText(ResManager.loadKDString((String)"\u4e0a\u671f\u91d1\u989d", (String)"GLReportFormulaEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode3);
        TreeNode sonNode4 = new TreeNode();
        sonNode4.setParentid(treeNode.getId());
        sonNode4.setId(reportItem.getString("number") + "4");
        sonNode4.setText(ResManager.loadKDString((String)"\u4e0a\u671f\u7d2f\u8ba1", (String)"GLReportFormulaEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode4);
        TreeNode sonNode5 = new TreeNode();
        sonNode5.setParentid(treeNode.getId());
        sonNode5.setId(reportItem.getString("number") + "5");
        sonNode5.setText(ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"GLReportFormulaEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode5);
        TreeNode sonNode6 = new TreeNode();
        sonNode6.setParentid(treeNode.getId());
        sonNode6.setId(reportItem.getString("number") + "6");
        sonNode6.setText(ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u7d2f\u8ba1", (String)"GLReportFormulaEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode6);
    }

    private void setCashflowstat(TreeNode treeNode, DynamicObject reportItem) {
        TreeNode sonNode1 = new TreeNode();
        sonNode1.setParentid(treeNode.getId());
        sonNode1.setId(reportItem.getString("number") + "1");
        sonNode1.setText(ResManager.loadKDString((String)"\u672c\u671f\u91d1\u989d", (String)"GLReportFormulaEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        TreeNode sonNode2 = new TreeNode();
        sonNode2.setId(reportItem.getString("number") + "2");
        sonNode2.setText(ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"GLReportFormulaEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode1);
        treeNode.addChild(sonNode2);
    }

    private void setShowincome(TreeNode treeNode, DynamicObject reportItem) {
        TreeNode sonNode1 = new TreeNode();
        sonNode1.setParentid(treeNode.getId());
        sonNode1.setId(reportItem.getString("number") + "1");
        sonNode1.setText(ResManager.loadKDString((String)"\u672c\u671f\u91d1\u989d", (String)"GLReportFormulaEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode1);
        TreeNode sonNode2 = new TreeNode();
        sonNode2.setParentid(treeNode.getId());
        sonNode2.setId(reportItem.getString("number") + "2");
        sonNode2.setText(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"GLReportFormulaEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode2);
        TreeNode sonNode3 = new TreeNode();
        sonNode3.setParentid(treeNode.getId());
        sonNode3.setId(reportItem.getString("number") + "3");
        sonNode3.setText(ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"GLReportFormulaEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode3);
        TreeNode sonNode4 = new TreeNode();
        sonNode4.setParentid(treeNode.getId());
        sonNode4.setId(reportItem.getString("number") + "4");
        sonNode4.setText(ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u7d2f\u8ba1", (String)"GLReportFormulaEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode4);
    }

    private void setBalancesheet(TreeNode treeNode, DynamicObject reportItem) {
        TreeNode sonNode1 = new TreeNode();
        sonNode1.setParentid(treeNode.getId());
        sonNode1.setId(reportItem.getString("number") + "1");
        sonNode1.setText(ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"GLReportFormulaEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode1);
        TreeNode sonNode2 = new TreeNode();
        sonNode2.setParentid(treeNode.getId());
        sonNode2.setId(reportItem.getString("number") + "2");
        sonNode2.setText(ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"GLReportFormulaEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        treeNode.addChild(sonNode2);
    }

    private void initSecondRoot(TreeNode firstRoot) {
        String parentId = firstRoot.getId();
        TreeNode treeNode1 = new TreeNode();
        treeNode1.setParentid(parentId);
        treeNode1.setId(GL_BALANCESHEET);
        treeNode1.setText(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d1f\u503a\u8868", (String)"GLReportFormulaEdit_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        TreeNode treeNode2 = new TreeNode();
        treeNode2.setParentid(parentId);
        treeNode2.setId(GL_SHOWINCOME);
        treeNode2.setText(ResManager.loadKDString((String)"\u5229\u6da6\u8868", (String)"GLReportFormulaEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        TreeNode treeNode3 = new TreeNode();
        treeNode3.setParentid(parentId);
        treeNode3.setId(GL_TAXSHOW);
        treeNode3.setText(ResManager.loadKDString((String)"\u4f01\u4e1a\u7eb3\u7a0e\u8868", (String)"GLReportFormulaEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        TreeNode treeNode4 = new TreeNode();
        treeNode4.setParentid(parentId);
        treeNode4.setId(GL_CASHFLOWSTAT);
        treeNode4.setText(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868", (String)"GLReportFormulaEdit_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        firstRoot.addChild(treeNode1);
        firstRoot.addChild(treeNode2);
        firstRoot.addChild(treeNode3);
        firstRoot.addChild(treeNode4);
        this.map.put(GL_BALANCESHEET, treeNode1);
        this.map.put(GL_SHOWINCOME, treeNode2);
        this.map.put(GL_TAXSHOW, treeNode3);
        this.map.put(GL_CASHFLOWSTAT, treeNode4);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeID = e.getNodeId().toString();
        if (nodeID == null || nodeID.length() != 7) {
            return;
        }
        String nonFdStr = (String)this.getView().getFormShowParameter().getCustomParam("nonFields");
        if (StringUtils.isNotBlank((CharSequence)nonFdStr)) {
            Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
            if (!nonSet.contains(nodeID)) {
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)nodeID);
            }
        } else {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)nodeID);
        }
    }
}

