/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.helper.CashFlowItemHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.formplugin.CashFlowDesignate;
import kd.fi.gl.formplugin.DesignateCommonPlugin;
import kd.fi.gl.formplugin.PresetCashFlowDesignate;
import kd.fi.gl.formplugin.accoutdesignation.AccDesignateExportHelper;
import kd.fi.gl.util.CashFlowItemHelperNew;
import kd.fi.gl.util.DesignateContext;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MutexRequireHelper;
import kd.fi.gl.util.cashflow.FilterContext;

public class MainDesignateEdit
extends DesignateCommonPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(MainDesignateEdit.class);
    private LogFacts logFacts = new LogFacts();
    private static final String ENTRY_D = "debitentry";
    private static final String ENTRY_C = "creditentry";
    private static final String ACCT = "account";
    private static final String ACCTID = "accountid";
    private static final String AMT = "amount";
    private static final String INFO = "info";
    private static final String CFTYPE = "cftype";
    private static final String TYPE = "type";
    private static final String COUNT = "count";
    private static final String LEVEL = "level";
    private static final String LEVELRE = "levelre";
    private static final String CFITEMID = "cfitemid";
    public static final String TYPE_ACC = "1";
    public static final String TYPE_CF = "2";
    public static final int DEFAULT_VOUCHERBATCH_SIZE = 200;
    private static final String CFITEM_PERIOD_MAP = "cashFlowItemByPeriodMap";
    private static final String NUMBER = "fnumber";
    private Map<Long, DynamicObject> cfItemMapCache = new HashMap<Long, DynamicObject>(8);

    private static String getCash() {
        return ResManager.loadKDString((String)"\u73b0\u91d1\u7c7b", (String)"MainDesignateEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
    }

    private static String getUncash() {
        return ResManager.loadKDString((String)"\u975e\u73b0\u91d1\u7c7b", (String)"MainDesignateEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
    }

    private static String getNonassgrp() {
        return ResManager.loadKDString((String)"\u975e\u6838\u7b97\u9879\u76ee", (String)"MainDesignateEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
    }

    private static String getUnhandle() {
        return ResManager.loadKDString((String)"\u672a\u5904\u7406\u73b0\u91d1\u6d41\u91cf", (String)"MainDesignateEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.optionColumn(ENTRY_D, "debit", "operationcolumnd");
        this.optionColumn(ENTRY_C, "credit", "operationcolumnc");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryc = (EntryGrid)this.getControl(ENTRY_C);
        entryc.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryd = (EntryGrid)this.getControl(ENTRY_D);
        entryd.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void optionColumn(String entryKey, String prefix, String opCols) {
        EntryGrid entryGridd = (EntryGrid)this.getControl(entryKey);
        entryGridd.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && opCols.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                DynamicObject obj = pkEvent.getRowData();
                boolean[] ocim = this.makeOperationColItems(obj, prefix);
                List operationColItems = (List)pkEvent.getFormatValue();
                ((OperationColItem)operationColItems.get(0)).setVisible(ocim[0]);
                ((OperationColItem)operationColItems.get(1)).setVisible(ocim[1]);
                ((OperationColItem)operationColItems.get(2)).setVisible(ocim[2]);
                ((OperationColItem)operationColItems.get(3)).setVisible(ocim[3]);
                ((OperationColItem)operationColItems.get(4)).setVisible(ocim[4]);
                ((OperationColItem)operationColItems.get(5)).setVisible(ocim[5]);
            }
        });
    }

    private boolean[] makeOperationColItems(DynamicObject obj, String prefix) {
        boolean[] oci = new boolean[]{true, true, true, true, true, true};
        String cftype = obj.getString(prefix + CFTYPE);
        String type = obj.getString(prefix + TYPE);
        String level = obj.getString(prefix + LEVEL);
        String levelre = obj.getString(prefix + LEVELRE);
        int count = obj.getInt(prefix + COUNT);
        String acctInfo = obj.getString(prefix + ACCT);
        String inforKey = obj.getString(prefix + INFO);
        String acct = acctInfo.split("_")[0];
        if (Integer.parseInt(level) != 1 && TYPE_ACC.equals(type) && this.isLastLevel(inforKey, acct)) {
            oci[0] = false;
        }
        if (TYPE_ACC.equals(cftype)) {
            oci[1] = false;
            oci[2] = false;
            oci[3] = false;
            oci[4] = false;
            if (count == 0) {
                oci[5] = false;
            }
        } else if (TYPE_CF.equals(cftype)) {
            String newrowdatamap = this.getPageCache().get("newrowdatamap");
            if (StringUtils.isNotEmpty((String)newrowdatamap)) {
                this.getPageCache().remove("newrowdatamap");
                Map rowData = (Map)SerializationUtils.fromJsonString((String)newrowdatamap, Map.class);
                String acctNew = (String)rowData.get(ACCT);
                if (acctInfo.equals(acctNew)) {
                    levelre = rowData.get(LEVELRE) + "";
                    count = (Integer)rowData.get(COUNT);
                    type = (String)rowData.get(TYPE);
                    oci[1] = false;
                }
            }
            if (count == 0) {
                oci[5] = false;
            }
            if (StringUtils.isNotEmpty((String)type)) {
                if (TYPE_ACC.equals(type)) {
                    if (TYPE_CF.equals(levelre)) {
                        oci[1] = true;
                    }
                } else if (TYPE_CF.equals(type)) {
                    oci[1] = false;
                } else if (type.startsWith("3")) {
                    oci[0] = false;
                    oci[1] = false;
                    oci[2] = false;
                    oci[5] = false;
                }
            }
            if ("3".equals(levelre)) {
                oci[1] = false;
                if (TYPE_CF.equals(type)) {
                    oci[0] = false;
                }
            }
            if (acctInfo.equals(MainDesignateEdit.getUnhandle())) {
                oci[2] = false;
            } else if (acctInfo.equals(MainDesignateEdit.getUncash())) {
                oci[2] = false;
                oci[3] = false;
                oci[4] = false;
            }
        }
        return oci;
    }

    private boolean isLastLevel(String infoKey, String acctNum) {
        long isLastLevelStart = System.currentTimeMillis();
        if (DebugTrace.enable()) {
            logger.info("[T_preset]isLastLevel_param, infoKey: {}, acctNum: {}", (Object)infoKey, (Object)acctNum);
        }
        boolean isLastLevel = true;
        Set<Long> leafAccountIds = this.getLeafAccountExSelf(acctNum);
        if (DebugTrace.enable()) {
            logger.info("[T_preset]isLastLevel_param, infoKey: {}, acctNum: {}, leafAccountIds: {}", new Object[]{infoKey, acctNum, leafAccountIds});
        }
        if (leafAccountIds.size() > 0) {
            FilterContext filterContext = this.getFilterContextFromPageCache();
            QFilter qfilter = filterContext.getqFilter();
            Set<Long> cacheVoucherIds = this.getCacheVoucherIds(infoKey);
            if (cacheVoucherIds != null && cacheVoucherIds.size() > 0) {
                qfilter.and(new QFilter("id", "in", cacheVoucherIds));
            }
            qfilter.and(new QFilter("entries.account", "in", leafAccountIds));
            long start = System.currentTimeMillis();
            isLastLevel = !QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])qfilter.toArray());
            long end = System.currentTimeMillis();
            logger.info("[T_preset]isLastLevel_exists_cost: {} ms", (Object)(end - start));
        }
        long isLastLevelEnd = System.currentTimeMillis();
        logger.info("[T_preset]isLastLevel:{}, isLastLevel_cost: {} ms", (Object)isLastLevel, (Object)(isLastLevelEnd - isLastLevelStart));
        return isLastLevel;
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "refresh": {
                FilterContext filterContext = this.getFilterContextFromPageCache();
                this.doQuery(filterContext);
                break;
            }
            case "preset": {
                this.showPreSetConfirmTip();
                break;
            }
        }
    }

    private void showPreSetConfirmTip() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult hasPermOrg = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)appId, (String)"gl_accdesignate", (String)"0YH1QK63ECUV");
        if (null == hasPermOrg || !hasPermOrg.hasAllOrgPerm() && hasPermOrg.getHasPermOrgs().size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0[T\u578b\u8d26\u6237\u6307\u5b9a]\u7684\u64cd\u4f5c[\u5e94\u7528\u9884\u8bbe]\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MainDesignateEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showConfirmTipForPreset("preset", ResManager.loadKDString((String)"\u662f\u5426\u8986\u76d6\u5df2\u6307\u5b9a\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff1f", (String)"MainDesignateEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u5df2\u5ba1\u6838\u51ed\u8bc1\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u4e0d\u4f1a\u88ab\u66ff\u6362\u3002", (String)"MainDesignateEdit_26", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    private void preset(boolean coverDesigned) {
        long presetStart = System.currentTimeMillis();
        kd.fi.gl.util.CashFlowItemHelper.logFacts.init();
        this.logFacts.init();
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter filters = filterContext.getqFilter();
        Map<Long, Map<String, PresetCashFlowDesignate>> subAcct = this.getSubAcct(filters, TYPE_ACC, coverDesigned);
        HashMap<Long, List<PresetCashFlowItemParam>> paramListMap = new HashMap<Long, List<PresetCashFlowItemParam>>(subAcct.size());
        HashSet<Long> voucherIdSet = new HashSet<Long>(subAcct.size());
        String checkMsg = null;
        checkMsg = this.initPresetParamAndVoucherIdsByPeriod(subAcct, paramListMap, voucherIdSet);
        if (checkMsg != null) {
            this.getView().showTipNotification(checkMsg, Integer.valueOf(2000));
            return;
        }
        AccountBookInfo book = filterContext.getBook();
        checkMsg = this.checkPeriod(book, voucherIdSet);
        if (checkMsg != null) {
            this.getView().showTipNotification(checkMsg, Integer.valueOf(2000));
            return;
        }
        if (this.checkModifyHisCf(voucherIdSet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u5305\u542b\u5df2\u7ed3\u8d26\u671f\u95f4\u51ed\u8bc1\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"MainDesignateEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        long orgId = book.getOrgId();
        long accountTableId = book.getAccountTableId();
        long batchGetCashFlowItemIdsStart = System.currentTimeMillis();
        boolean isDesignateSuccess = false;
        boolean hasPresetMap = false;
        for (Map.Entry param : paramListMap.entrySet()) {
            long period = (Long)param.getKey();
            List paramList = (List)param.getValue();
            Map presetMap = PresetCashItemUtil.batchGetCashFlowItemIds((List)paramList, (long)orgId, (long)accountTableId, (long)period);
            long batchGetCashFlowItemIdsEnd = System.currentTimeMillis();
            logger.info("[T_preset]batchGetCashFlowItemIds_cost: {} ms", (Object)(batchGetCashFlowItemIdsEnd - batchGetCashFlowItemIdsStart));
            if (CollectionUtils.isEmpty((Map)presetMap)) continue;
            hasPresetMap = true;
            if (DebugTrace.enable()) {
                logger.info("[T_preset]mapping_pattern:acctId-acctLongnumber-assgrp-dc-itemType=value,map={}", (Object)this.presetMapToString(presetMap));
            }
            for (Map.Entry<String, PresetCashFlowDesignate> entry : subAcct.get(period).entrySet()) {
                PresetCashFlowDesignate value = entry.getValue();
                PresetCashFlowItemParam key = this.buildPresetParam(value);
                Long cfItem = (Long)presetMap.get(key);
                if (DebugTrace.enable()) {
                    logger.info("[T_preset]preset_cfItem={}, key={}", (Object)cfItem, (Object)key);
                }
                if (cfItem == null) continue;
                boolean hasDesignate = this.designateV1(cfItem, value.getAssgrpId(), value.getVchIdEntriesIdMap());
                if (isDesignateSuccess) continue;
                isDesignateSuccess = hasDesignate;
            }
            Object designateV1ParamsCache = ThreadCache.get((Object)"designateV1Params");
            if (null == designateV1ParamsCache) continue;
            DesignateCommonPlugin.DesignateV1Params designateV1Params = (DesignateCommonPlugin.DesignateV1Params)designateV1ParamsCache;
            boolean hasDesignate = this.designateV1Pack(designateV1Params);
            if (!isDesignateSuccess) {
                isDesignateSuccess = hasDesignate;
            }
            ThreadCache.remove((Object)"designateV1Params");
        }
        if (!hasPresetMap) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u79d1\u76ee\u6620\u5c04\u5173\u7cfb\u3002", (String)"MainDesignateEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (isDesignateSuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9884\u8bbe\u6210\u529f\u3002", (String)"MainDesignateEdit_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            this.doQuery(filterContext);
        }
        long presetEnd = System.currentTimeMillis();
        if (DebugTrace.enable()) {
            logger.info("[T_preset]c_logFacts: {} ,logFacts:{} ", (Object)kd.fi.gl.util.CashFlowItemHelper.logFacts, (Object)this.logFacts);
        }
        logger.info("[T_preset]preset_cost: {} ms", (Object)(presetEnd - presetStart));
    }

    private Map<Long, Map<String, PresetCashFlowDesignate>> getSubAcct(QFilter filters, String newL, boolean coverDesigned) {
        QFilter mainstatusQF;
        long getSubAcctStart = System.currentTimeMillis();
        HashMap<Long, Map<String, PresetCashFlowDesignate>> resultMap = new HashMap<Long, Map<String, PresetCashFlowDesignate>>();
        if (DebugTrace.enable()) {
            logger.info("[T_preset]getSubAcct_doQuery qFilter: {}", (Object)this.filterToString(filters));
        }
        String selectFields = "id,period,billstatus,entries.id entryid, entries.maincfitem maincfitem, entries.maincfamount maincfamount, entries.entrydc entrydc,entries.assgrp assgrp, entries.account account, entries.debitlocal debitlocal,entries.creditlocal creditlocal";
        if (coverDesigned) {
            mainstatusQF = new QFilter("mainstatus", "in", Arrays.asList("3", TYPE_CF, TYPE_ACC));
        } else {
            mainstatusQF = new QFilter("mainstatus", "in", Arrays.asList(TYPE_CF, TYPE_ACC));
            mainstatusQF.and(new QFilter("entries.maincfitem", "=", (Object)0L));
        }
        mainstatusQF.and(filters);
        Set<Long> uncashAccIds = this.getCashAccIds(false);
        Map<Long, DynamicObject> accMap = this.getAccDO(uncashAccIds);
        try (DataSet ds = this.getInitDataSet(mainstatusQF, selectFields, false);){
            long getInitDataSetEnd = System.currentTimeMillis();
            logger.info("[T_preset]getSubAcct_getInitDataSet_cost: {} ms", (Object)(getInitDataSetEnd - getSubAcctStart));
            DataSet orderByperiodDs = ds.orderBy(new String[]{"period"});
            int buildNum = 0;
            long lastPeriod = 0L;
            LinkedHashMap<String, PresetCashFlowDesignate> map = new LinkedHashMap<String, PresetCashFlowDesignate>();
            for (Row row : orderByperiodDs) {
                long period = row.getLong("period");
                if (lastPeriod == 0L) {
                    lastPeriod = period;
                    resultMap.put(lastPeriod, map);
                } else if (lastPeriod != period) {
                    map = new LinkedHashMap();
                    lastPeriod = period;
                    resultMap.put(lastPeriod, map);
                }
                ++buildNum;
                Long accountId = row.getLong(ACCT);
                DynamicObject accDO = accMap.get(accountId);
                Long entryItemId = row.getLong("maincfitem");
                if (entryItemId != 0L) {
                    DynamicObject cfItem1 = CashFlowItemHelperNew.getCfItem(this.cfItemMapCache, (Long)entryItemId);
                    BigDecimal dc1 = BigDecimal.ONE;
                    if (cfItem1 != null && "o".equals(cfItem1.getString("direction"))) {
                        dc1 = dc1.negate();
                    }
                    this.buildAcctRow(row.getBigDecimal("maincfamount").multiply(dc1), row, map, newL, accDO);
                    continue;
                }
                this.buildAcctRow(row.getBigDecimal("creditlocal").subtract(row.getBigDecimal("debitlocal")), row, map, newL, accDO);
            }
            long getSubAcctEnd = System.currentTimeMillis();
            logger.info("[T_preset]getSubAcct_cost: {} ms, map.size: {}, buildNum: {}", new Object[]{getSubAcctEnd - getSubAcctStart, map.size(), buildNum});
        }
        return resultMap;
    }

    private Map<Long, DynamicObject> getAccDO(Set<Long> accIds) {
        HashMap<Long, DynamicObject> vchMap = new HashMap<Long, DynamicObject>(accIds.size());
        QFilter qFilter = new QFilter("id", "in", accIds);
        DynamicObject[] AccArr = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id, masterid, name, number, longnumber", (QFilter[])new QFilter[]{qFilter});
        for (int i = 0; i < AccArr.length; ++i) {
            DynamicObject vch = AccArr[i];
            long id = vch.getLong("id");
            vchMap.put(id, vch);
        }
        return vchMap;
    }

    private void buildAcctRow(BigDecimal amt, Row row, Map<String, PresetCashFlowDesignate> map, String newL, DynamicObject accDO) {
        String name = accDO.getString("number") + "_" + accDO.getString("name");
        Long account = accDO.getLong("masterid");
        String longnumber = accDO.getString("longnumber");
        String entrydc = row.getString("entrydc");
        String entryDc = TYPE_ACC.equals(entrydc) ? "d" : "c";
        Long assgrp = row.getLong("assgrp");
        String idKey = account + "-" + entryDc + "-1-" + assgrp;
        Long id = row.getLong("id");
        Long entryid = row.getLong("entryid");
        if (map.get(idKey) == null) {
            HashSet<Long> ids = new HashSet<Long>(16);
            ids.add(id);
            PresetCashFlowDesignate cf = new PresetCashFlowDesignate();
            map.put(idKey, cf);
            cf.setAmt(amt);
            cf.setName(name);
            cf.setVchIds(ids);
            cf.setType(TYPE_ACC);
            cf.setLevel(newL);
            ArrayList<Long> entryIds = new ArrayList<Long>(16);
            entryIds.add(entryid);
            cf.setVoucherEntryIds(entryIds);
            ArrayListMultimap vchIdEntriesIdMap = ArrayListMultimap.create();
            vchIdEntriesIdMap.put((Object)id, (Object)entryid);
            cf.setVchIdEntriesIdMap((Multimap<Long, Long>)vchIdEntriesIdMap);
            cf.setAcctId(account);
            cf.setAcctLongNumber(longnumber);
            cf.setItemType(TYPE_ACC);
            cf.setAssgrpId(assgrp);
            cf.setDc(entrydc);
        } else {
            PresetCashFlowDesignate cf = map.get(idKey);
            cf.setAmt(cf.getAmt().add(amt));
            cf.getVchIds().add(id);
            cf.getVoucherEntryIds().add(entryid);
            Multimap<Long, Long> vchIdEntriesIdMap = cf.getVchIdEntriesIdMap();
            vchIdEntriesIdMap.put((Object)id, (Object)entryid);
        }
    }

    private Set<Long> getLeafAccountExSelf(String acctNum) {
        DataSet dataSetByNumber = this.getDataSetByNumber(acctNum);
        HashSet<Long> result = new HashSet<Long>(8);
        HashSet<Long> self = new HashSet<Long>(8);
        HashSet<Long> parentIds = new HashSet<Long>(8);
        for (Row row : dataSetByNumber) {
            if (row.getBoolean("fisleaf").booleanValue()) {
                result.add(row.getLong("fid"));
                self.add(row.getLong("fid"));
                continue;
            }
            parentIds.add(row.getLong("fmasterid"));
            parentIds.add(row.getLong("fid"));
        }
        if (parentIds.size() != 0) {
            DataSet children = this.getDataSetByParentId(parentIds);
            Set<Long> childrenResult = this.getLeafAccountId(children);
            result.addAll(childrenResult);
        }
        if (self.size() > 0) {
            result.removeAll(self);
        }
        return result;
    }

    private Set<Long> getLeafAccountId(DataSet dyn) {
        HashSet<Long> result = new HashSet<Long>(8);
        HashSet<Long> parentIds = new HashSet<Long>(8);
        for (Row row : dyn) {
            if (row.getBoolean("fisleaf").booleanValue()) {
                result.add(row.getLong("fid"));
                continue;
            }
            parentIds.add(row.getLong("fmasterid"));
            parentIds.add(row.getLong("fid"));
        }
        if (parentIds.size() != 0) {
            DataSet children = this.getDataSetByParentId(parentIds);
            Set<Long> childrenResult = this.getLeafAccountId(children);
            result.addAll(childrenResult);
        }
        return result;
    }

    private void printEntryInfos(String entry, String key) {
        if (DebugTrace.enable()) {
            try {
                String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
                IDataModel model = this.getModel();
                int curri = model.getEntryCurrentRowIndex(entry);
                int entryRowCount = model.getEntryRowCount(entry);
                logger.info("[T_preset]printEntryInfos, key: {},entry: {},curri: {},entryRowCount: {}", new Object[]{key, entry, curri, entryRowCount});
                for (int i = 0; i < entryRowCount; ++i) {
                    String info = (String)model.getValue(prefix + INFO, i);
                    String cftype = (String)model.getValue(prefix + CFTYPE, i);
                    String type = (String)model.getValue(prefix + TYPE, i);
                    int count = (Integer)model.getValue(prefix + COUNT, i);
                    int levelre = (Integer)model.getValue(prefix + LEVELRE, i);
                    int level = (Integer)model.getValue(prefix + LEVEL, i);
                    String accountid = (String)model.getValue(prefix + ACCTID, i);
                    String account = (String)model.getValue(prefix + ACCT, i);
                    BigDecimal amt = (BigDecimal)model.getValue(prefix + AMT, i);
                    logger.info("[T_preset]printEntryInfos, i: {},info: {}, cftype: {}, type: {}, count: {}, levelre: {}, level: {}, accountid: {}, account: {}, amt: {}", new Object[]{i, info, cftype, type, count, levelre, level, accountid, account, amt});
                }
            }
            catch (Exception e) {
                logger.error("[T_preset]printEntryInfos error, entry: {}", (Object)entry, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAssgrp(String entry) {
        IDataModel model = this.getModel();
        int curIndex = this.getModel().getEntryCurrentRowIndex(entry);
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        String infoKey = (String)model.getValue(prefix + INFO, curIndex);
        Set<Long> ids = this.getCacheVoucherIds(infoKey);
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter qfilter = filterContext.getqFilter();
        QFilter idQFilter = new QFilter("id", "in", ids);
        idQFilter.and(qfilter);
        DataSet ds = null;
        String assgrpField = null;
        String assgrptype = null;
        String selectedFields = "id,mainstatus,entries.id entryid,entries.account account,entries.account.number number,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.maincfitem maincfitem,entries.maincfamount maincfamount,entries.assgrp assgrp,entries.maincfassgrp mcfassgrp";
        try {
            ds = this.getInitDataSet(idQFilter, selectedFields, false);
            ds = ds.filter("mainstatus != '3' or maincfitem != 0L");
            String type = (String)model.getValue(prefix + TYPE, curIndex);
            String acct = (String)model.getValue(prefix + ACCT, curIndex);
            if (TYPE_ACC.equals(type)) {
                String acctnumber = acct.split("_")[0];
                acctnumber = acctnumber.trim();
                String exp = "number='" + acctnumber + "'";
                ds = ds.filter(exp);
                assgrpField = "assgrp";
                ds = prefix.equals("debit") ? ds.addField("creditlocal-debitlocal", "amt") : ds.addField("debitlocal-creditlocal", "amt");
                assgrptype = "31";
            } else if (TYPE_CF.equals(type)) {
                String maincfnumber = acct.split("_")[0];
                String maincfIdExp = this.createMaincfIdExp(maincfnumber);
                ds = ds.filter(maincfIdExp);
                assgrpField = "mcfassgrp";
                ds = prefix.equals("debit") ? ds.addField("case when maincfitem!=0 then maincfamount else (creditlocal-debitlocal) end", "amt") : ds.addField("case when maincfitem!=0 then maincfamount else (debitlocal-creditlocal) end", "amt");
                assgrptype = "32";
            }
            Map<String, CashFlowDesignate> map = this.buildAssgrpItem(ds, assgrpField, assgrptype);
            this.updateModel(entry, prefix, model, curIndex, map, TYPE_CF);
        }
        finally {
            if (null != ds) {
                ds.close();
            }
        }
    }

    private void reloadCount(String entry) {
        IDataModel model = this.getModel();
        model.updateCache();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        int uncashIndex = this.getUncashIndex(entry, prefix);
        int entryRowCount = model.getEntryRowCount(entry);
        int count = 0;
        for (int i = uncashIndex + 1; i < entryRowCount; ++i) {
            int lever = (Integer)model.getValue(prefix + LEVEL, i);
            if (2 != lever) continue;
            ++count;
        }
        model.setValue(prefix + COUNT, (Object)count, uncashIndex);
        logger.info("reloadCount count : " + count);
        model.updateCache();
    }

    private void reload(String entry) {
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(entry);
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        String type = (String)model.getValue(prefix + TYPE, curIndex);
        String acctInfo = (String)model.getValue(prefix + ACCT, curIndex);
        if (acctInfo.trim().equals(MainDesignateEdit.getUncash())) {
            this.fold(entry, curIndex);
            this.showCashFlowItem(entry, curIndex);
        } else {
            String typeAcctOrCfByUncashIndex = this.checkEntryTypeAcctOrCfByUncashIndex(entry);
            int levelre = (Integer)model.getValue(prefix + LEVELRE, curIndex);
            if (levelre >= 3 && (type.equals(TYPE_CF) || type.startsWith("3")) && TYPE_CF.equals(typeAcctOrCfByUncashIndex)) {
                this.reloadByTypeExpandCf(entry);
            } else if (levelre >= 3 && (type.equals(TYPE_CF) || type.startsWith("3"))) {
                for (int i = curIndex; i > 0; --i) {
                    levelre = (Integer)model.getValue(prefix + LEVEL, i);
                    if (levelre == 2) {
                        curIndex = i;
                        break;
                    }
                    String prefixtype = (String)model.getValue(prefix + TYPE, i - 1);
                    String infoKey = (String)model.getValue(prefix + INFO, i - 1);
                    String acct = (String)model.getValue(prefix + ACCT, i - 1);
                    acct = acct.split("_")[0];
                    if (!TYPE_ACC.equals(prefixtype) || !this.isLastLevel(infoKey, acct)) continue;
                    curIndex = i - 1;
                    break;
                }
                this.fold(entry, curIndex);
                this.showCashFlowItem(entry, curIndex);
            } else if (levelre == 2 && type.equals(TYPE_ACC)) {
                this.fold(entry, curIndex);
                this.updateAccountAmt(entry, curIndex);
                this.showCashFlowItem(entry, curIndex);
            } else if (TYPE_ACC.equals(typeAcctOrCfByUncashIndex)) {
                if (type.startsWith("3")) {
                    this.fold(entry, curIndex - 1);
                    this.updateAccountAmt(entry, curIndex - 1);
                    this.showCashFlowItem(entry, curIndex - 1);
                }
            } else if (levelre == 3 && type.equals(TYPE_ACC)) {
                this.relodaCaseAcctFunc(entry);
            } else if (levelre > 3) {
                this.relodaCaseAcctFunc(entry);
            } else {
                DynamicObjectCollection col = model.getEntryEntity(entry);
                int i = 0;
                for (DynamicObject obj : col) {
                    if (obj.getString(prefix + ACCT).trim().equals(MainDesignateEdit.getUncash())) {
                        curIndex = i;
                        break;
                    }
                    ++i;
                }
                this.showCashFlowItem(entry, curIndex);
            }
            this.reloadCount(entry);
        }
    }

    private void reloadByTypeExpandCf(String entry) {
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(entry);
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        String type = (String)model.getValue(prefix + TYPE, curIndex);
        int levelre = (Integer)model.getValue(prefix + LEVELRE, curIndex);
        if (levelre >= 3 && (type.equals(TYPE_CF) || type.startsWith("3"))) {
            this.relodaCaseAcctFunc(entry);
        }
    }

    private String checkEntryTypeAcctOrCfByUncashIndex(String entry) {
        IDataModel model = this.getModel();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        int uncashIndex = this.getUncashIndex(entry, prefix);
        int nextIndex = uncashIndex + 1;
        String type = (String)model.getValue(prefix + TYPE, nextIndex);
        return type;
    }

    private void relodaCaseAcctFunc(String entry) {
        IDataModel model = this.getModel();
        model.getDataEntity(true);
        int curIndex = model.getEntryCurrentRowIndex(entry);
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        String acctN = ((String)model.getValue(prefix + ACCT, curIndex)).trim();
        int targetIndex = 0;
        String cfitemName = "";
        String cancel = this.getPageCache().get("cancelcfitem");
        if (StringUtils.isNotEmpty((String)cancel) && acctN.equals(cancel)) {
            this.getPageCache().remove("cancelcfitem");
            cfitemName = MainDesignateEdit.getUnhandle();
            targetIndex = this.getUnhandleIndex(entry, prefix);
        } else {
            cfitemName = this.getCfitemName();
            targetIndex = this.getTargetCFIndex(entry, cfitemName);
        }
        int acctNumS = this.getAcctIndexS(entry, curIndex);
        boolean isTargetExpand = true;
        if (0 == targetIndex) {
            Map<String, Object> newCFItemRowResult = this.newCFItemRow(entry, curIndex, cfitemName);
            Object success = newCFItemRowResult.get("success");
            if (!((Boolean)success).booleanValue()) {
                return;
            }
            targetIndex = (Integer)newCFItemRowResult.get("targetIndex");
            isTargetExpand = false;
            curIndex = curIndex >= targetIndex ? curIndex + 1 : curIndex;
            model.updateCache();
        } else {
            int targetCount = (Integer)model.getValue(prefix + COUNT, targetIndex);
            String targetAcct = model.getValue(prefix + ACCT, targetIndex).toString();
            boolean bl = isTargetExpand = targetCount > 0;
            if (isTargetExpand && !targetAcct.equals(MainDesignateEdit.getUnhandle())) {
                boolean containsAcct = false;
                String curAcct = ((String)model.getValue(prefix + ACCT, acctNumS)).trim().split("_")[0];
                LinkedHashMap<String, Map<String, Object>> acctCurMap = this.getAcctCurIndexMap(entry, targetIndex, curIndex);
                for (Map.Entry<String, Map<String, Object>> acctCurMapEntry : acctCurMap.entrySet()) {
                    String acct = acctCurMapEntry.getKey().split("_")[0];
                    if (!curAcct.split("_")[0].contains(acct)) continue;
                    containsAcct = true;
                    break;
                }
                if (!containsAcct) {
                    model.setValue(prefix + COUNT, (Object)(targetCount + 1), targetIndex);
                }
            }
        }
        acctNumS = this.getAcctIndexS(entry, curIndex);
        int uncashIndex = this.getUncashIndex(entry, prefix);
        Map<String, CashFlowDesignate> cfitmMap = this.buildCFItemData(entry, uncashIndex);
        String targetCfitem = (String)model.getValue(prefix + ACCT, targetIndex);
        CashFlowDesignate targetCfitemInfo = cfitmMap.get(targetCfitem);
        Map<Long, Set<Long>> key2Voucherids = this.getCache();
        if (null != targetCfitemInfo) {
            long key = Long.parseLong(model.getValue(prefix + INFO, targetIndex).toString());
            if (key == 0L) {
                key = this.batchGenGlobalIds(1)[0];
            }
            key2Voucherids.put(key, targetCfitemInfo.getVchIds());
            model.setValue(prefix + INFO, (Object)Long.toString(key), targetIndex);
            model.setValue(prefix + AMT, (Object)targetCfitemInfo.getAmt(), targetIndex);
        }
        int cfItemeIndex = this.getCFItemeIndex(entry, acctNumS);
        String cfItemeCur = (String)model.getValue(prefix + ACCT, cfItemeIndex);
        CashFlowDesignate cfitemCurInfo = cfitmMap.get(cfItemeCur);
        if (null != cfitemCurInfo) {
            long key = Long.parseLong(model.getValue(prefix + INFO, cfItemeIndex).toString());
            if (key == 0L) {
                key = this.batchGenGlobalIds(1)[0];
            }
            key2Voucherids.put(key, cfitemCurInfo.getVchIds());
            model.setValue(prefix + INFO, (Object)Long.toString(key), cfItemeIndex);
            model.setValue(prefix + AMT, (Object)cfitemCurInfo.getAmt(), cfItemeIndex);
        }
        this.putCache(key2Voucherids);
        int acctNumNew = this.getAcctIndexS(entry, curIndex);
        if (!isTargetExpand) {
            LinkedHashMap<String, Map<String, Object>> acctCurMap = this.getAcctCurIndexMap(entry, acctNumNew, curIndex);
            this.reloadEntryLastData(entry, curIndex, acctNumNew, acctCurMap);
        } else if (curIndex > targetIndex) {
            String targetAcct = model.getValue(prefix + ACCT, targetIndex).toString();
            if (!targetAcct.equals(MainDesignateEdit.getUnhandle())) {
                curIndex = this.reloadTopAcct(entry, curIndex, targetIndex, acctNumS);
                acctNumNew = this.getAcctIndexS(entry, curIndex);
                LinkedHashMap<String, Map<String, Object>> acctCurMap = this.getAcctCurIndexMap(entry, acctNumNew, curIndex);
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("index", curIndex);
                row.put(COUNT, model.getValue(prefix + COUNT, curIndex));
                String acct = ((String)model.getValue(prefix + ACCT, curIndex)).trim();
                acctCurMap.put(acct, row);
                this.reloadEntryLastData(entry, curIndex, acctNumNew, acctCurMap);
                int targetloopIndex = targetIndex;
                this.reloadEntryTargetData(entry, acctCurMap, targetloopIndex);
            }
        } else {
            this.reloadTopAcct(entry, curIndex, targetIndex, acctNumS);
            int targetloopIndex = targetIndex;
            LinkedHashMap<String, Map<String, Object>> acctCurMap = this.getAcctCurIndexMap(entry, acctNumS, curIndex);
            this.reloadEntryTargetData(entry, acctCurMap, targetloopIndex);
            acctCurMap = this.getAcctCurIndexMap(entry, acctNumS, curIndex);
            this.reloadEntryLastData(entry, curIndex, acctNumNew, acctCurMap);
        }
        EntryGrid eg = (EntryGrid)this.getControl(entry);
        eg.selectRows(targetIndex);
        model.updateCache();
    }

    private LinkedHashMap<String, Map<String, Object>> getAcctCurIndexMap(String entry, int acctNumS, int curAcctIndex) {
        IDataModel model = this.getModel();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        int assIndex = this.getAssIndex(entry, acctNumS);
        LinkedHashMap<String, Map<String, Object>> acctCurMap = new LinkedHashMap<String, Map<String, Object>>(assIndex - acctNumS + 1);
        int level = (Integer)model.getValue(prefix + LEVEL, assIndex > acctNumS ? acctNumS + 1 : acctNumS);
        int curAcctNumS = this.getAcctIndexS(entry, curAcctIndex);
        String curAcct = ((String)model.getValue(prefix + ACCT, curAcctNumS)).trim().split("_")[0];
        for (int i = acctNumS; i <= assIndex; ++i) {
            String acct = ((String)model.getValue(prefix + ACCT, i)).trim();
            int levelLoop = (Integer)model.getValue(prefix + LEVEL, i);
            if (levelLoop == level && !acct.split("_")[0].contains(curAcct)) continue;
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("index", i);
            row.put(COUNT, model.getValue(prefix + COUNT, i));
            acctCurMap.put(acct, row);
        }
        return acctCurMap;
    }

    private void reloadEntryTargetData(String entry, LinkedHashMap<String, Map<String, Object>> acctCurMap, int targetloopIndex) {
        IDataModel model = this.getModel();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        for (Map.Entry<String, Map<String, Object>> acctCurMapEntry : acctCurMap.entrySet()) {
            int assIndexTarget;
            String acct = acctCurMapEntry.getKey();
            int targetAcctIndex = this.getAcctIndexByNum(entry, prefix, acct, targetloopIndex, assIndexTarget = this.getAssIndex(entry, targetloopIndex));
            if (0 != targetAcctIndex) {
                int count = (Integer)acctCurMapEntry.getValue().get(COUNT);
                if (count > 0) {
                    this.showAcct(entry, targetAcctIndex);
                } else {
                    this.reloadEntryTargetDataShowAcct(entry, targetAcctIndex);
                }
            }
            model.updateCache();
        }
    }

    private void reloadEntryTargetDataShowAcct(String entry, int targetStartIndex) {
        IDataModel model = this.getModel();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        LinkedHashMap<String, Map<String, Object>> acctTargetMap = this.getAcctCurIndexMap(entry, targetStartIndex, targetStartIndex);
        for (Map.Entry<String, Map<String, Object>> acctTargetMapEntry : acctTargetMap.entrySet()) {
            int count;
            int assIndexTarget;
            String acct = acctTargetMapEntry.getKey();
            int targetAcctIndex = this.getAcctIndexByNum(entry, prefix, acct, targetStartIndex, assIndexTarget = this.getAssIndex(entry, targetStartIndex));
            if (0 != targetAcctIndex && (count = ((Integer)acctTargetMapEntry.getValue().get(COUNT)).intValue()) > 0) {
                this.showAcct(entry, targetAcctIndex);
            }
            model.updateCache();
        }
    }

    private int reloadTopAcct(String entry, int curIndex, int targetIndex, int acctNumS) {
        int assIndexTarget;
        String acctNew;
        int tc = targetIndex + 1;
        IDataModel model = this.getModel();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        int targetAcctTopIndex = this.getAcctIndexByNum(entry, prefix, acctNew = (String)model.getValue(prefix + ACCT, acctNumS), targetIndex, assIndexTarget = this.getAssIndex(entry, targetIndex));
        if (0 == targetAcctTopIndex) {
            Map<Long, Set<Long>> infoKey2Voucherids = this.getCache();
            long[] infoKeys = this.batchGenGlobalIds(1);
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            rowData.put(AMT, model.getValue(prefix + AMT, curIndex));
            rowData.put(LEVEL, model.getValue(prefix + LEVEL, acctNumS));
            rowData.put(LEVELRE, model.getValue(prefix + LEVELRE, acctNumS));
            rowData.put(ACCT, model.getValue(prefix + ACCT, acctNumS));
            rowData.put(ACCTID, model.getValue(prefix + ACCTID, acctNumS));
            infoKey2Voucherids.put(infoKeys[0], infoKey2Voucherids.get(Long.valueOf(model.getValue(prefix + INFO, curIndex).toString())));
            rowData.put(INFO, infoKeys[0]);
            rowData.put(CFTYPE, model.getValue(prefix + CFTYPE, acctNumS));
            rowData.put(TYPE, model.getValue(prefix + TYPE, acctNumS));
            rowData.put(COUNT, 0);
            this.addNewEntryRow(entry, prefix, tc, rowData);
            this.putCache(infoKey2Voucherids);
            ++curIndex;
        }
        model.updateCache();
        return curIndex;
    }

    private void reloadEntryLastData(String entry, int curIndex, int acctNumS, LinkedHashMap<String, Map<String, Object>> acctCurMap) {
        IDataModel model = this.getModel();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        String acctN = (String)model.getValue(prefix + ACCT, acctNumS);
        int cfItemeIndex = this.getCFItemeIndex(entry, acctNumS);
        int oldCount = (Integer)model.getValue(prefix + COUNT, cfItemeIndex);
        int oldCFItemIndex = this.getCFItemeIndex(entry, curIndex);
        int curloopIndex = this.getCFItemeIndex(entry, acctNumS);
        Map<Long, Set<Long>> infoKey2Voucherids = this.getCache();
        for (Map.Entry<String, Map<String, Object>> acctCurMapEntry : acctCurMap.entrySet()) {
            String acct = acctCurMapEntry.getKey();
            Integer acctIndexOld = (Integer)acctCurMapEntry.getValue().get("index");
            Map<String, CashFlowDesignate> acctMap = this.buildAcctCFitemData(entry, curloopIndex);
            for (Map.Entry<String, CashFlowDesignate> e : acctMap.entrySet()) {
                CashFlowDesignate cfitemInfo = e.getValue();
                if (null == cfitemInfo || !acct.equals(cfitemInfo.getName())) continue;
                infoKey2Voucherids.put(Long.valueOf(model.getValue(prefix + INFO, acctIndexOld.intValue()).toString()), cfitemInfo.getVchIds());
                model.setValue(prefix + AMT, (Object)cfitemInfo.getAmt(), acctIndexOld.intValue());
                break;
            }
            curloopIndex = acctIndexOld;
        }
        this.putCache(infoKey2Voucherids);
        boolean isChangeCfIteme = false;
        ListIterator<Map.Entry<String, Map<String, Object>>> i = new ArrayList<Map.Entry<String, Map<String, Object>>>(acctCurMap.entrySet()).listIterator(acctCurMap.size());
        while (i.hasPrevious()) {
            Map.Entry<String, Map<String, Object>> acctCurMapEntry = i.previous();
            int loopIndex = (Integer)acctCurMapEntry.getValue().get("index");
            int oldAcctCount = (Integer)model.getValue(prefix + COUNT, loopIndex);
            model.setValue(prefix + COUNT, (Object)(oldAcctCount - 1), loopIndex);
            if (oldAcctCount > 1) break;
            int acctNumTopIndex = this.getAcctIndexS(entry, loopIndex);
            isChangeCfIteme = loopIndex == acctNumTopIndex;
            model.deleteEntryRow(entry, loopIndex);
            model.updateCache();
        }
        if (isChangeCfIteme) {
            if (1 == oldCount) {
                model.deleteEntryRow(entry, cfItemeIndex);
                model.updateCache();
            } else {
                boolean containsAcct = false;
                int assIndex = this.getAssIndex(entry, cfItemeIndex);
                LinkedHashMap<String, Map<String, Object>> acctCurMap2 = this.getAcctCurIndexMap(entry, cfItemeIndex, assIndex);
                for (Map.Entry<String, Map<String, Object>> acctCurMapEntry : acctCurMap2.entrySet()) {
                    String acct = acctCurMapEntry.getKey().split("_")[0];
                    if (!acctN.split("_")[0].contains(acct)) continue;
                    containsAcct = true;
                    break;
                }
                if (!containsAcct) {
                    model.setValue(prefix + COUNT, (Object)(oldCount - 1), oldCFItemIndex);
                }
            }
        }
        model.updateCache();
    }

    private String getCfitemName() {
        String cfitemName = "";
        String addCFItem = this.getPageCache().get("addCFItem");
        this.getPageCache().remove("addCFItem");
        logger.info("getCfitemName():addCFItem(\u6307\u5b9a\u7684\u73b0\u91d1\u6d41\u91cfid) -> " + addCFItem);
        if (null != addCFItem) {
            DynamicObject cashflowitem = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(addCFItem), (String)"gl_cashflowitem");
            String number = cashflowitem.getString("number");
            String name = cashflowitem.getString("name");
            cfitemName = number + "_" + name;
        }
        logger.info("getCfitemName():cfitemName(\u6307\u5b9a\u7684\u73b0\u91d1\u6d41\u91cf\u540d\u79f0) -> " + cfitemName);
        return cfitemName;
    }

    private int getAssIndex(String entry, int curIndex) {
        int levelN;
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount(entry);
        if (curIndex == entryRowCount - 1) {
            return curIndex;
        }
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        int index = curIndex;
        int level = (Integer)model.getValue(prefix + LEVEL, index);
        int i = curIndex;
        while (i < entryRowCount && (levelN = ((Integer)model.getValue(prefix + LEVEL, i)).intValue()) >= level) {
            index = i++;
            level = levelN;
        }
        return index;
    }

    private int getAcctIndexS(String entry, int curIndex) {
        return this.getAcctIndexS(entry, curIndex, 0);
    }

    private int getAcctIndexS(String entry, int curIndex, int fromIndex) {
        String prefix;
        int index = 0;
        IDataModel model = this.getModel();
        String acctId = (String)model.getValue((prefix = entry.equals(ENTRY_D) ? "debit" : "credit") + ACCTID, this.getRightAcctNumIndex(prefix, curIndex));
        if (StringUtils.isEmpty((String)acctId)) {
            return curIndex;
        }
        String topAcct = this.getTopAcct(Long.parseLong(acctId));
        for (int i = curIndex; i > fromIndex; --i) {
            String acctN = ((String)model.getValue(prefix + ACCT, i)).split("_")[0].trim();
            if (!topAcct.equals(acctN)) continue;
            index = i;
            break;
        }
        return index;
    }

    private int getRightAcctNumIndex(String prefix, int index) {
        String acctId;
        int levelre;
        if (index < 0) {
            logger.error("[T_preset]getRightAcctNumIndex_error, prefix: {}, index: {}", (Object)prefix, (Object)index);
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u518d\u5c1d\u8bd5\u3002", (String)"MainDesignateEdit_24", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        IDataModel model = this.getModel();
        String type = (String)model.getValue(prefix + TYPE, index);
        if (type.startsWith("3")) {
            index = this.getRightAcctNumIndex(prefix, index - 1);
        }
        if ((levelre = ((Integer)this.getModel().getValue(prefix + LEVELRE, index)).intValue()) > 3) {
            index = this.getRightAcctNumIndex(prefix, index - 1);
        }
        if (!this.isNumberMatches(acctId = (String)this.getModel().getValue(prefix + ACCTID, index))) {
            index = this.getRightAcctNumIndex(prefix, index - 1);
        }
        return index;
    }

    private boolean isNumberMatches(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    private int calculateCFItemIndex(String entry, String cfitemName) {
        IDataModel model = this.getModel();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        DynamicObjectCollection col = model.getEntryEntity(entry);
        int moveToIndex = this.getUncashIndex(entry, prefix);
        if (MainDesignateEdit.getUnhandle().equals(cfitemName)) {
            return moveToIndex + 1;
        }
        HashMap<String, Integer> cfitemNumMap = new HashMap<String, Integer>();
        for (int j = 0; j < col.size(); ++j) {
            DynamicObject obj = (DynamicObject)col.get(j);
            String typeF = obj.getString(prefix + TYPE);
            String cftypeF = obj.getString(prefix + CFTYPE);
            if (!TYPE_CF.equals(cftypeF) || !TYPE_CF.equals(typeF)) continue;
            String acctF = obj.getString(prefix + ACCT);
            acctF = acctF.split("_")[0];
            cfitemNumMap.put(acctF, j);
        }
        if (cfitemNumMap.size() == 0) {
            return moveToIndex + 1;
        }
        if (cfitemNumMap.size() == 1) {
            String cfitemNameEntryOne = ((String)cfitemNumMap.keySet().iterator().next()).split("_")[0];
            if (MainDesignateEdit.getUnhandle().equals(cfitemNameEntryOne)) {
                moveToIndex = col.size();
                return moveToIndex;
            }
        }
        cfitemNumMap.remove(MainDesignateEdit.getUnhandle());
        cfitemNumMap.put(cfitemName.split("_")[0], 0);
        QFilter itemNumberFilter = new QFilter("number", "in", (Object)cfitemNumMap.keySet().toArray());
        DynamicObject[] cashflowitems = BusinessDataServiceHelper.load((String)"gl_cashflowitem", (String)"number", (QFilter[])new QFilter[]{itemNumberFilter}, (String)"number");
        for (int j = 0; j < cashflowitems.length; ++j) {
            DynamicObject cashflowitem = cashflowitems[j];
            if (!cashflowitem.getString("number").equals(cfitemName.split("_")[0])) continue;
            if (j == 0 || cashflowitems.length == 1) {
                int unhandleIndex = this.getUnhandleIndex(entry, prefix);
                if (0 == unhandleIndex) {
                    moveToIndex = this.getUncashIndex(entry, prefix);
                    break;
                }
                moveToIndex = this.getNextCFItemeIndex(entry, unhandleIndex);
                break;
            }
            if (j == cashflowitems.length - 1) {
                moveToIndex = col.size();
                break;
            }
            DynamicObject lastCashflowitem = cashflowitems[j - 1];
            int lastCFIndex = (Integer)cfitemNumMap.get(lastCashflowitem.getString("number"));
            moveToIndex = this.getNextCFItemeIndex(entry, lastCFIndex);
            break;
        }
        return moveToIndex;
    }

    private Map<String, Object> newCFItemRow(String entry, int curIndex, String cfitemName) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        Map<String, CashFlowDesignate> map = this.getCollCashFlowDesignate(entry, curIndex);
        CashFlowDesignate cashFlowDesignate = map.get(cfitemName);
        if (null == cashFlowDesignate) {
            this.itemClick(new ItemClickEvent((Object)this, "refresh", null));
            logger.error("newCFItemRow\uff08\uff09,\u65b0\u589e\u73b0\u91d1\u6d41\u91cf\u65f6\u627e\u4e0d\u5230\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff0c\u73b0\u91d1\u6d41\u91cf\uff1a" + cfitemName);
            result.put("success", Boolean.FALSE);
            return result;
        }
        int level = 2;
        int targetIndex = this.calculateCFItemIndex(entry, cfitemName);
        long[] infoKey = this.batchGenGlobalIds(1);
        Map<Long, Set<Long>> voucherIdCache = this.getCache();
        voucherIdCache.put(infoKey[0], cashFlowDesignate.getVchIds());
        this.putCache(voucherIdCache);
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        rowData.put(AMT, cashFlowDesignate.getAmt());
        rowData.put(LEVEL, level);
        rowData.put(ACCT, cashFlowDesignate.getName());
        rowData.put(ACCTID, cashFlowDesignate.getName());
        rowData.put(INFO, infoKey[0]);
        rowData.put(CFTYPE, TYPE_CF);
        rowData.put(TYPE, cashFlowDesignate.getType());
        rowData.put(LEVELRE, level);
        rowData.put(COUNT, 0);
        this.addNewEntryRow(entry, prefix, targetIndex, rowData);
        result.put("success", Boolean.TRUE);
        result.put("targetIndex", targetIndex);
        return result;
    }

    private int getTargetCFIndex(String entry, String cfitemName) {
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        int index = this.getAcctIndexByNum(entry, prefix, cfitemName);
        return index;
    }

    private int getCFItemeIndex(String entry, int curIndex) {
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        int index = 0;
        IDataModel model = this.getModel();
        for (int i = curIndex; i > 0; --i) {
            if (!TYPE_CF.equals(model.getValue(prefix + CFTYPE, i)) || !TYPE_CF.equals(model.getValue(prefix + TYPE, i))) continue;
            index = i;
            break;
        }
        return index;
    }

    private int getNextCFItemeIndex(String entry, int curIndex) {
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        DynamicObjectCollection col = model.getEntryEntity(entry);
        int index = col.size() - 1;
        for (int i = curIndex + 1; i < col.size(); ++i) {
            if (!TYPE_CF.equals((String)model.getValue(prefix + CFTYPE, i)) || !TYPE_CF.equals((String)model.getValue(prefix + TYPE, i))) continue;
            index = i;
            break;
        }
        return index;
    }

    private Set<String> getAcct(String acctNum) {
        HashSet<String> result = new HashSet<String>();
        this.getLeafAccount(this.getDataSetByNumber(acctNum), result, NUMBER);
        return result;
    }

    private void addNewEntryRow(String entry, String prefix, int index, Map<String, Object> rowData) {
        DynamicObject rowObj = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType().getAllEntities().get(entry));
        rowObj.set(prefix + ACCT, rowData.get(ACCT));
        rowObj.set(prefix + ACCTID, rowData.get(ACCTID));
        rowObj.set(prefix + AMT, rowData.get(AMT));
        rowObj.set(prefix + INFO, rowData.get(INFO));
        rowObj.set(prefix + LEVEL, rowData.get(LEVEL));
        rowObj.set(prefix + LEVELRE, rowData.get(LEVELRE));
        rowObj.set(prefix + CFTYPE, rowData.get(CFTYPE));
        rowObj.set(prefix + TYPE, rowData.get(TYPE));
        rowObj.set(prefix + COUNT, rowData.get(COUNT));
        this.getPageCache().put("newrowdatamap", SerializationUtils.toJsonString(rowData));
        this.getModel().createNewEntryRow(entry, index, rowObj);
        this.getModel().setValue(prefix + AMT, rowData.get(AMT), index);
        this.getModel().setValue(prefix + LEVEL, rowData.get(LEVEL), index);
        this.getModel().setValue(prefix + ACCT, rowData.get(ACCT), index);
        this.getModel().setValue(prefix + ACCTID, rowData.get(ACCTID), index);
        this.getModel().setValue(prefix + INFO, rowData.get(INFO), index);
        this.getModel().setValue(prefix + CFTYPE, rowData.get(CFTYPE), index);
        this.getModel().setValue(prefix + TYPE, rowData.get(TYPE), index);
        this.getModel().setValue(prefix + LEVELRE, rowData.get(LEVELRE), index);
        this.getModel().setValue(prefix + COUNT, rowData.get(COUNT), index);
        this.getModel().updateCache();
    }

    private int getUnhandleIndex(String entry, String prefix) {
        return this.getAcctIndexByNum(entry, prefix, MainDesignateEdit.getUnhandle());
    }

    private int getUncashIndex(String entry, String prefix) {
        return this.getAcctIndexByNum(entry, prefix, MainDesignateEdit.getUncash());
    }

    private int getAcctIndexByNum(String entry, String prefix, String acctNo) {
        DynamicObjectCollection col = this.getModel().getEntryEntity(entry);
        int index = 0;
        for (int i = 0; i <= col.size() - 1; ++i) {
            DynamicObject obj = (DynamicObject)col.get(i);
            if (!obj.getString(prefix + ACCT).trim().equals(acctNo)) continue;
            index = i;
            break;
        }
        return index;
    }

    private int getAcctIndexByNum(String entry, String prefix, String acctNo, int from, int to) {
        DynamicObjectCollection col = this.getModel().getEntryEntity(entry);
        if (to == 0) {
            to = col.size() - 1;
        }
        int index = 0;
        for (int i = from; i <= to; ++i) {
            DynamicObject obj = (DynamicObject)col.get(i);
            if (!obj.getString(prefix + ACCT).trim().equals(acctNo)) continue;
            index = i;
            break;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, CashFlowDesignate> getCollCashFlowDesignate(String entry, int curIndex) {
        Map<String, CashFlowDesignate> map = null;
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        String infoKey = (String)model.getValue(prefix + INFO, curIndex);
        Set<Long> ids = this.getCacheVoucherIds(infoKey);
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter qfilter = filterContext.getqFilter();
        QFilter idQFilter = new QFilter("id", "in", ids);
        idQFilter.and(qfilter);
        DataSet ds = null;
        String selectedFields = "id,mainstatus,entries.id entryid,entries.account account,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.maincfitem maincfitem,entries.maincfamount maincfamount";
        try {
            ds = this.getInitDataSet(idQFilter, selectedFields, false);
            ds = ds.filter("mainstatus != '3' or maincfitem != 0L");
            ds = entry.equals(ENTRY_D) ? ds.addField("case when maincfitem!=0 then maincfamount else (creditlocal-debitlocal) end", "amt") : ds.addField("case when maincfitem!=0 then maincfamount else (debitlocal-creditlocal) end", "amt");
            map = this.buildCFItem(ds, prefix);
        }
        finally {
            if (null != ds) {
                ds.close();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelCFItem(String entry) {
        boolean isSucc = false;
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(entry);
        this.getPageCache().put("cancelcfitem", ((String)model.getValue(prefix + ACCT, curIndex)).trim());
        String infoKey = (String)model.getValue(prefix + INFO, curIndex);
        Set<Long> voucherIds = this.getCacheVoucherIds(infoKey);
        QFilter qfilter = this.cancelCFItemQFilter(entry, curIndex, voucherIds);
        HashSet bookIds = new HashSet(10);
        HashSet vouIds = new HashSet(10);
        ArrayList paramList = new ArrayList(voucherIds.size());
        ArrayList vchParams = new ArrayList(voucherIds.size());
        ArrayList entryParams = new ArrayList(voucherIds.size());
        HashMap dataMap = new HashMap(16);
        this.checkParam(qfilter);
        boolean hasAuditVchs = false;
        long orgId = this.getFilterValue("org.id");
        long bookTypeId = this.getFilterValue("booktype.id");
        String opertion = "cancelCFItem";
        Set lockIds = MutexRequireHelper.batchRequire((String)"gl_voucher", voucherIds, (String)opertion);
        if (voucherIds.size() != lockIds.size()) {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u51ed\u8bc1\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainDesignateEdit_31", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi.gl.MainDesignate.cancelCF", (String)"gl_voucher", (String)"id, billstatus, entries.id, period", (QFilter[])qfilter.toArray(), null);){
            ArrayList<Long> entryIds = new ArrayList<Long>(10);
            long voucherId = 0L;
            for (Row r : ds) {
                if (!GLUtil.isCurrentVoucherAllowModifyCF((long)orgId, (long)bookTypeId, (long)r.getLong("period"), (String)r.getString("billstatus"))) {
                    hasAuditVchs = true;
                    continue;
                }
                if (voucherId != 0L && r.getLong("id") != voucherId) {
                    entryIds = new ArrayList(10);
                    if (dataMap.size() > 200) {
                        CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, (String)TYPE_ACC, bookIds, paramList, vchParams, entryParams, vouIds);
                        dataMap.clear();
                        isSucc = true;
                    }
                }
                voucherId = r.getLong("id");
                dataMap.put(voucherId, entryIds);
                if (r.getLong("entries.id") == 0L) continue;
                entryIds.add(r.getLong("entries.id"));
            }
            if (dataMap.size() > 0) {
                CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, (String)TYPE_ACC, bookIds, paramList, vchParams, entryParams, vouIds);
                isSucc = true;
            }
            CashFlowItemHelperNew.saveData(paramList, vchParams, entryParams, vouIds);
        }
        finally {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            if (!bookIds.isEmpty()) {
                kd.fi.gl.util.CashFlowItemHelper.calBal(bookIds);
            }
        }
        if (hasAuditVchs) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"MainDesignateEdit_27", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        return isSucc;
    }

    private int cancelCFItemLoopRightIndex(String entry, int index) {
        int rightIndex = index;
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        String type = (String)this.getModel().getValue(prefix + TYPE, index);
        if (type.startsWith("3")) {
            rightIndex = this.cancelCFItemLoopRightIndex(entry, index - 1);
        }
        return rightIndex;
    }

    private QFilter cancelCFItemQFilter(String entry, int index, Set<Long> ids) {
        IDataModel model = this.getModel();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        QFilter qfilter = null;
        String acctN = ((String)model.getValue(prefix + ACCT, index)).trim();
        if (acctN.equals(MainDesignateEdit.getUncash())) {
            FilterContext filterContext = this.getFilterContextFromPageCache();
            qfilter = filterContext.getqFilter();
        } else {
            index = this.cancelCFItemLoopRightIndex(entry, index);
            acctN = ((String)model.getValue(prefix + ACCT, index)).trim();
            String type = (String)model.getValue(prefix + TYPE, index);
            String item = null;
            if (type.equals(TYPE_ACC)) {
                item = "entries.account.number";
            } else if (type.equals(TYPE_CF)) {
                item = "entries.maincfitem.number";
            }
            QFilter facctNum = null;
            if (acctN.equals(MainDesignateEdit.getUnhandle())) {
                facctNum = new QFilter("entries.maincfitem", "=", (Object)0);
            } else {
                String acctNum = acctN.split("_")[0];
                String cftype = (String)model.getValue(prefix + CFTYPE, index);
                if (TYPE_CF.equals(cftype) && TYPE_CF.equals(type)) {
                    facctNum = new QFilter(item, "=", (Object)acctNum);
                } else {
                    Set<String> acctCol = this.getAcct(acctNum);
                    facctNum = new QFilter(item, "in", acctCol);
                }
            }
            QFilter fid = new QFilter("id", "in", ids);
            qfilter = fid.and(facctNum);
        }
        return qfilter;
    }

    private boolean setCFItemByPeriod(long id, long assgrpId, List<Long> periods) {
        String entry = this.getPageCache().get("entrykey");
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(entry);
        String acctN = ((String)model.getValue(prefix + ACCT, curIndex)).trim();
        String infoKey = (String)model.getValue(prefix + INFO, curIndex);
        Set<Long> ids = this.getCacheVoucherIds(infoKey);
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter qfilter = filterContext.getqFilter();
        QFilter fidQF = new QFilter("id", "in", ids);
        fidQF.and(qfilter);
        if (!CollectionUtils.isEmpty(periods)) {
            qfilter.and(new QFilter("period", "in", periods));
        }
        if (!acctN.equals(MainDesignateEdit.getUncash())) {
            String acctNum;
            String num;
            int levelre;
            String type = (String)model.getValue(prefix + TYPE, curIndex);
            String item = null;
            QFilter facct = null;
            if (TYPE_ACC.equals(type)) {
                item = "entries.account.number";
                levelre = (Integer)model.getValue(prefix + LEVELRE, curIndex);
                if (levelre == 3) {
                    num = this.getAcctNum(model, prefix, curIndex, 2);
                    facct = !MainDesignateEdit.getUnhandle().equals(num) ? new QFilter("entries.maincfitem.number", "=", (Object)num) : new QFilter("entries.maincfitem", "=", (Object)0);
                }
            } else if (TYPE_CF.equals(type)) {
                item = "entries.maincfitem.number";
                levelre = (Integer)model.getValue(prefix + LEVELRE, curIndex);
                if (levelre == 3) {
                    acctNum = this.getAcctNum(model, prefix, curIndex, 2);
                    HashSet<String> result = new HashSet<String>();
                    this.getLeafAccount(this.getDataSetByNumber(acctNum), result, NUMBER);
                    facct = new QFilter("entries.account.number", "=", (Object)acctNum);
                    if (result.size() > 0) {
                        facct = new QFilter("entries.account.number", "in", result);
                    }
                }
            } else if (type.startsWith("3")) {
                String _cfitem;
                String _acct;
                if (type.startsWith("31")) {
                    levelre = (Integer)model.getValue(prefix + LEVELRE, curIndex);
                    if (levelre == 3) {
                        facct = new QFilter("entries.account.number", "=", (Object)this.getAcctNum(model, prefix, curIndex, 2));
                    } else if (levelre == 4) {
                        _acct = this.getAcctNum(model, prefix, curIndex, 3);
                        _cfitem = this.getAcctNum(model, prefix, curIndex, 2);
                        facct = new QFilter("entries.account.number", "=", (Object)_acct);
                        facct = MainDesignateEdit.getUnhandle().equals(_cfitem) ? facct.and(new QFilter("entries.maincfitem", "=", (Object)0)) : facct.and(new QFilter("entries.maincfitem.number", "=", (Object)_cfitem));
                    }
                } else {
                    levelre = (Integer)model.getValue(prefix + LEVELRE, curIndex);
                    if (levelre == 3) {
                        num = this.getAcctNum(model, prefix, curIndex, 2);
                        facct = !MainDesignateEdit.getUnhandle().equals(num) ? new QFilter("entries.maincfitem.number", "=", (Object)num) : new QFilter("entries.maincfitem", "=", (Object)0);
                    } else if (levelre == 4) {
                        _acct = this.getAcctNum(model, prefix, curIndex, 2);
                        _cfitem = this.getAcctNum(model, prefix, curIndex, 3);
                        facct = new QFilter("entries.account.number", "=", (Object)_acct);
                        facct = MainDesignateEdit.getUnhandle().equals(_cfitem) ? facct.and(new QFilter("entries.maincfitem", "=", (Object)0)) : facct.and(new QFilter("entries.maincfitem.number", "=", (Object)_cfitem));
                    }
                }
            }
            QFilter facctNum = null;
            if (acctN.equals(MainDesignateEdit.getUnhandle())) {
                facctNum = new QFilter("entries.maincfitem", "=", (Object)0);
            } else if (!type.startsWith("3") && type.equals(TYPE_ACC)) {
                acctNum = acctN.split("_")[0];
                Set<String> accts = this.getAcct(acctNum);
                facctNum = new QFilter(item, "in", accts);
            } else if (!type.startsWith("3")) {
                acctNum = acctN.split("_")[0];
                facctNum = new QFilter(item, "=", (Object)acctNum);
            } else if (type.startsWith("3")) {
                String exp = null;
                String[] types = type.split("_");
                exp = type.startsWith("31") ? "entries.assgrp" : "entries.maincfassgrp";
                facctNum = new QFilter(exp, "=", (Object)GLUtil.transferStr2Long((Object)types[1]));
            }
            fidQF.and(facctNum);
            if (facct != null) {
                fidQF.and(facct);
            }
        }
        return this.designateV1Single(fidQF, id, assgrpId, ids);
    }

    private String getAcctNum(IDataModel m, String prefix, int curIndex, int expectLevel) {
        for (int i = curIndex - 1; i > 0; --i) {
            int level = (Integer)m.getValue(prefix + LEVELRE, i);
            if (level != expectLevel) continue;
            String acctN = ((String)m.getValue(prefix + ACCT, i)).trim();
            String acctNum = acctN.split("_")[0];
            return acctNum;
        }
        return null;
    }

    private void fold(String entry, int curIndex) {
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        int level = (Integer)model.getValue(prefix + LEVEL, curIndex);
        int count = (Integer)model.getValue(prefix + COUNT, curIndex);
        for (int i = (count += this.getDisplayCount(model, curIndex, entry, prefix, level)) + curIndex; i > curIndex; --i) {
            model.deleteEntryRow(entry, i);
        }
        model.setValue(prefix + COUNT, (Object)0, curIndex);
        model.updateCache();
    }

    private int getDisplayCount(IDataModel model, int curIndex, String entry, String prefix, int curLevel) {
        int size = model.getEntryRowCount(entry);
        int num = 0;
        for (int i = curIndex + 1; i < size && curLevel < (Integer)model.getValue(prefix + LEVEL, i); ++i) {
            num += ((Integer)model.getValue(prefix + COUNT, i)).intValue();
        }
        return num;
    }

    private void updateAccountAmt(String entry, int curIndex) {
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        int curLevel = (Integer)model.getValue(prefix + LEVEL, curIndex);
        int acctIndexS = this.getAcctIndexS(entry, curIndex, 0);
        for (int i = curIndex; i >= acctIndexS; --i) {
            int level = (Integer)model.getValue(prefix + LEVEL, i);
            if (i != curIndex && level >= curLevel) continue;
            BigDecimal amt = BigDecimal.ZERO;
            Map<String, CashFlowDesignate> stringCashFlowDesignateMap = this.buildCFItemData(entry, i);
            for (Map.Entry<String, CashFlowDesignate> stringCashFlowDesignateEntry : stringCashFlowDesignateMap.entrySet()) {
                CashFlowDesignate value = stringCashFlowDesignateEntry.getValue();
                amt = amt.add(value.getDcAmt());
            }
            model.setValue(prefix + AMT, (Object)amt, i);
        }
    }

    private void showCashFlowItem(String entry, int curIndex) {
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        Map<String, CashFlowDesignate> map = this.buildCFItemData(entry, curIndex);
        this.updateModel(entry, prefix, model, curIndex, map, TYPE_CF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, CashFlowDesignate> buildCFItemData(String entry, int curIndex) {
        LinkedHashMap<String, CashFlowDesignate> map = new LinkedHashMap();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        String infoKey = (String)model.getValue(prefix + INFO, curIndex);
        Set<Long> ids = this.getCacheVoucherIds(infoKey);
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter qfilter = filterContext.getqFilter();
        QFilter idQFilter = new QFilter("id", "in", ids);
        idQFilter.and(qfilter);
        DataSet ds = null;
        String selectedFields = "id,mainstatus,entries.id entryid,entries.account account,entries.account.number number,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.maincfitem maincfitem,entries.maincfamount maincfamount";
        try {
            ds = this.getInitDataSet(idQFilter, selectedFields, false);
            ds = ds.filter("mainstatus != '3' or maincfitem != 0L");
            String acct = (String)model.getValue(prefix + ACCT, curIndex);
            if (!MainDesignateEdit.getUncash().equals(acct)) {
                String acctnumber = ((String)model.getValue(prefix + ACCT, curIndex)).split("_")[0];
                acctnumber = acctnumber.trim();
                DataSet dataSet = this.getDataSetByNumber(acctnumber);
                HashSet<String> result = new HashSet<String>();
                this.getLeafAccount(dataSet, result, NUMBER);
                String exp = "number='" + acctnumber + "'";
                if (result.size() > 0) {
                    exp = "number in ('" + String.join((CharSequence)"','", result) + "')";
                    ds = ds.filter(exp);
                }
            }
            ds = entry.equals(ENTRY_D) ? ds.addField("case when maincfitem!=0 then maincfamount else (creditlocal-debitlocal) end", "amt") : ds.addField("case when maincfitem!=0 then maincfamount else (debitlocal-creditlocal) end", "amt");
            map = this.buildCFItem(ds, prefix);
        }
        finally {
            if (null != ds) {
                ds.close();
            }
        }
        return map;
    }

    private Map<String, CashFlowDesignate> buildAssgrpItem(DataSet ds, String assgrpField, String assgrptype) {
        LinkedHashMap<String, CashFlowDesignate> map = new LinkedHashMap<String, CashFlowDesignate>();
        ArrayList<Long> assgrpId = new ArrayList<Long>(16);
        for (Row row : ds) {
            String key = row.getLong(assgrpField) != 0L ? row.getString(assgrpField) : MainDesignateEdit.getNonassgrp();
            CashFlowDesignate cf = null;
            if (map.get(key) == null) {
                if (!MainDesignateEdit.getNonassgrp().equals(key)) {
                    assgrpId.add(Long.valueOf(key));
                }
                HashSet<Long> set = new HashSet<Long>(16);
                set.add(row.getLong("id"));
                cf = new CashFlowDesignate();
                map.put(key, cf);
                cf.setAmt(row.getBigDecimal("amt"));
                cf.setName(key);
                cf.setVchIds(set);
                continue;
            }
            cf = (CashFlowDesignate)map.get(key);
            cf.setAmt(cf.getAmt().add(row.getBigDecimal("amt")));
            cf.getVchIds().add(row.getLong("id"));
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_assist", (String)"id,assvals", (QFilter[])new QFilter[]{new QFilter("id", "in", assgrpId)});
        HashMap<String, Set> flexfieldMap = new HashMap<String, Set>(16);
        for (DynamicObject obj : col) {
            JSONObject vauleJson = JSONObject.parseObject((String)obj.getString("assvals"));
            for (Map.Entry entry : vauleJson.entrySet()) {
                Set values = flexfieldMap.computeIfAbsent((String)entry.getKey(), k -> new HashSet(10));
                values.add(entry.getValue());
            }
        }
        QFilter q = new QFilter("flexfield", "in", flexfieldMap.keySet());
        DynamicObjectCollection asstacttypes = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield,number,name,valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{q});
        HashMap<String, Set> asstactVMap = new HashMap<String, Set>(16);
        HashMap<String, String> asstactNMap = new HashMap<String, String>(16);
        HashMap<String, String> relationMap = new HashMap<String, String>(16);
        for (Object asstacttype : asstacttypes) {
            String string = asstacttype.getString("valuetype");
            String flexfield = asstacttype.getString("flexfield");
            String flexName = asstacttype.getString("name");
            String formid = "";
            if (TYPE_ACC.equals(string) || "3".equals(string)) {
                formid = asstacttype.getString("valuesource");
            } else if (TYPE_CF.equals(string)) {
                formid = "bos_assistantdata_detail";
            }
            if (!StringUtils.isBlank((String)formid)) {
                Set list = asstactVMap.computeIfAbsent(formid, k -> new HashSet(10));
                Set values = (Set)flexfieldMap.get(flexfield);
                list.addAll(values);
                for (Object value : values) {
                    relationMap.put(flexfield + "-" + value, formid + "-" + value);
                }
            }
            asstactNMap.put(flexfield, flexName);
        }
        HashMap<String, String> asstactDataNMap = new HashMap<String, String>(16);
        for (Map.Entry entry : asstactVMap.entrySet()) {
            DynamicObjectCollection asstactDatas = QueryServiceHelper.query((String)((String)entry.getKey()), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
            for (DynamicObject data : asstactDatas) {
                asstactDataNMap.put((String)entry.getKey() + "-" + data.getString("id"), data.getString("name"));
            }
        }
        HashMap<String, String> newName = new HashMap<String, String>(col.size());
        for (DynamicObject obj : col) {
            StringBuilder itemsStr = new StringBuilder();
            JSONObject vauleJson = JSONObject.parseObject((String)obj.getString("assvals"));
            for (Map.Entry entry : vauleJson.entrySet()) {
                String flexName = (String)asstactNMap.get(entry.getKey());
                String relation = (String)relationMap.get((String)entry.getKey() + "-" + entry.getValue());
                if (relation == null) {
                    itemsStr.append(flexName).append(':').append(entry.getValue()).append(" \n");
                } else {
                    String asstactDataName = (String)asstactDataNMap.get(relation);
                    itemsStr.append(flexName).append(':').append(asstactDataName).append(" \n");
                }
                newName.put(obj.getString("id"), itemsStr.toString());
            }
        }
        for (Map.Entry c : map.entrySet()) {
            String key = (String)c.getKey();
            CashFlowDesignate value = (CashFlowDesignate)c.getValue();
            if (newName.get(key) != null) {
                value.setName((String)newName.get(key));
                value.setType(assgrptype + "_" + key);
                continue;
            }
            value.setType(assgrptype + "_" + 0);
        }
        return map;
    }

    private Map<String, CashFlowDesignate> buildCFItem(DataSet ds, String prefix) {
        BigDecimal dc = BigDecimal.ONE;
        if (prefix.equals("credit")) {
            dc = dc.negate();
        }
        LinkedHashMap<String, CashFlowDesignate> map = new LinkedHashMap<String, CashFlowDesignate>();
        for (Row row : ds) {
            BigDecimal amt;
            String key;
            Long maincfitemId = row.getLong("maincfitem");
            BigDecimal cfDc = BigDecimal.ONE;
            if (maincfitemId != 0L) {
                DynamicObject cfItem = CashFlowItemHelperNew.getCfItem(this.cfItemMapCache, (Long)maincfitemId);
                if (cfItem == null) {
                    throw new KDBizException("cfItem is null , maincfitemId: " + maincfitemId);
                }
                if ("o".equals(cfItem.getString("direction"))) {
                    cfDc = cfDc.negate();
                }
                String maincfnumber = cfItem.getString("number");
                String maincfname = cfItem.getString("name");
                key = maincfnumber + "_" + maincfname;
            } else {
                key = MainDesignateEdit.getUnhandle();
            }
            BigDecimal dcAmt = amt = row.getBigDecimal("amt");
            if (maincfitemId != 0L) {
                dcAmt = amt.multiply(cfDc).multiply(dc);
            }
            CashFlowDesignate cf = null;
            if (map.get(key) == null) {
                HashSet<Long> set = new HashSet<Long>(16);
                set.add(row.getLong("id"));
                cf = new CashFlowDesignate();
                map.put(key, cf);
                cf.setAmt(amt);
                cf.setDcAmt(dcAmt);
                cf.setName(key);
                cf.setVchIds(set);
                cf.setType(TYPE_CF);
                continue;
            }
            cf = (CashFlowDesignate)map.get(key);
            cf.setAmt(cf.getAmt().add(amt));
            cf.setDcAmt(cf.getDcAmt().add(dcAmt));
            cf.getVchIds().add(row.getLong("id"));
        }
        return map;
    }

    private void showAcct(String entry) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(entry);
        this.showAcct(entry, index);
    }

    private void showAcct(String entry, int index) {
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        String cftype = (String)model.getValue(prefix + CFTYPE, index);
        Map<String, CashFlowDesignate> map = this.buildAcctCFitemData(entry, index);
        if (DebugTrace.enable()) {
            logger.info("[T_preset]buildAcctCFitemData_map.size:{}, map:{}", (Object)map.size(), map);
        }
        this.updateModel(entry, prefix, model, index, map, cftype);
    }

    private Map<String, CashFlowDesignate> buildAcctCFitemData(String entry, int index) {
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        IDataModel model = this.getModel();
        String infoKey = (String)model.getValue(prefix + INFO, index);
        String acct = (String)model.getValue(prefix + ACCT, index);
        Map<String, CashFlowDesignate> map = null;
        String cftype = (String)model.getValue(prefix + CFTYPE, index);
        int level = (Integer)model.getValue(prefix + LEVELRE, index);
        String type = (String)model.getValue(prefix + TYPE, index);
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter qfilter = filterContext.getqFilter();
        Set<Long> cacheVoucherIds = this.getCacheVoucherIds(infoKey);
        QFilter idQFilter = new QFilter("id", "in", cacheVoucherIds);
        idQFilter.and(qfilter);
        logger.info("[T_preset]cacheVoucherIds.size: {}, buildAcctCFitemData_qfilter: {}", (Object)cacheVoucherIds.size(), (Object)this.filterToString(idQFilter));
        String selectFields = "id,mainstatus,entries.id entryid,entries.account account,entries.entrydc entrydc,entries.account.number number,entries.account.name name,entries.account.masterid,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.maincfitem maincfitem,entries.maincfamount maincfamount";
        boolean isCashAccount = TYPE_ACC.equals(cftype.trim());
        DataSet ds = this.getInitDataSet(idQFilter, selectFields, isCashAccount);
        if (TYPE_ACC.equals(cftype.trim())) {
            String amtfield = prefix + "local  desc";
            ds = ds.orderBy(new String[]{"id", amtfield});
            map = this.buildCashAcctMap(ds, prefix);
            if (level > 1 && TYPE_ACC.equals(type)) {
                HashSet<String> leafAccount = new HashSet<String>(8);
                this.getLeafAccount(this.getDataSetByNumber(acct.split("_")[0]), leafAccount, "fid");
                map.entrySet().stream().filter(e -> leafAccount.contains(e));
            }
        } else {
            if (!MainDesignateEdit.getUncash().equals(acct)) {
                if ((acct = acct.trim()).equals(MainDesignateEdit.getUnhandle())) {
                    ds = ds.filter("maincfitem = 0");
                } else if (TYPE_ACC.equals(type)) {
                    int levelre = (Integer)model.getValue(prefix + LEVELRE, index);
                    if (3 == levelre) {
                        int cfItemeIndex = this.getCFItemeIndex(entry, index);
                        String cfIteme = (String)model.getValue(prefix + ACCT, cfItemeIndex);
                        if (cfIteme.equals(MainDesignateEdit.getUnhandle())) {
                            ds = ds.filter("maincfitem = 0");
                        } else {
                            String maincfnumber = cfIteme.split("_")[0];
                            String maincfIdExp = this.createMaincfIdExp(maincfnumber);
                            ds = ds.filter(maincfIdExp);
                        }
                    }
                    HashSet<String> result = new HashSet<String>();
                    this.getLeafAccount(this.getDataSetByNumber(acct.split("_")[0]), result, NUMBER);
                    if (result.size() > 0) {
                        ds = ds.filter("number in ('" + String.join((CharSequence)"','", result) + "')");
                    }
                } else if (TYPE_CF.equals(type)) {
                    String maincfnumber = acct.split("_")[0];
                    String maincfIdExp = this.createMaincfIdExp(maincfnumber);
                    ds = ds.filter(maincfIdExp);
                }
            }
            ds = ds.filter("mainstatus != '3' or maincfitem != 0L");
            ds = prefix.equals("debit") ? ds.addField("case when maincfitem != 0 then maincfamount else creditlocal-debitlocal end", "amt") : ds.addField("case when maincfitem != 0 then maincfamount else debitlocal-creditlocal end", "amt");
            map = this.buildUnCashAcctMap(ds, prefix);
        }
        map = TYPE_CF.equals(type) ? this.computeCashFlowAccount(CFTYPE, map) : this.computeCashFlowAccount(acct, map);
        return map;
    }

    private String createMaincfIdExp(String maincfnumber) {
        Set cfItemIdSet = CashFlowItemHelperNew.getCFItemIdByNumber((String)maincfnumber);
        Set cfItemIds = cfItemIdSet.stream().map(e -> String.valueOf(e)).collect(Collectors.toSet());
        if (DebugTrace.enable()) {
            logger.info("[T_preset]createMaincfIdExp, maincfnumber: {}, cfItemIds: {}", (Object)maincfnumber, cfItemIds);
        }
        if (cfItemIds.size() == 0) {
            throw new KDBizException("cfItemIds is empty, maincfnumber: " + maincfnumber);
        }
        String exp = " maincfitem in ( " + String.join((CharSequence)",", cfItemIds) + " ) ";
        if (DebugTrace.enable()) {
            logger.info("[T_preset]createMaincfIdExp, maincfnumber: {}, exp: {}", (Object)maincfnumber, (Object)exp);
        }
        return exp;
    }

    private Map<String, CashFlowDesignate> computeCashFlowAccount(String acct, Map<String, CashFlowDesignate> map) {
        TreeNode node;
        Long id;
        long computeCashFlowAccountStart = System.currentTimeMillis();
        Map<Object, TreeNode> accIdMap = this.getAccountMap();
        LinkedHashMap<String, CashFlowDesignate> newMap = new LinkedHashMap<String, CashFlowDesignate>();
        String[] s = acct.split("_");
        int level = 0;
        if (s.length == 1) {
            level = 1;
        } else {
            for (Map.Entry<String, CashFlowDesignate> entry : map.entrySet()) {
                id = Long.valueOf(entry.getKey());
                node = accIdMap.get(id);
                TreeNode nodeL = this.getNodeByLevel(node, s[0]);
                if (null == nodeL) continue;
                level = (Integer)nodeL.getPropValue(LEVEL) + 1;
                break;
            }
        }
        if (DebugTrace.enable()) {
            logger.info("[T_preset]print cashFlowDesignate map keySet: " + map.keySet());
        }
        for (Map.Entry<String, CashFlowDesignate> entry : map.entrySet()) {
            id = Long.valueOf(entry.getKey());
            node = accIdMap.get(id);
            if ((node = this.getNodeByLevel(node, level)) == null) {
                logger.info(String.format("getNodeByLevel() return null! node=%s,level=%s", node, level));
                continue;
            }
            CashFlowDesignate value = entry.getValue();
            String name = node.getPropValue("number") + "_" + node.getPropValue("name");
            value.setName(name);
            value.setLevel((Integer)node.getPropValue(LEVEL) + "");
            String idKey = String.valueOf(node.getMasterId());
            newMap.compute(idKey, (k, v) -> {
                if (v == null) {
                    return value;
                }
                Set<Long> entryIds = v.getVchIds();
                entryIds.addAll(value.getVchIds());
                v.setAmt(v.getAmt().add(value.getAmt()));
                return v;
            });
        }
        if (DebugTrace.enable()) {
            logger.info("[T_preset]print cashFlowDesignate newmap keySet: " + newMap.keySet());
        }
        long computeCashFlowAccountEnd = System.currentTimeMillis();
        logger.info("[T_preset]computeCashFlowAccount_cost: {} ms", (Object)(computeCashFlowAccountEnd - computeCashFlowAccountStart));
        return newMap;
    }

    private TreeNode getNodeByLevel(TreeNode node, String acct) {
        String number = (String)node.getPropValue("number");
        if (number.equals(acct)) {
            return node;
        }
        if (null != node.getParent()) {
            return this.getNodeByLevel(node.getParent(), acct);
        }
        return null;
    }

    private TreeNode getNodeByLevel(TreeNode node, int level) {
        if (node == null) {
            return null;
        }
        int nodeLevel = (Integer)node.getPropValue(LEVEL);
        if (nodeLevel == level) {
            return node;
        }
        if (nodeLevel > level) {
            return this.getNodeByLevel(node.getParent(), level);
        }
        return null;
    }

    private TreeNode getParentNode(TreeNode node) {
        if (null != node.getParent()) {
            return this.getParentNode(node.getParent());
        }
        return node;
    }

    private String getTopAcct(Long acctId) {
        Map<Object, TreeNode> accIdMap = this.getAccountMap();
        TreeNode nodeCur = accIdMap.get(acctId);
        TreeNode node = this.getParentNode(nodeCur);
        return (String)node.getPropValue("number");
    }

    private int calculateLevelre(String entry, String prefix, int index, String cftype, String type) {
        IDataModel model = this.getModel();
        int preLevelre = (Integer)model.getValue(prefix + LEVELRE, index);
        if (preLevelre == 1) {
            return 2;
        }
        String cftypeold = (String)model.getValue(prefix + CFTYPE, index);
        String typeold = (String)model.getValue(prefix + TYPE, index);
        if (cftypeold.equals(cftype) && typeold.equals(type)) {
            return preLevelre;
        }
        return preLevelre + 1;
    }

    private void updateModel(String entry, String prefix, IDataModel model, int index, Map<String, CashFlowDesignate> map, String cftype) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entry);
        EntryGrid entryGrid = (EntryGrid)this.getControl(entry);
        int[] selectRows = entryGrid.getSelectRows();
        logger.info("[T_preset]detected_indexOutOfBound: entry: {}, index: {}, entryCurrentRowIndex: {}, selectRows: {}", new Object[]{entry, index, entryCurrentRowIndex, selectRows == null ? "null" : Arrays.stream(selectRows).boxed().collect(Collectors.toList())});
        if (map != null && map.size() > 0) {
            int level = (Integer)model.getValue(prefix + LEVEL, index);
            model.getDataEntity(true);
            int count = (Integer)model.getValue(prefix + COUNT, index);
            count += this.getDisplayCount(model, index, entry, prefix, level);
            Map<Long, Set<Long>> keyToVoucherIds = this.getCache();
            String updatesuperiorcf = this.getPageCache().get("issuperiorcf");
            if (StringUtils.isNotEmpty((String)updatesuperiorcf) && Boolean.parseBoolean(updatesuperiorcf)) {
                this.getPageCache().put("issuperiorcf", Boolean.FALSE.toString());
                keyToVoucherIds.remove(Long.valueOf(model.getValue(prefix + INFO, index).toString()));
                model.deleteEntryRow(entry, index);
                --level;
                --index;
            } else {
                for (int i = count + index; i > index; --i) {
                    Object rowId = model.getValue(prefix + INFO, i);
                    if (rowId == null) {
                        logger.warn("rowId is null, index = {}", (Object)i);
                        continue;
                    }
                    keyToVoucherIds.remove(Long.valueOf(rowId.toString()));
                    model.deleteEntryRow(entry, i);
                }
            }
            model.setValue(prefix + COUNT, (Object)0, index);
            model.setValue(prefix + COUNT, (Object)map.size(), index);
            ++level;
            int lastIndex = index;
            ArrayList<Map.Entry<String, CashFlowDesignate>> list = new ArrayList<Map.Entry<String, CashFlowDesignate>>(map.entrySet());
            list.sort(Comparator.comparing(e -> ((CashFlowDesignate)e.getValue()).getName()));
            long[] infoKey = this.batchGenGlobalIds(list.size());
            int keyIndex = 0;
            for (Map.Entry entry2 : list) {
                CashFlowDesignate cashFlowDesignate = (CashFlowDesignate)entry2.getValue();
                keyToVoucherIds.put(infoKey[keyIndex], cashFlowDesignate.getVchIds());
                ++keyIndex;
            }
            this.putCache(keyToVoucherIds);
            keyIndex = 0;
            int levelre = this.calculateLevelre(entry, prefix, lastIndex, cftype, ((CashFlowDesignate)((Map.Entry)list.get(0)).getValue()).getType());
            for (Map.Entry entry3 : list) {
                CashFlowDesignate c = (CashFlowDesignate)entry3.getValue();
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                rowData.put(AMT, c.getAmt());
                rowData.put(LEVEL, level);
                rowData.put(LEVELRE, levelre);
                rowData.put(ACCT, c.getName());
                rowData.put(ACCTID, entry3.getKey());
                rowData.put(INFO, Long.toString(infoKey[keyIndex]));
                rowData.put(CFTYPE, cftype);
                rowData.put(TYPE, c.getType());
                rowData.put(COUNT, 0);
                this.addNewEntryRow(entry, prefix, ++index, rowData);
                ++keyIndex;
            }
            this.flushLashtoptionColumn(entry, lastIndex);
        }
        model.updateCache();
        EntryGrid eg = (EntryGrid)this.getControl(entry);
        eg.selectRows(index);
    }

    private void flushLashtoptionColumn(String entryKey, int lastIndex) {
        IDataModel model = this.getModel();
        String opCols = entryKey.equals(ENTRY_D) ? "operationcolumnd" : "operationcolumnc";
        String prefix = entryKey.equals(ENTRY_D) ? "debit" : "credit";
        OperationColumn operationColum = (OperationColumn)this.getControl(opCols);
        List operationColItems = operationColum.getOperationColItems();
        DynamicObject obj = model.getEntryRowEntity(entryKey, lastIndex);
        boolean[] ocim = this.makeOperationColItems(obj, prefix);
        HashSet<Map<String, Object>> itemspropSet = new HashSet<Map<String, Object>>(operationColItems.size());
        itemspropSet.add(this.itemsprops(((OperationColItem)operationColItems.get(0)).getOperationKey(), ocim[0]));
        itemspropSet.add(this.itemsprops(((OperationColItem)operationColItems.get(1)).getOperationKey(), ocim[1]));
        itemspropSet.add(this.itemsprops(((OperationColItem)operationColItems.get(2)).getOperationKey(), ocim[2]));
        itemspropSet.add(this.itemsprops(((OperationColItem)operationColItems.get(3)).getOperationKey(), ocim[3]));
        itemspropSet.add(this.itemsprops(((OperationColItem)operationColItems.get(4)).getOperationKey(), ocim[4]));
        itemspropSet.add(this.itemsprops(((OperationColItem)operationColItems.get(5)).getOperationKey(), ocim[5]));
        HashMap<String, Object> columnp = new HashMap<String, Object>();
        columnp.put("k", opCols);
        columnp.put("r", lastIndex);
        columnp.put("v", itemspropSet);
        ArrayList<HashMap<String, Object>> kList = new ArrayList<HashMap<String, Object>>(1);
        kList.add(columnp);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("k", entryKey);
        dataMap.put("fieldstates", kList);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", dataMap);
    }

    private Map<String, Object> itemsprops(String opk, boolean visible) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opk", opk);
        map.put("visible", visible);
        return map;
    }

    private Map<String, CashFlowDesignate> buildCashAcctMap(DataSet ds, String prefix) {
        LinkedHashMap<String, CashFlowDesignate> map = new LinkedHashMap<String, CashFlowDesignate>();
        ArrayList<CashFlowDesignate> list = new ArrayList<CashFlowDesignate>();
        CashFlowDesignate cf = null;
        BigDecimal cdamt = BigDecimal.ZERO;
        long voucherId = 0L;
        String DC = prefix.equals("debit") ? TYPE_ACC : "-1";
        String sumField = prefix.equals("debit") ? "creditlocal" : "debitlocal";
        for (Row row : ds) {
            if (voucherId != 0L && row.getLong("id") != voucherId) {
                if (cdamt.signum() != 0) {
                    this.compute(list, cdamt, map);
                    cdamt = BigDecimal.ZERO;
                }
                list.clear();
            }
            voucherId = row.getLong("id");
            if (!row.getString("entrydc").equals(DC)) {
                String key = String.valueOf(row.getLong(ACCT));
                cf = new CashFlowDesignate();
                cf.setAmt(row.getBigDecimal(sumField));
                cf.setName(key);
                HashSet<Long> ids = new HashSet<Long>(16);
                ids.add(row.getLong("id"));
                cf.setVchIds(ids);
                list.add(cf);
                cf.setType(TYPE_ACC);
                continue;
            }
            cdamt = cdamt.add(row.getBigDecimal(prefix + "local"));
        }
        this.compute(list, cdamt, map);
        return map;
    }

    private void compute(List<CashFlowDesignate> list, BigDecimal dcamt, Map<String, CashFlowDesignate> map) {
        for (CashFlowDesignate c : list) {
            if (dcamt.compareTo(BigDecimal.ZERO) == 0) {
                this.mergeMap(map, c);
                continue;
            }
            if (c.getAmt().compareTo(dcamt) >= 0) {
                c.setAmt(dcamt);
                this.mergeMap(map, c);
                break;
            }
            this.mergeMap(map, c);
            dcamt = dcamt.subtract(c.getAmt());
        }
    }

    private void mergeMap(Map<String, CashFlowDesignate> map, CashFlowDesignate c) {
        if (map.get(c.getName()) == null) {
            map.put(c.getName(), c);
        } else {
            CashFlowDesignate cf = map.get(c.getName());
            cf.getVchIds().addAll(c.getVchIds());
            cf.setAmt(cf.getAmt().add(c.getAmt()));
        }
    }

    private String transfterStr(Set<Long> entryIds, boolean getFirst) {
        if (getFirst) {
            return entryIds.iterator().next().toString();
        }
        StringBuilder s = new StringBuilder();
        for (long id : entryIds) {
            s.append(id).append(',');
        }
        if (s.length() > 1) {
            s.setLength(s.length() - 1);
        }
        return s.toString();
    }

    private Map<String, CashFlowDesignate> buildUnCashAcctMap(DataSet ds, String prefix) {
        LinkedHashMap<String, CashFlowDesignate> map = new LinkedHashMap<String, CashFlowDesignate>();
        for (Row row : ds) {
            BigDecimal realAmt;
            String name = row.getString("number") + "_" + row.getString("name");
            String key = String.valueOf(row.getLong(ACCT));
            CashFlowDesignate cf = null;
            BigDecimal amt = row.getBigDecimal("amt");
            Long maincfitemId = row.getLong("maincfitem");
            if (maincfitemId == 0L) {
                realAmt = amt;
            } else {
                DynamicObject cfItem;
                BigDecimal dc = BigDecimal.ONE;
                if (prefix.equals("credit")) {
                    dc = dc.negate();
                }
                if ((cfItem = CashFlowItemHelperNew.getCfItem(this.cfItemMapCache, (Long)maincfitemId)) == null) {
                    throw new KDBizException("cfItem is null, maincfitemId: " + maincfitemId);
                }
                BigDecimal cfDc = BigDecimal.ONE;
                if ("o".equals(cfItem.getString("direction"))) {
                    cfDc = cfDc.negate();
                }
                realAmt = amt.multiply(cfDc).multiply(dc);
            }
            if (map.get(key) == null) {
                HashSet<Long> set = new HashSet<Long>();
                set.add(row.getLong("id"));
                cf = new CashFlowDesignate();
                map.put(key, cf);
                cf.setAmt(realAmt);
                cf.setName(name);
                cf.setVchIds(set);
                cf.setType(TYPE_ACC);
                continue;
            }
            cf = (CashFlowDesignate)map.get(key);
            cf.setAmt(cf.getAmt().add(realAmt));
            cf.getVchIds().add(row.getLong("id"));
        }
        if (DebugTrace.enable()) {
            logger.info("[T_preset]buildAcctMap map keyset: " + map.keySet());
        }
        return map;
    }

    @Override
    protected void doQuery(FilterContext filterContext) {
        long doqueryStart = System.currentTimeMillis();
        QFilter qFilter = filterContext.getqFilter();
        if (qFilter == null) {
            logger.error("filterContext.getqFilter() return null!");
            return;
        }
        logger.info("[T_preset]doQuery qFilter: {}", (Object)this.filterToString(qFilter));
        String selectFields = "id, mainstatus, entries.debitlocal debitlocal,entries.creditlocal creditlocal";
        DataSet ds = this.getInitDataSet(qFilter, selectFields, true);
        ds = ds.groupBy(new String[]{"id", "mainstatus"}).sum("debitlocal").sum("creditlocal").finish();
        BigDecimal[] cash = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        HashSet<Long> allCashVoucherIds = new HashSet<Long>(16);
        HashSet<Long> notCashDebitVoucherIds = new HashSet<Long>(16);
        HashSet<Long> notCashCreditVoucherIds = new HashSet<Long>(16);
        long time = System.currentTimeMillis();
        int i = 0;
        long groupEnd = 0L;
        boolean exisC2 = false;
        boolean exisC3 = false;
        for (Row row : ds) {
            if (i == 0) {
                groupEnd = System.currentTimeMillis();
                logger.info("[T_preset]dataset group sum cost : {} ms", (Object)(groupEnd - time));
            }
            BigDecimal debit = row.getBigDecimal("debitlocal");
            BigDecimal credit = row.getBigDecimal("creditlocal");
            if (debit.signum() == 0) {
                cash[3] = cash[3].add(credit);
                exisC3 = true;
                notCashCreditVoucherIds.add(row.getLong("id"));
            } else if (credit.signum() == 0) {
                cash[2] = cash[2].add(debit);
                exisC2 = true;
                notCashDebitVoucherIds.add(row.getLong("id"));
            } else if (debit.compareTo(credit) == 0) {
                String mainStatus = row.getString("mainstatus");
                if (mainStatus.equals("0")) {
                    cash[0] = cash[0].add(debit);
                    cash[1] = cash[1].add(credit);
                    allCashVoucherIds.add(row.getLong("id"));
                } else {
                    cash[0] = cash[0].add(credit);
                    cash[1] = cash[1].add(credit);
                    allCashVoucherIds.add(row.getLong("id"));
                    notCashDebitVoucherIds.add(row.getLong("id"));
                }
            } else if (debit.compareTo(credit) > 0) {
                cash[0] = cash[0].add(credit);
                cash[1] = cash[1].add(credit);
                cash[2] = cash[2].add(debit.subtract(credit));
                exisC2 = true;
                allCashVoucherIds.add(row.getLong("id"));
                notCashDebitVoucherIds.add(row.getLong("id"));
            } else {
                cash[0] = cash[0].add(debit);
                cash[1] = cash[1].add(debit);
                cash[3] = cash[3].add(credit.subtract(debit));
                exisC3 = true;
                allCashVoucherIds.add(row.getLong("id"));
                notCashCreditVoucherIds.add(row.getLong("id"));
            }
            ++i;
        }
        long foreachEnd = System.currentTimeMillis();
        logger.info("[T_preset]for each cost : {} ms, count: {}", (Object)(foreachEnd - groupEnd), (Object)i);
        long[] genClobalids = this.batchGenGlobalIds(3);
        Map<Long, Set<Long>> voucherIdCache = this.getCache();
        if (voucherIdCache == null) {
            voucherIdCache = new HashMap<Long, Set<Long>>(3);
        }
        voucherIdCache.clear();
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_D);
        model.deleteEntryData(ENTRY_C);
        if (cash[0].signum() != 0) {
            voucherIdCache.put(genClobalids[0], allCashVoucherIds);
            this.setModelValue(TYPE_ACC, cash[0], Long.toString(genClobalids[0]), ENTRY_D);
        }
        if (exisC2) {
            voucherIdCache.put(genClobalids[1], notCashDebitVoucherIds);
            this.setModelValue(TYPE_CF, cash[2], Long.toString(genClobalids[1]), ENTRY_D);
        }
        if (cash[1].signum() != 0) {
            voucherIdCache.put(genClobalids[0], allCashVoucherIds);
            this.setModelValue(TYPE_ACC, cash[1], Long.toString(genClobalids[0]), ENTRY_C);
        }
        if (exisC3) {
            voucherIdCache.put(genClobalids[2], notCashCreditVoucherIds);
            this.setModelValue(TYPE_CF, cash[3], Long.toString(genClobalids[2]), ENTRY_C);
        }
        this.putCache(voucherIdCache);
        this.getView().updateView(ENTRY_C);
        this.getView().updateView(ENTRY_D);
        long doqueryEnd = System.currentTimeMillis();
        logger.info("[T_preset]doquery_cost: {} ms", (Object)(doqueryEnd - doqueryStart));
    }

    @Override
    protected void doUpdateView() {
        this.getModel().deleteEntryData(ENTRY_D);
        this.getModel().deleteEntryData(ENTRY_C);
    }

    private void setModelValue(String cftype, BigDecimal amt, String infoKey, String entry) {
        IDataModel model = this.getModel();
        model.beginInit();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        int index = model.createNewEntryRow(entry);
        if (TYPE_ACC.equals(cftype)) {
            model.setValue(prefix + ACCT, (Object)MainDesignateEdit.getCash(), index);
        } else if (TYPE_CF.equals(cftype)) {
            model.setValue(prefix + ACCT, (Object)MainDesignateEdit.getUncash(), index);
        }
        model.setValue(prefix + CFTYPE, (Object)cftype, index);
        model.setValue(prefix + AMT, (Object)amt, index);
        model.setValue(prefix + INFO, (Object)infoKey, index);
        model.setValue(prefix + LEVEL, (Object)1, index);
        model.setValue(prefix + LEVELRE, (Object)1, index);
        model.endInit();
    }

    private DataSet getInitDataSet(QFilter qFilter, String selectedFields, boolean isCashAccount) {
        Set<Long> filterAccIds = this.getCashAccIds(isCashAccount);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(qFilter);
        filters.add(new QFilter("entries.account", "in", filterAccIds));
        return VoucherQueryUtils.queryDataSet((String)selectedFields, (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
    }

    private DataSet getInitDataSetV1(QFilter qFilter, String selectFields, String orders) {
        DataSet ds = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])qFilter.toArray(), (String)orders, (int)-1);
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean designateV1In(QFilter qfilter, Long itemId, Long assgrpId, Set<Long> voucherIds, Map<Long, Long> entryidItemIdMap) {
        if (DebugTrace.enable()) {
            logger.info("[T_preset]designateV1In itemId:{} assgrpId:{}, vchIds.size: {}, entryidItemIdMap.size: {}, qfilter: {}", new Object[]{itemId, assgrpId, voucherIds.size(), null == entryidItemIdMap ? "null" : Integer.valueOf(entryidItemIdMap.size()), this.filterToString(qfilter)});
        }
        long designateStart = System.currentTimeMillis();
        if (null == itemId && null == entryidItemIdMap) {
            throw new KDBizException("itemId & entryidItemIdMap is null");
        }
        this.checkParam(qfilter);
        HashSet bookIds = new HashSet(10);
        ArrayList paramList = new ArrayList(voucherIds.size());
        ArrayList vchParams = new ArrayList(voucherIds.size());
        ArrayList entryParams = new ArrayList(voucherIds.size());
        HashSet vchIds = new HashSet(voucherIds.size());
        HashMap dataMap = new HashMap(voucherIds.size());
        HashMap itemMap = new HashMap(voucherIds.size());
        Set<Long> unCashAccIds = this.getCashAccIds(false);
        qfilter.and(new QFilter("entries.account", "in", unCashAccIds));
        qfilter.and(new QFilter("mainstatus", "in", Arrays.asList("3", TYPE_CF, TYPE_ACC)));
        boolean hasAuditVchs = false;
        boolean hasDesignate = false;
        long orgId = this.getFilterValue("org.id");
        long bookTypeId = this.getFilterValue("booktype.id");
        String opertion = "designate";
        Set lockIds = MutexRequireHelper.batchRequire((String)"gl_voucher", voucherIds, (String)opertion);
        if (voucherIds.size() != lockIds.size()) {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u51ed\u8bc1\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainDesignateEdit_31", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        String selectedFields = "id,period,billstatus,entries.id,entries.maincfitem,entries.maincfamount,entries.creditlocal,entries.debitlocal";
        try (DataSet ds = this.getInitDataSetV1(qfilter, selectedFields, "id");){
            if (ds.hasNext()) {
                HashMap<Long, BigDecimal> amtMap = new HashMap<Long, BigDecimal>(16);
                HashMap<Long, Long> itemIDMap = new HashMap<Long, Long>(16);
                long voucherId = 0L;
                for (Row row : ds) {
                    Long entryItemId;
                    if (!GLUtil.isCurrentVoucherAllowModifyCF((long)orgId, (long)bookTypeId, (long)row.getLong("period"), (String)row.getString("billstatus"))) {
                        hasAuditVchs = true;
                        continue;
                    }
                    LogFacts logFacts = this.logFacts;
                    Long l = logFacts.designateEntriesRows;
                    Long l2 = logFacts.designateEntriesRows = logFacts.designateEntriesRows + 1L;
                    if (voucherId != 0L && row.getLong("id") != voucherId) {
                        amtMap = new HashMap(16);
                        itemIDMap = new HashMap(16);
                        if (dataMap.size() > 200) {
                            CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, itemMap, (String)TYPE_ACC, bookIds, paramList, vchParams, entryParams, vchIds, this.cfItemMapCache, (Long)assgrpId);
                            dataMap.clear();
                            itemMap.clear();
                            hasDesignate = true;
                        }
                    }
                    voucherId = row.getLong("id");
                    Long entryId = row.getLong("entries.id");
                    Long itemIdParam = itemId;
                    if (itemIdParam == null && (itemIdParam = entryidItemIdMap.get(entryId)) == null) {
                        throw new KDBizException("itemId is null, entryId: " + entryId);
                    }
                    DynamicObject cfItem = CashFlowItemHelperNew.getCfItem(this.cfItemMapCache, (Long)itemIdParam);
                    if (cfItem == null) {
                        logger.error("[T_preset]item is null, itemId:{} entryId:{}", (Object)itemIdParam, (Object)entryId);
                        continue;
                    }
                    dataMap.put(voucherId, amtMap);
                    itemMap.put(voucherId, itemIDMap);
                    itemIDMap.put(entryId, itemIdParam);
                    BigDecimal dc = BigDecimal.ONE;
                    if ("o".equals(cfItem.getString("direction"))) {
                        dc = dc.negate();
                    }
                    if ((entryItemId = row.getLong("entries.maincfitem")) != 0L) {
                        long cfItem1loadSingleFromCacheStart = System.currentTimeMillis();
                        DynamicObject cfItem1 = CashFlowItemHelperNew.getCfItem(this.cfItemMapCache, (Long)entryItemId);
                        long cfItem1loadSingleFromCacheEnd = System.currentTimeMillis();
                        LogFacts logFacts2 = this.logFacts;
                        Long l3 = logFacts2.cfItem1loadSingleFromCacheTotalTimes;
                        Long l4 = logFacts2.cfItem1loadSingleFromCacheTotalTimes = logFacts2.cfItem1loadSingleFromCacheTotalTimes + 1L;
                        logFacts2 = this.logFacts;
                        logFacts2.cfItem1loadSingleFromCacheTotalCost = logFacts2.cfItem1loadSingleFromCacheTotalCost + (cfItem1loadSingleFromCacheEnd - cfItem1loadSingleFromCacheStart);
                        BigDecimal dc1 = BigDecimal.ONE;
                        if (cfItem1 != null && "o".equals(cfItem1.getString("direction"))) {
                            dc1 = dc1.negate();
                        }
                        amtMap.put(row.getLong("entries.id"), row.getBigDecimal("entries.maincfamount").multiply(dc1).multiply(dc));
                        continue;
                    }
                    amtMap.put(row.getLong("entries.id"), row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")).multiply(dc));
                }
                if (dataMap.size() > 0) {
                    hasDesignate = true;
                    CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, itemMap, (String)TYPE_ACC, bookIds, paramList, vchParams, entryParams, vchIds, this.cfItemMapCache, (Long)assgrpId);
                }
            }
            CashFlowItemHelperNew.saveData(paramList, vchParams, entryParams, vchIds);
        }
        finally {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            if (!bookIds.isEmpty()) {
                kd.fi.gl.util.CashFlowItemHelper.calBal(bookIds);
            }
        }
        if (hasAuditVchs) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"MainDesignateEdit_27", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        long designateEnd = System.currentTimeMillis();
        LogFacts logFacts = this.logFacts;
        logFacts.designateTotalCost = logFacts.designateTotalCost + (designateEnd - designateStart);
        logger.info("[T_preset]designateV1_cost: {} ms, itemId:{} assgrpId:{}, qfilter: {}", new Object[]{designateEnd - designateStart, itemId, assgrpId, this.filterToString(qfilter)});
        return hasDesignate;
    }

    private boolean designateV1(Long cfItem, Long assgrpId, Multimap<Long, Long> vchIdEntriesIdMap) {
        boolean result = false;
        if (vchIdEntriesIdMap.size() >= 999) {
            List<Tuple<Set<Long>, Set<Long>>> batchList = this.transToBatchList(vchIdEntriesIdMap);
            logger.info("[T_preset]designateV1, vchIdEntriesIdMap.size: {}, batchList.size: {} ", (Object)vchIdEntriesIdMap.size(), (Object)batchList.size());
            for (Tuple<Set<Long>, Set<Long>> tuple : batchList) {
                logger.info("[T_preset]designateV1In itemId:{} assgrpId:{}, vchIds.size: {}, veIds.size: {}", new Object[]{cfItem, assgrpId, ((Set)tuple.item1).size(), ((Set)tuple.item2).size()});
                QFilter entryIdFilter = new QFilter("id", "in", tuple.item1).and(new QFilter("entries.id", "in", tuple.item2));
                boolean hasDesignate = this.designateV1In(entryIdFilter, cfItem, assgrpId, (Set)tuple.item1, null);
                if (result) continue;
                result = hasDesignate;
            }
        } else {
            Object designateV1ParamsCache = ThreadCache.get((Object)"designateV1Params");
            DesignateCommonPlugin.DesignateV1Params designateV1Params = null != designateV1ParamsCache ? (DesignateCommonPlugin.DesignateV1Params)designateV1ParamsCache : new DesignateCommonPlugin.DesignateV1Params();
            designateV1Params.add(cfItem, vchIdEntriesIdMap);
            if (designateV1Params.vchIdCount >= 999) {
                result = this.designateV1Pack(designateV1Params);
                ThreadCache.remove((Object)"designateV1Params");
            } else {
                ThreadCache.put((Object)"designateV1Params", (Object)designateV1Params);
            }
        }
        return result;
    }

    private boolean designateV1Pack(DesignateCommonPlugin.DesignateV1Params designateV1Params) {
        boolean result = false;
        List<Tuple<Set<Long>, Set<Long>>> batchList = this.transToBatchList(designateV1Params.vchIdEntriesIdMap);
        logger.info("[T_preset]designateV1Pack, designateV1Params.vchIdEntriesIdMap.size: {}, batchList.size: {} ", (Object)designateV1Params.vchIdEntriesIdMap.size(), (Object)batchList.size());
        for (Tuple<Set<Long>, Set<Long>> tuple : batchList) {
            logger.info("[T_preset]designateV1Pack designateV1Params designateV1Params.entryidItemIdMap.size:{}, vchIds.size: {}, veIds.size: {}", new Object[]{designateV1Params.entryidItemIdMap.size(), ((Set)tuple.item1).size(), ((Set)tuple.item2).size()});
            QFilter entryIdFilter = new QFilter("id", "in", tuple.item1).and(new QFilter("entries.id", "in", tuple.item2));
            boolean hasDesignate = this.designateV1In(entryIdFilter, null, null, (Set)tuple.item1, designateV1Params.entryidItemIdMap);
            if (result) continue;
            result = hasDesignate;
        }
        return result;
    }

    private boolean designateV1Single(QFilter qfilter, long itemId, long assgrpId, Set<Long> vids) {
        boolean result = false;
        this.logFacts.init();
        HashSet<Long> subVids = new HashSet<Long>(999);
        for (Long vid : vids) {
            subVids.add(vid);
            if (subVids.size() < 999) continue;
            QFilter fidQF = new QFilter("id", "in", subVids);
            fidQF.and(qfilter);
            boolean hasDesignate = this.designateV1In(fidQF, itemId, assgrpId, subVids, null);
            if (!result) {
                result = hasDesignate;
            }
            subVids.clear();
        }
        if (subVids.size() > 0) {
            QFilter fidQF = new QFilter("id", "in", subVids);
            fidQF.and(qfilter);
            boolean hasDesignate = this.designateV1In(fidQF, itemId, assgrpId, subVids, null);
            if (!result) {
                result = hasDesignate;
            }
        }
        return result;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String id;
        switch (id = evt.getCallBackId()) {
            case "designate": {
                if (!evt.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.openCashFlowItem();
                break;
            }
            case "preset": {
                if (evt.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.preset(true);
                    break;
                }
                if (!evt.getResult().equals((Object)MessageBoxResult.No)) break;
                this.preset(false);
                break;
            }
            case "cancelcf": {
                String entry;
                boolean isSucc;
                if (!evt.getResult().equals((Object)MessageBoxResult.Yes) || !(isSucc = this.cancelCFItem(entry = this.getPageCache().get("entrykey")))) break;
                this.reload(entry);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"MainDesignateEdit_29", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("openCashFlowItem".equals(closedCallBackEvent.getActionId())) {
            DesignateContext.getOrCreate().setManual(true);
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                ListSelectedRowCollection row = (ListSelectedRowCollection)returnData;
                Long itemId = (Long)row.get(0).getPrimaryKeyValue();
                FilterContext filterContext = this.getFilterContextFromPageCache();
                Set periodIdSet = GLUtil.getPeriodIdSet((Date)filterContext.getStartDate(), (Date)filterContext.getEndDate(), (long)filterContext.getBook().getPeriodTypeId(), (Boolean)true);
                HashMap<Long, List> cashFlowItemByPeriodMap = new HashMap<Long, List>(periodIdSet.size());
                Boolean isSetAssgrp = Boolean.FALSE;
                int maxAssistSize = 0;
                Long maxAssgrpItemId = itemId;
                for (Long period : periodIdSet) {
                    Optional cashFlowItemVO = CashFlowItemHelper.loadSingleForVersion((Long)itemId, (Long)filterContext.getOrgId(), (Long)period, CashFlowItemVO::getLeaf);
                    if (!cashFlowItemVO.isPresent()) continue;
                    CashFlowItemVO cashFlowItem = (CashFlowItemVO)cashFlowItemVO.get();
                    cashFlowItemByPeriodMap.compute(cashFlowItem.getId(), (k, v) -> {
                        if (v == null) {
                            v = new ArrayList<Long>();
                        }
                        v.add(period);
                        return v;
                    });
                    if (cashFlowItem.getAssistEntryVOS().isEmpty()) continue;
                    isSetAssgrp = Boolean.TRUE;
                    if (maxAssistSize != 0 && maxAssistSize >= cashFlowItem.getAssistEntryVOS().size()) continue;
                    maxAssgrpItemId = cashFlowItem.getId();
                    maxAssistSize = cashFlowItem.getAssistEntryVOS().size();
                }
                if (isSetAssgrp.booleanValue()) {
                    FormShowParameter show = new FormShowParameter();
                    show.setFormId("gl_accdesignate_assgrp");
                    show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openassgrpview"));
                    show.setCustomParam("cfid", (Object)maxAssgrpItemId);
                    show.setCustomParam("org", (Object)filterContext.getOrgId().toString());
                    show.setCustomParam("booktype", (Object)filterContext.getBookTypeId().toString());
                    String entry = this.getPageCache().get("entrykey");
                    String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
                    int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entry);
                    show.setCustomParam("voucherid", this.getCacheVoucherIds((String)this.getModel().getValue(prefix + INFO, entryCurrentRowIndex)));
                    String type = (String)this.getModel().getValue(prefix + TYPE, entryCurrentRowIndex);
                    if (!TYPE_ACC.equals(type)) {
                        entryCurrentRowIndex = this.getRightAcctNumIndex(prefix, entryCurrentRowIndex);
                    }
                    if (entryCurrentRowIndex > 1) {
                        show.setCustomParam("acctid", this.getModel().getValue(prefix + ACCTID, entryCurrentRowIndex));
                    }
                    show.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(show);
                    this.getPageCache().put(CFITEM_PERIOD_MAP, SerializationUtils.serializeToBase64(cashFlowItemByPeriodMap));
                    this.getPageCache().put(CFITEMID, String.valueOf(itemId));
                } else {
                    Boolean isSetSucc = Boolean.FALSE;
                    for (Map.Entry entry : cashFlowItemByPeriodMap.entrySet()) {
                        boolean result = this.setCFItemByPeriod((Long)entry.getKey(), 0L, (List)entry.getValue());
                        if (isSetSucc.booleanValue()) continue;
                        isSetSucc = result;
                    }
                    if (isSetSucc.booleanValue()) {
                        this.getPageCache().put("addCFItem", String.valueOf(row.get(0).getPrimaryKeyValue()));
                        this.reload(this.getPageCache().get("entrykey"));
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"MainDesignateEdit_28", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                    }
                }
            }
        } else if ("openassgrpview".equals(closedCallBackEvent.getActionId())) {
            DesignateContext.getOrCreate().setManual(true);
            Object returnData = closedCallBackEvent.getReturnData();
            if (null != returnData) {
                Map cashFlowItemByPeriodMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CFITEM_PERIOD_MAP));
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id, assistentry.asstypeid.flexfield flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", cashFlowItemByPeriodMap.keySet())});
                HashMap itemFlexfilds = new HashMap();
                coll.forEach(e -> itemFlexfilds.compute(e.getLong("id"), (k, v) -> {
                    if (v == null) {
                        v = new HashMap<String, String>();
                    }
                    v.put(e.getString("flexfield"), "");
                    return v;
                }));
                long assgrpId = (Long)returnData;
                DynamicObjectCollection assistBD = QueryServiceHelper.query((String)"gl_assist_bd", (String)"asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "=", (Object)assgrpId)});
                DynamicObjectCollection assistTXT = QueryServiceHelper.query((String)"gl_assist_txt", (String)"asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "=", (Object)assgrpId)});
                Boolean isSetSucc = Boolean.FALSE;
                for (Map.Entry entry : cashFlowItemByPeriodMap.entrySet()) {
                    long itemId = (Long)entry.getKey();
                    Map transInAssists = (Map)itemFlexfilds.get(itemId);
                    for (DynamicObject dyn : assistBD) {
                        transInAssists.computeIfPresent(dyn.getString("asstype"), (k, v) -> dyn.getLong("assval"));
                    }
                    for (DynamicObject dyn : assistTXT) {
                        transInAssists.computeIfPresent(dyn.getString("asstype"), (k, v) -> dyn.getString("assval"));
                    }
                    Iterator it = transInAssists.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry next = it.next();
                        if (!ObjectUtils.isEmpty(next.getValue())) continue;
                        it.remove();
                    }
                    assgrpId = !CollectionUtils.isEmpty((Map)transInAssists) ? FlexUtils.saveFlexData((Map)transInAssists) : 0L;
                    boolean result = this.setCFItemByPeriod(itemId, assgrpId, (List)entry.getValue());
                    if (isSetSucc.booleanValue()) continue;
                    isSetSucc = result;
                }
                if (isSetSucc.booleanValue()) {
                    this.getPageCache().put("addCFItem", this.getPageCache().get(CFITEMID));
                    this.reload(this.getPageCache().get("entrykey"));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"MainDesignateEdit_28", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                }
            }
        }
    }

    private void openCashFlowItem() {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        ListShowParameter bsp = ShowFormHelper.createShowListForm((String)"gl_cashflowitem", (boolean)false);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "openCashFlowItem");
        bsp.setCloseCallBack(callBack);
        QFilter filter1 = new QFilter(TYPE, "=", (Object)TYPE_ACC);
        QFilter filter2 = new QFilter("isleaf", "=", (Object)TYPE_ACC).and(new QFilter("isprefit", "=", (Object)Boolean.FALSE)).and(new QFilter("direction", "!=", (Object)"b"));
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)filterContext.getOrgId());
        QFilter enableFilter = new QFilter("enable", "=", (Object)TYPE_ACC);
        List qFilters = bsp.getListFilterParameter().getQFilters();
        qFilters.add(filter1);
        qFilters.add(filter2);
        qFilters.add(enableFilter);
        qFilters.add(orgFilter);
        qFilters.add(new QFilter("startdate", "<", (Object)filterContext.getEndDate()));
        qFilters.add(new QFilter("enddate", ">=", (Object)filterContext.getEndDate()));
        bsp.setUseOrgId(filterContext.getOrgId().longValue());
        this.getView().showForm((FormShowParameter)bsp);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String prefix;
        String fieldName = evt.getFieldName();
        String string = prefix = fieldName.startsWith("credit") ? "credit" : "debit";
        if (fieldName.endsWith(ACCT)) {
            int index = evt.getRowIndex();
            String type = (String)this.getModel().getValue(prefix + TYPE, index);
            if (TYPE_ACC.equals(type)) {
                String infoKey = (String)this.getModel().getValue(prefix + INFO, index);
                Set<Long> ids = this.getCacheVoucherIds(infoKey);
                QFilter fid = new QFilter("id", "in", ids);
                this.hyperVoucher(fid);
            } else if (TYPE_CF.equals(type)) {
                String itemName = (String)this.getModel().getValue(prefix + ACCT, index);
                itemName = itemName.trim();
                String num = itemName.split("_")[0];
                String infoKey = (String)this.getModel().getValue(prefix + INFO, index);
                Set<Long> ids = this.getCacheVoucherIds(infoKey);
                if (MainDesignateEdit.getUnhandle().equals(itemName)) {
                    this.hyperCashFlowList("", ids, "main");
                } else {
                    this.hyperCashFlowList(num, ids, "main");
                }
            } else {
                logger.info(String.format("\u672a\u77e5\u7684\u8df3\u8f6c\u7c7b\u578b,type=%s", type));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate eo = (FormOperate)args.getSource();
        String key = eo.getOperateKey();
        String entry = key.endsWith("_d") ? ENTRY_D : ENTRY_C;
        this.printEntryInfos(entry, key);
        IDataModel model = this.getModel();
        String prefix = entry.equals(ENTRY_D) ? "debit" : "credit";
        String infoKey = (String)model.getValue(prefix + INFO, model.getEntryCurrentRowIndex(entry));
        Set<Long> voucherIdList = this.getCacheVoucherIds(infoKey);
        switch (key) {
            case "byacct_d": 
            case "byacct_c": {
                this.showAcct(entry);
                break;
            }
            case "bycf_d": 
            case "bycf_c": {
                int curIndex = this.getModel().getEntryCurrentRowIndex(entry);
                this.showCashFlowItem(entry, curIndex);
                break;
            }
            case "byassgrp_d": 
            case "byassgrp_c": {
                this.showAssgrp(entry);
                break;
            }
            case "designatecf_d": 
            case "designatecf_c": {
                FilterContext filterContext = this.getFilterContextFromPageCache();
                AccountBookInfo book = filterContext.getBook();
                if ("0".equals(book.getEnable())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"MainDesignateEdit_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                String checkMsg = this.checkPeriod(book, voucherIdList);
                if (checkMsg != null) {
                    this.getView().showTipNotification(checkMsg, Integer.valueOf(2000));
                    return;
                }
                if (this.checkModifyHisCf(voucherIdList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u5305\u542b\u5df2\u7ed3\u8d26\u671f\u95f4\u51ed\u8bc1\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"MainDesignateEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.getPageCache().put("entrykey", entry);
                this.showConfirmTip("designate", ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u7528\u9009\u62e9\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u66ff\u6362\u5df2\u9009\u884c\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MainDesignateEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u5df2\u5ba1\u6838\u51ed\u8bc1\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u4e0d\u4f1a\u88ab\u66ff\u6362\u3002", (String)"MainDesignateEdit_26", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cancelcf_d": 
            case "cancelcf_c": {
                FilterContext filterContext = this.getFilterContextFromPageCache();
                AccountBookInfo book = filterContext.getBook();
                if ("0".equals(book.getEnable())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"MainDesignateEdit_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.checkModifyHisCf(voucherIdList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"CashFlowDesignatePlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.getPageCache().put("entrykey", entry);
                this.showConfirmTip("cancelcf", ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u53d6\u6d88\u5df2\u9009\u884c\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MainDesignateEdit_30", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u5df2\u5ba1\u6838\u51ed\u8bc1\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u4e0d\u4f1a\u88ab\u66ff\u6362\u3002", (String)"MainDesignateEdit_26", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
            case "fold_d": 
            case "fold_c": {
                this.fold(entry, this.getModel().getEntryCurrentRowIndex(entry));
                this.getView().updateView(entry);
                break;
            }
            case "exportexcel": {
                AccDesignateExportHelper accDesignateExportHelper = new AccDesignateExportHelper(this.getView());
                accDesignateExportHelper.exportEntry(((FormOperate)args.getSource()).getPermissionItemId());
            }
        }
    }

    private Map<Long, DynamicObject> batchLoadVch(Set<Long> vchIds) {
        long batchLoadVchStart = System.currentTimeMillis();
        HashMap<Long, DynamicObject> vchMap = new HashMap<Long, DynamicObject>(vchIds.size());
        DynamicObject[] vchArr = BusinessDataServiceHelper.load((Object[])vchIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_voucher"));
        for (int i = 0; i < vchArr.length; ++i) {
            DynamicObject vch = vchArr[i];
            long id = vch.getLong("id");
            vchMap.put(id, vch);
        }
        long batchLoadVchEnd = System.currentTimeMillis();
        LogFacts logFacts = this.logFacts;
        logFacts.batchLoadTotal = logFacts.batchLoadTotal + (long)vchIds.size();
        logFacts = this.logFacts;
        logFacts.batchLoadTotalCost = logFacts.batchLoadTotalCost + (batchLoadVchEnd - batchLoadVchStart);
        return vchMap;
    }

    private Set<Long> getCashAccIds(boolean isCash) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        AccountBookInfo book = filterContext.getBook();
        HashSet<Long> accountIdSet = new HashSet<Long>(8);
        this.getAcctAllVersion(filterContext, book, isCash, accountIdSet, "T_BD_ACCOUNT_U");
        this.getAcctAllVersion(filterContext, book, isCash, accountIdSet, "T_BD_ACCOUNTUSEREG");
        SqlBuilder shareAccSql = new SqlBuilder();
        if (book.isBudget()) {
            shareAccSql.append("SELECT distinct(c.fid) id FROM T_BD_ACCOUNT AS c INNER JOIN T_bd_accounttype AS ct ON c.faccounttypeid = ct.fid WHERE ct.faccounttype not in ('A','B','C') and ", new Object[0]);
        } else {
            shareAccSql.append("SELECT distinct(c.fid) id FROM T_BD_ACCOUNT AS c WHERE ", new Object[0]);
        }
        this.appendCashCondition(shareAccSql, isCash);
        this.appendPeriodCondition(shareAccSql, filterContext);
        shareAccSql.append(" AND c.fctrlstrategy = '5' ", new Object[0]);
        shareAccSql.append(" AND c.faccounttableid = ? ", new Object[]{book.getAccountTableId()});
        try (DataSet dataSet = DB.queryDataSet((String)MainDesignateEdit.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)shareAccSql);){
            for (Row row : dataSet) {
                accountIdSet.add(row.getLong("id"));
            }
        }
        if (DebugTrace.enable()) {
            logger.info("[T_preset]getCashAccIds, isCash:{}, orgId:{}, PeriodId:{}, PeriodIds:{}, accountIdSet:{}", new Object[]{isCash, book.getOrgId(), filterContext.getPeriodId(), filterContext.getPeriodIds(), accountIdSet});
        }
        return accountIdSet;
    }

    private void getAcctAllVersion(FilterContext filterContext, AccountBookInfo book, boolean isCash, Set<Long> accountIdSet, String table) {
        SqlBuilder commonAccSql = new SqlBuilder();
        if (book.isBudget()) {
            commonAccSql.append("SELECT distinct(u.fdataid) id FROM ", new Object[0]);
            commonAccSql.append(table + " AS u ", new Object[0]);
            commonAccSql.append("INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid INNER JOIN T_bd_accounttype AS ct ON c.faccounttypeid = ct.fid WHERE ct.faccounttype not in ('A','B','C') and ", new Object[0]);
        } else {
            commonAccSql.append("SELECT distinct(u.fdataid) id FROM ", new Object[0]);
            commonAccSql.append(table + " AS u ", new Object[0]);
            commonAccSql.append("INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid WHERE ", new Object[0]);
        }
        this.appendCashCondition(commonAccSql, isCash);
        this.appendPeriodCondition(commonAccSql, filterContext);
        commonAccSql.append(" AND u.fuseorgid = ? ", new Object[]{book.getOrgId()});
        commonAccSql.append(" AND c.faccounttableid = ? ", new Object[]{book.getAccountTableId()});
        try (DataSet dataSet = DB.queryDataSet((String)MainDesignateEdit.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)commonAccSql);){
            for (Row row : dataSet) {
                accountIdSet.add(row.getLong("id"));
            }
        }
    }

    private void appendPeriodCondition(SqlBuilder sqlBuilder, FilterContext filterContext) {
        if (filterContext.getPeriodId() != null) {
            DynamicObject periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)filterContext.getPeriodId()).toArray());
            if (null != periodDO) {
                Date periodEndDate = periodDO.getDate("enddate");
                sqlBuilder.append(" and c.fstartdate <= ? ", new Object[]{periodEndDate});
                sqlBuilder.append(" and c.fenddate > ? ", new Object[]{periodEndDate});
            }
        } else if (filterContext.getPeriodIds() != null) {
            int i = 0;
            for (Long periodId : filterContext.getPeriodIds()) {
                DynamicObject periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
                if (null == periodDO) continue;
                if (++i == 1) {
                    sqlBuilder.append("  and ( ", new Object[0]);
                } else {
                    sqlBuilder.append("  or ", new Object[0]);
                }
                Date periodEndDate = periodDO.getDate("enddate");
                sqlBuilder.append(" ( c.fstartdate <= ? ", new Object[]{periodEndDate});
                sqlBuilder.append(" and c.fenddate > ? ", new Object[]{periodEndDate});
                sqlBuilder.append("  ) ", new Object[0]);
            }
            if (i > 0) {
                sqlBuilder.append("  ) ", new Object[0]);
            }
        }
    }

    private void appendCashCondition(SqlBuilder sqlBuilder, boolean isCash) {
        if (isCash) {
            sqlBuilder.append(" (c.fiscash = '1' or c.fisbank = '1' or c.fiscashequivalent = '1' )", new Object[0]);
        } else {
            sqlBuilder.append(" (c.fiscash != '1' and c.fisbank != '1' and c.fiscashequivalent != '1' )", new Object[0]);
        }
    }

    private String filterToString(QFilter qfilter) {
        QFilter[] qFilters = qfilter.recombine();
        StringBuilder sb = new StringBuilder(16);
        for (QFilter qf : qFilters) {
            String qfs = qf.toString();
            if (qfs.length() > 100) {
                String substring = qfs.substring(0, 100);
                sb.append(substring);
            } else {
                sb.append(qfs);
            }
            sb.append(';');
        }
        return sb.toString();
    }

    private static class LogFacts {
        private Long designateEntriesRows;
        private Long designateTotalCost;
        private Long cfItem1loadSingleFromCacheTotalCost;
        private Long cfItem1loadSingleFromCacheTotalTimes;
        private Long batchLoadTotal;
        private Long batchLoadTotalCost;
        private Long batchLoadCFTotal;
        private Long batchLoadCFTotalCost;

        public LogFacts() {
            this.init();
        }

        public final void init() {
            this.designateEntriesRows = 0L;
            this.designateTotalCost = 0L;
            this.cfItem1loadSingleFromCacheTotalCost = 0L;
            this.cfItem1loadSingleFromCacheTotalTimes = 0L;
            this.batchLoadTotal = 0L;
            this.batchLoadTotalCost = 0L;
            this.batchLoadCFTotal = 0L;
            this.batchLoadCFTotalCost = 0L;
        }

        public String toString() {
            return "LogFacts{designateEntriesRows=" + this.designateEntriesRows + ", designateTotalCost=" + this.designateTotalCost + ", cfItem1loadSingleFromCacheTotalCost=" + this.cfItem1loadSingleFromCacheTotalCost + ", cfItem1loadSingleFromCacheTotalTimes=" + this.cfItem1loadSingleFromCacheTotalTimes + ", batchLoadTotal=" + this.batchLoadTotal + ", batchLoadTotalCost=" + this.batchLoadTotalCost + ", batchLoadCFTotal=" + this.batchLoadCFTotal + ", batchLoadCFTotalCost=" + this.batchLoadCFTotalCost + '}';
        }
    }
}

