/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;

public class MultColSchemeEditPlugin
extends AbstractFormPlugin {
    private static final String MultCol_Type = "type";
    private static final String MultCol_AssgrpType = "fieldname";
    private static final String MultCol_ActLevelType = "leveltype";
    private static final String MultCol_Entity = "entryentity";
    private static final String MultCol_Entity_Act = "accountnum";
    private static final String MultCol_Entity_DC = "dc";
    private static final String MultCol_Entity_Value = "value";
    private static final int MaxColumnSize = 240;
    private boolean bIsDataChanged = true;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object sOrgId = this.getView().getFormShowParameter().getCustomParam("org");
        if (sOrgId != null) {
            Long orgId = Long.valueOf(sOrgId.toString());
            this.getModel().setValue("org", (Object)orgId);
            Object sAcctTblId = this.getView().getFormShowParameter().getCustomParam("accounttable");
            if (sAcctTblId != null) {
                Long acctTblId = Long.valueOf(sAcctTblId.toString());
                BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
                GlFormUtil.setF7ClickFilter(accountTableEdit, new QFilter("id", "=", (Object)acctTblId));
                this.getModel().setValue("accounttable", (Object)acctTblId);
            }
            this.setEntityBookType(orgId, true);
        }
    }

    public void afterBindData(EventObject e) {
        Object oAccount;
        super.afterBindData(e);
        DynamicObject oOrg = (DynamicObject)this.getModel().getValue("org");
        if (oOrg != null) {
            this.setEntityBookType(oOrg.getLong("id"), false);
        }
        this.initCurrency();
        Object oAssgrpType = this.getModel().getValue(MultCol_AssgrpType);
        if (oAssgrpType != null) {
            this.bindAssgrpProp((DynamicObject)oAssgrpType, false);
        }
        if ((oAccount = this.getModel().getValue("account")) != null) {
            this.bindAccountInfo((DynamicObject)oAccount, false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> filters = param.getListFilterParameter().getQFilters();
            if (filters == null) {
                filters = new ArrayList<QFilter>(1);
                param.getListFilterParameter().setQFilters(filters);
            }
            List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
            filters.add(new QFilter("id", "in", (Object)pkSet));
        });
        BasedataEdit accountEdit = (BasedataEdit)this.getView().getControl("account");
        accountEdit.addBeforeF7SelectListener(evt -> {
            String multColType;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> filters = param.getListFilterParameter().getQFilters();
            if (filters == null) {
                filters = new ArrayList<QFilter>(1);
                param.getListFilterParameter().setQFilters(filters);
            }
            if ("1".equals(multColType = this.getMultColType())) {
                filters.add(new QFilter("id", "in", this.queryFlexAccount()));
            }
            QFilter actfilter = new QFilter("isleaf", "=", (Object)"1").and(new QFilter("isassist", "=", (Object)"1"));
            actfilter = actfilter.or(new QFilter("isleaf", "=", (Object)"0"));
            filters.add(actfilter);
            DynamicObject oAcctTable = (DynamicObject)this.getModel().getValue("accounttable");
            if (oAcctTable != null) {
                filters.add(new QFilter("accounttable", "=", (Object)oAcctTable.getLong("id")));
            }
            filters.add(new QFilter("enddate", ">=", (Object)GLUtil.getEndDate()));
        });
        BasedataEdit entryAccountEdit = (BasedataEdit)this.getView().getControl(MultCol_Entity_Act);
        entryAccountEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> filters = param.getListFilterParameter().getQFilters();
            if (filters == null) {
                filters = new ArrayList<QFilter>(1);
                param.getListFilterParameter().setQFilters(filters);
            }
            ArrayList<Long> ffList = new ArrayList<Long>();
            DynamicObjectCollection dync = this.getModel().getEntryEntity(MultCol_Entity);
            for (DynamicObject dyn : dync) {
                DynamicObject fieldname = dyn.getDynamicObject(MultCol_Entity_Act);
                if (fieldname == null) continue;
                Long id = fieldname.getLong("id");
                ffList.add(id);
            }
            String actLevelType = (String)this.getModel().getValue(MultCol_ActLevelType);
            HashMap<Integer, Set<Long>> levelAndIdMap = new HashMap<Integer, Set<Long>>();
            DynamicObject account = (DynamicObject)this.getModel().getValue("account");
            if (account == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e0a\u7ea7\u79d1\u76ee\u3002", (String)"MultColSchemeEditPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long orgId = (Long)this.getModel().getValue("org_id");
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
            QFilter endDateF = new QFilter("enddate", "=", (Object)GLUtil.getEndDate());
            this.getAllChildAccount(account.getString("longnumber"), levelAndIdMap, orgFilter, endDateF);
            HashSet ids = new HashSet();
            for (Set tmpIds : levelAndIdMap.values()) {
                ids.addAll(tmpIds);
            }
            filters.add(new QFilter("id", "in", ids));
            if ("0".equals(actLevelType)) {
                filters.add(new QFilter("isleaf", "=", (Object)"1"));
            } else {
                String level = (String)this.getModel().getValue("accountlevel");
                filters.add(new QFilter("level", "<=", (Object)Long.parseLong(level)));
            }
            DynamicObject oAcctTable = (DynamicObject)this.getModel().getValue("accounttable");
            if (oAcctTable != null) {
                filters.add(new QFilter("accounttable", "=", (Object)oAcctTable.getLong("id")));
            }
            filters.add(new QFilter("id", "not in", ffList));
        });
        BasedataEdit flexFieldEdit = (BasedataEdit)this.getView().getControl(MultCol_AssgrpType);
        flexFieldEdit.addBeforeF7SelectListener(evt -> {
            Long accountId;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> filters = param.getListFilterParameter().getQFilters();
            if (filters == null) {
                filters = new ArrayList<QFilter>(1);
                param.getListFilterParameter().setQFilters(filters);
            }
            if ((accountId = (Long)this.getModel().getValue("account_id")) != 0L) {
                filters.add(new QFilter("id", "in", this.queryFlexField(accountId)));
            } else {
                filters.add(new QFilter("id", "=", (Object)0));
            }
        });
        BasedataEdit value = (BasedataEdit)this.getControl(MultCol_Entity_Value);
        value.addBeforeF7SelectListener(evt -> {
            DynamicObject assisType = (DynamicObject)this.getModel().getValue(MultCol_AssgrpType);
            if (assisType == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"MultColSchemeEditPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            BasedataProp prop = (BasedataProp)value.getProperty();
            DynamicObject valueSource = null;
            String entityId = null;
            String valuetype = assisType.getString("valuetype");
            if ("1".equals(valuetype)) {
                valueSource = assisType.getDynamicObject("valuesource");
                entityId = valueSource.getString("id");
            } else if ("2".equals(valuetype)) {
                valueSource = assisType.getDynamicObject("assistanttype");
                entityId = "bos_assistantdata_detail";
            }
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            if (valueSource != null) {
                prop.setBaseEntityId(entityId);
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
                param.setBillFormId(entityId);
            }
            ArrayList<Long> ffList = new ArrayList<Long>();
            DynamicObjectCollection dync = this.getModel().getEntryEntity(MultCol_Entity);
            for (DynamicObject dyn : dync) {
                DynamicObject fieldname = dyn.getDynamicObject(MultCol_Entity_Value);
                if (fieldname == null) continue;
                Long id = fieldname.getLong("id");
                ffList.add(id);
            }
            String levelType = (String)this.getModel().getValue(MultCol_ActLevelType);
            String entityName = assisType.getString("valuesource.number");
            boolean hasParent = this.hasParent(entityName);
            if ("1".equals(levelType)) {
                Object oLevel = this.getModel().getValue("accountlevel");
                if (oLevel == null || StringUtils.isEmpty((String)oLevel.toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7ea7\u6b21\u4e3a\u7a7a\u3002", (String)"MultColSchemeEditPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (hasParent) {
                    filters.add(new QFilter("level", "=", (Object)Integer.parseInt(oLevel.toString())));
                }
            } else if (hasParent) {
                filters.add(new QFilter("isleaf", "=", (Object)"1"));
            }
            filters.add(new QFilter("id", "not in", ffList));
            if (AssistValueType.isAssistData((String)valuetype)) {
                String flexField = assisType.getString("flexfield");
                FlexProperty flexProperty = FlexUtils.getFlexProperty((String)flexField);
                long assistantTypeId = Long.parseLong(flexProperty.getAssistantType());
                filters.add(new QFilter("group", "=", (Object)assistantTypeId));
                List<Long> orgs = Collections.singletonList((Long)this.getModel().getValue("org_id"));
                QFilter orgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistantTypeId, orgs);
                if (orgFilter != null) {
                    filters.add(orgFilter);
                }
                param.setUseOrgIds(orgs);
            }
        });
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "autoarrange": {
                this.autoArrange(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        switch (propertyName) {
            case "org": {
                Long orgId = ((DynamicObject)value).getLong("id");
                this.setEntityBookType(orgId, true);
                break;
            }
            case "booktype": {
                Long bookTypeId = ((DynamicObject)value).getLong("id");
                Long curOrgId = (Long)this.getModel().getValue("org_id");
                if (curOrgId == null || curOrgId.equals(0L)) {
                    return;
                }
                this.setBook(curOrgId, bookTypeId);
                break;
            }
            case "account": {
                this.bindAccountInfo((DynamicObject)value, true);
                break;
            }
            case "type": {
                this.updateMultColTypeInfo(value);
                break;
            }
            case "fieldname": {
                DynamicObject assgrp = (DynamicObject)value;
                this.bindAssgrpProp(assgrp, true);
                break;
            }
            case "accountlevel": 
            case "leveltype": {
                if (!this.bIsDataChanged) break;
                this.getModel().deleteEntryData(MultCol_Entity);
                break;
            }
            case "accountnum": {
                int actIdx = e.getChangeSet()[0].getRowIndex();
                DynamicObject entityAct = (DynamicObject)this.getModel().getValue(MultCol_Entity_Act);
                if (entityAct == null) break;
                String actDC = "1".equals(entityAct.getString(MultCol_Entity_DC)) ? "1" : "0";
                this.getModel().setValue(MultCol_Entity_DC, (Object)actDC, actIdx);
                break;
            }
            case "value": {
                int valIdx = e.getChangeSet()[0].getRowIndex();
                DynamicObject acct = (DynamicObject)this.getModel().getValue("account");
                if (acct == null) break;
                String actDC = "1".equals(acct.getString(MultCol_Entity_DC)) ? "1" : "0";
                this.getModel().setValue(MultCol_Entity_DC, (Object)actDC, valIdx);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            String operateKey;
            FormOperate formOp = (FormOperate)args.getSource();
            block3 : switch (operateKey = formOp.getOperateKey()) {
                case "save": {
                    int size;
                    String accountLevel = (String)this.getModel().getValue("accountlevel");
                    if (StringUtils.isEmpty((String)accountLevel)) {
                        this.bIsDataChanged = false;
                        this.getModel().setValue("accountlevel", (Object)"0");
                        this.bIsDataChanged = true;
                    }
                    if ((size = this.getModel().getEntryRowCount(MultCol_Entity)) <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u680f\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MultColSchemeEditPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (size > 240) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u680f\u76ee\u5141\u8bb8\u4e0a\u9650\u4e3a%s\u884c\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MultColSchemeEditPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), 240));
                        args.setCancel(true);
                        return;
                    }
                    String field = "0".equals(this.getModel().getValue(MultCol_Type)) ? MultCol_Entity_Act : MultCol_Entity_Value;
                    DynamicObjectCollection col = this.getModel().getEntryEntity(MultCol_Entity);
                    int i = 1;
                    for (DynamicObject obj : col) {
                        if (Objects.isNull(obj.getDynamicObject(field))) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u680f\u76ee\u7684\u7f16\u7801\u3002", (String)"MultColSchemeEditPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), i));
                            args.setCancel(true);
                            break block3;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    private String getMultColType() {
        return (String)this.getModel().getValue(MultCol_Type);
    }

    private void updateMultColTypeInfo(Object value) {
        DynamicObject account = (DynamicObject)this.getModel().getValue("account");
        this.bindAccountInfo(account, true);
    }

    /*
     * Unable to fully structure code
     */
    private void bindAssgrpProp(DynamicObject assisType, boolean isInitial) {
        if (isInitial) {
            this.getModel().deleteEntryData("entryentity");
        }
        if (assisType == null) {
            return;
        }
        type = this.getMultColType();
        if (!"1".equals(type)) {
            return;
        }
        entityName = assisType.getString("valuesource.number");
        hasParent = this.hasParent(entityName);
        if (hasParent) {
            if (isInitial) {
                this.getModel().setValue("leveltype", (Object)"1");
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"leveltype"});
            dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)"max(level) level", null, null);
            var7_8 = null;
            try {
                if (!dSet.hasNext()) ** GOTO lbl37
                maxLevel = dSet.next().getInteger("level");
                this.bindAcctLevel(1, maxLevel, isInitial);
            }
            catch (Throwable maxLevel) {
                var7_8 = maxLevel;
                throw maxLevel;
            }
            finally {
                if (dSet != null) {
                    if (var7_8 != null) {
                        try {
                            dSet.close();
                        }
                        catch (Throwable maxLevel) {
                            var7_8.addSuppressed(maxLevel);
                        }
                    } else {
                        dSet.close();
                    }
                }
            }
        } else {
            this.getModel().setValue("leveltype", (Object)"0");
            this.getView().setEnable(Boolean.FALSE, new String[]{"leveltype"});
        }
lbl37:
        // 3 sources

        this.bindFlexFieldProp(assisType);
        if (!isInitial) {
            size = this.getModel().getEntryRowCount("entryentity");
            this.getModel().beginInit();
            for (i = 0; i < size; ++i) {
                id = (Long)this.getModel().getValue("value_id", i);
                this.getModel().setValue("value", (Object)id, i);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void bindFlexFieldProp(DynamicObject assisType) {
        EntryProp entry = (EntryProp)this.getModel().getDataEntityType().getProperty(MultCol_Entity);
        BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(MultCol_Entity_Value);
        DynamicObject valueSource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("valuesource");
            entityId = valueSource.getString("id");
        } else if ("2".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("assistanttype");
            entityId = "bos_assistantdata_detail";
        }
        if (valueSource != null) {
            prop.setBaseEntityId(entityId);
            prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
        }
    }

    private Set<Long> autoArrange(boolean isReWrite) {
        IDataModel model = this.getModel();
        String type = (String)model.getValue(MultCol_Type);
        if ("0".equals(type)) {
            return this.autoArrangeByAccount(isReWrite);
        }
        return this.autoArrangeByAssgrp(isReWrite);
    }

    private Set<Long> autoArrangeByAssgrp(boolean isReWrite) {
        HashSet<Long> resultSet = null;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Object oAssgrpType = this.getModel().getValue(MultCol_AssgrpType);
        HashSet<Long> ids = new HashSet<Long>();
        if (oAssgrpType != null) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject assisType = (DynamicObject)oAssgrpType;
            this.bindFlexFieldProp(assisType);
            String entityName = assisType.getString("valuesource.number");
            String levelType = (String)model.getValue(MultCol_ActLevelType);
            if ("1".equals(levelType)) {
                Object oLevel = model.getValue("accountlevel");
                if (oLevel == null || StringUtils.isEmpty((String)oLevel.toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7ea7\u6b21\u4e3a\u7a7a\u3002", (String)"MultColSchemeEditPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return resultSet;
                }
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
                DynamicProperty isleaf = mainEntityType.getProperty("isleaf");
                if (isleaf != null && !StringUtils.isBlank((String)isleaf.getAlias())) {
                    filters.add(new QFilter("level", "=", (Object)Integer.parseInt((String)oLevel)));
                }
            } else {
                boolean hasParent = this.hasParent(entityName);
                if (hasParent) {
                    filters.add(new QFilter("isleaf", "=", (Object)"1"));
                }
            }
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            DynamicProperty status = mainEntityType.getProperty("status");
            DynamicProperty enable = mainEntityType.getProperty("enable");
            if (status != null && !StringUtils.isBlank((String)status.getAlias())) {
                filters.add(new QFilter("status", "=", (Object)"C"));
            }
            if (enable != null && !StringUtils.isBlank((String)enable.getAlias())) {
                filters.add(new QFilter("enable", "=", (Object)"1"));
            }
            Long orgId = (Long)this.getModel().getValue("org_id");
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)orgId);
            filters.add(orgFilter);
            String valuetype = assisType.getString("valuetype");
            if ("2".equals(valuetype)) {
                DynamicObject valueSource = assisType.getDynamicObject("assistanttype");
                String number = valueSource.getString("number");
                filters.add(new QFilter("group.number", "=", (Object)number));
            }
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(MultCol_Entity_Value, new Object[0]);
            vs.addField(MultCol_Entity_DC, new Object[0]);
            DynamicObject account = (DynamicObject)this.getModel().getValue("account");
            String defaultDC = "1";
            if (account != null) {
                defaultDC = "1".equals(account.getString(MultCol_Entity_DC)) ? "1" : "0";
            }
            try (DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)"id", (QFilter[])filters.toArray(new QFilter[0]), null);){
                int i = 0;
                for (Row row : dSet) {
                    Long id = row.getLong("id");
                    vs.addRow(new Object[]{id, defaultDC});
                    ids.add(id);
                    if (!isReWrite || ++i < 240) continue;
                    break;
                }
            }
            if (isReWrite) {
                if (vs.getCount() > 0) {
                    model.beginInit();
                    model.deleteEntryData(MultCol_Entity);
                    model.batchCreateNewEntryRow(MultCol_Entity, vs);
                    model.endInit();
                    this.getView().updateView(MultCol_Entity);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\u3002", (String)"MultColSchemeEditPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
            }
        }
        resultSet = ids;
        return resultSet;
    }

    private boolean hasParent(String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty parent = mainEntityType.getProperty("parent");
        DynamicProperty isleaf = mainEntityType.getProperty("isleaf");
        DynamicProperty level = mainEntityType.getProperty("level");
        return parent != null && !StringUtils.isBlank((String)parent.getAlias()) && isleaf != null && !StringUtils.isBlank((String)isleaf.getAlias()) && level != null && !StringUtils.isBlank((String)level.getAlias());
    }

    private Set<Long> autoArrangeByAccount(boolean isReWrite) {
        Set resultSet = null;
        IDataModel model = this.getModel();
        String actLevelType = (String)model.getValue(MultCol_ActLevelType);
        DynamicObject account = (DynamicObject)model.getValue("account");
        if (account == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79d1\u76ee\u3002", (String)"MultColSchemeEditPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return resultSet;
        }
        Set ids = null;
        Long orgId = (Long)this.getModel().getValue("org_id");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        String longNumber = account.getString("longnumber");
        QFilter endDateF = new QFilter("enddate", "=", (Object)GLUtil.getEndDate());
        if ("0".equals(actLevelType)) {
            ids = this.getAllLeafAccount(longNumber, orgFilter, endDateF);
        } else {
            Object oLevel = model.getValue("accountlevel");
            if (oLevel == null || StringUtils.isEmpty((String)oLevel.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7ea7\u6b21\u4e3a\u7a7a\u3002", (String)"MultColSchemeEditPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return resultSet;
            }
            HashMap<Integer, Set<Long>> levelAndIdMap = new HashMap<Integer, Set<Long>>();
            this.getAllChildAccount(longNumber, levelAndIdMap, orgFilter, endDateF);
            ids = (Set)levelAndIdMap.get(Integer.valueOf(oLevel.toString()));
        }
        resultSet = ids;
        if (isReWrite) {
            if (ids != null && ids.size() > 0) {
                model.deleteEntryData(MultCol_Entity);
                model.beginInit();
                int[] idxs = model.batchCreateNewEntryRow(MultCol_Entity, ids.size());
                int i = 0;
                HashMap<Long, String> idAndDCMap = new HashMap<Long, String>();
                try (DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id, dc", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, null);){
                    for (Row row : dSet) {
                        idAndDCMap.put(row.getLong("id"), row.getString(MultCol_Entity_DC));
                    }
                }
                for (Long id : ids) {
                    model.setValue(MultCol_Entity_Act, (Object)id, idxs[i]);
                    String accountDC = (String)idAndDCMap.get(id);
                    if (!StringUtils.isEmpty((String)accountDC)) {
                        String dc = accountDC.equals("1") ? "1" : "0";
                        model.setValue(MultCol_Entity_DC, (Object)dc, idxs[i]);
                    }
                    if (++i < 240) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u7f16\u6392\u52a0\u8f7d\u524d%s\u884c\uff0c\u8fbe\u5230\u62a5\u8868\u5141\u8bb8\u4e0a\u9650\u3002", (String)"MultColSchemeEditPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), 240));
                    break;
                }
                model.endInit();
                this.getView().updateView(MultCol_Entity);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5f53\u524d\u7ea7\u6b21\u4e0b\u7684\u79d1\u76ee\u4e0b\u7ea7\u3002", (String)"MultColSchemeEditPlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        }
        return resultSet;
    }

    private void setEntityBookType(Long orgId, boolean isInitial) {
        Long bookTypeId;
        Object oBookTypeId;
        Long defaultBookType = null;
        LinkedHashSet<Long> bookTypes = new LinkedHashSet<Long>();
        QFilter orgFiler = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{orgFiler});
        for (DynamicObject bt : btCol) {
            bookTypes.add(bt.getLong("id"));
            if (defaultBookType != null || !"1".equals(bt.getString(MultCol_Type))) continue;
            defaultBookType = bt.getLong("id");
        }
        if (isInitial && (oBookTypeId = this.getView().getFormShowParameter().getCustomParam("booktype")) != null && bookTypes.contains(bookTypeId = Long.valueOf(oBookTypeId.toString()))) {
            defaultBookType = bookTypeId;
        }
        if (defaultBookType == null && bookTypes.size() > 0) {
            defaultBookType = (Long)bookTypes.iterator().next();
        }
        if (defaultBookType == null) {
            return;
        }
        this.setBT(orgId, bookTypes, defaultBookType, isInitial);
    }

    private void setBT(Long orgId, Collection<Long> bookTypes, long defaultBookType, boolean isInitial) {
        BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl("booktype");
        GlFormUtil.setF7ClickFilter(bookTypeEdit, new QFilter("id", "in", bookTypes));
        this.getView().setVisible(Boolean.valueOf(bookTypes.size() > 1), new String[]{"booktype"});
        if (isInitial) {
            this.getModel().setValue("booktype", (Object)defaultBookType);
            this.setBook(orgId, defaultBookType);
        }
    }

    private void setBook(Long orgId, Long bookTypeId) {
        IDataModel model = this.getModel();
        HashSet<Long> childOrgSet = new HashSet<Long>();
        childOrgSet.add(orgId);
        List bookInfoList = AccSysUtil.getBookFromAccSys(childOrgSet, (long)bookTypeId);
        long defaultBaseCur = 0L;
        for (int i = 0; i < bookInfoList.size(); ++i) {
            AccountBookInfo book = (AccountBookInfo)bookInfoList.get(i);
            long baseCurrencyId = book.getBaseCurrencyId();
            if (i != 0) continue;
            defaultBaseCur = baseCurrencyId;
        }
        model.setValue("account", null);
        model.setValue("currency", (Object)defaultBaseCur);
    }

    private void bindAccountInfo(DynamicObject account, boolean isInitial) {
        if (account == null) {
            return;
        }
        String multColType = this.getMultColType();
        if ("0".equals(multColType)) {
            int maxLevel;
            HashMap<Integer, Set<Long>> levelAndIdMap = new HashMap<Integer, Set<Long>>();
            Long orgId = (Long)this.getModel().getValue("org_id");
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
            QFilter endDateF = new QFilter("enddate", "=", (Object)GLUtil.getEndDate());
            this.getAllChildAccount(account.getString("longnumber"), levelAndIdMap, orgFilter, endDateF);
            int minLevel = maxLevel = account.getInt("level");
            for (Integer level : levelAndIdMap.keySet()) {
                if (level.compareTo(maxLevel) <= 0) continue;
                maxLevel = level;
            }
            this.bindAcctLevel(minLevel, maxLevel, isInitial);
            this.getView().setEnable(Boolean.TRUE, new String[]{MultCol_ActLevelType});
        }
        boolean isAssist = account.getBoolean("isassist");
        boolean isLeaf = account.getBoolean("isleaf");
        if (isAssist) {
            if (isLeaf) {
                this.getView().setEnable(Boolean.FALSE, new String[]{MultCol_Type});
                this.getModel().setValue(MultCol_Type, (Object)"1");
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{MultCol_Type});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{MultCol_Type});
            this.getModel().setValue(MultCol_Type, (Object)"0");
        }
        if (isInitial) {
            Long accountId;
            List<Long> flexIds;
            ILocaleString name;
            if (StringUtils.isEmpty((String)this.getModel().getValue("number").toString())) {
                this.getModel().setValue("number", account.get("number"));
            }
            if ((name = (ILocaleString)this.getModel().getValue("name")) == null || StringUtils.isEmpty((String)name.getLocaleValue())) {
                this.getModel().setValue("name", account.get("name"));
            }
            if ((flexIds = this.queryFlexField(accountId = Long.valueOf(account.getLong("id")))).size() > 0) {
                this.getModel().setValue(MultCol_AssgrpType, (Object)flexIds.get(0));
                this.bindAssgrpProp((DynamicObject)this.getModel().getValue(MultCol_AssgrpType), true);
            } else {
                this.getModel().setValue(MultCol_AssgrpType, null);
            }
            this.getModel().deleteEntryData(MultCol_Entity);
        }
    }

    private void bindAcctLevel(int minLevel, int maxLevel, boolean isInitial) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(maxLevel - minLevel);
        for (int i = minLevel + 1; i <= maxLevel; ++i) {
            ComboItem item = new ComboItem();
            String viewStr = String.valueOf(i);
            item.setCaption(new LocaleString(viewStr));
            item.setValue(viewStr);
            list.add(item);
        }
        ComboEdit levelEdit = (ComboEdit)this.getControl("accountlevel");
        levelEdit.setComboItems(list);
        levelEdit.setMustInput(true);
        if (isInitial) {
            if (list.size() > 0) {
                this.getModel().setValue("accountlevel", (Object)((ComboItem)list.get(0)).getValue());
            } else {
                this.getModel().setValue("accountlevel", (Object)"0");
            }
        }
    }

    protected List<Long> queryFlexField(Long accountId) {
        QFilter accFilter = new QFilter("id", "=", (Object)accountId);
        String[] types = new String[]{"1", "2"};
        QFilter typeFilter = new QFilter("checkitementry.asstactitem.valuetype", "in", (Object)types);
        ArrayList<Long> result = new ArrayList<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".queryFlexField"), (String)"bd_accountview", (String)"checkitementry.asstactitem assist", (QFilter[])new QFilter[]{accFilter, typeFilter}, null);){
            for (Row row : dSet) {
                result.add(row.getLong("assist"));
            }
        }
        return result;
    }

    private Set<Long> queryFlexAccount() {
        HashSet<Long> result = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".queryFlexAccount"), (String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{new QFilter("isassist", "=", (Object)"1")}, null);){
            for (Row row : dSet) {
                result.add(row.getLong("id"));
            }
        }
        return result;
    }

    private void getAllChildAccount(String longNumber, Map<Integer, Set<Long>> levelAndIdMap, QFilter orgFilter, QFilter endDateF) {
        Long accountTableId = (Long)this.getModel().getValue("accounttable_id");
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getAllLeafAccount"), (String)"bd_accountview", (String)"id,level", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(longNumber + "%")), new QFilter("accounttable", "=", (Object)accountTableId), orgFilter, endDateF}, null);){
            for (Row row : dSet) {
                Long id = row.getLong("id");
                Integer level = row.getInteger("level");
                Set<Long> ids = levelAndIdMap.get(level);
                if (ids == null) {
                    ids = new HashSet<Long>();
                    levelAndIdMap.put(level, ids);
                }
                ids.add(id);
            }
        }
    }

    private Set<Long> getAllLeafAccount(String longNumber, QFilter orgFilter, QFilter endDateF) {
        Long accountTableId = (Long)this.getModel().getValue("accounttable_id");
        HashSet<Long> actIds = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getAllLeafAccount"), (String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(longNumber + "%")), new QFilter("accounttable", "=", (Object)accountTableId), new QFilter("isleaf", "=", (Object)"1"), orgFilter, endDateF}, null);){
            for (Row row : dSet) {
                Long id = row.getLong("id");
                actIds.add(id);
            }
        }
        return actIds;
    }

    private void initCurrency() {
        ComboEdit currency = (ComboEdit)this.getControl("currency");
        currency.setComboItems(this.getCurrencyItems());
    }

    private List<ComboItem> getCurrencyItems() {
        ArrayList<ComboItem> currColl = new ArrayList<ComboItem>();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_currency", (String)"id, name", null);
        for (DynamicObject obj : coll) {
            ComboItem item = new ComboItem();
            item.setValue(obj.getString("id"));
            item.setCaption(new LocaleString(obj.getString("name")));
            currColl.add(item);
        }
        ComboItem baseCur = new ComboItem();
        baseCur.setValue("0");
        baseCur.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7efc\u5408\u672c\u4f4d\u5e01", (String)"MultColSchemeEditPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        currColl.add(baseCur);
        return currColl;
    }
}

