/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class MultColSchemeListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"delete", "new"});
        this.addItemClickListeners(new String[]{"btnreturndata"});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        e.setCancel(true);
        long pkid = (Long)((IListView)this.getView()).getFocusRowPkId();
        this.showEditView(pkid);
    }

    public void click(EventObject evt) {
        super.click(evt);
        evt.getSource();
        if (evt.getSource() instanceof Label) {
            Label lable = (Label)evt.getSource();
            switch (lable.getKey()) {
                case "new": {
                    this.newData();
                    break;
                }
                case "delete": {
                    this.delData();
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btnreturndata": {
                this.returnData();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        switch (evt.getActionId()) {
            case "newCallBack": {
                IListView listView = (IListView)this.getView();
                listView.refresh();
                break;
            }
        }
    }

    private void showEditView(long id) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("gl_multcol_scheme");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setPkId((Object)id);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newCallBack"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void returnData() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection collection = listView.getSelectedRows();
        if (!collection.isEmpty()) {
            this.getView().returnDataToParent((Object)collection);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"AbstractListView_2", (String)"bos-form-mvc", (Object[])new Object[0]));
        }
    }

    private void newData() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gl_multcol_scheme");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("org", this.getView().getFormShowParameter().getCustomParam("org"));
        parameter.setCustomParam("booktype", this.getView().getFormShowParameter().getCustomParam("booktype"));
        parameter.setCustomParam("accounttable", this.getView().getFormShowParameter().getCustomParam("accounttable"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newCallBack"));
        this.getView().showForm(parameter);
    }

    private void delData() {
        IListView listView = (IListView)this.getView();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection collection = listView.getSelectedRows();
        if (collection.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"MultColSchemeListPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        HashSet<Long> removeIds = new HashSet<Long>();
        for (ListSelectedRow viewRow : collection) {
            Long id = (Long)viewRow.getPrimaryKeyValue();
            removeIds.add(id);
        }
        MainEntityType schemeType = EntityMetadataCache.getDataEntityType((String)"gl_multcol_scheme");
        DeleteServiceHelper.delete((IDataEntityType)schemeType, (Object[])removeIds.toArray(new Long[0]));
        listView.refresh();
        list.clearSelection();
    }
}

